<?php

/*
	ADMIN GLOBAL MEMBER API CLASS
	Created On : 
*/

//other include files
require_once("../global/GlobalQueryBuilder.php");
require_once("../member/MemberUtility.php");
require_once("../utility/ArrayUtility.php");
require_once("../utility/StringUtility.php");
require_once("../auth/UserUtility.php");
require_once("../utility/JwtUtility.php");
require_once("../utility/ResponseUtility.php");
require_once("../TimeZone.php");
require_once("../fax/FaxApiClass.php");

class AdminGlobalMembers
{
    //tab id
    const MEMBERS_LIST = 1;
    const UNASSIGNED = 2;
    const SCHEDULED = 3;
    const IN_PROGRESS = 4;
    const QA = 5;
    const CODING = 6;
    const CLINICIAN_REVIEW = 7;
    const READY_FOR_UPLOAD = 8;
    const COMPLETED = 9;
    const CANCELLED_NO_SHOW = 10;
    const TERMED_EXPIRED = 11;
    const UNASSIGNED_QA = 12;
    const  UNASSIGNED_CODING = 13;

    /*
        NAME    : getAdminRequiredColumnAsString
        TYPE    : internal Utiltiy function
        DETAILS :
        RETURN  :
    */
    public function getQUery($tab_id, $plan_id, $year)
    {

        //database connection
        include("../db.php");
        $getClientsids = "SELECT clientId FROM HRA_client where plan= '" . $plan_id . "' and year like  '%" . $year . "%'";

        $getClientsidsresult = mysqli_query($conn, $getClientsids);
        $sql_global_member_query = array();
        while ($getClientsidsresp = mysqli_fetch_array($getClientsidsresult, MYSQLI_ASSOC)) {
            $client_id = $getClientsidsresp['clientId'];
            $substatus_column = "";
            if ($tab_id == 5 || $tab_id == 6 || $tab_id == 7) {
                // $substatus_column = ",".$this->queryReviewCountCustomColumnTabCondition($tab_id);
                $substatus_column = "," . $this->queryReviewCountCustomColumnTabCondition($tab_id) . "," . GlobalQueryBuilder::sqlCustomColumnReportStatus('reportStatus');
            }
            $hradays_column = "";
            /*if($tab_id != 1 && $tab_id != 2 && $tab_id != 3){
                $hradays_column=",".$this->hraDaysCustomColumnTabContion($tab_id);
            }*/


            $hradays_column = ", " . GlobalQueryBuilder::sqlCustomColumnHraDays();
            $overrideScheduleDate_column = GlobalQueryBuilder::sqlCustomColumnOverridedScheduledDate();
            //$combine_member_query[] = "select member_id,firstname,lastname,nurse_id,scheduler_id,qa_id,coder_id,memberinfo,hraStatus,admin_idno,hraFileUpdatedHistory,termDate,scheduler,query_form,scheduleDate,EvaluationDate,schedulerCallLogDetails,schedulerCallHraStatus,VisitType,JSON_UNQUOTE(JSON_EXTRACT(pcp_fax_response, '$.status')) as faxstatus,clientid,year $substatus_column $hradays_column ,$overrideScheduleDate_column from HRA_member_" . $client_id . '_' . $year;

            $combine_member_query[] = "select member_id,firstname,lastname,nurse_id,scheduler_id,qa_id,coder_id,memberinfo,hraStatus,admin_idno,hraFileUpdatedHistory,termDate,scheduler,query_form,scheduleDate,EvaluationDate,schedulerCallLogDetails,schedulerCallHraStatus,VisitType,pcp_fax_response as faxstatus,clientid,year $substatus_column $hradays_column ,$overrideScheduleDate_column from HRA_member_" . $client_id . '_' . $year;
        }

        return $combine_member_query;

    }

    public function getFinalResponse($memberrecordscount, $tab_id)
    {
        //$reccount =  mysqli_fetch_array($memberrecordscount,MYSQLI_ASSOC);
        //$count = $reccount['totalRows'];

        $all_data = [];
        while ($member_row = mysqli_fetch_array($memberrecordscount, MYSQLI_ASSOC)) {
            $count = $member_row['totalRows'];
            $member_id = $member_row['member_id'];
            $memberinfo = $member_row['memberinfo'];
            $faxstatus = $member_row['faxstatus'];
            //$demographic = $member_row['Demographic'];
            //$override_scheduled_date = $member_row['overrideScheduledDate'];
            $scheduled_date = $member_row['scheduleDate'];
            $term_date = $member_row['termDate'];
            $evaluation_date = $member_row['EvaluationDate'];
            $hra_status = $member_row['hraStatus'];
            $visit_type = $member_row['VisitType'];

            $admin_id = $member_row['admin_idno'];
            $nurse_id = $member_row['nurse_id'];
            $qa_id = $member_row['qa_id'];
            $coder_id = $member_row['coder_id'];
            $scheduler_id = $member_row['scheduler_id'];

            $client_id = $member_row['clientid'];
            $client_year = $member_row['year'];

            $query_form = $member_row['query_form'];

            $FaxResponseData = $faxstatus != null && $faxstatus[0] != "[" ? "[".$faxstatus."]" : $faxstatus;
            $FaxResponseStatus = sizeof(json_decode($FaxResponseData)) != 0 ? (json_decode($FaxResponseData)[sizeof(json_decode($FaxResponseData))-1]->status != null ? json_decode($FaxResponseData)[sizeof(json_decode($FaxResponseData))-1]->status : 0) : 0;

            if (isset($member_row['query_form_review_count'])) {
                $sub_status = GlobalHelper::queryReviewCountToReadableFormat($member_row['query_form_review_count']);
            } else {
                $sub_status = $query_form_review_status = GlobalHelper::queryReviewCountToReadableFormat(null);
            }
            $hra_days = isset($member_row["hra_days"]) ? $member_row["hra_days"] : '';
            $all_data[] = array(
                "memberId" => $member_id,
                "faxstatus"=>$faxstatus,
                "nurseId" => $nurse_id,
                "adminId" => $admin_id,
                "schedulerId" => $scheduler_id,
                "qaId" => $qa_id,
                "coderId" => $coder_id,
                "memberinfo" => $memberinfo,
                "scheduleDate" => $scheduled_date,
                "termDate" => $term_date,
                "evaluationDate" => $evaluation_date,
                "hraStatus" => $hra_status,
                "visitType" => $visit_type,
                "clientId" => $client_id,
                "clientYear" => $client_year,
                "queryForm" => $query_form,
                "queryReviewStatus" => $sub_status,
                "hraDays" => $hra_days,
                "overrideScheduleDate" => $member_row["overrideScheduledDate"],
                "faxResponseStatus" => $FaxResponseStatus
            );
        }

        $faxapiclass = new FaxApiClass;
        $faxapiclass = $faxapiclass->getFaxStatus();

        $response = new stdClass();
        $response->status = 1;
        $response->members = $all_data;
        $response->totalRows = $count;
        $response->faxEnable = $faxapiclass;

        return $response;
    }

    public function getAdminRequiredColumnAsString($tab_id = 'None')
    {

        $required_column_array[] = "member_id,FirstName,lastname,nurse_id,scheduler_id,qa_id,coder_id,
                                memberinfo,hraStatus,admin_idno,hraFileUpdatedHistory,termDate,scheduler,query_form,
                                scheduleDate,EvaluationDate,schedulerCallLogDetails,schedulerCallHraStatus,VisitType";
        //custom member info field for sorting
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('Plan', 'memberPlan');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('Program', 'memberProgram');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('LOB', 'memberLob');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_City', 'memberCity');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Zip_Code', 'memberZip');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_first_name', 'memberFirstName');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_visit_type', 'membervisittype');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_scheduler_name', 'memberschedulername');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Term_Date', 'memberTermDate');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_qa_name', 'memberQaName');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Coder_name', 'memberCoderName');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_hra_days', 'memberhradays');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_schedule_Date', 'memberscheduleDate');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Evaluation_Date', 'memberEvaluationDate');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_sub_status', 'membersubstatus');

        $required_column_array[] = GlobalQueryBuilder::sqlCustomColumnDemographic();
        $required_column_array[] = GlobalQueryBuilder::sqlCustomColumnOverridedScheduledDate();
        $required_column_array[] = GlobalQueryBuilder::sqlCustomColumnOverridedShortScheduledDate();
        $required_column_array[] = GlobalQueryBuilder::sqlCustomColumnScreeningEligibility();
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnSimpleJsonExtract('reportStatus','text','reportStatus');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomColumnReportStatus('reportStatus');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomColumnReportStatusbychar('hrastatusbychar');
        $required_column_array[] = $this->hraDaysCustomColumnTabContion($tab_id);
        $query_form_review = $this->queryReviewCountCustomColumnTabCondition($tab_id);
        if ($query_form_review) {
            $required_column_array[] = $query_form_review;
        }

        return ArrayUtility::joinArrayByDelimiter($required_column_array, ',');
    }


    /*
        NAME    : getNurseRequiredColumnAsString
        TYPE    : internal Utiltiy function
        DETAILS :
        RETURN  :
    */
    public function convertToDefaultMemberSqlQuery($member_table_sql_query)
    {
        if ($member_table_sql_query === FALSE) return FALSE;//not valid query string

        $scheduler_member_sql_query = "SELECT (COUNT(*) OVER()) as totalRows, member_table.*,
            client_table.client_name as client_name,
            admin_table.userUniqueno as admin_id,
            CONCAT(scheduler_table.firstname ,' ',scheduler_table.lastname) as scheduler_fullname,
            CONCAT(nurse_table.firstname ,' ', nurse_table.lastname) as nurse_fullname,
            CONCAT(admin_table.firstname ,' ', admin_table.lastname) as admin_fullname, 
            CONCAT(qa_table.firstname ,' ', qa_table.lastname) as qa_fullname,
            CONCAT(coder_table.firstname ,' ', coder_table.lastname) as coder_fullname,
            
            member_global_status.return_mail as returnMail
            FROM 
				( $member_table_sql_query ) as member_table 
				LEFT JOIN userLogin as scheduler_table ON scheduler_table.userUniqueno = member_table.scheduler_id 
				LEFT JOIN userLogin as nurse_table ON nurse_table.userUniqueno = member_table.nurse_id 
                LEFT JOIN userLogin as qa_table ON qa_table.userUniqueno = member_table.qa_id 
                LEFT JOIN userLogin as coder_table ON coder_table.userUniqueno = member_table.coder_id 
				LEFT JOIN HRA_client as client_table ON client_table.clientId = member_table.client_id 
				LEFT JOIN userLogin as admin_table ON admin_table.userUniqueno = member_table.admin_idno
                LEFT JOIN hra_member_global_status AS member_global_status ON member_global_status.member_id = member_table.member_id";

        return $scheduler_member_sql_query;
    }

    /*
        NAME    : getMemberRequiredFieldAsArray
        TYPE    : interanl Utiltiy function
        DETAILS : used to generate requied response field from uery result
        RETURN  :
    */
    private function getMemberRequiredFieldAsArray($member_row)
    {
        $member_id = $member_row['member_id'];
        $memberinfo = $member_row['memberinfo'];
        $demographic = $member_row['Demographic'];

        $override_scheduled_date = $member_row['overrideScheduledDate'];
        $scheduled_date = $member_row['scheduleDate'];
        $term_date = $member_row['termDate'];
        $evaluation_date = $member_row['EvaluationDate'];
        ///$FirstName = $member_row['FirstName'];
        $hra_status = $member_row['hraStatus'];
        $hrastatusbychar = $member_row['hrastatusbychar'];
        $scheduler_status = $member_row['reportStatus'];
        $visit_type = $member_row['VisitType'];

        $admin_id = $member_row['admin_id'];
        $nurse_id = $member_row['nurse_id'];
        $qa_id = $member_row['qa_id'];
        $coder_id = $member_row['coder_id'];
        $scheduler_id = $member_row['scheduler_id'];

        $nurse_name = StringUtility::toEmptyStringIfNull($member_row['nurse_fullname']);
        $scheduler_name = StringUtility::toEmptyStringIfNull($member_row['scheduler_fullname']);
        $admin_name = StringUtility::toEmptyStringIfNull($member_row['admin_fullname']);
        $qa_fullname = StringUtility::toEmptyStringIfNull($member_row['qa_fullname']);
        $coder_fullname = StringUtility::toEmptyStringIfNull($member_row['coder_fullname']);


        $client_id = $member_row['client_id'];
        $client_name = $member_row['client_name'];
        $client_year = $member_row['client_year'];

        $query_form = $member_row['query_form'];
        //conver the query review count to ordinal suffix if number
        if (isset($member_row['query_form_review_count'])) {
            $query_form_review_status = GlobalHelper::queryReviewCountToReadableFormat($member_row['query_form_review_count']);
        } else {
            $query_form_review_status = $query_form_review_status = GlobalHelper::queryReviewCountToReadableFormat(null);
        }

        $hra_days = StringUtility::toEmptyStringIfNull($member_row['hra_days']);

        $response_array = array(
            "memberId" => $member_id,
            "nurseId" => $nurse_id,
            "adminId" => $admin_id,
            "schedulerId" => $scheduler_id,
            "qaId" => $qa_id,
            "coderId" => $coder_id,
            /// "FirstName"=>$FirstName,

            "nurseName" => $nurse_name,
            "schedulerName" => $scheduler_name,
            "qaName" => $qa_fullname,
            "coderName" => $coder_fullname,
            "adminName" => $admin_name,

            "memberinfo" => $memberinfo,
            "demographic" => $demographic,

            "scheduleDate" => $scheduled_date,
            //some case evalution date consider as scheduled date
            "overrideScheduleDate" => $override_scheduled_date,
            "termDate" => $term_date,
            "evaluationDate" => $evaluation_date,

            "hraStatus" => $hra_status,
            "hrastatusbychar" => $hrastatusbychar,
            "hraDays" => $hra_days,
            "queryReviewStatus" => $query_form_review_status,
            "schedulerStatus" => $scheduler_status,
            "visitType" => $visit_type,

            "clientId" => $client_id,
            "clientName" => $client_name,
            "clientYear" => $client_year,

            "queryForm" => $query_form
        );

        return $response_array;
    }

    /*
       NAME    : queryResultResponse
       TYPE    : global Utiltiy function
       DETAILS :
       RETURN  :
   */
    private function queryResultResponse($member_query_result, $error)
    {
        $total_rows = 0;

        $member_list = [];
        while ($member_row = $member_query_result->fetch_assoc()) {
            $member_list[] = $this->getMemberRequiredFieldAsArray($member_row);
            $total_rows = $member_row['totalRows'];
        }

        $member_response = new stdClass;
        $member_response->status = true;
        $member_response->error = $error;
        $member_response->totalRows = $total_rows;
        $member_response->members = $member_list;

        return $member_response;

    }


    /*
        NAME    : filter
        TYPE    : global Utiltiy function
        DETAILS :
        RETURN  :
    */
    public function filter($filter_parameters, &$error)
    {
        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $filter_parameters['planId'];
        $user_id = $filter_parameters['userId'];
        $year = $filter_parameters['year'];
        $min = $filter_parameters['min'];
        $max = $filter_parameters['max'];
        $lob = urldecode($filter_parameters['lob']);
        $filter_parameters['lob'] = $lob;
        $tab_id = $filter_parameters['tabId'];
        $faxStatus = $filter_parameters['faxStatus'];

        $base_sort_by = $filter_parameters['baseSortBy'];
        $base_sort_order = $filter_parameters['baseSortOrder'] == 0 ? 'ASC' : 'DESC';
        $sort_by = $filter_parameters['sortBy'];
        $sort_order = $filter_parameters['sortOrder'] == 0 ? 'ASC' : 'DESC';

        $start = $min;
        $offset = $max - $min;

        $un_assigned = $parameters['unAssigned'];
        $combine_member_query = $this->getQUery($tab_id, $plan_id, $year);
        if ($combine_member_query && is_array($combine_member_query)) {
            //$whereCondition = $this->tabConditionNew($tab_id);
            $whereCondition = $this->tabConditionNew($tab_id, $un_assigned);

            //$searchCondition = $this -> tabConditionSearch($whereCondition,$tab_id,$isSearchApplied,$memberid,$firstname,$lastname);
            $filterCondition = $this->filterCondition($tab_id, $filter_parameters);
            $orderBy = $this->memberSorting($sort_by, $sort_order);
            $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
            if($faxStatus == "1" || $faxStatus == "3" || (empty($faxStatus) && $faxStatus == "0")) $sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (" . $sql_global_member_query1 . " ) as  member_info  where $whereCondition $filterCondition  $orderBy[0] ";
            else $sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (" . $sql_global_member_query1 . " ) as  member_info  where $whereCondition $filterCondition  $orderBy[0] limit $min,$offset";

        }
    //    echo $sql_global_member_query1;exit;
        $memberrecordscount = mysqli_query($conn, $sql_global_member_query1);

        $final_response = $this->getFinalResponse($memberrecordscount, $tab_id);

        if ($final_response && ($faxStatus == "1" || $faxStatus == "3" || (empty($faxStatus) && $faxStatus == "0"))) {
            $count = 0;
            $sortedArray = [];
            if ($faxStatus == 1) {
                foreach ($final_response->members as $val) {
                    if ($val["faxResponseStatus"] == 1) {
                        array_push($sortedArray, $val);
                        $count++;
                    }
                }
            }elseif ($faxStatus == 3) {
                foreach ($final_response->members as $val) {
                    if ($val["faxResponseStatus"] == 3) {
                        array_push($sortedArray, $val);
                        $count++;
                    }
                }
            } else {
                foreach ($final_response->members as $val) {
                    if ($val["faxResponseStatus"] == 0) {
                        array_push($sortedArray, $val);
                        $count++;
                    }
                }
            }
            $final_response->totalRows = $count;
            $output = array_slice($sortedArray, $min, $offset);
            $final_response->members = $output;
        }

        echo json_encode($final_response);
        return TRUE;
    }

    public function filter_old($filter_parameters, &$error)
    {
        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $filter_parameters['planId'];
        $user_id = $filter_parameters['userId'];
        $year = $filter_parameters['year'];
        $min = $filter_parameters['min'];
        $max = $filter_parameters['max'];
        $lob = base64_decode(urldecode($filter_parameters['lob']));
        $filter_parameters['lob'] = $lob;

        $tab_id = $filter_parameters['tabId'];

        $base_sort_by = $filter_parameters['baseSortBy'];
        $base_sort_order = $filter_parameters['baseSortOrder'] == 0 ? 'ASC' : 'DESC';
        $sort_by = $filter_parameters['sortBy'];
        $sort_order = $filter_parameters['sortOrder'] == 0 ? 'ASC' : 'DESC';

        $start = $min;
        $offset = $max - $min;

        $sql_global_member_query = array();
        if (array_key_exists('planId', $filter_parameters)) {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                $this->convertToDefaultMemberSqlQuery(
                    GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id, $user_id, $year,
                        $this->getAdminRequiredColumnAsString($tab_id))
                ));
        } else {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                $this->convertToDefaultMemberSqlQuery(
                    GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id, $year,
                        $this->getAdminRequiredColumnAsString($tab_id))
                ));
        }

        //if invalid user details sent
        if (count($sql_global_member_query) == 0) return FALSE;

        //where clause array and condition
        $where_clause_contiditions = array();

        //tab condition - hra status
        $tab_hra_list = $this->tabCondition($tab_id);
        if ($tab_hra_list && empty($filter_parameters['hraStatus'])) {
            if ($tab_hra_list !== TRUE) {
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseHraStatusIn($tab_hra_list));
            } else {
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseHraStatusIn($filter_parameters));
            }
        } else {
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseHraStatusIn($filter_parameters));
        }

        //tab condition - unassigned
        switch ($tab_id) {
            case self::UNASSIGNED :
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseForMemberUnAssign($parameters, UserRoleConstant::SCHEDULER));
                break;

            case self::QA:
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseForMemberUnAssign($filter_parameters, UserRoleConstant::QA));
                break;

            case self::CODING:
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseForMemberUnAssign($filter_parameters, UserRoleConstant::CODER));
                break;
        }

        //filter conditions
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseCustomColumnValueIn('client_id', $filter_parameters, 'clientId', true, '|', ','));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseUserIdIn('nurse', $filter_parameters));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseUserIdIn('scheduler', $filter_parameters));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseUserIdIn('qa', $filter_parameters));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseUserIdIn('coder', $filter_parameters));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClausesubStatusIn('subStatus', $filter_parameters));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseScheduleDateBetween($filter_parameters));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseCustomColumnValueIn('VisitType', $filter_parameters, 'visitType', true));
        //$where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($filter_parameters));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseCustomColumnValueIn('reportStatus', $filter_parameters, 'status', true));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseByScreeningEligibility('screening', $filter_parameters));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo', $filter_parameters, 'city', 'Member_City', true));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo', $filter_parameters, 'lob', 'LOB', true));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo', $filter_parameters, 'plan', 'Plan', true));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo', $filter_parameters, 'program', 'Program', true));


        if (count($where_clause_contiditions) == 0) {
            $error = "no valid filter option selected";
            return FALSE;
        }

        //if any valid where clause found append 'where'
        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, (count($where_clause_contiditions) > 0 ? ' WHERE ' : ''));
        //if multiple where clause add 'and' else 'or' condition
        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, ArrayUtility::joinArrayByDelimiter($where_clause_contiditions, ' AND '));
        //order query string
        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, GlobalQueryBuilder::orderBy(UserRoleConstant::NURSE, $base_sort_by, $sort_by, $base_sort_order, $sort_order));
        //limit string
        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, " LIMIT ?,? ");
        //generated query
        $generated_query = implode($sql_global_member_query);
        // echo $generated_query;exit();

        //prepare the member query
        if ($conn->connect_errno) {
            $error = "datatbase connection failed";
        }
        //prepare the member query
        $member_query = $conn->prepare($generated_query);
        if ($member_query === FALSE) {
            $error = "error preparing sql query";
            return FALSE;
        }
        //bind parameters
        $member_query->bind_param('ii', $start, $offset);

        if ($member_query === FALSE) {
            $error = "parameter error";
            return FALSE;
        }

        $member_query->execute();

        if ($member_query === FALSE) {
            $error = "error in sql query";
            return FALSE;
        }

        $member_query_result = $member_query->get_result();
        ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result, $conn->error));

        return TRUE;
    }


    /*
        NAME    : search
        TYPE    : global Utiltiy function
        DETAILS :
        RETURN  :
    */
    public function search($search_parameters, &$error)
    {
        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $search_parameters['planId'];
        $user_id = $search_parameters['userId'];
        $year = $search_parameters['year'];
        $min = $search_parameters['min'];
        $max = $search_parameters['max'];

        $tab_id = $search_parameters['tabId'];
        $base_sort_by = $search_parameters['baseSortBy'];
        $base_sort_order = $search_parameters['baseSortOrder'] == 0 ? 'ASC' : 'DESC';
        $sort_by = $search_parameters['sortBy'];
        $sort_order = $search_parameters['sortOrder'] == 0 ? 'ASC' : 'DESC';

        //$isSearchApplied = $search_parameters['isSearchApplied'];
        $memberid = $search_parameters['id'];
        $firstname = $search_parameters['firstname'];
        $lastname = $search_parameters['lastname'];

        $un_assigned = $search_parameters['unAssigned'];

        $start = $min;
        $offset = $max - $min;

        $combine_member_query = $this->getQuery($tab_id, $plan_id, $year);

        if ($combine_member_query && is_array($combine_member_query)) {

            //$whereCondition = $this->tabConditionNew($tab_id);
            $whereCondition = $this->tabConditionNew($tab_id);

            $searchCondition = $this->tabConditionSearch($whereCondition, $tab_id, $memberid, $firstname, $lastname);

            $filterCondition = $this->filterCondition($tab_id, $search_parameters);

            $orderBy = $this->memberSorting($sort_by, $sort_order);

            $where_clause_contiditions = array();
            //search params by Kasarla Mahesh
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClausesubStatusIn('subStatus', $search_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseCustomColumnValueIn('VisitType', $search_parameters, 'visitType', true));
            //            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseScreeningStatus($search_parameters));
            $global_member_query = "";
            //if multiple where clause add 'and' else 'or' condition
            if (count($where_clause_contiditions) > 0) {
                $global_member_query = "AND " . ArrayUtility::joinArrayByDelimiter($where_clause_contiditions, ' AND ');
                $global_member_query = str_replace("member_table", "member_info", $global_member_query);
            }
            $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
            $sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (" . $sql_global_member_query1 . " ) as  member_info $orderBy[1] where $searchCondition $filterCondition $global_member_query $orderBy[0] limit $min,$offset";
        }
        //echo $sql_global_member_query1;exit;
        $memberrecordscount = mysqli_query($conn, $sql_global_member_query1);

        $final_response = $this->getFinalResponse($memberrecordscount, $tab_id);
        echo json_encode($final_response);
        return TRUE;

    }

    public function search_old($search_parameters, &$error)
    {
        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $search_parameters['planId'];
        $user_id = $search_parameters['userId'];
        $year = $search_parameters['year'];
        $min = $search_parameters['min'];
        $max = $search_parameters['max'];

        $tab_id = $search_parameters['tabId'];

        $base_sort_by = $search_parameters['baseSortBy'];
        $base_sort_order = $search_parameters['baseSortOrder'] == 0 ? 'ASC' : 'DESC';
        $sort_by = $search_parameters['sortBy'];
        $sort_order = $search_parameters['sortOrder'] == 0 ? 'ASC' : 'DESC';

        $start = $min;
        $offset = $max - $min;

        $sql_global_member_query = array();
        if (array_key_exists('planId', $search_parameters)) {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                $this->convertToDefaultMemberSqlQuery(
                    GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id, $user_id, $year,
                        $this->getAdminRequiredColumnAsString($tab_id)))
            );
        } else {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                $this->convertToDefaultMemberSqlQuery(
                    GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id, $year,
                        $this->getAdminRequiredColumnAsString($tab_id)))
            );
        }
        //if invalid user details sent
        if (count($sql_global_member_query) == 0) return FALSE;
        //where clause array and condition
        $where_clause_contiditions = array();

        $tab_hra_list = $this->tabCondition($tab_id);
        if ($tab_hra_list) {
            // if($tab_hra_list ===TRUE ) { $tab_hra_list=null;}
            //$where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($tab_hra_list));

            if ($tab_hra_list == 1 || $tab_hra_list === TRUE) {

                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseMemberListHraStatusIn($tab_hra_list));

            } else {
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseHraStatusIn($tab_hra_list));
            }

            //tab based unassigned conditions
            //    print_r($where_clause_contiditions);die;
            // echo $tab_id;die;
            switch ($tab_id) {
                case self::UNASSIGNED :

                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseForMemberUnAssign($search_parameters, UserRoleConstant::SCHEDULER));
                    break;

                case self::QA:

                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseForMemberUnAssign($search_parameters, UserRoleConstant::QA));
                    break;

                case self::CODING:

                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseForMemberUnAssign($search_parameters, UserRoleConstant::CODER));
                    break;
            }

        } else {
            $error = "no valid tab id sent";
            return FALSE;
        }

        //search where clause condition
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByColumnLike('firstname', $search_parameters, 'firstname'));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByColumnLike('lastname', $search_parameters, 'lastname'));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByMemberId($search_parameters, 'id'));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByMemberInfoField('Plan', $search_parameters, 'plan'));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByMemberInfoField('Program', $search_parameters, 'program'));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByMemberInfoField('LOB', $search_parameters, 'lob'));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByMemberInfoField('Member_City', $search_parameters, 'city'));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByMemberInfoField('Member_Zip_Code', $search_parameters, 'zip'));


        if (count($where_clause_contiditions) == 0) {
            $error = "invalid search value";
            return FALSE;
        }

        //if any valid where clause found append 'where'
        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, (count($where_clause_contiditions) > 0 ? ' WHERE ' : ''));
        //if multiple where clause add 'and' else 'or' condition
        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, ArrayUtility::joinArrayByDelimiter($where_clause_contiditions, ' AND '));

        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, GlobalQueryBuilder::orderBy(UserRoleConstant::NURSE, $base_sort_by, $sort_by, $base_sort_order, $sort_order));

        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, " LIMIT ?,? ");

        $generated_query = implode($sql_global_member_query);
        // echo $generated_query;die;
        if ($conn->connect_errno) {
            $error = "database connection failed";
        }

        //prepare the member query
        $member_query = $conn->prepare($generated_query);
        if ($member_query === FALSE) {
            $error = "error preparing sql query";
            return FALSE;
        }
        //bind parameters
        $member_query->bind_param('ii', $start, $offset);

        if ($member_query === FALSE) {
            $error = "parameter error";
            return FALSE;
        }

        $member_query->execute();

        if ($member_query === FALSE) {
            $error = "error in sql query";
            return FALSE;
        }

        $member_query_result = $member_query->get_result();
        ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result, $error));

        return TRUE;

    }


    /*
        NAME    : getMembers
        TYPE    : global Utiltiy function
        DETAILS : get the member details based on tab id
        RETURN  : member details
    */
    public function getMembers($parameters, &$error)
    {
        
        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $parameters['planId'];
        $user_id = $parameters['userId'];
        $year = $parameters['year'];
        $min = $parameters['min'];
        $max = $parameters['max'];

        $tab_id = $parameters['tabId'];
        $un_assigned = $parameters['unAssigned'];

        $base_sort_by = $parameters['baseSortBy'];
        $base_sort_order = $parameters['baseSortOrder'] == 0 ? 'ASC' : 'DESC';
        $sort_by = $parameters['sortBy'];
        $sort_order = $parameters['sortOrder'] == 0 ? 'ASC' : 'DESC';

        $isSearchApplied = $parameters['isSearchApplied'] ;
        $memberid = $parameters['id'];
        $firstname = $parameters['firstname'];
        $lastname = $parameters['lastname'];
        
        $start = $min;
        $offset = $max - $min;
        $user_clients = DataBaseUtility::getUserClientPrivilegeByPlan($plan_id, $user_id);

        //$required_column="member_id,trim(firstname) as firstname,lastname,nurse_id,scheduler_id,qa_id,coder_id,memberinfo,hraStatus,admin_idno,hraFileUpdatedHistory,termDate,scheduler,query_form,scheduleDate,EvaluationDate,schedulerCallLogDetails,schedulerCallHraStatus,VisitType,clientid,year";

        $combine_member_query = $this->getQUery($tab_id, $plan_id, $year);

        if ($combine_member_query && is_array($combine_member_query)) {

            $whereCondition = $this->tabConditionNew($tab_id);
            if($parameters['screeningIha'] != '' ) $whereCondition = $whereCondition."". GlobalQueryBuilder::screeningIha($parameters['screeningIha']);
            $orderBy = $this->memberSorting($sort_by, $sort_order);

            if($isSearchApplied == true || $isSearchApplied == "true" || $isSearchApplied){
                $searchCondition = " AND ". $this->tabConditionSearch($whereCondition, $tab_id, $memberid, $firstname, $lastname);
            }else{
                $searchCondition = "";
            }
            
            $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
            $sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (" . $sql_global_member_query1 . " ) as  member_info $orderBy[1] where $whereCondition $searchCondition $orderBy[0] limit $min,$offset";

        }


        //echo $sql_global_member_query1;exit;
        $memberrecordscount = mysqli_query($conn, $sql_global_member_query1);

        // $reccount =  mysqli_fetch_array($memberrecordscount,MYSQLI_ASSOC);
        // $count = $reccount['totalRows'];

        $response = $this->getFinalResponse($memberrecordscount, $tab_id);
        echo json_encode($response);
        return true;
    }

    public function getMembers1($parameters, &$error)
    {
        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $parameters['planId'];
        $user_id = $parameters['userId'];
        $year = $parameters['year'];
        $min = $parameters['min'];
        $max = $parameters['max'];

        $tab_id = $parameters['tabId'];
        $un_assigned = $parameters['unAssigned'];

        $base_sort_by = $parameters['baseSortBy'];
        $base_sort_order = $parameters['baseSortOrder'] == 0 ? 'ASC' : 'DESC';
        $sort_by = $parameters['sortBy'];
        $sort_order = $parameters['sortOrder'] == 0 ? 'ASC' : 'DESC';

        $start = $min;
        $offset = $max - $min;
        $user_clients = DataBaseUtility::getUserClientPrivilegeByPlan($plan_id, $user_id);

        //$required_column="member_id,trim(firstname) as firstname,lastname,nurse_id,scheduler_id,qa_id,coder_id,memberinfo,hraStatus,admin_idno,hraFileUpdatedHistory,termDate,scheduler,query_form,scheduleDate,EvaluationDate,schedulerCallLogDetails,schedulerCallHraStatus,VisitType,clientid,year";

        $getClientsids = "SELECT clientId FROM HRA_client where plan= '" . $plan_id . "' and year like  '%" . $year . "%'";

        $getClientsidsresult = mysqli_query($conn, $getClientsids);
        $sql_global_member_query = array();
        while ($getClientsidsresp = mysqli_fetch_array($getClientsidsresult, MYSQLI_ASSOC)) {
            $client_id = $getClientsidsresp['clientId'];
            $substatus_column = "";
            if ($tab_id == 5 || $tab_id == 6 || $tab_id == 7) {
                $substatus_column = "," . $this->queryReviewCountCustomColumnTabCondition($tab_id);
            }
            $hradays_column = "";
            if ($tab_id != 1 && $tab_id != 2 && $tab_id != 3) {
                $hradays_column = "," . $this->hraDaysCustomColumnTabContion($tab_id);
            }
            //$hradays_column=$this->hraDaysCustomColumnTabContion($tab_id);

            $overrideScheduleDate_column = GlobalQueryBuilder::sqlCustomColumnOverridedScheduledDate();
            $combine_member_query[] = "select member_id,firstname,lastname,nurse_id,scheduler_id,qa_id,coder_id,memberinfo,hraStatus,admin_idno,hraFileUpdatedHistory,termDate,scheduler,query_form,scheduleDate,EvaluationDate,schedulerCallLogDetails,schedulerCallHraStatus,VisitType,clientid,year $substatus_column $hradays_column ,$overrideScheduleDate_column from HRA_member_" . $client_id . '_' . $year;
        }

        // if($combine_member_query && is_array($combine_member_query))
        // {
        // $whereCondition = $this->tabConditionNew($tab_id);
        // $orderBy =$this->memberSorting($sort_by,$sort_order);

        // $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
        // $sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (". $sql_global_member_query1 . " ) as  member_info $orderBy[1] where $whereCondition $orderBy[0] limit $min,$offset";
        // }

        if ($combine_member_query && is_array($combine_member_query)) {

            $whereCondition = $this->tabConditionNew($tab_id);
            $orderBy = $this->memberSorting($sort_by, $sort_order);

            $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
            $sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (" . $sql_global_member_query1 . " ) as  member_info $orderBy[1] where $whereCondition $orderBy[0] limit $min,$offset";

        }


        //echo $sql_global_member_query1;exit;
        $memberrecordscount = mysqli_query($conn, $sql_global_member_query1);

        // $reccount =  mysqli_fetch_array($memberrecordscount,MYSQLI_ASSOC);
        // $count = $reccount['totalRows'];

        $all_data = [];
        while ($member_row = mysqli_fetch_array($memberrecordscount, MYSQLI_ASSOC)) {
            $count = $member_row['totalRows'];
            $member_id = $member_row['member_id'];
            $memberinfo = $member_row['memberinfo'];
            //$demographic = $member_row['Demographic'];
            //$override_scheduled_date = $member_row['overrideScheduledDate'];
            $scheduled_date = $member_row['scheduleDate'];
            $term_date = $member_row['termDate'];
            $evaluation_date = $member_row['EvaluationDate'];
            $hra_status = $member_row['hraStatus'];
            $visit_type = $member_row['VisitType'];

            $admin_id = $member_row['admin_idno'];
            $nurse_id = $member_row['nurse_id'];
            $qa_id = $member_row['qa_id'];
            $coder_id = $member_row['coder_id'];
            $scheduler_id = $member_row['scheduler_id'];

            $client_id = $member_row['clientid'];
            $client_year = $member_row['year'];

            $query_form = $member_row['query_form'];


            if (isset($member_row['query_form_review_count'])) {
                $sub_status = GlobalHelper::queryReviewCountToReadableFormat($member_row['query_form_review_count']);
            } else {
                $sub_status = $query_form_review_status = GlobalHelper::queryReviewCountToReadableFormat(null);
            }
            $hra_days = isset($member_row["hra_days"]) ? $member_row["hra_days"] : '';
            $all_data[] = array(
                "memberId" => $member_id,
                "nurseId" => $nurse_id,
                "adminId" => $admin_id,
                "schedulerId" => $scheduler_id,
                "qaId" => $qa_id,
                "coderId" => $coder_id,
                "memberinfo" => $memberinfo,
                "scheduleDate" => $scheduled_date,
                "termDate" => $term_date,
                "evaluationDate" => $evaluation_date,
                "hraStatus" => $hra_status,
                "visitType" => $visit_type,
                "clientId" => $client_id,
                "clientYear" => $client_year,
                "queryForm" => $query_form,
                "queryReviewStatus" => $sub_status,
                "hraDays" => $hra_days,
                "overrideScheduleDate" => $member_row["overrideScheduledDate"]
            );
        }

        $response = new stdClass();
        $response->status = 1;
        $response->members = $all_data;
        $response->totalRows = $count;
        echo json_encode($response);
        /*$totalCount = "select *from HRA_member_client_001_2021";
        $results=mysqli_query($conn,$totalCount);
        $count = mysqli_num_rows($results);*/


        /* $sql_global_member_query = array();

         if(array_key_exists('planId',$parameters))
         {
             $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                         $this->convertToDefaultMemberSqlQuery(
                                         GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
                                         $this->getAdminRequiredColumnAsString($tab_id)))
                                     );
         }
         else
         {
             $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                         $this->convertToDefaultMemberSqlQuery(
                                         GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
                                         $this->getAdminRequiredColumnAsString($tab_id)))
                                     );
         }

         //when invalid userid sent
         if(count($sql_global_member_query)==0) return FALSE;


             //where clause array and condition
             $where_clause_contiditions = array();

             //identify the tab and its condition
             $tab_hra_list = $this->tabCondition($tab_id);
             if($tab_hra_list)
             {
                 if($tab_hra_list ===TRUE ) { $tab_hra_list=null;}
                 $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($tab_hra_list));
                 //tab based unassigned conditions
                 switch($tab_id)
                 {
                     case self::UNASSIGNED :
                         $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseForMemberUnAssign($parameters,UserRoleConstant::SCHEDULER));
                     break;

                     case self::QA:
                         $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseForMemberUnAssign($parameters,UserRoleConstant::QA));
                     break;

                     case self::CODING:
                         $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseForMemberUnAssign($parameters,UserRoleConstant::CODER));
                     break;
                 }
             }
             else
             {
                 $error="no valid tab id sent";
                 return FALSE;
             }

             //if any valid where clause found append 'where'
             $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
             //if multiple where clause add 'and' else 'or' condition
             $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));
             //sort by query string
             $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy(UserRoleConstant::ADMIN,$base_sort_by,$sort_by,$base_sort_order,$sort_order));
             //limit by range
             $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT ?,? ");

             //genarated query
             $generated_query = implode($sql_global_member_query);

            // echo $generated_query;exit();
                 if($conn->connect_errno)
                 {
                     $error="database connection failed";
                 }

                 //prepare the member query
                 $member_query=$conn->prepare($generated_query);
                 if($member_query===FALSE)
                 {
                     $error = "error preparing sql query";
                     return FALSE;
                 }
                 //bind parameters
                 $member_query->bind_param('ii',$start,$offset);

                 if($member_query === FALSE)
                 {
                     $error="parameter error";
                     return FALSE;
                 }

                 $member_query->execute();

                 if($member_query === FALSE)
                 {
                     $error="error in sql query";
                     return FALSE;
                 }

             $member_query_result = $member_query->get_result();

             ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$error));*/

        return TRUE;

    }

    private function tabCondition($tab_id)
    {
        $tab_hra_list = FALSE;
        //tab hra status condition
        switch ($tab_id) {
            case self::MEMBERS_LIST: //member list
                //all status
                return TRUE;
                break;

            case self::UNASSIGNED: //un assigned
                $tab_hra_list['hraStatus'] = ArrayUtility::convertArrayToString(
                    [
                        MemberUtility::UNSCHEDULED
                    ], '_');
                break;

            case self::SCHEDULED: //scheduled
                $tab_hra_list['hraStatus'] = ArrayUtility::convertArrayToString(
                    [
                        MemberUtility::SCHEDULED
                    ], '_');
                break;

            case self::IN_PROGRESS: //in progress tab
                $tab_hra_list['hraStatus'] = ArrayUtility::convertArrayToString(
                    [
                        MemberUtility::IN_PROGRESS
                    ], '_');
                break;

            case self::QA: //QA tab
                $tab_hra_list['hraStatus'] = ArrayUtility::convertArrayToString(
                    [
                        MemberUtility::READY_FOR_QA
                    ], '_');
                break;

            case self::CODING: //Coding Tab
                $tab_hra_list['hraStatus'] = ArrayUtility::convertArrayToString(
                    [
                        MemberUtility::READY_FOR_CODER
                    ], '_');
                break;

            case self::CLINICIAN_REVIEW: //Clinician Review Tab
                $tab_hra_list['hraStatus'] = ArrayUtility::convertArrayToString(
                    [
                        MemberUtility::CLINICIAN_REVIEW_QA,
                        MemberUtility::CLINICAIN_REVIEW_CODER
                    ], '_');
                break;

            case self::READY_FOR_UPLOAD: //ready for upload Tab
                $tab_hra_list['hraStatus'] = ArrayUtility::convertArrayToString(
                    [
                        MemberUtility::READY_FOR_UPLOAD
                    ], '_');
                break;

            case self::COMPLETED: //Compeleted Tab
                $tab_hra_list['hraStatus'] = ArrayUtility::convertArrayToString(
                    [
                        MemberUtility::COMPLETED
                    ], '_');
                break;

            case self::CANCELLED_NO_SHOW: //Cancelled Tab
                $tab_hra_list['hraStatus'] = ArrayUtility::convertArrayToString(
                    [
                        MemberUtility::NO_SHOW,
                        MemberUtility::APPOINTMENT_CANCELLED,
                        MemberUtility::ASSESSMENT_CANCELLED,
                        MemberUtility::UTC,
                        MemberUtility::HOSPICE,
                        MemberUtility::DECEASED,
                        MemberUtility::IN_ELIGIBILE,
                        MemberUtility::OTHER,
                        MemberUtility::NO_SHOW

                    ], '_');
                break;

            case self::TERMED_EXPIRED: //Term Expired Tab
                $tab_hra_list['hraStatus'] = ArrayUtility::convertArrayToString(
                    [
                        MemberUtility::TERM_EXPIRED
                    ], '_');
                break;

        }

        return $tab_hra_list;
    }

    /*
        NAME    : tabCondition
        TYPE    : internal Utiltiy function
        DETAILS : tab based hra stauts condition
        RETURN  : hra status as string with '_' delimiter
    */


    private function memberSorting($sort_by, $sort_order)
    {
        $sort_text = "";
        $nurse_sort = "";
        switch ($sort_by) {
            case "name" :
                $sort_text = "ORDER BY trim(firstname) " . $sort_order;
                break;
            case "nursename" :
                $sort_text = "ORDER BY (CASE WHEN u.firstname IS NULL THEN 1 ELSE 0 END), u.firstname " . $sort_order;
                $nurse_sort = "LEFT JOIN userLogin u ON u.userUniqueno=member_info.nurse_id";
                break;
            case "visittype" :
//                $sort_text = "ORDER BY (CASE WHEN VisitType IS NULL THEN 1 ELSE 0 END), VisitType " . $sort_order;
                $sort_text = "ORDER BY (CASE WHEN (VisitType IS NULL or VisitType = 'select') THEN 1 ELSE 0 END), VisitType " . $sort_order;
                break;
            case "termdate" :
                $sort_text = "ORDER BY (CASE WHEN (termDate IS NULL or termDate='') THEN 1 ELSE 0 END),termDate " . $sort_order;
                break;
            case "hrastatusbychar" :
                $sort_text = "ORDER BY (CASE
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 20 
        THEN
        'Not Due'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 19 
        THEN
        'NO SHOW'  
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 18 
        THEN
        'TERM EXPIRED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 17 
        THEN
        'OTHER'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 16 
        THEN
        'HOSPICE'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 15 
        THEN
        'DECEASED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 14 
        THEN
        'INELIGIBILE'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 13 
        THEN
        'PRE-SCHEDULED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 12 
        THEN
        'ASSESSMENT CANCEllED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 11 
        THEN
        'COMPLETED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 10 
        THEN
        'READY FOR UPLOAD'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 9 
        THEN
        'CLINICAIN REVIEW CODER'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 8 
        THEN
        'CLINICIAN REVIEW QA'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 7 
        THEN
        'READY FOR CODER'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 6 
        THEN
        'READY FOR QA'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 5 
        THEN
        'UTC'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 4 
        THEN
        'PATIENT REFUSUAL'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 3 
        THEN
        'APPOINTMENT CANCELLED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 2 
        THEN
        'IN PROGRESS'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 1 
        THEN
        'SCHEDULED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 0 
        THEN
        'UNSCHEDULED'    
                   else
        'ZUNSCHEDULED' END
                ) " . $sort_order;
                break;
            case "program" :
                $sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Program')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Program')) = '') THEN 1 ELSE 0 END),LOWER(JSON_UNQUOTE(JSON_extract(memberinfo, '$.Program'))) " . $sort_order;
                break;
            case "lob" :
                $sort_text = " ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB')) = 'null' OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB')) = '') THEN 1 ELSE 0 END),JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB')) " . $sort_order;
                break;
            case "id" :
                $sort_text = " ORDER BY cast(member_id as unsigned) " . $sort_order;
                break;
            case "overridescheduledate" :
                $scheduled_sort_text = " (
                CASE
                    WHEN EvaluationDate IS NOT NULL AND scheduleDate IS NOT NULL THEN STR_TO_DATE(EvaluationDate, '%Y-%m-%d')
                    ELSE STR_TO_DATE(scheduleDate, '%Y-%m-%d')
                END ) ";
                $sort_text = "ORDER BY (CASE WHEN $scheduled_sort_text IS NULL THEN 1 ELSE 0 END ) , $scheduled_sort_text " . $sort_order;
                break;
            case "days" :
                $sort_text = "ORDER BY (CASE WHEN hra_days IS NULL THEN 1 ELSE 0 END), hra_days " . $sort_order;
                break;
            case "queryreview" :
                $sort_text = "ORDER BY (CASE WHEN query_form_review_count IS NULL THEN 1 ELSE 0 END), query_form_review_count " . $sort_order;
                break;
            case "qaname" :
                $sort_text = "ORDER BY (CASE WHEN (u.firstname IS NULL OR u.firstname = '') THEN 1 ELSE 0 END), u.firstname " . $sort_order;
                $nurse_sort = "LEFT JOIN userLogin as u ON u.userUniqueno=member_info.qa_id";
                break;
            case "codername" :
                $sort_text = "ORDER BY (CASE WHEN (u.firstname IS NULL OR u.firstname = '') THEN 1 ELSE 0 END), u.firstname " . $sort_order;
                $nurse_sort = "LEFT JOIN userLogin as u ON u.userUniqueno=coder_id";
                break;
            case "schedulername" :
                $sort_text = "ORDER BY (CASE WHEN (u.firstname IS NULL OR u.firstname = '') THEN 1 ELSE 0 END), u.firstname " . $sort_order;
                $nurse_sort = "LEFT JOIN userLogin as u ON u.userUniqueno=scheduler_id";
                break;
            default:
                break;
        }
        return [$sort_text, $nurse_sort];
    }

    private function oldmemberSorting($sort_by, $sort_order)
    {
        $sort_text = "";
        $nurse_sort = "";
        switch ($sort_by) {
            case "name" :
                $sort_text = "ORDER BY (CASE WHEN firstname IS NULL THEN 1 ELSE 0 END), firstname " . $sort_order;
                break;
            case "nursename" :
                $sort_text = "ORDER BY (CASE WHEN u.firstname IS NULL THEN 1 ELSE 0 END), u.firstname " . $sort_order;
                $nurse_sort = " LEFT JOIN userLogin u ON u.userUniqueno=member_info.nurse_id";
                break;
            case "visittype" :
                $sort_text = "ORDER BY (CASE WHEN VisitType IS NULL THEN 1 ELSE 0 END), VisitType " . $sort_order;
                break;
            case "termdate" :
                $sort_text = "ORDER BY (CASE WHEN (termDate IS NULL or termDate='') THEN 1 ELSE 0 END),termDate " . $sort_order;
                break;
            case "hrastatusbychar" :
                $sort_text = "ORDER BY (CASE WHEN JSON_UNQUOTE(JSON_extract(hraStatus, '$.hraStatus')) IS NULL THEN 1 ELSE 0 END),JSON_UNQUOTE(JSON_extract(hraStatus, '$.hraStatus')) " . $sort_order;
                break;
            case "program" :
                $sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Program')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Program')) = '') THEN 1 ELSE 0 END),JSON_UNQUOTE(JSON_extract(memberinfo, '$.Program')) " . $sort_order;
                break;
            case "lob" :
                //$sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB'))='') THEN 1 ELSE 0 END),JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB')) " . $sort_order;
                $sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB'))='') THEN 1 ELSE 0 END),JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB')) " . $sort_order;
                break;
            case "id" :
                //$sort_text = "ORDER BY (CASE WHEN member_id IS NULL THEN 1 ELSE 0 END), member_id " . $sort_order;
                $sort_text = "ORDER BY cast(member_id as unsigned) " . $sort_order;
                break;
            case "overridescheduledate" :
                $sort_text = "ORDER BY (CASE WHEN (overrideScheduledDate IS NULL OR overrideScheduledDate = '') THEN 1 ELSE 0 END),overrideScheduledDate " . $sort_order;
                break;
            case "days" :
                $sort_text = "ORDER BY (CASE WHEN hra_days IS NULL THEN 1 ELSE 0 END), hra_days " . $sort_order;
                break;
            case "queryreview" :
                $sort_text = "ORDER BY (CASE WHEN query_form_review_count IS NULL THEN 1 ELSE 0 END), query_form_review_count " . $sort_order;
                break;
            case "qaname" :
                $sort_text = "ORDER BY (CASE WHEN qa_table.firstname IS NULL THEN 1 ELSE 0 END),qa_table.firstname " . $sort_order;
                $nurse_sort = "LEFT JOIN userLogin as qa_table ON qa_table.userUniqueno = member_info.qa_id";
                break;
            case "codername" :
                $sort_text = "ORDER BY (CASE WHEN coder_table.firstname IS NULL THEN 1 ELSE 0 END),coder_table.firstname " . $sort_order;
                $nurse_sort = "LEFT JOIN userLogin as coder_table ON coder_table.userUniqueno = member_info.coder_id ";
                break;
            case "schedulername" :
                $sort_text = "ORDER BY (CASE WHEN scheduler_table.firstname IS NULL THEN 1 ELSE 0 END),scheduler_table.firstname  " . $sort_order;
                $nurse_sort = "LEFT JOIN userLogin as scheduler_table ON scheduler_table.userUniqueno = member_info.scheduler_id ";
                break;
            default:
                break;
        }
        return [$sort_text, $nurse_sort];
    }

    /*
        NAME    : tabCondition
        TYPE    : internal Utiltiy function
        DETAILS : tab based hra stauts condition
        RETURN  : hra status as string with '_' delimiter
    */
    private function tabConditionNew($tab_id)
    {

        $whereCondition = "";

        //tab hra status condition
        switch ($tab_id) {

            case self::MEMBERS_LIST: //member list
                $whereCondition = "member_id != 'null'";
                break;

            case self::UNASSIGNED: //un assigned
                $whereCondition = "member_info.hraStatus IS NULL OR JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::UNSCHEDULED;
                break;

            case self::SCHEDULED: //scheduled
                $whereCondition = "JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::SCHEDULED;
                break;

            case self::IN_PROGRESS: //in progress tab
                $whereCondition = "JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::IN_PROGRESS;
                break;

            case self::QA: //QA tab

                $whereCondition = "JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::READY_FOR_QA;


                break;
            case self::CODING: //Coding Tab
                $whereCondition = "JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::READY_FOR_CODER;
                break;

            case self::CLINICIAN_REVIEW: //Clinician Review Tab

                $whereCondition = "(JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::CLINICIAN_REVIEW_QA . " OR JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::CLINICAIN_REVIEW_CODER . ")";
                break;

            case self::READY_FOR_UPLOAD: //ready for upload Tab
                $whereCondition = "JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::READY_FOR_UPLOAD;
                break;

            case self::COMPLETED: //Compeleted Tab
                $whereCondition = "JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::COMPLETED;
                break;

            case self::CANCELLED_NO_SHOW: //Cancelled Tab
//                $whereCondition = "(JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=".MemberUtility::NO_SHOW." OR JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=".MemberUtility::APPOINTMENT_CANCELLED." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::ASSESSMENT_CANCELLED." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::UTC." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::HOSPICE." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::DECEASED." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::IN_ELIGIBILE." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::OTHER." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::NO_SHOW." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::PATIENT_REFUSAL.")";
                $whereCondition = "(JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::NO_SHOW . " OR JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::APPOINTMENT_CANCELLED . ")";

                break;

            case self::TERMED_EXPIRED: //Term Expired Tab
                $whereCondition = "JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::TERM_EXPIRED;
                break;

            case self::UNASSIGNED_QA: //Term Expired Tab
                $whereCondition = "((qa_id IS NULL  or qa_id='') AND JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=" . MemberUtility::READY_FOR_QA . ")";

                // $whereCondition = "(qa_id == 'NULL' AND JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::READY_FOR_QA.")";
                break;
            case self::UNASSIGNED_CODING:
                $whereCondition = "(coder_id IS NULL AND JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=" . MemberUtility::READY_FOR_CODER . ")";

                //Term Expired Tab READY_FOR_CODER
                // $whereCondition = "(coder_id != 'NULL' AND JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::READY_FOR_CODER.")";
                break;
        }

        return $whereCondition;

    }

    private function tabConditionNew_old($tab_id, $un_assigned)
    {

        $whereCondition = "";
        $whereCondition1 = "";
        if ($un_assigned != 0) {
            //echo"hi";
            switch ($tab_id) {
                case self::QA: //QA Tab


                    $whereCondition1 = "((qa_id IS NULL  or qa_id='') AND JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=" . MemberUtility::READY_FOR_QA . ")";


                    break;
                case self::CODING: //CODER Tab

                    $whereCondition1 = "(coder_id IS NULL AND JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=" . MemberUtility::READY_FOR_CODER . ")";

                    break;

            }
            return $whereCondition1;
        } else {
            //tab hra status condition
            switch ($tab_id) {

                case self::MEMBERS_LIST: //member list
                    $whereCondition = "member_id != 'null'";
                    break;

                case self::UNASSIGNED: //un assigned
                    $whereCondition = "JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::UNSCHEDULED;
                    break;

                case self::SCHEDULED: //scheduled
                    $whereCondition = "JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::SCHEDULED;
                    break;

                case self::IN_PROGRESS: //in progress tab
                    $whereCondition = "JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::IN_PROGRESS;
                    break;

                case self::QA: //QA tab

                    $whereCondition = "JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::READY_FOR_QA;


                    break;
                case self::CODING: //Coding Tab
                    $whereCondition = "JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::READY_FOR_CODER;
                    break;

                case self::CLINICIAN_REVIEW: //Clinician Review Tab

                    $whereCondition = "(JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::CLINICIAN_REVIEW_QA . " OR JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::CLINICAIN_REVIEW_CODER . ")";
                    break;

                case self::READY_FOR_UPLOAD: //ready for upload Tab
                    $whereCondition = "JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::READY_FOR_UPLOAD;
                    break;

                case self::COMPLETED: //Compeleted Tab
                    $whereCondition = "JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::COMPLETED;
                    break;

                case self::CANCELLED_NO_SHOW: //Cancelled Tab
                    $whereCondition = "(JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::NO_SHOW . " OR JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::APPOINTMENT_CANCELLED . " OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=" . MemberUtility::ASSESSMENT_CANCELLED . " OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=" . MemberUtility::UTC . " OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=" . MemberUtility::HOSPICE . " OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=" . MemberUtility::DECEASED . " OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=" . MemberUtility::IN_ELIGIBILE . " OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=" . MemberUtility::OTHER . " OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=" . MemberUtility::NO_SHOW . ")";

                    break;

                case self::TERMED_EXPIRED: //Term Expired Tab
                    $whereCondition = "JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=" . MemberUtility::TERM_EXPIRED;
                    break;

                case self::UNASSIGNED_QA: //Term Expired Tab
                    $whereCondition = "(qa_id == 'NULL' AND JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=" . MemberUtility::READY_FOR_QA . ")";
                    break;
                case self::UNASSIGNED_CODING: //Term Expired Tab READY_FOR_CODER
                    $whereCondition = "(coder_id != 'NULL' AND JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=" . MemberUtility::READY_FOR_CODER . ")";
                    break;
            }

            return $whereCondition;
        }
    }


    private function tabConditionSearch($whereCondition, $tab_id, $id = '', $firstname = '', $lastname = '')
    {
        $search_condtion = "";
        //echo $isSearchApplied;

        if ($id != '') {
            //$search_condtion = $whereCondition. " AND member_id LIKE '%$id%'";
            //$search_condtion = $whereCondition. " AND member_id = '$id'";
            $search_condtion = " member_info.member_id like '%$id%'";

        } elseif ($firstname != '') {
            $search_condtion = $whereCondition . " AND member_info.firstname LIKE '$firstname%'";
            //$search_condtion = " firstname LIKE '%$firstname%'";
        } elseif ($lastname != '') {
            $search_condtion = $whereCondition . " AND  member_info.lastname LIKE '%$lastname%'";
        } else {
            $search_condtion = $whereCondition;
        }

        //echo $search_condtion;exit;

        return $search_condtion;
    }

    private function filterConditionOld($tab_id, $filter_parameters)
    {
        $scheduledFrom = $filter_parameters['scheduledFrom'];
        $scheduledTo = $filter_parameters['scheduledTo'];

        $refusalFrom = $filter_parameters['refusalFrom'];
        $refusalTo = $filter_parameters['refusalTo'];

        $clientId = $filter_parameters['clientId'];
        $program = $filter_parameters['program'];
        $lob = $filter_parameters['lob'];
       if(strpos($lob,"M4") >= 0){
        $lob =  $lob . '_Medallion';
       }

        $city = $filter_parameters['city'];
        $hraStatus = $filter_parameters['hraStatus'];
        $visitType = $filter_parameters['visitType'];
        $qaIds = $filter_parameters['qaIds'];
        $coderIds = $filter_parameters['coderIds'];
        $nurseIds = $filter_parameters['nurseIds'];
        $status = $filter_parameters['status'];
        $schedulerIds = $filter_parameters['schedulerIds'];
        $subStatus = $filter_parameters['subStatus'];

        $filterCondition = '';
        if ($clientId != '') {
            $filterCondition = " AND clientid IN ('" . str_replace("|", "','", $clientId) . "')";
        }
        if ($lob != '') {
            $filterCondition .= " AND UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.LOB')))) IN ('" . strtoupper(str_replace("_", "','", $lob)) . "')";
        }
        if ($hraStatus != '') {
            $filterCondition .= " AND UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(hraStatus,'$.hraStatus')))) IN ('" . str_replace("_", "','", $hraStatus) . "')";
        }

        if ($visitType != '') {
            $filterCondition .= " AND VisitType IN ('" . str_replace("_", "','", $visitType) . "')";
        }

        if ($nurseIds != '') {
            $filterCondition .= " AND nurse_id IN ('" . str_replace("_", "','", $nurseIds) . "')";
        }

        if ($qaIds != '') {
            $filterCondition .= " AND qa_id IN ('" . str_replace("_", "','", $qaIds) . "')";
        }

        if ($schedulerIds != '') {
            $filterCondition .= " AND scheduler_id IN ('" . str_replace("_", "','", $schedulerIds) . "')";
        }

        if ($coderIds != '') {
            $filterCondition .= " AND coder_id IN ('" . str_replace("_", "','", $coderIds) . "')";
        }

        if ($scheduledFrom != '') {
            $filterCondition .= " AND " . GlobalQueryBuilder::whereClauseScheduleDateBetweenPerformance($filter_parameters);
        }

        if ($refusalFrom != '') {
            $filterCondition .= " AND " . GlobalQueryBuilder::whereClauseRefusalDateBetweenPerformance($filter_parameters);
        }

        if ($subStatus != '') {
            $filterCondition .= " AND " . GlobalQueryBuilder::whereClausesubStatusInPerformance('subStatus', $filter_parameters);
        }
        //echo $filterCondition;exit;
        return $filterCondition;
    }

    public function filterCondition($tab_id,$filter_parameters){
        $scheduledFrom = $filter_parameters['scheduledFrom'];
        $scheduledTo = $filter_parameters['scheduledTo'];

        $refusalFrom = $filter_parameters['refusalFrom'];
        $refusalTo = $filter_parameters['refusalTo'];

        $clientId = $filter_parameters['clientId'];
        $program = $filter_parameters['program'];
        // $lob =$filter_parameters['lob'];
        $lob = base64_decode($filter_parameters['lob']);
        if($lob != '' && strpos($lob,"M4") >= 0){
            $lob =  $lob . '_Medallion';
        }
        $lob=strtoupper($lob);

        //$city = $filter_parameters['city'];
        $hraStatus = str_replace(" ", "", $filter_parameters['hraStatus']);
        $visitType = $filter_parameters['visitType'];
        $qaIds = $filter_parameters['qaIds'];
        $coderIds = $filter_parameters['coderIds'];
        $nurseIds = $filter_parameters['nurseIds'];
//$screening = $filter_parameters['screening'];
        $subStatus = $filter_parameters['subStatus'];


        $status = $filter_parameters['status'];
        //$schedulerIds = $filter_parameters['schedulerIds'];

        $filterCondition = '';

        if($clientId != ''){
            $filterCondition = " AND clientid IN ('".str_replace("|","','",$clientId)."')";
        }


        if($lob != ''){
            $filterCondition .= " AND UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.LOB')))) IN ('".str_replace("_","','",$lob)."')";
        }
        if($hraStatus != ''){
            $filterCondition .= " AND UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(hraStatus,'$.hraStatus')))) IN ('".str_replace("_","','",$hraStatus)."')";
        }

        if($visitType != ''){
            $filterCondition .= " AND VisitType IN ('".str_replace("_","','",$visitType)."')";
        }

        if($status != ''){
            $filterCondition .= " AND member_info.reportStatus in('".$status."')";
        }

        if($nurseIds != ''  && $tab_id == 5 ){
            $filterCondition .= " AND nurse_id IN ('".str_replace("_","','",$nurseIds)."')  and member_info.reportStatus in ('Scheduled','Cancellation','Completed','No Show','Rescheduled','Refusal','F2F No Show','Virtual No Show')";
        }

        if($nurseIds != ''  && $tab_id != 5 ){
            $filterCondition .= " AND nurse_id IN ('".str_replace("_","','",$nurseIds)."')";
        }


        if ($refusalFrom != '') {
            $filterCondition .= " AND " . GlobalQueryBuilder::whereClauseRefusalDateBetweenPerformance($filter_parameters);
        }

        if ($subStatus != '') {
            $filterCondition .= " AND " . GlobalQueryBuilder::whereClausesubStatusInPerformance('subStatus', $filter_parameters);
        }
        if ($qaIds != '') {
            $filterCondition .= " AND qa_id IN ('" . str_replace("_", "','", $qaIds) . "')";
        }

        if ($coderIds != '') {
            $filterCondition .= " AND coder_id IN ('" . str_replace("_", "','", $coderIds) . "')";
        }

        if($scheduledFrom != ''){
            $filterCondition .= " AND ".GlobalQueryBuilder::whereClauseScheduleDateBetweenPerformance($filter_parameters);
        }

        if($filter_parameters['screeningIha'] == 'Yes' || $filter_parameters['screeningIha'] == 'No'){
            if($filter_parameters['screeningIha'] == "Yes") $filterCondition .= " AND TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Screening_IHA'))) = '".$filter_parameters['screeningIha']."'";
            else $filterCondition .= " AND TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Screening_IHA'))) != 'Yes' OR JSON_EXTRACT(memberinfo,'$.Screening_IHA') IS NULL";
        }

        return $filterCondition;
    }



    /*
        NAME    : hraDaysCustomColumnTabContion
        TYPE    : internal Utiltiy function
        DETAILS : tab based number hra history days calculation
        RETURN  : sql query as string
    */
    private function hraDaysCustomColumnTabContion($tab_id)
    {

        switch ($tab_id) {
            case self::QA:
                return GlobalQueryBuilder::sqlCustomColumnHraStatusHistoryDays(-1, 'hra_days');
                break;

            case self::CODING:
                return GlobalQueryBuilder::sqlCustomColumnHraStatusHistoryDays(-2, 'hra_days');
                break;

            default:
                return GlobalQueryBuilder::sqlCustomColumnHraStatusHistoryDays(0, 'hra_days');
        }
    }

    /*
        NAME    : queryReviewCountCustomColumnTabCondition
        TYPE    : internal Utiltiy function
        DETAILS : number of times query form reviewed based on tab condition
        RETURN  : sql query as string
    */
    private function queryReviewCountCustomColumnTabCondition($tab_id)
    {
        switch ($tab_id) {
            case self::QA:
                return GlobalQueryBuilder::sqlCustomColumnQueryFormReviewCount(UserRoleConstant::QA, 'query_form_review_count');
                break;

            case self::CODING:
                return GlobalQueryBuilder::sqlCustomColumnQueryFormReviewCount(UserRoleConstant::CODER, 'query_form_review_count');
                break;

            case self::CLINICIAN_REVIEW:
                return GlobalQueryBuilder::sqlCustomColumnQueryFormReviewCount(UserRoleConstant::NURSE, 'query_form_review_count');
                break;

            case self::MEMBERS_LIST:
                return GlobalQueryBuilder::sqlCustomColumnQueryFormMemberListReviewCount(UserRoleConstant::NURSE, 'query_form_review_count');
                break;
        }

        return FALSE;

    }


}


?>
