<?php

/*
    USER RELATED NEW FUNCTIONALITY AND GLOBAL UTILITY 
*/

require_once("../utility/Utility.php");
require_once("../TimeZone.php");
require_once("../config/Config.php");

use Config\AppConfig;
use Config\AdminConfig;

class AdminUtility
{   
    
    /*
        NAME    : OnUserAdded
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function SendEmailRegardingUserLocked($user_details,$reason_for_locked=ReasonForUnlockMailSent::LOGIN_ATTEMPT_EXCEEDS)
    {
        if(AppConfig::APP_ENVIRONMENT_TYPE === 2) // only work on production live version
        {
            if($user_details)
            {
                $user_name =  $user_details['firstname'];
                $user_firstname = $user_details['firstname'];
                $user_lastname = $user_details['lastname'];
                //all are dummy texts
                $reason_for_locked_detail = "Invalid Credentials Enter more than 3 times";
                switch($reason_for_locked)
                {
                    case ReasonForUnlockMailSent::LOGIN_ATTEMPT_EXCEEDS:
                        $reason_for_locked_detail = "Invalid Credentials Enter more than 3 times";
                    break;

                    case ReasonForUnlockMailSent::OTP_REQUEST_LIMIT_EXCEEDS:
                        $reason_for_locked_detail = "OTP request limit exceeds for security concren account locked";
                    break;

                    case ReasonForUnlockMailSent::OTP_VALIDATION_LIMIT_EXCEEDS:
                        $reason_for_locked_detail = "OTP validation limit exceeds for security concren account locked";
                    break;
                }

                TimeZone::useTimeZone();
                $current_time = date('m-d-Y H:i:s');

                $mail_content = '<div style="width:100%;background-color: gainsboro;"> 
                    <div style="margin-left:0px;  margin-top: 0px; height: auto;  width:100%">Hi Admin,<br>
                    <br>The following user <b>'.$user_firstname.' '.$user_lastname.' ('.$user_name.') </b> account was locked due to <b> '.$reason_for_locked_detail.'</b> on date <b>'.$current_time.'</b><br>
                    <br>Thank You</div>
                </div>';

               return Utility::sendMailToMultiple(AdminConfig::ADMIN_USER_UNLOCK_EMAIL_LIST,"USER ACCOUNT LOCKED",$mail_content);
              
            }
        }

        return Utility::failedMailResponse("user not found");
    }

}

/*
    reason due to user lock mail sent
*/
class ReasonForUnlockMailSent
{
    const UNKNOWN = -1;
    const LOGIN_ATTEMPT_EXCEEDS=0;
    const OTP_REQUEST_LIMIT_EXCEEDS=1;
    const OTP_VALIDATION_LIMIT_EXCEEDS=2;
}

?>

