<?php

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: PUT, GET, POST, DELETE");
header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");

require_once("../utility/JwtUtility.php");
require_once("../utility/Utility.php");
require_once("../utility/DataBaseUtility.php");
require_once("../utility/ResponseUtility.php");
require_once("../auth/UserUtility.php");
require_once("../TimeZone.php");

class UserLogin
{
    
    /*
		NAME 	: loginUserWithAttempt
		TYPE 	: api function
        DETAILS	: new way to login user with password hash method and attempt count
        RETURN	: user details and jwt token if valid user ans active state,else if inactive or failed  
	*/
    public function loginUserWithAttempt()
    {
        include("../db.php");
        
        $post_username = $GLOBALS['inputData']['data']['username'];
        $post_password = $GLOBALS['inputData']['data']['password'];

        try 
        {
            
            $response  = new stdClass();
            //prepare sql query for user avaiable or not check
            $user_query=$conn->prepare('SELECT * from userLogin WHERE BINARY `username` = BINARY ?');
                $user_query->bind_param('s',$post_username);
                $user_query->execute();
                $user_result = $user_query->get_result();
            $user_array=$user_result->fetch_assoc();

            if($user_array)
            {

                $user_unique_id  = $user_array['userUniqueno'];
                $user_active_status  = $user_array['userStatus'];
                if($user_active_status==0) //user in active
                {
                    $response->status = UserLoggingStatus::IN_ACTIVE;
                    $response->message = "user inactive status";
                    echo json_encode($response);
                    return;
                }

                //get the player login status by user unique id
                $user_login_status_details = UserUtility::getUserLoginStatus($user_unique_id);
                if($user_login_status_details)
                {
                    $is_user_locked =  $user_login_status_details['is_locked'];
                   
                    if($is_user_locked)
                    {
                        $response->status = UserLoggingStatus::ACCOUNT_LOCKED;
                        $response->message = "Account Locked due to maximum login OTP attempt tried";
                        echo json_encode($response);
                        return;//break the further execution
                    }

                    $user_attempt_count = $user_login_status_details['login_attempt'];
                    if($user_attempt_count>=UserLoggingConstant::MAX_LOGIN_ATTEMPT_COUNT)
                    {
                        $response->status = UserLoggingStatus::ATTEMPT_REACHED;
                        $response->message = "Maximum login attempt reached";
                        echo json_encode($response);
                        return;//break the further execution
                    }
                }

                //check user active state 
                if($user_active_status == 1)
                {
                    //verify the password with db hash
                    $verified = Utility::validatePasswordHash($post_password,$user_array['password_hash']);
                    if($verified)
                    {
                        //user login utility event
                        UserUtility::OnUserLoggedIn($user_unique_id,$user_login_status_details);

                        $login_type = $user_array['type'];
                        //generate jwt token
                            $jwt_utility = new JwtUtility;
                            $custom_user_data = array("username"=>$post_username,"role"=>$login_type);
                            $jwt_token = $jwt_utility->generateToken($custom_user_data);
                            $response->jwtToken = $jwt_token;
                        //end of jwt token

                            //user client access list
                            $user_clients=DataBaseUtility::getUserClientPrivilege($user_unique_id);
                            if($user_clients==null)
                            {
                                $user_clients = DataBaseUtility::getClientIdList();
                            }

                            switch($login_type)
                            {
                                        
                                case 'nurse' :

                                    $login_type      = $user_array['type'];
                                    $nurseinfo       = $user_array['userInfo'];
                                    $admin_idno      = $user_array['admin_idno'];
                                    $nurseUniqueno   = $user_array['userUniqueno'];
                                    $securityStatus  = $user_array['securityQuestionStatus'];
                                    $signatureStatus = $user_array['signatureStatus'];
                                    $signature       = $user_array['signature'];
                                    $userStatus      = $user_array['userStatus'];
                                    $securityanswers = $user_array['securityanswers'];
                                    $versionnumber   = $user_array['versionnumber'];
                                    $covidQuestionUpdated = $user_array['covidQuestionUpdated'];
                                     //quick fix to remove password when return user info 02-03-2021
                                     $admininfo_array = json_decode($nurseinfo,true);
                                     unset($admininfo_array["password"]);
                                     $admininfo_json  = json_encode($admininfo_array);
                                    //end of fix
                                    
                                        $response->status          = UserLoggingStatus::SUCCESS;
                                        $response->message         = "successfully logged in";

                                        $response->data            = $admininfo_json;
                                        $response->admin_idno      = $admin_idno;
                                        $response->versionNumber   = $versionnumber;
                                        $response->sessionid       = $user_array['session_id'];
                                        $response->nurseUniqueno   = $nurseUniqueno;
                                        $response->securityStatus  = $securityStatus;
                                        $response->securityAnswer  = $securityanswers;
                                        $response->signatureStatus = $signatureStatus;
                                        $response->signature       = $signature;
                                        $response->userStatus      = $userStatus;
                                        $response->type            = $login_type;
                                        $response->userClients     = $user_clients;
										$response->covidQuestionUpdated     = $covidQuestionUpdated;										
                                    echo json_encode($response);
                                   
                                break;
                                        
                                case 'qa' :
                                        
                                    $session_id    = session_id();
                                    $admin_idno    = $user_array['userUniqueno'];
                                    $admininfo     = $user_array['userInfo'];
                                    $versionnumber = $user_array['versionnumber'];

                                     //quick fix to remove password when return user info 02-03-2021
                                     $admininfo_array = json_decode($admininfo,true);
                                     unset($admininfo_array["password"]);
                                     $admininfo_json  = json_encode($admininfo_array);
                                    //end of fix

                                    $update_sessid = "UPDATE userLogin SET `session_id` = '$session_id' WHERE `username` = '$post_username'";
                                    $update_sessid_result = mysqli_query($conn, $update_sessid);

                                        $response->status         = UserLoggingStatus::SUCCESS;
                                        $response->message         = "successfully logged in";

                                        $response->sessionid      = $session_id;
                                        $response->data           = $admininfo_json;
                                        $response->type           = $login_type;
                                        $response->versionNumber  = $versionnumber;
                                        $response->qa_uniqueid    = $admin_idno;
                                        $response->userClients     = $user_clients;  
                                    echo json_encode($response);
                                        
                                break;
                                        
                                case 'coder' :
                                        
                                    $session_id    = session_id();
                                    $admin_idno    = $user_array['userUniqueno'];
                                    $admininfo     = $user_array['userInfo'];
                                    $versionnumber = $user_array['versionnumber'];

                                    //quick fix to remove password when return user info 02-03-2021
                                        $admininfo_array = json_decode($admininfo,true);
                                        unset($admininfo_array["password"]);
                                        $admininfo_json  = json_encode($admininfo_array);
                                    //end of fix

                                    $update_sessid = "UPDATE userLogin SET `session_id` = '$session_id' WHERE `username` = '$post_username'";
                                    $update_sessid_result = mysqli_query($conn, $update_sessid);
                                            
                                        $response->status         = UserLoggingStatus::SUCCESS;
                                        $response->message         = "successfully logged in";

                                        $response->sessionid      = $session_id;
                                        $response->data           = $admininfo_json;
                                        $response->type           = $login_type;
                                        $response->userClients    = $user_clients;  
                                        $response->versionNumber  = $versionnumber;
                                        $response->coder_uniqueid = $admin_idno;
                                    echo json_encode($response);
                                        
                                break;
                                        
                                default :
                                
                                    $session_id    = session_id();
                                    $admin_idno    = $user_array['userUniqueno'];
                                    $admininfo     = $user_array['userInfo'];

                                    //quick fix to remove password when return user info 02-03-2021
                                        $admininfo_array = json_decode($admininfo,true);
                                        unset($admininfo_array["password"]);
                                        $admininfo_json  = json_encode($admininfo_array);
                                    //end of fix

                                    $versionnumber = $user_array['versionnumber'];
                                    $update_sessid = "UPDATE userLogin SET `session_id` = '$session_id' WHERE `username` = '$post_username'";
                                    $update_sessid_result = mysqli_query($conn, $update_sessid);
                                    $signature       = $user_array['signature'];
                                        $response->status         = UserLoggingStatus::SUCCESS;
                                        $response->message        = "successfully logged in";

                                        $response->sessionid      = $session_id;
                                        $response->data           = $admininfo_json;
                                        $response->type           = $login_type;
                                        $response->userClients    = $user_clients;
                                        $response->versionNumber  = $versionnumber;
                                        $response->admin_uniqueid = $admin_idno;
                                    $response->signature       = $signature;
                                    echo json_encode($response);
                                
                                break;
                                    
                            }     
                    }
                    else
                    {
                        $reaponse_array = UserUtility::OnUserInValidPassword($user_unique_id,$user_login_status_details);
                        $attempt_count = $reaponse_array["attemptCount"];
                        $is_locked = $reaponse_array["isLocked"];
                        if($is_locked)
                        {
                            $response->status = UserLoggingStatus::ACCOUNT_LOCKED;
                            $response->message = "Account Locked due to wrong password enter after account enabled";
                            echo json_encode($response);
                            return;//break the further execution
                        }
                        else
                        {
                            //when user login failed 
                            $response->status = UserLoggingStatus::IN_VAILD_CREDENTIALS;
                            $response->attemptCount = $attempt_count;
                            $response->maxAttemptCount = UserLoggingConstant::MAX_LOGIN_ATTEMPT_COUNT;
                            $response->message = "invalid username or password";
                            echo json_encode($response);
                        }
                    }

                }
                else
                {
                    $response->status = UserLoggingStatus::IN_ACTIVE;
                    $response->message = "user inactive status";
                    echo json_encode($response);
                }

            }
            else
            {
                $response->status = UserLoggingStatus::FAILED;
                $response->message = "invalid username or password";
                echo json_encode($response);
            }
        }
        catch (Exception $e) 
        {
            $response  = new stdClass();
            $response->status = UserLoggingStatus::UNKNOWN;
            $response->message = "invalid username or password";
            $response->error = $e->getMessage();
            echo json_encode($response);
        }
           	
    }

}

$user_login = new UserLogin;

$method = $_SERVER['REQUEST_METHOD'];
$requestedurl = $_SERVER['REQUEST_URI'];
$arrayurlstring = explode("/",$requestedurl);
$crcount = count($arrayurlstring);
$crcountt = $crcount -1;
$requestMethod = $arrayurlstring[$crcountt];
$exploded = explode("?",$requestMethod);
$requestMethod = $exploded[0];

//request body and header parse
$postdata             = file_get_contents("php://input");
$request              = json_decode($postdata);
$requestt             = json_decode($postdata, true);

$GLOBALS['inputData'] = $requestt;
$GLOBALS['input']     = $request;

 switch ($method) {
	 
	 case 'POST':
        switch ($requestMethod) 
        {
            case 'Login':
                $user_login->loginUserWithAttempt();
            break;

            case 'LoginWithAttempt':
                $user_login->loginUserWithAttempt();
            break;

            case 'ResetPasswordByUsername':
                $response = UserUtility::resetPasswordByUsername();
                echo json_encode($response);
            break;

            case 'ResetPasswordByEmail':
                $response = UserUtility::resetPasswordByEmailAndRole();
                echo json_encode($response);
            break;

            case 'SendFailedAttemptOtp':
                $request_data_array = Utility::parseRequestBodyFormat();
                $user_name = $request_data_array['username'];
                $response = UserUtility::sendOtpForFailedAttempt($user_name);
                echo json_encode($response);
            break;

            case 'ValidateFailedAttemptOtp':
                $request_data_array = Utility::parseRequestBodyFormat();
                $user_name = $request_data_array['username'];
                $user_sent_otp = $request_data_array['otp'];
                $response = UserUtility::validateOtpByFailedAttempt($user_name,$user_sent_otp);
                echo json_encode($response);
            break;

            case 'SendOtpByUsername':
                $request_data_array = Utility::parseRequestBodyFormat();
                $user_name = $request_data_array['username'];
                $response = UserUtility::sendOtpByUsername($user_name);
                echo json_encode($response);
            break;

            case 'ValidateOtpByUsername':
                $request_data_array = Utility::parseRequestBodyFormat();
                $user_name = $request_data_array['username'];
                $user_sent_otp = $request_data_array['otp'];
                $response = UserUtility::validateOtpByUsername($user_name,$user_sent_otp);
                echo json_encode($response);
            break;
            
            case 'SendOtpByEmail':
                $request_data_array = Utility::parseRequestBodyFormat();
                $user_email = $request_data_array['email'];
                $user_role = $request_data_array['role'];
                $response = UserUtility::sendOtpByEmailAndRole($user_email,$user_role);
                echo json_encode($response);
            break;

            case 'ValidateOtpByEmail':
                $request_data_array = Utility::parseRequestBodyFormat();
                $user_email = $request_data_array['email'];
                $user_role = $request_data_array['role'];
                $user_sent_otp = $request_data_array['otp'];
                $response = UserUtility::validateOtpByEmailAndRole($user_email,$user_role,$user_sent_otp);
                echo json_encode($response);
            break;

        }
    break;

    case 'GET' :
        switch($requestMethod)
        {
            case 'UserRolesByEmail':
                $user_email = $_GET['email'];
                $response = new stdClass;
                $response->email=$user_email;
                $response->roles=UserUtility::getUserRolesByEmail($user_email);
                echo json_encode($response);
            break;
        }
    break;

 }

?>