<?php

/*
    USER RELATED NEW FUNCTIONALITY AND GLOBAL UTILITY 
*/

require_once("../utility/Utility.php");
require_once("../TimeZone.php");
require_once("../utility/DataBaseUtility.php");
require_once("../utility/ArrayUtility.php");
require_once("../admin/AdminUtility.php");
require_once("../config/Config.php");

use Config\AppConfig;

class UserUtility
{

        /*
            NAME    : OnUserAdded
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function OnUserAdded($role,$user_unique_id,$request_data_array)
        {

            

        }

        /*
            NAME    : OnUserDetailsUpdated
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function OnUserDetailsUpdated($role,$user_unique_id,$request_data_array)
        {
   
            
        }

        /*
            NAME    : OnClientDetailsUpdated
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function OnUserClientPrivilegesUpdated($role,$user_unique_id,$user_clients)
        {
            
            //if only user client is valid array and not null
            if($user_clients && is_array($user_clients))
            {
                //json client details for the user
                $client_privileges_array = json_decode('{"clients":[]]}',true);
                $client_privileges_array['clients'] = $user_clients;
                $client_privileges = json_encode($client_privileges_array);

                $update_result = DataBaseUtility::updateOrInsertUserClientPrivilege($user_unique_id,$client_privileges);
                $status = $update_result['status'];
                $rows_updated = $update_result['rowsUpdated'];
                if($status)
                {
                   if($rows_updated)
                   {
                       return true;
                   }
                    return false;
                }
                else
                {
                    return false;
                }
            }

            return false;

        }

        /*
            NAME    : IsUserInActiveStatus
            TYPE    : global Utiltiy function 
            DETAILS : to get the status of the user
            RETURN  : if true active else false 
        */
        public static function IsUserInActiveStatus($user_unique_id)
        {
            $user_details = DataBaseUtility::getUserById($user_unique_id);
            if($user_details)
            {
                $user_active_status  = $user_details['userStatus'];
                return $user_active_status==1?true:false;
            }
            
            return false;
        }

        /*
            NAME    : generateResponseIfUserInActive
            TYPE    : global Utiltiy function 
            DETAILS : to get the status of the user
            RETURN  : response code if user in inacive state else null
        */
        public static function generateResponseIfUserInActive($user_details,$status_code)
        {
            if($user_details)
            {
                $user_active_status  = $user_details['userStatus'];
                if($user_active_status==0) //user in active
                {
                    return array("status"=>$status_code,"message"=>"User inactive status","error"=>"");;
                }
            }
            
            return null;
        }

        /*
            NAME    : getUserAttemptCount
            TYPE    : global Utiltiy function 
            DETAILS :its called when successful attempt
            RETURN  : 
        */
        public static function OnUserLoggedIn($user_unique_id,$user_login_status_details)
        {
            //if no user status 
            if($user_login_status_details==null)
            {
                self::AddUserLoginStatus($user_unique_id);
            }

            self::resetUserAttemptCount($user_unique_id);
            self::AddUserLoginHistory($user_unique_id,true,$user_login_status_details['login_history']);
        }

        /*
            NAME    : getUserAttemptCount
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : active login attempt count
        */
        public static function OnUserInValidPassword($user_unique_id,$user_login_status_details)
        {
            $active_login_attempt_count = -1;
            //if no user status 
            if($user_login_status_details==null)
            {
                self::AddUserLoginStatus($user_unique_id);
                $user_login_attempt_count =self::getUserAttemptCount($user_unique_id);
                if($user_login_attempt_count==-1)
                {
                    //what if invalid attempt
                }
                else
                {
                    $active_login_attempt_count = self::incrementUserAttemptCount($user_unique_id,$user_login_attempt_count);
                }
            }
            else
            {
                $user_login_attempt_count = $user_login_status_details['login_attempt'];
                $active_login_attempt_count = self::incrementUserAttemptCount($user_unique_id,$user_login_attempt_count);
            }

            $is_locked=self::LockTheUserAccount($user_unique_id,false,ReasonForUnlockMailSent::LOGIN_ATTEMPT_EXCEEDS);

            self::AddUserLoginHistory($user_unique_id,false,$user_login_status_details['login_history']);

            return array("isLocked"=>$is_locked,"attemptCount"=>$active_login_attempt_count);

        }

        /*
            NAME    : LockTheUserAccount
            TYPE    : internal Utiltiy function 
            DETAILS : external factor to lock the account try to validate otp more than permitted limits
                      for security reason
            RETURN  : if true locked else false
        */
        private static function LockTheUserAccount($user_unique_id,$external_factor=false,$reason_for_locked=ReasonForUnlockMailSent::LOGIN_ATTEMPT_EXCEEDS)
        {
            $user_login_status_details = UserUtility::getUserLoginStatus($user_unique_id);
            if($user_login_status_details)
            {
                $opt_attempt_count = $user_login_status_details['opt_attempt_count'];
                $user_attempt_count = $user_login_status_details['login_attempt'];
                $is_locked=$user_login_status_details['is_locked'];
               
                if($external_factor===true || ( $user_attempt_count>=UserLoggingConstant::MAX_LOGIN_ATTEMPT_COUNT && $opt_attempt_count>0))            
                {
                    if(self::SetUserAccountLocked($user_unique_id))
                    {
                        //send mail here
                        $user_details = DataBaseUtility::getUserById($user_unique_id);
                        if($user_details)
                        {
                            AdminUtility::SendEmailRegardingUserLocked($user_details,$reason_for_locked);
                        }
                        $is_locked = true;
                    }
                }

                return $is_locked;
            }

            return false;
        }

        /*
            NAME    : OnUserLoginUnLocked
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : response as array
        */
        public static function OnUserLoginUnLocked($admin_unique_id,$user_unique_id)
        {
            $response_array = array("status"=>UserLoggingStatus::FAILED,"message"=>"User Unlock Failed","error"=>"");

            $user_details = DataBaseUtility::getUserById($admin_unique_id);
            if($user_details)
            {
                if($user_details['type']!==UserRoleConstant::ADMIN)
                {
                    $response_array = array("status"=>UserLoggingStatus::FAILED,"message"=>"User Unlock Failed","error"=>"No Admin Priveleges");
                    return $response_array;
                }
            
                self::resetUserAttemptCount($user_unique_id);
                self::resetUserResetLoginCount($user_unique_id);
                $response_array = array("status"=>UserLoggingStatus::SUCCESS,"message"=>"User Unlocked Successfully","error"=>"");
             }
             else
             {
                $response_array = array("status"=>UserLoggingStatus::FAILED,"message"=>"User Unlock Failed","error"=>"admin user not found");
             }

            return $response_array;
        }
        

        /*
            NAME    : getUserListByRoleAndClientPrivilege
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function getUserListByClientPrivilegesAndRole($client_id,$user_role)
        {
            include("../db.php");
            $user_list_array=[];
            $user_query=$conn->prepare('SELECT user_table.type,user_table.userUniqueno,user_table.username,user_table.firstname,
                                               user_table.lastname, user_table.email,user_table.userInfo,
                                               user_table.userStatus,
                                               user_privileges_table.client_privileges as userClients FROM ( SELECT * FROM `userLogin` WHERE `type`= ? ) as user_table
                                               LEFT JOIN user_privileges as user_privileges_table ON user_privileges_table.user_unique_id = user_table.userUniqueno ORDER BY user_table.firstname');
            
            $user_query->bind_param('s',$user_role);
            $user_query->execute();
            $user_query_result = $user_query->get_result();

            $total_client_list_array = DataBaseUtility::getClientIdList(); 
           
            while($user_detail_row = $user_query_result->fetch_assoc())
            {
                //user client access list
                $user_clients = ArrayUtility::getArrayFromJsonByKey($user_detail_row['userClients'],"clients");
                if($user_clients==null)
                {
                     $user_clients = $total_client_list_array;
                     $user_detail_row['clientPrivilegesStatus'] = false;
                }
                else
                {
                    $user_detail_row['clientPrivilegesStatus'] = true;
                }
                if(is_array($user_clients) && in_array($client_id,$user_clients))
                {
                    if($user_detail_row['userStatus']==1)
                    {
                        $user_detail_row['userInfo'] = json_decode($user_detail_row['userInfo'],true);
                        //do not sent this field eventhough is not used
                        unset($user_detail_row['userInfo']['password']);
                        
                        $user_detail_row['userClients'] = $user_clients;
                        $user_list_array[]=$user_detail_row;
                    }
                }

            }

            $response = new stdClass;
            $response->userRole = $user_role;
            $response->userList = $user_list_array;
            echo json_encode($response);
            
        }


        /*
            NAME    : getUserIdAndFullNameByClientPrivilegesAndRole
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function getUserIdAndFullNameByClientPrivilegesAndRole($client_id,$user_role)
        {
            include("../db.php");
            $user_list_array=[];
            $user_query=$conn->prepare('SELECT user_table.type,user_table.userUniqueno,CONCAT(user_table.firstname," ",
                                               user_table.lastname ) as userFullName,
                                               user_table.userStatus,
                                               user_privileges_table.client_privileges as userClients FROM ( SELECT * FROM `userLogin` WHERE `type`= ? ) as user_table
                                               LEFT JOIN user_privileges as user_privileges_table ON user_privileges_table.user_unique_id = user_table.userUniqueno ORDER BY userFullName');
            
            $user_query->bind_param('s',$user_role);
            $user_query->execute();
            $user_query_result = $user_query->get_result();

            $total_client_list_array = DataBaseUtility::getClientIdList(); 

            while($user_detail_row = $user_query_result->fetch_assoc())
            {
                $user_clients = ArrayUtility::getArrayFromJsonByKey($user_detail_row['userClients'],"clients");
                if($user_clients==null)
                {
                    //if privillages not set
                     $user_clients = $total_client_list_array;
                }
                //user client access list
                if(is_array($user_clients) && in_array($client_id,$user_clients))
                {
                    if($user_detail_row['userStatus']==1)
                    {
                        $user_list_array[]=array("userUniqueno"=>$user_detail_row['userUniqueno'],"userFullName"=>$user_detail_row['userFullName']);
                    }
                }
            }

            $response = new stdClass;
            $response->userRole = $user_role;
            $response->userList = $user_list_array;
            echo json_encode($response);
            
        }
        
        /*
            NAME    : getUserIdAndFullNameByUserClientPrivilegesAndRole
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function getUserIdAndFullNameByUserClientPrivilegesAndRole($user_id,$user_role)
        {
            include("../db.php");
            $user_list_array=[];

            $error_message ="";
            $response_status = true;

            if(DataBaseUtility::getUserById($user_id))
            {
                $logged_user_clients = DataBaseUtility::getUserClientPrivilege($user_id);
                $availalble_client_list_array = DataBaseUtility::getClientIdList();
                if($logged_user_clients==null) { $logged_user_clients=$availalble_client_list_array; }
                
                if($logged_user_clients)
                {
                    $user_query=$conn->prepare('SELECT user_table.type,user_table.userUniqueno,CONCAT(user_table.firstname," ",
                                                    user_table.lastname ) as userFullName,
                                                    user_table.userStatus,
                                                    user_privileges_table.client_privileges as userClients FROM ( SELECT * FROM `userLogin` WHERE `type`= ? ) as user_table
                                                    LEFT JOIN user_privileges as user_privileges_table ON user_privileges_table.user_unique_id = user_table.userUniqueno ORDER BY userFullName');
                    
                    $user_query->bind_param('s',$user_role);
                    $user_query->execute();
                    $user_query_result = $user_query->get_result();

                    while($user_detail_row = $user_query_result->fetch_assoc())
                    {
                        $user_clients = ArrayUtility::getArrayFromJsonByKey($user_detail_row['userClients'],"clients");
                        if($user_clients==null) { $user_clients=$availalble_client_list_array; }
                        //echo $user_detail_row['userFullName']." >".json_encode($user_clients)."\n";
                        if(is_array($user_clients) && array_intersect($user_clients,$logged_user_clients))
                        {
                            if($user_detail_row['userStatus']==1)
                            {
                                $user_list_array[]=array("userUniqueno"=>$user_detail_row['userUniqueno'],"userFullName"=>$user_detail_row['userFullName']);
                            }
                            
                        }
                    }
                }
                else
                {
                    $response_status = false;
                    $error_message ="logged user with no client privileges ";
                }
            }
            else
            {
                $response_status = false;
                $error_message ="invalid user id";
             }

            $response = new stdClass;
            $response->status = $response_status;
            $response->error = $error_message;
            $response->userRole = $user_role;
            $response->userList = $user_list_array;
            echo json_encode($response);
            
        }

         /*
            NAME    : getUserLoginStatus
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function getUserResetLogin($user_unique_id)
        {
            //database connection
            include("../db.php");

                $user_login_status_query=$conn->prepare('SELECT * from user_reset_login WHERE user_unique_id=?');
                $user_login_status_query->bind_param('i',$user_unique_id);
                $user_login_status_query->execute();
                $user_login_status_result = $user_login_status_query->get_result();
             
            return $user_login_status_result->fetch_assoc();

        }

        /*
            NAME    : AddUserResetLogin
            TYPE    : intenal Utiltiy function 
            DETAILS : add user login reset 
            RETURN  : affested rows
        */
        private static function AddUserResetLogin($user_unique_id)
        {
            //database connection
            include("../db.php");

                $user_login_status_query=$conn->prepare('INSERT IGNORE INTO user_reset_login (user_unique_id) VALUES(?)');
                $user_login_status_query->bind_param('i',$user_unique_id);
                $user_login_status_query->execute();

            return $user_login_status_query->affected_rows;

        }

         /*
            NAME    : getUserLoginStatus
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function getUserLoginStatus($user_unique_id)
        {
            //database connection
            include("../db.php");

                $user_login_status_query=$conn->prepare('SELECT * from user_login_status WHERE user_unique_id=?');
                $user_login_status_query->bind_param('i',$user_unique_id);
                $user_login_status_query->execute();
                $user_login_status_result = $user_login_status_query->get_result();
             
            return $user_login_status_result->fetch_assoc();

        }

        /*
            NAME    : AddUserLoginStatus
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function AddUserLoginStatus($user_unique_id)
        {
            //database connection
            include("../db.php");

                $user_login_status_query=$conn->prepare('INSERT IGNORE INTO user_login_status (user_unique_id) VALUES(?)');
                $user_login_status_query->bind_param('i',$user_unique_id);
                $user_login_status_query->execute();

            return $user_login_status_query->affected_rows;

        }

        /*
            NAME    : AddUserLoginStatus
            TYPE    : internal Utiltiy function 
            DETAILS :  format { status="success",date:"2021-03-25 10:00:00"}
            RETURN  : nothing
        */
        private static function AddUserLoginHistory($user_unique_id,$login_status,$login_history_array_json)
        {
             include("../db.php");

             TimeZone::useTimeZone();
			 $current_date_time = date("Y-m-d H:i:s");

            //decode the json hra history format into php array
			$login_history_array = json_decode($login_history_array_json, true);
             
             $login_status_text = $login_status===TRUE?"success":"failed";
             
                if($login_history_array==NULL )
                {
                    $login_history_array = array();
                }
            
             $login_history_status = array("status"=>$login_status_text , "date"=>$current_date_time);
             array_unshift( $login_history_array, $login_history_status);
            //limit only N entire to save database
             $login_history_array = array_slice($login_history_array,0,UserLoggingConstant::MAX_LOGIN_HISTORY_COUNT);

             $updated_login_history_json = json_encode($login_history_array);
             //updated database
             $login_history_query = $conn->prepare('UPDATE user_login_status SET login_history=? WHERE user_unique_id = ?'); 
             $login_history_query->bind_param("si", $updated_login_history_json,$user_unique_id);
             $login_history_query->execute();

             return $login_history_query->affected_rows;

        }

        /*
            NAME    : getUserAttemptCount
            TYPE    : internal Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function getUserAttemptCount($user_unique_id)
        {

            include("../db.php");

            //updated database
            $login_attempt_query = $conn->prepare('SELECT login_attempt FROM user_login_status WHERE user_unique_id = ?'); 
            $login_attempt_query->bind_param("i",$user_unique_id);
            $login_attempt_query->execute();
            $login_attempt_query_result = $login_attempt_query->get_result();
            if($login_attempt_query_result)
            {
                 $user_login_status_details = $login_attempt_query_result->fetch_assoc();
                 return $user_login_status_details['login_attempt'];
            }

            return -1;
        }

        /*
            NAME    : getOtpAttemptCount
            TYPE    : internal Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function getOtpAttemptDetails($user_unique_id)
        {

            include("../db.php");

            //updated database
            $login_attempt_query = $conn->prepare('SELECT otp_sent_count,opt_attempt_count FROM user_login_status WHERE user_unique_id = ?'); 
            $login_attempt_query->bind_param("i",$user_unique_id);
            $login_attempt_query->execute();
            $login_attempt_query_result = $login_attempt_query->get_result();
            if($login_attempt_query_result)
            {
                 $user_login_status_details = $login_attempt_query_result->fetch_assoc();
                 return $user_login_status_details;
            }

            return -1;
        }


        /*
            NAME    : getOtpResetLoginDetails
            TYPE    : internal Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function getOtpResetLoginDetails($user_unique_id)
        {

            include("../db.php");

            //updated database
            $login_attempt_query = $conn->prepare('SELECT otp_sent_count,opt_attempt_count FROM user_reset_login WHERE user_unique_id = ?'); 
            $login_attempt_query->bind_param("i",$user_unique_id);
            $login_attempt_query->execute();
            $login_attempt_query_result = $login_attempt_query->get_result();
            if($login_attempt_query_result)
            {
                 $user_login_status_details = $login_attempt_query_result->fetch_assoc();
                 return $user_login_status_details;
            }

            return -1;
        }

        /*
            NAME    : incrementUserAttemptCount
            TYPE    : internal Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function incrementUserAttemptCount($user_unique_id,$active_attempt_count)
        {
            include("../db.php");

            $active_attempt_count+=1;
            if($active_attempt_count>=UserLoggingConstant::MAX_LOGIN_ATTEMPT_COUNT)
            {
                $active_attempt_count = UserLoggingConstant::MAX_LOGIN_ATTEMPT_COUNT;
            }

            //updated database
            $login_attempt_query = $conn->prepare('UPDATE user_login_status SET login_attempt=? WHERE user_unique_id = ?'); 
            $login_attempt_query->bind_param("ii",$active_attempt_count,$user_unique_id);
            $login_attempt_query->execute();

            return $active_attempt_count;

        }

        /*
            NAME    : resetUserAttemptCount
            TYPE    : internal Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function resetUserAttemptCount($user_unique_id)
        {
            //dtabase connection 
            include("../db.php");

            $reset_count = 0;
            $empty_string = null;
            //updated database
            $login_attempt_query = $conn->prepare('UPDATE user_login_status SET login_attempt = ?, 
                                       otp_sent_count = ?,opt_attempt_count = ?, opt_value = ?,opt_sent_time = ?,
                                       is_locked = ? WHERE user_unique_id = ?'); 
            $login_attempt_query->bind_param("iiissii",$reset_count,$reset_count,$reset_count,$empty_string,$empty_string,$reset_count,$user_unique_id);
            $login_attempt_query->execute();

            return $login_attempt_query->affected_rows;

        }

        /*
            NAME    : resetUserAttemptCountExceptOptTriedCount
            TYPE    : internal Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function resetUserAttemptCountExceptOptTriedCount($user_unique_id)
        {
            //dtabase connection 
            include("../db.php");

            $reset_count = 0;
            $empty_string = null;
            //updated database
            $login_attempt_query = $conn->prepare('UPDATE user_login_status SET login_attempt = ?, 
                                       otp_sent_count = ?, opt_value = ?,opt_sent_time = ? WHERE user_unique_id = ?'); 
            $login_attempt_query->bind_param("iissi",$reset_count,$reset_count,$empty_string,$empty_string,$user_unique_id);
            $login_attempt_query->execute();

            return $login_attempt_query->affected_rows;

        }

        /*
            NAME    : resetUserAttemptCountExceptOptTriedCount
            TYPE    : internal Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function SetUserAccountLocked($user_unique_id)
        {
             //dtabase connection 
             include("../db.php");

             $locked = 1;
             //updated database
             $login_attempt_query = $conn->prepare('UPDATE user_login_status SET is_locked = ? WHERE user_unique_id = ?'); 
             $login_attempt_query->bind_param("ii",$locked,$user_unique_id);
             $login_attempt_query->execute();
 
             return $login_attempt_query->affected_rows;
        }

       
        /*
            NAME    : resetUserResetLoginCount
            TYPE    : internal Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function resetUserResetLoginCount($user_unique_id)
        {
            //dtabase connection 
            include("../db.php");

            $reset_count = 0;
            $empty_string = null;
            //updated database
            $login_attempt_query = $conn->prepare('UPDATE user_reset_login SET otp_sent_count = ?,opt_attempt_count = ?, 
                                                                opt_value = ?,opt_sent_time = ?,reset_attempt_count=? WHERE user_unique_id = ?'); 
            $login_attempt_query->bind_param("iissii",$reset_count,$reset_count,$empty_string,$empty_string,$reset_count,$user_unique_id);
            $login_attempt_query->execute();

            return $login_attempt_query->affected_rows;

        }

        /*
            NAME    : generateOptForFailedAttempt
            TYPE    : internal Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function generateOptForFailedAttempt($digit_count=6)
        {
            $array_of_numbers = range(0,9);
            $array_count = count($array_of_numbers);if($digit_count>=$array_count) { $digit_count=$array_count;}
            shuffle($array_of_numbers);
            return implode('',array_slice($array_of_numbers,0,$digit_count));
        }

        /*
            NAME    : sendOtpForFailedAttempt
            TYPE    : api Utility function 
            DETAILS : 
            RETURN  : 
        */
        public static function sendOtpForFailedAttempt($user_name)
        {
            $response_array = array ("status"=> UserOtpStatus::UNKNOWN,"message"=>"Invalid Username","error"=>"");

            $user_details = DataBaseUtility::getUserIdByUserName($user_name);

            $in_active_response = self::generateResponseIfUserInActive($user_details,UserOtpStatus::IN_ACTIVE);
            if($in_active_response) {return $in_active_response;}

            if($user_details)
            {   
                $user_unique_id = $user_details['userUniqueno'];
               
                $user_login_status_details = UserUtility::getUserLoginStatus($user_unique_id);
                if($user_login_status_details)
                {
                    $user_sent_count = $user_login_status_details['otp_sent_count'];
                    $is_locked = $user_login_status_details['is_locked'];

                    if($is_locked)
                    {
                        $response_array = array ("status"=>UserOtpStatus::ACCOUNT_LOCKED,"message"=>"Account Locked","error"=>"");
                        return $response_array;//break here
                    }

                    if($user_sent_count>UserLoggingConstant::MAX_OTP_SENT_COUNT)
                    {
                        $reason_details = "Account Locked due to request after OTP Sent Limit Excceds";
                        //lock the if not
                        $is_locked = self::LockTheUserAccount($user_unique_id,true,ReasonForUnlockMailSent::OTP_REQUEST_LIMIT_EXCEEDS);
                        $response_array = array ("status"=>UserOtpStatus::ACCOUNT_LOCKED,"message"=>$reason_details,"error"=>"");
                        return $response_array;//break here
                    }

                    if($user_sent_count>=UserLoggingConstant::MAX_OTP_SENT_COUNT)
                    {
                        //reset sent otp 
                        self::updateOtpInUserLoginStatus($user_unique_id,null,null,$user_sent_count);
                        $response_array = array ("status"=>UserOtpStatus::EXCEED_LIMITS,"message"=>"OTP Sent Limit Excceds","error"=>"");
                        return $response_array;//break here
                    }
                }

                $generated_otp = self::generateOptForFailedAttempt(8);
                $user_email = $user_details['email'];
                $mail_subject = "Failed Login Attempt OTP";
                $mail_content  = '<div style="width:100%;background-color: gainsboro;"> 
                                  <div style="margin-left:0px;  margin-top: 0px; height: auto width: 100%;">	
                                  <b>Reset Password!!!</b><br><br>Welcome to the Focuscare 
                                  <br><br>Your OTP is valid for 10 Minutes,your OTP is '.$generated_otp.
                                  '<br><br>Thanks and Regards,<br>Focus Care Team </div></div>';

                if(AppConfig::APP_ENVIRONMENT_TYPE==0)
                {
                        $mail_response =  array("mailStatus"=>'success' , "error"=>$generated_otp);
                }
                else
                {
                        $mail_response = Utility::sendMailTo($user_email,$mail_subject,$mail_content);
                }

                if($mail_response)
                {
                    if($mail_response['mailStatus']=="success")
                    {
                        TimeZone::useTimeZone();
                        $current_date_time  = date('Y-m-d H:i:s');
                        $opt_sent_count =  $user_login_status_details['otp_sent_count'];
                        self::updateOtpInUserLoginStatus($user_unique_id,$generated_otp,$current_date_time,$opt_sent_count);
                        $response_array = array ("status"=>UserOtpStatus::SUCCESS,"message"=>"OTP Sent Successfully","error"=>"");
                    }
                    else
                    {
                        $response_array = array ("status"=>UserOtpStatus::FAILED,"message"=>"OTP Sent Failed","error"=>"mail sending issue");
                    }
                }

            }

            return $response_array;
        }


        /*
            NAME    : sendOptByEmailAndRole
            TYPE    : api Utility function 
            DETAILS : 
            RETURN  : 
        */
        public static function sendOtpByUsername($user_name)
        {
            $user_details = DataBaseUtility::getUserIdByUserName($user_name);

            $in_active_response = self::generateResponseIfUserInActive($user_details,UserOtpStatus::IN_ACTIVE);
            if($in_active_response) {return $in_active_response;}
            
            return self::sendOtpByUserDetails($user_details);
        }

        /*
            NAME    : sendOtpByEmailAndRole
            TYPE    : api Utility function 
            DETAILS : 
            RETURN  : 
        */
        public static function sendOtpByEmailAndRole($user_email,$user_role)
        {
            $user_details = DataBaseUtility::getUserByEmailAndRole($user_email,$user_role);

            $in_active_response = self::generateResponseIfUserInActive($user_details,UserOtpStatus::IN_ACTIVE);
            if($in_active_response) { return $in_active_response;}

            return self::sendOtpByUserDetails($user_details);
        }

        /*
            NAME    : sendOtpByUserDetails
            TYPE    : global Utility function 
            DETAILS : 
            RETURN  : 
        */
        private static function sendOtpByUserDetails($user_details)
        {

            $response_array = array ("status"=> UserOtpStatus::UNKNOWN,"message"=>"Invalid Username","error"=>"");

            if($user_details)
            {   
 
                $user_unique_id = $user_details['userUniqueno'];
                $user_reset_login_details = UserUtility::getUserResetLogin($user_unique_id);

                //if no user reset details
                if($user_reset_login_details==null)
                {
                    if(UserUtility::AddUserResetLogin($user_unique_id))
                    {
                        $user_reset_login_details = UserUtility::getUserResetLogin($user_unique_id);
                    }
                }

                if($user_reset_login_details)
                {
                    $user_otp_sent_count = $user_reset_login_details['otp_sent_count'];
                    $user_otp_attempt_count = $user_reset_login_details['opt_attempt_count'];
                    if($user_otp_sent_count>=UserLoggingConstant::MAX_OTP_SENT_COUNT)
                    {
                        self::LockTheUserAccount($user_unique_id,true,ReasonForUnlockMailSent::OTP_REQUEST_LIMIT_EXCEEDS);//for security reason
                        $response_array = array ("status"=>UserOtpStatus::ACCOUNT_LOCKED,"message"=>"Account Locked due to request after OTP Sent Limit Excceds","error"=>"");                         
                        return $response_array;//break here
                    }
                }
                else
                {
                    //if no user reset login details added
                    $response_array = array ("status"=> UserOtpStatus::FAILED,"message"=>"user not found","error"=>"");
                    return $response_array;
                }
                
                $generated_otp = self::generateOptForFailedAttempt(8);
                $user_email = $user_details['email'];
                $mail_subject = "Failed Login Attempt OTP";
                $mail_content  = '<div style="width:100%;background-color: gainsboro;"> 
                                  <div style="margin-left:0px;  margin-top: 0px; height: auto width: 100%;">	
                                  <b>Reset Password!!!</b><br><br>Welcome to the Focuscare 
                                  <br><br>Your OTP is valid for 10 Minutes,your OTP is '.$generated_otp.
                                  '<br><br>Thanks and Regards,<br> Focus Care Team </div></div>';

                $mail_response = null;
                if(AppConfig::APP_ENVIRONMENT_TYPE==0)
                {
                    $mail_response =  array("mailStatus"=>'success' , "error"=>$generated_otp);
                }
                else
                {
                    $mail_response = Utility::sendMailTo($user_email,$mail_subject,$mail_content);
                }

                if($mail_response)
                {
                    if($mail_response['mailStatus']=="success")
                    {
                        TimeZone::useTimeZone();
                        $current_date_time  = date('Y-m-d H:i:s');
                        $otp_attept_details = self::getOtpResetLoginDetails($user_unique_id);
                        $opt_sent_count =  $otp_attept_details['otp_sent_count'];
                        self::updateOtpInUserResetLogin($user_unique_id,$generated_otp,$current_date_time,$opt_sent_count);
                        $response_array = array ("status"=>UserOtpStatus::SUCCESS,"message"=>"OTP Sent Successfully","error"=>"");
                    }
                    else
                    {
                        $response_array = array ("status"=>UserOtpStatus::FAILED,"message"=>"OTP Sent Failed","error"=>"mail sending issue");
                    }
                }

            }
            else
            {
                $response_array = array ("status"=> UserOtpStatus::FAILED,"message"=>"User not found","error"=>"");
            }

            return $response_array;

        }

        /*
            NAME    : updateOtpInUserLoginStatus
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function updateOtpInUserLoginStatus($user_unique_id,$opt_value,$opt_sent_date,$opt_sent_count)
        {
            //database connection 
            include("../db.php");

                $opt_sent_count+=1;
                if($opt_sent_count>=UserLoggingConstant::MAX_OTP_SENT_COUNT)
                {
                    //$opt_sent_count = UserLoggingConstant::MAX_OTP_SENT_COUNT;
                }
                //updated database
                $login_attempt_query = $conn->prepare('UPDATE user_login_status SET opt_value=?,opt_sent_time = ?,otp_sent_count=? WHERE user_unique_id = ?'); 
                $login_attempt_query->bind_param("ssii",$opt_value,$opt_sent_date,$opt_sent_count,$user_unique_id);
                $login_attempt_query->execute();

            return $login_attempt_query->affected_rows;
        }

         /*
            NAME    : updateOtpInUserResetLogin
            TYPE    : internal Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function updateOtpInUserResetLogin($user_unique_id,$opt_value,$opt_sent_date,$opt_sent_count)
        {
            //database connection 
            include("../db.php");

                $opt_sent_count+=1;
                if($opt_sent_count>=UserLoggingConstant::MAX_OTP_SENT_COUNT)
                {
                    //$opt_sent_count = UserLoggingConstant::MAX_OTP_SENT_COUNT;
                }

                //updated database
                $login_attempt_query = $conn->prepare('UPDATE user_reset_login SET opt_value=?,opt_sent_time =?,otp_sent_count=? WHERE user_unique_id = ?'); 
                $login_attempt_query->bind_param("ssii",$opt_value,$opt_sent_date,$opt_sent_count,$user_unique_id );
                $login_attempt_query->execute();

            return $login_attempt_query->affected_rows;
        }

        /*
            NAME    : updateOptAttemptCount
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function updateOptAttemptCount($user_unique_id,$opt_attempt_count)
        {
            //database connection 
            include("../db.php");

                $opt_attempt_count+=1;
                if($opt_attempt_count>=UserLoggingConstant::MAX_OTP_ATTEMPT_COUNT)
                {
                    //$opt_attempt_count = UserLoggingConstant::MAX_OTP_ATTEMPT_COUNT;
                    //lock the account
                }
                //updated database
                $login_attempt_query = $conn->prepare('UPDATE user_login_status SET opt_attempt_count=? WHERE user_unique_id = ?'); 
                $login_attempt_query->bind_param("ii",$opt_attempt_count,$user_unique_id);
                $login_attempt_query->execute();

            return $login_attempt_query->affected_rows;
        }

        /*
            NAME    : updateResetLoginOtpCount
            TYPE    : internal Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function updateResetLoginOtpCount($user_unique_id,$opt_attempt_count)
        {
            //database connection 
            include("../db.php");

                $opt_attempt_count+=1;
                if($opt_attempt_count>=UserLoggingConstant::MAX_OTP_ATTEMPT_COUNT)
                {
                    //$opt_attempt_count = UserLoggingConstant::MAX_OTP_ATTEMPT_COUNT;
                }
                //updated database
                $login_attempt_query = $conn->prepare('UPDATE user_reset_login SET opt_attempt_count=? WHERE user_unique_id = ?'); 
                $login_attempt_query->bind_param("ii",$opt_attempt_count,$user_unique_id);
                $login_attempt_query->execute();

            return $login_attempt_query->affected_rows;
        }

        /*
            NAME    : updateResetPasswordAttemptCount
            TYPE    : internal Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function updateResetPasswordAttemptCount($user_unique_id,$reset_attempt_count)
        {
            //database connection 
            include("../db.php");
                $reset_attempt_count+=1;
                if($reset_attempt_count>=UserLoggingConstant::MAX_OTP_ATTEMPT_COUNT)
                {
                    //$opt_attempt_count = UserLoggingConstant::MAX_OTP_ATTEMPT_COUNT;
                }
                //updated database
                $login_attempt_query = $conn->prepare('UPDATE user_reset_login SET reset_attempt_count=? WHERE user_unique_id = ?'); 
                $login_attempt_query->bind_param("ii",$reset_attempt_count,$user_unique_id);
                $login_attempt_query->execute();

            return $login_attempt_query->affected_rows;
        }

        /*
            NAME    : validateOtpByFailedAttempt
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function validateOtpByFailedAttempt($user_name,$user_sent_opt_value)
        {
            $user_details = DataBaseUtility::getUserIdByUserName($user_name);

            $in_active_response = self::generateResponseIfUserInActive($user_details,UserOtpStatus::IN_ACTIVE);
            if($in_active_response) {return $in_active_response;}

            return self::validateOptByUserLoginStatusDetails($user_details,$user_sent_opt_value);
        }

        /*
            NAME    : validateOtpByUsername
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function validateOtpByUsername($user_name,$user_sent_opt_value,$is_called_from_reset_password=false)
        {
            $user_details = DataBaseUtility::getUserIdByUserName($user_name);

            $in_active_response = self::generateResponseIfUserInActive($user_details,UserOtpStatus::IN_ACTIVE);
            if($in_active_response) {return $in_active_response;}
            
            return self::validateOtpByUserDetails($user_details,$user_sent_opt_value,$is_called_from_reset_password);
        }

        /*
            NAME    : validateOtpByEmailAndRole
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function validateOtpByEmailAndRole($user_email,$user_role,$user_sent_opt_value)
        {
            $user_details = DataBaseUtility::getUserByEmailAndRole($user_email,$user_role);
            
            $in_active_response = self::generateResponseIfUserInActive($user_details,UserOtpStatus::IN_ACTIVE);
            if($in_active_response) {return $in_active_response;}

            return self::validateOtpByUserDetails($user_details,$user_sent_opt_value);
        }

        /*
            NAME    : validateOptByUserLoginStatusDetails
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function validateOptByUserLoginStatusDetails($user_details,$user_sent_opt_value)
        {
            //database connection 
            include("../db.php");
            $response_array = array ("status"=> UserOtpStatus::UNKNOWN,"message"=>"Invalid Username","error"=>"");
            if($user_details)
            {
                $user_unique_id = $user_details['userUniqueno'];
                TimeZone::useTimeZone();

                $user_login_status_details = UserUtility::getUserLoginStatus($user_unique_id);
                if($user_login_status_details)
                {
                        $user_attempt_count = $user_login_status_details['opt_attempt_count'];
                        $is_locked = $user_login_status_details['is_locked'];

                        if($is_locked)
                        {
                            $response_array = array ("status"=>UserOtpStatus::ACCOUNT_LOCKED,"message"=>"Account Locked","error"=>"");
                            return $response_array;//break here
                        }

                        // try more otp validate for security reason account will be locked
                        if($user_attempt_count>=UserLoggingConstant::MAX_OTP_ATTEMPT_COUNT) 
                        {
                            self::updateOptAttemptCount($user_unique_id,$user_attempt_count);
                            $is_locked = self::LockTheUserAccount($user_unique_id,true,ReasonForUnlockMailSent::OTP_VALIDATION_LIMIT_EXCEEDS);
                            $response_array = array ("status"=>UserOtpStatus::ACCOUNT_LOCKED,"message"=>"Account Locked due to valitate the OTP 
                                            after tried Limit Excceds","error"=>"");
                            return $response_array;//break here
                        }

                        $login_attempt_query = $conn->prepare('SELECT opt_value,opt_sent_time,opt_attempt_count FROM user_login_status WHERE user_unique_id = ?'); 
                        $login_attempt_query->bind_param("i",$user_unique_id);
                        $login_attempt_query->execute();
                        $login_attempt_query_result = $login_attempt_query->get_result();
                        if($login_attempt_query_result)
                        {
                            $user_login_status_details = $login_attempt_query_result->fetch_assoc();
                            if($user_sent_opt_value === $user_login_status_details['opt_value'])
                            {
                                $opt_sent_time = $user_login_status_details['opt_sent_time'];
                                $expire_date_time = date("Y-m-d H:i:s", strtotime($opt_sent_time." +10 minutes"));
                                $current_date_time  = date('Y-m-d H:i:s');
                                if($current_date_time<=$expire_date_time)
                                {
                                    $opt_attempt_count = $user_login_status_details['opt_attempt_count'];
                                    self::updateOptAttemptCount($user_unique_id,$opt_attempt_count);
                                    self::resetUserAttemptCountExceptOptTriedCount($user_unique_id);
                                    $response_array = array ("status"=> UserOtpStatus::SUCCESS,"message"=>"OTP Validated successfully","error"=>"");
                                }
                                else
                                {
                                    $opt_attempt_count = $user_login_status_details['opt_attempt_count'];
                                    self::updateOptAttemptCount($user_unique_id,$opt_attempt_count);
                                    $response_array = array ("status"=> UserOtpStatus::EXPIRED,"message"=>"OTP Expired","error"=>"");
                                }
                            }
                            else
                            {
                                //wrong entered otp need to cleared ?
                                $opt_attempt_count = $user_login_status_details['opt_attempt_count'];
                                self::updateOptAttemptCount($user_unique_id,$opt_attempt_count);
                                $response_array = array ("status"=>UserOtpStatus::INVALID,"message"=>"OTP Validation Failed","error"=>"Invalid Otp");
                            }
                        }
                        else
                        {
                            $response_array = array ("status"=> UserOtpStatus::FAILED,"message"=>"OTP Validation Failed","error"=>"Invalid Username");
                        }
                }
            }

            return $response_array;

        }

        /*
            NAME    : validateOtpByUserDetails
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function validateOtpByUserDetails($user_details,$user_sent_opt_value,$is_called_from_reset_password=false)
        {
            //database connection 
            include("../db.php");
            $response_array = array ("status"=> UserOtpStatus::UNKNOWN,"message"=>"Invalid Username","error"=>"");

            if($user_details)
            {
                $user_unique_id = $user_details['userUniqueno'];
                TimeZone::useTimeZone();

                $login_attempt_query = $conn->prepare('SELECT opt_value,opt_sent_time,opt_attempt_count FROM user_reset_login WHERE user_unique_id = ?'); 
                $login_attempt_query->bind_param("i",$user_unique_id);
                $login_attempt_query->execute();
                $login_attempt_query_result = $login_attempt_query->get_result();
                if($login_attempt_query_result)
                {
                    $user_reset_login_details = $login_attempt_query_result->fetch_assoc();
                    if($user_reset_login_details)
                    {   
                        $user_attempt_count = $user_reset_login_details['opt_attempt_count'];
                        if($user_attempt_count>=UserLoggingConstant::MAX_FORGET_PASSWORD_OTP_ATTEMPT_COUNT)
                        {
                            //lock the if not
                            self::LockTheUserAccount($user_unique_id,true,ReasonForUnlockMailSent::OTP_VALIDATION_LIMIT_EXCEEDS);
                            $response_array = array ("status"=>UserOtpStatus::ACCOUNT_LOCKED,"message"=>"Account Locked due to validate the OTP Tried Limit Excceds","error"=>"");
                            return $response_array;//break here
                        }

                        $opt_attempt_count = $user_reset_login_details['opt_attempt_count'];
                        if($is_called_from_reset_password==false)
                        {
                            self::updateResetLoginOtpCount($user_unique_id,$opt_attempt_count);
                        }

                        if($user_sent_opt_value === $user_reset_login_details['opt_value'])
                        {
                            $opt_sent_time = $user_reset_login_details['opt_sent_time'];
                            $expire_date_time = date("Y-m-d H:i:s", strtotime($opt_sent_time." +10 minutes"));
                            $current_date_time  = date('Y-m-d H:i:s');
                            if($current_date_time<=$expire_date_time)
                            {
                                $response_array = array ("status"=> UserOtpStatus::SUCCESS,"message"=>"OTP Validated successfully","error"=>"");
                            }
                            else
                            {
                                $response_array = array ("status"=> UserOtpStatus::EXPIRED,"message"=>"OTP Expired","error"=>"");
                            }
                        }
                        else
                        {
                            //wrong entered otp need to cleared ?
                            $response_array = array ("status"=>UserOtpStatus::INVALID,"message"=>"OTP Validation Failed","error"=>"Invalid Otp");
                        }
                    }
                }
                else
                {
                    $response_array = array ("status"=> UserOtpStatus::FAILED,"message"=>"OTP Validation Failed","error"=>"Invalid Username");
                }
            }
            else
            {
                $response_array = array ("status"=> UserOtpStatus::FAILED,"message"=>"User not found","error"=>"");
            }
            return $response_array;

        }
        

        /*
            NAME    : getUserRolesByEmail
            TYPE    : api Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function getUserRolesByEmail($user_email)
        {
            $user_details = DataBaseUtility::getUsersByEmail($user_email);
            if($user_details)
            {
                return array_column($user_details,'type');
            }

            return null;
        }

        /*
            NAME    : resetPasswordByUsername
            TYPE    : api Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function resetPasswordByUsername()
        {

            $request_data = Utility::parseRequestBodyFormat();

            $user_name = $request_data['username'];
            $new_password = $request_data['new_password'];
            $confirm_password = $request_data['confirm_password'];
            $user_sent_opt_value = $request_data['otp'];

            $user_details = DataBaseUtility::getUserIdByUserName($user_name);

            $in_active_response = self::generateResponseIfUserInActive($user_details,UserResetPasswordStatus::IN_ACTIVE);
            if($in_active_response) {return $in_active_response;}

            if($user_details)
            {
                $user_unique_id = $user_details['userUniqueno'];
                return self::resetPassword($user_name,$user_unique_id,$new_password,$confirm_password,$user_sent_opt_value);
            }

            return  array ("status"=> UserResetPasswordStatus::FAILED,"message"=>"User not found","error"=>"");

        }

        /*
            NAME    : resetPasswordByEmailAndRole
            TYPE    : api Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function resetPasswordByEmailAndRole()
        {
            $request_data = Utility::parseRequestBodyFormat();

            $user_email = $request_data['email'];
            $user_role = $request_data['role'];
            $new_password = $request_data['new_password'];
            $confirm_password = $request_data['confirm_password'];
            $user_sent_opt_value = $request_data['otp'];

            $user_details = DataBaseUtility::getUserByEmailAndRole($user_email,$user_role);

            $in_active_response = self::generateResponseIfUserInActive($user_details,UserResetPasswordStatus::IN_ACTIVE);
            if($in_active_response) {return $in_active_response;}
            
            if($user_details)
            {
                $user_name = $user_details['username'];
                $user_unique_id = $user_details['userUniqueno'];
                return self::resetPassword($user_name,$user_unique_id,$new_password,$confirm_password,$user_sent_opt_value);
            }

            return array ("status"=> UserResetPasswordStatus::FAILED,"message"=>"User not found","error"=>"");
        }

        /*
            NAME    : resetPassword
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function resetPassword($user_name,$user_unique_id,$new_password,$confirm_password,$user_sent_opt_value)
        {
            //database connection 
            include("../db.php");

            $response_array = array ("status"=> UserResetPasswordStatus::UNKNOWN,"message"=>"","error"=>"");

            $user_reset_login_details = self::getUserResetLogin($user_unique_id);
            if($user_reset_login_details)
            {
                $reset_attempt_count =  $user_reset_login_details['reset_attempt_count'];

                if($reset_attempt_count>=UserLoggingConstant::MAX_FORGET_PASSWORD_RESET_ATTEMPT_COUNT)
                {
                    self::LockTheUserAccount($user_unique_id,true,ReasonForUnlockMailSent::OTP_VALIDATION_LIMIT_EXCEEDS);
                    $response_array = array ("status"=>UserResetPasswordStatus::ACCOUNT_LOCKED,
                                    "message"=>"Account Locked due to reset OTP validation tried limits exceeds",
                                    "error"=>$opt_validation_error);
                    return $response_array;
                }

                self::updateResetPasswordAttemptCount($user_unique_id,$reset_attempt_count);
            }

            $opt_validation_response = self::validateOtpByUsername($user_name,$user_sent_opt_value,true);
            if($opt_validation_response)
            {   
               
                $opt_validation_status = $opt_validation_response['status'];
                $opt_validation_message = $opt_validation_response['message'];
                $opt_validation_error = $opt_validation_response['error'];
                switch($opt_validation_status)
                {
                   
                    case UserOtpStatus::SUCCESS:
                        //updated password
                        if(strcmp($new_password,$confirm_password)===0)
                        {
                            //if both the passwords are same
                            if(DataBaseUtility::resetUserPassword($user_name,$new_password))
                            {
                                //clear login status and reset login details to login properly
                                self::resetUserAttemptCount($user_unique_id);
                                self::resetUserResetLoginCount($user_unique_id);
                                $response_array = array ("status"=> UserResetPasswordStatus::SUCCESS,
                                                "message"=>"new password changed successfully","error"=>" ");
                            }
                            else
                            {
                                $response_array = array ("status"=> UserResetPasswordStatus::FAILED,
                                         "message"=>"Password Update Failed","error"=>"Database update failed");
                            }

                        }
                        else
                        {
                            $response_array = array ("status"=> UserResetPasswordStatus::PASSWORD_MISMATCH,
                                            "message"=>"password mismatch found ","error"=>"");
                        }
                    break;

                    case UserOtpStatus::EXPIRED:
                        $response_array = array ("status"=> UserResetPasswordStatus::OPT_EXPIRED,
                                        "message"=>$opt_validation_message,"error"=>$opt_validation_error);
                    break;

                    case UserOtpStatus::INVALID:
                        $response_array = array ("status"=> UserResetPasswordStatus::OPT_INVALID,
                                        "message"=>$opt_validation_message,"error"=>$opt_validation_error);
                    break;

                    case UserOtpStatus::ACCOUNT_LOCKED:
                        $response_array = array ("status"=> UserResetPasswordStatus::ACCOUNT_LOCKED,
                                        "message"=>$opt_validation_message,"error"=>$opt_validation_error);
                    break;

                    case UserOtpStatus::FAILED:
                        $response_array = array ("status"=> UserResetPasswordStatus::FAILED,
                                         "message"=>$opt_validation_message,"error"=>$opt_validation_error);
                    break;
                }
                
            }

            return $response_array;
        }

}

/*
    USER LOGGIN STATUS
*/
class UserLoggingConstant
{
    const MAX_LOGIN_ATTEMPT_COUNT = 3;

    const MAX_OTP_SENT_COUNT = 3;

    const MAX_OTP_ATTEMPT_COUNT = 3;

    const MAX_FORGET_PASSWORD_OTP_ATTEMPT_COUNT = 3;

    const MAX_FORGET_PASSWORD_RESET_ATTEMPT_COUNT = 3;

    const MAX_LOGIN_HISTORY_COUNT = 10;
}

/*
    USER ROLES 
*/
class UserRoleConstant
{
    const ADMIN = 'admin';
    const NURSE = 'nurse';
    const QA = 'qa';
    const QA_LEAD = 'qa_lead';
    const CODER = 'coder';
    const CODER_LEAD = 'coder_lead';
    const SCHEDULER = 'scheduler';
    const SCHEDULER_LEAD ='scheduler_lead';
}

/*
    USER LOGGIN STATUS
*/
class UserLoggingStatus
{
    const UNKNOWN = -1;
    const FAILED = 0; //invalid username 
    const SUCCESS = 1;
    const IN_VAILD_CREDENTIALS = 2; //password error
    const IN_ACTIVE = 3; //user diasbled by admin
    const ATTEMPT_REACHED=4; //already tried 3 attempt count
    const ACCOUNT_LOCKED=5; //after this state admin can unlock the account
}

/*
    USER OTP STATUS
*/
class UserOtpStatus
{
    const UNKNOWN = -1;
    const FAILED = 0;
    const SUCCESS = 1; 
    const EXPIRED = 2; //opt expired
    const INVALID = 3; //ivalid opt
    const EXCEED_LIMITS=4; //otp send limit exceed
    const ACCOUNT_LOCKED=5;//opt attempt try exceeds
    const IN_ACTIVE = 6; //user diasbled by admin
}

/*
    USER REGISTER STATUS
*/
class UserRegisterStatus
{
    const UNKNOWN = -1;
    const FAILED = 0;
    const SUCCESS = 1;
    const USER_NAME_AVAILABLE = 2;
    const EMAIL_ALREADY_FOR_ROLE = 3;
}

/*
    USER RESET PASSWORD STATUS
*/
class UserResetPasswordStatus
{
    const UNKNOWN = -1;
    const FAILED = 0;
    const SUCCESS = 1;
    const OPT_EXPIRED = 2;
    const OPT_INVALID = 3;
    const PASSWORD_MISMATCH = 4;
    const ACCOUNT_LOCKED = 5;
    const IN_ACTIVE = 6; //user diasbled by admin

}

/*
    USER REGISTER RELATED CONSTANT
*/
class UserRegisterConstant
{
    const MAX_REGISTRATION_TRY_COUNT = 5;
}

?>