<?php

    /*
        MEMBER RELATED UTILTIY FUNCTION
    */

    //other include files
    require_once("../utility/FileIOUtility.php");
    require_once("ClientUtility.php");
    require_once("../utility/ArrayUtility.php");
    require_once("../utility/DataBaseUtility.php");
    require_once("../utility/StringUtility.php");
    require_once("../TimeZone.php");

    class ClientUtility
    {

         /*
            NAME    : OnClientAdded
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function OnClientAdded()
        {
            //datatbase connection
            include("../db.php");

            $response = new stdClass();
            $response->error ="";
            $response->message="";

			//convert request format as array
            $client_request_array = Utility::parseRequestBodyFormat();

            $plan_name = $client_request_array['data']['plan'];
            $program_name = $client_request_array['data']['program'];
            $client_name = $client_request_array['data']['client_name'];
            $health_plan_name = $client_request_array['data']['healthPlanName'];

            $client_id = $client_request_array['data']['clientId'];
            $client_info_array = $client_request_array['data']['clientInfo'];
            $client_info = json_encode($client_info_array);

            //year is in array format "year":[2019,2020,2021]
            $client_year_list = $client_request_array['data']['year']; 
            $client_year=ArrayUtility::getArrayLast($client_year_list);
            $client_year_string = ArrayUtility::convertArrayToString($client_year_list);
            //prepare sql query for client already available check
            $client_details=DataBaseUtility::IsClientAvaiable($plan_name,$program_name,$client_id);

                if($client_details)
                {
                    $response->status = "clientExists";
                    $response->error = "database";
                    $response->message="plan and program or client id is already present";
                }
                else
                {
                    TimeZone::useTimeZone();
                    $created_on = date('Y-m-d h:i:s');
                    $updated_on = date('Y-m-d h:i:s');

                    $table_status = DataBaseUtility::isTableAvailable($client_id,$client_year);
                    if ($table_status) 
                    {
                        $response->status = "clientExists";
                        $response->error ="database";
                        $response->message="client table already present";
                    }
                    else
                    {
                        $table_status=DataBaseUtility::CreateMemberTable($client_id,$client_year);
                        if($table_status)
                        {
                            //year string will be remove in future
                            $client_insert_affected_rows=DataBaseUtility::InsertNewClient($plan_name,$program_name,$client_name,$health_plan_name,$client_id,$client_year_string,$client_info,$created_on,$updated_on);
                            if($client_insert_affected_rows)
                            {
                                $is_client_year_added = DataBaseUtility::AddNewClientYear($client_id,$client_year);
                                $is_folders_created = FileIOUtility::CreateFoldersWhenClientAdded($client_id,$client_year);
                                //response
                                $response->status = "success";
							    $response->tableStatus = true;
                                $response->yearStatus = $is_client_year_added;
                                $response->folderStatus = $is_folders_created; 
                            }
                            else
                            {
                                 //response
							    $response->status = "notsuccess";
							    $response->tableStatus = false;
                                $response->yearStatus = false;
                                $response->folderStatus = false;
                            }
 
                        }
                    }
                }

            echo json_encode($response);

        }

        /*
            NAME    : OnClientYearAdded
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function OnClientYearAdded()
        {
            //datatbase connection
            include("../db.php");

            //convert request format as array
            $client_request_array = Utility::parseRequestBodyFormat();

            $plan_name = $client_request_array['data']['plan'];
            $program_name = $client_request_array['data']['program'];
            $client_id = $client_request_array['data']['clientId'];
		    $client_name = $client_request_array['data']['client_name'];//may be used for display name
            $health_plan_name =  $client_request_array['data']['healthPlanName'];
		    $client_year_list = $client_request_array['data']['year']; //array of year=[2019,2020,2021]
            $client_year=ArrayUtility::getArrayLast($client_year_list);
            $client_year_string = ArrayUtility::convertArrayToString($client_year_list);

            $client_info = $client_request_array['data']['clientInfo'];
		    $json_client_info = json_encode($client_info);
		
            $response = new stdClass();
            $response->status = "notsuccess";
			$response->tableStatus = false;
            $response->error ="";
            $response->message="";

            TimeZone::useTimeZone();
            $updated_on = date('Y-m-d h:i:s');

            if(DataBaseUtility::IsClientYearAvailable($client_id,$client_year)==null)
            {

               $is_client_year_added = DataBaseUtility::AddNewClientYear($client_id,$client_year);
               if($is_client_year_added)
               {
                    $is_table_available = DataBaseUtility::isTableAvailable($client_id,$client_year);
                    if($is_table_available==false)
                    {
                        $table_status=DataBaseUtility::CreateMemberTable($client_id,$client_year);
                        if($table_status)
                        {
                            //update user info
                            $affected_rows=DataBaseUtility::updateClient($plan_name,$program_name,$client_name,$health_plan_name,$client_id,$client_year_string,$json_client_info,$updated_on);
                            $is_folders_created = FileIOUtility::CreateFoldersWhenClientAdded($client_id,$client_year);
                            //response
                            $response->status = "success";
                            $response->tableStatus = true;
                            $response->folderStatus = $is_folders_created; 
                        }
                        else
                        {
                            $response->status = "notsuccess";
                            $response->tableStatus = false;
                            $response->folderStatus = false; 
                        }
                    }
                    else
                    {
                        $response->status = "success";
                        $response->tableStatus = true;
                        $response->folderStatus = true;
                    }
               }
               else
               {
                    $response->status = "notsuccess";
                    $response->tableStatus = DataBaseUtility::isTableAvailable($client_id,$client_year);
                    $response->error ="database";
                    $response->message="error creating client year";
               }
            }
            else
            {
                $response->status = "notsuccess";
                $response->tableStatus = DataBaseUtility::isTableAvailable($client_id,$client_year);
                $response->error ="database";
                $response->message="client year already avaialble";
            }

            echo json_encode($response);
            
        }

        /*
            NAME    : OnClientDetailsUpdated
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function OnClientDetailsUpdated()
        {
            //datatbase connection
            include("../db.php");

            //convert request format as array
            $client_request_array = Utility::parseRequestBodyFormat();

            $response = new stdClass();
            $response->status = "notsuccess";
            $response->message= "";

            $plan_name = $client_request_array['data']['plan'];
            $program_name = $client_request_array['data']['program'];

            $client_id = $client_request_array['data']['clientId'];
            $client_name = $client_request_array['data']['client_name'];
            $health_plan_name = $client_request_array['data']['healthPlanName'];

            $client_info_array = $client_request_array['data']['clientInfo'];
            $client_info = json_encode($client_info_array);

            TimeZone::useTimeZone();
            $updated_on = date('Y-m-d h:i:s');

            $affected_rows=DataBaseUtility::updateClientWithoutYear($plan_name,$program_name,$client_name,$health_plan_name,$client_id,$client_info,$updated_on);
            
            if($affected_rows)
            {
				$response->status = "success";
            }
            else
            {
                $response->status = "notsuccess";
            }

            echo json_encode($response);
        }

         /*
            NAME    : getTotalClientRows
            TYPE    : global utility api function 
            DETAILS : with out client format for add and edit client listing
            RETURN  : 
        */
        public static function getTotalClientRows()
        {
                //database connation
                include("../db.php");
    
                $client_list_query=$conn->prepare('SELECT plan,program,client_name,health_plan_name,clientId,clientInfo,createdon,updatedon from HRA_client');
                $client_list_query->execute();
                $client_list_query_result = $client_list_query->get_result();

                while($client_detail_row=$client_list_query_result->fetch_assoc())
                {
                    $client_detail_row['year'] = DataBaseUtility::getClientYears($client_detail_row['clientId']);
                    $client_detail_row['healthPlanName']=StringUtility::toEmptyStringIfNull($client_detail_row['health_plan_name']);
                    unset($client_detail_row['health_plan_name']);
                    $client_detail_row['clientInfo'] = json_decode($client_detail_row['clientInfo']);
                    $client_list_array[] = $client_detail_row;
                }

                return $client_list_array;
        }

        /*
            NAME    : getTotalClientList
            TYPE    : global utility api function 
            DETAILS : 
            RETURN  : 
        */
        public static function getTotalClientList()
        {
                //database connation
                include("../db.php");
    
                $client_list_query=$conn->prepare('SELECT plan,plan_type,clientId,program,client_name,health_plan_name from HRA_client');
                $client_list_query->execute();
                $client_list_query_result = $client_list_query->get_result();

                $client_default_json = '{ "plan":[] }';
                $client_list_array = json_decode($client_default_json,true);

                while($client_detail_row=$client_list_query_result->fetch_assoc())
                {
                    $plan = $client_detail_row['plan'];
                    $plan_type = $client_detail_row['plan_type'];
                    $program = $client_detail_row['program'];

                    $client_details = ClientUtility::generateSimpleClientArrayDetails($client_detail_row);
                    $client_id=$client_details['clientId'];
                    $client_year = DataBaseUtility::getClientYears($client_id);
                    //find plan name already available or not
                    $plan_result = ArrayUtility::compareArrayKeyValue($client_list_array['plan'],'name',$plan);

                    if($plan_result["result"])
                    {
                            $plc = $plan_result["index"];
                        
                            $this_program_array = $client_list_array['plan'][$plc]['program'];
                            $program_found_result = ArrayUtility::compareArrayKeyValue($this_program_array,'name',$program);
                            if($program_found_result["result"])
                            {
                                $program_index = $program_found_result["index"];
                                $this_program_array[$program_index][]=array("client_name"=>$client_details['client_name'],
                                                                            "clientId"=>$client_details['clientId'],
                                                                            "healthPlanName"=>$client_details['health_plan_name'],
                                                                            "year"=>$client_year);                                          
                            }
                            else
                            {
                                $client_list_array['plan'][$plc]['program'][]=array("name"=>$program,
                                                                            "client_name"=>$client_details['client_name'],
                                                                            "clientId"=>$client_details['clientId'],
                                                                            "healthPlanName"=>$client_details['health_plan_name'],
                                                                            "year"=>$client_year);                         
                            }
                        
                    }
                    else
                    {	
                        $plan_array = array('name'=>$plan,'planType'=>$plan_type,'program'=>array(
                                                                    array("name"=>$program,
                                                                    "client_name"=>$client_details['client_name'],
                                                                    "clientId"=>$client_details['clientId'],
                                                                    "healthPlanName"=>$client_details['health_plan_name'],
                                                                    "year"=>$client_year)));                                                                                   
                        $client_list_array['plan'][]=$plan_array;
                    }

                }

                return $client_list_array;
        }

        /*
            NAME    : getUserClientsList
            TYPE    : global api function 
            DETAILS : 
            RETURN  : 
        */
        public static function getUserClientList($user_unique_id)
        {
            //database connation
            include("../db.php");

            //get the user client privileges
            $client_privileges_json = DataBaseUtility::IsUserPrivilegeAvailable($user_unique_id,'client_privileges');
            $client_privilege_array = json_decode($client_privileges_json,true);
            
            //get the total client list 
            $client_list_query=$conn->prepare('SELECT * from HRA_client');
            $client_list_query->execute();
            $client_list_query_result = $client_list_query->get_result();

            $client_list_count = $client_list_query_result->num_rows;

            if($client_list_count != 0)
            {
                $client_default_json = '{ "plan":[] }';
                $client_list_array = json_decode($client_default_json,true);

                while($client_detail_row=$client_list_query_result->fetch_assoc())
                {
                    $client_unique_id = $client_detail_row['clientId'];
                    //if client privilege not set or specific client access privilegs
                    if($client_privilege_array == null ||  in_array($client_unique_id,$client_privilege_array['clients']))
                    {

                        $plan = $client_detail_row['plan'];
                        $plan_type = $client_detail_row['plan_type'];
                        $program = $client_detail_row['program'];
                       
                        $client_details = ClientUtility::generateClientArrayDetails($client_detail_row);
                        //find plan name already available or not
                        $plan_result = ArrayUtility::compareArrayKeyValue($client_list_array['plan'],'name',$plan);

                        if($plan_result["result"])
                        {
                                $plc = $plan_result["index"];
                            
                                $this_program_array = $client_list_array['plan'][$plc]['program'];
                                $program_found_result = ArrayUtility::compareArrayKeyValue($this_program_array,'name',$program);
                                if($program_found_result["result"])
                                {
                                    $program_index = $program_found_result["index"];
                                    $this_program_array[$program_index][]=array("name"=>$program,"clientDetails"=>$client_details);
                                }
                                else
                                {
                                    $client_list_array['plan'][$plc]['program'][]=array("name"=>$program,"clientDetails"=>$client_details);                                                
                                }
                            
                        }
                        else
                        {	
                            $plan_array = array('name'=>$plan,'planType'=>$plan_type,'program'=>array(array("name"=>$program,"clientDetails"=>$client_details)));                    
                            $client_list_array['plan'][]=$plan_array;
                        }

                    }

                }

                echo json_encode($client_list_array);
            }
            else
            {
                $response = new stdClass();
                $response->status = 'noRecords';
                $response = json_encode($response);
                echo $response;	
            }
            
        }
        
        /*
            NAME    : generateClientArrayDetails
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function generateClientArrayDetails($client_detail_row)
        {

                $client_name = $client_detail_row['client_name'];
                $health_plan_name = StringUtility::toEmptyStringIfNull($client_detail_row['health_plan_name']);
				$year = $client_detail_row['year'];
				$client_id = $client_detail_row['clientId'];
				$client_info = $client_detail_row['clientInfo'];
				$client_info_array = json_decode($client_info,true);
                //get the year list
				$year_list_array = DataBaseUtility::getClientYears($client_id);
                //lob details
                $lob_details = self::generateClientYearLobDetails($client_id,$year_list_array);

				return array(
					"client_name"=>$client_name,
                    "healthPlanName"=>$health_plan_name,
                    "clientId"=>$client_id,
					"year"=>$year_list_array,
					"clientInfo"=>$client_info_array,
                    "lob"=>$lob_details
                    );

        }

         /*
            NAME    : generateClientYearLobDetails
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function generateClientYearLobDetails($client_id,$year_list)
        {
            $lob_details = [];
            $year_count = count($year_list);
            for($yidx=0;$yidx<$year_count;$yidx++)
            {
                $year = $year_list[$yidx];
                $lob_array=DataBaseUtility::getClientYearLobs($client_id,$year);
                $lob_details[]=array("year"=>$year,"details"=>$lob_array);
            }

            return $lob_details;
        }

        /*
            NAME    : generateSimpleClientArrayDetails
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function generateSimpleClientArrayDetails($client_detail_row)
        {
                $client_name = $client_detail_row['client_name'];
				$client_id = $client_detail_row['clientId'];
                $health_plan_name = $client_detail_row['health_plan_name'];

				return array(
					"client_name"=>$client_name,
                    "health_plan_name"=>$health_plan_name==null?"":$health_plan_name,
					"clientId"=>$client_id
                );

        }

        /*
            NAME    : getGlobalYearList
            TYPE    : global Utiltiy function 
            DETAILS : get the year list based on client privileges
            RETURN  : 
        */
        public static function getGlobalYearList($user_id)
        {
            //database connection
            include("../db.php");
            //get user client privilege
            if(DataBaseUtility::getUserById($user_id))
            {

                $user_client_array=DataBaseUtility::getUserClientPrivilege($user_id);
                if($user_client_array==null) //privilege not set
                {
                    $user_client_array=DataBaseUtility::getClientIdList();
                }
                $user_in_client_string=ArrayUtility::convertArrayToString($user_client_array,",");
                $user_in_client_string=StringUtility::splitAndJoinWith($user_in_client_string,',',',',true);
                if($user_in_client_string)
                {
                    $user_global_year_query=$conn->prepare('SELECT DISTINCT year FROM hra_client_year_details where client_id IN('.$user_in_client_string.')');
                    $user_global_year_query->execute();
                    $user_global_year_query_result = $user_global_year_query->get_result();
                    $user_year_details = null;
                    while ($year_result_row = $user_global_year_query_result->fetch_assoc()) 
                    {
                        $user_year_details[]=$year_result_row['year'];
                    }
                    return $user_year_details;
                }
            }

             return null;

        }


        /*
            NAME    : getGlobalUserClientList
            TYPE    : global Utiltiy function 
            DETAILS : get the user client list of  plan and years based on client privileges
            RETURN  : 
        */
        public static function getGlobalUserClientList($user_id)
        {
            //database connection
            include("../db.php");
            //get user client privilege
            if(DataBaseUtility::getUserById($user_id))
            {

                $user_client_array=DataBaseUtility::getUserClientPrivilege($user_id);
                if($user_client_array==null) //privilege not set
                {
                    $user_client_array=DataBaseUtility::getClientIdList();
                }

                $user_in_client_string=ArrayUtility::convertArrayToString($user_client_array,",");
                $user_in_client_string=StringUtility::splitAndJoinWith($user_in_client_string,',',',',true);
                if($user_in_client_string)
                {
                    $user_global_year_query=$conn->prepare('SELECT 
                            DISTINCT client_table.plan,client_year_table.year
                            FROM
                            (SELECT 
                                *
                                FROM
                                    HRA_client
                                WHERE clientId IN ('.$user_in_client_string.') 
                            ) AS client_table
                            LEFT JOIN hra_client_year_details AS client_year_table ON client_year_table.client_id = client_table.clientId');
                            

                    $user_global_year_query->execute();
                    $user_global_year_query_result = $user_global_year_query->get_result();

                    $user_client_year_details_format = '{ "plan":[] }';
                    $user_client_year_details = json_decode($user_client_year_details_format,true);

                    while ($user_client_year_row = $user_global_year_query_result->fetch_assoc()) 
                    {
                        $client_plan = $user_client_year_row['plan'];
                        $plan_result = ArrayUtility::compareArrayKeyValue($user_client_year_details['plan'],'name',$client_plan);
                        if($plan_result["result"])
                        {
                            $plan_index = $plan_result["index"];
                            $user_client_year_details['plan'][$plan_index]['year'][]=$user_client_year_row['year']; 
                        }
                        else
                        {	
                            $plan_year_array = array('name'=>$client_plan,'year'=>array($user_client_year_row['year']));                    
                            $user_client_year_details['plan'][]=$plan_year_array;
                        }
                        
                    }

                    return $user_client_year_details;
                }
            }

             return null;

        }


        /*
            NAME    : getClientIdList
            TYPE    : global utility api function 
            DETAILS : get client id list which is used for filter drop down or any other list
            RETURN  : 
        */
        public static function getClientIdList($user_id)
        {
                //database connation
                include("../db.php");
                if(DataBaseUtility::getUserById($user_id))
                {
    
                    $client_list_query=$conn->prepare('SELECT plan,program,clientId,health_plan_name from HRA_client');
                    $client_list_query->execute();
                    $client_list_query_result = $client_list_query->get_result();

                    $logged_user_clients = DataBaseUtility::getUserClientPrivilege($user_id);
                    if($logged_user_clients==null) { $logged_user_clients=DataBaseUtility::getClientIdList(); }

                    while($client_detail_row=$client_list_query_result->fetch_assoc())
                    {
                        $client_id = $client_detail_row['clientId'];
                        if(in_array($client_id,$logged_user_clients))
                        {
                            $program_name = $client_detail_row['program'];
 			    $health_plan_name = $client_detail_row['health_plan_name'];
                            $client_name = $client_detail_row['plan'].'-'.$program_name;
                            if($program_name=='none') {  $client_name = $client_detail_row['plan'];}
                            $client_list_array[] = array("clientId"=>$client_detail_row['clientId'],"clientName"=>$client_name,"health_plan_name"=>$health_plan_name);
                        }
                    }

                    return $client_list_array;
                }

            return  null;
        }

        /*
            NAME    : getClientProgarm
            TYPE    : global utility api function 
            DETAILS : get all program associate with plan and user and year selected
            RETURN  : 
        */
        public static function getClientProgarm($plan_id,$user_id,$year)
        {   

            //database connection
            include("../db.php");
            $plan_details=DataBaseUtility::IsPlanAvailable($plan_id);
            if($plan_details==null)
            {
                return FALSE;//in valid plan name ,not found
            }

            $user_details = DataBaseUtility::getUserById($user_id);
            if($user_details==null)
            {
                return FALSE;//in valid user id ,not found
            }

            $user_clients=DataBaseUtility::getUserClientPrivilegeByPlan($plan_id,$user_id);
            if($user_clients==null)
            {
                $user_clients = DataBaseUtility::getClientIdListByPlan($plan_id);
            }

            $combine_member_query = FALSE;
            $member_program_details=[];
            $client_list_count = count($user_clients);
            for($cl=0;$cl<$client_list_count;$cl++)
            {
                $client_id = $user_clients[$cl];
                $client_year_array = DataBaseUtility::getClientYears($client_id);
                if($client_year_array && is_array($client_year_array) && in_array($year,$client_year_array))
                {
                    $combine_member_query[]="SELECT UPPER(JSON_UNQUOTE(
                                                    JSON_EXTRACT(memberinfo, '$.Program')
                                                )) AS member_program FROM HRA_member_".$user_clients[$cl]."_".$year;
                }
            }

            if($combine_member_query && is_array($combine_member_query))
            {
                $combine_member_query = implode(" UNION ALL ", $combine_member_query);
            }
            
            if($combine_member_query)
            {
                $member_program_query=$conn->prepare('SELECT DISTINCT member_program FROM ('.$combine_member_query.') AS member_table WHERE member_program IS NOT NULL ORDER BY member_program');
                $member_program_query->execute();
                $member_program_result = $member_program_query->get_result();
                while ($program_row = $member_program_result->fetch_assoc()) {
                    $member_program_details[]=$program_row['member_program'];
                }
                
                return $member_program_details;
            }

            return FALSE;
         }

         
    }
?>