<?php

/*
	GLOBAL CLEINT API 
	Created On : 08/18/2021
*/

//access control allow Header 
include("../AccessControlAllowHeader.php");

//other include files
require_once("../utility/JwtUtility.php");
require_once("../utility/ResponseUtility.php");
require_once("../TimeZone.php");

require_once("../utility/DataBaseUtility.php");
require_once("../auth/UserUtility.php");
require_once("../client/ClientUtility.php");

//validate token
$token_validation_result = JwtUtility::isValidToken();
if($token_validation_result !== JwtUtility::VALID_TOKEN)
{     
	//un authorized access 
    JwtUtility::exitWithUnAuthorizedResponse($token_validation_result);
}
//end of token validation

//parse the request 
$method = $_SERVER['REQUEST_METHOD'];
$requestedurl = $_SERVER['REQUEST_URI'];
$arrayurlstring = explode("/",$requestedurl);
$crcount = count($arrayurlstring);
$crcountt = $crcount -1;
$requestMethod = $arrayurlstring[$crcountt];
$exploded = explode("?",$requestMethod);
$requestMethod = $exploded[0];

  switch ($method) 
  {

        case 'POST':
            switch($requestMethod)
            {
                               
            }
        break;

	   case 'GET' :
            switch($requestMethod)
            {
                case 'lobs':
		    $planId = $_GET['planId'];
                    $unique_lob_list = DataBaseUtility::getAllLobs($planId);
                    echo ResponseUtility::responseArrayAsJson(true,"lob list",$unique_lob_list);
                break;

                case 'lobslistbyyear' :
                    $planId = $_GET['planId'];
                    $year = $_GET['year'];
                    $unique_lob_list = DataBaseUtility::getAllLobsListByYear($planId,$year);
                    echo ResponseUtility::responseArrayAsJson(true,"lob list",$unique_lob_list);
                break;



                case 'clientIdList':
                    $user_id = $_GET['userId'];
                    $client_list=ClientUtility::getClientIdList($user_id);
                    if($client_list) { echo ResponseUtility::responseArrayAsJson(true,"client list",$client_list); } else { echo ResponseUtility::responseArrayAsJson(false,"error getting data",$client_list);}
                break;

                case 'clientIdListByPlan':
                    $plan_name = $_GET['planId'];
                    $client_list=DataBaseUtility::getClientIdListByPlan($plan_name);
                    if($client_list) { echo ResponseUtility::responseArrayAsJson(true,"client list",$client_list); } else { echo ResponseUtility::responseArrayAsJson(false,"error getting data",$client_list);}
                break;

                case 'userClientsList':
                    $user_id =  $_GET['userId'];
                    $client_plan_list=ClientUtility::getGlobalUserClientList($user_id);
                    if($client_plan_list)
                    {
                        $client_plan_list['status']=true;
                        $client_plan_list['message']="client plan year list";
                    }
                    else
                    {
                        $client_plan_list['status']=false;
                        $client_plan_list['message']="error getting client plan year list";
                        $client_plan_list['plan']=null;
                    }
		            echo json_encode($client_plan_list);
                break;

                case 'userProgramList':
                    $plan_id =  $_GET['planId'];
                    $user_id =  $_GET['userId'];
                    $year = $_GET['year'];
                    $user_program_list=ClientUtility::getClientProgarm($plan_id,$user_id,$year);
                    if(is_array($user_program_list))
                    {
                        $client_program_list['status']=true;
                        $client_program_list['message']="program plan year list";
                        $client_program_list['program']=$user_program_list;
                    }
                    else
                    {
                        $client_program_list['status']=false;
                        $client_program_list['message']="error getting programlist";
                        $client_program_list['program']=null;
                    }
		            echo json_encode($client_program_list);
                break;

                case 'yearList':
                    $user_id = $_GET['userId'];
                    $year_array=ClientUtility::getGlobalYearList($user_id);
                    if($year_array) { echo ResponseUtility::responseArrayAsJson(true,"user year list",$year_array); } else { echo ResponseUtility::responseArrayAsJson(false,"invalid user id or user privileges not set",$year_array);}
                break;

                case 'nurseList':
                    //get the all nurse name by client privilege assigned to this user id
                    $user_id = $_GET['userId'];
                    echo UserUtility::getUserIdAndFullNameByUserClientPrivilegesAndRole($user_id,'nurse');
                break;
    
                case 'qaList':
                    $user_id = $_GET['userId'];
                    echo UserUtility::getUserIdAndFullNameByUserClientPrivilegesAndRole($user_id,'qa');
                break;
    
                case 'coderList':
                    $user_id = $_GET['userId'];
                    echo UserUtility::getUserIdAndFullNameByUserClientPrivilegesAndRole($user_id,'coder');
                break;
    
                case 'schedulerList':
                    $user_id = $_GET['userId'];
                    echo UserUtility::getUserIdAndFullNameByUserClientPrivilegesAndRole($user_id,'scheduler');
                break;

                case 'adminList':
                    $user_id = $_GET['userId'];
                    echo UserUtility::getUserIdAndFullNameByUserClientPrivilegesAndRole($user_id,'admin');
                break;

                case 'schedulerLeadList':
                    $user_id = $_GET['userId'];
                    echo UserUtility::getUserIdAndFullNameByUserClientPrivilegesAndRole($user_id,'scheduler_lead');
                break;
            }

        }

?>