<?php

//access control allow Header 
include("../AccessControlAllowHeader.php");

//other include files
require_once("../utility/JwtUtility.php");
require_once("../utility/FileIOUtility.php");
require_once("ClientUtility.php");
require_once("../utility/ArrayUtility.php");
require_once("../utility/DataBaseUtility.php");
require_once("../utility/ResponseUtility.php");
require_once("../auth/UserUtility.php");
require_once("../TimeZone.php");

class client {
	
	public function getAllClient()
	{
		include("../db.php");

		$getClientData="select * from HRA_client";
	  	$getClientDetails=mysqli_query($conn,$getClientData);
		$counttt = mysqli_num_rows($getClientDetails);
		
		if($counttt != 0)
		{
			while($getClientResp=mysqli_fetch_array($getClientDetails,MYSQLI_ASSOC))
			{
				$client_name = $getClientResp['client_name'];
				$year = $getClientResp['year'];
				$clientId = $getClientResp['clientId'];
				$clientInfo = $getClientResp['clientInfo'];
				$clientInfop = json_decode($clientInfo,true);
				$arrayData = explode(",",$year);
				$client_data[]=array("client_name"=>$client_name,"year"=>$arrayData,"clientId"=>$clientId,"clientInfo"=>$clientInfop);
			}

			echo $response = json_encode($client_data);
		}
		else
		{
			$response = new stdClass();
			$response->status = 'noRecords';
			$response = json_encode($response);
			echo $response;	
		}
		
	}

	/*
        NAME : getClientsList
        TYPE : API function
        DETAILS :client list format generation based on new plan,program and lob with exsisting system
		RETURN : client details as json response
	*/
	public function getClientsList()
	{
		//database connation
		include("../db.php");
		$client_list_query="select * from HRA_client";
	  	$client_list_query_result=mysqli_query($conn,$client_list_query);
		$client_list_count = mysqli_num_rows($client_list_query_result);

		if($client_list_count != 0)
		{
			$client_default_json = '{ "plan":[] }';
			$client_list_array = json_decode($client_default_json,true);

			while($client_detail_row=mysqli_fetch_array($client_list_query_result,MYSQLI_ASSOC))
			{
				$plan = $client_detail_row['plan'];
				$program = $client_detail_row['program'];
				$lob = $client_detail_row['lob'];

				$client_details = ClientUtility::generateClientArrayDetails($client_detail_row);
				//find plan name already available or not
				$plan_result = ArrayUtility::compareArrayKeyValue($client_list_array['plan'],'name',$plan);

				if($plan_result["result"])
				{
						$plc = $plan_result["index"];
						$this_program_array = $client_list_array['plan'][$plc]['program'];
						$program_found_result = ArrayUtility::compareArrayKeyValue($this_program_array,'name',$program);
						if($program_found_result["result"])
						{
							$program_index = $program_found_result["index"];
							$this_program_lob = $this_program_array[$program_index]['lob'];

							$lob_found_result = ArrayUtility::compareArrayKeyValue($this_program_lob,'name',$lob);

							if($lob_found_result["result"])
							{
								$lob_index = $lob_found_result["index"];
								$this_program_lob[$lob_index]['clientDetails'][]=$client_details;	
							}
							else
							{
								$client_list_array['plan'][$plc]['program'][$program_index]['lob'][]=array("name"=>$lob,
																									"clientDetails"=>$client_details);						
							}

						}
						else
						{
							$client_list_array['plan'][$plc]['program'][]=array("name"=>$program,
																				"lob"=>array(array("name"=>$lob,
																					"clientDetails"=>$client_details)));
						}
					
				}
				else
				{	
					$plan_array = array('name'=>$plan,'program'=>array(array("name"=>$program,
																	"lob"=>array(array("name"=>$lob,
																		"clientDetails"=>$client_details)))));
					$client_list_array['plan'][]=$plan_array;
				}

			}

			echo json_encode($client_list_array);
		}
		else
		{
			$response = new stdClass();
			$response->status = 'noRecords';
			$response = json_encode($response);
			echo $response;	
		}
		
	}

	public function addYearToClient()
	{

		include("../db.php");
		
		$clientId = $GLOBALS['inputData']['data']['clientId'];
		$clientName = $GLOBALS['inputData']['data']['client_name'];
		$implodeddata = $GLOBALS['inputData']['data']['year'];

		$maxkeyvalue = count($implodeddata);
 		$maxkeyvaluee = $maxkeyvalue - 1;
		$year = $implodeddata[$maxkeyvaluee];
		 
		$clientInfo = $GLOBALS['inputData']['data']['clientInfo'];
		$jsonClientInfo = json_encode($clientInfo);
		
		$getRec = "select * from HRA_client where clientId = '$clientId'";
		$getRec_result=mysqli_query($conn,$getRec);
		$getRec_row=mysqli_fetch_array($getRec_result,MYSQLI_ASSOC);
		$oldYear = $getRec_row['year'];
		
		$curYear[] = $oldYear;
		$curYear[] = $year;
		
		TimeZone::useTimeZone();
		$updatedon = date('Y-m-d h:i:s');
		$implodedYear = implode(",",$curYear);
		$table_status = false;
		$updateClientRec = "update HRA_client set client_name='$clientName',year='$implodedYear',clientInfo='$jsonClientInfo',updatedon='$updatedon' where clientId='$clientId'";
		try
		{
			mysqli_query($conn, $updateClientRec);
			$updated_res = mysqli_affected_rows($conn);
			if($updated_res)
			{
				$response = new stdClass();
				$response->status = "success";
				//create client member table if year added
				$table_status = DataBaseUtility::CreateMemberTable($clientId,$year);
				$response->tableStatus = $table_status;
				$response = json_encode($response);
				echo $response;
			}
			else
			{
				$response = new stdClass();
				$response->status = "notsuccess";
				$response->tableStatus = false;
				$response = json_encode($response);
				echo $response;
			}
					
		}
		catch (Exception $e)
		{
			$response = new stdClass();
			$response->status = "notsuccess";
			$response->tableStatus = false;
			$response = json_encode($response);
			echo $response;
		}
		
		//only create releavent folder if table created
		if($table_status)
		{
			$jsonfolderpath = '../hrajsondata/HRA_member_'.$clientId;
			$jsonfolderpathresp = file_exists($jsonfolderpath);
			if($jsonfolderpathresp == 1)
			{
				$jsonfolderpathh = '../hrajsondata/HRA_member_'.$clientId.'/'.$year;
				$permitt = FileIOUtility::CLIENT_FOLDER_PERMISSION;
				mkdir($jsonfolderpathh);
				chmod($jsonfolderpathh, $permitt);
			}
				
			$jsonfolderpath = '../member_data/HRA_member_'.$clientId;
			$jsonfolderpathresp = file_exists($jsonfolderpath);
			if($jsonfolderpathresp == 1)
			{

				$jsonfolderpathh = '../member_data/HRA_member_'.$clientId.'/'.$year;
				$permitt = FileIOUtility::CLIENT_FOLDER_PERMISSION;
				mkdir($jsonfolderpathh);
				chmod($jsonfolderpathh, $permitt);	
			}
		}
	}
	
	public function editClient()
	{

		include("../db.php");

		$clientId = $GLOBALS['inputData']['data']['clientId'];
		$clientName = $GLOBALS['inputData']['data']['client_name'];
		
		$clientInfo = $GLOBALS['inputData']['data']['clientInfo'];
		$jsonClientInfo = json_encode($clientInfo);

		TimeZone::useTimeZone();
		$updatedon = date('Y-m-d h:i:s');
		
		$updateClientRec = "update HRA_client set client_name='$clientName',clientInfo='$jsonClientInfo',updatedon='$updatedon' where clientId='$clientId'";
		
		try 
		{
			mysqli_query($conn, $updateClientRec);
			$updated_res = mysqli_affected_rows($conn);
			if($updated_res)
			{
				$response = new stdClass();
				$response->status = "success";
				$response = json_encode($response);
				echo $response;
			}
			else
			{
				$response = new stdClass();
				$response->status = "notsuccess";
				$response = json_encode($response);
				echo $response;
			}
					
		}
		catch (Exception $e)
		{
			$error = $e->getMessage();
			echo $error;
		}
	}
	
	public function addClient()
	{
		include("../db.php");
		
		$clientId = $GLOBALS['inputData']['data']['clientId'];
		$clientInfo = $GLOBALS['inputData']['data']['clientInfo'];
		$jsonClientInfo = json_encode($clientInfo);
		$client_name = $GLOBALS['inputData']['data']['client_name'];
		$implodeddata = $GLOBALS['inputData']['data']['year'];
		$year = $implodeddata[0];
			
		$query = "select * from HRA_client where client_name='$client_name'";
		$result=mysqli_query($conn,$query);
		if(mysqli_num_rows($result) == 0)
		{
			TimeZone::useTimeZone();
			$createdon = date('Y-m-d h:i:s');
			$updatedon = date('Y-m-d h:i:s');
		
			$table_status = DataBaseUtility::CreateMemberTable($clientId,$year);
			if ($table_status) 
			{
  					$insert_membersql="insert into HRA_client (client_name,year,clientId,clientInfo,createdon,updatedon) values('$client_name','$year','$clientId','$jsonClientInfo','$createdon','$updatedon')";
					try
					{
						mysqli_query($conn, $insert_membersql);
						$newRecordId = mysqli_insert_id($conn);
						if($newRecordId)
						{
							$response = new stdClass();
						 	$response->status = "success";
							$response->tableStatus = true; 
						 	$response = json_encode($response);
						 	echo $response;
						}
						else
						{
							$response = new stdClass();
							$response->status = "notsuccess";
							$response->tableStatus = false; 
							echo json_encode($response);
						}
						
					}
					catch(Exception $e)
					{
						$response = new stdClass();
						$response->status = "notsuccess";
						$response->tableStatus = false;
						$response->error = $e->getMessage(); 
						echo json_encode($response);	
					}
			}
			else 
			{
				$response = new stdClass();
				$response->status = "notsuccess";
				$response->tableStatus = false;
				$response->error = $conn->error; 
				echo json_encode($response);
			}

			//only table created properly than create relavent folder
			if($table_status)
			{
				$jsonfolderpath = '../hrajsondata/HRA_member_'.$clientId;
				$jsonfolderpathresp = file_exists($jsonfolderpath);
				if($jsonfolderpathresp == 1)
				{
					$response = new stdClass();
					$response->status = 'HRA_member_'.$clientId.'/'.$year.' AlreadyExists';
					$response = json_encode($response);
					echo $response;
				}
				else
				{

					$jsonfolderpathh = '../hrajsondata/HRA_member_'.$clientId;
					$permitt = FileIOUtility::CLIENT_FOLDER_PERMISSION;
					mkdir($jsonfolderpathh);
					chmod($jsonfolderpathh, $permitt);
			
					$subjsonfolderpathh = '../hrajsondata/HRA_member_'.$clientId.'/'.$year;
					$subjsonfolderpathhh = file_exists($subjsonfolderpathh);
										
					if($subjsonfolderpathhh == 1)
					{
						$response = new stdClass();
						$response->status = 'exist';
						$response = json_encode($response);
						echo $response;
					}
					else
					{
						$subjsonfolderpathhyr = '../hrajsondata/HRA_member_'.$clientId.'/'.$year;
						$permittyr = FileIOUtility::CLIENT_YEAR_FOLDER_PERMISSION;
						mkdir($subjsonfolderpathhyr);
						chmod($subjsonfolderpathhyr, $permittyr);
					}
										
				}
			
				//checking member folder		
				$memeberdatafolderpath = '../member_data/HRA_member_'.$clientId;
				$memeberdatafolderpathresp = file_exists($memeberdatafolderpath);
				if($memeberdatafolderpathresp == 1)
				{
					
					$subfolder = '../member_data/HRA_member_'.$clientId.'/'.$year;	
					$subfolderpath = file_exists($subfolder);		
					if($subfolderpath == 1)
					{
						
					}
					else
					{
						$subfolderr = '../member_data/HRA_member_'.$clientId.'/'.$year;	
						$permit = FileIOUtility::CLIENT_YEAR_FOLDER_PERMISSION;
						mkdir($subfolderr);
						chmod($subfolderr, $permit);
					}
					
				}
				else
				{
					$jsonfolderpathh = '../member_data/HRA_member_'.$clientId;
					$permit = FileIOUtility::CLIENT_FOLDER_PERMISSION;
					mkdir($jsonfolderpathh);
					chmod($jsonfolderpathh, $permit);
					$subfolder = '../member_data/HRA_member_'.$clientId.'/'.$year;	
					$subfolderpath = file_exists($subfolder);

					if($subfolderpath == 1)
					{
						
					}
					else
					{
						$subfolderr = '../member_data/HRA_member_'.$clientId.'/'.$year;	
						$permit = FileIOUtility::CLIENT_YEAR_FOLDER_PERMISSION;
						mkdir($subfolderr);
						chmod($subfolderr, $permit);
					}
							
				}
			}
			
		}
		else
		{
			$response = new stdClass();
			$response->status = "clientExists";
			$response = json_encode($response);
			echo $response;
		}
		
	}

}


//validate token
$token_validation_result = JwtUtility::isValidToken();
if($token_validation_result !== JwtUtility::VALID_TOKEN)
{     
	//un authorized access 
    JwtUtility::exitWithUnAuthorizedResponse($token_validation_result);
}
//end of token validation

$client = new client;
$method = $_SERVER['REQUEST_METHOD'];

$requestedurl = $_SERVER['REQUEST_URI'];
$arrayurlstring = explode("/",$requestedurl);
$crcount = count($arrayurlstring);
$crcountt = $crcount -1;
$requestMethod = $arrayurlstring[$crcountt];
$exploded = explode("?",$requestMethod);
$requestMethod = $exploded[0];

switch ($method) {
	
	case 'GET' :
		switch($requestMethod)
		{
			case 'getAllClient' :
				$client->getAllClient();
			break;

			case 'clientsList' :
				$client->getClientsList();
			break;

			case 'clientRows' :
				$total_client_rows = ClientUtility::getTotalClientRows();
				echo json_encode($total_client_rows);
			break;
			
			case 'List' :
				$total_client_list = ClientUtility::getTotalClientList();
				echo json_encode($total_client_list);
			break;

			case 'userClientsList':
				$user_id =  $_GET['userId'];
				ClientUtility::getUserClientList($user_id);
			break;

			case 'lobs':
				$unique_lob_list = DataBaseUtility::getAllLobs();
				echo ResponseUtility::responseArrayAsJson(true,"lob list",$unique_lob_list);
			break;
			
			/*
				client privileged based user list 
			*/
			case 'nurseList':
				$client_id = $_GET['clientId'];
				echo UserUtility::getUserListByClientPrivilegesAndRole($client_id,'nurse');
			break;

			case 'qaList':
				$client_id = $_GET['clientId'];
				echo UserUtility::getUserListByClientPrivilegesAndRole($client_id,'qa');
			break;

			case 'coderList':
				$client_id = $_GET['clientId'];
				echo UserUtility::getUserListByClientPrivilegesAndRole($client_id,'coder');
			break;

			case 'schedulerList':
				$client_id = $_GET['clientId'];
				echo UserUtility::getUserListByClientPrivilegesAndRole($client_id,'scheduler');
			break;
			
			/*
				client privileged based user id and  name list 
			*/
			case 'nurseNames':
				$client_id = $_GET['clientId'];
				echo UserUtility::getUserIdAndFullNameByClientPrivilegesAndRole($client_id,'nurse');
			break;

			case 'qaNames':
				$client_id = $_GET['clientId'];
				echo UserUtility::getUserIdAndFullNameByClientPrivilegesAndRole($client_id,'qa');
			break;

			case 'coderNames':
				$client_id = $_GET['clientId'];
				echo UserUtility::getUserIdAndFullNameByClientPrivilegesAndRole($client_id,'coder');
			break;

			case 'schedulerNames':
				$client_id = $_GET['clientId'];
				echo UserUtility::getUserIdAndFullNameByClientPrivilegesAndRole($client_id,'scheduler');
			break;
		}
	break;
	 
	case 'POST' :
	 	$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);
		$requestt = json_decode($postdata,true);
    	$GLOBALS['inputData'] = $requestt;
    	$GLOBALS['input'] = $request;
		switch($requestMethod)
		{
			case 'addClient' :
				//$client->addClient();
				ClientUtility::OnClientAdded();
			break;
			
			case 'editClient' :
				//$client->editClient();
				ClientUtility::OnClientDetailsUpdated();
			break;
			
			case 'addYearToClient' :
				//$client->addYearToClient();
				ClientUtility::OnClientYearAdded();
			break;

		}
	break;
}
?>