<?php

/*
	CODER GLOBAL MEMBER API CLASS
	Created On : 14-10-2021
*/

//other include files
require_once("../global/GlobalQueryBuilder.php");
require_once("../member/MemberUtility.php");
require_once("../utility/ArrayUtility.php");
require_once("../utility/StringUtility.php");
require_once("../auth/UserUtility.php");
require_once("../utility/JwtUtility.php");
require_once("../utility/ResponseUtility.php");
require_once("../TimeZone.php");
require_once("../admin/AdminGlobalMembers.php");
class CoderGlobalMembers
{

    /*
        NAME    : getCoderRequiredColumnAsString
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public function getCoderRequiredColumnAsString($tab_id = 'None')
    {
        $sql_demograhic_string = GlobalQueryBuilder::sqlCustomColumnDemographic();
        $required_column_array[] = "member_id,firstname,lastname,nurse_id,scheduler_id,qa_id,coder_id,
                                memberinfo,hraStatus,admin_idno,hraFileUpdatedHistory,termDate,query_form,
                                scheduleDate,EvaluationDate,VisitType";
        //custom member info field for sorting 
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Plan','memberPlan');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('Program', 'memberProgram');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('LOB', 'memberLob');
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_City','memberCity');
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Zip_Code','memberZip');
        $required_column_array[] = GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_first_name', 'memberFirstName');

        $required_column_array[] = $sql_demograhic_string;
        $required_column_array[] = GlobalQueryBuilder::sqlCustomColumnOverridedScheduledDate();
        $required_column_array[] = GlobalQueryBuilder::sqlCustomColumnOverridedShortScheduledDate();
        $required_column_array[] = GlobalQueryBuilder::sqlCustomColumnReportStatus('reportStatus');
        //$required_column_array[]=$this->hraDaysCustomColumnTabContion($tab_id);
        $required_column_array[] = GlobalQueryBuilder::sqlCustomColumnHraDays();
        $query_form_review = $this->queryReviewCountCustomColumnTabCondition($tab_id);
        if ($query_form_review) {
            $required_column_array[] = $query_form_review;
        }

        return ArrayUtility::joinArrayByDelimiter($required_column_array, ',');
    }


    /*
        NAME    : convertToDefaultMemberSqlQuery
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function convertToDefaultMemberSqlQuery($member_table_sql_query)
    {
        if ($member_table_sql_query === FALSE) return FALSE;//not valid query string

        $scheduler_member_sql_query = "SELECT (COUNT(*) OVER()) as totalRows, member_table.*,
            client_table.client_name as client_name,
            admin_table.userUniqueno as admin_id,
            CONCAT(scheduler_table.firstname ,' ',scheduler_table.lastname) as scheduler_fullname,
            CONCAT(nurse_table.firstname ,' ', nurse_table.lastname) as nurse_fullname,
            CONCAT(admin_table.firstname ,' ', admin_table.lastname) as admin_fullname, 
            CONCAT(qa_table.firstname ,' ', qa_table.lastname) as qa_fullname,
            CONCAT(coder_table.firstname ,' ', coder_table.lastname) as coder_fullname,
            
            member_global_status.return_mail as returnMail
            FROM 
				( $member_table_sql_query ) as member_table 
				LEFT JOIN userLogin as scheduler_table ON scheduler_table.userUniqueno = member_table.scheduler_id 
				LEFT JOIN userLogin as nurse_table ON nurse_table.userUniqueno = member_table.nurse_id 
                LEFT JOIN userLogin as qa_table ON qa_table.userUniqueno = member_table.qa_id 
                LEFT JOIN userLogin as coder_table ON coder_table.userUniqueno = member_table.coder_id 
				LEFT JOIN HRA_client as client_table ON client_table.clientId = member_table.client_id 
				LEFT JOIN userLogin as admin_table ON admin_table.userUniqueno = member_table.admin_idno
                LEFT JOIN hra_member_global_status AS member_global_status ON member_global_status.member_id = member_table.member_id";

        return $scheduler_member_sql_query;
    }

    /*
        NAME    : getMemberRequiredFieldAsArray
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    private function getMemberRequiredFieldAsArray($member_row)
    {
        $member_id = $member_row['member_id'];
        $memberinfo = $member_row['memberinfo'];
        $demographic = $member_row['Demographic'];

        $override_scheduled_date = $member_row['overrideScheduledDate'];
        $scheduled_date = $member_row['scheduleDate'];
        $term_date = $member_row['termDate'];
        $evaluation_date = $member_row['EvaluationDate'];

        $hra_status = $member_row['hraStatus'];
        $scheduler_status = $member_row['reportStatus'];
        $visit_type = $member_row['VisitType'];

        $admin_id = $member_row['admin_id'];
        $nurse_id = $member_row['nurse_id'];
        $qa_id = $member_row['qa_id'];
        $coder_id = $member_row['coder_id'];
        $scheduler_id = $member_row["scheduler_id"];

        $nurse_name = StringUtility::toEmptyStringIfNull($member_row['nurse_fullname']);
        $scheduler_name = StringUtility::toEmptyStringIfNull($member_row['scheduler_fullname']);
        $admin_name = StringUtility::toEmptyStringIfNull($member_row['admin_fullname']);
        $qa_fullname = StringUtility::toEmptyStringIfNull($member_row['qa_fullname']);
        $coder_fullname = StringUtility::toEmptyStringIfNull($member_row['coder_fullname']);

        $client_id = $member_row['client_id'];
        $client_name = $member_row['client_name'];
        $client_year = $member_row['client_year'];

        $query_form = $member_row['query_form'];

        $hra_days = StringUtility::toEmptyStringIfNull($member_row['hra_days']);
        //conver the query review count to ordinal suffix if number
        if (isset($member_row['query_form_review_count'])) {
            $query_form_review_status = GlobalHelper::queryReviewCountToReadableFormat($member_row['query_form_review_count']);
        } else {
            $query_form_review_status = GlobalHelper::queryReviewCountToReadableFormat(null);
        }

        $response_array = array(
            "memberId" => $member_id,
            "nurseId" => $nurse_id,
            "adminId" => $admin_id,
            "schedulerId" => $scheduler_id,
            "qaId" => $qa_id,
            "coderId" => $coder_id,

            "nurseName" => $nurse_name,
            "schedulerName" => $scheduler_name,
            "qaName" => $qa_fullname,
            "coderName" => $coder_fullname,
            "adminName" => $admin_name,

            "memberinfo" => $memberinfo,
            "demographic" => $demographic,

            "scheduleDate" => $scheduled_date,
            //some case evalution date consider as scheduled date
            "overrideScheduleDate" => $override_scheduled_date,
            "termDate" => $term_date,
            "evaluationDate" => $evaluation_date,

            "hraStatus" => $hra_status,
            "hraDays" => $hra_days,
            "queryReviewStatus" => $query_form_review_status,
            "schedulerStatus" => $scheduler_status,
            "visitType" => $visit_type,

            "clientId" => $client_id,
            "clientName" => $client_name,
            "clientYear" => $client_year,

            "queryForm" => $query_form
        );

        return $response_array;
    }

    /*
       NAME    : queryResultResponse
       TYPE    : global Utiltiy function
       DETAILS :
       RETURN  :
   */
    private function queryResultResponse($member_query_result, $error)
    {
        $total_rows = 0;

        $member_list = [];
        while ($member_row = $member_query_result->fetch_assoc()) {
            $member_list[] = $this->getMemberRequiredFieldAsArray($member_row);
            $total_rows = $member_row['totalRows'];
        }

        $member_response = new stdClass;
        $member_response->status = true;
        $member_response->error = $error;
        $member_response->totalRows = $total_rows;
        $member_response->members = $member_list;

        return $member_response;

    }


    /*
        NAME    : filter
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public function filter($filter_parameters, &$error)
    {
        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $filter_parameters['planId'];
        $user_id = $filter_parameters['userId'];
        $year = $filter_parameters['year'];
        $min = $filter_parameters['min'];
        $max = $filter_parameters['max'];

        $tab_id = $filter_parameters['tabId'];

        $lob = base64_decode(urldecode($filter_parameters['lob']));
        $filter_parameters['lob'] = $lob;
        $base_sort_by = $filter_parameters['baseSortBy'];
        $base_sort_order = $filter_parameters['baseSortOrder'] == 0 ? 'ASC' : 'DESC';
        $sort_by = $filter_parameters['sortBy'];
        $sort_order = $filter_parameters['sortOrder'] == 0 ? 'ASC' : 'DESC';

        $start = $min;
        $offset = $max - $min;

        $sql_global_member_query = array();
        if (array_key_exists('planId', $filter_parameters)) {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                self::convertToDefaultMemberSqlQuery(
                    GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id, $user_id, $year,
                        $this->getCoderRequiredColumnAsString($tab_id))
                ));
        } else {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                self::convertToDefaultMemberSqlQuery(
                    GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id, $year,
                        $this->getCoderRequiredColumnAsString($tab_id))
                ));
        }
        //if invalid user details sent                                                
        if (count($sql_global_member_query) == 0) return FALSE;

        //where clause array and condition
        $where_clause_contiditions = array();
        //to get this coder assigned members where clause condition
        $user_details = DataBaseUtility::getUserById($user_id);
        //echo "<pre>". print_r($user_details,1). "</pre>";exit;
        $user_type = FALSE;
        if ($user_details) {
            $user_type = $user_details['type'];
        }

        if ($user_type == UserRoleConstant::CODER) {
            $my_member_filter['coderIds'] = $user_id;
            $my_member_filter['column'] = "coder_id";
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseUserIdIn(UserRoleConstant::CODER, $my_member_filter));
        } else if ($user_type == UserRoleConstant::CODER_LEAD) {
            if ($tab_id == 1) {
                //check for unAssigned parameter condition
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseForMemberUnAssign($parameters, UserRoleConstant::CODER));
            }
        } else {
            $error = "not a valid coder lead or coder";
            return FALSE;
        }

        //hra status based on tab
        $coder_hralist = $this->tabHraCondition($tab_id);
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseHraStatusIn($coder_hralist));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseScreeningStatus($filter_parameters));

        //filter conditions
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseCustomColumnValueIn('client_id', $filter_parameters, 'clientId', true, '|', ','));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseUserIdIn('qa', $filter_parameters));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseUserIdIn('coder', $filter_parameters));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseUserIdIn('nurse', $filter_parameters));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseCoderScheduleDateBetween($filter_parameters));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseCustomColumnValueIn('VisitType', $filter_parameters, 'visitType', true));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseHraStatusIn($filter_parameters));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo', $filter_parameters, 'city', 'Member_City', true));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo', $filter_parameters, 'lob', 'LOB', true));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo', $filter_parameters, 'plan', 'Plan', true));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo', $filter_parameters, 'program', 'Program', true));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClausesubStatusIn('subStatus', $filter_parameters));
        //if(count($where_clause_contiditions)==2) { $error="no valid filter option selected"; return FALSE;}  

        //if any valid where clause found append 'where'
        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, (count($where_clause_contiditions) > 0 ? ' WHERE ' : ''));
        //if multiple where clause add 'and' else 'or' condition
        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, ArrayUtility::joinArrayByDelimiter($where_clause_contiditions, ' AND '));
        //order query string
        if ($sort_by == 'days') {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, GlobalQueryBuilder::orderBy($user_type, $base_sort_by, 'days_coder', $base_sort_order, $sort_order));
        } else {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, GlobalQueryBuilder::orderBy($user_type, $base_sort_by, $sort_by, $base_sort_order, $sort_order));
        }
        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, " LIMIT ?,? ");
        //generated query
        $generated_query = implode($sql_global_member_query);
        //echo $generated_query;exit();
        //prepare the member query
        if ($conn->connect_errno) {
            $error = "datatbase connection failed";
        }
        //prepare the member query
        $member_query = $conn->prepare($generated_query);

        if ($member_query === FALSE) {
            $error = "error preparing sql query";
            return FALSE;
        }
        //bind parameters
        $member_query->bind_param('ii', $start, $offset);

        if ($member_query === FALSE) {
            $error = "parameter error";
            return FALSE;
        }

        $member_query->execute();


        if ($member_query === FALSE) {
            $error = "error in sql query";
            return FALSE;
        }

        $member_query_result = $member_query->get_result();

        ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result, $conn->error));

        return TRUE;
    }


    /*
        NAME    : search
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public function search($search_parameters, &$error)
    {
        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $search_parameters['planId'];
        $user_id = $search_parameters['userId'];
        $year = $search_parameters['year'];
        $min = $search_parameters['min'];
        $max = $search_parameters['max'];

        $tab_id = $search_parameters['tabId'];

        $base_sort_by = $search_parameters['baseSortBy'];
        $base_sort_order = $search_parameters['baseSortOrder'] == 0 ? 'ASC' : 'DESC';
        $sort_by = $search_parameters['sortBy'];
        $sort_order = $search_parameters['sortOrder'] == 0 ? 'ASC' : 'DESC';

        $start = $min;
        $offset = $max - $min;

        $sql_global_member_query = array();
        if (array_key_exists('planId', $search_parameters)) {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                self::convertToDefaultMemberSqlQuery(
                    GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id, $user_id, $year,
                        $this->getCoderRequiredColumnAsString($tab_id)))
            );
        } else {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                self::convertToDefaultMemberSqlQuery(
                    GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id, $year,
                        $this->getCoderRequiredColumnAsString($tab_id)))
            );
        }
        //if invalid user details sent                                                
        if (count($sql_global_member_query) == 0) return FALSE;
        //where clause array and condition
        $where_clause_contiditions = array();
        //to get this coder assigned members where clause condition
        $user_details = DataBaseUtility::getUserById($user_id);
        $user_type = FALSE;
        if ($user_details) {
            $user_type = $user_details['type'];
        }

        if ($user_type == UserRoleConstant::CODER) {
            $my_member_filter['coderIds'] = $user_id;
            $my_member_filter['column'] = "coder_id";
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseUserIdIn(UserRoleConstant::CODER, $my_member_filter));
        } else if ($user_type == UserRoleConstant::CODER_LEAD) {
            if ($tab_id == 1) {
                //check for unAssigned parameter condition
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseForMemberUnAssign($parameters, UserRoleConstant::CODER));
            }
        } else {
            $error = "not a valid coder lead or coder";
            return FALSE;
        }

        //hra status based on tab
        $coder_hralist = $this->tabHraCondition($tab_id);
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseHraStatusIn($coder_hralist));

        //search where clause condition
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByColumnLike('firstname', $search_parameters, 'firstname'));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByColumnLike('lastname', $search_parameters, 'lastname'));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByMemberId($search_parameters, 'id'));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByMemberInfoField('Plan', $search_parameters, 'plan'));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByMemberInfoField('Program', $search_parameters, 'program'));
        // $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByMemberInfoField('LOB', $search_parameters, 'lob'));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByMemberInfoField('Member_City', $search_parameters, 'city'));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByMemberInfoField('Member_Zip_Code', $search_parameters, 'zip'));
        //search params by Kasarla Mahesh
        // $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClausesubStatusIn('subStatus', $search_parameters));
        // $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseCustomColumnValueIn('VisitType', $search_parameters, 'visitType', true));
        //            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseCustomColumnValueIn('hraStatus',$search_parameters,'hraStatus',true));
        //echo "<pre>".print_r($where_clause_contiditions,1). "</pre>";exit;
        //if(count($where_clause_contiditions)==2) { $error="invalid search value"; return FALSE;}   

        //if any valid where clause found append 'where'
        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, (count($where_clause_contiditions) > 0 ? ' WHERE ' : ''));
        //if multiple where clause add 'and' else 'or' condition
        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, ArrayUtility::joinArrayByDelimiter($where_clause_contiditions, ' AND '));

        $filterCondition = str_replace("_info", "_table", (new AdminGlobalMembers())->filterCondition($tab_id, $search_parameters));
        // $filterCondition = (new AdminGlobalMembers())->filterCondition($tab_id, $search_parameters);
        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,$filterCondition);


        if ($sort_by == 'days') {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, GlobalQueryBuilder::orderBy($user_type, $base_sort_by, 'days_coder', $base_sort_order, $sort_order));
        } else {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, GlobalQueryBuilder::orderBy($user_type, $base_sort_by, $sort_by, $base_sort_order, $sort_order));
        }

        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, " LIMIT ?,? ");

        $generated_query = implode($sql_global_member_query);
        //echo $generated_query; exit();
        if ($conn->connect_errno) {
            $error = "database connection failed";
        }

        //prepare the member query
        $member_query = $conn->prepare($generated_query);
        if ($member_query === FALSE) {
            $error = "error preparing sql query";
            return FALSE;
        }
        //bind parameters
        $member_query->bind_param('ii', $start, $offset);

        if ($member_query === FALSE) {
            $error = "parameter error";
            return FALSE;
        }

        $member_query->execute();

        if ($member_query === FALSE) {
            $error = "error in sql query";
            return FALSE;
        }

        $member_query_result = $member_query->get_result();
        ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result, $error));

        return TRUE;

    }


    /*
        NAME    : getMembers
        TYPE    : global Utiltiy function 
        DETAILS : get the member details based on tab id
        RETURN  : member details
    */
    public function getMembers($parameters, &$error)
    {
        //database connection
        include("../db.php");
        //custom parameter data
        $plan_id = $parameters['planId'];
        $user_id = $parameters['userId'];
        $year = $parameters['year'];
        $min = $parameters['min'];
        $max = $parameters['max'];

        $tab_id = $parameters['tabId'];
        $base_sort_by = $parameters['baseSortBy'];
        $base_sort_order = $parameters['baseSortOrder'] == 0 ? 'ASC' : 'DESC';
        $sort_by = $parameters['sortBy'];
        $sort_order = $parameters['sortOrder'] == 0 ? 'ASC' : 'DESC';

        $isSearchApplied = $parameters['isSearchApplied'];

        $start = $min;
        $offset = $max - $min;

        $sql_global_member_query = array();
        if (array_key_exists('planId', $parameters)) {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                self::convertToDefaultMemberSqlQuery(
                    GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id, $user_id, $year,
                        $this->getCoderRequiredColumnAsString($tab_id)))
            );
        } else {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                self::convertToDefaultMemberSqlQuery(
                    GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id, $year,
                        $this->getCoderRequiredColumnAsString($tab_id)))
            );
        }

        //when invalid userid sent
        if (count($sql_global_member_query) == 0) return FALSE;

        //where clause array and condition
        $where_clause_contiditions = array();

        //to get this coder assigned members where clause condition
        $user_details = DataBaseUtility::getUserById($user_id);
        $user_type = FALSE;
        if ($user_details) {
            $user_type = $user_details['type'];
        }
        //when api accessed by user type of CODER
        if ($user_type == UserRoleConstant::CODER) {
            $my_member_filter['coderIds'] = $user_id;
            $my_member_filter['column'] = "coder_id";
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseUserIdIn(UserRoleConstant::CODER, $my_member_filter));
        } else if ($user_type == UserRoleConstant::CODER_LEAD) {
            if ($tab_id == 1) {
                //check for unAssigned parameter condition
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseForMemberUnAssign($parameters, UserRoleConstant::CODER));
            }
        } else {
            $error = "not a valid coder lead or coder";
            return FALSE;
        }

        //coder specific hra status where clause condition
        $coder_hralist = $this->tabHraCondition($tab_id);
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::whereClauseHraStatusIn($coder_hralist));

        if ($isSearchApplied == true || $isSearchApplied == "true") {
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByColumnLike('firstname', $parameters, 'firstname'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByColumnLike('lastname', $parameters, 'lastname'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions, GlobalQueryBuilder::searchByMemberId($parameters, 'id'));
        }

        //if any valid where clause found append 'where'
        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, (count($where_clause_contiditions) > 0 ? ' WHERE ' : ''));
        //if multiple where clause add 'and' else 'or' condition
        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, ArrayUtility::joinArrayByDelimiter($where_clause_contiditions, ' AND '));
        //sort by query string
        if ($sort_by == 'days') {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, GlobalQueryBuilder::orderBy($user_type, $base_sort_by, 'days_coder', $base_sort_order, $sort_order));
        } else {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, GlobalQueryBuilder::orderBy($user_type, $base_sort_by, $sort_by, $base_sort_order, $sort_order));
        }

        //limit by range
        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query, " LIMIT ?,? ");
        //genarated query
        $generated_query = implode($sql_global_member_query);

        //echo $generated_query;exit();
        if ($conn->connect_errno) {
            $error = "database connection failed";
        }

        //prepare the member query
        $member_query = $conn->prepare($generated_query);
        if ($member_query === FALSE) {
            $error = "error preparing sql query";
            return FALSE;
        }
        //bind parameters
        $member_query->bind_param('ii', $start, $offset);

        if ($member_query === FALSE) {
            $error = "parameter error";
            return FALSE;
        }

        $member_query->execute();

        if ($member_query === FALSE) {
            $error = "error in sql query";
            return FALSE;
        }

        $member_query_result = $member_query->get_result();

        ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result, $error));

        return TRUE;

    }

    /*
        NAME    : tabHraCondition
        TYPE    : internal Utiltiy function 
        DETAILS : hra status condition based on  tab id
        RETURN  : hra status array list
    */
    private function tabHraCondition($tab_id)
    {
        $coder_hralist['hraStatus'] = null;
        //tab hra status condition
        switch ($tab_id) {
            case '1':
                $coder_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
                    [
                        MemberUtility::READY_FOR_CODER
                    ], '_');
                break;

            case '2':
                $coder_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
                    [
                        //MemberUtility::CLINICIAN_REVIEW_QA,
                        MemberUtility::CLINICAIN_REVIEW_CODER
                    ], '_');
                break;
            //below 2 are coder lead tab conditions
            case '3':
                $coder_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
                    [
                        MemberUtility::READY_FOR_UPLOAD
                    ], '_');
                break;

            case '4':
                $coder_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
                    [
                        MemberUtility::COMPLETED
                    ], '_');
                break;

        }

        return $coder_hralist;
    }


    /*
        NAME    : hraDaysCustomColumnTabContion
        TYPE    : internal Utiltiy function 
        DETAILS : tab based number hra history days calculation 
        RETURN  : sql query as string 
    */
    private function hraDaysCustomColumnTabContion($tab_id)
    {

        switch ($tab_id) {
            case '1':
                return GlobalQueryBuilder::sqlCustomColumnHraStatusHistoryDays(-2, 'hra_days');
                break;

            case '2':
                return GlobalQueryBuilder::sqlCustomColumnHraStatusHistoryDays(0, 'hra_days');
                break;

            default:
                return GlobalQueryBuilder::sqlCustomColumnHraStatusHistoryDays(0, 'hra_days');
        }
    }

    /*
        NAME    : queryReviewCountCustomColumnTabCondition
        TYPE    : internal Utiltiy function 
        DETAILS : number of times query form reviewed based on tab condition
        RETURN  : sql query as string 
    */
    private function queryReviewCountCustomColumnTabCondition($tab_id)
    {
        switch ($tab_id) {
            case '1':
                return GlobalQueryBuilder::sqlCustomColumnQueryFormReviewCount(UserRoleConstant::CODER, 'query_form_review_count');
                break;

            case '2':
                return GlobalQueryBuilder::sqlCustomColumnQueryFormReviewCount(UserRoleConstant::CODER, 'query_form_review_count');
                break;

            case '3':
                return GlobalQueryBuilder::sqlCustomColumnQueryFormReviewCount(UserRoleConstant::CODER, 'query_form_review_count');
                break;

        }

        return FALSE;

    }


}


?>