<?php

//access control allow Header 
include("../AccessControlAllowHeader.php");

//other include files
require_once("../utility/JwtUtility.php");
require_once("../utility/Utility.php");
require_once("../auth/UserUtility.php");
require_once("../TimeZone.php");
require_once("../utility/ResponseUtility.php");

class covidQuestionnaire
{
	public function onCovidAnswerSave()
	{
		include("../db.php");
		$nurseId = $GLOBALS['inputData']['nurseId'];
		$firstName = $GLOBALS['inputData']['firstName'];
		$lastName = $GLOBALS['inputData']['lastName'];
		$answerData = $GLOBALS['inputData']['answer'];
		
		$answer = json_encode($answerData);

		$datetime = date("Y-m-d H:i:s");
		$utc = new DateTime($datetime, new DateTimeZone('UTC'));
		$utc->setTimezone(new DateTimeZone('America/Sao_Paulo'));
		$createdOn= $utc->format('Y-m-d H:i:s');

		$covidQuestionUpdated = $utc->format('Y-m-d');
		$update_nurserecord = "update userLogin set covidQuestionUpdated='$covidQuestionUpdated'where userUniqueno='$nurseId'";

		if($conn->query($update_nurserecord) === TRUE)
		{
		$user_insert_query = $conn->prepare('INSERT INTO covid_questionnaire(nurseId,firstName,lastName,
																	answer,createdOn) 
																	VALUES (?,?,?,?,?)');

		$user_insert_query->bind_param("sssss",$nurseId,$firstName,$lastName,
		$answer,$createdOn
		);

		$user_insert_query->execute();
		if($user_insert_query->affected_rows>0)
		{
			$response = new stdClass();
			$response->status = 1;
			$response = json_encode($response);
			echo $response; 
		}else{
			$response = new stdClass();
			$response->status = 0;
			$response = json_encode($response);
			echo $response; 
		}
	}else{
		$response = new stdClass();
		$response->status = 0;
		$response = json_encode($response);
		echo $response;
	}

// sending mail
		$mailData = $GLOBALS['inputData']['mailData'];
		$sendMailData = json_encode($mailData);
		$mailDecode = json_decode($sendMailData,true);
		$sendingData= $mailDecode['mailData'];
		$clinicianName = $mailDecode['name'];
		$dateCompleted = $mailDecode['dateCompleted'];

		$bodyData="";

		if(count($sendingData) > 0){
			$bodyData="Hello,".'<br><br>';
			$bodyData .= '<b>Clinician Name:</b> '.$clinicianName.'<br><br>';
			$bodyData .= '<b>Date Completed:</b> '.$dateCompleted.'<br><br>';
			for($i=0; $i < count($sendingData); $i++){
				$str = $sendingData[$i];
				$question = $str['question'];
				$answer = $str['answer'];
				$bodyData .=$question.'<br>'.$answer.'<br><br>';
			}

			$mailId = "awalsh@focuscares.com";

			$mailResponse =  Utility::sendMailTo($mailId,'Covid Answer',$bodyData);

		}else{
			/*$response = new stdClass();
			$response->status = 0;
			$response = json_encode($response);
			echo $response;*/
		}
		
	}

	public function onGetCovidAnswer($min,$max)
	{
		include("../db.php");
		$getAllAnswer="select * from covid_questionnaire limit $min,$max";
		$totalCount = "select * from covid_questionnaire";
		$results=mysqli_query($conn,$totalCount);
		$count = mysqli_num_rows($results);

		$answerResults = mysqli_query($conn,$getAllAnswer);
		
		if($count>0){
			$answerata=[];
			while($allAnswerRow = mysqli_fetch_array($answerResults,MYSQLI_ASSOC))
			{
				$nurseId = $allAnswerRow['nurseId'];
				$firstName = $allAnswerRow['firstName'];
				$lastName = $allAnswerRow['lastName'];
				$answer = $allAnswerRow['answer'];
				$createdOn = $allAnswerRow['createdOn'];

				$answerata[]=array("nurseId"=>$nurseId,"firstName"=>$firstName,"lastName"=>$lastName,"answer"=>$answer,
						"createdOn"=>$createdOn);
			}

			$response = new stdClass();
			$response->status = 1;
			$response->data = $answerata;
			$response->totalRows = $count;
			echo json_encode($response);
	}else{
		$response = new stdClass();
		$response->status = 0;
		$response->data = [];
		$response->totalRows = 0;
		echo json_encode($response);
	}

	}

	public function search()
	{
		include("../db.php");
		$min = $_GET['min'];
		$max = $_GET['max'];
		$firstName = $_GET['firstname'];
		$lastName = $_GET['lastname'];
		$countQuery = "";
		$sqlQuery = "";
		if($firstName){
			$countQuery="select COUNT(*) as count from covid_questionnaire where firstName LIKE '%$firstName%'";
			$sqlQuery="select * from covid_questionnaire where firstName LIKE '%$firstName%' limit $min,$max";
		}else{
			$countQuery="select COUNT(*) as count from covid_questionnaire where lastName LIKE '%$lastName%'";
			$sqlQuery="select * from covid_questionnaire where lastName LIKE '%$lastName%' limit $min,$max";
		}
		
		$countResults=mysqli_query($conn,$countQuery);
		$numrows = mysqli_num_rows($countResults);
		if($numrows>0){
			$answerata=[];
			$countRow = mysqli_fetch_array($countResults,MYSQLI_ASSOC);
			$count = $countRow['count'];
			$getData = mysqli_query($conn,$sqlQuery);
			while($allAnswerRow = mysqli_fetch_array($getData,MYSQLI_ASSOC))
			{
				$nurseId = $allAnswerRow['nurseId'];
				$firstName = $allAnswerRow['firstName'];
				$lastName = $allAnswerRow['lastName'];
				$answer = $allAnswerRow['answer'];
				$createdOn = $allAnswerRow['createdOn'];
				$answerata[]=array("nurseId"=>$nurseId,"firstName"=>$firstName,"lastName"=>$lastName,"answer"=>$answer,
					"createdOn"=>$createdOn);
			}
			$response = new stdClass();
			$response->status = 1;
			$response->data = $answerata;
			$response->totalRows = $count;
			echo json_encode($response);
		}else{
			$response = new stdClass();
			$response->status = 1;
			$response->data = [];
			$response->totalRows = 0;
			echo json_encode($response);
		}
	}

	public function filter()
	{
		include("../db.php");
		$min = $_GET['min'];
		$max = $_GET['max'];
		$from = $_GET['covidFrom'];
		$to = $_GET['covidTo'];
		$countQuery;
		$sqlQuery;
		if($from){
			$countQuery="select COUNT(*) from covid_questionnaire where createdOn between '$from' and '$to'";
			$sqlQuery="select * from covid_questionnaire where createdOn between '$from' and '$to' limit $min, $max";
		}

		$countResults=mysqli_query($conn,$countQuery);
		$count = mysqli_num_rows($countResults);

		if($count>0){
			$getData = mysqli_query($conn,$sqlQuery);
			$answerata=[];
			while($allAnswerRow = mysqli_fetch_array($getData,MYSQLI_ASSOC))
			{
				$nurseId = $allAnswerRow['nurseId'];
				$firstName = $allAnswerRow['firstName'];
				$lastName = $allAnswerRow['lastName'];
				$answer = $allAnswerRow['answer'];
				$createdOn = $allAnswerRow['createdOn'];
				
				$answerata[]=array("nurseId"=>$nurseId,"firstName"=>$firstName,"lastName"=>$lastName,"answer"=>$answer,
					"createdOn"=>$createdOn);
			}
			$response = new stdClass();
			$response->status = 1;
			$response->data = $answerata;
			$response->totalRows = $count;
			echo json_encode($response);
		}else{
			$response = new stdClass();
			$response->status = 1;
			$response->data = [];
			$response->totalRows = 0;
			echo json_encode($response);
		}
	}
	
}

//validate token
$token_validation_result = JwtUtility::isValidToken();
if($token_validation_result !== JwtUtility::VALID_TOKEN)
{     
	//un authorized access 
    JwtUtility::exitWithUnAuthorizedResponse($token_validation_result);
}
//end of token validation

$covid = new covidQuestionnaire;
$method = $_SERVER['REQUEST_METHOD'];
$requestedurl = $_SERVER['REQUEST_URI'];
$arrayurlstring = explode("/",$requestedurl);
$crcount = count($arrayurlstring);
$crcountt = $crcount -1;
$requestMethod = $arrayurlstring[$crcountt];
$exploded = explode("?",$requestMethod);
$requestMethod = $exploded[0];

 switch ($method)
 {
	 case 'POST' :
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);
		$requestt = json_decode($postdata,true);
		$GLOBALS['inputData'] = $requestt;
		$GLOBALS['input'] = $request;
			switch($requestMethod)
			{
				case 'saveCovidAnswer' :
					$covid->onCovidAnswerSave();
				break;
			}
			break;
	 
	 case 'GET' :
		switch($requestMethod)
		{
			case 'getCovidAnswer' :
				$min = $_GET['min'];
				$max = $_GET['max'];
				$covid->onGetCovidAnswer($min,$max);
			break;
			case 'Filter' :
				$covid->filter();
			break;
			case 'Search' :
				$covid->search();
			break;
		}
	 break;
 }
?>