<?php
require_once("../global/GlobalQueryBuilder.php");
require_once("../member/MemberUtility.php");
//require_once("../utility/FtpUtility.php");
require_once("../TimeZone.php");


require_once("../packages/phpseclib/Net/SSH2.php");
require_once("../packages/phpseclib/Net/SFTP.php");

require_once("../packages/phpseclib/Crypt/RSA.php");
require_once("../packages/phpseclib/Math/BigInteger.php");
require_once("../packages/phpseclib/Crypt/Hash.php");
require_once("../packages/phpseclib/Crypt/Random.php");
require_once("../packages/phpseclib/Crypt/Base.php");
require_once("../packages/phpseclib/Crypt/Rijndael.php");
require_once("../packages/phpseclib/Crypt/AES.php");
require_once("../packages/phpseclib/Crypt/Blowfish.php");
require_once("../packages/phpseclib/Crypt/DES.php");
require_once("../packages/phpseclib/Crypt/RC2.php");
require_once("../packages/phpseclib/Crypt/RC4.php");
require_once("../packages/phpseclib/Crypt/TripleDES.php");
require_once("../packages/phpseclib/Crypt/Twofish.php");

use phpseclib\Net\SFTP;

require_once("../config/Config.php");
use Config\FtpGoAnywhereConfig;

include("../db.php");

$plan_id = 'VPHP';
$year = '2021';

TimeZone::useTimeZone();
$current_date = date("Y-m-d H:i:s");

$ftp_server = FtpGoAnywhereConfig::SFTP_HOST_NAME;
$ftp_username = FtpGoAnywhereConfig::SFTP_USERNAME;
$ftp_password = FtpGoAnywhereConfig::SFTP_PASSWORD;
$ftp_remote_path = FtpGoAnywhereConfig::SFTP_REMOTE_PATH;

$sftp = new SFTP($ftp_server);

if ($sftp->login($ftp_username, $ftp_password)) {

    $getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";

    $getClientsidsresult=mysqli_query($conn,$getClientsids);
    $sql_global_member_query = array();
    while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
        $client_id =  $getClientsidsresp['clientId'];
        $substatus_column = "";
            
        $hradays_column = ", ". GlobalQueryBuilder::sqlCustomColumnHraDays();
        $overrideScheduleDate_column=GlobalQueryBuilder::sqlCustomColumnOverridedScheduledDate();
        $combine_member_query[] = "select member_id,STR_TO_DATE(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,'$.completed[0].date')) ,'%Y-%m-%d' )as completed_date,hraStatus,clientid,year, pdf_file_name from HRA_member_".$client_id.'_'.$year;
    }

    //print_r( $combine_member_query);
    if($combine_member_query && is_array($combine_member_query))
    {
        $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
	    $sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (". $sql_global_member_query1 . " ) as  member_info  where JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=".MemberUtility::COMPLETED . "  AND completed_date >= DATE(NOW()) - INTERVAL 7 DAY and completed_date < DATE(NOW())"; 

        //echo $sql_global_member_query1;exit;
        $memberrecordscount = mysqli_query($conn,$sql_global_member_query1);

        while($member_row = mysqli_fetch_array($memberrecordscount,MYSQLI_ASSOC))
        {
            //echo $member_row['member_id']."\n";
            //echo "<pre>". print_r($member_row,1). "</pre>";
            $memberId = $member_row['member_id'];
            $clientId = $member_row['clientid'];
            $year = $member_row['year'];
            $form_type = "form_pdf";
            $fileepath = '../member_data/HRA_member_'.$clientId.'/'.$year;
            $local_file_to_upload = $fileepath.'/'.$form_type.'/'.$memberId.'.pdf';
            $file_name_with_extention = $memberId.'.pdf';

            $remote_file_path=$ftp_remote_path.$file_name_with_extention;

            if($member_row['pdf_file_name'] != ''){
                $file_name = mysqli_real_escape_string($conn,$member_row['pdf_file_name']);
                $file_name .= ".pdf" ;
            }else{
                $file_name = mysqli_real_escape_string($conn,$file_name_with_extention);
            }
            

            $go_any_where_status = array("uploadStatus" => "failed", "reason" => "", "member_id" => $memberId , "client_id" => $clientId , "year" => $year, "ftp_upload_date" => $current_date , "assessment_name" => $file_name);

            if(file_exists($local_file_to_upload))
            {
                if($sftp->chdir($ftp_remote_path)){
                    if(!$sftp->put($file_name, $file_name_with_extention, SFTP::SOURCE_LOCAL_FILE)){
                        
                        $go_any_where_status = array("uploadStatus"=>"success" , "reason" => "uploaded" , "member_id" => $memberId , "client_id" => $clientId , "year" => $year , "ftp_upload_date" => $current_date , "assessment_name" => $file_name);
                    }else{
                        $go_any_where_status = array("uploadStatus"=>"failed", "reason" => "not uploaded in ftp server" , "member_id" => $memberId , "client_id" => $clientId , "year" => $year , "ftp_upload_date" => $current_date , "assessment_name" => $file_name);   
                    }
                }else{
                    $go_any_where_status = array("uploadStatus"=>"failed", "reason" => "directory $ftp_remote_path not existed in ftp server" , "member_id" => $memberId , "client_id" => $clientId , "year" => $year , "ftp_upload_date" => $current_date , "assessment_name" => $file_name);    
                }
                
            }else{
                $go_any_where_status = array("uploadStatus"=>"failed", "reason" => "$file_name is not existed" , "member_id" => $memberId , "client_id" => $clientId , "year" => $year , "ftp_upload_date" => $current_date , "assessment_name" => $file_name);   
            }
           
            $update_Query = "UPDATE HRA_member_".$clientId.'_'.$year. " SET Ftp_upload_status = '".json_encode($go_any_where_status)."' where member_id = ". $memberId;
            //echo $update_Query;
            mysqli_query($conn, $update_Query) or die($conn -> mysqli_error());
            echo  json_encode($go_any_where_status);

            if($go_any_where_status['uploadStatus'] == "failed"){
                $local_file_to_upload = mysqli_real_escape_string($conn,$local_file_to_upload);
                $memberId = mysqli_real_escape_string($conn,$memberId);
                $insert_query = "INSERT INTO ftp_error_logs( member_id, clientid, `year`, filepath, cron_type, reason) VALUES ('$memberId','$clientId',$year,'$local_file_to_upload','Weekly_Upload_Completed_records','".$go_any_where_status['reason']."') ";

                //echo $insert_query;

                $query = mysqli_query($conn,$insert_query) or die($conn -> mysqli_error());

            }
        }
    }
}else{
    echo "Unable to connect to FTP Server";
    throw new Exception('Login failed');
}

?>