<?php 
    /*
    MEMBER API CALLS
	class : members
*/

//access control allow Header 
include("../AccessControlAllowHeader.php");

//other include file
require_once("../TimeZone.php");
//Added by Ramya for exclusion member update 
require_once("../php_excel/PHPExcel.php");

require_once("../db.php");

// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

$objPHPExcel->setActiveSheetIndex(0)
			->setCellValue('A1', 'Member ID')
			->setCellValue('B1', 'Date Of Visit')
			->setCellValue('C1', 'Nurse Name')
			->setCellValue('D1', 'Referral Type')
			->setCellValue('E1', 'Referral Copy');

$plan = $_GET['plan'];
$year = $_GET['year'];

$fileName = $plan."_ReferralForm.xlsx";
$excel_file_path = "../download_xls/referral_xls/";
/*$table = "HRA_member_client_001_2022";
$cleint_id = "client_001";
$year = 2022;*/

$getClientsids = "SELECT clientId FROM HRA_client where plan= ? and year like '%$year%'";
if ($conn->connect_errno) {
    $error = "datatbase connection failed";
}

$client_query = $conn->prepare($getClientsids);
if ($client_query === FALSE) {
    $error = "error preparing sql query";
    return FALSE;
}
//bind parameters
$client_query->bind_param('s', $plan );

if ($client_query === FALSE) {
    $error = "parameter error";
    return FALSE;
}
$client_query->execute();

if ($client_query === FALSE) {
    $error = "error in sql query";
    return FALSE;
}

$client_query_result = $client_query->get_result();


while($client_row = $client_query_result->fetch_assoc()){
    $client_id = $client_row['clientId'];
    $table = "HRA_member_". $client_id. "_".$year;

    $generated_query = "SELECT h.member_id , CONCAT(n.firstname ,' ', n.lastname) as nurse_fullname , h.scheduleDate , h.referralForm FROM $table as h LEFT JOIN userLogin as n ON h.nurse_id = n.userUniqueno where `referralForm` IS NOT NULL;";

    //echo $generated_query;exit;
    if ($conn->connect_errno) {
        $error = "datatbase connection failed";
    }
    //prepare the member query
    $member_query = $conn->prepare($generated_query);
    if ($member_query === FALSE) {
        $error = "error preparing sql query";
        return FALSE;
    }
    //bind parameters
    //$member_query->bind_param('ii', $start, $offset);

    if ($member_query === FALSE) {
        $error = "parameter error";
        return FALSE;
    }

    $member_query->execute();

    if ($member_query === FALSE) {
        $error = "error in sql query";
        return FALSE;
    }

    $member_query_result = $member_query->get_result();

    $i=1;
    $folder_path = "../hrajsondata/HRA_member_$client_id/$year/";
    while ($member_row = $member_query_result->fetch_assoc()) {
        $file_path =$folder_path. $member_row['member_id']."/". $member_row['member_id'].".json";
        if(is_dir($folder_path. $member_row['member_id'])){
            $str = file_get_contents($file_path);
            $json = json_decode($str, true);
            echo "<pre>". print_r($json,1)."</pre>";
        }else{
        }
    
        $i++;
        $referral_type = "Urgent";
        $objPHPExcel->setActiveSheetIndex(0)
						->setCellValue("A$i", $member_row['member_id'])
						->setCellValue("B$i", $member_row['scheduleDate'])
						->setCellValue("C$i", $member_row['nurse_fullname'])
						->setCellValue("D$i", $referral_type)
						->setCellValue("E$i", $member_row['referralForm']);
						
    //echo "<pre>". print_r($member_row,1)."</pre>";
    }
}

$objPHPExcel->getActiveSheet()->setTitle('Sheet1');


				// Set active sheet index to the first sheet, so Excel opens this as the first sheet
				$objPHPExcel->setActiveSheetIndex(0);

				// Redirect output to a client’s web browser (Excel5)
				header("Content-Type: application/vnd.ms-excel");
				header("Content-Disposition: attachment; filename=".$fileName);
				header("Cache-Control: max-age=0");

				// Save Excel 2007 file
				$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

				$objWriter->save(str_replace('.php', '.xlsx', __FILE__));
				$objWriter->save($excel_file_path);

                unset($objWriter);
				unset($objPHPExcel);


?>