<?php
//access control allow Header 
include("../AccessControlAllowHeader.php");

//other include files
require_once("../utility/JwtUtility.php");
require_once("../TimeZone.php");

class downloadfile
{
    public function downloadfiles($memberId, $fileName, $clientId, $year)
    {

        $tmp = explode(".", $fileName);
        switch ($tmp[count($tmp) - 1]) {
            case "pdf":
                $ctype = "application/pdf";
                break;
            case "exe":
                $ctype = "application/octet-stream";
                break;
            case "zip":
                $ctype = "application/zip";
                break;
            case "docx":
            case "doc":
                $ctype = "application/msword";
                break;
            case "csv":
            case "xls":
            case "xlsx":
                $ctype = "application/vnd.ms-excel";
                break;
            case "ppt":
                $ctype = "application/vnd.ms-powerpoint";
                break;
            case "gif":
                $ctype = "image/gif";
                break;
            //case "png": $ctype="image/png"; break;
            case "PNG":
                $ctype = "image/PNG";
                break;
            case "jpeg":
            case "jpg":
                $ctype = "image/jpg";
                break;
            case "tif":
            case "tiff":
                $ctype = "image/tiff";
                break;
            case "psd":
                $ctype = "image/psd";
                break;
            case "bmp":
                $ctype = "image/bmp";
                break;
            case "ico":
                $ctype = "image/vnd.microsoft.icon";
                break;
            default:
                $ctype = "application/force-download";
        }
        
        $fileepath = '../hrajsondata/HRA_member_' . $clientId . '/' . $year . '/' . $memberId;
        $fileurl = $fileepath . '/' . $fileName;
        
        header("Pragma: public"); // required
        header("Expires: 0");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("Cache-Control: private", false); // required for certain browsers
        header("Content-Type: $ctype");
        header("Content-Length: " . filesize($fileurl));
        header("Content-Disposition: attachment; filename=\"" . $fileurl . "\";");
        
        header("Content-Transfer-Encoding: binary");
        
        
        ob_clean();
        flush();
        
        readfile($fileurl);
        
    }
	
}

//validate token
$token_validation_result = JwtUtility::isValidToken();
if($token_validation_result !== JwtUtility::VALID_TOKEN)
{     
	//un authorized access 
    JwtUtility::exitWithUnAuthorizedResponse($token_validation_result);
}
//end of token validation

$downloadingFile = new downloadfile;
$method          = $_SERVER['REQUEST_METHOD'];
$requestedurl = $_SERVER['REQUEST_URI'];
$arrayurlstring = explode("/",$requestedurl);
$crcount = count($arrayurlstring);
$crcountt = $crcount -1;
$requestMethod = $arrayurlstring[$crcountt];
$exploded = explode("?",$requestMethod);
$requestMethod = $exploded[0];
 
switch ($method) {
    case 'GET':
	
	switch($requestMethod)
	{
		
		case 'files' :
            $id          = $_GET['id'];
            $ccdFileName = $_GET['ccdFileName'];
            $clientId    = $_GET['clientId'];
            $year        = $_GET['year'];
            $id = trim($id);
    
            $downloadingFile->downloadfiles($id, $ccdFileName, $clientId, $year);
        break;
	}
	break;
}

?>