<?php

    /*
        FAX API CLASS DEFINATIONS
        DETAILS : 
        CREATED ON :11/08/2021 (dd/mm/yyyy)
    */

    require_once("../TimeZone.php");
    require_once("FaxingDatabase.php");
    require_once("FaxingService.php");
    require_once("FaxingServiceProvider.php");
    require_once("FaxResponse.php");
    require_once("../utility/ResponseUtility.php");
    require_once("../utility/DataBaseUtility.php");

    class FaxApiClass
    {   

        /*
            NAME    : SendFaxPdfFile
            TYPE    : api Utiltiy function 
            DETAILS : use this method to send fax from pdf file location  
            RETURN  : fax response
        */
        public function SendFaxPdfFile($client_id,$year,$member_id,$full_file_path)
        {

           $fax_content = file_get_contents($full_file_path);
            if($fax_content)
            {
                $this->SendFax($client_id,$year,$member_id,$fax_content ,'PDF');
            }
        }

        /*
            NAME    : SendFax
            TYPE    : internal Utiltiy function 
            DETAILS : use this method to send fax  by pdf file content
            RETURN  : fax response
        */
        public function SendFax($client_id,$year,$member_id,$fax_content,$file_type='PDF')
        {



            $fax_error_code = null;
            $fax_response = null;
            $member_array_response = array();
            //read the member fax number from member info field 
            $member_details = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,['memberinfo']);

            $member_information_array = json_decode($member_details['memberinfo'],true);

            $member_name = $member_information_array['Member_first_name']." ". $member_information_array['Member_Middle_name']. " ". $member_information_array['Member_Last_name'];

            $member_array_response['memberid'] = $member_id;
            $member_array_response['member_name'] = $member_name;

            if( $member_information_array && 
                is_array($member_information_array) &&
                array_key_exists("PCP_Fax_Number",$member_information_array)) //need to add fax field to find that fax number 
            {
                //removed after proper member pcp fax id **** REMOVE FOR PRODUCTION
                // $fax_number = FaxingService::TEST_DEMO_FAX_ID;
                // $to_pcp_name = 'Focus Admin';
                // $to_pcp_company ='Focus Cares';
                
                $fax_number = $member_information_array['PCP_Fax_Number'];
                $to_pcp_name = $member_information_array['Pcp_Name'];
                $to_pcp_company = $member_information_array['Office_Name'];

                //get the fax provider information by client

                $client_fax_provider_details = FaxingDatabase::getProviderByClient($client_id);


                if($client_fax_provider_details)
                {
                     $provider_id =  $client_fax_provider_details['provider_id'];
                //   $provider_id =  100001;


                    if($provider_id)
                    {
                        $fax_provider_details = FaxingDatabase::getProviderById($provider_id);
                        if($fax_provider_details)
                        {
                            $provider_unique_name = $fax_provider_details['provider_unique_name'];
                            $fax_provider_id = $fax_provider_details['provider_id'];
                            if($provider_unique_name)
                            {       
                                $fax_service = new FaxingService;
                                $fax_provider_object = $fax_service->getFaxProviderObject($provider_unique_name);
                                if($fax_provider_object)
                                {

                                    $fax_response =  $fax_provider_object->SendFaxFor($fax_provider_id,$fax_number,$to_pcp_name,$to_pcp_company,$fax_content,$file_type);
                                    //$fax_response = array_merge($fax_response,$member_array_response);
                                    if($fax_response)
                                    {
                                        if(property_exists($fax_response,"fax_response"))
                                        {
                                            //update fax response in member database
                                            $this->updateFaxResponseInDatabase($client_id,$year,$member_id,$fax_response->status,$fax_response->message,$fax_response->fax_response);
                                        }

                                        echo json_encode($fax_response);
                                        exit();//break the execution;
                                    }
                                }
                                else
                                {
                                    $fax_error_code = FaxResponse::PROVIDER_NOT_FOUND;
                                }
                            }
                            else
                            {
                                $fax_error_code = FaxResponse::PROVIDER_NOT_FOUND;
                            }
                        }
                        else
                        {
                            $fax_error_code = FaxResponse::PROVIDER_NOT_FOUND;
                        }
                    }
                    else
                    {
                        $fax_error_code = FaxResponse::PROVIDER_NOT_FOUND;
                    }
               }
                else
                {
                    $fax_error_code = FaxResponse::PROVIDER_NOT_FOUND;
                }
            }
            else
            {
                // $jsonfilepath = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
                // echo $jsonfilecontent = file_get_contents($jsonfilepath);die;

                $jsonfilepath = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
                $jsonfilecontent = file_get_contents($jsonfilepath);

		$fax_number = $jsonfilecontent['data'][0]['q'][0]['pcpfaxno'] != "" ?  $jsonfilecontent['data'][0]['q'][0]['pcpfaxno'] : FaxingService::TEST_DEMO_FAX_ID;

          //      $fax_number = $member_information_array['PCP_Fax_Number'];
                $to_pcp_name = $member_information_array['Pcp_Name'];
                $to_pcp_company = $member_information_array['Office_Name'];
                //get the fax provider information by client

                $client_fax_provider_details = FaxingDatabase::getProviderByClient($client_id);
            
                if($client_fax_provider_details)
                {
                    $provider_id =  $client_fax_provider_details['provider_id'];
                //   $provider_id =  100001;
                    if($provider_id)
                    {
                        $fax_provider_details = FaxingDatabase::getProviderById($provider_id);
                        if($fax_provider_details)
                        {
                            $provider_unique_name = $fax_provider_details['provider_unique_name'];
                            $fax_provider_id = $fax_provider_details['provider_id'];
                            if($provider_unique_name)
                            {       
                                $fax_service = new FaxingService;
                                $fax_provider_object = $fax_service->getFaxProviderObject($provider_unique_name);
                                if($fax_provider_object)
                                {
                                    $fax_response =  $fax_provider_object->SendFaxFor($fax_provider_id,$fax_number,$to_pcp_name,$to_pcp_company,$fax_content,$file_type);
                                    //$fax_response = array_merge($fax_response,$member_array_response);
                                    if($fax_response)
                                    {
                                        if(property_exists($fax_response,"fax_response"))
                                        {
                                            //update fax response in member database
                                            $this->updateFaxResponseInDatabase($client_id,$year,$member_id,$fax_response->status,$fax_response->message,$fax_response->fax_response);
                                        }

                                        echo json_encode($fax_response);
                                        exit();//break the execution;
                                    }
                                }
                                else
                                {
                                    $fax_error_code = FaxResponse::PROVIDER_NOT_FOUND;
                                }
                            }
                            else
                            {
                                $fax_error_code = FaxResponse::PROVIDER_NOT_FOUND;
                            }
                        }
                        else
                        {
                            $fax_error_code = FaxResponse::PROVIDER_NOT_FOUND;
                        }
                    }
                    else
                    {
                        $fax_error_code = FaxResponse::PROVIDER_NOT_FOUND;
                    }
               }
                else
                {
                    $fax_error_code = FaxResponse::PROVIDER_NOT_FOUND;
                }
            }

            //if any error 
            if($fax_error_code)
            {
                switch($fax_error_code)
                {
                    case FaxResponse::SERVICE_NOT_AVAILABLE:
                        $fax_response = FaxResponse::serviceNotAvailable();
                        //$fax_response = array_merge($fax_response,$member_array_response);
                        $this->updateFaxResponseInDatabase($client_id,$year,$member_id,$fax_response->status,$fax_response->message,null);
                        ResponseUtility::echoJsonObject($fax_response);
                    break;

                    case FaxResponse::PROVIDER_NOT_FOUND:
                        $fax_response = FaxResponse::providerNotFound();
                        //$fax_response = array_merge($fax_response,$member_array_response);
                        $this->updateFaxResponseInDatabase($client_id,$year,$member_id,$fax_response->status,$fax_response->message,null);
                        ResponseUtility::echoJsonObject($fax_response);
                    break;
                    
                    case FaxResponse::MEMBER_FAX_NUMBER_NOT_FOUND:
                        $fax_response = FaxResponse::memberWithOutFaxNumber();
                        //$fax_response = array_merge($fax_response,$member_array_response);
                        $this->updateFaxResponseInDatabase($client_id,$year,$member_id,$fax_response->status,$fax_response->message,null);
                        ResponseUtility::echoJsonObject($fax_response);
                    break;
                }
            }
            else
            {
                $fax_response = FaxResponse::unKnownFaxError();
                //$fax_response = array_merge($fax_response,$member_array_response);
                $this->updateFaxResponseInDatabase($client_id,$year,$member_id,$fax_response->status,$fax_response->message,null);
                ResponseUtility::echoJsonObject($fax_response);
            }

        }

        /*
            NAME    : AddFaxProvider
            TYPE    : internal Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private function updateFaxResponseInDatabase($client_id,$year,$member_id,$fax_stataus,$fax_memssage,$fax_response_object)
        {
            TimeZone::useTimeZone();
            $fax_date = date('Y-m-d H:i:s');
            $fax_response_array=FaxResponse::faxDatatbaseResponseFormat($fax_stataus,$fax_date,$fax_memssage,$fax_response_object);
            FaxingDatabase::updateFaxResponse($client_id,$year,$member_id,$fax_response_array);
        }

        /*
            NAME    : AddFaxProvider
            TYPE    : public Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public function AddFaxProvider()
        {


        }

         /*
            NAME    : UpdatedFaxProvider
            TYPE    : public Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public function UpdatedFaxProvider()
        {


        }

        /*
            NAME    : removeFaxProvider
            TYPE    : public Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public function removeFaxProvider()
        {


        }

        /*
            NAME    : removeFaxProvider
            TYPE    : public Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public function AddFaxProviderForClient()
        {


        }

        /*
            NAME    : UpdateFaxProviderForClient
            TYPE    : public Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public function UpdateFaxProviderForClient()
        {


        }

        /*
            NAME    : RemoveFaxProviderForClient
            TYPE    : public Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public function RemoveFaxProviderForClient()
        {


        }


    }

?>
