<?php

    /*
        FAX API RESPONSE FORMAT AND RESPONSE CODE AND ERROR CODE DEFINATIONS
        DETAILS : 
        CREATED ON :11/08/2021 (dd/mm/yyyy)
    */

    class FaxResponse
    {
        //AVAILABLE API RESPONSE STATUS
        const UNKNOWN_ISSUE = -1;
        const FAILED = 0;
        const SUCCESS = 1;
        const PENDING = 3;

        //ERROR CODE
        const UNKNOWN_ERROR = -1;
        const SERVICE_NOT_AVAILABLE = 0;
        const PROVIDER_NOT_FOUND = 1;
        const MEMBER_FAX_NUMBER_NOT_FOUND=2;

        /*
            SUCCESS FULL RESPONSE
        */
        /*
            NAME    : serviceNotAvailable
            TYPE    : utility function 
            DETAILS :  
        */
        public static function faxSentSuccessfully($fax_response_obejct,$fax_transmission_object)
        {
            $response = new stdClass();
                $response->status = self::SUCCESS;
                $response->message = "Fax sent sucessfully";
                $response->fax_response = $fax_response_obejct;
                $response -> fax_transmission_response = $fax_transmission_object;
		    return $response;
        }

        public static function faxSentPending($fax_response_obejct,$fax_transmission_object)
        {
            
            $response = new stdClass();
                $response->status = self::PENDING;
                $response->message = "Fax Status Pending";
                $response->fax_response = $fax_response_obejct;
                $response -> fax_transmission_response = $fax_transmission_object;
		    return $response;
        }

        /*
            ERROR RESPONSE
        */

        /*
            NAME    : serviceNotAvailable
            TYPE    : utility function 
            DETAILS :  
        */
        public static function serviceNotAvailable()
        {
            $response = new stdClass();
                $response->status = self::FAILED;
                $response->message = "eFax service not available";
                $response->error_code = self::SERVICE_NOT_AVAILABLE;
		    return $response;
        }

        /*
            NAME    : providerNotFound
            TYPE    : utility function 
            DETAILS :  
        */
        public static function providerNotFound()
        {
            $response = new stdClass();
                $response->status = self::FAILED;
                $response->message = "invalid fax provider";
                $response->error_code = self::PROVIDER_NOT_FOUND;
		    return $response;
        }

         /*
            NAME    : memberWithOutFaxNumber
            TYPE    : utility function 
            DETAILS :  
        */
        public static function memberWithOutFaxNumber()
        {
            $response = new stdClass();
                $response->status = self::FAILED;
                $response->message = "member pcp fax number not found";
                $response->error_code = self::MEMBER_FAX_NUMBER_NOT_FOUND;
		    return $response;
        }

        /*
            NAME    : unKnownFaxError
            TYPE    : utility function 
            DETAILS :  
        */
        public static function unKnownFaxError()
        {
            $response = new stdClass();
                $response->status = self::FAILED;
                $response->message = "Unknown error when sending fax";
                $response->error_code = self::UNKNOWN_ERROR;
                $response->fax_response = null;
		    return $response;
        }

        /*
            NAME    : faxSentFailed
            TYPE    : utility function 
            DETAILS :  
        */
        public static function faxSentFailed($fax_response_object)
        {
            $response = new stdClass();
                $response->status = self::FAILED;
                $response->message = "Fax sent failed";
                $response->fax_response = $fax_response_object;
		    return $response;
        }

        /*
            NAME    : faxDatatbaseResponseFormat
            TYPE    : utility function 
            DETAILS :  
        */
        public static function faxDatatbaseResponseFormat($fax_stataus,$fax_date,$fax_memssage,$fax_response_object,$fax_transmission_response)
        {
            $response = new stdClass();
                $response->status = $fax_stataus;
                $response->date = $fax_date;
                $response->message = $fax_memssage;
                $response->fax_response = $fax_response_object;
                $response -> fax_transmission_response = $fax_transmission_response;
		    return $response;
        }

    }

?>