<?php

    /*
        FAX CREDENTIALS DATABASE CLASS DEFINATIONS
        DETAILS : 
        CREATED ON :11/08/2021 (dd/mm/yyyy)
    */

    class FaxingDatabase
    {

         /*
            NAME    : getProviderBy
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function getProviderByClient($client_id)
        {

            //database connection
            include("../db.php");

                $client_provider_query=$conn->prepare('SELECT * FROM hra_client_faxing_details WHERE client_id=?');
                $client_provider_query->bind_param('s',$client_id);
                $client_provider_query->execute();
                $client_provider_query_result = $client_provider_query->get_result();

                $provider_details=$client_provider_query_result->fetch_assoc();
                if($provider_details)
                {
                    return $provider_details;
                }

            return null;

        }

         /*
            NAME    : getProviderByUniqueName
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function getProviderByUniqueName($provider_unique_name)
        {

            //database connection
            include("../db.php");
               
                $client_provider_query=$conn->prepare('SELECT * from hra_fax_provider WHERE provider_unique_name=?');
                $client_provider_query->bind_param('s',$provider_unique_name);
                $client_provider_query->execute();
                $client_provider_query_result = $client_provider_query->get_result();
                $provider_details=$client_provider_query_result->fetch_assoc();

                if($provider_details)
                {
                    return $provider_details;
                }

            return null;

        }

         /*
            NAME    : getProviderById
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function getProviderById($provider_id)
        {

            //database connection
            include("/var/www/html/pre_live_focuscares_api/v4/db.php");
               
                $client_provider_query=$conn->prepare('SELECT * from hra_fax_provider WHERE provider_id=?');
                $client_provider_query->bind_param('i',$provider_id);
                $client_provider_query->execute();
                $client_provider_query_result = $client_provider_query->get_result();
                $provider_details=$client_provider_query_result->fetch_assoc();

                if($provider_details)
                {
                    return $provider_details;
                }

            return null;

        }


        /*
            NAME    : updateProviderBy
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function updateProviderBy($provider_id,$client_id)
        {
            //database connection
            include("../db.php");

                $update_provider_id = $conn->prepare('UPDATE hra_client_faxing_details SET provider_id=? WHERE client_id=?'); 
                $update_provider_id->bind_param("ss", $provider_id,$client_id);
                $update_provider_id->execute();

            return $update_provider_token->affected_rows;
        }

        /*
            NAME    : getStoredAccessToken
            TYPE    : internal Utiltiy function 
            DETAILS : get the stored access token in database ( access tokens stored based on provider id )
            RETURN  : stored access token
        */
        public static function getStoredAccessToken($provider_id)
        {
            //database connection
            include("../db.php");
               
                $access_token_query=$conn->prepare('SELECT access_token from hra_fax_provider WHERE provider_id=?');
                $access_token_query->bind_param('s',$provider_id);
                $access_token_query->execute();
                $access_token_query_result = $access_token_query->get_result();
                $access_token=$access_token_query_result->fetch_assoc();

                if($access_token)
                {
                    return $access_token['access_token'];
                }

            return null;
        }

        /*
            NAME    : updateStoredAccessToken
            TYPE    : internal Utiltiy function 
            DETAILS : updated access tokens stored based on provider id in dtatbase
            RETURN  : if TRUE updated else FALSE
        */
        public static function updateStoredAccessToken($provider_id,$access_token)
        {
            //database connection
            include("/var/www/html/pre_live_focuscares_api/v4/db.php");

                $update_access_token = $conn->prepare('UPDATE hra_fax_provider SET access_token=? WHERE provider_id=?'); 
                $update_access_token->bind_param("ss", $access_token,$provider_id);
                $update_access_token->execute();

            return $update_access_token->affected_rows;
        }

        /*
            NAME    : updateFaxResponse
            TYPE    : internal Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function updateFaxResponse($client_id,$year,$member_id,$fax_response)
        {
            //database connection
            include("../db.php");

                $member_client_year_table ="UPDATE HRA_member_".$client_id.'_'.$year;
                $update_access_token = $conn->prepare($member_client_year_table.' SET pcp_fax_response=? WHERE member_id=?'); 
               // $encoded_fax_response = json_encode($fax_response);
                $encoded_fax_response = $fax_response;
                $update_access_token->bind_param("ss",$encoded_fax_response,$member_id);
                $update_access_token->execute();

            return $update_access_token->affected_rows;

        }


    }

?>