<?php

    /*
        FAXING SERIVCE CLASS 
        DETAILS : this calss used to identify the fax provider and respective provider implementation
    */

    require_once('providers/EFaxCorporate.php');

    class FaxingService
    {
        public const TEST_DEMO_FAX_ID = 18883730493;
        /*
            implementated list of faxing providers
        */
        protected $FAX_PROVIDERS = [
            'e-fax-corporate'
        ];

        /*
            NAME    : getFaxProviderList
            TYPE    : public Utiltiy function 
            DETAILS : list of implemented fax provider list
            RETURN  : array of unique provider list
        */
        public function getFaxProviderList()
        {
            return $this->FAX_PROVIDERS;
        }

        /*
            NAME    : getFaxProviderObject
            TYPE    : public Utiltiy function 
            DETAILS : e-faxing provider object based on provider unique name
            RETURN  : provider object to send fax
        */
        public function getFaxProviderObject($provider_unique_name)
        {
            switch($provider_unique_name)
            {
                case 'e-fax-corporate':
                    return new EFaxCorporate;
                break;
            }

            return null;
        }

    }

?>