<?php

    /*
        E-FAXING PROVIDER OVERRIDE 
    */
    //require_once(__DIR__."/../FaxingServiceProvider.php");
    //require_once(__DIR__."/../FaxingDatabase.php");

    require_once("/var/www/html/pre_live_focuscares_api/v4/fax/FaxingServiceProvider.php");
    require_once("/var/www/html/pre_live_focuscares_api/v4/fax/FaxingDatabase.php");
    class EFaxCorporate extends FaxingServiceProvider
    {
       //eFax Corporate specific API Details
        private  $APP_ID;
        private  $API_KEY;
        private  $USER_ID;

        /*
            NAME    : initService
            TYPE    : service initialize function 
            DETAILS :  
        */
        public function initService($provider_id)
        {
           //get the data from hra fax details 
            $fax_provider_details = FaxingDatabase::getProviderById($provider_id);
            if($fax_provider_details)
            {
                $this->APP_ID = $fax_provider_details['app_id'];
                $this->USER_ID = $fax_provider_details['user_id'];
                $this->API_KEY = $fax_provider_details['api_key'];
                $this->stored_access_token = $fax_provider_details['access_token'];
                return TRUE;
            }

            return FALSE;
        }

         /*
            NAME    : SendFaxFor
            TYPE    : service initialize function 
            DETAILS :  
        */
        public function SendFaxFor($provider_id,$fax_number,$to_name,$to_company,$file_content,$file_type='PDF')
        {
            if($this->initService($provider_id))
            {
                if(isset($this->stored_access_token))
                {
                    $fax_request_body=$this->generateFaxBody($fax_number,$to_name,$to_company,$file_type,$file_content);
                    $response_array = $this->SendFaxApi($fax_request_body);
                    
                    $http_status_code = $response_array['http_status_code'];
                    $response_value = json_decode($response_array['response'],true);
                    $transmission_response = $response_array['transmission_response'];
                    
                    switch($http_status_code)
                    {
                        case 401: //if access token expired
                            return $this->renewAccessTokenAndSendFax($provider_id,$fax_number,$to_name,$to_company,$file_type,$file_content);
                        break;
                        
                        default:
                            return $this->generateFaxResposne($http_status_code,$response_value,$transmission_response);
                        break;
                    }

                    return FaxResponse::faxSentFailed($response_value);
                }
                else
                {
                    return $this->renewAccessTokenAndSendFax($provider_id,$fax_number,$to_name,$to_company,$file_type,$file_content);
                }
            }
           
            return FaxResponse::unKnownFaxError();
        }

         /*
            NAME    : renewAccessTokenAndSendFax
            TYPE    : internal Utiltiy function 
            DETAILS : renew the access token if not set or expired
            RETURN  : fax response based on http status
        */
        protected function renewAccessTokenAndSendFax($provider_id,$fax_number,$to_name,$to_company,$file_type,$file_content)
        {
            $this->stored_access_token = $this->renewAuthTokenAndUpdateDb($provider_id); 
            if($this->stored_access_token)
            {
                //send fax 
                $fax_request_body=$this->generateFaxBody($fax_number,$to_name,$to_company,$file_type,$file_content);
                $response_array = $this->SendFaxApi($fax_request_body);
                //
                $http_status_code = $response_array['http_status_code'];
                $response_value = json_decode($response_array['response'],true);
                $transmission_response = json_decode($response_array['transmission_response'],true);
                return $this->generateFaxResposne($http_status_code,$response_value,$transmission_response);
            }
            else
            {
                return FaxResponse::unKnownFaxError();
            }

            return FaxResponse::unKnownFaxError();
        }

        /*
            NAME    : generateFaxResposne
            TYPE    : internal Utiltiy function 
            DETAILS : 
            RETURN  : fax response based on http status
        */
        protected  function generateFaxResposne($http_status_code,$response, $transmission_response)
        {
            switch($http_status_code)
            {
                case 200:
                case 201:
                    //return FaxResponse::faxSentSuccessfully($response,$transmission_response);
                    return FaxResponse::faxSentPending($response,$transmission_response);
                break;

                case 400:
                    return FaxResponse::faxSentFailed($response);
                break;

                case 429:
                    return FaxResponse::faxSentFailed($response);
                break;

                case 500:
                    return FaxResponse::faxSentFailed($response);
                break;

            }

            return FaxResponse::faxSentFailed($response);
        }

         /*
            NAME    : renewAuthToken
            TYPE    : internal Utiltiy function 
            DETAILS : 
            RETURN  : renewed auth token else FALSE
        */
        protected function renewAuthTokenAndUpdateDb($provider_id)
        {
            $auth_token_response_format=$this->renewAuthToken();
            
            $current_access_token = $this->parseAuthToken($auth_token_response_format);
                if($current_access_token===FALSE)
                {
                    //if not auth token check for Error
                    $error_response = $this->parseError($auth_token_response_format);
                    return FALSE;
                }
                else
                {
                    if(FaxingDatabase::updateStoredAccessToken($provider_id,$current_access_token))
                    {
                        return $current_access_token;
                    }
                }

            return FALSE;
        }

        /*
            NAME    : renewAuthToken
            TYPE    : internal Utiltiy function 
            DETAILS : 
                    response format when success
                        {
                            "access_token": "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJzZWNyZXRfaWQiOiI0MGZiNmYwOS1jMmRmLTQ4MWYtYjc2NS02MmMxZDdlZTY4YzciLCJzY29wZSI6WyJyZWFkIiwid3JpdGUiXSwiZXhwIjoxNjI4NTg2MjAzLCJhcHBfaWQiOiI3NTlkMTFjZC05NWQ5LTRjYmEtOTEyZS05MDJkZTZlYTU2NTciLCJhdXRob3JpdGllcyI6WyJST0xFX0ZTVE9SIl0sImp0aSI6IjcwMWZkODk0LWJmOTYtNDE0OS04ZWQxLTY5MzAyYzU4NDYxMyIsImNsaWVudF9pZCI6Ijc1OWQxMWNkLTk1ZDktNGNiYS05MTJlLTkwMmRlNmVhNTY1NyJ9.cl3yHWMkcXWON_xlmxiLd60TLqteNH47-23oZOVRwjvUpmUZ0khAuXZiUUTWWTYzQ19p_Nh-pwylDnif2yWj-cC3wCpkuM-gdH81cZecd__7OqIZ2Dz8l7cKpMeJLLdB4B2NDPqFrOkUXxPMmCBI8sR1EZOHI2ecMsMgzysoKy6ACpOMR6wXWY6_px32n_TC0oBxjOk-Z0VXe986hXmTS9dHurzKIwPINq7Hw9W8ccdv9ahz25rvw0qROmdFm1Sr1D2exanb81jrmBlAFFxn-WpJqK3WcvYnlND44OWgsp7mIyS0_6gYXLuKDrQhD4gyjPGFpNdPCARr3Zn42q4FVA",
                            "token_type": "bearer",
                            "expires_in": 86399,
                            "scope": "read write",
                            "secret_id": "40fb6f09-c2df-481f-b765-62c1d7ee68c7",
                            "app_id": "759d11cd-95d9-4cba-912e-902de6ea5657",
                            "jti": "701fd894-bf96-4149-8ed1-69302c584613"
                        }
                    response format when error
                        {
                            "transaction_id": "1d372f26-f8ef-11eb-820b-832900675fc0",
                            "errors": [
                                {
                                    "error_code": "Unauthorized",
                                    "developer_message": "Failed to decode basic authentication token",
                                    "user_message": "Failed to decode basic authentication token",
                                    "more_info": "https://efax-production-faxing.tech-docs.io/"
                                }
                            ]
                        }

            RETURN  : auth token
        */
        protected function renewAuthToken()
        {

            $curl = curl_init();

                curl_setopt_array($curl, 
                    array(
                        CURLOPT_URL => "https://api.securedocex.com/tokens",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 30,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => "POST",
                        CURLOPT_POSTFIELDS => "grant_type=client_credentials",
                        CURLOPT_HTTPHEADER => array(
                            "authorization: Basic ".base64_encode($this->APP_ID.":".$this->API_KEY),
                            "content-type: application/x-www-form-urlencoded"
                        ),
                    )
                );

            $curl_result = curl_exec($curl);
            $curl_error = curl_error($curl);
            $http_response_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

            curl_close($curl);

            if ($curl_error) 
            {
                return $curl_error;
            } 
            else
            {
                return $curl_result;
            }

            return null;
        }

        /*
            NAME    : IsServiceAvailable
            TYPE    : public Utiltiy function 
            DETAILS : check whether the fax server is 'UP' or DOWN
            RETURN  : true if UP else false
        */
        public function IsServiceAvailable()
        {
            
            $curl = curl_init();

                curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://api.securedocex.com/health",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "GET",
                ));
            
                $curl_result = curl_exec($curl);
                $curl_error = curl_error($curl);
            
            $http_response_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

            curl_close($curl);
            
            if ($curl_error) 
            {
                return FALSE;
            } 
            else 
            {
               $response_array = json_decode($curl_result,true);
               if($response_array && is_array($response_array))
               {
                    if($response_array["status"] == "UP")
                    {
                        return TRUE;
                    }
               }
            }

            return FALSE;
        }

         /*
            NAME    : generateFaxBody
            TYPE    : public Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private function parseAuthToken($response_format)
        {
            $response_array = json_decode($response_format,true);

            if(is_array($response_array) && array_key_exists("access_token",$response_array))
            {
                return $response_array['access_token'];
            }

            return FALSE;
        }

        /*
            NAME    : generateFaxBody
            TYPE    : public Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private function parseError($response_format)
        {
            $response_array = json_decode($response_format,true);

            if(is_array($response_array) && array_key_exists("errors",$response_array))
            {
                $error_response_array = $response_array['errors'];

                return (isset($error_response_array[0])?$error_response_array[0]:FALSE);
            }

            return FALSE;
        }

        /*
            NAME    : generateFaxBody
            TYPE    : public Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private function generateFaxBody($fax_number,$to_name,$to_company,$file_type,$file_content)
        {
            $fax_body_object["destinations"] = array(
                array("to_name"=>$to_name,"to_company"=>$to_company,"fax_number"=>$fax_number)
                );

            $fax_body_object["documents"] = array(
                array("document_type"=>$file_type,"document_content"=>base64_encode($file_content))
            );
            return $fax_body_object;
        }

        /*
            NAME    : generateFaxOptions
            TYPE    : public Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private function generateFaxOptions($from_name,$subject,$message)
        {
            $fax_options['image_resolution']   = "STANDARD";
            $fax_options['include_cover_page'] = true;
            $fax_options['cover_page_options'] = array("from_name"=>$from_name,"subject"=>$subject,"message"=>$message);
            $fax_options['retry_options'] =  array("non_billable"=>2,"billable"=>3,"human_answer"=>1);
            return $fax_options;
        }

        /*
            NAME    : SendFaxApi
            TYPE    : public Utiltiy function 
            DETAILS : check whether the fax server is 'UP' or DOWN
            RETURN  : true if UP else false
        */
        private function SendFaxApi($fax_body_object)
        {
  
                $curl = curl_init();

                    curl_setopt_array($curl, array(
                    CURLOPT_URL => "https://api.securedocex.us/faxes",
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 30,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "POST",
                    CURLOPT_POSTFIELDS => json_encode($fax_body_object),
                    CURLOPT_HTTPHEADER => array(
                        "Authorization: Bearer ".$this->stored_access_token,
                        "content-type: application/json",
                        "user-id: ".$this->USER_ID
                    ),
                    ));


                $curl_result = curl_exec($curl);
                $curl_error = curl_error($curl);

                $http_response_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

                curl_close($curl);

                if ($curl_error) 
                {
                    return array("http_status_code"=>$http_response_code,"response"=>$curl_error , "transmission_response" => "");
                }
                else
                {
                    $res = json_decode($curl_result, true);
                    $fax_id = $res[0]['fax_id'];
                    //$fax_transmission_array = $this -> faxTransmission($fax_id) ;
                    /*while(1){
                        if($fax_transmission_array == NULL || $fax_transmission_array == "NULL" || $fax_transmission_array == "null"){
                            $fax_transmission_array = $this -> faxTransmission($fax_id) ;
                        }else{
                            return array("http_status_code"=>$http_response_code,"response"=>$curl_result,"transmission_response" => $fax_transmission_array);
                        }
                    }*/
                    
                    return array("http_status_code"=>$http_response_code,"response"=>$curl_result,"transmission_response" => "Pending");
                }
        }

    public function faxTransmission($fax_id,$provider_id){
        if($this->initService($provider_id)){   
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://api.securedocex.us/faxes/$fax_id/transmission-details",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => array(
                    "Authorization: Bearer ".$this->stored_access_token,
                    "content-type: application/json",
                    "transaction-id: ",
                    "user-id: ".$this->USER_ID
                )
            ));
            
            $curl_result = curl_exec($curl);
            $curl_error = curl_error($curl);

            $http_response_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            //echo json_encode($this->stored_access_token);exit;
            curl_close($curl);
            if($curl_result != ''){
                if ($curl_error) {
                    return array("http_status_code"=>$http_response_code,"response"=>$curl_error);
                } else {
                    return array("http_status_code"=>$http_response_code,"response"=>$curl_result);
                }
            }else{
                return array("http_status_code"=>"","response"=>"Pending");
                //$fax_transmission = $this->faxTransmission($fax_id);
            }        
        }else{
            $renew = renewAuthTokenAndUpdateDb($provider_id);
            if($this->stored_access_token){
                $this->faxTransmission($fax_id,$provider_id);
            }
        }
    }
       
    }

?>