<?php 
// Load the database configuration file 
date_default_timezone_set('America/New_York');

include("include_phpseclib.php");
use phpseclib\Net\SFTP;

$plan_id = 'OHP-OPTIMA';
//$plan_id = isset($_GET['plan_id'])? $_GET['plan_id'] : "";
$current_date = date("Y-m-d H:i:s");
$date = date("mdY");
$year = isset($_GET['year'])? $_GET['year'] : date("Y");
//$year = 2021;

if($plan_id != ""){

	// Excel file name for download 
	$fileName = "FocusCare_Weekly Upload Report_Date $date.xlsx"; 

	// Set document properties
    /*$objPHPExcel->getProperties()->setCreator("Maarten Balliauw")
      ->setLastModifiedBy("Maarten Balliauw")
      ->setTitle("PHPExcel Test Document")
      ->setSubject("PHPExcel Test Document")
      ->setDescription("Test document for PHPExcel, generated using PHP classes.")
      ->setKeywords("office PHPExcel php")
      ->setCategory("Test result file");*/


	$excel_file_path = "$root_path/ftp_uploads/$date/$fileName";
	if(!file_exists("$root_path/ftp_uploads")){
		mkdir("$root_path/ftp_uploads",0777,true);

	}
	if(!file_exists("../ftp_uploads/$date")){
		mkdir("../ftp_uploads/$date",0777,true);

	}



	// Create new PHPExcel object
	$objPHPExcel = new PHPExcel();

	if(file_exists($excel_file_path)){
		$objReader = PHPExcel_IOFactory::createReader("Excel2007");

		$objPHPExcel = $objReader->load($excel_file_path);
		$highest_row = $objPHPExcel->setActiveSheetIndex(0)->getHighestRow();

		$i = $highest_row;
		$j = $highest_row - 1;
	}else{

		$objPHPExcel->setActiveSheetIndex(0)
			->setCellValue('A1', 'SNo')
			->setCellValue('B1', 'Plan')
			->setCellValue('C1', 'Year')
			->setCellValue('D1', 'LOB')
			->setCellValue('E1', 'Member ID')
			->setCellValue('F1', 'Member First Name')
			->setCellValue('G1', 'Member Last Name')
			->setCellValue('H1', 'Visit Type')
			->setCellValue('I1', 'Assessment Naming Convention')
			->setCellValue('J1', 'Date of Service')
			->setCellValue('K1', 'Date of Upload')
			->setCellValue('L1', 'Status')
			->setCellValue('M1', 'Reason');
		$i=1;
		$j=0;
	}

	$ftp_server = "";
	$ftp_username = "";
	$ftp_password = "";
	$ftp_remote_path = "";

	$select_query = mysqli_query($conn,"SELECT * FROM hra_ftp_details where plan='DEMO'");

	if(mysqli_num_rows($select_query)>0){
		$ftp_details = mysqli_fetch_assoc($select_query);
		if($ftp_details['active_status']=='Y'){
			$ftp_server = $ftp_details['ftp_host'];
			$ftp_username = $ftp_details['ftp_user'];
			$ftp_password = $ftp_details['ftp_password'];
			$ftp_remote_path = "/".$ftp_details['ftp_remote_path'];
		}else{
			echo json_encode("$plan_id is not active for uploading files to FTP Server");
			return false;
		}
	}else{
		echo json_encode("No client is active with $plan_id");
		return false;
	}




	$sftp = new SFTP($ftp_server);

	if ($sftp->login($ftp_username, $ftp_password)) {

		if(!$sftp -> chdir($ftp_remote_path)){
			$sftp -> mkdir($ftp_remote_path);
			if(!$sftp -> chdir($ftp_remote_path.'/'.$year)){
				$sftp -> mkdir($ftp_remote_path.'/'.$year);
				if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
					$sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
				}elseif($sftp -> chdir($ftp_remote_path.'/'.$year)){
					if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
						$sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
					}
				}
			}
		}else{
			if(!$sftp -> chdir($ftp_remote_path.'/'.$year)){
				$sftp -> mkdir($ftp_remote_path.'/'.$year);
				if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
					$sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
				}
			}elseif($sftp -> chdir($ftp_remote_path.'/'.$year)){
				if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
					$sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date);
				}
			}
		}

		if($sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date)){
			$sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id);
		}

		$getClientsids =  "SELECT active_status,clientId, program FROM HRA_client LEFT JOIN hra_ftp_details as ftp ON ftp.plan = HRA_client.plan where HRA_client.plan= '".$plan_id."' and year like  '%".$year."%' ";
		//$getClientsids =  "SELECT clientId, program FROM HRA_client where HRA_client.plan= '".$plan_id."' and year like  '%".$year."%' ";

		$getClientsidsresult=mysqli_query($conn,$getClientsids);
		$sql_global_member_query = array();
		$sql_global_member_query1 = array();

		while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
			$client_id =  $getClientsidsresp['clientId'];
			$substatus_column = "";

			$overrideScheduleDate_column = "(
				CASE
				WHEN EvaluationDate IS NOT NULL AND scheduleDate IS NOT NULL THEN EvaluationDate 
				ELSE scheduleDate
				END
			) AS  overrideScheduledDate";

			$overrideShortScheduleDate_column = "(
                CASE
                    WHEN EvaluationDate IS NOT NULL AND scheduleDate IS NOT NULL THEN STR_TO_DATE(EvaluationDate, '%m-%d-%Y')
                    ELSE STR_TO_DATE(scheduleDate, '%m-%d-%Y')
                END
                ) AS  overrideShortScheduledDate";
			$completed_date_column = "( CASE 
				WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.completed'))) <> 0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,CONCAT('$.completed[',JSON_LENGTH(`hraStatusHistory` , '$.completed')-1,'].date')))


				END ) AS completed_date";
			$combine_member_query[] = "select member_id, $completed_date_column,hraStatus,clientid,year, memberinfo,$overrideScheduleDate_column,$overrideShortScheduleDate_column, VisitType, pdf_file_name from HRA_member_".$client_id.'_'.$year;
			$combine_member_query1['active'] = $getClientsidsresp['active_status'];
		} 
		$combine_member_query1['active']='Y';
		if($combine_member_query1['active']=='Y'){
			if($combine_member_query && is_array($combine_member_query))
			{
				$sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
				//$sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (". $sql_global_member_query1 . " ) as  member_info  where JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus'))=".MemberUtility::COMPLETED . "  AND completed_date >= DATE(NOW()) - INTERVAL 7 DAY and completed_date <= DATE(NOW())"; 

				//$sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (". $sql_global_member_query1 . " ) as  member_info  where JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus')) = 11  AND completed_date >= DATE(NOW()) - INTERVAL 7 DAY and completed_date < DATE(NOW()) and pdf_file_name !=''"; 

				$sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (". $sql_global_member_query1 . " ) as  member_info  where JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus')) = 11  AND completed_date >= DATE(NOW()) - INTERVAL 7 DAY and completed_date < DATE(NOW()) AND pdf_file_name !=''"; 

				//$sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (". $sql_global_member_query1 . " ) as  member_info  where JSON_UNQUOTE(JSON_EXTRACT(member_info.hraStatus, '$.hraStatus')) = 11 "; 
				//echo $sql_global_member_query1;exit;
				$memberrecordscount = mysqli_query($conn,$sql_global_member_query1);

				while($member_row = mysqli_fetch_array($memberrecordscount,MYSQLI_ASSOC))
				{
					$response[] = $member_row;
					$i++;
					$j++;
					$memberId = $member_row['member_id'];
					$clientId = $member_row['clientid'];
					$year = $member_row['year'];
					$form_type = "form_pdf";
					$fileepath = "$root_path/member_data/HRA_member_".$clientId.'/'.$year;
					$local_file_to_upload = $fileepath.'/'.$form_type.'/'.$memberId.'.pdf';
					$local_file_to_upload_summary = $fileepath.'/'.'summary_report'.'/'.$memberId.'.pdf';

					$file_name_with_extention = $memberId.'.pdf';



					$meminfo =  json_decode($member_row['memberinfo'],true);
					if($member_row['pdf_file_name'] != ''){
						$file_name = $member_row['pdf_file_name'].'.pdf';
					}else{
						// $file_name = $file_name_with_extention;
						$file_name = "OHP_".$meminfo['LOB'].'_'.$meminfo['Member_Region'].'_'.$member_row['VisitType'].'_'.$meminfo['Member_Last_name'].'_'.$memberId.'_.pdf';
					}


					$remote_file_path_hra="$ftp_remote_path/$year/$date/$plan_id";
					//$remote_file_path_hra = "$ftp_remote_path/";
					//$remote_file_path_summary="$ftp_remote_path/$year/summary_report/";


					$file_name = mysqli_real_escape_string($conn,$file_name);
					if(file_exists($local_file_to_upload))
					{
						if($sftp->chdir($remote_file_path_hra)){
						if($sftp->put($file_name, $local_file_to_upload, SFTP::SOURCE_LOCAL_FILE)){

							$go_any_where_status = array("hra_uploadStatus" => "success", "summary_uploadStats" => "failed" , "reason_hra" => "uploaded for HRA Assessment" ,"reason_summary" => "", "member_id" => $memberId , "client_id" => $clientId , "year" => $year , "ftp_upload_date" => $current_date , "assessment_name" => $file_name);
						}else{
							$go_any_where_status = array("hra_uploadStatus" => "failed", "summary_uploadStats" => "failed" , "reason_hra" => "not uploaded in ftp server for HRA Assessment" , "reason_summary" => "" , "member_id" => $memberId , "client_id" => $clientId , "year" => $year , "ftp_upload_date" => $current_date , "assessment_name" => $file_name);   
						}
	     				}else{
		 					$go_any_where_status = array("hra_uploadStatus" => "failed", "summary_uploadStats" => "failed" , "reason_hra" => "directory $remote_file_path_hra not existed in ftp server for HRA Assessment" , "reason_summary" => "","member_id" => $memberId , "client_id" => $clientId , "year" => $year , "ftp_upload_date" => $current_date , "assessment_name" => $file_name);    
	     				}

					}else{
						$go_any_where_status = array("hra_uploadStatus" => "failed", "summary_uploadStats" => "failed" , "reason_hra" => "$file_name is not existed for HRA Assessment" , "reason_summary" => "" ,"member_id" => $memberId , "client_id" => $clientId , "year" => $year , "ftp_upload_date" => $current_date , "assessment_name" => $file_name);   
					}

					$update_Query = "UPDATE HRA_member_".$clientId.'_'.$year. " SET Ftp_upload_status = '".json_encode($go_any_where_status)."' where member_id = ". $memberId;
					//echo $update_Query;
					mysqli_query($conn, $update_Query) ;
					echo  json_encode($go_any_where_status);
					//exit;
					if($go_any_where_status['hra_uploadStatus'] == "failed"){
						$local_file_to_upload = mysqli_real_escape_string($conn,$local_file_to_upload);
						$memberId = mysqli_real_escape_string($conn,$memberId);
						$insert_query = "INSERT INTO ftp_error_logs( member_id, clientid, `year`, filepath, cron_type, reason) VALUES ('$memberId','$clientId',$year,'$local_file_to_upload','Weekly_Upload_Completed_records_hra_assessment','".$go_any_where_status['reason_hra']."') ";

						//echo $insert_query;

						$query = mysqli_query($conn,$insert_query);

					}
					$objPHPExcel->setActiveSheetIndex(0)
						->setCellValue("A$i", $j)
						->setCellValue("B$i", $plan_id)
						->setCellValue("C$i", $year)
						->setCellValue("D$i", $meminfo['LOB'])
						->setCellValue("E$i", $memberId)
						->setCellValue("F$i", $meminfo['Member_first_name'])
						->setCellValue("G$i", $meminfo["Member_Last_name"])
						->setCellValue("H$i", $member_row['VisitType'])
						->setCellValue("I$i", $file_name)
						->setCellValue("J$i", $member_row['overrideShortScheduledDate'])
						->setCellValue("K$i",  date("m-d-Y"))
						->setCellValue("L$i", $go_any_where_status['hra_uploadStatus'])
						->setCellValue("M$i", $go_any_where_status['reason_hra']);

				}



				$objPHPExcel->getActiveSheet()->setTitle('Sheet1');


				// Set active sheet index to the first sheet, so Excel opens this as the first sheet
				$objPHPExcel->setActiveSheetIndex(0);

				// Redirect output to a client’s web browser (Excel5)
				header("Content-Type: application/vnd.ms-excel");
				header("Content-Disposition: attachment; filename=".$fileName);
				header("Cache-Control: max-age=0");

				// Save Excel 2007 file
				$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

				$objWriter->save(str_replace('.php', '.xlsx', __FILE__));
				$objWriter->save($excel_file_path);

				unset($objWriter);
				unset($objPHPExcel);
				unset($sftp);

				$sftp = new SFTP($ftp_server);

				if ($sftp->login($ftp_username, $ftp_password)) {
					if(!$sftp -> chdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/weekly_report')){
						$sftp -> mkdir($ftp_remote_path.'/'.$year.'/'.$date.'/'.$plan_id.'/weekly_report');
					}
					$remote_weekly_file ="$ftp_remote_path/$year/$date/$plan_id/weekly_report/";
					//$remote_weekly_file = "/"; 
					$excel_file_path = "$root_path/ftp_uploads/$date/$fileName";

					if($sftp->chdir($remote_weekly_file)){
					//if($sftp->put($remote_weekly_file.$fileName, $excel_file_path , SFTP::SOURCE_LOCAL_FILE)){
                    if($sftp->put($remote_weekly_file.$fileName, 'ftp_ohp.xlsx' , SFTP::SOURCE_LOCAL_FILE)){
						unlink(str_replace('.php', '.xlsx', __FILE__));
						echo "Uploaded excel file";

					}else{
						echo "Not uploaded excel file";
					}
					}
				}
			}
		}
	}
}else{
	echo "Plan Id is empty";
}
exit;

