<?php

require_once("../utility/Utility.php");

class GlobalHelper
{
        /*
			NAME 	: getPagedMembersFromArray
			TYPE 	: Internal Utility Function
            DETAILS	: get paged members list from total members array
            RETURN	: sliced array list    
		*/
        public static function getPagedMembersFromArray($total_members,$page,$member_per_page)
		{	
			//get the total member count
			$total_members_count = $total_members;
			if($total_members_count<=0) { return FALSE;}
			//start index
			if($page<=0) { $page=1; }
			$start = ($page-1) * $member_per_page;
			if ($start <= 0) { $start = 0; }
			if($start>=$total_members_count) { $start=$total_members_count; }
			
			//slice length
			$offset = $member_per_page; 
			if ($offset <= 0) { $offset = 0; }
			if($offset>=$total_members_count) { $offset=$total_members_count; }

			return array("min"=>$start,"max"=>$offset);
		}

		/*
			NAME 	: convertOrdertoCloumnName
			TYPE 	: Internal Utility Function
            DETAILS	: convert order value to database column name
            RETURN	: 
		*/
		public static function convertOrderBytoColumnName($order_by)
    	{	
			$order_to_column_name = FALSE;
			switch($order_by)
			{
				case 'id':
					$order_to_column_name = "member_id";
				break;

				case 'clientid':
					$order_to_column_name = "client_id";
				break;

				case 'year':
					$order_to_column_name = "client_year";
				break;

				case 'visittype':
					$order_to_column_name = "(CASE WHEN VisitType IS NULL OR VisitType ='' THEN 1 ELSE 0 END),VisitType";
				break;

				case 'adminname':
					$order_to_column_name = "(CASE WHEN admin_fullname IS NULL THEN 1 ELSE 0 END),admin_fullname";
				break;

				case 'nursename':
					$order_to_column_name = "(CASE WHEN nurse_fullname IS NULL THEN 1 ELSE 0 END),nurse_fullname";
				break;

				case 'schedulername':
					$order_to_column_name = "(CASE WHEN scheduler_fullname IS NULL THEN 1 ELSE 0 END),scheduler_fullname";
				break;

				case 'qaname':
					$order_to_column_name = "(CASE WHEN qa_fullname IS NULL THEN 1 ELSE 0 END),qa_fullname";
				break;

				case 'codername':
					$order_to_column_name = "(CASE WHEN coder_fullname IS NULL THEN 1 ELSE 0 END),coder_fullname";
				break;

				case 'callorder':
					$order_to_column_name = "(CASE WHEN member_table.schedulerCallOrder IS NULL THEN 1 ELSE 0 END),
										JSON_EXTRACT(
											member_table.schedulerCallOrder,
											'$.orderType'
										) ASC ,
										JSON_EXTRACT(
											member_table.schedulerCallOrder,
											'$.sortOrder'
										)";
				break;

			}
			
			return $order_to_column_name;
    	}

		/*
			NAME 	: queryReviewCountToReadableFormat
			TYPE 	: Internal Utility Function
            DETAILS	: query review count to read able response format
            RETURN	: 
		*/
		public static function queryReviewCountToReadableFormat($review_count)
		{
			if($review_count)
			{
				$review_count_suffix = Utility::convertNumberSuffix($review_count);
				if($review_count_suffix)
				{
					return $review_count_suffix.' Review';
				}
			}
			return 'New';
		}

		/*
			NAME 	: isDefaultValidParameter
			TYPE 	: Internal Utility Function
            DETAILS	: 
            RETURN	: 
		*/
		public static function isDefaultValidParameter($parameters)
		{

			if(	array_key_exists('userId',$parameters) && 
				array_key_exists('year',$parameters) && 
				array_key_exists('min',$parameters) && 
				array_key_exists('max',$parameters))
				{
					return TRUE;
				}

			return FALSE;

		}

		/*
			NAME 	: echoFailedResponse
			TYPE 	: Internal Utility Function
            DETAILS	: 
            RETURN	: 
		*/
		public static function echoFailedResponse($error="")
		{
			$member_response = new stdClass;
				$member_response->status=false;
				$member_response->error=$error;
				$member_response->totalRows=0;
				$member_response->members=null;
        	echo json_encode($member_response);
		}

}


?>