<?php

/*
	GLOABL MEMBER STATUS UTILTIY CLASS 
	Created On : 01/12/2020 
*/

class GlobalMemberStatus
{
		//if any new status created with different data type 
        const INT_STATUS_TYPE=0;
        const STRING_STATUS_TYPE=1;
        const FLOAT_STATUS_TYPE=2;
		const BOOL_STATUS_TYPE=3;

        /*
			NAME : setStatus
			DETAILS :
			RETURN:
		*/
		public function setStatus($client_id,$member_id,$status_column,$status_value,$status_type)
		{
			include("../db.php");
			//get the assessment review status 
			$status_result = $this->getStatus($client_id,$member_id,$status_column);
			$status_response = new stdClass();
			$status_response->status = "success";

			//if review not avaiable for member in client and specific year
			if($status_result["is_member"]===false)
			{
				$result=$this->insertStatus($client_id,$member_id,$status_column,$status_value,$status_type);
				if($result) {$status_response->status = "success";}else{$status_response->status = "failed";}
			}
			else
			{
				$result=$this->updateStatus($client_id,$member_id,$status_column,$status_value,$status_type);
				if($result) {$status_response->status = "success";}else{$status_response->status = "failed";}
			}

			echo json_encode($status_response);

		}
		
		public function importStatus($client_id,$member_id,$status_column,$status_value,$status_type)
		{
			include("../db.php");
			//get the assessment review status 
			$status_result = $this->getStatus($client_id,$member_id,$status_column);
			$status_response = new stdClass();
			$status_response->status = "success";

			//if review not avaiable for member in client and specific year
			if($status_result["is_member"]===false)
			{
				$result=$this->insertStatus($client_id,$member_id,$status_column,$status_value,$status_type);
				if($result) {$status_response->status = "success";}else{$status_response->status = "failed";}
			}
			else
			{
				$result=$this->updateStatus($client_id,$member_id,$status_column,$status_value,$status_type);
				if($result) {$status_response->status = "success";}else{$status_response->status = "failed";}
			}

			return $status_response;

		}

		/*
			NAME : getStatusResponse
			DETAILS : 
			RETURN:
		*/
		public function getStatusResponse($client_id,$member_id,$status_column,$status_type)
		{
			$status_result = $this->getStatus($client_id,$member_id,$status_column);
			$status_response = new stdClass();
			$status_response->status = "success";

			switch($status_type)
			{
				case self::BOOL_STATUS_TYPE:
					$status_response->value = $status_result["value"]==1?true:false;
				break;
				default:
					$status_response->status=$status_result["value"];
			}
            
			echo json_encode($status_response);
		}

		

		/*
			NAME : getStatus
			DETAILS : 
			RETURN:
		*/
		public function getStatus($client_id,$member_id,$status_column)
		{

			include("../db.php");
			//prepare sql query
            $user_query=$conn->prepare('SELECT * from hra_member_global_status WHERE client_id =  ? and member_id = ?');
                $user_query->bind_param('ss',$client_id,$member_id);
                $user_query->execute();
                $user_result = $user_query->get_result();
            $user_array=$user_result->fetch_assoc();
			
			if($user_array)
			{
                if(array_key_exists($status_column,$user_array))
                {
                    return array("is_member"=>true,"is_field"=>true,"value"=>$user_array[$status_column]);
                }
                else
                {
                    return array("is_member"=>true,"is_field"=>false,"value"=>null);
                }
			}

			return array("is_member"=>false,"is_field"=>false,"value"=>null);
		}

		/*
			NAME : insertStatus
			DETAILS : 
			RETURN:
		*/
		private function insertStatus($client_id,$member_id,$status_column,$status_value,$status_type)
		{
			include("../db.php");
			//prepare sql query
            $user_query=$conn->prepare('INSERT IGNORE INTO hra_member_global_status (client_id,member_id,'.$status_column.') VALUES(?,?,?)');
			switch($status_type)
			{
				case self::BOOL_STATUS_TYPE:
				case self::INT_STATUS_TYPE:
					$user_query->bind_param('ssi',$client_id,$member_id,$status_value);
				break;
				default:
					$user_query->bind_param('sss',$client_id,$member_id,$status_value);
			}

			$user_query->execute(); 
           
            return $user_query->affected_rows;
		}

		/*
			NAME : updateStatus
			DETAILS : 
			RETURN:
		*/
		private function updateStatus($client_id,$member_id,$status_column,$status_value,$status_type)
		{
			include("../db.php");
			//prepare sql query
            $user_query=$conn->prepare('update hra_member_global_status set '.$status_column.'=? where client_id=? and member_id=?');
			switch($status_type)
			{
				case self::BOOL_STATUS_TYPE:
				case self::INT_STATUS_TYPE:
            		$user_query->bind_param('iss',$status_value,$client_id,$member_id);
				break;
				
				default:
					$user_query->bind_param('sss',$status_value,$client_id,$member_id);

			}
            return $user_query->execute();  
		}

}

?>