<?php

/*
    GLOBAL DATABASE QUERY BUILDER
*/

require_once("../auth/UserUtility.php");
require_once("../utility/ArrayUtility.php");
require_once("../utility/StringUtility.php");
require_once("../utility/DateUtility.php");
require_once("../utility/ConstantHelper.php");
require_once("GlobalQueryUtility.php");
require_once("GlobalHelper.php");

class GlobalQueryBuilder
{

    /*
        NAME    : generateMemberQueryBasedOnClientPrivilege
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function generateMemberQueryBasedOnClientPrivilege($user_id,$year,$required_column)
    {   
        $user_details = DataBaseUtility::getUserById($user_id);
        if($user_details==null)
        {
            return FALSE;//in valid user id found
        }

        $user_clients=DataBaseUtility::getUserClientPrivilege($user_id);
        if($user_clients==null)
        {
            $user_clients = DataBaseUtility::getClientIdList();
        }

        $combine_member_query = FALSE;
        $client_list_count = count($user_clients);
        for($cl=0;$cl<$client_list_count;$cl++)
        {
            $client_id = $user_clients[$cl];
            $client_year_array = DataBaseUtility::getClientYears($client_id);
            if($client_year_array && is_array($client_year_array) && in_array($year,$client_year_array))
            {
                $combine_member_query[]="SELECT COALESCE(clientid,'$client_id') AS client_id,
                                                COALESCE(year,'$year') AS client_year,".$required_column." FROM HRA_member_".$user_clients[$cl]."_".$year;
            }
        }

        if($combine_member_query && is_array($combine_member_query))
        {
            $combine_member_query = implode(" UNION ALL ", $combine_member_query);
        }

        return $combine_member_query;
    }


    /*
        NAME    : generateMemberQueryBasedOnPlanAndClientPrivilege
        TYPE    : global Utiltiy function 
        DETAILS : get user client privilage based on client plan 
        RETURN  : 
    */
    public static function generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,$required_column)
    {   
        $plan_details=DataBaseUtility::IsPlanAvailable($plan_id);
        if($plan_details==null)
        {
            return FALSE;//in valid plan name ,not found
        }

        $user_details = DataBaseUtility::getUserById($user_id);
        if($user_details==null)
        {
            return FALSE;//in valid user id ,not found
        }

        $user_clients=DataBaseUtility::getUserClientPrivilegeByPlan($plan_id,$user_id);
       // print_r($user_clients);die;
        if($user_clients==null)
        {
            $user_clients = DataBaseUtility::getClientIdListByPlan($plan_id);
        }

        $combine_member_query = FALSE;
        $client_list_count = count($user_clients);
        for($cl=0;$cl<$client_list_count;$cl++)
        {
            $client_id = $user_clients[$cl];
            $client_year_array = DataBaseUtility::getClientYears($client_id);
            if($client_year_array && is_array($client_year_array) && in_array($year,$client_year_array))
            {
                $combine_member_query[]="SELECT COALESCE(clientid,'$client_id') AS client_id,
                                                COALESCE(year,'$year') AS client_year,".$required_column." FROM HRA_member_".$user_clients[$cl]."_".$year;
            }
        }

        if($combine_member_query && is_array($combine_member_query))
        {
            $combine_member_query = implode(" UNION ALL ", $combine_member_query);
        }
//echo $combine_member_query;die;
        return $combine_member_query;
    }

     /*
        NAME    : sqlCustomColumnScreening
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function sqlCustomColumnScreening()
    {
        //initial space important
        return "JSON_UNQUOTE(
                    JSON_EXTRACT(
                        hraFileUpdatedHistory,
                    REPLACE
                        (
                            JSON_UNQUOTE(
                                JSON_SEARCH(
                                    hraFileUpdatedHistory,
                                    'one',
                                    'screening'
                                )
                            ),
                            '.component',
                            '.value'
                        )
                    )
                ) As ScreeningArray";
    }

    /*
        NAME    : sqlCustomColumnScreeningEligibility
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function sqlCustomColumnScreeningEligibility()
    {
        return "JSON_EXTRACT(
                    JSON_EXTRACT(
                        hraFileUpdatedHistory,
                            REPLACE
                                (
                                    JSON_UNQUOTE(
                                        JSON_SEARCH(
                                            hraFileUpdatedHistory,
                                            'one',
                                            'screening'
                                        )
                                    ),
                                    '.component',
                                    '.value'
                                )
                            ),
                        '$[0][*][0]'

                ) AS ScreeningEligibility";

    }


public static function sqlCustomColumnGetSerailNumber(){
    $screeningobj = "JSON_UNQUOTE(
        JSON_EXTRACT(
            hraFileUpdatedHistory,
        REPLACE
            (
                JSON_UNQUOTE(
                    JSON_SEARCH(
                        hraFileUpdatedHistory,
                        'one',
                        'screening'
                    )
                ),
                '.component',
                '.value[0]'
            )
        )
    ) As screeningobj";


    return "(CASE
     WHEN ( JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE (JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0][0][2]' ))) <> ''  ||  JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE (JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0][0][3]' ))) <> '') THEN '0'

     WHEN ( JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE (JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0][1][2]' ))) <> ''  ||  JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE (JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0][1][3]' ))) <> '') THEN '1'

     WHEN ( JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE (JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0][2][2]' ))) <> ''  ||  JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE (JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0][2][3]' ))) <> '') THEN '2'

     WHEN ( JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE (JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0][3][2]' ))) <> ''  ||  JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE (JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0][3][3]' ))) <> '') THEN '3'

     WHEN ( JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE (JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0][4][2]' ))) <> ''  ||  JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE (JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0][4][3]' ))) <> '') THEN '4'


     WHEN ( JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE (JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0][5][2]' ))) <> ''  ||  JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE (JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0][5][3]' ))) <> '') THEN '5'

     WHEN ( JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE (JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0][6][2]' ))) <> ''  ||  JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE (JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0][6][3]' ))) <> '') THEN '6'



  
    
    END) ";

}


public static function sqlCustomColumn($lob){ 
    //echo"2";
    return "(
        CASE WHEN
            JSON_UNQUOTE(
                JSON_EXTRACT(
                    hraFileUpdatedHistory,
                REPLACE
                    (
                        JSON_UNQUOTE(
                            JSON_SEARCH(
                                hraFileUpdatedHistory,
                                'one',
                                'demographic'
                            )
                        ),
                        '.component',
                        '.value[0].program'
                    )
                )
            ) IS NOT NULL AND JSON_UNQUOTE(
                JSON_EXTRACT(
                    hraFileUpdatedHistory,
                REPLACE
                    (
                        JSON_UNQUOTE(
                            JSON_SEARCH(
                                hraFileUpdatedHistory,
                                'one',
                                'demographic'
                            )
                        ),
                        '.component',
                        '.value[0].plan'
                    )
                )
            ) IS NOT NULL AND LOWER(
                TRIM(
                    JSON_UNQUOTE(
                        JSON_EXTRACT(
                            hraFileUpdatedHistory,
                        REPLACE
                            (
                                JSON_UNQUOTE(
                                    JSON_SEARCH(
                                        hraFileUpdatedHistory,
                                        'one',
                                        'demographic'
                                    )
                                ),
                                '.component',
                                '.value[0].plan'
                            )
                        )
                    )
                )
            ) = 'vphp' OR LOWER(
                TRIM(
                    JSON_UNQUOTE(
                        JSON_EXTRACT(
                            hraFileUpdatedHistory,
                        REPLACE
                            (
                                JSON_UNQUOTE(
                                    JSON_SEARCH(
                                        hraFileUpdatedHistory,
                                        'one',
                                        'demographic'
                                    )
                                ),
                                '.component',
                                '.value[0].plan'
                            )
                        )
                    )
                )
            ) = 'vphp - virginia premier' THEN JSON_UNQUOTE(
                JSON_EXTRACT(
                    hraFileUpdatedHistory,
                REPLACE
                    (
                        JSON_UNQUOTE(
                            JSON_SEARCH(
                                hraFileUpdatedHistory,
                                'one',
                                'demographic'
                            )
                        ),
                        '.component',
                        '.value[0].lob'
                    )
                )
            ) WHEN JSON_UNQUOTE(
                JSON_EXTRACT(
                    hraFileUpdatedHistory,
                REPLACE
                    (
                        JSON_UNQUOTE(
                            JSON_SEARCH(
                                hraFileUpdatedHistory,
                                'one',
                                'demographic'
                            )
                        ),
                        '.component',
                        '.value[0].program'
                    )
                )
            ) IS NOT NULL AND JSON_UNQUOTE(
                JSON_EXTRACT(
                    hraFileUpdatedHistory,
                REPLACE
                    (
                        JSON_UNQUOTE(
                            JSON_SEARCH(
                                hraFileUpdatedHistory,
                                'one',
                                'demographic'
                            )
                        ),
                        '.component',
                        '.value[0].plan'
                    )
                )
            ) IS NOT NULL AND LOWER(
                TRIM(
                    JSON_UNQUOTE(
                        JSON_EXTRACT(
                            hraFileUpdatedHistory,
                        REPLACE
                            (
                                JSON_UNQUOTE(
                                    JSON_SEARCH(
                                        hraFileUpdatedHistory,
                                        'one',
                                        'demographic'
                                    )
                                ),
                                '.component',
                                '.value[0].plan'
                            )
                        )
                    )
                )
            ) = 'ohp - optima' OR LOWER(
                TRIM(
                    JSON_UNQUOTE(
                        JSON_EXTRACT(
                            hraFileUpdatedHistory,
                        REPLACE
                            (
                                JSON_UNQUOTE(
                                    JSON_SEARCH(
                                        hraFileUpdatedHistory,
                                        'one',
                                        'demographic'
                                    )
                                ),
                                '.component',
                                '.value[0].plan'
                            )
                        )
                    )
                )
            ) = 'ohp' THEN CONCAT(
                'OHP-',
                JSON_UNQUOTE(
                    JSON_EXTRACT(
                        hraFileUpdatedHistory,
                    REPLACE
                        (
                            JSON_UNQUOTE(
                                JSON_SEARCH(
                                    hraFileUpdatedHistory,
                                    'one',
                                    'demographic'
                                )
                            ),
                            '.component',
                            '.value[0].lob'
                        )
                    )
                )
            ) ELSE 'NA'
    END
    ) AS ".$lob; 
    }




public static function sqlCustomColumnpcplname()
{
    //initial space important
    return "REPLACE(SUBSTRING(SUBSTRING_INDEX(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','demographic')),'.component','.value[0].pphy'))), ',', 2),LENGTH(SUBSTRING_INDEX(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','demographic')),'.component','.value[0].pphy'))), ',', 2 -1)) + 1),',', '') AS  pcplname";

}
public static function sqlCustomColumnpcpfname(){

    return "REPLACE(SUBSTRING(SUBSTRING_INDEX(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','demographic')),'.component','.value[0].pphy'))), ',', 1),LENGTH(SUBSTRING_INDEX(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','demographic')),'.component','.value[0].pphy'))), ',', 1 -1)) + 1),',', '') AS  pcpfname";
}
    /*
        NAME    : sqlCustomColumnDemographic
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function sqlCustomColumnDemographic()
    {
        //initial space important
        return "JSON_UNQUOTE(
                    JSON_EXTRACT(
                        hraFileUpdatedHistory,
                        REPLACE
                            (
                                JSON_UNQUOTE(
                                    JSON_SEARCH(
                                        hraFileUpdatedHistory,
                                        'one',
                                        'demographic'
                                    )
                                ),
                                '.component',
                                '.value[0]'
                            )
                    )
            ) As Demographic";
    }

    /*
        NAME    : sqlCustomColumnLastCallLog
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function sqlCustomColumnLastCallLog()
    {
      //  return "JSON_EXTRACT(scheduler,'$.callLog[0]') AS lastCallLog";
return "STR_TO_DATE(RTRIM(SUBSTRING_INDEX(JSON_UNQUOTE(JSON_EXTRACT(scheduler,'$.callLog[0].date')),' @',1)), '%m/%d/%Y') as lastCallLog";
    }

    /*
        NAME    : sqlCustomColumnOverridedScheduledDate
        TYPE    : global Utiltiy function 
        DETAILS : this is the custom column as overrideScheduledDate if evaluation date set its consider as scheduled date
        RETURN  : calculated scheduled date
    */

	   public static function sqlCustomColumnOverridedShortScheduledDate()
    {
        return "(
                CASE
                    WHEN EvaluationDate IS NOT NULL AND scheduleDate IS NOT NULL THEN STR_TO_DATE(EvaluationDate, '%Y-%m-%d')
                    ELSE STR_TO_DATE(scheduleDate, '%Y-%m-%d')
                END
                ) AS  overrideShortScheduledDate";
    }




    public static function sqlCustomColumnOverridedScheduledDate()
    {
        return "(
                CASE
                    WHEN EvaluationDate IS NOT NULL AND scheduleDate IS NOT NULL THEN EvaluationDate 
                    ELSE scheduleDate
                END
                ) AS  overrideScheduledDate";
    }



    public static function sqlCustomColumnSortOverridedScheduledDate()
    {
        return "(
                CASE
                WHEN member_table.reportStatus not in ('Scheduled','Cancellation','Completed','No Show','Rescheduled','Refusal','F2F No Show','Virtual No Show') THEN NULL
                    WHEN EvaluationDate IS NOT NULL AND scheduleDate IS NOT NULL THEN EvaluationDate 
                    ELSE scheduleDate
                END
                ) AS  overrideScheduledDate";
    }

    public static function sqlCustomColumnSortOverridedShortScheduledDate()
    {
        return "(
                CASE
                    WHEN member_table.reportStatus not in ('Scheduled','Cancellation','Completed','No Show','Rescheduled','Refusal','F2F No Show','Virtual No Show') THEN NULL
                    WHEN EvaluationDate IS NOT NULL AND scheduleDate IS NOT NULL THEN STR_TO_DATE(EvaluationDate, '%Y-%m-%d')
                    ELSE STR_TO_DATE(scheduleDate, '%Y-%m-%d')
                END
                ) AS  overrideShortScheduledDate";
    }

	public static function sqlCustomColumnhrastatustOverridedScheduledDate()
    {
        return "(
                CASE
                WHEN JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) not in(3, 19, 6, 7 , 8, 9, 10, 11, 12) THEN NULL
                    WHEN EvaluationDate IS NOT NULL AND scheduleDate IS NOT NULL THEN EvaluationDate 
                    ELSE scheduleDate
                END
                ) AS  overrideScheduledDate";
    }

    public static function sqlCustomColumnhrastatusOverridedShortScheduledDate()
    {
        return "(
                CASE
                    WHEN JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) not in(3, 19, 6, 7 , 8, 9, 10, 11, 12) THEN NULL
                    WHEN EvaluationDate IS NOT NULL AND scheduleDate IS NOT NULL THEN STR_TO_DATE(EvaluationDate, '%Y-%m-%d')
                    ELSE STR_TO_DATE(scheduleDate, '%Y-%m-%d')
                END
                ) AS  overrideShortScheduledDate";
    }
    /*
        NAME    : sqlCustomColumnLastCallBackDate
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function sqlCustomColumnLastCallBackDate()
    {
        return "STR_TO_DATE(
            JSON_UNQUOTE(
                JSON_EXTRACT(
                    scheduler,
                    '$.callLog[0].callbackDate'
                )
            ),
            '%m/%d/%Y'
        ) AS lastCallBackDate";
    }

   
     /*
        NAME    : sqlCustomColumnSimpleJsonExtract
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function sqlCustomColumnSimpleJsonExtract($column_name,$json_field,$alias_name)
    {
        return "JSON_UNQUOTE(JSON_EXTRACT($column_name,'$.$json_field')) AS ".$alias_name;
    }

     /*
        NAME    : sqlCustomMemberInfoFiled
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function sqlCustomMemberInfoFiled($json_field,$alias_name)
    {
        return "UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.$json_field')))) AS ".$alias_name; 
    }



     /*
        NAME    : sqlCustomColumnHraStatusHistoryDays
        TYPE    : global Utiltiy function 
        DETAILS : HRA_DAYS_BY_STATUS,HRA_DATYS are custom sql function defined in database.
                    used to calculated hra days from curent date by hra status
        RETURN  : 
    */
    public static function sqlCustomColumnHraStatusHistoryDays($tab_condition,$alias_name)
    {
        return "HRA_DAYS_BY_TAB(hraStatusHistory,$tab_condition,hraStatus) AS ".$alias_name;
    }


    public static function whereClausesubStatusIn($search_by,$filter_parameters)
    {
        
		if (array_key_exists($search_by, $filter_parameters))
		{
			$search_value = $filter_parameters[$search_by];
			if(!empty($filter_parameters[$search_by]))
			{
                $user_id_array_string = $filter_parameters[$search_by];
                $user_ids_array = explode("_", $filter_parameters[$search_by]);
             
                if(count($user_ids_array))
                {
            
                    $user_id_array_string = implode(",", $user_ids_array);
                }

				return "member_table.query_form_review_count in( $user_id_array_string)";
			}
            if($filter_parameters[$search_by] == 0){
                $user_id_array_string = $filter_parameters[$search_by];
                return "member_table.query_form_review_count in( $user_id_array_string)";

            }
		}

        return FALSE;
    }

     /*
        NAME    : sqlCustomColumnQueryFormReviewCount
        TYPE    : global Utiltiy function 
        DETAILS : review count based on query form 
        RETURN  : 
    */
    public static function sqlCustomColumnQueryFormReviewCount($user_role,$alias_name)
    {
        $query_role = "unknown";
        switch($user_role)
        {
            case UserRoleConstant::QA:
            case UserRoleConstant::QA_LEAD:
                $query_role = "qa";
            break;

            case UserRoleConstant::CODER:
            case UserRoleConstant::CODER_LEAD:
                $query_role = "coder";
            break;

            case UserRoleConstant::NURSE:
              //  $query_role = "nurse";
$query_role = "coder";
            break;
        }
        
       	return "( CASE WHEN JSON_SEARCH( query_form,'all','%$query_role%',NULL,'$.queryData[*].role' ) is NULL then 0 when  JSON_LENGTH(JSON_SEARCH(query_form,'all','%$query_role%',NULL,'$.queryData[*].role')) >=0 then JSON_LENGTH(JSON_SEARCH(query_form,'all','%$query_role%',NULL,'$.queryData[*].role' )) END) AS ". $alias_name;
    }


    public static function sqlCustomColumnnoshow($noshow){

return "(
    CASE WHEN JSON_UNQUOTE(JSON_EXTRACT(reportStatus, '$.text')) = 'F2F No Show' THEN 'F2F'
    
    WHEN JSON_UNQUOTE(JSON_EXTRACT(reportStatus, '$.text')) = 'Virtual No Show' THEN 'Virtual'

    WHEN JSON_UNQUOTE(JSON_EXTRACT(importTrackerDetails, '$.noShowReportStatus')) <> '' THEN JSON_UNQUOTE(JSON_EXTRACT(importTrackerDetails, '$.noShowReportStatus'))

    WHEN  JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(cancelHistory, '$.noShow'))) <> 0 and JSON_UNQUOTE(JSON_EXTRACT(cancelHistory,CONCAT('$.noShow[',JSON_LENGTH(`cancelHistory` ->> '$.noShow')-1,'].type'))) = 'In Person' THEN 'F2F'

   

    WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(cancelHistory, '$.noShow'))) <> 0 and  JSON_UNQUOTE(JSON_EXTRACT(cancelHistory,CONCAT('$.noShow[',JSON_LENGTH(`cancelHistory` ->> '$.noShow')-1,'].type'))) = 'Virtual' THEN 'Virtual'


   END )AS ".$noshow;
    }


         /*
        NAME    : sqlCustomColumnReportStatus
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : refusalForQa
    */
    public static function sqlCustomColumnReadyForQa($readyForQa){

        return "( CASE 
        WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.readyForQa'))) <> 0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,CONCAT('$.readyForQa[',JSON_LENGTH(`hraStatusHistory` ->> '$.readyForQa')-1,'].date')))

            
            END )AS ".$readyForQa;

    }


     public static function sqlCustomColumnQaAssignedDate($qaAssignedDatee){

       return "( CASE 
        WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.qaAssigned'))) <> 0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,CONCAT('$.qaAssigned[',JSON_LENGTH(`hraStatusHistory` ->> '$.qaAssigned')-1,'].date')))

            
            END )AS ".$qaAssignedDatee;

    
    }


    public static function sqlCustomColumnCoderAssignedDate($coderassigneddatee){

        return "( CASE 
        WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.coderAssigned'))) <> 0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,CONCAT('$.coderAssigned[',JSON_LENGTH(`hraStatusHistory` ->> '$.coderAssigned')-1,'].date')))


            END )AS ".$coderassigneddatee;

    }

    public static function sqlCustomColumnReadyForUploadDate($readyforuploaddatee){
        return "( CASE 
        WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.readyForUpload'))) <> 0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,CONCAT('$.readyForUpload[',JSON_LENGTH(`hraStatusHistory` ->> '$.readyForUpload')-1,'].date')))


            END )AS ".$readyforuploaddatee;

    }


     public static function sqlCustomColumnCompletedDate($completeddatee) {
        return "( CASE 
        WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.completed'))) <> 0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,CONCAT('$.completed[',JSON_LENGTH(`hraStatusHistory` ->> '$.completed')-1,'].date')))

            
            END )AS ".$completeddatee;

    }


    /*
        NAME    : sqlCustomColumnReportStatus
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : refusalLetterDate
    */
   public static function sqlCustomColumnRefusalDate($refusalDate){

    return "(
        CASE
         WHEN refusalLetterDate IS NOT NULL 
        THEN 
        refusalLetterDate + INTERVAL 4 - weekday(refusalLetterDate) DAY
    
            WHEN
             refusalLetterDate IS  NULL   AND importTrackerDetails is NOT NULL AND JSON_UNQUOTE(JSON_EXTRACT(importTrackerDetails, '$.refusalLetterEligibility')) <> ''
              THEN JSON_UNQUOTE(JSON_EXTRACT(importTrackerDetails, '$.refusalLetterEligibility')) + INTERVAL 4 - weekday(JSON_UNQUOTE(JSON_EXTRACT(importTrackerDetails, '$.refusalLetterEligibility'))) DAY
    
            
            WHEN 
            hraStatusHistory is NOT NULL and (JSON_UNQUOTE(JSON_EXTRACT(memberinfo, '$.Plan')) =  'VPHP - VIRGINIA PREMIER' OR JSON_UNQUOTE(JSON_EXTRACT(memberinfo, '$.Plan')) =  'VPHP') and   clientid = 'client_001' AND    JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.patientRefusal'))) >= 1 
            
                       THEN 
            JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,CONCAT('$.patientRefusal[',JSON_LENGTH(`hraStatusHistory` ->> '$.patientRefusal')-1,'].date'))) + INTERVAL 4 - weekday(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,CONCAT('$.patientRefusal[',JSON_LENGTH(`hraStatusHistory` ->> '$.patientRefusal')-1,'].date')))) DAY 	
    
            WHEN 
            hraStatusHistory is NOT NULL and (JSON_UNQUOTE(JSON_EXTRACT(memberinfo, '$.Plan')) =  'VPHP - VIRGINIA PREMIER' OR JSON_UNQUOTE(JSON_EXTRACT(memberinfo, '$.Plan')) =  'VPHP') and   clientid = 'client_001' AND    JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.patientRefusal'))) = 0
            
            THEN ''
    
            WHEN 
            hraStatusHistory is  NULL and JSON_UNQUOTE(JSON_EXTRACT(memberinfo, '$.Plan')) = 'VPHP - VIRGINIA PREMIER' and   clientid = 'client_001' AND    JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.patientRefusal'))) = 0
    
             THEN ''
    
             WHEN 
             hraStatusHistory is NOT NULL and (JSON_UNQUOTE(JSON_EXTRACT(memberinfo, '$.Plan')) =  'VPHP - VIRGINIA PREMIER' OR JSON_UNQUOTE(JSON_EXTRACT(memberinfo, '$.Plan')) =  'VPHP') and   clientid <> 'client_001' AND    JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.patientRefusal'))) >= 1
             
             THEN 'NA'
    
    
             WHEN 
             hraStatusHistory is NOT NULL and JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.patientRefusal'))) >= 1
             THEN 'NA'
    
          
           ELSE ''
            
            END )AS ".$refusalDate;
        

    }

    /*
        NAME    : sqlCustomColumnReportStatus
        TYPE    : global Utiltiy function 
        DETAILS : when hra status is not due and status is empty than
                   set report status as 'Not Due' else capture report status text
        RETURN  : 
    */
    public static function sqlCustomColumnReportStatus($alias_name)
    {
        return "(CASE
                    WHEN
                        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 20 AND 
                        (reportStatus IS NULL OR JSON_UNQUOTE(JSON_EXTRACT(reportStatus, '$.text')) = '')
                    THEN
                        'Not Due'
                    WHEN
                        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 0 AND 
                        (reportStatus IS NULL OR JSON_UNQUOTE(JSON_EXTRACT(reportStatus, '$.text')) = '')
                    THEN
                        ''
                    ELSE 
                        JSON_UNQUOTE(JSON_EXTRACT(reportStatus, '$.text'))
                END
                ) AS ".$alias_name;
    }


        /*
        NAME    : sqlCustomColumnReportStatusbychar
        TYPE    : global Utiltiy function 
        DETAILS : when hra status is not due and status is empty than
                   set report status as 'Not Due' else capture report status text
        RETURN  : 
    */

    public static function sqlCustomColumnReportStatusbychar($alias_name)
    {
        return "(CASE
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 20 
        THEN
        'Not Due'
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 19 
        THEN
        'NO SHOW'
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 18 
        THEN
        'TERM EXPIRED'
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 17 
        THEN
        'OTHER'
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 16 
        THEN
        'HOSPICE'
        
        
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 15 
        THEN
        'DECEASED'
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 14 
        THEN
        'INELIGIBILE'
        
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 13 
        THEN
        'PRE-SCHEDULED'
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 12 
        THEN
        'ASSESSMENT CANCEllED'
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 11 
        THEN
        'COMPLETED'
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 10 
        THEN
        'READY FOR UPLOAD'
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 9 
        THEN
        'CLINICAIN REVIEW CODER'
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 8 
        THEN
        'CLINICIAN REVIEW QA'
        
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 7 
        THEN
        'READY FOR CODER'
        
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 6 
        THEN
        'READY FOR QA'
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 5 
        THEN
        'UTC'
        


        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 4 
        THEN
        'PATIENT REFUSUAL'

        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 3 
        THEN
        'APPOINTMENT CANCELLED'
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 2 
        THEN
        'IN PROGRESS'
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 1 
        THEN
        'SCHEDULED'
        
        
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 0 
        THEN
        'UNSCHEDULED'


                   
                   
                END
                ) AS ".$alias_name;
    }

    //---------------------------WHERE CLAUSE QUERY --------------------------
    /*
        NAME    : whereClauseColumnByName
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function whereClauseColumnByName($column_name,$filter_array,$filter_by)
    {
		if (array_key_exists($filter_by, $filter_array))
		{
			$filter_value = $filter_array[$filter_by];
			if(!empty($filter_array[$filter_by]))
			{
				return "member_table.".$column_name." ='$filter_value'";
			}
		}

        return FALSE;
    }

    /*
        NAME    : whereClauseCustomColumnValueIn
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function whereClauseCustomColumnValueIn($column_name,$filter_array,$filter_by,$is_quoted=false,$split_by='_',$join_by=',')
    {
        if(array_key_exists($filter_by,$filter_array))
        {
            $search_value_in_format = FALSE;
            if(StringUtility::isValueSet($filter_array[$filter_by]))
            {
                $search_value_in_format = StringUtility::splitAndJoinWith($filter_array[$filter_by],$split_by,$join_by,$is_quoted);
                if($search_value_in_format)
                {
                    return "member_table.".$column_name." IN ($search_value_in_format)";
                }
            }
        }

        return FALSE;
    }

    /*
        NAME    : whereClauseColumnSimpleJsonFieldsIn
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function whereClauseColumnSimpleJsonFieldsIn($column_name,$filter_array,$filter_by,$field_by,$is_quoted=false,$split_by='_',$join_by=',')
    {
//print_r($filter_array);die;
        $search_value_in_format = FALSE;
        if(array_key_exists($filter_by,$filter_array))
        {
            if(StringUtility::isValueSet($filter_array[$filter_by]))
            {
//echo $filter_array[$filter_by];die;
               $search_value_in_format = StringUtility::splitAndJoinWith($filter_array[$filter_by],$split_by,$join_by,$is_quoted);
                if($search_value_in_format)
                {
                    //return "UPPER(JSON_UNQUOTE(JSON_EXTRACT(member_table.".$column_name.",'$.$field_by'))) IN (UPPER($search_value_in_format))";
 return "UPPER(JSON_UNQUOTE(JSON_EXTRACT(member_table.".$column_name.",'$.$field_by'))) IN ($search_value_in_format)";

                }
            }
        }

        return FALSE;
    }

    /*
        NAME    : whereClauseColumnSimpleJsonField
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function whereClauseColumnSimpleJsonField($column_name,$filter_array,$filter_by,$field_by,$condition_type = '=')
    {
        if(array_key_exists($filter_by,$filter_array))
        {
            if(StringUtility::isValueSet($filter_array[$filter_by]))
            {
                $search_value = $filter_array[$filter_by];
                if($search_value)
                {
                    $query_string_array[] ="JSON_UNQUOTE(JSON_EXTRACT(member_table.".$column_name.",'$.$field_by'))";
                    $query_string_array[] =$condition_type ;
                    $query_string_array[] =$search_value ;
                    return implode($query_string_array);
                }
            }
        }

        return FALSE;
    }

    /*
        NAME    : whereClauseHraFileSearchLikeQuery
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function whereClauseHraFileSearchLikeQuery($search_by,$search_value)
    {
        return "JSON_UNQUOTE(
            JSON_EXTRACT(
                member_table.hraFileUpdatedHistory,
            REPLACE
                (
                    JSON_UNQUOTE(
                        JSON_SEARCH(
                            member_table.hraFileUpdatedHistory,
                            'one',
                            'demographic'
                        )
                    ),
                    '.component',
                    '.value[0].$search_by'
                )
            )
        ) LIKE '%$search_value%'";
    }

     /*
        NAME    : whereClauseSearchMemberInfoLikeQuery
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function whereClauseSearchMemberInfoLikeQuery($search_by,$search_value)
    {
        return "JSON_UNQUOTE(
            JSON_EXTRACT(
                member_table.memberinfo,'$.$search_by')
            )
         LIKE '%$search_value%'";
    }

     /*
        NAME    : whereClauseLastCallLog
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function whereClauseLastCallLog($search_by,$search_value)
    {
        return "JSON_EXTRACT(member_table.scheduler,'$.callLog[0].$search_by') = '$search_value'";
    }




     /*
        NAME    : whereClauseNextOutreachCallBackDateRange
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function whereClauseNextOutreachCallBackDateRange($filter_array){
        if((! $filter_array['nextOutreachCallBackToDate'] &&  $filter_array['nextOutreachCallBackFromDate']) || ( $filter_array['nextOutreachCallBackToDate'] && ! $filter_array['nextOutreachCallBackFromDate'])) {
            //  echo "hii";die;
          if(! $filter_array['nextOutreachCallBackToDate']){
  
              $filter_array['nextOutreachCallBackToDate'] = date('Y-m-d');
   
          }
          if(! $filter_array['nextOutreachCallBackFromDate']){
  
              $filter_array['nextOutreachCallBackFromDate'] = '2021-01-01';
          }
      }

      if(array_key_exists('nextOutreachCallBackFromDate', $filter_array) && array_key_exists('nextOutreachCallBackToDate', $filter_array)){
        if(!empty($filter_array['nextOutreachCallBackFromDate']) && !empty($filter_array['nextOutreachCallBackToDate']))
        {
            $call_back_from = $filter_array['nextOutreachCallBackFromDate'];
            $call_back_to = $filter_array['nextOutreachCallBackToDate'];
            if(DateUtility::isValidateDateFormat($call_back_from,"Y-m-d") && DateUtility::isValidateDateFormat($call_back_to,"Y-m-d"))
            {
                // return "member_table.reportStatus in  ('Pending','Disconnected') and ( STR_TO_DATE(
                //     JSON_UNQUOTE(
                //         JSON_EXTRACT(
                //             scheduler,
                //             '$.callLog[0].callbackDate'
                //         )
                //     ),
                //     '%m/%d/%Y'
                // ) BETWEEN '$call_back_from' AND DATE_ADD('$call_back_to',INTERVAL 1 DAY))";

                return "member_table.reportStatus in  ('Pending','Disconnected') and (STR_TO_DATE(RTRIM(SUBSTRING_INDEX(JSON_UNQUOTE(JSON_EXTRACT(scheduler,'$.callLog[0].callbackDate')),'
                @',1)), '%m/%d/%Y') BETWEEN '$call_back_from' AND '$call_back_to')";
            }
        }

      }
      return FALSE;

    }

     /*
        NAME    : whereClauseLastCallLogCallBackDateRange
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
	    public static function whereClauseLastCallLogCallBackDateRange($filter_array)
    {

        if((! $filter_array['callBackDateTo'] &&  $filter_array['callBackDateFrom']) || ( $filter_array['callBackDateTo'] && ! $filter_array['callBackDateFrom'])) {
         
        if(! $filter_array['callBackDateTo']){

            $filter_array['callBackDateTo'] = date('Y-m-d');
 
        }
        if(! $filter_array['callBackDateFrom']){

            $filter_array['callBackDateFrom'] = '2021-01-01';
        }
    }

        if(array_key_exists('callBackDateFrom', $filter_array) && array_key_exists('callBackDateTo', $filter_array))
		{
         
			if(!empty($filter_array['callBackDateFrom']) && !empty($filter_array['callBackDateTo']))
			{
				$call_back_from = $filter_array['callBackDateFrom'];
				$call_back_to = $filter_array['callBackDateTo'];
				if(DateUtility::isValidateDateFormat($call_back_from,"Y-m-d") && DateUtility::isValidateDateFormat($call_back_to,"Y-m-d"))
				{
                    return "member_table.reportStatus = 'Call Back' and ( STR_TO_DATE(
                        JSON_UNQUOTE(
                            JSON_EXTRACT(
                                scheduler,
                                '$.callLog[0].callbackDate'
                            )
                        ),
                        '%m/%d/%Y'
                    ) BETWEEN '$call_back_from' AND DATE_ADD('$call_back_to',INTERVAL 1 DAY))";
				}
			}
		}

        return FALSE;
    }
	
	/*
        NAME    : whereClauseReportRefusalTabConditionQuery
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */


    public static function whereClauseHomeAccessResultsTabConditionQuery($getmemberlists){
        return "JSON_EXTRACT(
            member_table.hraFileUpdatedHistory,
        REPLACE
            (
                json_unquote(
                    json_search(
                        member_table.hraFileUpdatedHistory,
                        'one',
                        'screening'
                    )
                ),
                '.component',
                '.status'
            )
        )= TRUE  and member_table.member_id in (".$getmemberlists.") ";
    }

     /*
        NAME    : whereClauseReportQATabConditionQuery
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function whereClauseReportQATabConditionQuery()
    {
        return "((JSON_LENGTH (member_table.cancelHistory,'$.noShow') >0 or 
        JSON_LENGTH (member_table.cancelHistory,'$.utc') >0 or 
        JSON_LENGTH (member_table.cancelHistory,'$.patientRefusal') >0 or 
        JSON_LENGTH (member_table.cancelHistory,'$.appointmentCancelled') >0)  AND 
        (JSON_EXTRACT (member_table.hraStatus,'$.hraStatus')=1 or 
        JSON_EXTRACT (member_table.hraStatus,'$.hraStatus')=2 or 
        JSON_EXTRACT (member_table.hraStatus,'$.hraStatus')=13 or 
        JSON_EXTRACT (member_table.hraStatus,'$.hraStatus')=14 or 
        JSON_EXTRACT (member_table.hraStatus,'$.hraStatus')=15 or 
        JSON_EXTRACT (member_table.hraStatus,'$.hraStatus')=16 or
        JSON_EXTRACT (member_table.hraStatus,'$.hraStatus')=17)) OR 
        (
          (
            (
              JSON_EXTRACT (member_table.hraStatus,'$.hraStatus')=4 or 
              JSON_EXTRACT (member_table.hraStatus,'$.hraStatus')=5
            )
            AND
            (
              (
                JSON_LENGTH (member_table.cancelHistory,'$.patientRefusal') =1 
                and 
                (
                  JSON_LENGTH (member_table.cancelHistory,'$.utc') >=1 or 
                  JSON_LENGTH (member_table.cancelHistory,'$.noShow') >=1 or 
                  JSON_LENGTH (member_table.cancelHistory,'$.appointmentCancelled') >=1
                )
              ) 
              or 
              (
                JSON_LENGTH (member_table.cancelHistory,'$.utc') =1 
                and 
                (
                  JSON_LENGTH (member_table.cancelHistory,'$.patientRefusal') >=1 or 
                  JSON_LENGTH (member_table.cancelHistory,'$.noShow') >=1 or 
                  JSON_LENGTH (member_table.cancelHistory,'$.appointmentCancelled') >=1
                )
              )
            ) 
          )
        )" ;
    }

     /*
        NAME    : whereClauseReportRefusalTabConditionQuery
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */

    public static function whereClauseReportRefusalTabConditionQuery(){
        return "(JSON_LENGTH (member_table.hraStatus,'$.hraStatus')<=5 or
        JSON_EXTRACT (member_table.hraStatus,'$.hraStatus')=11 or 
        JSON_EXTRACT (member_table.hraStatus,'$.hraStatus')=12 or
        JSON_EXTRACT (member_table.hraStatus,'$.hraStatus')=14 or
        JSON_EXTRACT (member_table.hraStatus,'$.hraStatus')=15 or
        JSON_EXTRACT (member_table.hraStatus,'$.hraStatus')=16 or
        JSON_EXTRACT (member_table.hraStatus,'$.hraStatus')=18 or
        JSON_EXTRACT (member_table.hraStatus,'$.hraStatus')=19 or
        JSON_EXTRACT (member_table.hraStatus,'$.hraStatus')=20) AND
        (JSON_LENGTH (member_table.hraStatusHistory,'$.patientRefusal') >= 1 or
        member_table.refusalLetterDate IS NOT NULL)";
    }

    /*
        NAME    : whereClauseCallBackStatus
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function whereClauseCallBackStatus($filter_array)
    {
        
        if(array_key_exists('callBackStatus',$filter_array))
        {
            if(StringUtility::isValueSetAllowZero($filter_array['callBackStatus']))
            {
               // echo "hiie";
               $callback_status = $filter_array['callBackStatus'];

               if($callback_status=='Overdue' || $callback_status=='Due')
               {
                if($callback_status=='Overdue'){
                    $due_string = " < ";
                    
                }
                    
                    if($callback_status=='Due')
                    {
                        $due_string = " > ";
                    }

                    return "STR_TO_DATE(
                        JSON_UNQUOTE(JSON_EXTRACT(
                            scheduler,
                            '$.callLog[0].callbackDate'
                        )),
                        '%m/%d/%Y'
                    ) ".$due_string." CURDATE() OR STR_TO_DATE(
                        JSON_UNQUOTE(JSON_EXTRACT(
                            scheduler,
                            '$.callLog[0].callbackDate'
                        )),
                        '%m/%d/%Y @ %H:%i %p'
                    ) ".$due_string." CURDATE()";
                }else{
                   
                    return   "JSON_UNQUOTE(
                        JSON_EXTRACT(
                            scheduler,
                            '$.callLog[0].callbackDate'
                        )
                    )  = '".$callback_status."'";
                    
                }
            }
        }

        return FALSE;
    }

    /*
        NAME    : whereClauseCallBackDate
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function whereClauseCallBackDate($filter_array)
    {
        if(StringUtility::isValueSetAllowZero($filter_array['callBackDate']))
        {
                $callback_date = $filter_array['callBackDate'];
                
                return "STR_TO_DATE(
                            JSON_UNQUOTE(JSON_EXTRACT(
                                scheduler,
                                '$.callLog[0].callbackDate'
                            )),
                            '%m/%d/%Y'
                        )";
        }

        return FALSE;
    }

    /*
        NAME    : whereClauseLastCallLogIn
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function whereClauseLastCallLogIn($search_by,$filter_array)
    {
        if (array_key_exists('callResult', $filter_array))
        {
            $search_value_in_format = FALSE;
            if(StringUtility::isValueSetAllowZero($filter_array['callResult']))
            {
                    $filter_call_result_array = explode("_", $filter_array['callResult']);
                    if(count($filter_call_result_array))
                    {
                        $search_value_in_format = implode(", ", $filter_call_result_array);
                    }
                    else
                    {
                        return FALSE;
                    }

                return "JSON_EXTRACT(member_table.scheduler,'$.callLog[0].$search_by') IN ($search_value_in_format)";
            }
        }

        return FALSE;
    }

    /*
        NAME    : whereClauseLastCallLogWithSubResultIn
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function whereClauseLastCallLogWithSubResultIn($filter_array)
    {

        if (array_key_exists('callResult', $filter_array))
        {
            $search_value_in_format = FALSE;
            if(StringUtility::isValueSetAllowZero($filter_array['callResult']))
            {

                $filter_call_result_array = explode("_", $filter_array['callResult']);

                $combined_call_result = FALSE;
                for($cr=0;$cr<count($filter_call_result_array);$cr++)
                {
                    $call_result_array = explode('|',$filter_call_result_array[$cr]);


                    if(count($call_result_array)>1)
                    {
                        $call_result = $call_result_array[0];
                        $call_sub_result = $call_result_array[1];
                        if( $call_sub_result=='-1')
                        {
                            $combined_call_result[]="JSON_EXTRACT(member_table.scheduler,'$.callLog[0].result') = $call_result";
                            
                        }
                        else
                        {
                            $combined_call_result[]="(JSON_EXTRACT(member_table.scheduler,'$.callLog[0].result') = $call_result AND 
                                                JSON_EXTRACT(member_table.scheduler,'$.callLog[0].noAnswer') = $call_sub_result )";
                        }
                    }else{
                       $callresult = $call_result_array[0];
                        $combined_call_result[]="JSON_EXTRACT(member_table.scheduler,'$.callLog[0].result') = '".$callresult."'";

                    }
                }
                   
                if($combined_call_result===FALSE)
                {
                    return FALSE;
                }

                return "(".ArrayUtility::joinArrayByDelimiter($combined_call_result,' OR ').")";
            }
        
        }

        return FALSE;
    }

    /*
        NAME    : whereClauseByScreeningEligibility
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
	    public static function whereClauseByScreeningEligibility($filter_by,$filter_array)
    {   

        if(array_key_exists($filter_by,$filter_array))
        {
          
            if(StringUtility::isValueSetAllowZero($filter_array[$filter_by]))
            {

                    $eligibility_array = ArrayUtility::convertStringToArray($filter_array[$filter_by],'_');
 
                    if($eligibility_array)
                    {
                        $eligibility_query = array();
                        $total_eg_count = count($eligibility_array);
                        for($ev=0;$ev<$total_eg_count;$ev++)
                        {
                          
                           if (  preg_match('/^\d+$/', $eligibility_array[$ev]) ) {
                        
                            $eligibility_query = ArrayUtility::appendIfNotFalse($eligibility_query,GlobalQueryUtility::getElibilityQueryString($eligibility_array[$ev]));
                           }
                           else{
                          
                            $clause_screening_query = "JSON_UNQUOTE(JSON_EXTRACT(member_table.ScreeningEligibility,'$[6]')) ='".$eligibility_array[$ev]."'";
                            $eligibility_query = ArrayUtility::appendIfNotFalse($eligibility_query,$clause_screening_query);

                           }
                        }

                        return ArrayUtility::joinArrayByDelimiter($eligibility_query,' AND ');
                    }
            }
       
        }

        return FALSE;
    }

      /*
        NAME    : whereClauseBySpecificScreeningEligibligy
        TYPE    : global Utiltiy function 
        DETAILS : screening eligibility based on specific screening result and contidion of 'Yes' 'No' 
                    to 
        RETURN  : 
    */
	    public static function whereClauseBySpecificScreeningEligibligy($filter_array)
    {
     
        $filter_by = ArrayUtility::checkArrayWithAnyOfKeys($filter_array,['screening_0','screening_1',
                                                                          'screening_2','screening_3',
                                                                        'screening_4','screening_5','screening_6']);

        if($filter_by)
        {
            if(StringUtility::isValueSet($filter_array[$filter_by]))
            {
               
                $screeing_array = explode('_',$filter_by);
                if(count($screeing_array)>1)
                {

                    $screeing_index = $screeing_array[1];
                    $condition = $filter_array[$filter_by];
                    if($condition==='Yes' || $condition==='yes')
                    {
                        return "JSON_UNQUOTE(JSON_EXTRACT(member_table.ScreeningEligibility,'$[$screeing_index]')) = 'Yes'";
                    }
                    else if($condition==='No' || $condition==='no'){
                    return "JSON_UNQUOTE(JSON_EXTRACT(member_table.ScreeningEligibility,'$[$screeing_index]')) <> 'Yes'";
                }else{
                    return "JSON_UNQUOTE(JSON_EXTRACT(member_table.ScreeningEligibility,'$[$screeing_index]')) = 
                    '".$condition."' ";

                }
                }
            }
        }

        return FALSE;
    }

    /*
        NAME    : whereClauseHraStatusIn
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */

   public static function whereClauseHraStatusInweeklyreport($filter_array)
    {

        $hra_status_where_clause=FALSE;
        //hra status with mutilple
			if($filter_array && array_key_exists('hraStatus', $filter_array))
			{


				if(!empty($filter_array['hraStatus']) || $filter_array['hraStatus']=='0')
				{
					$hra_status_array_string = $filter_array['hraStatus'];

					$hra_status_array = explode("_", $filter_array['hraStatus']);
					if(count($hra_status_array))
					{
						$hra_status_array_string = implode(", ", $hra_status_array);
					}

					if($hra_status_array_string=='0' || ArrayUtility::getArrayFilter($hra_status_array,
                                function($hra_status){ 
                                    return $hra_status==0;
                                })
                            )
					{

                 if ( ! preg_match('/^\d+$/', $hra_status_array[0]) ) {
						$hra_status_where_clause = "( hraStatus is NULL or hraStatus='' or ";
						$hra_status_where_clause.= "JSON_EXTRACT(`hraStatus`, '$.hraStatus') IN ('".$hra_status_array_string."') )  and reportStatus not in ('UTC')";
                 }else{
                    $hra_status_where_clause = "( hraStatus is NULL or hraStatus='' or ";
                    $hra_status_where_clause.= "JSON_EXTRACT(`hraStatus`, '$.hraStatus') IN ($hra_status_array_string) )  and reportStatus not in ('UTC')";

                 }


					}
					else
					{
                       // echo "out";die;
                       if ( ! preg_match('/^\d+$/', $hra_status_array[0]) ) {

						$hra_status_where_clause.= "JSON_EXTRACT(`hraStatus`, '$.hraStatus') IN ('".$hra_status_array_string."')  and reportStatus not in ('UTC')";

                       }else {
						$hra_status_where_clause.= "JSON_EXTRACT(`hraStatus`, '$.hraStatus') IN ($hra_status_array_string) and reportStatus not in ('UTC')";
                    }
					}

					return $hra_status_where_clause;
				}
			}

        return FALSE;
    }

	    public static function whereClauseHraStatusIn($filter_array)
    {

        $hra_status_where_clause=FALSE;
        //hra status with mutilple
			if($filter_array && array_key_exists('hraStatus', $filter_array))
			{


				if(!empty($filter_array['hraStatus']) || $filter_array['hraStatus']=='0')
				{
					$hra_status_array_string = $filter_array['hraStatus'];

					$hra_status_array = explode("_", $filter_array['hraStatus']);
                  //  print_r($hra_status_array);die;
					if(count($hra_status_array))
					{
						$hra_status_array_string = implode(", ", $hra_status_array);
					}

					//if hra status is unscheduled means it may be zero,NULL,empty string (previous year table has some value)
					if($hra_status_array_string=='0' || ArrayUtility::getArrayFilter($hra_status_array,
                                function($hra_status){ 
                                    return $hra_status==0;
                                })
                            )
					{

                // if ( ! preg_match('/^\d+$/', $hra_status_array_string) ) {
 if ( ! preg_match('/^\d+$/', $hra_status_array[0]) ) {
						$hra_status_where_clause = "( hraStatus is NULL or hraStatus='' or ";
						$hra_status_where_clause.= "JSON_EXTRACT(`hraStatus`, '$.hraStatus') IN ('".$hra_status_array_string."') )";
                 }else{
                    $hra_status_where_clause = "( hraStatus is NULL or hraStatus='' or ";
                    $hra_status_where_clause.= "JSON_EXTRACT(`hraStatus`, '$.hraStatus') IN ($hra_status_array_string) )";

                 }


					}
					else
					{
                       // echo "out";die;
                       if ( ! preg_match('/^\d+$/', $hra_status_array[0]) ) {

						$hra_status_where_clause.= "JSON_EXTRACT(`hraStatus`, '$.hraStatus') IN ('".$hra_status_array_string."')";

                       }else {
						$hra_status_where_clause.= "JSON_EXTRACT(`hraStatus`, '$.hraStatus') IN ($hra_status_array_string)";
                    }
					}

					return $hra_status_where_clause;
				}
			}

        return FALSE;
    }
    
    /*
        NAME    : whereClauseUserIdIn
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */

  public static function whereClauseUserIdInweeklyreport($role,$filter_array)
    {

       //filter and role mapping 
        $user_role_filter_array = array (
                "nurse"=>array("filter"=>"nurseIds","column"=>"nurse_id"),
                "scheduler"=>array("filter"=>"schedulerIds","column"=>"scheduler_id"),
                "qa"=>array("filter"=>"qaIds","column"=>"qa_id"),
                "coder"=>array("filter"=>"coderIds","column"=>"coder_id")
            );
        
        if(array_key_exists($role,$user_role_filter_array))
        {
                 $filter_by = $user_role_filter_array[$role]['filter'];
                 $column_by =  $user_role_filter_array[$role]['column'];

                $user_id_where_clause=FALSE;
                    if (array_key_exists($filter_by, $filter_array))
                    {
                        if(!empty($filter_array[$filter_by]))
                        {
                            $user_id_array_string = $filter_array[$filter_by];
                            $user_ids_array = explode("_", $filter_array[$filter_by]);

                            if(count($user_ids_array))
                            {
                                $user_id_array_string = "'".implode("', '", $user_ids_array)."'";
                            }

                            //$user_id_where_clause= "member_table.".$column_by." IN ($user_id_array_string)";
                            $user_id_where_clause= "member_table.".$column_by." IN ($user_id_array_string) and member_table.reportStatus in ('Scheduled','Cancellation','Completed','No Show','Rescheduled','Refusal','F2F No Show','Virtual No Show')";

                        }
                    }

                    if($user_id_where_clause)
                    {
                        return " ".$user_id_where_clause." ";
                    }
                    
            }
            
        return FALSE;

    }


    public static function whereClauseCustomColumnScreening($search_by,$filter_array){

        if (array_key_exists('screening', $filter_array)){

            if(StringUtility::isValueSetAllowZero($filter_array['screening'])){
                $filter_call_result_array = explode("_", $filter_array['screening']);
   //$currentfiltersarray = array("0" => "DIGITAL_RETINAL_EXAM", "1" => "HBA1C", "2" => "MICROALBUMIN", "3" =>"FOBT", "4" =>"DEXA", "5" =>"PAD", "6" =>"LDL");
     $currentfiltersarray = array("0" => "DIGITAL RETINAL EXAM", "1" => "HBA1C", "2" => "MICROALBUMIN", "3" =>"FIT", "4" =>"DEXA", "5" =>"PAD", "6" =>"DLDL");

                $intersectresult=array_keys(array_intersect($currentfiltersarray,$filter_call_result_array));

                if(count($intersectresult))
                {
 

                    $search_value_in_format = implode(", ", $intersectresult);
                }
                else
                {
                    return FALSE;
                }
              
                return "member_table.serialnumber IN ($search_value_in_format)";

            }
        }
return FALSE;
    }


	    public static function whereClauseUserIdIn($role,$filter_array)
    {

       //filter and role mapping 
        $user_role_filter_array = array (
                "nurse"=>array("filter"=>"nurseIds","column"=>"nurse_id"),
                "scheduler"=>array("filter"=>"schedulerIds","column"=>"scheduler_id"),
                "qa"=>array("filter"=>"qaIds","column"=>"qa_id"),
                "coder"=>array("filter"=>"coderIds","column"=>"coder_id")
            );
        
        if(array_key_exists($role,$user_role_filter_array))
        {
                $filter_by = $user_role_filter_array[$role]['filter'];
                $column_by =  $user_role_filter_array[$role]['column'];

                $user_id_where_clause=FALSE;

                    if (array_key_exists($filter_by, $filter_array))
                    {
                        if(!empty($filter_array[$filter_by]))
                        {
                            $user_id_array_string = $filter_array[$filter_by];
                            $user_ids_array = explode("_", $filter_array[$filter_by]);
                          

                            if(count($user_ids_array))
                            {
                                $user_id_array_string = "'".implode("', '", $user_ids_array)."'";
                            }

                            $user_id_where_clause= "member_table.".$column_by." IN ($user_id_array_string)";
                        }
                    }
               
                    if($user_id_where_clause)
                    {
                        return " ".$user_id_where_clause." ";
                    }
                    
            }
            
        return FALSE;

    }


     /*
        NAME    : whereClauseScheduleDateBetween
        TYPE    : global Utiltiy function 
        DETAILS : refusal date between where clause condition
        RETURN  : 
    */


    public static function whereClauseRefusalDateBetween($filter_array)
    {

        if((! $filter_array['refusalTo'] &&  $filter_array['refusalFrom']) || ( $filter_array['refusalTo'] && ! $filter_array['refusalFrom'])) {
           
          if(! $filter_array['refusalTo']){
  
              $filter_array['refusalTo'] = date('Y-m-d');
   
          }
          if(! $filter_array['refusalFrom']){
  
              $filter_array['refusalFrom'] = '2021-01-01';
          }
      }
      

        if(array_key_exists('refusalFrom', $filter_array) && array_key_exists('refusalTo', $filter_array))
		{
			if(!empty($filter_array['refusalFrom']) && !empty($filter_array['refusalTo']))
			{
				$refusal_from = $filter_array['refusalFrom'];
				$refusal_to = $filter_array['refusalTo'];
		

                if(DateUtility::isValidateDateFormat($refusal_from,"Y-m-d") && DateUtility::isValidateDateFormat($refusal_to,"Y-m-d"))
				{
                  
                    return "( STR_TO_DATE(member_table.refusalDate,'%Y-%m-%d') BETWEEN '$refusal_from' AND '$refusal_to' ) ";
				}
			}
		}

        return FALSE;
    }

     /*
        NAME    : whereClauseScheduleDateBetween
        TYPE    : global Utiltiy function 
        DETAILS : schedule date between where lause condition
        RETURN  : 
    */
    public static function whereClauseScheduleDateBetween($filter_array)
    {
 $tabid = $filter_array['tabId'];
        if((! $filter_array['scheduledTo'] &&  $filter_array['scheduledFrom']) || ( $filter_array['scheduledTo'] && ! $filter_array['scheduledFrom'])) {
            //  echo "hii";die;
          if(! $filter_array['scheduledTo']){
  
              $filter_array['scheduledTo'] = date('Y-m-d');
   
          }
          if(! $filter_array['scheduledFrom']){
  
              $filter_array['scheduledFrom'] = '2021-01-01';
          }
      }
      

        if(array_key_exists('scheduledFrom', $filter_array) && array_key_exists('scheduledTo', $filter_array))
		{
			if(!empty($filter_array['scheduledFrom']) && !empty($filter_array['scheduledTo']))
			{
				$scheduled_from = $filter_array['scheduledFrom'];
				$scheduled_to = $filter_array['scheduledTo'];
				if(DateUtility::isValidateDateFormat($scheduled_from,"Y-m-d") && DateUtility::isValidateDateFormat($scheduled_to,"Y-m-d")  && $tabid == 5)
				{
                  //  return "( STR_TO_DATE(member_table.scheduleDate,'%Y-%m-%dT%H:%i') BETWEEN '$scheduled_from' AND DATE_ADD('$scheduled_to',INTERVAL 1 DAY))";
                    return "( STR_TO_DATE(member_table.scheduleDate,'%Y-%m-%dT%H:%i') BETWEEN '$scheduled_from' AND '$scheduled_to' ) and member_table.reportStatus  in ('Scheduled','Cancellation','Completed','No Show','Rescheduled','Refusal','F2F No Show','Virtual No Show')";
				}

                if(DateUtility::isValidateDateFormat($scheduled_from,"Y-m-d") && DateUtility::isValidateDateFormat($scheduled_to,"Y-m-d") && $tabid != 5)
				{
                  //  return "( STR_TO_DATE(member_table.scheduleDate,'%Y-%m-%dT%H:%i') BETWEEN '$scheduled_from' AND DATE_ADD('$scheduled_to',INTERVAL 1 DAY))";
                    return "( STR_TO_DATE(member_table.scheduleDate,'%Y-%m-%dT%H:%i') BETWEEN '$scheduled_from' AND '$scheduled_to' ) ";
				}

			}
		}

        return FALSE;
    }

    /*
        NAME    : whereClauseForAssignAndUnAssign
        TYPE    : global Utiltiy function 
        DETAILS : scheduler lead by assigned and unassigned
        RETURN  : 
    */
    public static function whereClauseForAssignAndUnAssign($filter_array)
    {
        $assign_un_assign_query = FALSE;

        if(array_key_exists('assigned',$filter_array) && array_key_exists('unAssigned',$filter_array))
        {
            $is_assigned=$filter_array['assigned'];
            $is_unassigned=$filter_array['unAssigned'];

            if($is_assigned && $is_unassigned)
            {
               $assign_un_assign_query = "( member_table.hraStatus is NULL OR member_table.hraStatus='' OR JSON_EXTRACT(member_table.hraStatus, '$.hraStatus') IN(0) )";
            }
            else if($is_assigned)
            {
                $assign_un_assign_query = "( member_table.scheduler_id IS NOT NULL AND ( member_table.hraStatus is NULL or member_table.hraStatus='' OR JSON_EXTRACT(member_table.hraStatus, '$.hraStatus') IN(0)))";
            }
            else if($is_unassigned)
            {
                $assign_un_assign_query = "( ( member_table.scheduler_id IS NULL OR member_table.scheduler_id='') AND ( member_table.hraStatus IS NULL OR member_table.hraStatus='' OR JSON_EXTRACT(member_table.hraStatus, '$.hraStatus') IN (0) ) )";                        		 
            }
        }

        return $assign_un_assign_query;
    }

    
    /*
        NAME    : whereClauseForMemberUnAssign
        TYPE    : global Utiltiy function 
        DETAILS : unassigned member where clause conditon based on user role
        RETURN  : 
    */
    public static function whereClauseForMemberUnAssign($filter_array,$user_role)
    {
        $assign_un_assign_query = FALSE;

        if(array_key_exists('unAssigned',$filter_array))
        {
           
            $is_unassigned=$filter_array['unAssigned'];
            if($is_unassigned)
            {
                switch($user_role)
                {
                    case UserRoleConstant::SCHEDULER:
                        $assign_un_assign_query = "( member_table.scheduler_id IS NULL or member_table.scheduler_id='' )"; 
                    break;

                    case UserRoleConstant::QA:
                        $assign_un_assign_query = "( member_table.qa_id IS NULL or member_table.qa_id='' )"; 
                    break;

                    case UserRoleConstant::CODER:
                        $assign_un_assign_query = "( member_table.coder_id IS NULL or member_table.coder_id='' )"; 
                    break;
                }                     		 
            }
        }

        return $assign_un_assign_query;
    }

     /*
        NAME    : whereClauseForMemberAssigned
        TYPE    : global Utiltiy function 
        DETAILS : assigned member where clause conditon based on user role
        RETURN  : 
    */
    public static function whereClauseForMemberAssigned($filter_array,$user_role)
    {
        $assign_un_assign_query = FALSE;

        if(array_key_exists('assigned',$filter_array))
        {
           
            $is_unassigned=$filter_array['assigned'];
            if($is_unassigned)
            {
                switch($user_role)
                {
                    case UserRoleConstant::SCHEDULER:
                        $assign_un_assign_query = "( member_table.scheduler_id IS NOT NULL or member_table.scheduler_id<>'' )"; 
                    break;

                    case UserRoleConstant::QA:
                        $assign_un_assign_query = "( member_table.qa_id IS NOT NULL or member_table.qa_id<>'' )"; 
                    break;

                    case UserRoleConstant::CODER:
                        $assign_un_assign_query = "( member_table.coder_id IS NOT NULL or member_table.coder_id<>'' )"; 
                    break;
                }                     		 
            }
        }

        return $assign_un_assign_query;
    }

   /*
        NAME    : sqlCustomColumnQueryFormMemberListReviewCount
        TYPE    : global Utiltiy function 
        DETAILS : review count based on query form from member list
        RETURN  : 
    */
    public static function sqlCustomColumnQueryFormMemberListReviewCount($user_role,$alias_name)
    {
        return "CASE WHEN (JSON_EXTRACT(hraStatus,'$.hraStatus')) = 6 THEN JSON_LENGTH(JSON_SEARCH(
                        query_form,
                        'all','%qa%',NULL,
                        '$.queryData[*].role'
                    )) WHEN (JSON_EXTRACT(hraStatus,'$.hraStatus')) = 7 THEN JSON_LENGTH(JSON_SEARCH(
                        query_form,
                        'all','%coder%',NULL,
                        '$.queryData[*].role'
                    )) WHEN (JSON_EXTRACT(hraStatus,'$.hraStatus')) in (8,9) THEN JSON_LENGTH(JSON_SEARCH(
                        query_form,
                        'all','%nurse%',NULL,
                        '$.queryData[*].role'
                    ))
                    END AS query_form_review_count";
    }


/*
        NAME    : whereClauseMemberListHraStatusIn
        TYPE    : global Utiltiy function for member list
        DETAILS : 
        RETURN  : 
    */
    public static function whereClauseMemberListHraStatusIn($filter_array)
    {
        $hra_status_where_clause=FALSE;
        $hra_status_where_clause = "(CASE WHEN JSON_EXTRACT(`hraStatus`, '$.hraStatus') IN (6) THEN JSON_EXTRACT(`hraStatus`, '$.hraStatus') IN (6)
        WHEN JSON_EXTRACT(`hraStatus`, '$.hraStatus') IN (7) THEN JSON_EXTRACT(`hraStatus`, '$.hraStatus') IN (7)
        WHEN JSON_EXTRACT(`hraStatus`, '$.hraStatus') IN (8,9) THEN JSON_EXTRACT(`hraStatus`, '$.hraStatus') IN (8,9) ELSE JSON_EXTRACT(`hraStatus`, '$.hraStatus') END)";

        return $hra_status_where_clause;

    }


    // ---------------------------------------- ORDER BY QUERY ----------------------------------
    /*
        NAME    : orderBy
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function orderBy($role,$base_order_by,$column_order_by,$base_order_type='ASC',$column_order_type='ASC')
    {
        $order_by_query = FALSE;
        $base_order_by = GlobalHelper::convertOrderBytoColumnName($base_order_by);
        switch($column_order_by)
        {

            case 'custom' :
                
                //$order_by_query = "(CASE WHEN customone IS NULL OR customone ='' THEN 1 ELSE 0 END),customone";
$order_by_query = "(CASE WHEN memberLob IS NULL OR memberLob ='' THEN 1 ELSE 0 END),memberLob";
              break;

 case 'returnmail':
                $order_by_query = "(CASE WHEN  member_global_status.return_mail IS NULL THEN 1 ELSE 0 END), member_global_status.return_mail";
            break;

            case 'pcpname':
            $order_by_query = "JSON_UNQUOTE(JSON_EXTRACT(Demographic,'$.pcpname'))"; 
			break;

            case 'pcpstate':
                $order_by_query = "JSON_UNQUOTE(JSON_EXTRACT(Demographic,'$.pcpstate'))";
				break;
      
            case 'pcpcity':
                    $order_by_query = "JSON_UNQUOTE(JSON_EXTRACT(Demographic,'$.pcpcity'))";  break;
             case 'pphy':
                  $order_by_query = "JSON_UNQUOTE(JSON_EXTRACT(Demographic,'$.pphy'))";  break;

                      case 'pcpfname':
                        $order_by_query = "(CASE WHEN pcpfname IS NULL OR pcpfname ='' THEN 1 ELSE 0 END),pcpfname";  break;
                        
                        case 'pcplname':
                        $order_by_query = "(CASE WHEN pcplname IS NULL OR pcplname ='' THEN 1 ELSE 0 END),pcplname"; 
                        break;




case 'readyforuploaddate' :
 $order_by_query = "(CASE WHEN readyforuploaddatee IS NULL OR readyforuploaddatee ='' THEN 1 ELSE 0 END),readyforuploaddatee";
break;

					 case 'readyforqadate':
                        $order_by_query = "(CASE WHEN readyForQa IS NULL OR readyForQa ='' THEN 1 ELSE 0 END),readyForQa";
                     break;

                    case 'coderassigneddate':
                        $order_by_query = "(CASE WHEN coderassigneddatee IS NULL OR coderassigneddatee ='' THEN 1 ELSE 0 END),coderassigneddatee";
                     break;
						
						
                     case 'readyforupload':
                        $order_by_query = "JSON_UNQUOTE(
                            JSON_EXTRACT(
                                hraStatusHistory,
                                '$.readyForUpload[0].date'
                            ) 
                        )";
                     break;

                  

            case 'noshow':
                $order_by_query = "(CASE WHEN noShowInfo IS NULL OR noShowInfo ='' THEN 1 ELSE 0 END),noShowInfo";
            break;
                    
    

            case 'completed':  
                        $order_by_query = "JSON_UNQUOTE(
                            JSON_EXTRACT(
                                hraStatusHistory,
                                '$.completed[0].date'
                            ) 
                        )";
                     break;

case 'gender':
            $order_by_query = "(CASE WHEN memberGender IS NULL OR memberGender ='' THEN 1 ELSE 0 END),memberGender";
        break;

case 'completeddate' :
			
$order_by_query = "(CASE WHEN completeddatee IS NULL OR completeddatee ='' THEN 1 ELSE 0 END),completeddatee";
break;


case 'qaassigneddate':
                    $order_by_query = "(CASE WHEN qaAssignedDatee IS NULL OR qaAssignedDatee ='' THEN 1 ELSE 0 END),qaAssignedDatee";
                 break;

			case 'plan':
                $order_by_query = "(CASE WHEN memberPlan IS NULL OR memberPlan ='' THEN 1 ELSE 0 END),memberPlan";
            break;            

            case 'program':
                $order_by_query = "(CASE WHEN memberProgram IS NULL OR memberProgram ='' THEN 1 ELSE 0 END),memberProgram";
            break;
            case 'lob':
                $order_by_query = "(CASE WHEN memberLob IS NULL OR memberLob ='' THEN 1 ELSE 0 END),memberLob";
            break;
            case 'id':
                $order_by_query = "CONVERT(REPLACE(member_table.member_id,'*',''), UNSIGNED INTEGER)";
            break;
            case 'clientid':
                $order_by_query = "client_id";
            break;
            case 'year':
                $order_by_query = "client_year";
            break;
            case 'name':
                $order_by_query = "(CASE WHEN memberFirstName IS NULL OR memberFirstName ='' THEN 1 ELSE 0 END),memberFirstName";
            break;

           // case 'fname':
             //   $order_by_query = "(CASE WHEN memberFirstName IS NULL OR memberFirstName ='' THEN 1 ELSE 0 END),memberFirstName";
            //break;

            case 'lname':
                $order_by_query = "(CASE WHEN memberLastName IS NULL OR memberLastName ='' THEN 1 ELSE 0 END),memberLastName";
            break;
            case 'city':
                $order_by_query = "(CASE WHEN memberCity IS NULL OR memberCity ='' THEN 1 ELSE 0 END),memberCity";
            break;
            case 'state':
                $order_by_query = "(CASE WHEN memberState IS NULL OR memberState ='' THEN 1 ELSE 0 END),memberState";
            break;
            case 'country':
                $order_by_query = "(CASE WHEN memberCountry IS NULL OR memberCountry ='' THEN 1 ELSE 0 END),memberCountry";
            break;
            case 'language':
                $order_by_query = "(CASE WHEN memberLanguage IS NULL OR memberLanguage ='' THEN 1 ELSE 0 END),memberLanguage";
            break;

            case 'zip':
                $order_by_query = "(CASE WHEN memberZip IS NULL OR memberZip ='' THEN 1 ELSE 0 END),memberZip";
            break;
            case 'hrastatus':
                $order_by_query = "(CASE WHEN member_table.hraStatus IS NULL THEN 1 ELSE 0 END),JSON_EXTRACT(member_table.hraStatus, '$.hraStatus')";
           break;

      	    case 'hrastatusbychar' :
                    $order_by_query = "( CASE WHEN hrastatusbychar IS NULL THEN 1 ELSE 0 END),member_table.hrastatusbychar";
                    break;

            case 'status':
                $order_by_query = "(CASE WHEN reportStatus IS NULL OR reportStatus ='' THEN 1 ELSE 0 END),UPPER(reportStatus)";
            break;
            case 'visittype':
                $order_by_query = "(CASE WHEN VisitType IS NULL OR VisitType ='' THEN 1 ELSE 0 END),VisitType";
            break;
            case 'schedule':
                $order_by_query = "(CASE WHEN STR_TO_DATE(member_table.scheduleDate, '%Y-%m-%d') IS NULL THEN 1 ELSE 0 END),member_table.scheduleDate";
            break;
		case 'scheduledate':
                
                $order_by_query = "(CASE WHEN STR_TO_DATE(member_table.shortscheduleDate, '%Y-%m-%d') IS NULL THEN 1 ELSE 0 END),member_table.shortscheduleDate";
            break;

case 'lastattempt':
                $order_by_query = "(CASE WHEN STR_TO_DATE(lastCallLog,'%Y-%m-%d') IS NULL THEN 1 ELSE 0 END),lastCallLog";
            break;

            case 'termdate':
                $order_by_query = "(CASE WHEN STR_TO_DATE(member_table.termDate, '%Y-%m-%d') IS NULL THEN 1 ELSE 0 END),member_table.termDate";
	
            break;
	    case 'overridescheduledatereportstatus':
		    $order_by_query = "(CASE WHEN member_table.overrideShortScheduledDate is NULL or member_table.reportStatus not in ('Scheduled','Cancellation','Completed','No Show','Rescheduled','Refusal','F2F No Show','Virtual No Show') THEN 1 ELSE 0 END),member_table.overrideShortScheduledDate";

            break;	
	    case 'overridescheduledatehrastatus':
                //$order_by_query = "(CASE WHEN member_table.overrideShortScheduledDate is NULL or hrastatusbychar not in('APPOINTMENT CANCELLED','READY FOR QA','ASSESSMENT CANCEllED','NO SHOW') THEN 1 ELSE 0 END),member_table.overrideShortScheduledDate";
		$order_by_query = "(CASE WHEN member_table.overrideShortScheduledDate is NULL or JSON_UNQUOTE(JSON_EXTRACT(member_table.hraStatus, '$.hraStatus')) not in(3, 19, 6, 7 , 8, 9, 10, 11, 12) THEN 1 ELSE 0 END),member_table.overrideShortScheduledDate";
            break;
            case 'overridescheduledate':
              //  $order_by_query = "(CASE WHEN overrideShortScheduledDate IS NULL THEN 1 ELSE 0 END),member_table.shortscheduleDate";
 $order_by_query = "(CASE WHEN overrideShortScheduledDate IS NULL  THEN 1 ELSE 0 END),member_table.overrideShortScheduledDate";

//$order_by_query = "(CASE WHEN member_table.overrideShortScheduledDate is NULL  and  reportStatus in ('Scheduled','Cancellation','Completed','No Show','Rescheduled','Refusal','F2F No Show','Virtual No Show') THEN 1 ELSE 0 END),member_table.overrideShortScheduledDate";

//$order_by_query = "(CASE WHEN overrideShortScheduledDate IS NULL  THEN 1 ELSE 0 END),member_table.overrideShortScheduledDate";

//$order_by_query = "(CASE WHEN shortscheduleDate IS NULL THEN 1 ELSE 0 END),member_table.overrideScheduledDate";
            break;
            case 'refusaldate':
               // $order_by_query = "(CASE WHEN STR_TO_DATE(member_table.refusalDate,'%Y-%m-%d') IS NULL THEN 1 ELSE 0 END),member_table.refusalDate";
 		$order_by_query = "(CASE WHEN STR_TO_DATE(member_table.refusalDate,'%Y-%m-%d') IS NULL THEN 1 ELSE 0 END),member_table.refusalDate";
            break;
            case 'senttoavility':
                $order_by_query = "(CASE WHEN STR_TO_DATE(member_table.sentToAvility,'%Y-%m-%d') IS NULL THEN 1 ELSE 0 END),member_table.sentToAvility";
            break;
            case 'invoicedate':
                $order_by_query = "(CASE WHEN STR_TO_DATE(member_table.invoiceDate,'%Y-%m-%d') IS NULL THEN 1 ELSE 0 END),member_table.invoiceDate";
            break;
            case 'evaluationdate':
                $order_by_query = "(CASE WHEN STR_TO_DATE(member_table.EvaluationDate, '%Y-%m-%d') IS NULL THEN 1 ELSE 0 END),member_table.EvaluationDate";                     
            break;
            case 'attemptcount':
                $order_by_query = "(CASE WHEN member_table.schedulerCallLogDetails IS NULL THEN 1 ELSE 0 END),JSON_EXTRACT(member_table.schedulerCallLogDetails, '$.attemptCount')";
            break;
            case 'adminname':
                $order_by_query = "(CASE WHEN admin_fullname IS NULL THEN 1 ELSE 0 END),admin_fullname";
            break;
            case 'nursename':
                $order_by_query = "(CASE WHEN nurse_fullname IS NULL THEN 1 ELSE 0 END),nurse_fullname";
            break;
            case 'schedulername':
                $order_by_query = "(CASE WHEN scheduler_fullname IS NULL THEN 1 ELSE 0 END),scheduler_fullname";
            break;
            case 'qaname':
                $order_by_query = "(CASE WHEN qa_fullname IS NULL THEN 1 ELSE 0 END),qa_fullname";
            break;
            case 'codername':
                $order_by_query = "(CASE WHEN coder_fullname IS NULL THEN 1 ELSE 0 END),coder_fullname";
            break;
            case 'lastcalllog':
                $order_by_query = "JSON_EXTRACT(lastCallLog,'$.result') ".$column_order_type." ,JSON_EXTRACT(lastCallLog,'$.noAnswer')";
            break;
            case 'eyeexam':
                $order_by_query = "(CASE WHEN member_table.ScreeningEligibility IS NULL THEN 1 ELSE 0 END),(CASE WHEN JSON_EXTRACT(member_table.ScreeningEligibility,'$[0]') = 'Yes' THEN 0 ELSE 1 END)";
            break;
            
            //hra days not supported for all tabs 
            case 'days':
                $order_by_query = "(CASE WHEN member_table.hra_days IS NULL THEN 1 ELSE 0 END),member_table.hra_days";
            break;
            //number of time query reviewed by qa,coder,nurse
            //this not supported by all the tabs
            case 'queryreview':
                $order_by_query = "(CASE WHEN member_table.query_form_review_count IS NULL THEN 9999999 ELSE member_table.query_form_review_count END)";
            break;

        }
        
        if($base_order_by || $order_by_query)
        {
            $order_by_query_array = array();
            $order_by_query_string = " ORDER BY ";

                if(StringUtility::isValueSet($base_order_by)) 
                {
                    $order_by_query_array = ArrayUtility::appendIfNotFalse($order_by_query_array,$base_order_by." ".$base_order_type);
                }

                if(StringUtility::isValueSet($order_by_query)) 
                {
                    $order_by_query_array = ArrayUtility::appendIfNotFalse($order_by_query_array,$order_by_query." ".$column_order_type);
                }

            return  $order_by_query_string.ArrayUtility::joinArrayByDelimiter($order_by_query_array,',');
        }

        return FALSE;
    }

    // ---------------------------------------- SEARCH WHERE CLAUSE QUERY --------------------------------------
    /*
        NAME    : searchByColumnLike
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function searchByColumnLike($column_name,$search_array,$search_by,$min_text_len=3)
    {
        //firstname
        if (array_key_exists($search_by,$search_array))
        {
            $column_search_by = 'member_table.'.$column_name;
            $search_value = trim($search_array[$search_by]);
            if(strlen($search_value)>=$min_text_len)
            {
                return $column_search_by." LIKE '".$search_value."%' ";
            }
        }

        return FALSE;
    }

    /*
        NAME    : searchByMemberId
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function searchByMemberId($search_array,$search_by)
    {
        
		if (array_key_exists($search_by, $search_array))
		{
			$search_value = $search_array[$search_by];
			if(!empty($search_array[$search_by]))
			{
				return "member_table.member_id = $search_value";
			}
		}

        return FALSE;
    }

    /*
        NAME    : searchByDemographicField
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function searchByDemographicField($field_by,$search_array,$search_by,$min_text_len=3)
    {
        //zip code
        if (array_key_exists($search_by, $search_array))
        {
            $search_value = trim($search_array[$search_by]);
            if(strlen($search_value)>=$min_text_len)
            {
                return self::whereClauseHraFileSearchLikeQuery($field_by,$search_value);
            }
        }

        return FALSE;
    }

    /*
        NAME    : searchByMemberInfoField
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function searchByMemberInfoField($field_by,$search_array,$search_by,$min_text_len=3)
    {
        //zip code
        if (array_key_exists($search_by, $search_array))
        {
            $search_value = trim($search_array[$search_by]);
            if(strlen($search_value)>=$min_text_len)
            {
                return self::whereClauseSearchMemberInfoLikeQuery($field_by,$search_value);
            }
        }

        return FALSE;
    }
}

?>
