<?php

    
    /*
        HRA FILE CHANGES AND COMPONENT CHANGES DETECTION UTILITY CLASS
    */

    require_once("../TimeZone.php");
    require_once("../scheduler/SchedulerUtility.php");
    require_once("../member/MemberUtility.php");
    require_once("../utility/ArrayUtility.php");
    require_once("../utility/DataBaseUtility.php");
    require_once("../scheduler/SchedulerCallOrderUtility.php");
    require_once("../report/ReportStatus.php");
    
    class HraFileChangesUtility
    {

            /*
                NAME 	: onHraFileUpdatedHistory
                TYPE    : Internal  Utility Function
                DETAILS : whenever hrajson data changes need to check specific answer
                        data changes or not if any changes ,than update the database 
                        column with date and which answer column modified eg:("screeniing","minicog")

                PARAMETERS :client id,year member id ,reveived hra json content

                DATABASE COLUMN : hraFileUpdatedHistory

                FORMAT : {
                        "last_updated":"02-23-2021",
                        "history":[
                            {"modified":[{"component":"screening","date":"02-23-2021","time":"13:15:33",status="true",value=[]}]}
                        ]
                    }

                RETUTN : NULL
            */


      
		   public function onHraFileUpdatedHistory($client_id,$year,$member_id,$hra_json_content,$exclude_previous_value_check=false)
            {
           
                TimeZone::useTimeZone();
                $current_date = date("m-d-Y");
                $current_time = date("H:i:s");
                $components_updated_list =["demographic","screening"];
                $previous_json_file_contnent = $this->getJsonContent($client_id,$year,$member_id);
                $comp_count = count($components_updated_list);
                for($comp=0;$comp<$comp_count;$comp++)
                {
                     $component_name = $components_updated_list[$comp];
                    switch($component_name)
                    {
                        case "demographic":
                            
                            //current demographic value as php array
                            $demographic_value = $this->convertJsonAsArray($hra_json_content,["Demographics","demo"]);
                            //this logic used when first time register member
                            $previous_demographic_value = null;
                            if($exclude_previous_value_check==false)
                            {
                                //previous saved hra json file converted to php array
                                $previous_demographic_value = $this->getJsonAnswerByTitle($previous_json_file_contnent,["Demographics","demo"]);
                            }
                            
                            $component_data_changed = !$this->compareArray($previous_demographic_value,$demographic_value);
                            if($component_data_changed)
                            {
                                $this->OnDemographicsValueChanged($client_id,$year,$member_id,$current_date,$current_time,
                                                 $previous_demographic_value,$demographic_value);
                            }
                            
                        break;

                        case "screening":
                            $screening_value = $this->convertJsonAsArray($hra_json_content,["Screenings Needed","Screenings"]);
                            $previous_screening_value = null;
                            if($exclude_previous_value_check==false)
                            {
                                $previous_screening_value = $this->getJsonAnswerByTitle($previous_json_file_contnent,["Screenings Needed","Screenings"]);
                            }

                            $component_data_changed = !$this->compareArray($previous_screening_value,$screening_value);

                            if($year == 2022) {
                                //echo "<pre>";
                                // print_r($screening_value);die;

                                $newarray = [];
                                if(is_array($screening_value)){ 
                                    $screening_value_array=$screening_value;
                                    $screeing_row_count = count($screening_value_array);
                                    $screeing_row_count  = $screeing_row_count  -1;
                                    // to arrange screening data array  like previous years like 2020,2021 so created  previousformatarray variable
                                    $previousformatarray = ['4','2','0','1','5','6','3'];


                                    $overallarray = [];

                                    for($scr=0;$scr<$screeing_row_count;$scr++){
                                        $internalarray = [];
                                        $positionvalue = $previousformatarray[$scr];
                                        $screening_row_value = $screening_value_array[$positionvalue];

                                        //if(is_array($screening_row_value)){
                                        if(is_array($screening_row_value) && ($screening_row_value['a']['indx'][0] == 1 )){
                                            $member_eligible =  $screening_row_value['a']['indx'][0];

                                            if($member_eligible == 1)
                                            {
                                                array_push($internalarray,'Yes');
                                                array_push($internalarray,'');
                                            }else{
                                                array_push($internalarray,'');
                                                array_push($internalarray,'');
                                            }

                                            //here for positionvalue 0,1,2,3 we had barcodes
                                            if($positionvalue == 1 || $positionvalue == 2 || $positionvalue == 0 || $positionvalue == 3 )  {
                                                $screening_result =  $screening_row_value['a']['sub']['indx'][3][0];
                                                if(strlen($screening_result)>0){

                                                    array_push($internalarray,$screening_result);
                                                }else{

                                                    array_push($internalarray,'');
                                                }
                                                $examdate =  $screening_row_value['a']['sub']['indx'][2][0];
                                                if(strlen($examdate)>0){

                                                    array_push($internalarray,$examdate);
                                                }else{

                                                    array_push($internalarray,'');
                                                }

                                                $barcode =  $screening_row_value['a']['sub']['indx'][1][0];
                                                if(strlen($barcode)>0){

                                                    array_push($internalarray,$barcode);
                                                    array_push($internalarray,$barcode);
                                                }else{

                                                    array_push($internalarray,'');
                                                    array_push($internalarray,'');
                                                }
                                                
                                                $status =  $screening_row_value['a']['sub']['indx'][0];
                                                if (in_array("1", $status)){
                                                    array_push($internalarray,'yes');
                                                }else{
                                                    array_push($internalarray,'');
                                                }

                                                $diag =  $screening_row_value['a']['sub']['indx'][4][0];
                                                if(strlen($diag)>0){

                                                    array_push($internalarray,$diag);
                                                }else{

                                                    array_push($internalarray,'');
                                                }
                                                $comment =  $screening_row_value['a']['sub']['indx'][5][0];
                                                if(strlen($comment)>0){

                                                    array_push($internalarray,$comment);
                                                }else{

                                                    array_push($internalarray,'');
                                                }

                                            }
                                            
                                            //here we dont have  barcode questions for  screening tab so i have segrated with position values with 4 and 5
                                            if($positionvalue == 4 || $positionvalue == 5 ){
                                                $screening_result =  $screening_row_value['a']['sub']['indx'][2][0];
                                                if(strlen($screening_result)>0){

                                                    array_push($internalarray,$screening_result);
                                                }else{

                                                    array_push($internalarray,'');
                                                }

                                                $examdate =  $screening_row_value['a']['sub']['indx'][1][0];
                                                if(strlen($examdate)>0){

                                                    array_push($internalarray,$examdate);
                                                    array_push($internalarray,'');
                                                    array_push($internalarray,'');
                                                }else{

                                                    array_push($internalarray,'');
                                                    array_push($internalarray,'');
                                                    array_push($internalarray,'');
                                                }

                                                $status =  $screening_row_value['a']['sub']['indx'][0];
                                                if (in_array("1", $status)){
                                                    array_push($internalarray,'yes');
                                                }else{
                                                    array_push($internalarray,'');
                                                }

                                                $dialog =  $screening_row_value['a']['sub']['indx'][3][0];
                                                if(strlen($dialog)>0){

                                                    array_push($internalarray,$dialog);
                                                }else{

                                                    array_push($internalarray,'');
                                                }

                                                $comment =  $screening_row_value['a']['sub']['indx'][4][0];
                                                if(strlen($comment)>0){

                                                    array_push($internalarray,$comment);
                                                }else{

                                                    array_push($internalarray,'');
                                                }
                                            }

                                            //posotion 6 is related to pad here we had many questions
                                            if($positionvalue == 6 ){
                                                $screening_result =  $screening_row_value['a']['sub']['indx'][2][0];
                                                $right_screening_result =  $screening_row_value['a']['sub']['indx'][4][0];
                                                // if(strlen($screening_result)>0){
                                                if(strlen($screening_result)>0 || strlen($right_screening_result)>0 ){
                                                    // $overal_screening_result = $screening_result .'|'. $right_screening_result; 
                                                    $overal_screening_result = 'Left: '.$screening_result .', Right: '. $right_screening_result; 

                                                    array_push($internalarray,$overal_screening_result);
                                                }else{

                                                    array_push($internalarray,'');
                                                }
                                                $examdate =  $screening_row_value['a']['sub']['indx'][1][0];
                                                if(strlen($examdate)>0){

                                                    array_push($internalarray,$examdate);
                                                    array_push($internalarray,'');
                                                    array_push($internalarray,'');
                                                }else{

                                                    array_push($internalarray,'');
                                                    array_push($internalarray,'');
                                                    array_push($internalarray,'');
                                                }
                                                $status =  $screening_row_value['a']['sub']['indx'][0];
                                                if (in_array("1", $status)){
                                                    array_push($internalarray,'yes');
                                                }else{
                                                    array_push($internalarray,'');
                                                }

                                                $dialog =  $screening_row_value['a']['sub']['indx'][6][0];
                                                if(strlen($dialog)>0){

                                                    array_push($internalarray,$dialog);
                                                }else{

                                                    array_push($internalarray,'');
                                                }

                                                $comment =  $screening_row_value['a']['sub']['indx'][7][0];
                                                if(strlen($comment)>0){

                                                    array_push($internalarray,$comment);
                                                }else{

                                                    array_push($internalarray,'');
                                                }
                                            }

                                        
                                            $status_options =  $screening_row_value['a']['sub']['indx'][0];
                                        

                                            if (in_array("1", $status_options)){
                                                //array_push($internalarray,'yes');
                                                $value = array_search("1", $status_options);
                                                if($positionvalue == 0 || $positionvalue ==1 || $positionvalue ==2 || $positionvalue ==3){
                                                    if($value == 0){
                                                        $value1 = "Member refused";
                                                    }
                                                    if($value == 1){
                                                        $value1 = "Left kit";
                                                    }
                                                    if($value == 2){
                                                        $value1 = "Collected Sample";
                                                    }
                                                    if($value == 3){
                                                        $value1 = "Mail Kit direct to member";
                                                    }  if($value == 4){
                                                        $value1 = "Result Received";
                                                    }   
                                                }

                                                if($positionvalue == 4 || $positionvalue == 5 || $positionvalue == 6 ){
                                                    if($value == 0){
                                                        $value1 = "Member refused";
                                                    }
                                                    if($value == 1){
                                                        $value1 = "Exam completed";
                                                    }
                                                    if($value == 2){
                                                        $value1 = "Environmental issue";
                                                    }  if($value == 3){
                                                        $value1 = "Result Received";
                                                    }
                                                }
                                                /*if($value1 == "Member refused"){
                                                    $reason_member_refused = $screening_row_value['a']['sub']['sub']['indx'][0][0];

                                                    $reason_member_refused_value = array_search("1", $reason_member_refused);
                                                    if($reason_member_refused_value == 0){
                                                        $value1 = $value1 . " _ Member recently completed";
                                                    }
                                                    if($reason_member_refused_value == 1){
                                                        $value1 = $value1 . " _ Scheduled to complete";
                                                    }
                                                    if($reason_member_refused_value == 2){
                                                        $value1 = $value1 . " _ Member apprehension";
                                                    }
                                                    if($reason_member_refused_value == 3){
                                                        $value1 = $value1 . " _ Not interested";
                                                    }
                                                    if($reason_member_refused_value == 4){
                                                        $reason_member_refused_comment = $screening_row_value['a']['sub']['sub']['sub']['indx'][0][0][0][0];
                                                        $value1 = $value1 . " _ Other _ ".$reason_member_refused_comment ;
                                                    }
                                                    
                                                }*/
                                                array_push($internalarray,$value1);
                                            }else{
                                                array_push($internalarray,'');
                                            }

                                            //by Suresh  for Member Refusal Screening Report

                                            $screeningcomment =  $screening_row_value['a']['comment'][0];
                                            array_push($internalarray,$screeningcomment);   

                                            $statusoptioncomment =  $screening_row_value['a']['sub']['comment'][0][$value];
                                            array_push($internalarray,$statusoptioncomment);
                                           
                                            if (in_array("1", $status_options)){
                                                $value = array_search("1", $status_options);
                                                if($value == 0){
                                                    $refusalreason =  $screening_row_value['a']['sub']['sub']['indx'][0][0];
                                                    if (in_array("1", $refusalreason)){
                                                        $refusalvalue = array_search("1", $refusalreason);
                                                        $refusalotherdescribe='';
                                                        if($refusalvalue == 0){
                                                            $reasonrefusal = "Member recently completed";
                                                            $refusedreasoncomment =  $screening_row_value['a']['sub']['sub']['comment'][0][0][0];
                                                        }
                                                        if($refusalvalue == 1){
                                                            $reasonrefusal = "Scheduled to complete";
                                                            $refusedreasoncomment =  $screening_row_value['a']['sub']['sub']['comment'][0][0][1];
                                                        }
                                                        if($refusalvalue == 2){
                                                            $reasonrefusal = "Member apprehension";
                                                            $refusedreasoncomment =  $screening_row_value['a']['sub']['sub']['comment'][0][0][2];
                                                        }
                                                        if($refusalvalue == 3){
                                                            $reasonrefusal = "Not interested";
                                                            $refusedreasoncomment =  $screening_row_value['a']['sub']['sub']['comment'][0][0][3];
                                                        } 
                                                        if($refusalvalue == 4){
                                                            $reasonrefusal = "Other";
                                                            $refusedreasoncomment =  $screening_row_value['a']['sub']['sub']['comment'][0][0][4];
                                                            $refusalotherdescribe = $screening_row_value['a']['sub']['sub']['sub']['indx'][0][0][0][0];
                                                        }

                                                        array_push($internalarray,$reasonrefusal);
                                                        array_push($internalarray,$refusedreasoncomment);
                                                        array_push($internalarray,$refusalotherdescribe);
                                                    }else{
                                                        array_push($internalarray,''); //for refusal reason
                                                        //for refusal reason Comment
                                                        if(isset($screening_row_value['a']['sub']['sub']['comment'][0][6])){
                                                            $refusedreasoncomment =  $screening_row_value['a']['sub']['sub']['comment'][0][6];                                                            
                                                            array_push($internalarray,$refusedreasoncomment);
                                                        }else{
                                                            array_push($internalarray,'');
                                                        }
                                                        //for refusal reason Other's Describe
                                                        array_push($internalarray,'');
                                                    }
                                                } elseif($positionvalue == 4 && $value == 3) {
                                                    $refusalreason =  $screening_row_value['a']['sub']['sub']['indx'][0][0];
                                                    if (in_array("1", $refusalreason)){
                                                        $refusalvalue = array_search("1", $refusalreason);
                                                        $refusalotherdescribe='';
                                                        if($refusalvalue == 0){
                                                            $reasonrefusal = "Valid Image";
                                                            $refusedreasoncomment =  $screening_row_value['a']['sub']['sub']['comment'][0][0][0];
                                                        }
                                                        if($refusalvalue == 1){
                                                            $reasonrefusal = "Invalid Image";
                                                            $refusedreasoncomment =  $screening_row_value['a']['sub']['sub']['comment'][0][0][1];
                                                        }
                                                        array_push($internalarray,$reasonrefusal);
                                                        array_push($internalarray,$refusedreasoncomment);
                                                        array_push($internalarray,$refusalotherdescribe);
                                                    } else{
                                                        array_push($internalarray,'');
                                                        array_push($internalarray,'');
                                                        array_push($internalarray,'');
                                                    }
                                                } else{
                                                    // for refusal reason, refusal reason Comment, refusal reason Other's Describe
                                                    array_push($internalarray,'');
                                                    array_push($internalarray,'');
                                                    array_push($internalarray,'');
                                                }
                                            }

                                            //By Suresh

                                        }

                                        else{
                                            array_push($internalarray,'');
                                            array_push($internalarray,'');
                                            array_push($internalarray,'');
                                            array_push($internalarray,'');
                                            array_push($internalarray,'');
                                            array_push($internalarray,'');
                                            array_push($internalarray,'');
                                            array_push($internalarray,'');
                                            array_push($internalarray,'');
                                            array_push($internalarray,'');

                                            //By Suresh for Member Refusal Screening Report
                                            $screeningcomment =  $screening_row_value['a']['comment'][1];
                                            array_push($internalarray,$screeningcomment);
                                            array_push($internalarray,'');
                                            array_push($internalarray,'');
                                            array_push($internalarray,'');
                                            array_push($internalarray,'');
                                            //By Suresh       

                                        }
                                        $overallarray[] = $internalarray; // arraging all screening questions into an array
                                    }
                                }

                                // taken new variable to arrange array data format  like 2020,2021
                                $newarray[] = $overallarray;
                                $screening_value = $newarray; // assigning array to screening value variable  

                            
                            }
                            //echo json_encode($screening_value,true);
                            //die;

                           $component_status = $this->findChangesInScreeningData($client_id,$year,$member_id,$screening_value);
                            //echo $component_status;die;
                            $this->appendHraFileUpdateHistroy($client_id,$year,$member_id,"screening",$current_date,$current_time,
                                                                $component_status,$screening_value,$component_data_changed);
                                                                
                        break;

                    }
                }

                //when their is no changes in hra file screening value
                $this->updateHraFileHistoryLastUpdatedDate($client_id,$year,$member_id,$current_date,$current_time);

            }
            
            /*
                NAME : OnDemographicsValueChanged
                TYPE : Internal Event Callback
                DETAILS :
                RETURN :
            */
            private function OnDemographicsValueChanged($client_id,$year,$member_id,$current_date,$current_time,$previous_demographic_value,$demographic_value)
            {
     
                $this->appendHraFileUpdateHistroy($client_id,$year,$member_id,"demographic",$current_date,$current_time,
                                                                true,$demographic_value,true);
                //update the memberinfo database column
                //this flag used to find out not first time register and
                //when demographic values changed in fill form
                if($previous_demographic_value)
                {
                    $this->OnUpdateMemberInfo($client_id,$year,$member_id,$demographic_value);
                
                    //check the filed to find any changes in cell number or phone number field
                    $current_phone_cell_details = $this->getMemberPhoneDemoGraphicsAsArray($demographic_value);
                    $previous_phone_cell_details = $this->getMemberPhoneDemoGraphicsAsArray($previous_demographic_value);
                    $demographic_phone_data_changed = $this->compareArrayReturnChanges($current_phone_cell_details,$previous_phone_cell_details);
                    if($demographic_phone_data_changed)
                    {
                        $member_scheduler_call_hra_status = $this->getDatabaseJsonFieldAsArray($client_id,$year,$member_id,'schedulerCallHraStatus');
                        if($member_scheduler_call_hra_status)
                        {
                            $this->OnMobileNumberChanged($client_id,$year,$member_id,$member_scheduler_call_hra_status,$demographic_phone_data_changed);
                        }
                    }
                }
                
            }

            /*
                NAME : OnUpdateMemberInfo
                TYPE : Internal Event Callback
                DETAILS :
                RETURN :
            */
            public function OnUpdateMemberInfo($client_id,$year,$member_id,$demographic_value)
            {
                //ONLY MOBILE NUMBER UPDATED for now others too if needed
                //read the member hraStatus and scheduler details
                $member_details = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,["memberinfo"]);
                $member_info_array = json_decode($member_details["memberinfo"],true);
   
                /*
                    member_info - hra_file_member_info
                    ----------------------------------
                    HICN=cliId
                    Pcp_Zip=pcpzip
                    Pcp_City=pcpcity
                    Pcp_Name=pphy
                    Office_ID=pcpid
                    PCP_Phone=ppno
                    Pcp_State=pcpstate
                    Member_City=city
                    Member_Primary_Phone_Number=pno
                    Member_Secondary_Phone_Number=cno
                    Member_Alternate_Phone_Number=ano
                */
                if($member_info_array)
                {
                    $demographic_value_data = $demographic_value[0];
                    if($demographic_value_data)
                    {

                        if(array_key_exists("pno",$demographic_value_data))
                        {
                            $member_info_array=ArrayUtility::updateValueByKey($member_info_array,
                                        "Member_Primary_Phone_Number",$demographic_value_data["pno"],true);  
                        }

                        if(array_key_exists("cno",$demographic_value_data))
                        {
                            $member_info_array=ArrayUtility::updateValueByKey($member_info_array,
                                        "Member_Secondary_Phone_Number",$demographic_value_data["cno"],true);
                        }  
                        
                        if(array_key_exists("ano",$demographic_value_data))
                        {
                            $member_info_array=ArrayUtility::updateValueByKey($member_info_array,
                                        "Member_Alternate_Phone_Number",$demographic_value_data["ano"],true);
                        }

                        if(array_key_exists("pcpfaxno",$demographic_value_data))
                        {
                            $member_info_array=ArrayUtility::updateValueByKey($member_info_array,
                                        "PCP_Fax_Number",$demographic_value_data["pcpfaxno"],true);
                        }

                        if(array_key_exists("plan",$demographic_value_data))
                        {
                            $member_info_array=ArrayUtility::updateValueByKey($member_info_array,
                                        "Plan",$demographic_value_data["plan"],true);
                        }

                        if(array_key_exists("program",$demographic_value_data))
                        {
                            $member_info_array=ArrayUtility::updateValueByKey($member_info_array,
                                        "Program",$demographic_value_data["program"],true);
                        }

                        if(array_key_exists("lob",$demographic_value_data))
                        {
                            $member_info_array=ArrayUtility::updateValueByKey($member_info_array,
                                        "LOB",$demographic_value_data["lob"],true);
                        }
                    }

                }

                //clear previous assigned scheduler id 
                $column_name_list =['memberinfo'];
                $column_value_list=[json_encode($member_info_array)];
                DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
            }

            /*
                NAME : OnMobileNumberChanged
                TYPE : Internal Event Callback
                DETAILS :
                RETURN :
            */
            private function OnMobileNumberChanged($client_id,$year,$member_id,$member_scheduler_call_hra_status,$updated_contact_no_details)
            {
                
                //$member_scheduler_call_hra_status = $this->getDatabaseJsonFieldAsArray($client_id,$year,$member_id,'schedulerCallHraStatus');
                    if($member_scheduler_call_hra_status)
                    {
                        if(array_key_exists("status",$member_scheduler_call_hra_status))
                        {
                            //if status is 2 means member scheduler call status is 5 calllog of 'disconnected/wrong number'
                            switch($member_scheduler_call_hra_status["status"])
                            {  
                                case SchedulerUtility::MOVE_TO_UTC_FIVE_DISPOSITIONS:
                                    TimeZone::useTimeZone();
                                    $member_scheduler_call_hra_status['status'] = SchedulerUtility::UNSCHEDULED;
                                    $member_scheduler_call_hra_status['date'] = date("m-d-Y H:i:s");
                                    $member_scheduler_call_hra_status['details'] = "mobile number changed";
                                    $member_scheduler_call_hra_status['disabled'] = false;
                                    //set scheduler notification for mobile changed
                                    $scheduler_notification = SchedulerUtility::generateSchedulerNotification(SchedulerUtility::SCHN_MOBILE_CHANGED,
                                                                                SchedulerUtility::MOVE_TO_UTC_FIVE_DISPOSITIONS,$updated_contact_no_details);
                                    $member_scheduler_call_hra_status['notification'] = $scheduler_notification;
        
                                    //update the scheduler hra status
                                    $this->updateDatabaseJsonField($client_id,$year,$member_id,'schedulerCallHraStatus',$member_scheduler_call_hra_status);
                                    //update hra status back to unscheduled when if hra status is UTC
                                    DataBaseUtility::updateHraStatus($client_id,$year,$member_id,MemberUtility::UNSCHEDULED,MemberUtility::UTC);
                                    //reset the scheduler attempt count
                                    MemberUtility::SetCallLogAttemptCount($client_id,$year,$member_id,0);
                                    //reassign scheduler by appending same schedulerDetails 
                                    SchedulerUtility::reAssignSchedulerDetails($client_id,$year,$member_id);
                                    //updated report status
                                    ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::UNSCHEDULED);
                                    ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::UNSCHEDULED);
                                    
                                    //set call order to show what order that member shown in dashboard
                                    SchedulerCallOrderUtility::setCallOrder($client_id,$year,$member_id,SchedulerCallOrderUtility::CONTACT_NO_CHANGED_ORDER);
                                break;

                                case SchedulerUtility::DISCONNECT_WRONG_NUMBER:
                                    TimeZone::useTimeZone();
                                    $member_scheduler_call_hra_status['status'] = SchedulerUtility::UNSCHEDULED;
                                    $member_scheduler_call_hra_status['date'] = date("m-d-Y H:i:s");
                                    $member_scheduler_call_hra_status['details'] = "mobile number changed";
                                    $member_scheduler_call_hra_status['disabled'] = false;
                                    //set scheduler notification for mobile changed
                                    $scheduler_notification = SchedulerUtility::generateSchedulerNotification(SchedulerUtility::SCHN_MOBILE_CHANGED,
                                                                                SchedulerUtility::DISCONNECT_WRONG_NUMBER,$updated_contact_no_details);
                                    $member_scheduler_call_hra_status['notification'] = $scheduler_notification;

                                    //update the scheduler hra status
                                    $this->updateDatabaseJsonField($client_id,$year,$member_id,'schedulerCallHraStatus',$member_scheduler_call_hra_status);
                                    //update hra status back to unscheduled when if hra status is UTC
                                    DataBaseUtility::updateHraStatus($client_id,$year,$member_id,MemberUtility::UNSCHEDULED);
                                    //reset the scheduler attempt count
                                    MemberUtility::SetCallLogAttemptCount($client_id,$year,$member_id,0);
                                    //reassign scheduler by appending same schedulerDetails 
                                    SchedulerUtility::reAssignSchedulerDetails($client_id,$year,$member_id);
                                    //updated report status
                                    ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::UNSCHEDULED);
                                    ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::UNSCHEDULED);
                                    //set call order to show what order that member shown in dashboard
                                    SchedulerCallOrderUtility::setCallOrder($client_id,$year,$member_id,SchedulerCallOrderUtility::CONTACT_NO_CHANGED_ORDER);
                                break;


                            }
                        }
                    }
            }

            /*
                NAME    : getMemberPlanProgramDemoGraphicsAsArray
                DETAILS : NOT USED
                RETURN  :
            */
            private function getMemberPlanProgramDemoGraphicsAsArray($demographic_value)
            {
               
                $member_demo_graphics_json='{"lob":"","plan":"","region":"","aligned":"","program":""}';  
                $member_demo_graphics = json_decode($member_demo_graphics_json, true);

                if(is_array($demographic_value))
                {
                    if(count($demographic_value)>0)
                    {
                        $demographic_value_data = $demographic_value[0];
                        if(array_key_exists("plan",$demographic_value_data))
                        {
                            $member_demo_graphics["plan"] = $demographic_value_data["plan"];
                        }

                        if(array_key_exists("lob",$demographic_value_data))
                        {
                            $member_demo_graphics["lob"] = $demographic_value_data["lob"];
                        }

                        if(array_key_exists("region",$demographic_value_data))
                        {
                            $member_demo_graphics["region"] = $demographic_value_data["region"];
                        }

                        if(array_key_exists("aligned",$demographic_value_data))
                        {
                            $member_demo_graphics["aligned"] = $demographic_value_data["aligned"];
                        }

                        if(array_key_exists("program",$demographic_value_data))
                        {
                            $member_demo_graphics["program"] = $demographic_value_data["program"];
                        }
                    }
                }

                return $member_demo_graphics;
            }

            /*
                NAME : getMemberPhoneDemoGraphicsAsArray
                DETAILS : get the phone and cell number from demographic value
                          it return as array because to compare current and previous value
                          for data changes
                RETURN : phpone/cell number array object
            */
            private function getMemberPhoneDemoGraphicsAsArray($demographic_value)
            {
                $member_demo_graphics_json='{"pno":"","cno":"","ano":""}';  
                $member_demo_graphics = json_decode($member_demo_graphics_json, true);
                if(is_array($demographic_value))
                {
                    if(count($demographic_value)>0)
                    {
                        $demographic_value_data = $demographic_value[0];
                        if(array_key_exists("pno",$demographic_value_data))
                        {
                            $member_demo_graphics['pno'] = $demographic_value_data["pno"];
                        }

                        if(array_key_exists("cno",$demographic_value_data))
                        {
                            $member_demo_graphics['cno'] = $demographic_value_data["cno"];
                        }

                        if(array_key_exists("ano",$demographic_value_data))
                        {
                            $member_demo_graphics['ano'] = $demographic_value_data["ano"];
                        }
                    }
                }

                return $member_demo_graphics;
            }

            /*
                NAME : getComponentChangedStatus
                DETAILS : 
            */
            public function getComponentChangedStatus($hra_file_updated_content,$what_modified)
            {
                $hra_file_history_array = json_decode($hra_file_updated_content,true);
                $response = array("status"=>false,"date"=>null,"time"=>null,"value"=>null);
                if(is_array($hra_file_history_array))
                {
                    if(array_key_exists("history",$hra_file_history_array))
                    {
                        
                        $hra_file_update_array_history = $hra_file_history_array["history"];
                        if(is_array($hra_file_update_array_history))
                        {
                            $hra_file_history_count = count($hra_file_update_array_history);
                            for($hfh=0;$hfh<$hra_file_history_count;$hfh++)
                            {
                                $hra_file_history_row=$hra_file_update_array_history[$hfh];
                                if($hra_file_history_row)
                                {
                                    
                                    $hra_file_history_what_modified = $hra_file_history_row["modified"];
                                    if(is_array($hra_file_history_what_modified))
                                    {
                                        $modified_count = count($hra_file_history_what_modified);
                                        for($hmc=0;$hmc<$modified_count;$hmc++)
                                        {
                                            $modified_comp_array = $hra_file_history_what_modified[$hmc];
                                            //if value not found
                                            if($modified_comp_array["component"]==$what_modified)
                                            {   
                                                if($modified_comp_array["status"]==true)
                                                {
                                                    $response["status"]=true;
                                                    $response["date"]=$modified_comp_array["date"];
                                                    $response["time"]=$modified_comp_array["time"];
                                                    $response["value"]=$modified_comp_array["value"];
                                                }
                                            }
                                        } 
                                    }
                                }
                            }
                        }
                        
                    }
                }

                return $response;
            }

            /*
                NAME : findChangeInScreeningData
                DETAILS : when member import when no hra file found.IMPLEMENTATION PENDING
                         for monthly report - screening result used
                         for weekly report bar code data used
            */
            private function findChangesInScreeningData($client_id,$year,$member_id,$screening_value)
            {
                if($year==2019 || $year==2020) { return false; }

                if(is_array($screening_value))
                {
                        $screening_value_array=$screening_value[0];
                        if(is_array($screening_value_array))
                        {
                            $screeing_row_count = count($screening_value_array);
                            
                            for($scr=0;$scr<$screeing_row_count;$scr++)
                            {
                                $screening_row_value = $screening_value_array[$scr];

                                if(is_array($screening_row_value))
                                {
                                    $member_eligible = $screening_row_value[0];
                                    //$status = $screening_row_value[6];
                                    $screening_completed = $screening_row_value[1];
                                    $screening_result = $screening_row_value[2];
                                    $barcode = $screening_row_value[4];
                                    //find changes in screening value condition
                                    //if($screening_completed=="Yes" || $screening_completed=="Exception")
                                    if($member_eligible=="Yes" || $member_eligible=="yes")
                                    {
                                        return true;
                                    }

                                    //bar code without white space
                                    $trimmed_barcode = trim($barcode);
                                    if($trimmed_barcode)
                                    {
                                        return true;
                                    }

                                    //screening result condition
                                    if(strlen($screening_result)>0)
                                    {
                                        if(!empty($screening_result) && !ctype_space($screening_result))
                                        {
                                            return true;
                                        }
                                    }

                                    if(strlen($screening_completed)>0)
                                    {
                                        if(!empty($screening_completed) && !ctype_space($screening_completed))
                                        {
                                            return true;
                                        }
                                    }
                                    
                                }
                            }
                        }

                }

                return false;
            }


            /*
                NAME : getJsonDataByTitle
                DETAILS : array of specific title and answer value
            */
            public function getJsonDataByTitle($client_id,$year,$member_id,$component_title_name_array)
            {
                //previous saved hra json file
                $member_json_file_path = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
                
                if(file_exists($member_json_file_path))
                {
                    $hra_json_content = file_get_contents($member_json_file_path);
                    $specific_data_value = $this->getJsonAnswerByTitle($hra_json_content,$component_title_name_array);
                    return $specific_data_value;
                }

                return NULL;
            }

            /*
                NAME : getJsonContent
                DETAILS : 
            */
            public function getJsonContent($client_id,$year,$member_id)
            {
                //previous saved hra json file
                $member_json_file_path = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
                if(file_exists($member_json_file_path))
                {
                    $hra_json_content = file_get_contents($member_json_file_path);
                    return $hra_json_content;
                }

                return NULL;
            }

            /*
                NAME : convertJsonAsArray
                DETAILS : 
            */
            private function convertJsonAsArray($hra_json_content,$component_title_name_array)
            {
                $specific_data_value = $this->getJsonAnswerByTitle($hra_json_content,$component_title_name_array);
                return $specific_data_value;
            }

            /*
                NAME : appendHraFileUpdateHistroy
                DETAILS : check the member present or not and decode the hra file updated history,
                         append the time and what component valued modified later update database column
                         hraFileUpdatedHistory
                RETURN : NULL
            */
            private function appendHraFileUpdateHistroy($client_id,$year,$member_id,$what_modified,$on_what_date,$on_what_time,
                            $component_status,$componet_value,$component_data_changed)
            {

                include("../db.php");
//echo json_encode($componet_value,true);die;

                $hra_file_history_json="";
                $hra_file_history_query = "select hraFileUpdatedHistory from HRA_member_".$client_id.'_'.$year." where member_id='$member_id'";
                $db_success = false;
                try
                {
                    $hra_status_history_query_result=mysqli_query($conn,$hra_file_history_query);
                    if(mysqli_num_rows($hra_status_history_query_result) == 1)
                    {
                        $hra_file_history_row=mysqli_fetch_array($hra_status_history_query_result,MYSQLI_ASSOC);
                        $hra_file_history_json = $hra_file_history_row['hraFileUpdatedHistory'];
                        $db_success=true;
                    }
                }
                catch (Exception $e)
                {
                    $error = $e->getMessage();
                    $db_success=false;
                }

                if($db_success)
                {
                    //decode the json hra history format into php array
                    $hra_file_history_array = json_decode($hra_file_history_json, true);
                    //check the hra file updated history date already present update 
//echo json_encode($componet_value,true);die;
                    $hra_file_history_array  = $this->findAndUpdateHraFileHistoryByFirstRow($hra_file_history_array,$what_modified,
                                        $on_what_date,$on_what_time,$component_status,$componet_value,$component_data_changed);
//echo json_encode($hra_file_history_array,true);die;
                    
                    if($this->updateHraFileJsonHistoryInDb($client_id,$year,$member_id,$hra_file_history_array))
                    {
                        $response = new stdClass();
                        $response->status = 'updated';
                        $response = json_encode($response);
                        return $response;
                    }
                    else
                    {
                        $response = new stdClass();
                        $response->status = 'not updated';
                        $response = json_encode($response);
                        return $response;
                    }
                }
                else
                {
                        $response = new stdClass();
                        $response->status = 'member not found';
                        $response = json_encode($response);
                        return $response;
                }
                
                //echo json_encode($hra_file_history_array,true);
            }

            /*
                NAME : updateHraFileUpdateHistroy
                DETAILS : update hra file updated history's last updated date and time
                RETURN : NULL
            */
            private function updateHraFileHistoryLastUpdatedDate($client_id,$year,$member_id,$on_what_date,$on_what_time)
            {
                include("../db.php");

                $hra_file_history_json="";
                $hra_file_history_query = "select hraFileUpdatedHistory from HRA_member_".$client_id.'_'.$year." where member_id='$member_id'";
                $db_success = false;
                try
                {
                    $hra_status_history_query_result=mysqli_query($conn,$hra_file_history_query);
                    if(mysqli_num_rows($hra_status_history_query_result) == 1)
                    {
                        $hra_file_history_row=mysqli_fetch_array($hra_status_history_query_result,MYSQLI_ASSOC);
                        $hra_file_history_json = $hra_file_history_row['hraFileUpdatedHistory'];
                        $db_success=true;
                    }
                }
                catch (Exception $e)
                {
                    $error = $e->getMessage();
                    $db_success=false;
                }

                if($db_success)
                {
                    if($hra_file_history_json=="" || $hra_file_history_json=='null' || $hra_file_history_json==NULL)
                    {
                        $hra_file_history_json='{
                            "last_updated":"",
                            "history":[]
                        }';
                    }
                    //decode the json hra history format into php array
                    $hra_file_history_array = json_decode($hra_file_history_json, true);
                    //check the hra file updated history date already present update 
                    $current_time = $on_what_date." ".$on_what_time;
                    if(is_array($hra_file_history_array))
                    {
                        $hra_file_history_array["last_updated"] = $current_time;
                    }
                    
                    if($this->updateHraFileJsonHistoryInDb($client_id,$year,$member_id,$hra_file_history_array))
                    {
                        $response = new stdClass();
                        $response->status = 'updated';
                        $response = json_encode($response);
                        return $response;
                    }
                    else
                    {
                        $response = new stdClass();
                        $response->status = 'not updated';
                        $response = json_encode($response);
                        return $response;
                    }
                }
                else
                {
                        $response = new stdClass();
                        $response->status = 'member not found';
                        $response = json_encode($response);
                        return $response;
                }
                
                //echo json_encode($hra_file_history_array,true);
            }

            /*
                NAME : getDatabaseJsonFieldAsArray
                DETAILS : 
                RETURN : return json field value as array format if not null value
            */
            private function getDatabaseJsonFieldAsArray($client_id,$year,$member_id,$json_field_name)
            {
               
				include("../db.php");

                $json_field_value="";
                $hra_file_history_query = "select $json_field_name from HRA_member_".$client_id.'_'.$year." where member_id='$member_id'";
                $db_success = false;
                try
                {
                    $hra_status_history_query_result=mysqli_query($conn,$hra_file_history_query);
                    if(mysqli_num_rows($hra_status_history_query_result) == 1)
                    {
                        $hra_file_history_row=mysqli_fetch_array($hra_status_history_query_result,MYSQLI_ASSOC);
                        $json_field_value = $hra_file_history_row[$json_field_name];
                        $db_success=true;
                    }
                }
                catch (Exception $e)
                {
                    $error = $e->getMessage();
                    $db_success=false;
                }

                return json_decode($json_field_value, true);

            }

            /*
                NAME : updateDatabaseJsonField
                DETAILS : udpated hra file history pushed into database column
                RETURN : return true if database updated else false
            */
            private function updateDatabaseJsonField($client_id,$year,$member_id,$json_field_name,$json_field_value_array)
            {
                include("../db.php");
                //update the hra file json value in array
                $updated_hra_json_field_value=json_encode($json_field_value_array);
                $updated_hra_json_field_value=mysqli_real_escape_string($conn,$updated_hra_json_field_value);
				$updated_hra_json_field_value_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET $json_field_name='$updated_hra_json_field_value' WHERE `member_id` = '$member_id'";
				$updated_hra_json_field_value_query_result = NULL;
				try 
				{
					$updated_hra_json_field_value_query_result=mysqli_query($conn,$updated_hra_json_field_value_query);
					$updated_row_count = mysqli_affected_rows($conn);
					if($updated_row_count)
					{
						return true;
					}
					else
					{	
						//no value value change detected
						if($updated_hra_json_field_value_query)
						{
							return true;
						}
						return false;
					}	
				}
				catch (Exception $e)
				{
					$error = $e->getMessage();
					return false;
				}

            }

            /*
                NAME : updateHraFileJsonHistoryInDb
                DETAILS : udpated hra file history pushed into database column
                RETURN : return true if database updated else false
            */
            private function updateHraFileJsonHistoryInDb($client_id,$year,$member_id,$hra_file_history_array)
            {
                include("../db.php");
                //update the hra file json value in array
                $updated_hra_file_json_history=json_encode($hra_file_history_array);
                $updated_hra_file_json_history=mysqli_real_escape_string($conn,$updated_hra_file_json_history);
				  $updated_hra_file_json_history_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET hraFileUpdatedHistory='$updated_hra_file_json_history' WHERE `member_id` = '$member_id'";
				$updated_hra_file_json_history_query_result = NULL;
				try 
				{
					$updated_hra_file_json_history_query_result=mysqli_query($conn,$updated_hra_file_json_history_query);
					$updated_row_count = mysqli_affected_rows($conn);
					if($updated_row_count)
					{
						return true;
					}
					else
					{	
						//no value value change detected
						if($updated_hra_file_json_history_query_result)
						{
							return true;
						}
						return false;
					}	
				}
				catch (Exception $e)
				{
					$error = $e->getMessage();
					return false;
				}

            }

            /*
                NAME : addHraHistoryInArray
                DETAILS : when hra file history array is empty than  create new array of time and what component
                        modified .if already created push the new array of time and what component modified value.

                RETURN : update hra file history array
            */
            private function addHraHistoryInArray($hra_file_history_array,$what_modified,$on_what_date,$on_what_time,$component_status,$componet_value)
            {
                $current_time = $on_what_date." ".$on_what_time;
                if(empty($hra_file_history_array))
                {
                    if($component_status==false) { $componet_value=null;}
                    $hra_file_history_array = array("last_updated"=>$current_time,"history"=>array());
                    array_push($hra_file_history_array["history"],array(
                     "modified"=>array(
                         array("component"=>$what_modified,
                                "date"=>$on_what_date,
                                "time"=>$on_what_time,
                                "status"=>$component_status,
                                "value"=>$componet_value)
                            )));
                }
                else
                {
                    if($component_status==false) { $componet_value=null;}
                    $hra_file_update_array_history = $hra_file_history_array["history"];
                    array_push($hra_file_update_array_history,array(
                        "modified"=>array(
                            array("component"=>$what_modified,
                                   "date"=>$on_what_date,
                                   "time"=>$on_what_time,
                                   "status"=>$component_status,
                                   "value"=>$componet_value)
                               )));
                    $hra_file_history_array["history"]=$hra_file_update_array_history;
                
                }

                return $hra_file_history_array;
            }


            private function updateHraHistoryByComponent($hra_file_history_row,$what_modified,$on_what_date,$on_what_time,
                                                                    $component_status,$componet_value,$component_data_changed)
            {
                $is_what_modified_found = false;
                $hra_file_history_what_modified = $hra_file_history_row["modified"];
                if(is_array($hra_file_history_what_modified))
                {
                    $modified_count = count($hra_file_history_what_modified);
                    for($hmc=0;$hmc<$modified_count;$hmc++)
                    {
                        $modified_comp_array = $hra_file_history_what_modified[$hmc];
                       
                        //if value not found
                        if($modified_comp_array["component"]==$what_modified)
                        {
                            $is_what_modified_found = true;
                            if($component_status==false) { $componet_value=null;}
                            //if value found update the time at which the component updated
                            if($component_data_changed)
                            {
                                $modified_comp_array["date"]=$on_what_date;
                                $modified_comp_array["time"]=$on_what_time;
                            }
                            $modified_comp_array["status"]=$component_status;
                            $modified_comp_array["value"]=$componet_value;
                            $hra_file_history_what_modified[$hmc] = $modified_comp_array;
                        }
                    }

                    if($is_what_modified_found===false)
                    {
                        if($component_status==false) { $componet_value=null;}
                        $what_modified_at_time= array("component"=>$what_modified,
                                                "date"=>$on_what_date,
                                                "time"=>$on_what_time,
                                                "status"=>$component_status,
                                                "value"=>$componet_value);
                        array_push($hra_file_history_what_modified,$what_modified_at_time);
                    }

                    $hra_file_history_row["modified"] = $hra_file_history_what_modified;
                    
                }
                //echo "hra_file_history_row".json_encode($hra_file_history_row)."\n";
                return $hra_file_history_row;

            }
            
            /*
                NAME : findAndUpdateHraFileHistoryByFirstRow
                DETAILS : find and updated the first row of the history array when specific component updated
            */
            private function findAndUpdateHraFileHistoryByFirstRow($hra_file_history_array,$what_modified,$on_what_date,
                                                $on_what_time,$component_status,$componet_value,$component_data_changed)
            {
                $current_time = $on_what_date." ".$on_what_time;
                $already_date_found = false;
                if(is_array($hra_file_history_array))
                {
                    $hra_file_history_array["last_updated"] = $current_time;
                    if(array_key_exists("history",$hra_file_history_array))
                    {
                        $hra_file_update_array_history = $hra_file_history_array["history"];
                        if(is_array($hra_file_update_array_history))
                        {
                            $hra_file_history_count = count($hra_file_update_array_history);
                            for($hfh=0;$hfh<$hra_file_history_count;$hfh++)
                            {
                                $hra_file_history_row=$hra_file_update_array_history[$hfh];
                                if($hra_file_history_row)
                                {
                                    $hra_file_history_row_updated = $this->updateHraHistoryByComponent($hra_file_history_row,$what_modified,
                                                                    $on_what_date,$on_what_time,$component_status,
                                                                    $componet_value,$component_data_changed);
                                    $hra_file_update_array_history[$hfh]=$hra_file_history_row_updated;
                                    $already_date_found = true;
                                }
                            }
                        }
                        $hra_file_history_array["history"] = $hra_file_update_array_history;
                    }
                }

                //if date already not found than add new hra json file history
                if($already_date_found==false)
                {
                    $hra_file_history_array=$this->addHraHistoryInArray($hra_file_history_array,$what_modified,$on_what_date,
                                                $on_what_time,$component_status,$componet_value,$component_data_changed);
                }

                return $hra_file_history_array;
            }

             /*
                NAME : compareArray
                DETAILS : compare to php array (to diffrentiate 
                        the two json values of hra file)
                RETURN : equal return true ,else false
            */
            private function compareArray($array_a,$array_b)
            {
                $is_array_a = is_array($array_a);
                $is_array_b = is_array($array_b);
               
                if($is_array_a==1 && $is_array_b==1)
                {
                    if($array_a==$array_b)
                    {
                        return true;
                    }
        
                }
                return false;
            }

             /*
                NAME : compareArrayReturnChanges
                DETAILS : compare the keys and values of the two array 
                RETURN : return the difference,else false
            */
            public function compareArrayReturnChanges($array_a,$array_b)
            {
                $is_array_a = is_array($array_a);
                $is_array_b = is_array($array_b);
               
                if($is_array_a==1 && $is_array_b==1)
                {
                    $array_diff_value=array_diff_assoc($array_a,$array_b);
                    if($array_diff_value)
                    {
                        if(count($array_diff_value)>0)
                        {
                            return $array_diff_value;
                        }
                        return FALSE;
                    }
        
                }
                return FALSE;
            }

            /*
                NAME : getFileModified
                DETAILS : file modified date and time 
            */
            private function getFileModified($client_id,$year,$member_id)
            {
                $member_json_file_path = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
                if(file_exists($member_json_file_path))
                {
                    $file_modified_time = filemtime($member_json_file_path);
                    $file_modified_date=date("m-d-Y", $file_modified_time);
                    $file_modified_time=date("H:i:s", $file_modified_time);
                    return array("date"=>$file_modified_date,"time"=>$file_modified_time);
                }

                return NULL;
            }   

            /*
                NAME : getJsonAnswerByTitle
                DETAILS : get the answer value based on title(t) key value(s)
            */
            private function getJsonAnswerByTitle($hra_json_content,$component_title_name_array)
		    {
                    $hra_json_array = json_decode($hra_json_content,true);
                    if($hra_json_array)
                    {
                        $array_count = count($hra_json_array);
                        if($array_count)
                        {
                            if(array_key_exists('data', $hra_json_array))
                            {
                                $hra_data_count = count($hra_json_array["data"]);
                                if($hra_data_count)
                                {
                                    for($ans=0;$ans<$hra_data_count;$ans++)
                                    {
                                        $answer_data_value=$hra_json_array["data"][$ans];
                                        if($answer_data_value)
                                        {
                                            if(array_key_exists('t', $answer_data_value))
                                            {
                                                $title_value = $answer_data_value["t"];
                                                if (in_array($title_value, $component_title_name_array))
                                                {
                                                    if(array_key_exists('q', $answer_data_value))
                                                    {
                                                        return $answer_data_value["q"];  
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    
			    return NULL;
		    }

           

    }
    
?>
