<?php

/*
    MEMBER API CALLS
	class : members
*/

//access control allow Header 
include("../AccessControlAllowHeader.php");

//other include files
require_once("../utility/JwtUtility.php");
require_once("../utility/FileIOUtility.php");
require_once("../utility/Utility.php");
require_once("../utility/DataBaseUtility.php");
require_once("MemberDatabaseQuery.php");
require_once("../TimeZone.php");
require_once("MemberUtility.php");
require_once("MemberHistory.php");
require_once("HraFileChanges.php");
require_once("../global/GlobalMemberStatus.php");
require_once("../fax/FaxApiClass.php");
//Added by Ramya for exclusion member update 
require_once("../php_excel/PHPExcel.php");
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class members
{
	/*
		Created On : 26-05-2022
		Created By : Ramya
		Update exclusion files update
		For this need to update hraStatus as 4 , reportStatus as Ineligible and hraStatusHistory

	*/
	public function exclusionMemberUpdate($file_name,$client_id,$year){

		include("../db.php");

		//echo "<pre>". print_r($_FILES,1)."</pre>";
		$inputFileName = $_FILES['file']['tmp_name'];
		$objPHPExcel = new PHPExcel();
		$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
    	$objReader = PHPExcel_IOFactory::createReader($inputFileType);
    	$objPHPExcel = $objReader->load($inputFileName);

		$sheet = $objPHPExcel->getSheet(0); 
		$highestRow = $sheet->getHighestRow(); 
		$highestColumn = $sheet->getHighestColumn();

		$headings = $sheet->rangeToArray('A1:' . $highestColumn . 1,
                                            NULL,
                                            TRUE,
                                            FALSE);
	    //echo "<pre>". print_r($headings[0],1). "</pre>";exit;
		$index = "";
		foreach($headings[0] as $key => $value){
			if(strtolower($value) == "member_id" || strtolower($value) == "memberid"){
				$index = $key;
			}
		}

		//  Loop through each row of the worksheet in turn
		for ($row = 2; $row <= $highestRow; $row++){ 
    		//  Read a row of data into an array
    		$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,NULL,TRUE,FALSE);
    		
			//echo "<pre>". print_r($rowData,1)."</pre>";exit;
			$member_id = $rowData[0][$index];

			//$query = mysqli_query($conn, "SELECT * FROM HRA_member_".$client_id."_$year where member_id = '$member_id'");
			$query = mysqli_query($conn, "SELECT * FROM HRA_member_".$client_id."_$year where member_id = '$member_id' AND (JSON_EXTRACT(hraStatus,'$.hraStatus') IS NULL or JSON_EXTRACT(hraStatus,'$.hraStatus') = 0);");


			$response = new stdClass();
			$response -> memberId = $member_id;
            $response -> cleintId = $client_id;
			$response -> year = $year;

			if(mysqli_num_rows($query)>0){
				$resultData = $this-> addHraStatusHistory($client_id,$year,$member_id,'14',NULL);
				$result_success = $resultData['success'];
				$hra_history_updated = $resultData['updatedJsonHistory'];
				
				$update_sessid ="";
				if($result_success)
				{
					$update_sessid = "UPDATE HRA_member_".$client_id.'_'.$year." SET hraStatusHistory='$hra_history_updated' WHERE `member_id` = '$member_id'";
					$updated_resultt=mysqli_query($conn,$update_sessid);
					$updated_res = mysqli_affected_rows($conn);
					if($updated_res)
					{
						$response->HraStatusHistory = "Updated";
					}
					else
					{
						$response->hraStatusHistory = "Not Updated";						
					}
				}
				$ReportStatus = ReportStatus::updateReportStatus($client_id,$year,$member_id,"Ineligible");
				ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::IN_ELIGIBLE);
				$column_name_list =['hraStatus'];
				$hraStatusArray = array("hraStatus" => 14,"subStatus" => "","cancelStatus" => "","cancelText" => "");
           		$column_value_list=[json_encode($hraStatusArray)];
           		$hraStatusUpdate = DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
				
				$response -> hraStatus = $hraStatusUpdate ? "Updated" : "Not Updated";
				$response -> reportStatus = "Updated";
				
			}else{
				$reponse -> status = "Not Updated, member id is not there";
			}
			$response = json_encode($response);
			echo $response;
			//exit;
		}
		
		return true;
	}


	public function termDateUpdate($file_name,$client_id,$year){

		include("../db.php");

		//echo "<pre>". print_r($_FILES,1)."</pre>";
		$inputFileName = $_FILES['file']['tmp_name'];
		$objPHPExcel = new PHPExcel();
		$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
    	$objReader = PHPExcel_IOFactory::createReader($inputFileType);
    	$objPHPExcel = $objReader->load($inputFileName);

		$sheet = $objPHPExcel->getSheet(0); 
		$highestRow = $sheet->getHighestRow(); 
		$highestColumn = $sheet->getHighestColumn();

		$headings = $sheet->rangeToArray('A1:' . $highestColumn . 1,
                                            NULL,
                                            TRUE,
                                            FALSE);
	    //echo "<pre>". print_r($headings[0],1). "</pre>";exit;
		$index = "";
		foreach($headings[0] as $key => $value){
			if(strtolower($value) == "member_id" || strtolower($value) == "memberid" || strtolower($value)=="insuredmemberidentifier"){
				$index = $key;
			}
			if(strtolower($value) == "term_date" || strtolower($value) == "termdate" ){
				$index1 = $key;
			}
		}

		//  Loop through each row of the worksheet in turn
		for ($row = 2; $row <= $highestRow; $row++){ 
    		//  Read a row of data into an array
    		$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row,NULL,TRUE,FALSE);
    		
			//echo "<pre>". print_r($rowData,1)."</pre>";exit;
			$member_id = $rowData[0][$index];
			$termDate = $rowData[0][$index1];

			//$query = mysqli_query($conn, "SELECT * FROM HRA_member_".$client_id."_$year where member_id = '$member_id'");
			$query = mysqli_query($conn, "SELECT * FROM HRA_member_".$client_id."_$year where member_id = '$member_id';");


			$response = new stdClass();
			$response -> memberId = $member_id;
            $response -> cleintId = $client_id;
			$response -> year = $year;
			$response -> termDate = $termDate;
			if(mysqli_num_rows($query)>0){
				$response -> data = "present";
				$resultData = $this-> addHraStatusHistory($client_id,$year,$member_id,'18',NULL);
				$result_success = $resultData['success'];
				$hra_history_updated = $resultData['updatedJsonHistory'];
				
				$update_sessid ="";
				if($result_success)
				{
					$update_sessid = "UPDATE HRA_member_".$client_id.'_'.$year." SET hraStatusHistory='$hra_history_updated' , termDate = '".$termDate."' WHERE `member_id` = '$member_id'";
					$updated_resultt=mysqli_query($conn,$update_sessid);
					$updated_res = mysqli_affected_rows($conn);
					if($updated_res)
					{
						$response->HraStatusHistory = "Updated";
					}
					else
					{
						$response->hraStatusHistory = "Not Updated";						
					}
				}
				$ReportStatus = ReportStatus::updateReportStatus($client_id,$year,$member_id,"Termed");
				ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::TERMED);
				$column_name_list =['hraStatus'];
				$hraStatusArray = array("hraStatus" => 18,"subStatus" => "","cancelStatus" => "","cancelText" => "");
           		$column_value_list=[json_encode($hraStatusArray)];
           		$hraStatusUpdate = DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
				
				$response -> hraStatus = $hraStatusUpdate ? "Updated" : "Not Updated";
				$response -> reportStatus = "Updated";
				
			}else{
				$reponse -> status = "Not Updated, member id is not there";
			}
			$response = json_encode($response);
			echo $response;
			//exit;
		}
		
		return true;
	}
	public function referralForm($clientId,$year,$referralId,$memberId,$answer){

		include("../db.php");

		$data = $GLOBALS['input'];
        $update_hradata = "select * from HRA_member_" . $clientId . '_' . $year . " where member_id ='$memberId'";
        $updatehradataresult = mysqli_query($conn, $update_hradata);
		if (mysqli_num_rows($updatehradataresult) == 1) {
			$hrajson_data = $answer;
			$updateInprogressStatus = "update HRA_member_" . $clientId . '_' . $year . " set referralForm = '".json_encode($data)."'   where member_id ='$memberId'";
			try {
				$updateInprogressStatusResult = mysqli_query($conn, $updateInprogressStatus);
				$db_status = "updated";
			} catch (Exception $e) {
				$error = $e->getMessage();
			}

			$response = new stdClass();
						$response->status = 'updated';
						$response->memid = $memberId;
						//$response->hraStatus=$responseHraStatus;
						$response = json_encode($response);
					echo $response;
			
		}else{
			$response = new stdClass();
            $response->status = "recordnotfound";
            $response->memid = $memberId;
            $response = json_encode($response);
            echo $response;
		}
		
	}
	public function totalAllMember($clientId,$year,$start,$end)
	{

		include("../db.php");

		//create hra file changes utilty class to parse the 'hraFileUpdatedHistory' component details
		$hra_file_change = new HraFileChangesUtility;

		$differnce = $end - $start;
		$allfetch_recordquery = MemberDatabaseQuery::totalMemberQuery($clientId,$year,$start,$differnce);
		
		$allpatientinfo_result=mysqli_query($conn,$allfetch_recordquery);
		while($allpatientinfo_row=mysqli_fetch_array($allpatientinfo_result,MYSQLI_ASSOC))
		{ 

			$json_nurseinfo = $allpatientinfo_row['nurse_id'];
			$query_form = $allpatientinfo_row['query_form'];
			$scheduler = $allpatientinfo_row['scheduler'];
			$admin_idno = $allpatientinfo_row['admin_idno'];
			$memberinfo = $allpatientinfo_row['memberinfo'];
			$scheduleDate = $allpatientinfo_row['scheduleDate'];
			$termDate = $allpatientinfo_row['termDate'];
			$EvaluationDate = $allpatientinfo_row['EvaluationDate'];
			$hraStatus = $allpatientinfo_row['hraStatus'];
			$visitType = $allpatientinfo_row['VisitType'];
			$versioning = $allpatientinfo_row['versioning'];
			$qaid = $allpatientinfo_row['qa_id'];
			$coderid = $allpatientinfo_row['coder_id'];
			$scheduler_name = $allpatientinfo_row['scheduler_name'];
			$scheduler_full_name = $allpatientinfo_row['scheduler_firstname'].' '.$allpatientinfo_row['scheduler_lastname'];
			$scheduler_id = $allpatientinfo_row["scheduler_id"];
			$hra = $allpatientinfo_row['hra'];
			$uploadedfiles = $allpatientinfo_row['uploadedfiles']; 
			
			$hra_status_history = $allpatientinfo_row['hraStatusHistory'];
			$cancel_history = $allpatientinfo_row['cancelHistory'];
			
			//reports fields
			$sent_to_avility = $allpatientinfo_row['sentToAvility'];
			$invoice_date = $allpatientinfo_row['invoiceDate'];
			$notes = $allpatientinfo_row['reportNotes'];

			//newly added field 
			$schedule_hra_status = $allpatientinfo_row['schedulerCallHraStatus'];
			$avail_for_schedule = $allpatientinfo_row['availForSchedule'];
			$schedule_call_log_details= $allpatientinfo_row['schedulerCallLogDetails'];
			$scheduler_details = $allpatientinfo_row['schedulerDetails'];
			$scheduler_call_order = json_decode($allpatientinfo_row['schedulerCallOrder'],true);

			$scheduler_call_response = MemberUtility::getMemberCallResponse($hraStatus,$scheduler_id,$scheduler,
					$scheduler_details,$schedule_hra_status,$schedule_call_log_details);

			//import tracker details
			$import_tracker_details = json_decode($allpatientinfo_row['importTrackerDetails'],true);

			//previous assessment date
			$previous_assessment_date = $allpatientinfo_row['previousAssessmentDate'];

			$hra_file_updated_history = $allpatientinfo_row['hraFileUpdatedHistory'];
			//hra file updated history
			if($memberinfo)
			{

				$member_demo_graphic_details=FileIOUtility::getDemographicDetails($hra_file_change,$hra_file_updated_history);
				$mem_info_details = json_decode($memberinfo,true);

					$mem_info_details['eno'] = isset($member_demo_graphic_details['eno']) ? $member_demo_graphic_details['eno']:'';
					$mem_info_details['ename'] = isset($member_demo_graphic_details['ename']) ? $member_demo_graphic_details['ename']:'';
					///if plan,program,lob is not defined in memberinfo look in hra file
					$mem_info_details['Plan'] = isset($member_demo_graphic_details['plan']) ? $member_demo_graphic_details['plan']:$mem_info_details['Plan'];
					//$mem_info_details['Program'] = isset($member_demo_graphic_details['program']) ? $member_demo_graphic_details['program']:$mem_info_details['Program'];
					$mem_info_details['LOB'] = isset($member_demo_graphic_details['lob']) ? $member_demo_graphic_details['lob']:$mem_info_details['LOB'];
					
				$memberinfo = json_encode($mem_info_details);
			}

			//screening details
			$member_screening_details=FileIOUtility::getScreeningDetails($hra_file_change,$hra_file_updated_history,0,-1,-1);

			//refusal letter date
			$refusal_letter_date  = $allpatientinfo_row['refusalLetterDate'];

			//return mail 
			$return_mail = isset($allpatientinfo_row['return_mail'])?($allpatientinfo_row['return_mail']==1?true:false):false;

			//refusal letter date
			$report_status  = $allpatientinfo_row['reportStatus'];
			$report_status_array = json_decode($report_status,true);
			$report_status_text = isset($report_status_array['text'])?trim($report_status_array['text']):"";

			if($json_nurseinfo != '')
			{

				$getnurseClientname="select * from userLogin where userUniqueno=$json_nurseinfo";
				$getnurseClientResult=mysqli_query($conn,$getnurseClientname);
				$getnurseClientRow=mysqli_fetch_array($getnurseClientResult,MYSQLI_ASSOC);
				$nurseInfo = isset($getnurseClientRow['userInfo']) ? $getnurseClientRow['userInfo'] : '';
				$nursefirstname = isset($getnurseClientRow['firstname']) ? $getnurseClientRow['firstname'] : '';
				$nurseInfop= json_decode($nurseInfo);
				$clientName = isset($nurseInfop->clientName) ? $nurseInfop->clientName : '';
				$userInfo = $getnurseClientRow['userInfo'];
				
			}

			$scheduleDatee = isset($scheduleDate) ? $scheduleDate : '';
			$termDatee = isset($termDate) ? $termDate : '';
			$EvaluationDatee = isset($EvaluationDate) ? $EvaluationDate : '';
			$uploadedfiless = isset($uploadedfiles) ? $uploadedfiles : '';
				
			$getAdminname="select * from userLogin where userUniqueno=$admin_idno";
			$getAdminnameRes=mysqli_query($conn,$getAdminname);
			$getAdminnameRow=mysqli_fetch_array($getAdminnameRes,MYSQLI_ASSOC);
			$adminusername = $getAdminnameRow['username'];
			$json_nurseinfoo = isset($json_nurseinfo) ? $json_nurseinfo : '';
			$qaid = isset($qaid) ? $qaid : '';
			$coderid = isset($coderid) ? $coderid : '';
			
			$all_data[]=array("nurseid"=>$json_nurseinfoo,"nurseFirstName"=>$nursefirstname,"memberinfo"=>$memberinfo,"schedulerName"=>$scheduler_name,
								"schedulerFullName"=>$scheduler_full_name,"schedulerId"=>$scheduler_id,"scheduleDate"=>$scheduleDatee,"termDate"=>$termDatee,"EvaluationDate"=>$EvaluationDatee,
								"qaid"=>$qaid,"coderid"=>$coderid,"hraStatus"=>$hraStatus,"visitType"=>$visitType,
								"versioning"=>$versioning,"clientName"=>$clientName,"adminUserName"=>$adminusername,
								"ccd"=>$uploadedfiless,"nurseinfo"=>$userInfo,"query_form"=>$query_form,"scheduler"=>$scheduler,
								"hraStatusHistory"=>$hra_status_history,"cancelHistory"=>$cancel_history,"sentToAvility"=>$sent_to_avility,
								"invoiceDate"=>$invoice_date,"notes"=>$notes,"availForSchedule"=>$avail_for_schedule,
								"schedulerHraStatus"=>$schedule_hra_status,"schedulerCallResponse"=>$scheduler_call_response,"schedulerCallOrder"=>$scheduler_call_order,
								"refusalLetterDate"=>$refusal_letter_date,"returnMail"=>$return_mail,"reportStatus"=>$report_status_text,
								"screeningDetails" =>$member_screening_details,"importTrackerDetails"=>$import_tracker_details,
								"previousAssessmentDate"=>$previous_assessment_date
							);
				 
		}
		
		echo json_encode($all_data);
		
	}

	
	public function assignMember($memm_id,$nurse_Id,$clientId,$year)
	{
		include("../db.php");
		$mem_query = "select * from HRA_member_".$clientId.'_'.$year." where member_id='$memm_id'";
		try 
		{
			$hramem_result=mysqli_query($conn,$mem_query);
			if(mysqli_num_rows($hramem_result) == 1)
			{
				$update_sessid = "UPDATE HRA_member_".$clientId.'_'.$year." SET `nurse_id` = '$nurse_Id' WHERE `member_id` = '$memm_id'";
				$updated_res = NULL;
				try 
				{
					$updated_resultt=mysqli_query($conn,$update_sessid);
					$updated_res = mysqli_affected_rows($conn);
					if($updated_res)
					{
						$response = new stdClass();
						$response->status = "added";
						$response = json_encode($response);
					}
					else
					{
						$response = new stdClass();
						$response->status = "notadded";
						$response = json_encode($response);
						
					}
				}
				catch (Exception $e)
				{
					$error = $e->getMessage();
					echo $error;
				}
				echo $response;
			}
			else
			{
				$response = new stdClass();
				$response->status = "null";
				$response = json_encode($response);
				echo $response;
			}
		}
		catch (Exception $e)
		{
			$error = $e->getMessage();
			echo $error;
		}
	}
	
	public function assignToQa($memm_id,$qa_Id,$clientId,$year)
	{
		include("../db.php");

		$hra_username = $GLOBALS['input']->{'hraUsername'};

		$mem_query = "select * from HRA_member_".$clientId.'_'.$year." where member_id='$memm_id'";
		try 
		{
			$hramem_result=mysqli_query($conn,$mem_query);
			if(mysqli_num_rows($hramem_result) == 1)
			{
				$resultData = $this->addHraStatusHistory($clientId,$year,$memm_id,'-1',$hra_username);
				$result_success = $resultData['success'];
				$hra_history_updated = $resultData['updatedJsonHistory'];
				
				$update_sessid ="";
				if($result_success)
				{
					$update_sessid = "UPDATE HRA_member_".$clientId.'_'.$year." SET hraStatusHistory='$hra_history_updated', `qa_id` = '$qa_Id' WHERE `member_id` = '$memm_id'";
				}
				else
				{
					$update_sessid = "UPDATE HRA_member_".$clientId.'_'.$year." SET `qa_id` = '$qa_Id' WHERE `member_id` = '$memm_id'";
				}

				$updated_res = NULL;
				try 
				{
					$updated_resultt=mysqli_query($conn,$update_sessid);
					$updated_res = mysqli_affected_rows($conn);
					if($updated_res)
					{
						$response = new stdClass();
						$response->status = "added";
						$response = json_encode($response);
					}
					else
					{
						$response = new stdClass();
						$response->status = "notadded";
						$response = json_encode($response);	
					}	
				}
				catch (Exception $e){
					$error = $e->getMessage();
					echo $error;
				}
				
				echo $response;
			}
			else
			{
				$response = new stdClass();
				$response->status = "null";
				$response = json_encode($response);
				 echo $response;
			}
		}catch (Exception $e){
		$error = $e->getMessage();
		echo $error;
		}
	}

	public function assignToCoder($memm_id,$coder_Id,$clientId,$year)
	{
		include("../db.php");

		$hra_username = $GLOBALS['input']->{'hraUsername'};

		$mem_query = "select * from HRA_member_".$clientId.'_'.$year." where member_id='$memm_id'";
		try {

			$hramem_result=mysqli_query($conn,$mem_query);
			if(mysqli_num_rows($hramem_result) == 1)
			{
				$resultData = $this->addHraStatusHistory($clientId,$year,$memm_id,'-2',$hra_username);
				$result_success = $resultData['success'];
				$hra_history_updated = $resultData['updatedJsonHistory'];
			
				/*if($memm_id == "900031054*01"){
					echo "<pre>". print_r($resultData,1). "</pre>";
					exit;
				}*/
				$update_sessid ="";
				if($result_success)
				{
					 $update_sessid = "UPDATE HRA_member_".$clientId.'_'.$year." SET hraStatusHistory='$hra_history_updated', `coder_id` = '$coder_Id' WHERE `member_id` = '$memm_id'";
				}
				else
				{
					$update_sessid = "UPDATE HRA_member_".$clientId.'_'.$year." SET  `coder_id` = '$coder_Id' WHERE `member_id` = '$memm_id'";
				}

				$updated_res = NULL;
				try 
				{
					$updated_resultt=mysqli_query($conn,$update_sessid);
					$updated_res = mysqli_affected_rows($conn);
					if($updated_res)
					{
						$response = new stdClass();
						$response->status = "added";
						$response = json_encode($response);
					}
					else
					{
						$response = new stdClass();
						$response->status = "notadded";
						$response = json_encode($response);	
					}	
				}
				catch (Exception $e)
				{
					$error = $e->getMessage();
					echo $error;
				}
				
				echo $response;
			}
			else
			{
				$response = new stdClass();
				$response->status = "null";
				$response = json_encode($response);
				 echo $response;
			}
		}
		catch (Exception $e)
		{
			$error = $e->getMessage();
			echo $error;
		}
	}
	
	/*
		FUNCTION : singleMemberData
		DETAILS : get the member json hra file content as response for
				view form 
	*/
	public function singleMemberData($clientId,$year,$req_id)
	{
		include("../db.php");
		$allmemeber_recordquery="select * from HRA_member_".$clientId.'_'.$year." where member_id='$req_id'";
		try 
		{
			$allmemberinfo_result=mysqli_query($conn,$allmemeber_recordquery);
			$allmemberinfo_row=mysqli_fetch_array($allmemberinfo_result,MYSQLI_ASSOC);
			$fileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$req_id.'/'.$req_id.'.json';
			echo $getcontentdata = file_get_contents($fileepath);
		}
		catch(Exception $e)
		{
			$error = $e->getMessage();
			echo $error;
		}
	}

    public function singleMemberDataWithPrevYears($clientId, $year, $req_id)
    {
        include("../db.php");
//        $all_data = [];
        $allmemeber_recordquery = "select * from HRA_member_" . $clientId . '_' . $year . " where member_id='$req_id'";
        try {
            $allmemberinfo_result = mysqli_query($conn, $allmemeber_recordquery);
            $allmemberinfo_row = mysqli_fetch_array($allmemberinfo_result, MYSQLI_ASSOC);
            $fileepath = '../hrajsondata/HRA_member_' . $clientId . '/' . $year . '/' . $req_id . '/' . $req_id . '.json';
            $getcontentdata = file_get_contents($fileepath);
            $priorAssessment = $this->separateMemberQuery($clientId, $req_id, $year);
            $nurseSignature = $this->nurseSignatureQuery($clientId, $req_id, $year);
            $addendumNurseSignature = $this->addendumSignatureQuery($clientId, $req_id, $year);
            $examFinishDate = $this->examFinishDateQuery($clientId, $req_id, $year);
            $dateOfService = $this->dateOfServiceQuery($clientId, $req_id, $year);
//            $all_data[] = array(
//                "getcontentdata" => json_decode($getcontentdata),
//                "priorAssessment" => $priorAssessment,
//            );

            $compar = 0;
            if(isset($dateOfService) || isset($examFinishDate)) {
                $startDates = (isset($dateOfService) && isset($dateOfService['EvaluationDate'])) ? explode("T", $dateOfService['EvaluationDate']) : null;
                $startDate = (isset($startDates)) ? date("Y-m-d", strtotime($startDates[0])) : null;
                $endDate = (isset($examFinishDate) && isset($examFinishDate['exam_finished_date'])) ? explode("T", $examFinishDate['exam_finished_date']) : null;
                $endDate = (isset($endDate)) ? date("Y-m-d", strtotime($endDate[0])) : null;
                if (isset($endDate) && isset($startDate) && ($endDate >= $startDate)) {
                    $compar = 1;
                }
//    print_r($startDate);exit();
                if(isset($startDate) && isset($startDates)) {
                    $dateOfService['EvaluationDate'] = $startDate . "T" . $startDates[1];
                }
            }



			$referralFormQuery = $this->referralFormQuery($clientId, $req_id, $year);
			//echo "<pre>". print_r($referralFormQuery,1)."</pre>";exit;
            $response = new stdClass();
            $response->status = 1;
            $response->getcontentdata = json_decode($getcontentdata);
            $response->priorAssessment = $priorAssessment[0];
            $response->memberinfoData = $priorAssessment[0] ? $priorAssessment[0][0] : $priorAssessment[1][0];
			$response->referralFormData = $referralFormQuery[0]['referralForm'] ;
			$response->referralFormStatus = empty($referralFormQuery[0]['referralForm']) ? 0 : (isset(json_decode($referralFormQuery[0]['referralForm'])->referralFormStatus) ? json_decode($referralFormQuery[0]['referralForm'])->referralFormStatus : 0);
            $response->nurseSignature = $nurseSignature;
//            $response->addendumSignature = '';
            $response->addendumSignature = $addendumNurseSignature;
//            $response->examFinishDate = $examFinishDate;
            $response->examFinishDate = ($compar == 1) ? $examFinishDate : null;
            $response->dateOfService = $dateOfService;
            echo json_encode($response);
            return true;
        } catch (Exception $e) {
            $error = $e->getMessage();
            echo $error;
        }
    }

	public function referralFormQuery($clientId, $member_id, $year)
    {
		include("../db.php");
		$memberWithClientYear = [];
		$separate_member_query = 'SELECT member_id,clientid,year,hraStatus,memberinfo,query_form,nurse_id , referralForm ' . ' FROM HRA_member_' . $clientId . '_' . $year . " WHERE member_id = " . $member_id;
		$getClientsidsresult = mysqli_query($conn, $separate_member_query);
		if(mysqli_num_rows($getClientsidsresult)>0){
			while ($getClientsidsresp = mysqli_fetch_array($getClientsidsresult, MYSQLI_ASSOC)) {
				$memberWithClientYear[] = $getClientsidsresp;
			 }
			 return $memberWithClientYear;
		}
		return true;
	}

    public function separateMemberQuery($clientId, $member_id, $year)
    {
        include("../db.php");
        $clientsWithYear = [];
        $memberWithClientYear = [];
        $memberWithClientpresentYear = [];
        $getClientsidsNew = "SELECT year FROM HRA_client where clientId= '" . $clientId . "'";
        $getClientsidsresultNew = mysqli_query($conn, ($getClientsidsNew));
        $getClientsidsWithYear = mysqli_fetch_array($getClientsidsresultNew, MYSQLI_ASSOC);
        $clientsWithYear = explode(",", $getClientsidsWithYear["year"]);
        for ($i = 0; $i < sizeof($clientsWithYear); $i++) {
//            $separate_member_query = 'SELECT member_id,scheduleDate,clientid,year ' . ' FROM HRA_member_' . $clientId . '_' . $clientsWithYear[$i] . " WHERE member_id = " . $member_id;
            if($clientsWithYear[$i] <= $year) {
            $separate_member_query = 'SELECT member_id,scheduleDate,clientid,year,EvaluationDate,hraStatus,memberinfo,referralForm,query_form,nurse_id ' . ' FROM HRA_member_' . $clientId . '_' . $clientsWithYear[$i] . " WHERE member_id = '" . $member_id."'";
            $getClientsidsresult = mysqli_query($conn, $separate_member_query);
            while ($getClientsidsresp = mysqli_fetch_array($getClientsidsresult, MYSQLI_ASSOC)) {
                $memberWithClientYear[] = $getClientsidsresp;
            }
            }
        }

        if (empty($memberWithClientYear)){
            $separate_member_query = 'SELECT member_id,scheduleDate,clientid,year,EvaluationDate,hraStatus,memberinfo,query_form,nurse_id ' . ' FROM HRA_member_' . $clientId . '_' . $year . " WHERE member_id = '" . $member_id."'";
            $getClientsidsresult = mysqli_query($conn, $separate_member_query);
            while ($getClientsidsresp = mysqli_fetch_array($getClientsidsresult, MYSQLI_ASSOC)) {
                $memberWithClientpresentYear[] = $getClientsidsresp;
            }
        }

        return ([$memberWithClientYear, $memberWithClientpresentYear]);
    }

    public function nurseSignatureQuery($clientId, $member_id, $year)
    {
        include("../db.php");
        $separate_member_query = 'SELECT clinician_signature ' . ' FROM HRA_member_' . $clientId . '_' . $year . " WHERE member_id = " . $member_id;
        $allmemberinfo_result = mysqli_query($conn, $separate_member_query);
        $allmemberinfo_row = mysqli_fetch_array($allmemberinfo_result, MYSQLI_ASSOC);
        return $allmemberinfo_row;
    }

    public function addendumSignatureQuery($clientId, $member_id, $year)
    {
        include("../db.php");
        $addendum_member_query = 'SELECT addendum_clinician_signature ' . ' FROM HRA_member_' . $clientId . '_' . $year . " WHERE member_id = " . $member_id;
        $addesndum_result = mysqli_query($conn, $addendum_member_query);
        $addendumInfo_row = mysqli_fetch_array($addesndum_result, MYSQLI_ASSOC);
        return $addendumInfo_row;
    }

    public function examFinishDateQuery($clientId, $member_id, $year)
    {
        include("../db.php");
        $separate_member_query = 'SELECT exam_finished_date ' . ' FROM HRA_member_' . $clientId . '_' . $year . " WHERE member_id = '" . $member_id ."'";
        $allmemberinfo_result = mysqli_query($conn, $separate_member_query);
        $allmemberinfo_row = mysqli_fetch_array($allmemberinfo_result, MYSQLI_ASSOC);
        return $allmemberinfo_row;
    }

    public function dateOfServiceQuery($clientId, $member_id, $year)
    {
        include("../db.php");
//        $separate_member_query = '';
//        $separate_member_query = 'SELECT EvaluationDate ' . ' FROM HRA_member_' . $clientId . '_' . $year . " WHERE member_id = '" . $member_id ."'";
        $separate_member_query = 'SELECT (
					CASE
					WHEN EvaluationDate IS NOT NULL AND scheduleDate IS NOT NULL THEN EvaluationDate
					ELSE scheduleDate
					END
					) AS EvaluationDate  ' . ' FROM HRA_member_' . $clientId . '_' . $year . " WHERE member_id = '" . $member_id ."'";
        $allmemberinfo_result = mysqli_query($conn, $separate_member_query);
        $allmemberinfo_row = mysqli_fetch_array($allmemberinfo_result, MYSQLI_ASSOC);
        return $allmemberinfo_row;
    }

	public function evaluationDate($memm_id,$clientId,$year)
	{
		include("../db.php");
		$evaldatee = $GLOBALS['input']->{'data'};

		$updateEvalDate = "update HRA_member_".$clientId.'_'.$year." set query_form=JSON_SET(query_form,'$.dateOfService','$evaldatee'), EvaluationDate='$evaldatee' where member_id ='$memm_id'";
		try 
		{
			$updateEvalDateResult=mysqli_query($conn,$updateEvalDate);
			$updated_resp = mysqli_affected_rows($conn);
			if($updated_resp)
			{
				$response = new stdClass();
				$response->status = "updated";
				$response = json_encode($response);
				echo $response;
			}
			else
			{
				$response = new stdClass();
				$response->status = "notupdated";
				$response = json_encode($response);
				echo $response;
			}

		}
		catch (Exception $e)
		{
			$error = $e->getMessage();
		}

	}

    public function referralSendHelpline($memm_id,$clientId,$year)
    {
        include("../db.php");
        $referralDate = $GLOBALS['input']->{'data'};
        $update_referral_data = "select referralForm from HRA_member_".$clientId.'_'.$year." where member_id='$memm_id'";
        $getinfo_resultt=mysqli_query($conn,$update_referral_data);
        $getrowdata=mysqli_fetch_array($getinfo_resultt,MYSQLI_ASSOC);
//        print_r($getrowdata);exit();
//        $reportStatusinfo = $getrowdata['referralForm'];
        $reportStatusinfo = json_decode($getrowdata['referralForm'], true);
//        print_r($reportStatusinfo);exit();
        if(!empty($reportStatusinfo)) {
            $reportStatusinfo['sentToHelpLineDate'] = $referralDate;
            $reportStatusinfo['referralFormStatus'] = 2;
//        print_r($reportStatusinfo['sentToHelpLineDate']);exit();
//        $reportstatus_info = json_decode($reportStatusinfo, true);
//        $report_status = $reportstatus_info['text'];

            $referral_obj = json_encode($reportStatusinfo);
            $updateInprogressStatus = "update HRA_member_" . $clientId . '_' . $year . " set referralForm='$referral_obj' where member_id ='$memm_id'";
//        $updatedlogin_resultt=mysqli_query($conn,$updateSqlNurseStatus);
//        $updated_status = mysqli_affected_rows($conn);
//        print_r($updateInprogressStatus);exit();
            try {
                $updateEvalDateResult = mysqli_query($conn, $updateInprogressStatus);
                $updated_resp = mysqli_affected_rows($conn);
                if ($updated_resp) {
                    $response = new stdClass();
                    $response->status = "updated";
                    $response = json_encode($response);
                    echo $response;
                } else {
                    $response = new stdClass();
                    $response->status = "notupdated";
                    $response = json_encode($response);
                    echo $response;
                }

            } catch (Exception $e) {
                $error = $e->getMessage();
            }
        } else {
                $response = new stdClass();
                $response->status = "Not updated";
                $response->message = "Need to submit referral form";
                $response = json_encode($response);
                echo $response;
          }

    }
	
	public function registerMember($clientId,$year,$Member_Identification_Number)
	{
		//echo $clientId;die;
		include("../db.php");
		
		$Member_first_name = mysqli_real_escape_string($conn,$GLOBALS['inputData']['data']['Member_first_name']);
		$Member_Last_name = mysqli_real_escape_string($conn,$GLOBALS['inputData']['data']['Member_Last_name']);
		//$term_Date  = mysqli_real_escape_string($conn,$GLOBALS['inputData']['data']['termDate']);
		//$HICN = $GLOBALS['inputData']['data']['HICN'];
		$HICN = mysqli_real_escape_string($conn,$GLOBALS['inputData']['data']['HICN']);
		$AdminIDNO = $GLOBALS['input']->{'id'};
		$term_Date = $GLOBALS['input']->{'termDate'};
		$mem_info = $GLOBALS['inputData']['data'];
		$mem_info = json_encode($mem_info);
		$generatedName = $Member_Identification_Number .  '.json';
		$member_id_two = $GLOBALS['inputData']['data']['member_id_two'];
		$member_unique_id = $GLOBALS['inputData']['data']['Member_UniqueID'];
		//$clientId = $GLOBALS['input']->{'clientId'};
		//$year = $GLOBALS['input']->{'year'};
		
		 $check_recordexist="select * from HRA_member_".$clientId.'_'.$year." where member_id='$Member_Identification_Number'";
		 $result=mysqli_query($conn,$check_recordexist);
		 $memberinfo_row=mysqli_fetch_array($result,MYSQLI_ASSOC);
		 $created_on = $memberinfo_row['created_on'];
		 if(mysqli_num_rows($result) == 0)
		 {		
			TimeZone::useTimeZone();
			$date = date('d-m-Y h:i:s');
			$mem_info = mysqli_real_escape_string($conn,$mem_info);
			$req_id = $Member_Identification_Number;
			if($Member_Identification_Number != "")
			{
				$fileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/';
				$resp = file_exists($fileepath);
				if($resp == 1)
				{
					 $memfileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$req_id;
					 $memresp = file_exists($memfileepath);	
					 if($memresp == 1)
					 {
						$meminsidefilepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$req_id.'/'.$req_id.'.json';
						 $hraJson = $GLOBALS['input']->{'hraJson'};
						 $hraJson = json_encode($hraJson);
						 file_put_contents($meminsidefilepath,$hraJson);
						 $permit = FileIOUtility::HRA_JSON_FILE_PERMISISON;
						 chmod($meminsidefilepath, $permit);
					 }
					 else
					 {	
						 $memfileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$req_id;
						 $permit = FileIOUtility::CLIENT_YEAR_FOLDER_PERMISSION;
						 mkdir($memfileepath);
						 chmod($memfileepath, $permit);
						 $meminsidefilepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$req_id.'/'.$req_id.'.json';
						 $hraJson = $GLOBALS['input']->{'hraJson'};
						 $hraJson = json_encode($hraJson);
						 file_put_contents($meminsidefilepath,$hraJson);
						 $permit = FileIOUtility::HRA_JSON_FILE_PERMISISON;
						 chmod($meminsidefilepath, $permit);
					 }
					$generatedName = $req_id.'.json';		
					$hra='';//https://hra.focuscares.com/production/hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$req_id.'/'.$generatedName;
					$insert_membersql = null;
					if ($AdminIDNO != '')
					{
						if ($year < 2023) $insert_membersql = "insert into HRA_member_" . $clientId . '_' . $year . "(clientid,year,member_id,firstname,lastname,termDate,hicn,memberinfo,hra,admin_idno,created_on) values('$clientId','$year','$Member_Identification_Number','$Member_first_name','$Member_Last_name','$term_Date','$HICN','$mem_info','$hra','$AdminIDNO','$date')";
						else $insert_membersql = "insert into HRA_member_" . $clientId . '_' . $year . "(clientid,year,member_id,member_id_two,member_unique_id,firstname,lastname,termDate,hicn,memberinfo,hra,admin_idno,created_on) values('$clientId','$year','$Member_Identification_Number','$member_id_two','$member_unique_id','$Member_first_name','$Member_Last_name','$term_Date','$HICN','$mem_info','$hra','$AdminIDNO','$date')";		
					} else{			
						$nurseId = $GLOBALS['input']->{'nurseId'};
						$id = $GLOBALS['input']->{'id'};
                        if ($year < 2023) $insert_membersql = "insert into HRA_member_".$clientId.'_'.$year."(nurse_id,clientid,year,member_id,firstname,lastname,termDate,hicn,memberinfo,hra,hraStatus,created_on) values('$nurseId','$clientId','$year','$Member_Identification_Number','$Member_first_name','$Member_Last_name','$term_Date','$HICN','$mem_info','$hra','0','$date')";	 
						else $insert_membersql = "insert into HRA_member_".$clientId.'_'.$year."(nurse_id,clientid,year,member_id,member_id_two,member_unique_id,firstname,lastname,termDate,hicn,memberinfo,hra,hraStatus,created_on) values('$nurseId','$clientId','$year','$Member_Identification_Number','$member_id_two','$member_unique_id','$Member_first_name','$Member_Last_name','$term_Date','$HICN','$mem_info','$hra','0','$date')";	 
					}

					$response = new stdClass();
					try
					{
						mysqli_query($conn, $insert_membersql);	
						$newRecordId = mysqli_insert_id($conn);
						if($newRecordId)
						{		
							//raise event call back when member created successful
							$member_id = $req_id;
							$member_info_array = $GLOBALS['inputData']['data'];
							MemberUtility::OnMemberRegister($clientId,$year,$member_id,$member_info_array);
							//START - hra json file changes detection utility
								$hra_file_change = new HraFileChangesUtility;
								$current_hra_json_data = $GLOBALS['input']->{'hraJson'};
								$current_hra_json_content = json_encode($current_hra_json_data);
								$hra_file_change->onHraFileUpdatedHistory($clientId,$year,$member_id,$current_hra_json_content,true);
							//end of hra file change
						
							$response->status = "Saved";
							$response = json_encode($response);
							echo $response;
						}
						else
						{
							$response->status = "notSaved";
							$response = json_encode($response);
							echo $response;
						}
						
					}
					catch(Exception $e)
					{
						$error = $e->getMessage();
						echo $error;	
					}
					
				}
				
			}	
			
		 }
		 else
		 {	
			 	//functionality removed due to client approval pending
			 	//when member already exists and verify that member can be moved to next year or NOT
				//$create_member_response = $this->createMemberOnNextYear($clientId,$year,$Member_Identification_Number,$created_on);
				//if($create_member_response)
				//{
				//	echo $create_member_response;
				//}
				//else
				//{

					$response = new stdClass();
					$req_id = $Member_Identification_Number;
					$response->status = "Exists";
					$response->date = $created_on;
					$response->memberdata = $memberinfo_row;
					//read the already saved json file
					$jsonfilepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$req_id.'/'.$req_id.'.json';
					$jsonfilecontent = file_get_contents($jsonfilepath);
					if($jsonfilecontent)
					{
						$response->jsonfilecontent = $jsonfilecontent;
					}
					else
					{
						$response->jsonfilecontent="null";
					}

					$response = json_encode($response);
					echo $response;
				//}
		 }
	}

	/*
		Created On : 23-11-2020
		Create a Member on next year table if already existed with condition  
		1) Created on date and current date exceeds more than 10 month 
	*/
	public function createMemberOnNextYear($client_id,$current_year,$member_id,$date_created)
	{
		//database reference
		include("../db.php");

		//check date member created and current date
		TimeZone::useTimeZone();
		$created_year = date('Y', strtotime($date_created));
		$current_year = date('Y');
		$created_month = date('m', strtotime($date_created));
		$current_month = date('m');
		//offset month index by -1 to calculate month difference
		//include that month also
		$calculated_created_month = $created_month-1;
		if($calculated_created_month<=0) $calculated_created_month=0;
		if($created_month==$current_month)
		{
			$calculated_created_month = $created_month;
		}
		//calculate month difference if exceeds more than 12
		$month_difference = ($current_month - $calculated_created_month)+(($current_year - $created_year) * 12);
		//if month less equal to 10 
		if($month_difference<=10)
		{
			return null;
		}

		//calculate next year
		$year_int = (int)$current_year;
		$next_year = $year_int+1;
		$year = $next_year;

		//first check next year table already created or not
		$table_name = "HRA_member_".$client_id.'_'.$year;
		$check_table_query="SHOW TABLES LIKE '".$table_name."'";
		$check_table_query_result=mysqli_query($conn,$check_table_query);
		//if sql query result with zero means no such a table
		if(mysqli_num_rows($check_table_query_result) == 0)
		{
			$response = new stdClass();
			$response->status = "notSaved";
			$response->details = "member table not avaiable for the client id ".$client_id." and year ".$year;
			$response = json_encode($response);
			return $response;
		}
		else
		{

			//read the member information from request body
			$member_first_name = mysqli_real_escape_string($conn,$GLOBALS['inputData']['data']['Member_first_name']);
			$member_last_name = mysqli_real_escape_string($conn,$GLOBALS['inputData']['data']['Member_Last_name']);
			
			//check HICN value present or not
			$hicn = null;
			if(array_key_exists("HICN",$GLOBALS['inputData']['data']))
			{
				$hicn = mysqli_real_escape_string($conn,$GLOBALS['inputData']['data']['HICN']);
			}

			$admin_unique_id = $GLOBALS['input']->{'id'};
			$term_Date = $GLOBALS['input']->{'termDate'};
			$member_data = $GLOBALS['inputData']['data'];
			$member_info = json_encode($member_data);

			//check member already present or not
			$check_record_exist_query="select * from HRA_member_".$client_id.'_'.$year." where member_id='$member_id'";
			$check_record_exist_query_result=mysqli_query($conn,$check_record_exist_query);
			$member_info_row=mysqli_fetch_array($check_record_exist_query_result,MYSQLI_ASSOC);
			//if sql query result with zero means no member already exist on the next year table
			if(mysqli_num_rows($check_record_exist_query_result) == 0)
			{
				TimeZone::useTimeZone();
				$created_on_date = date('d-m-Y h:i:s');
				$member_info = mysqli_real_escape_string($conn,$member_info);
				if($member_id != "")
				{
					$folder_path = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/';
					$is_folder_exist = file_exists($folder_path);
					if($is_folder_exist == 1)
					{	
						//check member folder path already exist or NOT
						$member_folder_path = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id;
						$is_member_folder_path_exist = file_exists($member_folder_path);
						if($is_member_folder_path_exist == 1)
						{
							$member_json_file_full_path = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
							$hra_json_details = $GLOBALS['input']->{'hraJson'};
							$hra_json = json_encode($hra_json_details);
							file_put_contents($member_json_file_full_path,$hra_json);
							$permit = FileIOUtility::HRA_JSON_FILE_PERMISISON;
							chmod($member_json_file_full_path, $permit);
						}
						else
						{
							//if not exist created member json folder and file
							$member_folder_path = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id;
							$folder_permission = FileIOUtility::CLIENT_YEAR_FOLDER_PERMISSION;
							mkdir($member_folder_path);
							chmod($member_folder_path, $folder_permission);
							$member_json_file_full_path = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
							$hra_json_details = $GLOBALS['input']->{'hraJson'};
							$hra_json = json_encode($hra_json_details);
							file_put_contents($member_json_file_full_path,$hra_json);
							$file_permission = FileIOUtility::HRA_JSON_FILE_PERMISISON;
							chmod($member_json_file_full_path, $file_permission);
						}
						
						//member based file name
						$json_file_name = $member_id.'.json';
						//hra field value of json file location
						$hra='';//https://hra.focuscares.com/production/hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id.'/'.$json_file_name;
						
						//prepare sql query for create new member data
						if($admin_unique_id != '')
						{
							$insert_member_sql_query="insert into HRA_member_".$client_id.'_'.$year."(clientid,year,
													member_id,firstname,lastname,termDate,hicn,memberinfo,hra,admin_idno,created_on) 
													values('$client_id','$year','$member_id',
													'$member_first_name','$member_last_name','$term_Date','$hicn','$member_info',
													'$hra','$admin_unique_id','$created_on_date')";
						}
						else
						{
							$nurse_id = $GLOBALS['input']->{'nurseId'};
							$id = $GLOBALS['input']->{'id'};
							$insert_member_sql_query="insert into HRA_member_".$client_id.'_'.$year."(nurse_id,clientid,
											year,member_id,firstname,lastname,termDate,hicn,memberinfo,hra,hraStatus,created_on) 
											values('$nurse_id','$client_id','$year','$member_id',
											'$member_first_name','$member_last_name','$term_Date','$hicn','$member_info','$hra','0','$created_on_date')";
							
						}
						
						//create response object to retrun proper response
						$response = new stdClass();
						try
						{
							//sql query for insert new member
							mysqli_query($conn, $insert_member_sql_query);
							$added_record_id = mysqli_insert_id($conn);
							if($added_record_id)
							{
								$response->status = "Saved";
								$response->details = "member created on next year table.because exceeds 10 month period";
								$response = json_encode($response);
								return $response;
							}
							else
							{
								$response->status = "notSaved";
								$response = json_encode($response);
								return $response;
							}
							
						}
						catch(Exception $e)
						{
							$error = $e->getMessage();
							return $error;	
						}
						
					}
					
				}	
				
			}
			else
			{
				$response = new stdClass();
				$response->status = "notSaved";
				$response->details = "member id meets 10 month period condition.but already available for the client id ".$client_id." and year ".$year;
				$response = json_encode($response);
				return $response;
			}

		}

		return null;

	}


	/*
		update member values and save updated hra json file
		new function added on 05_10_2020 
		Updated On 06_10_2020
	*/
	public function updateMember($client_id,$year,$member_id)
	{
		include("../db.php");

		$update_member_json_data = $GLOBALS['inputData'];
		//member data column
		$firstname = $update_member_json_data['data']['firstname'];
		$lastname = $update_member_json_data['data']['lastname'];
		$termDate = $update_member_json_data['data']['termDate'];
		$memberinfo = $update_member_json_data['data']['memberinfo'];

		$json_file_content = $update_member_json_data['hraJson'];
		$hraJson = json_encode($json_file_content);
		//first check member exit or not
		$is_update_member_available_query = "select * from HRA_member_".$client_id.'_'.$year." where member_id ='$member_id'";
		$is_update_member_available_result=mysqli_query($conn,$is_update_member_available_query);
		$member_record_response = mysqli_num_rows($is_update_member_available_result);
		//is member avaialble to update
		if($member_record_response)
		{
			try 
			{
				$updated_member_query_response = NULL;
				$write_json_file_status = 0 ;
				//memberinfo encode before update into database
				$memberinfo_sql_string = mysqli_real_escape_string($conn,json_encode($memberinfo));
				//member database update query
				$update_member_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET `firstname` = '$firstname',`lastname` = '$lastname',`memberinfo` = '$memberinfo_sql_string',`termDate` = '$termDate' WHERE `member_id` ='$member_id'";
				$update_member_query_result=mysqli_query($conn,$update_member_query);	
				$updated_member_query_response = mysqli_affected_rows($conn);
				
				//START - hra json file changes detection utility
				$hra_file_change = new HraFileChangesUtility;
				$hra_file_change->onHraFileUpdatedHistory($client_id,$year,$member_id,$hraJson);
				//end of hra file change

				//hra json file updated
				$hra_json_data_file_path = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
				$write_json_file_status = file_put_contents($hra_json_data_file_path,$hraJson);
				$permit = FileIOUtility::HRA_JSON_FILE_PERMISISON;
				chmod($hra_json_data_file_path, $permit);
				//send response based on the result
				if($updated_member_query_response)
				{
					$response = new stdClass();
					$response->status = 'updated';
					$response->dbstatus =$update_member_query_result;
					if($write_json_file_status!=0)
					{
						$response->jsonfilestatus = 'json file saved'; 
					} 
					else
					{
						$response->jsonfilestatus = 'json file save failed'; 
					}
					$response = json_encode($response);
					echo $response;
	
				}
				else
				{
					$response = new stdClass();
					$response->status = 'not updated';
					$response->member = 'no memeber value changes found';
					if($write_json_file_status!=0)
					{
						$response->jsonfilestatus = 'json file saved'; 
					} 
					else
					{
						$response->jsonfilestatus = 'json file save failed'; 
					}
					$response = json_encode($response);
					echo $response;
				}
			}
			catch (Exception $e)	
			{
				$error = $e->getMessage();
				echo $error;
			}

		}
		else
		{
			//member not found error
			$response = new stdClass();
			$response->status = "member record not found";
			$response->memberid = $member_id;
			$response = json_encode($response);
			echo $response;
		}

		
	}

	/*
			NAME 		: addHraStatusHistory
			DETAILS		: add hra status history is the utiltiy function to return hra status history updated json value
						  and database operation validation as return value
						  new function added on 19_10_2020 
			PARAMETERS 	: client id, year ,member id ,hra status , hra admin username
			RETURN		: array of database status and updated hra history json 
		*/
		public function addHraStatusHistory($client_id,$year,$member_id,$hra_status,$hra_username)
		{

			return MemberUtility::OnAddHraStatusHistory($client_id,$year,$member_id,$hra_status,$hra_username,null);

			/*
				include("../db.php");

				$hra_status_history="";
				$hra_status_history_array=NULL;
				$hra_status_history_query = "select * from HRA_member_".$client_id.'_'.$year." where member_id='$member_id'";
				$db_success = false;
				try
				{
					$hra_status_history_query_result=mysqli_query($conn,$hra_status_history_query);
					if(mysqli_num_rows($hra_status_history_query_result) == 1)
					{
						$hra_history_row=mysqli_fetch_array($hra_status_history_query_result,MYSQLI_ASSOC);
						$hra_status_history = $hra_history_row['hraStatusHistory'];
						$db_success=true;
					}
				}
				catch (Exception $e)
				{
					$error = $e->getMessage();
					$db_success=false;
				}

				//if hra status history is null or empty
				if($hra_status_history=="" || $hra_status_history==NULL )
				{
					$hra_status_history =  '{ 
						"scheduled":[],"inProgress":[],"appointmentCancelled":[],
						"patientRefusal":[],"utc":[],"readyForQa":[],"qaAssigned":[],
						"readyForCoder":[],"coderAssigned":[],"clinicianReviewQa":[],"clinicianReviewCoder":[],
						"readyForUpload":[],"completed":[],"assessmentCalcelled":[],"preScheduled":[],
						"inEligibile":[],"deceased":[],"hospice":[],"other":[],"termExpired":[],"noShow":[]
						}';
				}

				//decode the json hra history format into php array
				$hra_status_history_array = json_decode($hra_status_history, true);

				//newly added fields 'preScheduled' to 'termExpired' so validate that keys already in available or not
				//if not push the php array with those newly added keys
				if (!array_key_exists('preScheduled', $hra_status_history_array))
				{
					$updated_hra_status_history='{ "preScheduled":[],
						"inEligibile":[],"deceased":[],"hospice":[],"other":[],"termExpired":[] ,"noShow":[] }';
					$hra_status_history_array =	array_merge( $hra_status_history_array,json_decode($updated_hra_status_history, true));
				}
				
				TimeZone::useTimeZone();
				$current_date_time = date("Y-m-d")."T".date("H:i");
				$hra_status_new_history = array("date"=>$current_date_time, "username"=>$hra_username);
			
					switch ( $hra_status )
					{	
							case '1':
								array_push( $hra_status_history_array['scheduled'], $hra_status_new_history );
							break;

							case '2':
								array_push( $hra_status_history_array['inProgress'], $hra_status_new_history );
							break;

							case '3':
								array_push( $hra_status_history_array['appointmentCancelled'], $hra_status_new_history );
							break;

							case '4':
								array_push( $hra_status_history_array['patientRefusal'], $hra_status_new_history );
							break;

							case '5':
								array_push( $hra_status_history_array['utc'], $hra_status_new_history );
							break;

							case '6':
								array_push( $hra_status_history_array['readyForQa'], $hra_status_new_history );
							break;

							case '7':
								array_push( $hra_status_history_array['readyForCoder'], $hra_status_new_history );
							break;

							case '8':
								array_push( $hra_status_history_array['clinicianReviewQa'], $hra_status_new_history );
							break;

							case '9':
								array_push( $hra_status_history_array['clinicianReviewCoder'], $hra_status_new_history );
							break;

							case '10':
								array_push( $hra_status_history_array['readyForUpload'], $hra_status_new_history );
							break;

							case '11':
								array_push( $hra_status_history_array['completed'], $hra_status_new_history );
							break;

							case '12':
								array_push( $hra_status_history_array['assessmentCalcelled'], $hra_status_new_history );
							break;

							case '13':
								array_push( $hra_status_history_array['preScheduled'], $hra_status_new_history );
							break;
							
							case '14':
								array_push( $hra_status_history_array['inEligibile'], $hra_status_new_history );
							break;
							
							case '15':
								array_push( $hra_status_history_array['deceased'], $hra_status_new_history );
							break;
							
							case '16':
								array_push( $hra_status_history_array['hospice'], $hra_status_new_history );
							break;
							
							case '17':
								array_push( $hra_status_history_array['other'], $hra_status_new_history );
							break;
							
							case '18':
								array_push( $hra_status_history_array['termExpired'], $hra_status_new_history );
							break;

							case '19':
								array_push( $hra_status_history_array['noShow'], $hra_status_new_history );
							break;
							
							//non hra status number 
							case '-1': //qaAssigned
								array_push( $hra_status_history_array['qaAssigned'], $hra_status_new_history );
							break;

							case '-2'://coderAssigned
								array_push( $hra_status_history_array['coderAssigned'], $hra_status_new_history );
							break;
					}

				return array("success"=>$db_success , "updatedJsonHistory"=>json_encode($hra_status_history_array),"date"=>$current_date_time);
				
			*/

		}

		/*
			NAME 		: addCancelHistory
			DETAILS 	: used to store the patient cancellation status history in 'cancelHistory' as json array format 
			PARAMETERS 	: client id,year,member id,admin user name,hra status,sub status,cancel status,cancel text
			RETURN 		: true if history updated else false
		*/
		private function addCancelHistory($client_id,$year,$member_id,$hra_username,$hra_status,$sub_status,$cancel_status,$cancel_text,$current_date_time)
		{
			return MemberUtility::OnAddCancelHistory($client_id,$year,$member_id,$hra_username,$hra_status,$sub_status,$cancel_status,$cancel_text,$current_date_time);
			
			/*
				include("../db.php");
				
				$cancel_history="";
				$cancel_history_array=NULL;
				$member_query = "select * from HRA_member_".$client_id.'_'.$year." where member_id='$member_id'";
				$is_member = false;
				try
				{
					$member_query_result=mysqli_query($conn,$member_query);
					if(mysqli_num_rows($member_query_result) == 1)
					{
						$member_row=mysqli_fetch_array($member_query_result,MYSQLI_ASSOC);
						$visit_type = $member_row['VisitType'];
						$cancel_history = $member_row['cancelHistory'];
						$is_member=true;
					}
				}
				catch (Exception $e)
				{
					$error = $e->getMessage();
					$is_member=false;
				}

				if($is_member)
				{

					if($cancel_history=="" || $cancel_history==NULL )
					{
						$cancel_history =  '{ "appointmentCancelled":[] , "patientRefusal":[] ,"utc":[] ,"noShow":[] }';
					}
					
					//decode the json cancel history into array
					$cancel_history_array = json_decode($cancel_history, true);

					//its added because its later update on 05-01-2021
					//newly added fields 'patientRefusal' to 'utc' so validate that keys already is available or not
					if (!array_key_exists('patientRefusal', $cancel_history_array))
					{
						$updated_cancel_history='{ "patientRefusal":[], "utc":[] ,"noShow":[] }';
						$cancel_history_array =	array_merge( $cancel_history_array,json_decode($updated_cancel_history, true));
					}

					//cancel history array format
					$new_cancel_history = array("date"=>$current_date_time, 
												"username"=>$hra_username,
												"hraStatus"=>$hra_status,
												"subStaus"=>$sub_status,
												"cancelStatus"=>$cancel_status,
												"cancelText"=>$cancel_text,
												"date"=>$current_date_time,
												"type"=>$visit_type);
			
					switch ( $hra_status )
					{	
						case '3':
							array_push( $cancel_history_array['appointmentCancelled'], $new_cancel_history );
						break;

						case '4':
							array_push( $cancel_history_array['patientRefusal'], $new_cancel_history );
						break;

						case '5':
							array_push( $cancel_history_array['utc'], $new_cancel_history );
						break;

						case '19':
							array_push( $cancel_history_array['noShow'], $new_cancel_history );
						break;
					}

					//update the cancel history in db
					$updated_cancel_history=json_encode($cancel_history_array);
					$update_cancel_history_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET cancelHistory='$updated_cancel_history' WHERE `member_id` = '$member_id'";
					$update_cancel_history_query_result = NULL;
					try 
					{
						$update_cancel_history_query_result=mysqli_query($conn,$update_cancel_history_query);
						$updated_row_count = mysqli_affected_rows($conn);
						if($updated_row_count)
						{
							return true;
						}
						else
						{	
							//no value value change detected
							if($update_cancel_history_query_result)
							{
								return true;
							}
							return false;
						}	
					}
					catch (Exception $e)
					{
						$error = $e->getMessage();
						return false;
					}

				}

				return false;
			*/

		}


public function updatehradetails($clientId,$year){
  include("../db.php");

  $getdata = "SELECT member_id FROM HRA_member_".$clientId.'_'.$year." where JSON_LENGTH(JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory, REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening' )),'.component', '.value[0]') ))) <> 1";
  $updatehradataresult=mysqli_query($conn,$getdata);
  $memberidsarrayy = [];
  while($allpatientinfo_row=mysqli_fetch_array($updatehradataresult,MYSQLI_ASSOC))
  {
	$memberidsarrayy[] = $allpatientinfo_row['member_id'];
	}




	foreach($memberidsarrayy as  $value){
	$member_id = $value;
	 $allmemeber_recordquery="select * from HRA_member_".$clientId.'_'.$year." where member_id='$member_id'";
	
		$allmemberinfo_result=mysqli_query($conn,$allmemeber_recordquery);
		$allmemberinfo_row=mysqli_fetch_array($allmemberinfo_result,MYSQLI_ASSOC);
		$fileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
		$hrajson_data = file_get_contents($fileepath);

		$hra_file_change = new HraFileChangesUtility;
		$hra_json_content=$hrajson_data;
		$hra_file_change->onHraFileUpdatedHistory($clientId,$year,$member_id,$hra_json_content);
//die;
  }
		}

    public function runhraSaveApiOld($clientId, $year, $table)
    {
//        include("../db.php");
//        $query = mysqli_query($conn,"SELECT member_id FROM $table");
//        while($row = mysqli_fetch_assoc($query)) {
//            $member_id = $row['member_id'];
            $member_id = '11000982';
            $this->hraSave($clientId,$year,$member_id);
//        }
    }

    public function runhraSaveApiOld2($clientId, $year, $table)
    {

        include("../db.php");
        $query = mysqli_query($conn,"SELECT member_id FROM $table");
        while($row = mysqli_fetch_assoc($query)) {
            $member_id = $row['member_id'];
        $hraUsername = "admin";
        $userType ="admin";
//            $getcontentdata = '';
        $fileepath = '../hrajsondata/HRA_member_' . $clientId . '/' . $year . '/' . $member_id . '/' . $member_id . '.json';
        $getcontentdata = file_get_contents($fileepath);
        $data =json_decode($getcontentdata, true);
        $this->hraSaveApiToSaveScreeingData($clientId, $year, $member_id, $data, $hraUsername, $userType);
        }
    }

    public function runhraSaveApi($clientId, $year, $table)
    {
        $memberData = ['CC0025782','CC0026926','CC0022901'];

        include("../db.php");
        $query = mysqli_query($conn,"SELECT member_id FROM $table");
        while($row = mysqli_fetch_assoc($query)) {
            $member_id = $row['member_id'];

            if (in_array($member_id, $memberData, TRUE))
            {
//                exit();


                $hraUsername = "admin";
                $userType ="admin";
//            $getcontentdata = '';
                $fileepath = '../hrajsondata/HRA_member_' . $clientId . '/' . $year . '/' . $member_id . '/' . $member_id . '.json';
                $getcontentdata = file_get_contents($fileepath);
                $data =json_decode($getcontentdata, true);
//                print_r($data);exit();
                $this->hraSaveApiToSaveScreeingData($clientId, $year, $member_id, $data, $hraUsername, $userType);

            }
            else
            {
//                echo "not found \n";
//                exit();
            }


        }
    }

    public function hraSaveApiToSaveScreeingData($clientId, $year, $req_id, $data, $hraUsername, $userType)
    {
        include("../db.php");
        $signature = $this->savingSignatureData($clientId, $year, $req_id);

        $update_hradata = "select * from HRA_member_" . $clientId . '_' . $year . " where member_id ='$req_id'";
        $updatehradataresult = mysqli_query($conn, $update_hradata);
        $hrajson_data = $data;
        $latestlobvalue = $hrajson_data['data'][0]['q'][0]['lob'];
        $latestpcpname = $hrajson_data['data'][0]['q'][0]['pphy'];
        $latestDobValue = $hrajson_data['data'][0]['q'][0]['dob'];
        $hrajson_data['data'][0]['q'][0]['program'] = 'Care N Care';
//        $latestDobValue = $hrajson_data['data'][0]['q'][0]['email'];
        if ($hrajson_data['data'][3]['t'] == "Screenings Needed") {
            $latestMicroAlbumInValue = $hrajson_data['data'][3]['q'][0]['a']['indx'][0];
            $latestFobtValue = $hrajson_data['data'][3]['q'][1]['a']['indx'][0];
            $latestHba1cInValue = $hrajson_data['data'][3]['q'][2]['a']['indx'][0];
            $latestLdlValue = $hrajson_data['data'][3]['q'][3]['a']['indx'][0];
            $latestDigitalRetinalExamValue = $hrajson_data['data'][3]['q'][4]['a']['indx'][0];
            $latestDexaValue = $hrajson_data['data'][3]['q'][5]['a']['indx'][0];
            $latestPadValue = $hrajson_data['data'][3]['q'][6]['a']['indx'][0];
        } elseif ($hrajson_data['data'][13]['t'] == "Screenings Needed") {
            $latestMicroAlbumInValue = $hrajson_data['data'][13]['q'][0]['a']['indx'][0];
            $latestFobtValue = $hrajson_data['data'][13]['q'][1]['a']['indx'][0];
            $latestHba1cInValue = $hrajson_data['data'][13]['q'][2]['a']['indx'][0];
            $latestLdlValue = $hrajson_data['data'][13]['q'][3]['a']['indx'][0];
            $latestDigitalRetinalExamValue = $hrajson_data['data'][13]['q'][4]['a']['indx'][0];
            $latestDexaValue = $hrajson_data['data'][13]['q'][5]['a']['indx'][0];
            $latestPadValue = $hrajson_data['data'][13]['q'][6]['a']['indx'][0];
        }

        $hra_username = $hraUsername;
        $user_type = $userType;
        $hrajson_dataa = json_encode($hrajson_data);
        if (mysqli_num_rows($updatehradataresult) == 1) {
            $allhramember_row = mysqli_fetch_array($updatehradataresult, MYSQLI_ASSOC);

            $hraStatus = $allhramember_row['hraStatus'];
            $memberinfo = $allhramember_row['memberinfo'];
            $memberinfo_array = json_decode($memberinfo, true);
            $memberinfo_array['LOB'] = $latestlobvalue;
            $memberinfo_array['Date_Of_Birth'] = $latestDobValue;
            $memberinfo_array['Pcp_Name'] = $latestpcpname;
            $memberinfo_array['MICROALBUMIN'] = $latestMicroAlbumInValue == 1 ? 'Y' : 'N';
            $memberinfo_array['FOBT'] = $latestFobtValue == 1 ? 'Y' : 'N';
            $memberinfo_array['HBA1C'] = $latestHba1cInValue == 1 ? 'Y' : 'N';
            $memberinfo_array['LDL'] = $latestLdlValue == 1 ? 'Y' : 'N';
            $memberinfo_array['DIGITAL_RETINAL_EXAM'] = $latestDigitalRetinalExamValue == 1 ? 'Y' : 'N';
            $memberinfo_array['DEXA'] = $latestDexaValue == 1 ? 'Y' : 'N';
            $memberinfo_array['PAD'] = $latestPadValue == 1 ? 'Y' : 'N';



            //suresh  To update demographic data in member_info column
            $memberinfo_array['Aligned'] = $hrajson_data['data'][0]['q'][0]['aligned'];
            if($memberinfo_array['Member_Identification_Number']=='' && $GLOBALS['inputData']['id']!=''){
                $memberinfo_array['Member_Identification_Number'] = $GLOBALS['inputData']['id'];
            }
            // $memberinfo_array['Member_Identification_Number'] = $hrajson_data['data'][0]['q'][0]['insh'];

            if($hrajson_data['data'][0]['q'][0]['gend']=='0'){
                $gender='M';
            }else if($hrajson_data['data'][0]['q'][0]['gend']=='1'){
                $gender='F';
            }

            $memberinfo_array['Member_Region'] = $hrajson_data['data'][0]['q'][0]['region'];
            $memberinfo_array['Plan'] = $hrajson_data['data'][0]['q'][0]['plan'];
//            $memberinfo_array['Program'] = $hrajson_data['data'][0]['q'][0]['program'];
            $memberinfo_array['Program'] ='Care N’ Care';
            $memberinfo_array['Date_Of_Birth'] = $hrajson_data['data'][0]['q'][0]['dob'];
            $memberinfo_array['Member_Address1'] = $hrajson_data['data'][0]['q'][0]['add'];
            $memberinfo_array['Member_Address2'] = $hrajson_data['data'][0]['q'][0]['add2'];
            $memberinfo_array['Member_Address3'] = $hrajson_data['data'][0]['q'][0]['add3'];
            $memberinfo_array['Member_City'] = $hrajson_data['data'][0]['q'][0]['city'];
            $memberinfo_array['Member_State'] = $hrajson_data['data'][0]['q'][0]['state'];
            $memberinfo_array['Member_Zip_Code'] = $hrajson_data['data'][0]['q'][0]['zip'];
            $memberinfo_array['Mailing_Address1'] = $hrajson_data['data'][0]['q'][0]['madd1'];
            $memberinfo_array['Mailing_Address2'] = $hrajson_data['data'][0]['q'][0]['madd2'];
            $memberinfo_array['Mailing_City'] = $hrajson_data['data'][0]['q'][0]['mcity'];
            $memberinfo_array['Mailing_State'] = $hrajson_data['data'][0]['q'][0]['mstate'];
            $memberinfo_array['Mailing_Zip_Code'] = $hrajson_data['data'][0]['q'][0]['mzip'];
            $memberinfo_array['Member_Gender'] = $gender;
            $memberinfo_array['Member_Primary_Phone_Number'] = $hrajson_data['data'][0]['q'][0]['pno'];
            $memberinfo_array['Member_Alternate_Phone_Number'] = $hrajson_data['data'][0]['q'][0]['ano'];
            $memberinfo_array['Member_Email_Address'] = $hrajson_data['data'][0]['q'][0]['email'];
            $memberinfo_array['Pcp_Address_1'] = $hrajson_data['data'][0]['q'][0]['pcpadd'];
            $memberinfo_array['Pcp_City'] = $hrajson_data['data'][0]['q'][0]['pcpcity'];
            $memberinfo_array['PCP_Fax_Number'] = $hrajson_data['data'][0]['q'][0]['pcpfaxno'];
            $memberinfo_array['Office_Name'] = $hrajson_data['data'][0]['q'][0]['pcpname'];
            $memberinfo_array['Pcp_Zip'] = $hrajson_data['data'][0]['q'][0]['pcpzip'];
            $memberinfo_array['PCP_Phone'] = $hrajson_data['data'][0]['q'][0]['ppno'];
            //suresh

            $memberinfo_obj = json_encode($memberinfo_array);
            $updatememberinfo = "update HRA_member_" . $clientId . '_' . $year . " set memberinfo='$memberinfo_obj'  where member_id ='$req_id'";
            $updatedmemberinforespResult = mysqli_query($conn, $updatememberinfo);

            if ($hraStatus == "1" || $hraStatus == "0" || $hraStatus == null) {
                $HraStatusresp = 1;
            } else {
                $arraData = json_decode($hraStatus, true);
                $HraStatusresp = $arraData['hraStatus'];
            }

            $db_status = "not updated";
            if ($user_type == "nurse") {
                $staticStatus = '{"hraStatus": 2, "subStatus": "", "cancelStatus": "","cancelText": ""}';
                if ($HraStatusresp == 1 || $HraStatusresp == 0 || $HraStatusresp == null) {
                    $hra_status = 2;
                    $resultData = $this->addHraStatusHistory($clientId, $year, $req_id, $hra_status, $hra_username);
                    $result_success = $resultData['success'];
                    $hra_history_updated = $resultData['updatedJsonHistory'];

                    $updateInprogressStatus = "";
//echo "hii";echo $result_success;die;
                    if ($result_success) {
                        $updateInprogressStatus = "update HRA_member_" . $clientId . '_' . $year . " set hraStatusHistory='$hra_history_updated' , hraStatus='$staticStatus' where member_id ='$req_id'";
                    } else {
                        $updateInprogressStatus = "update HRA_member_" . $clientId . '_' . $year . " set hraStatus='$staticStatus' where member_id ='$req_id'";
                    }

                    try {
                        $updateInprogressStatusResult = mysqli_query($conn, $updateInprogressStatus);
                        $db_status = "updated";
                    } catch (Exception $e) {
                        $error = $e->getMessage();
                    }
                } else {
                    $db_status = "not updated.already hra status created";
                }
            } else {
                $db_status = "not updated.invalid user type";
            }

            //START - hra json file changes detection utility
            $hra_file_change = new HraFileChangesUtility;
            $member_id = $req_id;
            $hra_json_content = $hrajson_dataa;
            $hra_file_change->onHraFileUpdatedHistory($clientId, $year, $member_id, $hra_json_content);
            //end of hra file change

            $fileepath = '../hrajsondata/HRA_member_' . $clientId . '/' . $year . '/' . $req_id . '/' . $req_id . '.json';
            $statusjson = file_put_contents($fileepath, $hrajson_dataa);
            $permit = FileIOUtility::HRA_JSON_FILE_PERMISISON;
            chmod($fileepath, $permit);
            if ($statusjson != 0) {
                $response = new stdClass();
                $response->status = 'updated';
                $response->db_status = $db_status;
                $response->signature = $signature;
                $response = json_encode($response);
                echo $response;

            } else {
                $response = new stdClass();
                $response->status = 'notupdated';
                $response->db_status = $db_status;
                $response->signature = $signature;
                $response = json_encode($response);
                echo $response;
            }
        } else {
            $response = new stdClass();
            $response->status = "recordnotfound";
//            $response->memid = $memberId;
            $response->memid = $req_id;
            $response->signature = $signature;
            $response = json_encode($response);
            echo $response;
        }
    }

    public function hraSave($clientId, $year, $req_id)
    {
        include("../db.php");

        $signature = $this->savingSignatureData($clientId, $year, $req_id);
        $addendumSignature = $this->savingAddendumSignatureData($clientId, $year, $req_id);
        $timeExamFinishedDate = $this->savingTimeExamFinished($clientId, $year, $req_id);
        $update_hradata = "select * from HRA_member_" . $clientId . '_' . $year . " where member_id ='$req_id'";
        $updatehradataresult = mysqli_query($conn, $update_hradata);
        $hrajson_data = $GLOBALS['inputData']['data'];
        $latestlobvalue = $hrajson_data['data'][0]['q'][0]['lob'];
        $latestpcpname = $hrajson_data['data'][0]['q'][0]['pphy'];
        $latestDobValue = $hrajson_data['data'][0]['q'][0]['dob'];
//        $latestDobValue = $hrajson_data['data'][0]['q'][0]['email'];
        if ($hrajson_data['data'][3]['t'] == "Screenings Needed") {
            $latestMicroAlbumInValue = $hrajson_data['data'][3]['q'][0]['a']['indx'][0];
            $latestFobtValue = $hrajson_data['data'][3]['q'][1]['a']['indx'][0];
            $latestHba1cInValue = $hrajson_data['data'][3]['q'][2]['a']['indx'][0];
            $latestLdlValue = $hrajson_data['data'][3]['q'][3]['a']['indx'][0];
            $latestDigitalRetinalExamValue = $hrajson_data['data'][3]['q'][4]['a']['indx'][0];
            $latestDexaValue = $hrajson_data['data'][3]['q'][5]['a']['indx'][0];
            $latestPadValue = $hrajson_data['data'][3]['q'][6]['a']['indx'][0];
        } elseif ($hrajson_data['data'][13]['t'] == "Screenings Needed") {
            $latestMicroAlbumInValue = $hrajson_data['data'][13]['q'][0]['a']['indx'][0];
            $latestFobtValue = $hrajson_data['data'][13]['q'][1]['a']['indx'][0];
            $latestHba1cInValue = $hrajson_data['data'][13]['q'][2]['a']['indx'][0];
            $latestLdlValue = $hrajson_data['data'][13]['q'][3]['a']['indx'][0];
            $latestDigitalRetinalExamValue = $hrajson_data['data'][13]['q'][4]['a']['indx'][0];
            $latestDexaValue = $hrajson_data['data'][13]['q'][5]['a']['indx'][0];
            $latestPadValue = $hrajson_data['data'][13]['q'][6]['a']['indx'][0];
        }

        $hra_username = $GLOBALS['input']->{'hraUsername'};
        $user_type = $GLOBALS['input']->{'userType'};
        $hrajson_dataa = json_encode($hrajson_data);
        if (mysqli_num_rows($updatehradataresult) == 1) {
            $allhramember_row = mysqli_fetch_array($updatehradataresult, MYSQLI_ASSOC);

            $hraStatus = $allhramember_row['hraStatus'];
            $memberinfo = $allhramember_row['memberinfo'];
            $memberinfo_array = json_decode($memberinfo, true);
            $memberinfo_array['LOB'] = $latestlobvalue;
            $memberinfo_array['Date_Of_Birth'] = $latestDobValue;
            $memberinfo_array['Pcp_Name'] = $latestpcpname;
            $memberinfo_array['MICROALBUMIN'] = $latestMicroAlbumInValue == 1 ? 'Y' : 'N';
            $memberinfo_array['FOBT'] = $latestFobtValue == 1 ? 'Y' : 'N';
            $memberinfo_array['HBA1C'] = $latestHba1cInValue == 1 ? 'Y' : 'N';
            $memberinfo_array['LDL'] = $latestLdlValue == 1 ? 'Y' : 'N';
            $memberinfo_array['DIGITAL_RETINAL_EXAM'] = $latestDigitalRetinalExamValue == 1 ? 'Y' : 'N';
            $memberinfo_array['DEXA'] = $latestDexaValue == 1 ? 'Y' : 'N';
            $memberinfo_array['PAD'] = $latestPadValue == 1 ? 'Y' : 'N';



			//suresh  To update demographic data in member_info column
				$memberinfo_array['Aligned'] = $hrajson_data['data'][0]['q'][0]['aligned'];
				if($memberinfo_array['Member_Identification_Number']=='' && $GLOBALS['inputData']['id']!=''){
				    $memberinfo_array['Member_Identification_Number'] = $GLOBALS['inputData']['id'];
				}
				// $memberinfo_array['Member_Identification_Number'] = $hrajson_data['data'][0]['q'][0]['insh'];

				if($hrajson_data['data'][0]['q'][0]['gend']=='0'){
					$gender='M';
				}else if($hrajson_data['data'][0]['q'][0]['gend']=='1'){
					$gender='F';
				} 

				$memberinfo_array['Member_Region'] = $hrajson_data['data'][0]['q'][0]['region'];
				$memberinfo_array['Plan'] = $hrajson_data['data'][0]['q'][0]['plan'];
				$memberinfo_array['Program'] = $hrajson_data['data'][0]['q'][0]['program'];
				$memberinfo_array['Date_Of_Birth'] = $hrajson_data['data'][0]['q'][0]['dob'];
				$memberinfo_array['Member_Address1'] = $hrajson_data['data'][0]['q'][0]['add'];
				$memberinfo_array['Member_Address2'] = $hrajson_data['data'][0]['q'][0]['add2'];
				$memberinfo_array['Member_Address3'] = $hrajson_data['data'][0]['q'][0]['add3'];
				$memberinfo_array['Member_City'] = $hrajson_data['data'][0]['q'][0]['city'];
				$memberinfo_array['Member_State'] = $hrajson_data['data'][0]['q'][0]['state'];
				$memberinfo_array['Member_Zip_Code'] = $hrajson_data['data'][0]['q'][0]['zip'];		
				$memberinfo_array['Mailing_Address1'] = $hrajson_data['data'][0]['q'][0]['madd1'];
				$memberinfo_array['Mailing_Address2'] = $hrajson_data['data'][0]['q'][0]['madd2'];
				$memberinfo_array['Mailing_City'] = $hrajson_data['data'][0]['q'][0]['mcity'];
				$memberinfo_array['Mailing_State'] = $hrajson_data['data'][0]['q'][0]['mstate'];
				$memberinfo_array['Mailing_Zip_Code'] = $hrajson_data['data'][0]['q'][0]['mzip'];
				$memberinfo_array['Member_Gender'] = $gender;
				$memberinfo_array['Member_Primary_Phone_Number'] = $hrajson_data['data'][0]['q'][0]['pno'];
				$memberinfo_array['Member_Alternate_Phone_Number'] = $hrajson_data['data'][0]['q'][0]['ano'];
				$memberinfo_array['Member_Email_Address'] = $hrajson_data['data'][0]['q'][0]['email'];
				$memberinfo_array['Pcp_Address_1'] = $hrajson_data['data'][0]['q'][0]['pcpadd'];
				$memberinfo_array['Pcp_City'] = $hrajson_data['data'][0]['q'][0]['pcpcity'];
				$memberinfo_array['PCP_Fax_Number'] = $hrajson_data['data'][0]['q'][0]['pcpfaxno'];
				$memberinfo_array['Office_Name'] = $hrajson_data['data'][0]['q'][0]['pcpname'];
				$memberinfo_array['Pcp_Zip'] = $hrajson_data['data'][0]['q'][0]['pcpzip'];
				$memberinfo_array['PCP_Phone'] = $hrajson_data['data'][0]['q'][0]['ppno'];
			//suresh

            $memberinfo_obj = json_encode($memberinfo_array);
            $updatememberinfo = "update HRA_member_" . $clientId . '_' . $year . " set memberinfo='$memberinfo_obj'  where member_id ='$req_id'";
            $updatedmemberinforespResult = mysqli_query($conn, $updatememberinfo);

            if ($hraStatus == "1" || $hraStatus == "0" || $hraStatus == null) {
                $HraStatusresp = 1;
            } else {
                $arraData = json_decode($hraStatus, true);
                $HraStatusresp = $arraData['hraStatus'];
            }

            $db_status = "not updated";
            if ($user_type == "nurse") {
                $staticStatus = '{"hraStatus": 2, "subStatus": "", "cancelStatus": "","cancelText": ""}';
                if ($HraStatusresp == 1 || $HraStatusresp == 0 || $HraStatusresp == null) {
                    $hra_status = 2;
                    $resultData = $this->addHraStatusHistory($clientId, $year, $req_id, $hra_status, $hra_username);
                    $result_success = $resultData['success'];
                    $hra_history_updated = $resultData['updatedJsonHistory'];

                    $updateInprogressStatus = "";
//echo "hii";echo $result_success;die;
                    if ($result_success) {
                        $updateInprogressStatus = "update HRA_member_" . $clientId . '_' . $year . " set hraStatusHistory='$hra_history_updated' , hraStatus='$staticStatus' where member_id ='$req_id'";
                    } else {
                        $updateInprogressStatus = "update HRA_member_" . $clientId . '_' . $year . " set hraStatus='$staticStatus' where member_id ='$req_id'";
                    }

                    try {
                        $updateInprogressStatusResult = mysqli_query($conn, $updateInprogressStatus);
                        $db_status = "updated";
                    } catch (Exception $e) {
                        $error = $e->getMessage();
                    }
                } else {
                    $db_status = "not updated.already hra status created";
                }
            } else {
                $db_status = "not updated.invalid user type";
            }

            //START - hra json file changes detection utility
            $hra_file_change = new HraFileChangesUtility;
            $member_id = $req_id;
            $hra_json_content = $hrajson_dataa;
            $hra_file_change->onHraFileUpdatedHistory($clientId, $year, $member_id, $hra_json_content);
            //end of hra file change

            $fileepath = '../hrajsondata/HRA_member_' . $clientId . '/' . $year . '/' . $req_id . '/' . $req_id . '.json';
            $statusjson = file_put_contents($fileepath, $hrajson_dataa);
            $permit = FileIOUtility::HRA_JSON_FILE_PERMISISON;
            chmod($fileepath, $permit);
            if ($statusjson != 0) {
                $response = new stdClass();
                $response->status = 'updated';
                $response->db_status = $db_status;
                $response->signature = $signature;
                $response->addendumSignature = $addendumSignature;
                $response->examFinishDate = $timeExamFinishedDate;
                $response = json_encode($response);
                echo $response;

            } else {
                $response = new stdClass();
                $response->status = 'notupdated';
                $response->db_status = $db_status;
                $response->signature = $signature;
                $response->addendumSignature = $addendumSignature;
                $response->examFinishDate = $timeExamFinishedDate;
                $response = json_encode($response);
                echo $response;
            }
        } else {
            $response = new stdClass();
            $response->status = "recordnotfound";
//            $response->memid = $memberId;
            $response->memid = $req_id;
            $response->signature = $signature;
            $response->addendumSignature = $addendumSignature;
            $response->examFinishDate = $timeExamFinishedDate;
            $response = json_encode($response);
            echo $response;
        }
    }

    public function hraSaveData($clientId, $year, $req_id)
    {
        include("../db.php");

        $signature = $this->savingSignatureData($clientId, $year, $req_id);
        $timeExamFinishedDate = $this->savingTimeExamFinished($clientId, $year, $req_id);
        $update_hradata = "select * from HRA_member_" . $clientId . '_' . $year . " where member_id ='$req_id'";
        $updatehradataresult = mysqli_query($conn, $update_hradata);
        $hrajson_data = $GLOBALS['inputData']['data'];
//print_r($hrajson_data);die;
        $latestlobvalue = $hrajson_data['data'][0]['q'][0]['lob'];
        $latestpcpname = $hrajson_data['data'][0]['q'][0]['pphy'];
        $latestDobValue = $hrajson_data['data'][0]['q'][0]['dob'];
        if ($hrajson_data['data'][3]['t'] == "Screenings Needed") {
            $latestMicroAlbumInValue = $hrajson_data['data'][3]['q'][0]['a']['indx'][0];
            $latestFobtValue = $hrajson_data['data'][3]['q'][1]['a']['indx'][0];
            $latestHba1cInValue = $hrajson_data['data'][3]['q'][2]['a']['indx'][0];
            $latestLdlValue = $hrajson_data['data'][3]['q'][3]['a']['indx'][0];
            $latestDigitalRetinalExamValue = $hrajson_data['data'][3]['q'][4]['a']['indx'][0];
            $latestDexaValue = $hrajson_data['data'][3]['q'][5]['a']['indx'][0];
            $latestPadValue = $hrajson_data['data'][3]['q'][6]['a']['indx'][0];
        } elseif ($hrajson_data['data'][13]['t'] == "Screenings Needed") {
            $latestMicroAlbumInValue = $hrajson_data['data'][13]['q'][0]['a']['indx'][0];
            $latestFobtValue = $hrajson_data['data'][13]['q'][1]['a']['indx'][0];
            $latestHba1cInValue = $hrajson_data['data'][13]['q'][2]['a']['indx'][0];
            $latestLdlValue = $hrajson_data['data'][13]['q'][3]['a']['indx'][0];
            $latestDigitalRetinalExamValue = $hrajson_data['data'][13]['q'][4]['a']['indx'][0];
            $latestDexaValue = $hrajson_data['data'][13]['q'][5]['a']['indx'][0];
            $latestPadValue = $hrajson_data['data'][13]['q'][6]['a']['indx'][0];
        }

        $hra_username = $GLOBALS['input']->{'hraUsername'};
        $user_type = $GLOBALS['input']->{'userType'};
        $hrajson_dataa = json_encode($hrajson_data);
//        print_r(1111);exit();
        if (mysqli_num_rows($updatehradataresult) == 1) {
            $allhramember_row = mysqli_fetch_array($updatehradataresult, MYSQLI_ASSOC);

            $hraStatus = $allhramember_row['hraStatus'];
            $memberinfo = $allhramember_row['memberinfo'];
            $memberinfo_array = json_decode($memberinfo, true);
            $memberinfo_array['LOB'] = $latestlobvalue;
            $memberinfo_array['Date_Of_Birth'] = $latestDobValue;
            $memberinfo_array['Pcp_Name'] = $latestpcpname;
            $memberinfo_array['MICROALBUMIN'] = $latestMicroAlbumInValue == 1 ? 'Y' : 'N';
            $memberinfo_array['FOBT'] = $latestFobtValue == 1 ? 'Y' : 'N';
            $memberinfo_array['HBA1C'] = $latestHba1cInValue == 1 ? 'Y' : 'N';
            $memberinfo_array['LDL'] = $latestLdlValue == 1 ? 'Y' : 'N';
            $memberinfo_array['DIGITAL_RETINAL_EXAM'] = $latestDigitalRetinalExamValue == 1 ? 'Y' : 'N';
            $memberinfo_array['DEXA'] = $latestDexaValue == 1 ? 'Y' : 'N';
            $memberinfo_array['PAD'] = $latestPadValue == 1 ? 'Y' : 'N';
            $memberinfo_obj = json_encode($memberinfo_array);
            $updatememberinfo = "update HRA_member_" . $clientId . '_' . $year . " set memberinfo='$memberinfo_obj'  where member_id ='$req_id'";
            $updatedmemberinforespResult = mysqli_query($conn, $updatememberinfo);
            if ($hraStatus == "1" || $hraStatus == "0" || $hraStatus == null) {
                $HraStatusresp = 1;
            } else {
                $arraData = json_decode($hraStatus, true);
                $HraStatusresp = $arraData['hraStatus'];
            }

            $db_status = "not updated";
            if ($user_type == "nurse") {
                $staticStatus = '{"hraStatus": 2, "subStatus": "", "cancelStatus": "","cancelText": ""}';
                if ($HraStatusresp == 1 || $HraStatusresp == 0 || $HraStatusresp == null) {
                    $hra_status = 2;
                    $resultData = $this->addHraStatusHistory($clientId, $year, $req_id, $hra_status, $hra_username);
                    $result_success = $resultData['success'];
                    $hra_history_updated = $resultData['updatedJsonHistory'];

                    $updateInprogressStatus = "";
                    if ($result_success) {
                        $updateInprogressStatus = "update HRA_member_" . $clientId . '_' . $year . " set hraStatusHistory='$hra_history_updated' , hraStatus='$staticStatus' where member_id ='$req_id'";
                    } else {
                        $updateInprogressStatus = "update HRA_member_" . $clientId . '_' . $year . " set hraStatus='$staticStatus' where member_id ='$req_id'";
                    }

                    try {
                        $updateInprogressStatusResult = mysqli_query($conn, $updateInprogressStatus);
                        $db_status = "updated";
                    } catch (Exception $e) {
                        $error = $e->getMessage();
                    }
                } else {
                    $db_status = "not updated.already hra status created";
                }
            } else {
                $db_status = "not updated.invalid user type";
            }

            //START - hra json file changes detection utility
            $hra_file_change = new HraFileChangesUtility;
            $member_id = $req_id;
            $hra_json_content = $hrajson_dataa;
            $hra_file_change->onHraFileUpdatedHistory($clientId, $year, $member_id, $hra_json_content);
            //end of hra file change

            $fileepath = '../hrajsondata/HRA_member_' . $clientId . '/' . $year . '/' . $req_id . '/' . $req_id . '.json';
            $statusjson = file_put_contents($fileepath, $hrajson_dataa);
            $permit = FileIOUtility::HRA_JSON_FILE_PERMISISON;
            chmod($fileepath, $permit);
            if ($statusjson != 0) {
                $response = new stdClass();
                $response->status = 'updated';
                $response->db_status = $db_status;
                $response->signature = $signature;
                $response->examFinishDate = $timeExamFinishedDate;
                $response = json_encode($response);
                return $response;

            } else {
                $response = new stdClass();
                $response->status = 'notupdated';
                $response->db_status = $db_status;
                $response->signature = $signature;
                $response->examFinishDate = $timeExamFinishedDate;
                $response = json_encode($response);
                return $response;
            }
        } else {
            $response = new stdClass();
            $response->status = "recordnotfound";
//            $response->memid = $memberId;
            $response->memid = $req_id;
            $response->signature = $signature;
            $response->examFinishDate = $timeExamFinishedDate;
            $response = json_encode($response);
            return $response;
        }
    }

    public function savingSignature($clientId, $year, $memberId)
    {
        include("../db.php");
        $signatureData = $GLOBALS['inputData']['data'];
        $jsonData = json_encode($signatureData);
        $updateSqlNurseSignature = "update HRA_member_" . $clientId . '_' . $year . " SET `clinician_signature` = '$jsonData' where member_id='$memberId'";
        try {
            $updated_result = mysqli_query($conn, $updateSqlNurseSignature);
            $updated_resp = mysqli_affected_rows($conn);
            if ($updated_resp) {
                $response = new stdClass();
                $response->status = "updated";
                $response = json_encode($response);
                echo $response;
            } else {
                $response = new stdClass();
                $response->status = "notupdated";
                $response = json_encode($response);
                echo $response;
            }
        } catch (Exception $e) {
            $error = $e->getMessage();
            echo $error;
        }
    }

    public function savingSignatureData($clientId, $year, $memberId)
    {
        include("../db.php");
        $signatureData = $GLOBALS['inputData']['signatureData'];
        $jsonData = json_encode($signatureData);
        $updateSqlNurseSignature = "update HRA_member_" . $clientId . '_' . $year . " SET `clinician_signature` = '$jsonData' where member_id='$memberId'";
        try {
            $updated_result = mysqli_query($conn, $updateSqlNurseSignature);
            $updated_resp = mysqli_affected_rows($conn);
            $response = $updated_resp ? "updated" : "notupdated";
        } catch (Exception $e) {
            $error = $e->getMessage();
            $response = $error;
        }
        return $response;
    }

    public function savingAddendumSignatureData($clientId, $year, $memberId)
    {
        include("../db.php");
        $addendumSignatureData = $GLOBALS['inputData']['addendumSignatureData'];
        $addendumJsonData = json_encode($addendumSignatureData);
        if((isset($addendumJsonData)) && (!empty($addendumJsonData)) && ($addendumJsonData !=null) && ($addendumJsonData !='null')) {
        $updateSqlAddendumSignature = "update HRA_member_" . $clientId . '_' . $year . " SET `addendum_clinician_signature` = '$addendumJsonData' where member_id='$memberId'";
        try {
            $updated_result = mysqli_query($conn, $updateSqlAddendumSignature);
            $updated_addendum_resp = mysqli_affected_rows($conn);
            $response = $updated_addendum_resp ? "updated" : "notupdated";
        } catch (Exception $e) {
            $error = $e->getMessage();
            $response = $error;
        }
        } else {
            $response = "notupdated";
        }
        return $response;
    }

    public function savingTimeExamFinished($clientId, $year, $memberId)
    {
        include("../db.php");
        $timeExamFinished = $GLOBALS['inputData']['examFinished'];
        if((isset($timeExamFinished)) && (!empty($timeExamFinished)) && ($timeExamFinished !=null) && ($timeExamFinished !='null')) {
//            $jsonData = json_encode($timeExamFinished);
            $updateSqlNurseSignature = "update HRA_member_" . $clientId . '_' . $year . " SET `exam_finished_date` = '$timeExamFinished' where member_id='$memberId'";
            try {
                $updated_result = mysqli_query($conn, $updateSqlNurseSignature);
                $updated_resp = mysqli_affected_rows($conn);
                $response = $updated_resp ? "updated" : "notupdated";
            } catch (Exception $e) {
                $error = $e->getMessage();
                $response = $error;
            }
        } else {
            $response = "notupdated";
        }
        return $response;
    }

    /*
            NAME 		: offlineHraSave
            DETAILS 	: offline hra save functionality to update hra sttaus and hra json file
            PARAMETERS 	: client id,year,member id,nurse user name,hra status,sub status,cancel status,cancel text
            RETURN 		: true if history and hra saved else false
        */
		public function offlineHraSave($client_id,$year,$member_id)
		{
			include("../db.php");

			$hra_file_json_data = $GLOBALS['inputData']['data'];
			$hra_status_array = $GLOBALS['inputData']['hraStatus'];

			$hra_username =  $GLOBALS['inputData']['hraUsername'];
			$user_type =  $GLOBALS['inputData']['userType'];
			$visit_type =  $GLOBALS['inputData']['visitType'];
			$evalution_date =  $GLOBALS['inputData']['evaluationDate'];  //by Suresh for evalutiondate update

			$responseHraStatus = "not updated";
			
			//is member available 
			$is_member = DataBaseUtility::isMemberAvailable($client_id,$year,$member_id);
			if($is_member)
			{
				if($user_type=="nurse")
				{

					if(array_key_exists('hraStatus',$hra_status_array))
					{
						$hra_status = $hra_status_array['hraStatus'];
						$responseResult = $this->addHraStatusHistory($client_id,$year,$member_id,$hra_status,$hra_username);
						$result_success = $responseResult['success'];
						$hra_history_updated = $responseResult['updatedJsonHistory'];

						if($result_success)
						{
							$column_name_list =['hraStatusHistory'];
							$column_value_list=[$hra_history_updated];
							DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
							$db_status = "updated";
						}

						if(DataBaseUtility::updateHraStatus($client_id,$year,$member_id,$hra_status))
						{
							MemberUtility::OnApiEvent($client_id,$year,$member_id,MemberUtility::API_HRA_STATUS,true,$hra_status_array);
							$responseHraStatus="updated";
						}
					}

					DataBaseUtility::updateVisitType($client_id,$year,$member_id,$visit_type);
					DataBaseUtility::updateEvalutionDate($client_id,$year,$member_id,$evalution_date); //by Suresh for evalutiondate update
				}
				else
				{
					$db_status = "not updated.invalid user type";
				}

				//START - hra json file changes detection utility
					$hra_file_change = new HraFileChangesUtility;
					$hra_json_content = json_encode($hra_file_json_data);
					$hra_file_change->onHraFileUpdatedHistory($client_id,$year,$member_id,$hra_json_content);
				//end of hra file change

				$member_json_file_path = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
				$file_updated_status = file_put_contents($member_json_file_path,$hra_json_content);
				$permit = FileIOUtility::HRA_JSON_FILE_PERMISISON;
				chmod($member_json_file_path, $permit);
				if($file_updated_status != 0)
				{
					$response = new stdClass();
						$response->status = 'updated';
						$response->historyStatus = $db_status;
						$response->hraStatus=$responseHraStatus;
						$response = json_encode($response);
					echo $response;
				}
				else
				{
					$response = new stdClass();
						$response->status = 'notupdated';
						$response->historyStatus = $db_status;
						$response->hraStatus=$responseHraStatus;
						$response = json_encode($response);
					echo $response;
				}
			}
			else
			{
				$response = new stdClass();
					$response->status = "recordnotfound";
					$response->memid = $member_id;
					$response = json_encode($response);
				echo $response;
			}
		}
	
		public function totalMember($clientId,$year)
		{
			include("../db.php");
			$total_count = "select * from HRA_member_".$clientId.'_'.$year;
			try 
			{
				$allmemberinfo_result=mysqli_query($conn,$total_count);
				$total_cnt = mysqli_num_rows($allmemberinfo_result);
				$response = new stdClass();
				$response->count = $total_cnt;
				$response = json_encode($response);
				echo $response; 
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				echo $error;
			}
		}


		public function scheduleDateCalllog($clientId,$year,$memberId,$scheduleDate)
		{
			
				include("../db.php");
				$staticStatus =	'{"hraStatus": 1, "subStatus": "", "cancelStatus": "","cancelText": ""}';
				$hra_username = $GLOBALS['input']->{'hraUsername'};

//if($GLOBALS['input']->{'id'} == '123456789'){

//	ReportStatus::updateReportStatusByEnum($clientId,$year,$memberId,ReportStatus::SCHEDULED);
	
//}

			//	MemberUtility::OnHraStatusChanged($clientId,$year,$memberId,$staticStatus);
				//add status history
				$resultData = $this->addHraStatusHistory($clientId,$year,$memberId,1,$hra_username);
				$result_success = $resultData['success'];
				$hra_history_updated = $resultData['updatedJsonHistory'];

				$update_scheduledate=null;
				if($result_success)
				{
					$update_scheduledate = "UPDATE HRA_member_".$clientId.'_'.$year." SET hraStatusHistory='$hra_history_updated',`scheduleDate` = '$scheduleDate', hraStatus = '$staticStatus',`availForSchedule`= 0 WHERE `member_id` = '$memberId'";
				}
				else
				{
					$update_scheduledate = "UPDATE HRA_member_".$clientId.'_'.$year." SET `scheduleDate` = '$scheduleDate', hraStatus = '$staticStatus' , `availForSchedule`= 0 WHERE `member_id` = '$memberId'";
				}

				try
				{
					$updatedschdeuleresult=mysqli_query($conn,$update_scheduledate);
					$updated_resp = mysqli_affected_rows($conn);
					if($updated_resp)
					{
						$response = new stdClass();
						$response->status = "updated";
						//scheduler hra status updated
						$result_hra_status_result=MemberUtility::OnApiEvent($clientId,$year,$memberId,MemberUtility::API_SCHEDULED_DATE,true,null);
						$response->schedulerHraStatus = $result_hra_status_result;

						$response = json_encode($response);
						echo $response;
					}
					else
					{
						$response = new stdClass();
						$response->status = "notupdated";
						$response = json_encode($response);
						echo $response;
					}
					
				}
				catch(Exception $e)
				{
					$error = $e->getMessage();
					$response = new stdClass();
					$response->status = 'notupdated';
					$response = json_encode($response);
					echo $response; 
				}

		}

		public function scheduleDate($clientId,$year,$memberId,$scheduleDate)
		{

				include("../db.php");

				$staticStatus =	'{"hraStatus": 1, "subStatus": "", "cancelStatus": "","cancelText": ""}';
				$hra_username = $GLOBALS['input']->{'hraUsername'};
//if($GLOBALS['input']->{'id'} == '123456789'){

//	ReportStatus::updateReportStatusByEnum($clientId,$year,$memberId,ReportStatus::SCHEDULED);
	
//}

				//add status history
				$resultData = $this->addHraStatusHistory($clientId,$year,$memberId,1,$hra_username);
				$result_success = $resultData['success'];
				$hra_history_updated = $resultData['updatedJsonHistory'];

				$update_scheduledate=null;
				if($result_success)
				{
					$update_scheduledate = "UPDATE HRA_member_".$clientId.'_'.$year." SET hraStatusHistory='$hra_history_updated',`scheduleDate` = '$scheduleDate', hraStatus = '$staticStatus',`availForSchedule`= 0 WHERE `member_id` = '$memberId'";
				}
				else
				{
					$update_scheduledate = "UPDATE HRA_member_".$clientId.'_'.$year." SET `scheduleDate` = '$scheduleDate', hraStatus = '$staticStatus' , `availForSchedule`= 0 WHERE `member_id` = '$memberId'";
				}

				try
				{
					$updatedschdeuleresult=mysqli_query($conn,$update_scheduledate);
					$updated_resp = mysqli_affected_rows($conn);
					if($updated_resp)
					{
						$response = new stdClass();
						$response->status = "updated";
						//scheduler hra status updated
						$result_hra_status_result=MemberUtility::OnApiEvent($clientId,$year,$memberId,MemberUtility::API_SCHEDULED_DATE,true,null);
						ReportStatus::updateReportStatusByEnum($clientId,$year,$memberId,ReportStatus::SCHEDULED);
						ReportStatus::OnAddReportStatusHistory($clientId,$year,$memberId,ReportStatus::SCHEDULED);
						$response->schedulerHraStatus = $result_hra_status_result;

						$response = json_encode($response);
						echo $response;
					}
					else
					{
						$response = new stdClass();
						$response->status = "notupdated";
						$response = json_encode($response);
						echo $response;
					}
					
				}
				catch(Exception $e)
				{
					$error = $e->getMessage();
					$response = new stdClass();
					$response->status = 'notupdated';
					$response = json_encode($response);
					echo $response; 
				}

		}
		
		public function termDate($clientId,$year,$memberId)
		{
			
			$termDate = $GLOBALS['inputData']['data']['termDate'];
			include("../db.php");
			$update_scheduledatee = "UPDATE HRA_member_".$clientId.'_'.$year." SET `termDate` = '$termDate'  WHERE `member_id` = '$memberId'";
			$updatedschdeuleresult=mysqli_query($conn,$update_scheduledatee);
			$updated_respp = mysqli_affected_rows($conn);
			//on term date updated
			$term_response_array = MemberUtility::OnTermDateUpdated($clientId,$year,$memberId,$termDate);
			if($updatedschdeuleresult)
			{
				$response = new stdClass();
				$response->status = "updated";
				$response->termResponse = $term_response_array;
				$response = json_encode($response);
				echo $response;
			}
			else
			{
				$response = new stdClass();
				$response->status = "notupdated";
				$response->termResponse = null;
				$response = json_encode($response);
				echo $response;
			}
			
		}

		public function scheduleMember($clientId,$year,$req_nurseid)
		{
			include("../db.php");
			TimeZone::useTimeZone();
			$date = date('Y-m-d');
			$fetch_memberrecords = "select * from HRA_member_".$clientId.'_'.$year." where nurse_id = '$req_nurseid' and DATE(scheduleDate)='$date'";
			try
			{
				$allmemberinfo_result=mysqli_query($conn,$fetch_memberrecords);
				$total_cnt = mysqli_num_rows($allmemberinfo_result);
				if($total_cnt != 0)
				{
					$member_data = null;
					while($allpatientinfo_row=mysqli_fetch_array($allmemberinfo_result,MYSQLI_ASSOC))
					{
						$memberinfo = $allpatientinfo_row['memberinfo'];
						$hra_path = $allpatientinfo_row['hra'];
						$scheduleDate = $allpatientinfo_row['scheduleDate'];
						$EvaluationDate = $allpatientinfo_row['EvaluationDate'];
						$getcontentdata = file_get_contents($hra_path);
						$member_data[]=array("memberinfo"=>$memberinfo,"hrainfo"=>$getcontentdata,"scheduleDate"=>$scheduleDate,"EvaluationDate"=>$EvaluationDate);
					}
					echo $res_result = json_encode($member_data); 
				}
				else
				{
					$response = new stdClass();
					$response->status = 'NoRecords';
					$response = json_encode($response);
					echo $response;
				}
				
			}
			catch(Exception $e)
			{
				$error = $e->getMessage();
				echo $error;
			}
		}

		public function downloadMember($clientId,$year,$arrCount)
		{
			include("../db.php");
			for($arrval=0;$arrval < $arrCount; $arrval++)
			{
				$memberId = $GLOBALS['inputData']['data'][$arrval]['memberId'];
				$clientId = $GLOBALS['inputData']['data'][$arrval]['clientId'];
				$year = $GLOBALS['inputData']['data'][$arrval]['year'];
				
				$get_arraydata = "select * from HRA_member_".$clientId.'_'.$year." where member_id = '$memberId'";
				$get_arraydataall=mysqli_query($conn,$get_arraydata);
				$get_arraydataallrow=mysqli_fetch_array($get_arraydataall,MYSQLI_ASSOC);
				$memberinfo = $get_arraydataallrow['memberinfo']; 
				$scheduleDate = $get_arraydataallrow['scheduleDate']; 
				$EvaluationDate = $get_arraydataallrow['EvaluationDate']; 
				$hraStatus = $get_arraydataallrow['hraStatus'];
				$visitType = $get_arraydataallrow['VisitType'];				
				$versioning = $get_arraydataallrow['versioning']; 
				$clientid = $get_arraydataallrow['clientid']; 
				//$year = $get_arraydataallrow['year']; 
				$hrapath = $get_arraydataallrow['hra'];
				$exploded = explode("/",$hrapath);
				$lastpath=$exploded[6];
				$fifthpath=$exploded[5];
				$fileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$memberId.'/'.$memberId.'.json';
				$getcontentdata = file_get_contents($fileepath);
				$getcontentdata = json_decode($getcontentdata);
				$getcontentdataa = isset($getcontentdata) ? $getcontentdata : '';
				$member_infodata[]=array("memberinfo"=>$memberinfo,"scheduleDate"=>$scheduleDate,"EvaluationDate"=>$EvaluationDate,"hrainfo"=>$getcontentdataa,"hraStatus"=>$hraStatus,"visitType"=>$visitType,"versioning"=>$versioning,"applicationType"=>'production',"clientId"=>$clientid,"year"=>$year);
				
			}
			echo $res_result = json_encode($member_infodata);  
		}

		public function unAssignMember($clientId,$year,$memberIdd)
		{
			 include("../db.php");
			 $update_info = "UPDATE HRA_member_".$clientId.'_'.$year." SET `nurse_id` = '' WHERE `member_id` = '$memberIdd'";
			 try 
			 {
				$updated_resultt=mysqli_query($conn,$update_info);
				$updated_resp = mysqli_affected_rows($conn);
				if($updated_resp)
				{
					$response = new stdClass();
					$response->status = "Removed";
					$response = json_encode($response);
				}
				else
				{
					$response = new stdClass();
					$response->status = "NotRemoved";
					$response = json_encode($response);
				} 
			 }
			 catch(Exception $e)
			 {
				$error = $e->getMessage();
				echo $error; 
			 }

			 echo $response;
			
		}
		
		public function unAssignQa($clientId,$year,$memberIdd)
		{
			include("../db.php");
			$update_info = "UPDATE HRA_member_".$clientId.'_'.$year." SET `qa_id` = '' WHERE `member_id` = '$memberIdd'";
			try 
			{
				 $updated_resultt=mysqli_query($conn,$update_info);
				 $updated_resp = mysqli_affected_rows($conn);
				 if($updated_resp)
				 {
					$response = new stdClass();
					$response->status = "Removed";
					$response = json_encode($response);
				}
				else
				{
					$response = new stdClass();
					$response->status = "NotRemoved";
					$response = json_encode($response);
				 }
				 
			}
			catch(Exception $e)
			{
				$error = $e->getMessage();
				echo $error; 
			}
		    echo $response;
		}
		
		public function unAssignToQa($clientId,$year,$memberIdd)
		{
			include("../db.php");
			//$update_info = "UPDATE HRA_member_".$clientId.'_'.$year." SET qaAssignedStart='',`qa_id` = '' WHERE `member_id` = '$memberIdd'";
			$update_info = "UPDATE HRA_member_".$clientId.'_'.$year." SET `qa_id` = NULL WHERE `member_id` = '$memberIdd'";
			 try 
			 {
				$updated_resultt=mysqli_query($conn,$update_info);
				$updated_resp = mysqli_affected_rows($conn);
				if($updated_resp)
				{
					$response = new stdClass();
					$response->status = "Removed";
					$response = json_encode($response);
				}
				else
				{
					$response = new stdClass();
					$response->status = "NotRemoved";
					$response = json_encode($response);
				 }
				 
			 }
			 catch(Exception $e)
			 {
				$error = $e->getMessage();
				echo $error; 
			 }

			 echo $response;

		}
		
		
		public function unAssignCoder($clientId,$year,$memberIdd)
		{
			include("../db.php");
			$update_info = "UPDATE HRA_member_".$clientId.'_'.$year." SET `coder_id` = '' WHERE `member_id` = '$memberIdd'";
			try
			{
				$updated_resultt=mysqli_query($conn,$update_info);
				$updated_resp = mysqli_affected_rows($conn);
				if($updated_resp)
				{
					$response = new stdClass();
					$response->status = "Removed";
					$response = json_encode($response);
				}
				else
				{
					$response = new stdClass();
					$response->status = "NotRemoved";
					$response = json_encode($response);
				 }
				 
			}
			catch(Exception $e)
			{
				$error = $e->getMessage();
				echo $error; 
			}

			echo $response;
		}

		public function unAssignToCoder($clientId,$year,$memberIdd)
		{
			include("../db.php");
			
			//$update_info = "UPDATE HRA_member_".$clientId.'_'.$year." SET coderAssignedStart='' ,`coder_id` = '' WHERE `member_id` = '$memberIdd'";
$update_info = "UPDATE HRA_member_".$clientId.'_'.$year." SET `coder_id` = NULL WHERE `member_id` = '$memberIdd'";
			try 
			{
				 $updated_resultt=mysqli_query($conn,$update_info);
				 $updated_resp = mysqli_affected_rows($conn);
				 if($updated_resp)
				 {
					$response = new stdClass();
					$response->status = "Removed";
					$response = json_encode($response);
				}
				else
				{
					$response = new stdClass();
					$response->status = "NotRemoved";
					$response = json_encode($response);
				 } 
			}
			catch(Exception $e)
			{
				$error = $e->getMessage();
				echo $error; 
			}

			echo $response;
		}
		public function versioning($clientId,$year,$memID)
		{
			include("../db.php");
			$jsonData = json_encode($GLOBALS['inputData']['data']);			
			
			$updatestatus_info = "UPDATE HRA_member_".$clientId.'_'.$year." SET `versioning` = '$jsonData' WHERE `member_id` = '$memID'";
			try
			{
				$updatedhra_resultt=mysqli_query($conn,$updatestatus_info);
				$updated_statusresp = mysqli_affected_rows($conn);
				if($updated_statusresp)
				{
					$response = new stdClass();
					$response->status = "updated";
					$response = json_encode($response);
					echo $response;
				}
				else
				{
					$response = new stdClass();
					$response->status = "notupdated";
					$response = json_encode($response);
					echo $response;
				}
				
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				echo $error;
			}
			
			
		}
		
		public function visitTypecalllog($clientId,$year,$memID)
		{
//echo "ss1";die;
			include("../db.php");
			$jsonData = $GLOBALS['inputData']['data']['visitType'];
			$updatestatus_info = "UPDATE HRA_member_".$clientId.'_'.$year." SET `VisitType` = '$jsonData' WHERE `member_id` = '$memID'";


			 
			try
			{
				$updatedhra_resultt=mysqli_query($conn,$updatestatus_info);
				$updated_statusresp = mysqli_affected_rows($conn);
				if($updated_statusresp)
				{
					$response = new stdClass();
					$response->status = "updated";
					$response = json_encode($response);


				}
				else
				{
					$response = new stdClass();
					$response->status = "notupdated";
					$response = json_encode($response);
				}
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				echo $error;
			}

			echo $response;
		}

		public function visitType($clientId,$year,$memID)
		{
			//echo "ss";die;
			include("../db.php");
			$jsonData = $GLOBALS['inputData']['data']['visitType'];
			$updatestatus_info = "UPDATE HRA_member_".$clientId.'_'.$year." SET `VisitType` = '$jsonData' WHERE `member_id` = '$memID'";

			$gethrasttus = "select * from HRA_member_".$clientId.'_'.$year." where `member_id` = '$memID'";
			$gethrasttus_resultt=mysqli_query($conn,$gethrasttus);

			$get_dataresultset=mysqli_fetch_array($gethrasttus_resultt,MYSQLI_ASSOC);
			$hraStatusobj = $get_dataresultset['hraStatus']; 
			$hraStatusarray = json_decode($hraStatusobj,true);
			$hraStatus = $hraStatusarray['hraStatus'];


			// echo "d";die;

			try
			{
				$updatedhra_resultt=mysqli_query($conn,$updatestatus_info);
				$updated_statusresp = mysqli_affected_rows($conn);
				if($updated_statusresp)
				{
					$response = new stdClass();
					$response->status = "updated";
					$response = json_encode($response);

					if($jsonData == 'Virtual' && $hraStatus == 19)
					{
						$time=time();
						$history_date_time = date( "Y-m-d",$time )."T".date( "H:i", $time );
						ReportStatus::updateReportStatusByEnum($clientId,$year,$memID,ReportStatus::VIRTUAL_NO_SHOW);
						ReportStatus::OnAddReportStatusHistory($clientId,$year,$memID,ReportStatus::VIRTUAL_NO_SHOW);
						//sleep(3);
						$hra_status=19;
						$cancel_history_response = $this->addCancelHistory($clientId,$year,$memID,$hra_username,
						$hra_status,$hra_sub_status,$hra_cancel_status,
						$hra_cancel_text,$history_date_time);
					}
					else if($jsonData == 'In Person' && $hraStatus == 19)
					{
						//echo "hi";die;
						$time=time();
						$history_date_time = date( "Y-m-d",$time )."T".date( "H:i", $time );
						ReportStatus::updateReportStatusByEnum($clientId,$year,$memID,ReportStatus::F2F_NO_SHOW);
						ReportStatus::OnAddReportStatusHistory($clientId,$year,$memID,ReportStatus::F2F_NO_SHOW);
						//sleep(3);
						$hra_status=19;
						$cancel_history_response = $this->addCancelHistory($clientId,$year,$memID,$hra_username,
						$hra_status,$hra_sub_status,$hra_cancel_status,
						$hra_cancel_text,$history_date_time);
					}else{
						//echo "c";die;
					}
				}
				else
				{
					$response = new stdClass();
					$response->status = "notupdated";
					$response = json_encode($response);
				}
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				echo $error;
			}

			echo $response;
		}
		

		/*
			NAME    : hraStatus
			TYPE    : API Function
			DETAILS : hra status update function in which hra status history and cancel history also updated here.
					  last updated added on 12_01_2021
			RETURN  :
     	*/
		 //hra status last updated added on 03_12_2020
		public function hraStatus($clientId,$year,$memID)
		{
			include("../db.php");
			
			$hra_status_json = $GLOBALS['inputData']['data']['hraStatus'];
			$jsonData = json_encode($hra_status_json);
			$hra_username = $GLOBALS['input']->{'hraUsername'};
		
			$log = "";
			//$log .= "[".date("m-d-Y H:i:s")."] Server Parameters : ".json_encode($_SERVER).PHP_EOL. PHP_EOL;
			$log .= "[".date("m-d-Y H:i:s")."] Client : $clientId". PHP_EOL;
			$log .= "[".date("m-d-Y H:i:s")."] Year : $year". PHP_EOL;
			$log .= "[".date("m-d-Y H:i:s")."] Member ID : $memid". PHP_EOL;
			$log .= "[".date("m-d-Y H:i:s")."] Input Data : ".json_encode($GLOBALS['inputData']). PHP_EOL;

			
			if($hra_status_json)
			{
				//decode json hra status into individual fields
				//{"hraStatus": 2, "subStatus": "", "cancelStatus": "","cancelText": ""}
				$hra_status_elements = $hra_status_json;
				$hra_status = $hra_status_elements['hraStatus'];
				$hra_sub_status = $hra_status_elements['subStatus'];
				$hra_cancel_status = $hra_status_elements['cancelStatus'];
				$hra_cancel_text =  $hra_status_elements['cancelText'];

			}
			
			$resultData = $this->addHraStatusHistory($clientId,$year,$memID,$hra_status,$hra_username);
			$result_success = $resultData['success'];
			$hra_history_updated = $resultData['updatedJsonHistory'];
			$history_date_time = $resultData['date'];

			$updatestatus_info ="";
			if($result_success)
			{
				$updatestatus_info = "UPDATE HRA_member_".$clientId.'_'.$year." SET hraStatusHistory='$hra_history_updated',`hraStatus` = '$jsonData' WHERE `member_id` = '$memID'";
			}
			else
			{
				$updatestatus_info = "UPDATE HRA_member_".$clientId.'_'.$year." SET `hraStatus` = '$jsonData' WHERE `member_id` = '$memID'";
			}

			$response = new stdClass();
			try
			{
				$updatedhra_resultt=mysqli_query($conn,$updatestatus_info);
				$updated_statusresp = mysqli_affected_rows($conn);
				if($updated_statusresp)
				{
					$response->status = "updated";
					//when hra status changed 
					$result_hra_status_result = MemberUtility::OnApiEvent($clientId,$year,$memID,MemberUtility::API_HRA_STATUS,true,$hra_status_elements);
					$response->schedulerHraStatus = $result_hra_status_result;
				}
				else
				{
					$response->status = "notupdated";
				}
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				$response->error = $error;
			}

			//update cancel history for hra status
			switch($hra_status)
			{
				case 3:
				case 4:
				case 5:
				case 19:
					$cancel_history_response = $this->addCancelHistory($clientId,$year,$memID,$hra_username,
													$hra_status,$hra_sub_status,$hra_cancel_status,
													$hra_cancel_text,$history_date_time);
					$response->cancel_status = $cancel_history_response==true?"updated":"not updated";
				break;
			}

			//encode response into json format
			$response = json_encode($response);
			echo $response;
		}

    public function hraStatusData($clientId,$year,$memID)
    {
        include("../db.php");

        $hra_status_json = $GLOBALS['inputData']['hraStatus']['hraStatus'];
        $jsonData = json_encode($hra_status_json);
        $hra_username = $GLOBALS['input']->{'hraUsername'};

        if($hra_status_json)
        {
            //decode json hra status into individual fields
            //{"hraStatus": 2, "subStatus": "", "cancelStatus": "","cancelText": ""}
            $hra_status_elements = $hra_status_json;
            $hra_status = $hra_status_elements['hraStatus'];
            $hra_sub_status = $hra_status_elements['subStatus'];
            $hra_cancel_status = $hra_status_elements['cancelStatus'];
            $hra_cancel_text =  $hra_status_elements['cancelText'];

        }

        $resultData = $this->addHraStatusHistory($clientId,$year,$memID,$hra_status,$hra_username);
        $result_success = $resultData['success'];
        $hra_history_updated = $resultData['updatedJsonHistory'];
        $history_date_time = $resultData['date'];

        $updatestatus_info ="";
        if($result_success)
        {
            $updatestatus_info = "UPDATE HRA_member_".$clientId.'_'.$year." SET hraStatusHistory='$hra_history_updated',`hraStatus` = '$jsonData' WHERE `member_id` = '$memID'";
        }
        else
        {
            $updatestatus_info = "UPDATE HRA_member_".$clientId.'_'.$year." SET `hraStatus` = '$jsonData' WHERE `member_id` = '$memID'";
        }
//print_r(1111);exit();
        $response = new stdClass();
        try
        {
            $updatedhra_resultt=mysqli_query($conn,$updatestatus_info);
            $updated_statusresp = mysqli_affected_rows($conn);
//                print_r($response) ;
//			exit();
            if($updated_statusresp)
            {
                $response->status = "updated";
                //when hra status changed
                $result_hra_status_result = MemberUtility::OnApiEvent($clientId,$year,$memID,MemberUtility::API_HRA_STATUS,true,$hra_status_elements);
                $response->schedulerHraStatus = $result_hra_status_result;
            }
            else
            {
                $response->status = "notupdated";
            }
        }
        catch (Exception $e)
        {
            $error = $e->getMessage();
            $response->error = $error;
        }

        //update cancel history for hra status
        switch($hra_status)
        {
            case 3:
            case 4:
            case 5:
            case 19:
                $cancel_history_response = $this->addCancelHistory($clientId,$year,$memID,$hra_username,
                    $hra_status,$hra_sub_status,$hra_cancel_status,
                    $hra_cancel_text,$history_date_time);
                $response->cancel_status = $cancel_history_response==true?"updated":"not updated";
                break;
        }
//            print_r($response) ;
//			exit();
        //encode response into json format
        $response = json_encode($response);
        return $response;
//			exit();
    }

		public function unScheduleDate($clientId,$year,$memberId)
		{
			include("../db.php");
			$staticStatus =	'{"hraStatus": 0, "subStatus": "", "cancelStatus": "","cancelText": ""}';
			$update_removeunschdeulesql = "UPDATE HRA_member_".$clientId.'_'.$year." SET `scheduleDate` = '', hraStatus = '$staticStatus' , `availForSchedule`= 1 WHERE `member_id` = '$memberId'";
				try 
				{
					
					$updated_resultt=mysqli_query($conn,$update_removeunschdeulesql);
					$updated_schdateresp = mysqli_affected_rows($conn);
					if($updated_schdateresp)
					{
						$response = new stdClass();
						$response->status = "Removed";
						//when schedule date unassigned chage the scheduler call hra status and attempt count equal to zero
						$un_scheduled_result = MemberUtility::OnApiEvent($clientId,$year,$memberId,MemberUtility::API_UNSCHEDULED_DATE,true,null);
						$response->schedulerHraStatus = $un_scheduled_result;
	
						$response = json_encode($response);
					}
					else
					{
						$response = new stdClass();
						$response->status = "NotRemoved";
						$response = json_encode($response);
					}

				}
				catch (Exception $e)
				{
					$error = $e->getMessage();
					echo $error;
				}
				echo $response;
		
		}
		
		public function callLog($clientId,$year,$memid)
		{
			include("../db.php");

			$calllog=$GLOBALS['inputData']['data']['callLog'];
			$comment=[];
			for($i=0;$i<sizeof($calllog);$i++){
				$calllog[$i]['comment']=addslashes($calllog[$i]['comment']);
				$calllog[$i]['comment']=str_replace("\n"," ",$calllog[$i]['comment']);
				$calllog[$i]['comment']=str_replace('\"',"\'",$calllog[$i]['comment']);
				$calllog[$i]['comment']=$calllog[$i]['comment'];
				$comment[]=$calllog[$i];
			}
			$GLOBALS['inputData']['data']['callLog']=$comment;
			
			$jsonData = json_encode($GLOBALS['inputData']['data']);
			$jsonData=str_replace("\\\\","",$jsonData);
			$jsonData=str_replace("'","\'",$jsonData);
			
			$updateSqlNurseStatus="update HRA_member_".$clientId.'_'.$year." SET `scheduler` = '$jsonData' where member_id='$memid'";
			try
			{
				$updated_resultt=mysqli_query($conn,$updateSqlNurseStatus);
				//on call log event called
				$scheduler_request_data = $GLOBALS['inputData'];
				$call_log_response_array = MemberUtility::OnMemberCallLogChanged($clientId,$year,$memid,$scheduler_request_data);

				$callinforesp = $call_log_response_array["report_status"];
				if($callinforesp == null){

					$getinfo = "select reportStatus from HRA_member_".$clientId.'_'.$year." where member_id='$memid'";
					$getinfo_resultt=mysqli_query($conn,$getinfo);
					$getrowdata=mysqli_fetch_array($getinfo_resultt,MYSQLI_ASSOC);
					$reportStatusinfo = $getrowdata['reportStatus']; 
					 $reportstatus_info = json_decode($reportStatusinfo, true);
					 $report_status = $reportstatus_info['text'];
					//$report_status = $reportStatusinfo->{'text'};
				}else{
					$report_status=$call_log_response_array["report_status"];
				}


				$hra_status_array=$call_log_response_array["hra_status"];
				$attempt_count=$call_log_response_array["attempt_count"];
				$disabled_status=$call_log_response_array["disabled_status"];
				//$report_status=$call_log_response_array["report_status"];
				//if call log changed clear the report notes
				$report_notes_cleared=$this->clearReportNotes($clientId,$year,$memid);
				$updated_schdateresp = mysqli_affected_rows($conn);
				if($updated_schdateresp)
				{
					$response = new stdClass();
					$response->status = "Updated";
					$response->hraStatus = $hra_status_array;
					$response->reportStatus = $report_status;
					$response->disabled = $disabled_status;
					$response->attemptCount=$attempt_count;
					
					$response->notes_status=$report_notes_cleared==true?"cleared":"not cleared";
					$response = json_encode($response);
					echo $response;
				}
				else
				{
					$response = new stdClass();
					$response->status = "NotUpdated";
					$response->disabled = false;
					$response->hraStatus = $hra_status_array;
					$response->reportStatus = $report_status;
					$response->attemptCount=$attempt_count;
					$response->notes_status=$report_notes_cleared==true?"cleared":"not cleared";
					$response = json_encode($response);
					echo $response;
				}
				
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				echo $error;
			}
			
		}

		public function changeNurseStatus($nurseId,$adminId,$loginStatus)
		{
			include("../db.php");
			$updateSqlNurseStatus="update userLogin SET `userStatus` = '$loginStatus' where userUniqueno='$nurseId'";
			try
			{
				$updatedlogin_resultt=mysqli_query($conn,$updateSqlNurseStatus);
				$updated_status = mysqli_affected_rows($conn);
				if($updated_status)
				{
					$response = new stdClass();
					$response->status = "updated";
					$response = json_encode($response);
				}
				else
				{
					$response = new stdClass();
					$response->status = "notUpdated";
					$response = json_encode($response);
				}
			}
			catch(Exception $e)
			{
				$error = $e->getMessage();
				echo $error;
			}

			echo $response;
		}
		

public function sendutclettersbymail($year, $clientId, $memm_id)
{
    include ("../db.php");
    $getmeminfo = "select memberinfo,firstname from HRA_member_" . $clientId . '_' . $year . " where member_id = '$memm_id' ";
    $getmeminforesp = mysqli_query($conn, $getmeminfo);
    $getmeminfo_row = mysqli_fetch_array($getmeminforesp, MYSQLI_ASSOC);
    $memberinfo = $getmeminfo_row['memberinfo'];
    $firstname = $getmeminfo_row['firstname'];

    $mem_array = json_decode($memberinfo, true);
    $program = strtoupper($mem_array['Program']);

    if ($program == null || $program == '')
    {

        $getprogramname = "select program from HRA_client where clientid = '$clientId '";
        $getprogramnameresp = mysqli_query($conn, $getprogramname);
        $getprogramresp_row = mysqli_fetch_array($getprogramnameresp, MYSQLI_ASSOC);
        $program = strtoupper($getprogramresp_row['program']);

    }

    $utcpath = '../uploadfiles/utc';
    $isutcpathh = file_exists($utcpath);
    if ($isutcpathh != 1)
    {
        $permitt = FileIOUtility::CLIENT_FOLDER_PERMISSION;
        mkdir($utcpath);
        chmod($utcpath, $permitt);

    }
    $jsonfolderpathh = '../uploadfiles/utc/' . $year;
    $innerfolderpath = file_exists($jsonfolderpathh);
    if ($innerfolderpath != 1)
    {
        $permitt = FileIOUtility::CLIENT_FOLDER_PERMISSION;
        mkdir($jsonfolderpathh);
        chmod($jsonfolderpathh, $permitt);

    }

    $isProgrampath = '../uploadfiles/utc/' . $year . '/' . $program;
    $ispath = file_exists($isProgrampath);
    if ($ispath != 1)
    {
        $permitt = FileIOUtility::CLIENT_FOLDER_PERMISSION;
        mkdir($isProgrampath);
        chmod($isProgrampath, $permitt);

    }
    $file_pointer = '../uploadfiles/utc/' . $year . '/' . $program . '/' . $_FILES["file"]["name"];
    //	$file_pointer = '../uploadfiles/utc/2021/MEDICAID/11000379.pdf';
    $response = new stdClass();
    $isUploadStatus = '';
    if (file_exists($file_pointer) != 1)
    {

        if (move_uploaded_file($_FILES["file"]["tmp_name"], $isProgrampath . '/' . $_FILES["file"]["name"]))
        {
            $response->status = "uploaded";
            include ("../db.php");
            $getUpdatedFiles = "select * from HRA_member_" . $clientId . '_' . $year . " where member_id='$memm_id'";

            $getUpdatedFilesRec = mysqli_query($conn, $getUpdatedFiles);
            $getUpdatedFilesRow = mysqli_fetch_array($getUpdatedFilesRec, MYSQLI_ASSOC);
            $uplodedfiless = $getUpdatedFilesRow['utcfiles'];

            if ($uplodedfiless == '')
            {
                $fName = $_FILES["file"]["name"];

                TimeZone::useTimeZone();
                $curr_time = date('d-m-Y H:i:s');

                $myObj->filename[] = $fName;
                $myObj->dateTime[] = $curr_time;
                $myJSON = json_encode($myObj);

                $updateFileName = "update HRA_member_" . $clientId . '_' . $year . " set utcfiles='" . $myJSON . "' where member_id='$memm_id'";
                $updated_resultt = mysqli_query($conn, $updateFileName);
            }
            else
            {
                $b = $uplodedfiless;
                $jsonstring = json_decode($b, true);

                TimeZone::useTimeZone();
                $curr_time = date('d-m-Y H:i:s');

                array_push($jsonstring['filename'], $_FILES["file"]["name"]);
                array_push($jsonstring['dateTime'], $curr_time);

                $meregedjsonm = json_encode($jsonstring);

                $updateFileName = "update HRA_member_" . $clientId . '_' . $year . " set utcfiles='" . $meregedjsonm . "' where member_id='$memm_id'";
                $updated_resultt = mysqli_query($conn, $updateFileName);
            }

        }
        else
        {
            $response->status = "notuploaded";
        }
    }

    $mailId = 'korra.naik@focussoftek.net';
    $mail_body = '<div style="width:100%;background-color: gainsboro;"> 
                    <div style="margin-left:0px;  margin-top: 0px; height: auto     width: 100%;">Dear  ' . $firstname . ',<br><br>We keep missing you! <br><br>We have been trying to reach you to set up your free in-home health review with a Licensed Nurse Practitioner!
					<br><br>An in-home health review gives you the chance to talk to a Licensed Nurse Practitioner about your health, in the comfort and ease of your own home, at no cost to you <br><br>This visit is not meant to replace the care you get from your doctor. Our goal is to support the work done by you and your doctor to improve your health. Results from the in-home health review will be sent to your doctor
					
					<br><br>Thank You</div></div>';
    $mail_response = Utility::sendMailByAttachment($mailId, 'UTC Letter', $mail_body, $file_pointer);

    $mailresponse = new stdClass();

    $mailresponse->mailStatus = $mail_response["mailStatus"];
    $mailresponse->mailError = $mail_response["error"];
    $mailresponse = json_encode($mailresponse);
    echo $mailresponse;

}




		public function sendalertmail($role,$mailId)
		{
			//echo $role,$mailId;die;
			include("../db.php");
			//$mailId='korra.naik@focussoftek.net';
			
			$getClinicianName = "select * from userLogin where email='$mailId'";
			$getClinicianNamee=mysqli_query($conn,$getClinicianName);
			$getClinicianNameeRow=mysqli_fetch_array($getClinicianNamee,MYSQLI_ASSOC);
			$firstname = $getClinicianNameeRow['firstname']; 
			//$	 ='eswar';
			
			require 'PHPMailer/src/Exception.php';
            require 'PHPMailer/src/PHPMailer.php';
            require 'PHPMailer/src/SMTP.php';
			
			 $mail = new PHPMailer(true);
			try {

                $mail->isSMTP(); // using SMTP protocol                                    
                $mail->Host       = 'smtp.office365.com'; // SMTP host as gmail 
                $mail->SMTPAuth   = true; // enable smtp authentication                            
                $mail->Username   = 'admin@focuscares.com'; // sender gmail host              
                $mail->Password   = 'F0cus@1234'; // sender gmail host password                          
                $mail->SMTPSecure = 'tls'; // for encrypted connection                          
                $mail->Port       = 587; // port for SMTP    
                $mail->setFrom('admin@focuscares.com', "Sender"); // sender's email and name
				//$userEmail='korra.naik@focussoftek.net';
                $mail->addAddress($mailId, "Receiver"); // receiver's email and name
                $mail->Subject = 'Query Form';
                $mail->IsHTML(true);
                $mail->Body = '<div style="width:100%;background-color: gainsboro;"> 
                    <div style="margin-left:0px;  margin-top: 0px; height: auto     width: 100%;">Hi '.$firstname.',<br><br>A query form has been submitted for one of your Health Risk Assessments and your review is needed.<br><br>Please <a href="">login</a> to your dashboard at your earliest convenience to review.<br>Thank You</div></div>';
                
                $mail->send();
                $response         = new stdClass();
                $response->status = 'mailSent';
                $response         = json_encode($response);
                //echo $response;
				
            }
            catch (Exception $e) { // handle error.
               // echo 'Message could not be sent. Mailer Error: ', $mail->ErrorInfo;
				$response         = new stdClass();
                $response->status = 'mailnotSent';
                $response         = json_encode($response);
				echo $response;
            }
			
		}

		public function sendmailalert($role,$mailId)
		{
			
			include("../db.php");

			$getClinicianName = "select * from userLogin where email='$mailId'";
			$getClinicianNamee=mysqli_query($conn,$getClinicianName);
			$getClinicianNameeRow=mysqli_fetch_array($getClinicianNamee,MYSQLI_ASSOC);
			//if user name found
			if($getClinicianNameeRow)
			{
				$firstname = $getClinicianNameeRow['firstname']; 

				$mail_body = '<div style="width:100%;background-color: gainsboro;"> 
				<div style="margin-left:0px;  margin-top: 0px; height: auto     width: 100%;">Hi '.$firstname.',<br><br>A query form has been submitted for one of your Health Risk Assessments and your review is needed.<br><br>Please <a href="">login</a> to your dashboard at your earliest convenience to review.<br>Thank You</div></div>';
			
				return Utility::sendMailTo($mailId,'Query Form',$mail_body);

			}
			else
			{
				Utility::failedMailResponse("user not found");
			}
				
			return Utility::failedMailResponse("unknown");
			
		}

		public function getVersioningData($clientId,$year,$memberId)
		{
			include("../db.php");
			$getVersion="select * from HRA_member_".$clientId.'_'.$year." where member_id ='$memberId'";
			try
			{
				$getVersionresult=mysqli_query($conn,$getVersion);
				$getVersionresultrow=mysqli_fetch_array($getVersionresult,MYSQLI_ASSOC);
				$versioning = $getVersionresultrow['versioning'];
				$response = new stdClass();
				$response->versioning = $versioning;
				$response = json_encode($response);
				echo $response;	
			}
			catch (Exception $e) 
			{ // handle error.
                echo 'Message could not be sent. Mailer Error: ', $mail->ErrorInfo;
            }
		}
		
		public function queryData($clientId,$year,$memberId,$role,$mailId)
		{
			
			include("../db.php");
			$jsondata = $GLOBALS['input']->{'data'};
			$hraStatus = $GLOBALS['input']->{'hraStatus'};
			$hra_username = $GLOBALS['input']->{'hraUsername'};
			$josnInfoData =  json_encode($jsondata);
			$hraStatus =  json_encode($hraStatus);
			$hra_status_elements = $hraStatus;
		
			$josnInfoDataa = mysqli_real_escape_string($conn,$josnInfoData);
		
			if($hra_status_elements)
			{
				//decode json hra status into individual fields
				//{"hraStatus": 2, "subStatus": "", "cancelStatus": "","cancelText": ""}
				$hra_status_elements = json_decode($hra_status_elements,true);
				$hra_status = $hra_status_elements['hraStatus'];
				$hra_sub_status = $hra_status_elements['subStatus'];
				$hra_cancel_status = $hra_status_elements['cancelStatus'];
				$hra_cancel_text =  $hra_status_elements['cancelText'];

			}

			$resultData = $this->addHraStatusHistory($clientId,$year,$memberId,$hra_status,$hra_username);
			$result_success = $resultData['success'];
			$hra_history_updated = $resultData['updatedJsonHistory'];
			
			$update_querydata ="";
			if($result_success)
			{
				$update_querydata = "UPDATE HRA_member_".$clientId.'_'.$year." SET hraStatusHistory='$hra_history_updated',query_form= '$josnInfoDataa',hraStatus='$hraStatus' WHERE member_id = '$memberId'";
			}
			else
			{
				$update_querydata = "UPDATE HRA_member_".$clientId.'_'.$year." SET query_form= '$josnInfoDataa',hraStatus='$hraStatus' WHERE member_id = '$memberId'";
			}
			
			try
			{
				$update_querydataresult=mysqli_query($conn,$update_querydata);
				$updated_resp = mysqli_affected_rows($conn);
				if($updated_resp)
				{
					$mail_response = $this->sendmailalert($role,$mailId);
					$response = new stdClass();
					$response->status = "updated";
					$response->mailStatus = $mail_response["mailStatus"];
					$response->mailError = $mail_response["error"];
					$response = json_encode($response);
					echo $response;
				}
				else
				{
					$response = new stdClass();
					$response->status = "notUpdated";
					$response->mailStatus = "mailSendFailed";
					$response->mailError = "Unknown error";
					$response = json_encode($response);
					echo $response;
				}
				
			}
			catch(Exception $e)
			{
				$error = $e->getMessage();
				echo $error;
			}
			
			
		}

			/*
			sent to avility api definition
			sample request body json format
			{
				"data":
				{
					"clientId":"client_001",
					"year" : "2020",
					"memberIds":[
							"11002711",
							"11002711"
						],
					"sentToAvility":"23-11-2020 04:45:54"
				}
			}
		*/
		public function sentToAvility($client_id,$year,$member_id_array,$date)
		{

			include("../db.php");

			//total member ids sent count
			$total_member_count = count($member_id_array);

			//implode array values in to string with single quotes
			//$array_of_member_ids_string = "'".implode("', '", $member_id_array)."'";
			$totalclientscount = count($client_id);
		//	print_r($array_of_member_ids_string);die;
			try
			{
				$reccount = 0;
				for($a=0;$a <$totalclientscount; $a++){
			
				$client_idd = $client_id[$a];
					//find the members record count to identify wrong member id if any
					$member_records_query = "select * from HRA_member_".$client_idd.'_'.$year." where member_id IN ($member_id_array[$a])";
					$member_records_query_result=mysqli_query($conn,$member_records_query);
					$member_record_count = mysqli_num_rows($member_records_query_result);
							
					//update members sent to avility date 
	//$update_set_to_avility_query = "UPDATE HRA_member_".$client_idd.'_'.$year." SET `sentToAvility` = '$date' WHERE `member_id` IN ($member_id_array[$a])";
$update_set_to_avility_query = "UPDATE HRA_member_".$client_idd.'_'.$year." SET `sentToAvility` = '$date' WHERE `member_id` IN ('$member_id_array[$a]')";
					$updated_response = NULL;
					$updated_result=mysqli_query($conn,$update_set_to_avility_query);
					$updated_response = mysqli_affected_rows($conn);
					$reccount = $reccount + $member_record_count;
			}

				
				if($updated_response)
				{
					$response = new stdClass();
					$response->status = "success";
					$response->totalmemberidssent = $total_member_count;
					$response->totalmemberidsupdate = $reccount;
					if($total_member_count!=$reccount){$response->error = "but some invalid member ids";}
					$response = json_encode($response);
				}
				else
				{
					$response = new stdClass();
					if($total_member_count!=$reccount)
					{
						$response->status = "failed";
						$response->error = "some invalid member ids";
					}
					else
					{
						$response->status = "success";
						$response->message = "no change in date value";
					}
					$response->totalmemberidssent = $total_member_count;
					$response->totalmemberidsupdate = $updated_response;
					$response = json_encode($response);
				}

				echo $response;
						
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				echo $error;
			}
		}

		/*
			set invoice date to list of members 
			sample request body json format
			{
				"data":
				{
					"clientId":"client_001",
					"year" : "2020",
					"memberIds":[
							"11002711",
							"11002711"
						],
					"invoiceDate":"23-11-2020 04:45:54"
				}
			}
			
		*/
		public function invoiceDate($client_id,$year,$member_id_array,$date)
		{
			
			include("../db.php");

			//total member ids sent count
			$total_member_count = count($member_id_array);

			//implode array values in to string with single quotes
			//$array_of_member_ids_string = "'".implode("', '", $member_id_array)."'";
			$totalclientscount = count($client_id);
		//	print_r($array_of_member_ids_string);die;
			try
			{
				$reccount = 0;
				for($a=0;$a <$totalclientscount; $a++){
			
				$client_idd = $client_id[$a];
					//find the members record count to identify wrong member id if any
					$member_records_query = "select * from HRA_member_".$client_idd.'_'.$year." where member_id IN ($member_id_array[$a])";
					$member_records_query_result=mysqli_query($conn,$member_records_query);
					$member_record_count = mysqli_num_rows($member_records_query_result);
							
					//update members sent to avility date 
	//$update_set_to_avility_query = "UPDATE HRA_member_".$client_idd.'_'.$year." SET `invoiceDate` = '$date' WHERE `member_id` IN ($member_id_array[$a])";
$update_set_to_avility_query = "UPDATE HRA_member_".$client_idd.'_'.$year." SET `invoiceDate` = '$date' WHERE `member_id` IN ('$member_id_array[$a]')";
					$updated_response = NULL;
					$updated_result=mysqli_query($conn,$update_set_to_avility_query);
					$updated_response = mysqli_affected_rows($conn);
					$reccount = $reccount + $member_record_count;
			}

				
				if($updated_response)
				{
					$response = new stdClass();
					$response->status = "success";
					$response->totalmemberidssent = $total_member_count;
					$response->totalmemberidsupdate = $reccount;
					if($total_member_count!=$reccount){$response->error = "but some invalid member ids";}
					$response = json_encode($response);
				}
				else
				{
					$response = new stdClass();
					if($total_member_count!=$reccount)
					{
						$response->status = "failed";
						$response->error = "some invalid member ids";
					}
					else
					{
						$response->status = "success";
						$response->message = "no change in date value";
					}
					$response->totalmemberidssent = $total_member_count;
					$response->totalmemberidsupdate = $updated_response;
					$response = json_encode($response);
				}

				echo $response;
						
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				echo $error;
			}
	
		}

		/*
			set report notes for a member

			request body json format
			{
				"data":
				{
					"clientId":"client_001",
					"year":"2020",
					"memberId":"1100094',
					"notes":"notes for member"
				}
			}
			
		*/
		public function reportNotes($client_id,$year,$member_id,$notes_text)
		{
			
			try
			{
				$is_note_updated=$this->addReportNote($client_id,$year,$member_id,$notes_text);			
				if($is_note_updated)
				{
					$response = new stdClass();
					$response->status = "success";
					$response = json_encode($response);
				}
				else
				{
					$response = new stdClass();
					$response->status = "failed";
					$response = json_encode($response);
				}
				echo $response;			
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				echo $error;
			}
	
		}

		/*
			internal utility function for report notes api call
			to append report json field everytime reportNotes api called 
		*/
		private function addReportNote($client_id,$year,$member_id,$notes_text)
		{

			include("../db.php");
			
			$report_notes=NULL;
			$report_notes_array=NULL;
			$member_query = "select * from HRA_member_".$client_id.'_'.$year." where member_id='$member_id'";
			$is_member = false;
			try
			{
				$member_query_result=mysqli_query($conn,$member_query);
				if(mysqli_num_rows($member_query_result) == 1)
				{
					$member_row=mysqli_fetch_array($member_query_result,MYSQLI_ASSOC);
					$report_notes = $member_row['reportNotes'];
					$is_member=true;
				}
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				$is_member=false;
			}

			if($is_member)
			{
				if($report_notes==NULL || $report_notes=="")
				{
					$report_notes='{ }';
				}
				//decode the report notes into array
				$report_notes_array = json_decode($report_notes, true);
				//get the current time
				TimeZone::useTimeZone();
				$current_date_time = date("Y-m-d")."T".date("H:i");
				//report note array keys ans values
				$new_report_note = array("date"=>$current_date_time,"text"=>$notes_text);
				array_push( $report_notes_array, $new_report_note );
				$updated_report_notes_array=json_encode($report_notes_array);
				//update report notes sql query 
				$update_report_notes_query = "update HRA_member_".$client_id.'_'.$year." SET reportNotes='$updated_report_notes_array' WHERE `member_id` = '$member_id'";
				$update_report_notes_query_result = NULL;
				try 
				{
					$update_report_notes_query_result=mysqli_query($conn,$update_report_notes_query);
					if($update_report_notes_query_result)
					{
						return true;
					}
					else
					{	
						return false;
					}	
				}
				catch (Exception $e)
				{
					$error = $e->getMessage();
					return false;
				}

			}

			return false;

		}

		/*
			internal utilty function to clear the reportNotes data
			with the condition when call log api called
		*/
		private  function clearReportNotes($client_id,$year,$member_id)
		{
				include("../db.php");
				$update_report_notes_query = "update HRA_member_".$client_id.'_'.$year." SET reportNotes=NULL WHERE `member_id` = '$member_id'";
				$update_report_notes_query_result = NULL;
				try 
				{
					$update_report_notes_query_result=mysqli_query($conn,$update_report_notes_query);
					if($update_report_notes_query_result)
					{
						return true;
					}
					else
					{	
						return false;
					}	
				}
				catch (Exception $e)
				{
					$error = $e->getMessage();
					return false;
				}

				return false;
		}

		/*
			NAME : getAllCities
			DETAILS : get the list of available city name
			RETURN : response as city names array
					{
						"status":"success",
						"cities":['name','name 2']
					}
		*/
		public function getAllCities()
		{
			include("../db.php");
			$member_city_response = new stdClass();
			//sql query to get all city name of member list
			$member_cities_list_query = "select * from HRA_member_city ORDER BY name";
			try 
			{	
				
				$member_cities_list_query_result=mysqli_query($conn,$member_cities_list_query);
                while($members_city_list=mysqli_fetch_array($member_cities_list_query_result,MYSQLI_ASSOC))
		        { 
			        $cities_array[] = $members_city_list['name'];
				}
				
				$member_city_response->status = "success";
				$member_city_response->cities = $cities_array;
	
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				$member_city_response->status = "failed";
				$member_city_response->cities = null;
				$member_city_response->error = $error;
			}
			
			echo json_encode($member_city_response);

		}


					
		public function efaxmonthlyresult($parameters,$error){
		include("../db.php");
			//custom parameter datas
			$plan_id = $parameters['planId'];
			$user_id = $parameters['userId'];
		   $year = $parameters['year'];
		   $min = $parameters['min'];
		   $max = $parameters['max'];
		   $overallfaxreport =   $this ->getfaxmonthlyreport($plan_id,$year,$parameters);
		  if(count($overallfaxreport) != 0){
		   $member_infodata=array("status"=>true,"members"=>$overallfaxreport,"error"=>"","totalRows"=>count($overallfaxreport));
		}
		else{
		$member_infodata=array("status"=>true,"members"=>$overallfaxreport,"error"=>"","totalRows"=>0);
			}
		  
		  echo $res_result = json_encode($member_infodata);  
		}
		
		
		
		public function getfaxmonthlyreport($plan_id,$year,$parameters){
			TimeZone::useTimeZone();
			$current_date = date("Y-m-d");
			$first_day_this_month = date('Y-m-01');  
			$last_day_this_month  = date('Y-m-t');
			$base_sort_by = $parameters['baseSortBy'];
			$base_sort_order = $parameters['baseSortOrder']==0?'ASC':'DESC';
			$sort_by = $parameters['sortBy']; 
			$sort_order = $parameters['sortOrder']==0?'ASC':'DESC';
			$fromdate = ($parameters['fromdate'] != null || $parameters['fromdate'] != '') ? $parameters['fromdate'] : $first_day_this_month;
			$todate = $parameters['todate'] != null || $parameters['todate'] != ''  ? $parameters['todate'] : $last_day_this_month;
			include("../db.php");
			$getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";
			$getClientsidsresult=mysqli_query($conn,$getClientsids);
			$sql_global_member_query = array();
			while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
				$client_id =  $getClientsidsresp['clientId'];
				$combine_member_query[] = "select member_id,date_format(JSON_UNQUOTE(json_extract(pcp_fax_response, '$.date')), '%Y-%m-%d') as faxsenddate,clientid as client_id,year,pcp_fax_response FROM HRA_member_".$client_id.'_'.$year." where pcp_fax_response is not null";

			}

			if($combine_member_query && is_array($combine_member_query))
			{
				$sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
				 $sql_global_member_query1 = "select * from (". $sql_global_member_query1 . " ) as member_table " ;
				$sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,$sql_global_member_query1);
			}
			if(count($sql_global_member_query)==0) return FALSE; 
			$generated_query = implode($sql_global_member_query);
			$membersresult=mysqli_query($conn,$generated_query);
			$memids = [];
			$overallarray = [];
			while($membersresultresp=mysqli_fetch_array($membersresult,MYSQLI_ASSOC)){
				if($membersresultresp['pcp_fax_response'] != '' || $membersresultresp['pcp_fax_response'] != null ){
	if(substr($membersresultresp['pcp_fax_response'],0,1) == '[') {
$faxarraydata = json_decode($membersresultresp['pcp_fax_response'],true);
$count = count($faxarraydata);

for($p=0; $p<$count;$p++){
	$savedfaxdate = $faxarraydata[$p]['date'];
	$savedfaxdate = date("Y-m-d", strtotime($savedfaxdate));
if ($savedfaxdate > $fromdate && $savedfaxdate < $todate){

	$memids['member_ids'] = $membersresultresp['member_id'];
	$memids['date'] = $savedfaxdate;
	$memids['pcp_fax_response'] = json_decode($membersresultresp['pcp_fax_response'], true, JSON_UNESCAPED_SLASHES);
	array_push($overallarray,$memids);
}

}
}
else{
$faxobject = $membersresultresp['pcp_fax_response'];
$faxarray = json_decode($faxobject,true);
 $savedfaxdate = $faxarray['date'];
 $savedfaxdate = date("Y-m-d", strtotime($savedfaxdate));
if ($savedfaxdate > $fromdate && $savedfaxdate < $todate){
	$memids['member_ids'] = $membersresultresp['member_id'];
	$memids['date'] = $membersresultresp['faxsenddate'];
	$memids['pcp_fax_response'] = json_decode($membersresultresp['pcp_fax_response'], true, JSON_UNESCAPED_SLASHES);
	array_push($overallarray,$memids);
}

}
				}

			}
			return $overallarray;
			
		}


		public function resendfax($memberId,$clientId,$year){
			include("../db.php");
			$fileepath = '../member_data/HRA_member_'.$clientId.'/'.$year;
$file_moved_path_location = $fileepath.'/summary_report/'.$memberId.'.pdf';
$faxapiclass = new FaxApiClass;
$faxapiclass->SendFaxPdfFile($clientId,$year,$memberId,$file_moved_path_location);

		}



		public function updateFaxNumberWithPcpName($faxnumber,$pcpname,$plan_id,$year){
			include("../db.php");
			$getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";
     
			$getClientsidsresult=mysqli_query($conn,$getClientsids);
			$sql_global_member_query = array();

			while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
				$client_id =  $getClientsidsresp['clientId'];
				$combine_member_query[] = "SELECT member_id,clientid,memberinfo,JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','demographic')),'.component','.value[0]' ) ) ) As Demographic,hraFileUpdatedHistory,JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'all','demographic', null, '$.history[*].modified[*].component' )) as serialno FROM HRA_member_".$client_id.'_'.$year. " where JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Pcp_Name')) = '$pcpname'";
			}
			if($combine_member_query && is_array($combine_member_query))
			{
				$sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
				$sql_global_member_query1 = "select * from (".$sql_global_member_query1.") as  member_table";
				$sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,$sql_global_member_query1);
			}
			$generated_query = implode($sql_global_member_query);
//echo $generated_query;die;
			$get_memberinfoobj=mysqli_query($conn,$generated_query);
 			$rowcount=mysqli_num_rows($get_memberinfoobj);
			if($rowcount != 0) {
				while($resultrow=mysqli_fetch_array($get_memberinfoobj,MYSQLI_ASSOC)){
					$member_id = 	$resultrow['member_id'];
					$clientId = $resultrow['clientid'];
					$Demographic = 	$resultrow['Demographic'];
					$serialno = $resultrow['serialno'];
					$serailid = mb_substr($serialno, 22, 1);
					$hraFileUpdatedHistory = $resultrow['hraFileUpdatedHistory'];
					$hraFileUpdatedHistoryarray = json_decode($hraFileUpdatedHistory,true);
					
					$hraFileUpdatedHistoryarray['history'][0]['modified'][$serailid]['value'][0]['pcpfaxno'] = $faxnumber;
	
					$hraFileUpdatedHistoryobject = json_encode($hraFileUpdatedHistoryarray);  //hrafileupdatehistroryobject
					$hraFileUpdatedHistoryobject = mysqli_real_escape_string($conn,$hraFileUpdatedHistoryobject);

					$memberinfo = $resultrow['memberinfo']; 


					$memberinfo_array = json_decode($memberinfo,true);
					$memberinfo_array['PCP_Fax_Number']=$faxnumber;
					$memberinfo_obj = json_encode($memberinfo_array); //memberinfo object
					$update_faxnumber_query = "UPDATE HRA_member_".$clientId.'_'.$year." SET `memberinfo` = '$memberinfo_obj',`hraFileUpdatedHistory` = '$hraFileUpdatedHistoryobject' WHERE `member_id` = '$member_id'";
					$updated_result=mysqli_query($conn,$update_faxnumber_query);
					$updated_response = mysqli_affected_rows($conn);
					if($updated_response)
					{
						$response = new stdClass();
						$response->status = "updated";

						$response = json_encode($response);

						$fileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
						$getcontentdata = file_get_contents($fileepath);
						$decodeddata = json_decode($getcontentdata,true);
			 			$decodeddata['data'][0]['q'][0]['pcpfaxno'] = $faxnumber;
			 			$encodeddata = json_encode($decodeddata);
		 
			  			file_put_contents($fileepath,$encodeddata);

				}else{

					$response = new stdClass();
					$response->status = "not updated";

					$response = json_encode($response);
				}


			}
		}else{
			$response = new stdClass();
			$response->status = "no Records";

			$response = json_encode($response);

		}
			echo $response;


		}


		public function updatefaxnumber($faxnumber,$mem_id,$clientId,$year){

			include("../db.php");
			$get_memberinfo = "select memberinfo from HRA_member_".$clientId.'_'.$year." where member_id ='$mem_id'";
			$get_memberinfoobj=mysqli_query($conn,$get_memberinfo);
			$resultrow=mysqli_fetch_array($get_memberinfoobj,MYSQLI_ASSOC);
		    $memberinfo = $resultrow['memberinfo'];
			$memberinfo_array = json_decode($memberinfo,true);
			$memberinfo_array['PCP_Fax_Number']=$faxnumber;
			$memberinfo_obj = json_encode($memberinfo_array);

			$update_faxnumber_query = "UPDATE HRA_member_".$clientId.'_'.$year." SET `memberinfo` = '$memberinfo_obj' WHERE `member_id` = '$mem_id'";
			$updated_result=mysqli_query($conn,$update_faxnumber_query);
			$updated_response = mysqli_affected_rows($conn);
			if($updated_response)
			{
				$response = new stdClass();
				$response->status = "updated";

				$response = json_encode($response);
			}else{

				$response = new stdClass();
				$response->status = "not updated";

				$response = json_encode($response);
			}

				echo $response;
		}

		
		public function saveAddress($client_id,$year,$member_id){
			include("../db.php");
			$address1 = $GLOBALS['input']->{'add1'};
			$address2 = $GLOBALS['input']->{'add2'};
			$address3 = $GLOBALS['input']->{'add3'};
			$city = $GLOBALS['input']->{'city'};
			$state = $GLOBALS['input']->{'state'};
			$zip = $GLOBALS['input']->{'zip'};
			$country = $GLOBALS['input']->{'country'};
			$phone = $GLOBALS['input']->{'primary_number'};
			$secondaryphone = $GLOBALS['input']->{'secondary_number'};
			$alternatephone = $GLOBALS['input']->{'alternate_number'};
			$email = $GLOBALS['input']->{'email'};
			$response = new stdClass();
			$response -> memberId = $member_id;
            $response -> cleintId = $client_id;
			$response -> year = $year;

			$get_data_query = "SELECT member_id,clientid,memberinfo,JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','demographic')),'.component','.value[0]' ) ) ) As Demographic,hraFileUpdatedHistory,JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'all','demographic', null, '$.history[*].modified[*].component' )) as serialno from HRA_member_".$client_id."_$year where member_id=?";

			//echo "SELECT member_id,clientid,memberinfo,JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','demographic')),'.component','.value[0]' ) ) ) As Demographic,hraFileUpdatedHistory,JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'all','demographic', null, '$.history[*].modified[*].component' )) as serialno from HRA_member_".$client_id."_$year where member_id='$member_id'";exit;
			$get_data_sql = $conn -> prepare($get_data_query);
			$get_data_sql -> bind_param("s",$member_id);
			$get_data_sql -> execute();
			$get_data_result = $get_data_sql -> get_result();
			if($get_data_result -> num_rows > 0){
				
				$get_data_row = $get_data_result -> fetch_array();
				$memberinfo = $get_data_row['memberinfo'];
				$hra_file_updated_history = $get_data_row['hraFileUpdatedHistory'];
				$Demographic = $get_data_row['Demographic'];
				$serialno = $get_data_row['serialno'];
				$serailid = mb_substr($serialno, 22, 1);

				$mem_info_details = json_decode($memberinfo,true);
				$mem_info_details['Member_Address1'] =  $address1;
				$mem_info_details['Member_Address2'] =  $address2;
				$mem_info_details['Member_Address3'] =  $address3;
				$mem_info_details['Member_City'] =  $city;
				$mem_info_details['Member_State'] =  $state;
				$mem_info_details['Member_Zip_Code'] =  $zip;
				$mem_info_details['Member_Country'] =  $country;
				$mem_info_details['Member_Primary_Phone_Number'] =  $phone;
				$mem_info_details['Member_Secondary_Phone_Number'] =  $secondaryphone;
				$mem_info_details['Member_Alternate_Phone_Number'] =  $alternatephone;
				$mem_info_details['Member_Email_Address'] =  $email;

				$memberinfo_obj = json_encode($mem_info_details);

				$hraFileUpdatedHistoryarray = json_decode($hra_file_updated_history,true);

				TimeZone::useTimeZone();
                $current_date = date("m-d-Y");
                $current_time = date("H:i:s");

				$hraFileUpdatedHistoryarray['history'][$serailid]['modified'][$serailid]['date'] = $current_date;
				$hraFileUpdatedHistoryarray['history'][$serailid]['modified'][$serailid]['time'] = $current_time;
				$hraFileUpdatedHistoryarray['history'][$serailid]['modified'][$serailid]['value'][0]['add'] = $address1;
				$hraFileUpdatedHistoryarray['history'][$serailid]['modified'][$serailid]['value'][0]['add1'] = $address2;
				$hraFileUpdatedHistoryarray['history'][$serailid]['modified'][$serailid]['value'][0]['add2'] = $address3;
				$hraFileUpdatedHistoryarray['history'][$serailid]['modified'][$serailid]['value'][0]['city'] = $city;
				$hraFileUpdatedHistoryarray['history'][$serailid]['modified'][$serailid]['value'][0]['state'] = $state;
				$hraFileUpdatedHistoryarray['history'][$serailid]['modified'][$serailid]['value'][0]['zip'] = $zip;
				$hraFileUpdatedHistoryarray['history'][$serailid]['modified'][$serailid]['value'][0]['pno'] = $phone;
				$hraFileUpdatedHistoryarray['history'][$serailid]['modified'][$serailid]['value'][0]['cno'] = $secondaryphone;
				$hraFileUpdatedHistoryarray['history'][$serailid]['modified'][$serailid]['value'][0]['ano'] = $alternatephone;
				$hraFileUpdatedHistoryarray['history'][$serailid]['modified'][$serailid]['value'][0]['email'] = $email;
				$hraFileUpdatedHistoryobject = json_encode($hraFileUpdatedHistoryarray);  

				$update_address_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET `memberinfo` = ?,`hraFileUpdatedHistory` = ? WHERE `member_id` = ?";
				//echo "UPDATE HRA_member_".$client_id.'_'.$year." SET `memberinfo` = '".$memberinfo_obj."',`hraFileUpdatedHistory` = '".$hraFileUpdatedHistoryobject."' WHERE `member_id` = '".$member_id."'";exit;
				$updated_result=$conn->prepare($update_address_query);
				$updated_result -> bind_param("sss", $memberinfo_obj, $hraFileUpdatedHistoryobject,$member_id);
				$updated_result -> execute();
				$updated_response = $conn -> affected_rows;
				//echo "<pre>".print_r($updated_response,1)."</pre>";exit;
				if($updated_response)
				{		
					$response -> status = "Updated";
					$response -> member_info = $memberinfo_obj;
					$response = json_encode($response);
					$fileepath = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
					$getcontentdata = file_get_contents($fileepath);
					$hrajson_data = json_decode($getcontentdata,true);
					$hrajson_data['data'][0]['q'][0]['add'] = $address1;
					$hrajson_data['data'][0]['q'][0]['add2'] = $address2;
					$hrajson_data['data'][0]['q'][0]['add3'] = $address3;
					$hrajson_data['data'][0]['q'][0]['city'] = $city;
					$hrajson_data['data'][0]['q'][0]['state'] = $state;
					$hrajson_data['data'][0]['q'][0]['zip'] = $zip;
					$hrajson_data['data'][0]['q'][0]['pno'] = $phone;
					$hrajson_data['data'][0]['q'][0]['cno'] = $secondaryphone;
					$hrajson_data['data'][0]['q'][0]['ano'] = $alternatephone;
					$hrajson_data['data'][0]['q'][0]['email'] = $email;

					$hrajson_data = json_encode($hrajson_data);
		 
			  		file_put_contents($fileepath,$hrajson_data);
					echo $response;
					return false;

				}else{
					$response -> status = "Not Updated";
					$response = json_encode($response);
				}		
			}else{
				$response -> status = "no Records";
				$response = json_encode($response);
			}
			echo $response;
		}

	public function queryform($clientId, $year, $req_id) {

		include("../db.php");
		$EvalDate = "select EvaluationDate from HRA_member_" . $clientId . '_' . $year . " where member_id='$req_id'";
		$query = mysqli_query($conn, $EvalDate);
		$dateOfService = mysqli_fetch_array($query, MYSQLI_ASSOC);
		$response = new stdClass();
		$response->status = 1;
		$response->dateOfService = $dateOfService;
		echo json_encode($response);
		return true;

	}
	
}

//validate token
$token_validation_result = JwtUtility::isValidToken();
if($token_validation_result !== JwtUtility::VALID_TOKEN)
{     
	//un authorized access 
    JwtUtility::exitWithUnAuthorizedResponse($token_validation_result);
}
//end of token validation

$members = new members;
$method = $_SERVER['REQUEST_METHOD'];
$requestedurl = $_SERVER['REQUEST_URI'];
$arrayurlstring = explode("/",$requestedurl);
$crcount = count($arrayurlstring);
$crcountt = $crcount -1;
$requestMethod = $arrayurlstring[$crcountt];
$exploded = explode("?",$requestMethod);
$requestMethod = $exploded[0];
 
  switch ($method) {
	    case 'POST' :

			$postdata = file_get_contents("php://input");
//echo "<pre>";
//print_r($postdata);die;
			$request = json_decode($postdata);
			$requestt = json_decode($postdata,true);

			$GLOBALS['inputData'] = $requestt;
			$GLOBALS['input'] = $request;



			switch($requestMethod)
			{

case 'sendutcletter' :
					$year = $GLOBALS['inputData']['year'];
					$memm_id = $GLOBALS['inputData']['memberId'];
					$clientId = $GLOBALS['input']->{'clientId'};

					$members->sendutclettersbymail($year,$clientId,$memm_id);
				break;

					case 'updatefaxnumber' :
					$faxnumber = $GLOBALS['inputData']['faxnumber'];
					$mem_id = $GLOBALS['inputData']['memberId'];
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$members->updatefaxnumber($faxnumber,$mem_id,$clientId,$year);
					break;

			case 'updateFaxNumberWithPcpName' :
						$faxnumber = $GLOBALS['inputData']['faxNumber'];
						$pcpname = $GLOBALS['inputData']['pcpName'];
						$plan = $GLOBALS['input']->{'planId'};
						$year = $GLOBALS['input']->{'year'};
						$members->updateFaxNumberWithPcpName($faxnumber,$pcpname,$plan,$year);
						break;


					case 'resendfax' :
						
						$mem_id = $GLOBALS['inputData']['memberId'];
						$clientId = $GLOBALS['input']->{'clientId'};
						$year = $GLOBALS['input']->{'year'};
						$members->resendfax($mem_id,$clientId,$year);


						break;


				case 'assignMember' :
					$memm_id = $GLOBALS['inputData']['data']['memberId'];
					$nurse_Id = $GLOBALS['inputData']['data']['nurseId'];
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$members->assignMember($memm_id,$nurse_Id,$clientId,$year);
				break;

				case 'evaluationDate' :
					$memm_id = $GLOBALS['input']->{'id'};
					$year = $GLOBALS['input']->{'year'};
					$clientId = $GLOBALS['input']->{'clientId'};
					$members->evaluationDate($memm_id,$clientId,$year);
				break;

                case 'referralSendHelpline' :
//                    print_r($GLOBALS['input']->{'id'});exit();
                    $memm_id = $GLOBALS['input']->{'id'};
                    $year = $GLOBALS['input']->{'year'};
                    $clientId = $GLOBALS['input']->{'clientId'};
                    $members->referralSendHelpline($memm_id,$clientId,$year);
                    break;

				case 'assignToQa' :
					$memm_id = $GLOBALS['inputData']['data']['memberId'];
					$qa_Id = $GLOBALS['inputData']['data']['qaId'];
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$members->assignToQa($memm_id,$qa_Id,$clientId,$year);
				break;
				
				case 'assignToCoder' :
					$memm_id = $GLOBALS['inputData']['data']['memberId'];
					$coder_Id = $GLOBALS['inputData']['data']['coderId'];
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$members->assignToCoder($memm_id,$coder_Id,$clientId,$year);
				break;

				case 'registerMember' :
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$Member_Identification_Number = $GLOBALS['inputData']['data']['Member_Identification_Number'];
					$members->registerMember($clientId,$year,$Member_Identification_Number);		
				break;

				case 'updateMember' :
					$client_id = $GLOBALS['inputData']['clientId'];
					$year = $GLOBALS['inputData']['year'];
					$member_id = $GLOBALS['inputData']['memberId'];
					$members->updateMember($client_id,$year,$member_id);
				break;

                case 'hraSave' :
                    $clientId = $GLOBALS['input']->{'clientId'};
                    $year = $GLOBALS['input']->{'year'};
                    $req_id = $GLOBALS['input']->{'id'};
                    $members->hraSave($clientId, $year, $req_id);
                    break;

                case 'savingSignature' :
                    $clientId = $GLOBALS['input']->{'clientId'};
                    $year = $GLOBALS['input']->{'year'};
                    $req_id = $GLOBALS['input']->{'id'};
                    $members->savingSignature($clientId, $year, $req_id);
                    break;

				case 'offlineHraSave' :
					$client_id = $GLOBALS['inputData']['clientId'];
					$year = $GLOBALS['inputData']['year'];
					$member_id = $GLOBALS['inputData']['id'];
					$members->offlineHraSave($client_id,$year,$member_id);
				break;
				
				case 'scheduleDate' :
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$memberId = $GLOBALS['inputData']['data']['memberId'];
					$scheduleDate = $GLOBALS['inputData']['data']['scheduleDate'];
					$members->scheduleDate($clientId,$year,$memberId,$scheduleDate);
				break;

				case 'scheduleDateCalllog' :
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$memberId = $GLOBALS['inputData']['data']['memberId'];
					$scheduleDate = $GLOBALS['inputData']['data']['scheduleDate'];
					$members->scheduleDateCalllog($clientId,$year,$memberId,$scheduleDate);
				break;
				
				case 'termDate' :
					$memberId = $GLOBALS['inputData']['data']['memberId'];
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$members->termDate($clientId,$year,$memberId);
				break;
				
				case 'scheduleMember' :
					$req_nurseid = $GLOBALS['input']->{'id'};
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$members->scheduleMember($clientId,$year,$req_nurseid);
				break;
				
				case 'downloadMember' :
					$arrCount = count($GLOBALS['inputData']['data']);
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$members->downloadMember($clientId,$year,$arrCount);
				break;
				
				case 'unAssignMember' :
					$memberIdd = $GLOBALS['inputData']['data']['memberId'];
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$members->unAssignMember($clientId,$year,$memberIdd);
				break;
				
				case 'unAssignQa' :
					$memberIdd = $GLOBALS['inputData']['data']['memberId'];
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$members->unAssignQa($clientId,$year,$memberIdd);
				break;
				
				case 'unAssignToQa' :
					$memberIdd = $GLOBALS['inputData']['data']['memberId'];
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$members->unAssignToQa($clientId,$year,$memberIdd);
				break;
				
				case 'unAssignCoder' :
					$memberIdd = $GLOBALS['inputData']['data']['memberId'];
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$members->unAssignCoder($clientId,$year,$memberIdd);
				break;
				
				case 'unAssignToCoder' :
					$memberIdd = $GLOBALS['inputData']['data']['memberId'];
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$members->unAssignToCoder($clientId,$year,$memberIdd);
				break;
				
				case 'visitType' :
//echo "ss";die;
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$memID = $GLOBALS['inputData']['data']['memberId'];
					$members->visitType($clientId,$year,$memID);
				break;

				case 'visitTypecalllog' :
					//echo "ss";die;
										$clientId = $GLOBALS['input']->{'clientId'};
										$year = $GLOBALS['input']->{'year'};
										$memID = $GLOBALS['inputData']['data']['memberId'];
										$members->visitTypecalllog($clientId,$year,$memID);
									break;
				
				case 'hraStatus' :
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$memID = $GLOBALS['inputData']['data']['memberId'];
					$members->hraStatus($clientId,$year,$memID);
				break;
				
				case 'versioning' :
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$memID = $GLOBALS['input']->{'id'};
					$members->versioning($clientId,$year,$memID);
				break;
			
				
				case 'unScheduleDate' :
					$memberId = $GLOBALS['inputData']['data']['memberId'];
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$members->unScheduleDate($clientId,$year,$memberId);
				break;
				
				case 'changeNurseStatus' :
					$nurseId = $GLOBALS['inputData']['data']['nurseId'];
					$adminId = $GLOBALS['inputData']['data']['adminId'];
					$loginStatus = $GLOBALS['inputData']['data']['loginStatus'];
					$members->changeNurseStatus($nurseId,$adminId,$loginStatus);
				break;
				
				case 'queryData' :
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$memberId = $GLOBALS['input']->{'id'};
					$role = $GLOBALS['input']->{'role'};
					$mailId = $GLOBALS['input']->{'mailId'};
					$members->queryData($clientId,$year,$memberId,$role,$mailId);
				break;
				
				case 'callLog' :
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$memid = $GLOBALS['input']->{'id'};
					$members->callLog($clientId,$year,$memid);
				break;

				case 'sentToAvility':
					$client_id = $GLOBALS['inputData']['data']["clientId"];
					$year = $GLOBALS['inputData']['data']["year"];
					$sent_avility_date = $GLOBALS['inputData']['data']["sentToAvility"];
					$member_id_array = $GLOBALS['inputData']['data']["memberIds"];
					$members->sentToAvility($client_id,$year,$member_id_array,$sent_avility_date);
				break;

				case 'invoiceDate':
					$client_id = $GLOBALS['inputData']['data']["clientId"];
					$year = $GLOBALS['inputData']['data']["year"];
					$sent_avility_date = $GLOBALS['inputData']['data']["invoiceDate"];
					$member_id_array = $GLOBALS['inputData']['data']["memberIds"];
					$members->invoiceDate($client_id,$year,$member_id_array,$sent_avility_date);
				break;

				case 'reportNotes':
					$client_id = $GLOBALS['inputData']['data']["clientId"];
					$year = $GLOBALS['inputData']['data']["year"];
					$notes_text = $GLOBALS['inputData']['data']["notes"];
					$member_id = $GLOBALS['inputData']['data']["memberId"];
					$members->reportNotes($client_id,$year,$member_id,$notes_text);
				break;

				case 'updatePriorAssessmentsReviewStatus' :
					$client_id = $GLOBALS['inputData']['clientId'];
					$member_id = $GLOBALS['inputData']['memberId'];
					$year = $GLOBALS['inputData']['year'];
					$review_status_text = strtolower($GLOBALS['inputData']['reviewStatus']);
					$review_status = $review_status_text==="yes"?1:0;
					$member_history = new MemberHistory;
					$member_history->reviewAssessmentStatus($client_id,$year,$member_id,$review_status);
				break;
					
				case 'updateReturnMailStatus':
					$client_id = $GLOBALS['inputData']['clientId'];
					$member_id = $GLOBALS['inputData']['memberId'];
					$status_value =  $GLOBALS['inputData']['value']===TRUE?1:0;
					$global_member_status = new GlobalMemberStatus;
					$global_member_status->setStatus($client_id,$member_id,"return_mail",$status_value,GlobalMemberStatus::BOOL_STATUS_TYPE);
				break;

				case 'referralForm':
					
					$answer = 	$GLOBALS['inputData']['answer'];
					$referralId = $GLOBALS['inputData']['referralId'];
					$clientId = $GLOBALS['inputData']['clientId'];
					$memberId = $GLOBALS['inputData']['memberId'];
					$year = $GLOBALS['inputData']['year'];

					$members->referralForm($clientId,$year,$referralId,$memberId,$answer);
				break;

				case 'exclusionMemberUpdate':
					$file_name = $_FILES['file']['name'];
					$client_id = $_POST['client_id'];
					$year = $_POST['year'];
					$members -> exclusionMemberUpdate($file_name,$client_id,$year);
				break;
				
				case 'termDateUpdate':
					$file_name = $_FILES['file']['name'];
					$client_id = $_POST['client_id'];
					$year = $_POST['year'];
					$members -> termDateUpdate($file_name,$client_id,$year);
				break;

                case 'hraSaveAndStatus' :
                    $clientId = $GLOBALS['input']->{'clientId'};
                    $year = $GLOBALS['input']->{'year'};
                    $req_id = $GLOBALS['input']->{'id'};
                    $memID = $GLOBALS['inputData']['hraStatus']['memberId'];
                    $final_array = [];
                    $hraSaveData = $members->hraSaveData($clientId,$year,$req_id);
                    $hraStatusData = $members->hraStatusData($clientId,$year,$memID);
                    $hraSaveDataArray = array("hraSaveData" => $hraSaveData);
                    $hraStatusDataArray = array("hraStatusData" => $hraStatusData);
                    array_push($final_array,$hraSaveDataArray);
                    array_push($final_array,$hraStatusDataArray);
                    echo json_encode($final_array);
//                    echo $final_array;
                    return true;
                    break;
					case 'saveAddress':
						$client_id = $GLOBALS['input']->{'clientId'};
						$member_id =$GLOBALS['input']->{'memberId'};
						$year = $GLOBALS['input']->{'year'};
						//echo "<pre>".print_r($GLOBALS,1)."</pre>";exit;
						$members -> saveAddress($client_id,$year,$member_id);
					break;
			}

	  break;
	  
	  case 'GET' :
		switch($requestMethod)
		{
				case 'totalAllMember' : 
					$clientId = $_GET['clientId'];
					$year = $_GET['year'];
					$start = $_GET['min'];
					$end = $_GET['max'];
					$members->totalAllMember($clientId,$year,$start,$end);
				break;


				case 'updatehradetails' :
					$clientId = $_GET['clientId'];
					$year = $_GET['year'];

					$members->updatehradetails($clientId,$year);
					break;

				case 'efaxmonthlyreport' :
					$parameters=[];
					$parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$parameters);
					$parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$parameters);
					$parameters= ArrayUtility::appendIfVaildUrlParameter('year',$parameters);
					$parameters= ArrayUtility::appendIfVaildUrlParameter('min',$parameters);
					$parameters= ArrayUtility::appendIfVaildUrlParameter('max',$parameters);
					$parameters= ArrayUtility::appendIfVaildUrlParameter('fromdate',$parameters);
					$parameters= ArrayUtility::appendIfVaildUrlParameter('todate',$parameters);

					   $members->efaxmonthlyresult($parameters,$error);

					break;



				
				case 'getVersioningData' :
					$memberId = $_GET['id'];
					$clientId = $_GET['clientId'];
					$year = $_GET['year'];
					$members->getVersioningData($clientId,$year,$memberId);
				break;
				
				case 'singleMemberData' :
					$clientId = $_GET['clientId'];
					$year = $_GET['year'];
					$req_id = $_GET['id'];
					$members->singleMemberData($clientId,$year,$req_id);
				break;

            case 'singleMemberDataWithPrevYears' :
                $clientId = $_GET['clientId'];
                $year = $_GET['year'];
                $req_id = $_GET['id'];
                $members->singleMemberDataWithPrevYears($clientId, $year, $req_id);
                break;

				case 'totalMember' :
					$clientId = $_GET['clientId'];
					$year = $_GET['year'];
					$members->totalMember($clientId,$year);
				break;

				case 'cityList' :
					$members->getAllCities();
				break;

				case 'memberHistory' :
					$client_id = $_GET['clientId'];
					$member_id = $_GET['memberId'];
					$member_history = new MemberHistory;
					$member_history->getMemberHistory($client_id,$member_id);
				break;

				case 'previousAssessments' :
					$client_id = $_GET['clientId'];
					$member_id = $_GET['memberId'];
					$year = $_GET['year'];
					$member_history = new MemberHistory;
					$member_history->getPreviousYearAssessments($client_id,$year,$member_id);
				break;

				case 'returnMailStatus':
					$client_id = $_GET['clientId'];
					$member_id = $_GET['memberId'];
					$global_member_status = new GlobalMemberStatus;
					$global_member_status->getStatusResponse($client_id,$member_id,"return_mail",GlobalMemberStatus::BOOL_STATUS_TYPE);
				break;

				

            case 'runhraSaveApi' :
                $clientId = $_GET['clientId'];
                $year = $_GET['year'];
                $table = $_GET['table'];
                $members->runhraSaveApi($clientId,$year,$table);
                break;

			case 'queryform':
				$clientId = $_GET['clientId'];
				$year = $_GET['year'];
				$req_id = $_GET['id'];
				$members->queryform($clientId, $year, $req_id);
				break;
		}
	  break;
	  
  }
?>