<?php

    /*
        MEMBER RELATED DAB CALLS
        class : MemberDatabaseQuery
    */

    class MemberDatabaseQuery 
    {

        /*
            NAME    : totalMemberQueryWithPreviousAssessment
            TYPE    : global Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function totalMemberQueryWithPreviousAssessment($client_id,$year,$min,$max)
        {
            $previous_year = $year-1;
            return "SELECT
                        member_table.*,
                        schedulerTable.username AS scheduler_name,
                        schedulerTable.firstname AS scheduler_firstname,
                        schedulerTable.lastname AS scheduler_lastname,
                        member_global_status.return_mail,
                    IF(
                        JSON_LENGTH(
                            member_table_previous_year.hraStatusHistory,
                            '$.readyForQa'
                        ) > 0,
                        JSON_UNQUOTE(
                            JSON_EXTRACT(
                                member_table_previous_year.hraStatusHistory,
                                CONCAT(
                                    '$.readyForQa[',
                                    JSON_LENGTH(
                                        member_table_previous_year.hraStatusHistory,
                                        '$.readyForQa'
                                    ) -1,
                                    '].date'
                                )
                            )
                        ),
                        NULL ) AS previousAssessmentDate
            
                    FROM
                    (
                        SELECT * FROM HRA_member_".$client_id.'_'.$year." limit $min,$max
                    ) AS member_table
                    LEFT JOIN hra_member_global_status AS member_global_status
                    ON
                        member_global_status.member_id = member_table.member_id
                    LEFT JOIN userLogin AS schedulerTable
                    ON
                        schedulerTable.userUniqueno = member_table.scheduler_id
                    LEFT JOIN HRA_member_".$client_id."_".$previous_year." AS member_table_previous_year
                    ON
                        member_table_previous_year.member_id = member_table.member_id
                    ORDER BY
                        member_table.id";

        }

    
    /*
        NAME    : totalMemberQuery
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */   
    public static function totalMemberQuery($client_id,$year,$min,$max)
    {

        return "SELECT 
                member_table.*, 
                schedulerTable.username AS scheduler_name,schedulerTable.firstname AS scheduler_firstname,
                schedulerTable.lastname AS scheduler_lastname,
                member_global_status.return_mail,
                NULL as previousAssessmentDate
                FROM ( SELECT * FROM HRA_member_".$client_id.'_'.$year." limit $min,$max) as member_table
                LEFT JOIN hra_member_global_status AS member_global_status ON member_global_status.member_id = member_table.member_id 
                LEFT JOIN userLogin as schedulerTable ON schedulerTable.userUniqueno = member_table.scheduler_id 
                ORDER BY member_table.id";
    }

}


?>