<?php

/*
	MEMBER HISTORY UTILTIY CLASS 
	Created On : 01/12/2020 
*/

require_once("../utility/DataBaseUtility.php");
require_once("../global/GlobalMemberStatus.php");
									
class MemberHistory
{
		/*
			get member history
		*/
		public function getMemberHistory($client_id,$member_id)
		{

			include("../db.php");

			//global status - return mail
			$global_member_status = new GlobalMemberStatus;
			$return_mail_status=$global_member_status->getStatus($client_id,$member_id,"return_mail",GlobalMemberStatus::BOOL_STATUS_TYPE);
			$return_mail = isset($return_mail_status['value'])?($return_mail_status['value']==1?true:false):false;
			
			
			$member_history_response = new stdClass();
			//sql query to get all client list 
			$client_list_query = "select * from HRA_client where clientId = '$client_id'";
			try 
			{	
				
				$client_list_query_result=mysqli_query($conn,$client_list_query);
				//fetch the client info
				$client_info_row = mysqli_fetch_array($client_list_query_result,MYSQLI_ASSOC);
				
				if($client_info_row)
				{
					
					$client_years =$client_info_row['year'];
					$client_name =$client_info_row['client_name'];

					$client_year_array = explode(",",$client_years);
					$client_years_count = count($client_year_array);

					$member_details = null;
					for($y=0;$y<$client_years_count;$y++)
					{
						$member_data=$this->getMemberData($client_id,$client_year_array[$y],$member_id);
						if($member_data)
						{
							$hra_demographic_data = $this->getMemberDemographic($client_id,$client_year_array[$y],$member_id);
							$urls = $this->getMemberRelatedUrls($client_id,$client_year_array[$y],$member_id);
							$member_details[] = array("year"=>$client_year_array[$y],
														"data"=>$member_data,
														"demographic"=>$hra_demographic_data,
														"url"=>$urls);
						}
					}

					$member_history_response->status = "success";
					$member_history_response->returnMail = $return_mail;
					$member_history_response->history = $member_details;
				}
				
	
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				$member_history_response->status = "failed";
				$member_history_response->history = null;
				$member_history_response->error = $error;
			}
			
			echo json_encode($member_history_response);
		}

		/*
			NAME : getPreviousYearAssessment
			DETAILS : get member history
			RETURN:
		*/
		public function getPreviousYearAssessments($client_id,$year,$member_id)
		{
			//database  connection
			include("../db.php");
			//member history
			$member_history_response = new stdClass();

			try 
			{	
				$member_details = null;
				
				DataBaseUtility::runSqlQueryOnClientYears($client_id,
					function($client_id,$client_year) use ($year,$member_id,&$member_details) 
						{
							if($client_year<$year)
							{
								$member_data = DataBaseUtility::getMemberDataBaseFields($client_id,$client_year,$member_id,
													["firstname","hraStatus","scheduleDate","termDate"]
													);
								$review_result = $this->getAssessmentReviewStatus($client_id,$client_year,$member_id);
								if($member_data)
								{
									$review_status = $review_result["review_status"]?"yes":"no";
									$member_details[] = array("year"=>$client_year,"reviewStatus"=>$review_status,"data"=>$member_data);
								}
							}		
						}
				);

				$member_history_response->status = "success";
				$member_history_response->previousAssessment = $member_details;
				
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				$member_history_response->status = "failed";
				$member_history_response->history = null;
				$member_history_response->error = $error;
			}
			
			echo json_encode($member_history_response);

		}

		
		/*
			NAME : reviewAssessmentStatus
			DETAILS :
			RETURN:
		*/
		public function reviewAssessmentStatus($client_id,$year,$member_id,$review_status)
		{
			include("../db.php");
			//get the assessment review status 
			$review_result = $this->getAssessmentReviewStatus($client_id,$year,$member_id);
			$review_response = new stdClass();
			$review_response->status = "success";
			//echo json_encode($review_result);
			//if review not avaiable for member in cleint and specific year
			if($review_result["is_member"]===false)
			{
				$result=$this->insertAssessmentReviewStatus($client_id,$year,$member_id,$review_status);
				if($result) {$review_response->status = "success";}else{$review_response->status = "failed";}
			}
			else
			{
				$result=$this->setAssessmentReviewStatus($client_id,$year,$member_id,$review_status);
				if($result) {$review_response->status = "success";}else{$review_response->status = "failed";}
			}

			echo json_encode($review_response);

		}

		/*
			NAME : getAssessmentReviewStatus
			DETAILS : 
			RETURN:
		*/
		public function getAssessmentReviewStatus($client_id,$year,$member_id)
		{

			include("../db.php");
			//prepare sql query for user avaiable or not check
            $user_query=$conn->prepare('SELECT * from hra_member_assessments WHERE client_id =  ? and year = ? and member_id = ?');
                $user_query->bind_param('sis',$client_id,$year,$member_id);
                $user_query->execute();
                $user_result = $user_query->get_result();
            $user_array=$user_result->fetch_assoc();
			
			if($user_array)
			{
				if($user_array["review_status"]==1)
				{
					return array("is_member"=>true,"review_status"=>true);
				}
				else
				{
					return array("is_member"=>true,"review_status"=>false);
				}
			}

			return array("is_member"=>false,"review_status"=>false);
		}

		/*
			NAME : setAssessmentReviewStatus
			DETAILS : 
			RETURN:
		*/
		private function insertAssessmentReviewStatus($client_id,$year,$member_id,$review_status)
		{
			include("../db.php");
			//prepare sql query for user avaiable or not check
            $user_query=$conn->prepare('INSERT IGNORE INTO hra_member_assessments (client_id,year,member_id,review_status) VALUES(?,?,?,?)');
           	$user_query->bind_param('sisi',$client_id,$year,$member_id,$review_status);
            $user_query->execute();
			return $user_query->affected_rows;
		}

		/*
			NAME : setAssessmentReviewStatus
			DETAILS : 
			RETURN:
		*/
		private function setAssessmentReviewStatus($client_id,$year,$member_id,$review_status)
		{
			include("../db.php");
			//prepare sql query for user avaiable or not check
            $user_query=$conn->prepare('update hra_member_assessments set review_status=? where client_id=? and year=? and member_id=?');
            $user_query->bind_param('isis',$review_status,$client_id,$year,$member_id);
            $user_query->execute();
			return $user_query->affected_rows;
		}

		/*
			get member data based on client and year
		*/
		private function getMemberData($client_id,$year,$member_id)
		{

			include("../db.php");
			//client year members
			$client_year_members = null;
			$member_details_sql_query = "select member_table.*, client_table.client_name as client_name,scheduler_table.username as scheduler_name , nurse_table.firstname as nurse_firstname , 
				nurse_table.userInfo nurse_info ,admin_table.username as admin_username from 
				( select * from HRA_member_".$client_id.'_'.$year." where member_id='".$member_id."' ) as member_table 
				LEFT JOIN userLogin as scheduler_table ON scheduler_table.userUniqueno = member_table.scheduler_id 
				LEFT JOIN userLogin as nurse_table ON nurse_table.userUniqueno = member_table.nurse_id 
				LEFT JOIN HRA_client as client_table ON client_table.clientId = '".$client_id."'
				LEFT JOIN userLogin as admin_table ON admin_table.userUniqueno = member_table.admin_idno order by member_table.id";

			$member_details_result=mysqli_query($conn,$member_details_sql_query);
			$member_row = mysqli_fetch_array($member_details_result,MYSQLI_ASSOC);
			
			if($member_row)
			{
				$nurse_id = $member_row['nurse_id'];
				$query_form = $member_row['query_form'];
				$scheduler = $member_row['scheduler'];
				$admin_idno = $member_row['admin_idno'];
				$memberinfo = $member_row['memberinfo'];
				$scheduleDate = $member_row['scheduleDate'];
				$termDate = $member_row['termDate'];
				$EvaluationDate = $member_row['EvaluationDate'];
				$hraStatus = $member_row['hraStatus'];
				$visitType = $member_row['VisitType'];
				$versioning = $member_row['versioning'];
				$qaid = $member_row['qa_id'];
				$coderid = $member_row['coder_id'];
				$scheduler_name = $member_row['scheduler_name'];
				$scheduler_id = $member_row["scheduler_id"];
				$hra = $member_row['hra'];
				$uploadedfiles = $member_row['uploadedfiles']; 
				$hra_status_history = $member_row['hraStatusHistory'];
				$hra_cancel_history =$member_row['cancelHistory'];
				$nurse_firstname = $member_row['nurse_firstname'];
				$nurse_info = $member_row['nurse_info'];
				$admin_username = $member_row['admin_username'];
				$client_name = $member_row['client_name'];
				$sent_to_avility = $allpatientinfo_row['sentToAvility'];
				$invoice_date = $allpatientinfo_row['invoiceDate'];
				$notes = $allpatientinfo_row['reportNotes'];
				$refusal_letter_date = $member_row['refusalLetterDate'];
				
				$client_year_member=array("nurseid"=>$nurse_id,"nurseFirstName"=>$nurse_firstname,"memberinfo"=>$memberinfo,"schedulerName"=>$scheduler_name,
									"schedulerId"=>$scheduler_id,"scheduleDate"=>$scheduleDate,"termDate"=>$termDate,"EvaluationDate"=>$EvaluationDate,
									"qaid"=>$qaid,"coderid"=>$coderid,"hraStatus"=>$hraStatus,"visitType"=>$visitType,
									"versioning"=>$versioning,"clientName"=>$client_name,"adminUserName"=>$admin_username,
									"ccd"=>$uploadedfiles,"nurseinfo"=>$nurse_info,"query_form"=>$query_form,"scheduler"=>$scheduler,
									"hraStatusHistory"=>$hra_status_history,"cancelHistory"=>$hra_cancel_history,"sentToAvility"=>$sent_to_avility,
									"invoiceDate"=>$invoice_date,"notes"=>$notes,"refusalLetterDate"=>$refusal_letter_date);
					
				
				return $client_year_member;
			}

			return null;

		}

		/*
			get the members demographic details 
			demographic details of the member store in hrajson file of member
			based on client,year and member id
		*/
		private function getMemberDemographic($client_id,$year,$member_id)
		{
			$json_file_path = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
			if(file_exists($json_file_path))
			{
				$file_content = file_get_contents($json_file_path);
				$hra_json_array = json_decode($file_content,true);
				if($hra_json_array)
				{
					$array_count = count($hra_json_array);
					if($array_count)
					{
						if(array_key_exists('data', $hra_json_array))
						{
							$hra_data_count = count($hra_json_array["data"]);
							if($hra_data_count)
							{
								$first_index_value=$hra_json_array["data"][0];
								if($first_index_value)
								{
									if(array_key_exists('q', $first_index_value))
									{
										$q_value=$first_index_value["q"];
										$q_value_count = count($q_value);
										if($q_value_count)
										{
											return $q_value[0];
										}
									}
								}
							}
						}
					}
				}

			}

			return null;
		}

		/*
			get the member related urls
		*/
		private function getMemberRelatedUrls($client_id,$year,$member_id)
		{
			//remove direct folder access
			return array_push($url_array,array("type"=>'pdf',"url"=>null));;

		}
}
?>