<?php

    /*
        MEMBER RELATED UTILTIY FUNCTION
    */

    require_once("../TimeZone.php");
    require_once("../utility/DataBaseUtility.php");
    require_once("../utility/DateUtility.php");
    require_once("../utility/ArrayUtility.php");
    require_once("../scheduler/SchedulerApiClass.php");
    require_once("../scheduler/SchedulerUtility.php");
    require_once("../report/ReportStatus.php");
    require_once("../scheduler/SchedulerCallOrderUtility.php");
  
    class MemberUtility
    {  
        
        /*
            GLOBAL CONST VALUES
        */
        //API CALL TYPE
        const API_SCHEDULED_DATE = 0;
        const API_UNSCHEDULED_DATE = 1;
        const API_HRA_STATUS = 2;

        //NON HRA STATUS
        const UNKNOWN = -99;
        const CODER_ASSIGNED =-2;
        const QA_ASSIGNED = -1;
        //HRA STATUS 
        const UNSCHEDULED = 0;
        const SCHEDULED = 1;
        const IN_PROGRESS=2;
        const APPOINTMENT_CANCELLED=3;
        const PATIENT_REFUSAL=4;
        const UTC=5;
        const READY_FOR_QA=6;
        //const QA_IN_PROGRESS=7;
        const READY_FOR_CODER=7;
        //const CODING_IN_PROGRESS=9;
        const CLINICIAN_REVIEW_QA=8;
        const CLINICAIN_REVIEW_CODER=9;
        const READY_FOR_UPLOAD=10;
        const COMPLETED=11;
        const ASSESSMENT_CANCELLED=12;
        const PRE_SCHEDULED=13; //remove on hra updated
        const IN_ELIGIBILE=14;
        const DECEASED=15;
        const HOSPICE=16;
        const OTHER=17;
        const TERM_EXPIRED=18;
        const NO_SHOW=19;
        const HRA_NOT_DUE=20;

        //CALL LOG RESULT CONSTANT
        const CALL_RESULT_UNSCHEDULED = -1;//unused status
        const CALL_RESULT_SCHEDULED  = 0;
        const CALL_RESULT_DEAD_AIR  = 1;
        const CALL_RESULT_INELIGIBLE  = 2;
        const CALL_RESULT_NO_ANSWER  = 3;
            //no answer sub field
            const LEFT_VOICEMAIL = (self::CALL_RESULT_NO_ANSWER*10)+0;//30
            const MAILBOX_FULL   = (self::CALL_RESULT_NO_ANSWER*10)+1;//31
            const NO_VM_SETUP    = (self::CALL_RESULT_NO_ANSWER*10)+2;//32
        const CALL_RESULT_WRONG_NUMBER  = 4;
        const CALL_RESULT_DECEASED  = 5;
        const CALL_RESULT_CALL_BACK_REQUESTED  = 6;
        const CALL_RESULT_LINE_BUSY  = 7;
        const CALL_RESULT_HOSPICE  = 8;
        const CALL_RESULT_REFUSAL  = 9;
        const CALL_RESULT_DISCONNECTED  = 10;
        const CALL_RESULT_OTHER  = 11;
        const CALL_RESULT_RESCHEDULED  = 12;
        const CALL_RESULT_CALLER_DISCONNECTED = 13;
        const CALL_RESULT_F2F_CALLBACK = 14;

        //call order 
        const DEFAULT_NOTIFICATION_CALL_ORDER = 0;
        const DEFAULT_CALL_ORDER = 1;
        const DEFAULT_USER_ORDER = 50;

        /*
            NAME : OnMemberCallLogChanged
            TYPR : CALLBACK EVENT
            DETAILS : this call log changed event function act as event to capture whenever calllog api called
                    in member class

                    FRONT END ORDER OF EXECUTION : when submit calllog with scheduled option selected (appointmentDate) ,networt api call
                        =>callLog => scheduleDate => assignMember =>visitType => HraStatus
                        OTHER WISE
                        =>callLog
            { 
                "utc": false, "result": 0, "callLog": [
                
                    {
                        "date": "9/9/2020 @ 12:56 PM", ///date on which call log created
                        "result": 0, //call log type ( scheduled,Rescheduled,NoAnswer,)
                        "comment": "",
                        "noAnswer": -1, // of no answer than used to store sub type [ 1.Left Voicemail,2.Mailbox Full ,3.No Vm Setup ]
                        "scheduler": "test schedulerFE"
                    }, 

                ]
            }
        */
        public static function OnMemberCallLogChanged($client_id,$year,$member_id,$scheduler_request_data)
        {
            $call_log_response = array("disabled_status"=>false,"attempt_count"=>0,"hra_status"=>null);
            $disabled_status = false;
            //what current call result value when scheduler save log details
            $scheduler_current_call_result = $scheduler_request_data["data"]["result"];
            $call_log = $scheduler_request_data["data"]["callLog"];
            
            //read the member hraStatus and scheduler details
            $member_details = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,["hraStatus","schedulerDetails","schedulerCallHraStatus","schedulerCallLogDetails"]);
            $hra_status_array = json_decode($member_details["hraStatus"],true);
            $scheduler_details_array = json_decode($member_details["schedulerDetails"],true);
            $previous_scheduler_hra_status_array = json_decode($member_details["schedulerCallHraStatus"],true);
            $scheduler_call_log_details = json_decode($member_details["schedulerCallLogDetails"],true);
            //hrastatus details
            $call_log_response["hra_status"]=$hra_status_array;
            //check for scheduler details because scheduler lead created call log without assign 
            //scheduler consider scheduler lead himself as a scheduler so new create scheduler details 
            if($scheduler_details_array==NULL && count($call_log)>0)
            {
                $scheduler = new SchedulerApiClass;
                $scheduler_full_name_array = explode(" ",$call_log[0]["scheduler"]);
                if(count($scheduler_full_name_array)>1)
                {
                    $scheduler_firstname = $scheduler_full_name_array[0];
                    $scheduler_lastname = $scheduler_full_name_array[1];
                    $scheduler_user_info = DataBaseUtility::getUserIdByFullName($scheduler_firstname,$scheduler_lastname);
                    if($scheduler_user_info)
                    {
                        $scheduler_lead_id = $scheduler_user_info['userUniqueno'];
                        $scheduler_id = $scheduler_lead_id;
                        //issue in calllog time and scheduler assigned time beabecause call log created earlier
                        //so slove this issue first call log with out scheduler assigned than call log time consider as scheduler 
                        //assigned time
                        $custom_date_time = null;
                        $active_calllog_date = $call_log[0]['date'];
                        if(DateUtility::validateScheduledDate($active_calllog_date,'n/j/Y @ h:i A'))
                        {
                            $custom_date_time = DateUtility::convertDateFormat($active_calllog_date,'n/j/Y @ h:i A',"m-d-Y H:i:s");
                        }

                        $scheduler->assignSchedulerLeadHimSelfToMember($client_id,$year,$member_id,$scheduler_lead_id,$scheduler_id,$custom_date_time);
                        //$current_date_time = date('m-d-Y H:i:s');
                        //after updated get the scheduler details
                        $member_details = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,["schedulerDetails"]);
                        $scheduler_details_array = json_decode($member_details["schedulerDetails"],true);
                    }
                }
            }

            //*this code should not be above because no scheduler assigned means attemptCount made zero when self assigned
            //raise call log add event to call calculate attempt count
            $attempt_count=self::OnCallLogAdded($client_id,$year,$member_id,$scheduler_current_call_result,$call_log);
            
            //still no scheduler details done nothing
            if($scheduler_details_array==NULL)
            {
                $call_log_response["attempt_count"]=$attempt_count;
                $call_log_response["disabled_status"]=$disabled_status;
                return $call_log_response;
            }
            
            $recent_scheduled_date = SchedulerUtility::getRecentSchedulerAssignedDate($scheduler_details_array);
            $recent_call_logs = self::getRecentCallLogAsArray($call_log,$recent_scheduled_date);
            //only after the recent call log contains 5 call log after the recent scheduler assigned
            //echo json_encode($recent_call_logs)."\n";
            //check for appointment info with current date the skip for below 
            //scheduler status condition 
            $disabled_status = SchedulerUtility::OnCallLogSchedulerCallHraStatus($client_id,$year,$member_id,$scheduler_current_call_result,$recent_call_logs,$hra_status_array,true,null,$previous_scheduler_hra_status_array);
            //previous scheduler hra status
            //already this member scheduler hra status in disabled mode than return false;
            //if any changes in hra status 
            $updated_member_details = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,["hraStatus","reportStatus"]);
            if($disabled_status)
            {
                $updated_hra_status_array = json_decode($updated_member_details["hraStatus"],true);
                $call_log_response["hra_status"]=$updated_hra_status_array;
                
                if($previous_scheduler_hra_status_array)
                {
                    $scheduler_hra_status=$previous_scheduler_hra_status_array['status'];
                    if( $scheduler_hra_status==SchedulerUtility::MOVE_TO_UTC_FIVE_DISPOSITIONS || 
                        $scheduler_hra_status==SchedulerUtility::DISCONNECT_WRONG_NUMBER )
                        {
                            $disabled_status=false;
                        }
                }
            }

            $call_log_response["report_status"]="";
            $call_log_response_report_status=json_decode($updated_member_details["reportStatus"],true);
            if(is_array($call_log_response_report_status) && array_key_exists('text',$call_log_response_report_status))
            {
                $call_log_response["report_status"]=trim($call_log_response_report_status['text']);
            }
            
            $call_log_response["attempt_count"]=$attempt_count;
            $call_log_response["disabled_status"]=$disabled_status;
            return $call_log_response;

        } 

        /*
            NAME    : OnCallLogAdded
            TYPE    : internal event function 
            DETAILS : when call log added ,append attempt count by 1 and store the attempt count in 'schedulerCallLogDetails' column as json format
        */
        public static function OnCallLogAdded($client_id,$year,$member_id,$scheduler_current_call_result,$call_log)
        {
            $attempt_count=0;
            $member_details = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,["schedulerCallLogDetails"]);
            $scheduler_call_log_details = json_decode($member_details["schedulerCallLogDetails"],true);
            if($scheduler_call_log_details)
            {
                $scheduler_call_log_details=ArrayUtility::incrementValueByKey($scheduler_call_log_details,'attemptCount',1);
            }
            else
            {
                $scheduler_call_log_details=SchedulerUtility::generateSchedulerCallLogDetails(1);
            }

            if($scheduler_call_log_details)
            {
                $attempt_count = $scheduler_call_log_details["attemptCount"];
            }

           //updated database columns
           $column_name_list =['schedulerCallLogDetails'];
           $column_value_list=[json_encode($scheduler_call_log_details)];
           DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);

            //***** OnCallLogReportStatusChanged *******/
           //capture the sub call result values
            $sub_call_result = -1;
            if(is_array($call_log))
            {
                    if(count($call_log)>0)
                    {
                        $recent_call_log = $call_log[0];
                        $sub_call_result = $recent_call_log['noAnswer'];
                    }
            } 
            self::OnCallLogReportStatusChanged($client_id,$year,$member_id,$scheduler_current_call_result,$sub_call_result);

            SchedulerUtility::OnCallLogAddedEvent($client_id,$year,$member_id);

           return $attempt_count;

        }

        /*
            NAME    : SetCallLogAttemptCount
            TYPE    : global event function 
            DETAILS : set call log attempt count directly,this method used for clear and set specific call log attempt count
        */
        public static function SetCallLogAttemptCount($client_id,$year,$member_id,$attempt_count)
        {
            $member_details = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,["schedulerCallLogDetails"]);
            $scheduler_call_log_details = json_decode($member_details["schedulerCallLogDetails"],true);
            if($scheduler_call_log_details)
            {
                $scheduler_call_log_details=ArrayUtility::updateValueByKey($scheduler_call_log_details,'attemptCount',$attempt_count);
            }
            else
            {
                $scheduler_call_log_details=SchedulerUtility::generateSchedulerCallLogDetails($attempt_count);
            }

           //updated database columns
           $column_name_list =['schedulerCallLogDetails'];
           $column_value_list=[json_encode($scheduler_call_log_details)];
           return DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
           //updated call log attempt details

        }

         /*
            NAME : OnMemberRegister
            TYPE : global Static Utiltiy function 
            DETAILS : this callback function called when new memeber register
        */
        public static function OnMemberRegister($client_id,$year,$member_id,$member_info_array)
        {
            include("../db.php");
        
            //member info related info update
            if($member_info_array && is_array($member_info_array))
            {
                //check member city and update if not avaialble in 'Hra_member_city' table
                $city_name=$member_info_array['Member_City'];
                $state_name=$member_info_array['Member_State'];
                DataBaseUtility::insertMemberCityIfNotAvailable($city_name,$state_name);

                //check members lob and update if not avilable
                $member_lob=trim($member_info_array['LOB']);
                if(isset($member_lob))
                {
                    DataBaseUtility::AddLobIfNotAvailable($client_id,$year,$member_lob);
                }

            }

        }

        /*
            NAME        : AvailForSchedulerWhenImportBasedOnHraStatus
            TYPE        : internal Static Utiltiy function 
            PARAMETERS  : 
            RETURN      : 
        */
        private static function AvailForSchedulerWhenImportBasedOnHraStatus($connection,$client_id,$year,$member_id)
        {
            
            $response_array = array("status"=>false,"hraStatus"=>MemberUtility::UNSCHEDULED);
            
                $member_table_sql_query = "SELECT member_id,hraStatus FROM HRA_member_".$client_id."_".$year;
                $member_hra_status_query = $connection->prepare($member_table_sql_query.' WHERE member_id = ?');
                $member_hra_status_query->bind_param('s',$member_id);
                $member_hra_status_query->execute();
                $member_hra_status_result = $member_hra_status_query->get_result();
    
                $member_detail = $member_hra_status_result->fetch_assoc();
    
                if($member_detail)
                {
                    $hra_status_array = json_decode($member_detail['hraStatus'],true);
                    if($hra_status_array)
                    {
                        if(is_array($hra_status_array) && array_key_exists('hraStatus',$hra_status_array))
                        {
                            $hra_status =  $hra_status_array['hraStatus'];
                            $response_array = array("status"=>false,"hraStatus"=>$hra_status);
                            switch($hra_status)
                            {
                                case MemberUtility::APPOINTMENT_CANCELLED:
                                case MemberUtility::UTC:
                                case MemberUtility::ASSESSMENT_CANCELLED:
                                case MemberUtility::TERM_EXPIRED:
                                case MemberUtility::NO_SHOW:
                                    $response_array = array("status"=>true,"hraStatus"=>$hra_status);
                                break;
                            }
                        }
                    }
                }
    
            return $response_array;
        }

         /*
            NAME    : OnApiEvent
            TYPE    : global Static Utiltiy function 
            PARAMETERS : type = api call type , $status - api call success or not
            RETURN : 
        */
        public static function OnApiEvent($client_id,$year,$member_id,$type,$status,$api_data)
        {
//echo "hie";

            $result_array = array("status"=>false,"isAttemptCountChanged"=>false);
            switch($type)
            {
                case self::API_HRA_STATUS:
                    //if hra status successfully updated
                    if($status)
                    {
                        $hra_status_array = $api_data;
                        //when hra status move to no show status
                        if($hra_status_array)
                        {
                            $result_array=self::OnHraStatusChanged($client_id,$year,$member_id,$hra_status_array);
                        }
                    }
                break;

                case self::API_SCHEDULED_DATE:
                    //change the scheduler call hra status also
                    TimeZone::useTimeZone();
                    $current_date = date('m-d-Y H:i:s');
                    $details = "scheduled directly";
                    $result_array["status"]=DataBaseUtility::updateSchedulerCallHraInDatabase($client_id,$year,$member_id,SchedulerUtility::SCHEDULED,$current_date,$details,false);
                break;

                case self::API_UNSCHEDULED_DATE:
                    //change the scheduler call hra status also
                    TimeZone::useTimeZone();
                    $current_date = date('m-d-Y H:i:s');
                    $details = "unscheduled directly";
                    $result_array["status"]=DataBaseUtility::updateSchedulerCallHraInDatabase($client_id,$year,$member_id,SchedulerUtility::UNSCHEDULED,$current_date,$details,false);
                    $result_array["isAttemptCountChanged"]=self::SetCallLogAttemptCount($client_id,$year,$member_id,0);
                    $result_array["attemptCount"]=0;
                break;
            }

            return $result_array;
        }

        /*
            NAME    : OnHraStatusChanged
            TYPE    : global Static Utiltiy function 
            DETAILS : 
            RETURN : 
        */
        private static function OnHraStatusChanged($client_id,$year,$member_id,$hra_status_array)
        {
            //report status 
            self::OnHraReportStatusChanged($client_id,$year,$member_id,$hra_status_array);

            $result_hra_status_result = array("status"=>false,"isAttemptCountChanged"=>false,"attemptCount"=>-1);
            switch($hra_status_array['hraStatus'])
            {
                case self::APPOINTMENT_CANCELLED:
                case self::ASSESSMENT_CANCELLED:
                case self::NO_SHOW:
                    //set call order to show what order that member shown in dashboard
                    SchedulerCallOrderUtility::setCallOrder($client_id,$year,$member_id,SchedulerCallOrderUtility::CANCELLATION_ORDER);
                    //update member avail for schedule status
                    $availForSchedule=1;
                    DataBaseUtility::updateMemberScheduleStatus($client_id,$year,$member_id,$availForSchedule);
                    //change the scheduler call hra status also
                    TimeZone::useTimeZone();
                    $current_date = date('m-d-Y H:i:s');
                    $details = "hra status changed";
                    //this functionality only work with scheduler dashboard mmebers
                    //direct hra status won't work
                    $member_scheduler_details = SchedulerUtility::getSchedulerDetailsAndCallHraStatus($client_id,$year,$member_id);
                    $member_scheduler_id = $member_scheduler_details['schedulerId'];
                    $scheduler_call_hra_status = $member_scheduler_details['schedulerCallHraStatus'];
                    $scheduler_details_array = $member_scheduler_details['schedulerDetails'];
                    if( $scheduler_call_hra_status && is_array($scheduler_call_hra_status) )
                    {
                        $scheduler_notification = null;
                        $call_hra_status = $scheduler_call_hra_status['status'];
                        //only for scheduled members by scheduler call result
                        if($call_hra_status==SchedulerUtility::SCHEDULED)
                        {
                            // nofitication format
                            // "notification": {"type": 0, "value": "", "previous_status": 3}
                            $scheduler_notification = SchedulerUtility::generateSchedulerNotification(SchedulerUtility::SCSN_NO_SHOW_CANCELLATION,
                                                                                SchedulerUtility::SCHEDULED,"");
                           
                            $details = "scheduled member moved to no show/cancellation";
                        }

                        $result_hra_status_result["status"]=DataBaseUtility::updateSchedulerCallHraInDatabase($client_id,$year,$member_id,
                                                SchedulerUtility::UNSCHEDULED,$current_date,$details,false,
                                               $scheduler_notification);
                        
                        if($result_hra_status_result &&  $scheduler_notification)
                        {
                            //{"mail_details": [], "scheduler_details": [{"date": "01-26-2021 10:00:00", "schedulerId": "87014190", "schedulerLeadId": "87014190"}]}
                            //re-assign the same scheduler again for restart the 2 call log process
                            $recent_scheduler_detail=SchedulerUtility::getRecentSchedulerAssignedDetails($scheduler_details_array);
                           
                            if($recent_scheduler_detail)
                            {
                                $scheduler_id = $recent_scheduler_detail['schedulerId'];
                                $scheduler_lead_id = $recent_scheduler_detail['schedulerLeadId'];
                                if($member_scheduler_id==$scheduler_id) //update only when scheduler id matched
                                {
                                    $scheduler_api = new SchedulerApiClass;
                                    $appended_result=$scheduler_api->appendSchedulerDetails($client_id,$year,$member_id,$scheduler_lead_id,$scheduler_id);
                                    $db_result = $appended_result['success'];
                                    $scheduler_details_json = $appended_result['updated_scheduler_details'];
                                    if($db_result)
                                    {
                                        //updated other database columns
                                        $column_name_list =['schedulerDetails'];
                                        $column_value_list=[$scheduler_details_json];
                                        DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
                                    }
                                }
                                else
                                {
                                    //then their is a bug
                                }

                            }
                        }
                    }
                    else
                    {
                        $result_hra_status_result["status"]=DataBaseUtility::updateSchedulerCallHraInDatabase($client_id,$year,$member_id,
                                            SchedulerUtility::UNSCHEDULED,$current_date,$details,false,
                                            null);
                    }
                    
                    //need to updated scheduler assigned to this date to get recent call log list
                    
                    //reset call attempt count
                    $result_hra_status_result["isAttemptCountChanged"]=self::SetCallLogAttemptCount($client_id,$year,$member_id,0);
                    $result_hra_status_result["attemptCount"]=0;
                break;

  case self::IN_PROGRESS :
                    include("../db.php");
                    //	echo $member_id;echo "<br>";
                     $update_hradata = "select * from HRA_member_".$client_id.'_'.$year." where member_id ='$member_id'";
                //echo "accc";
                
                    $updatehradataresult=mysqli_query($conn,$update_hradata);
                    $hrajson_data = $GLOBALS['inputData']['data'];
                    $hra_username = $GLOBALS['input']->{'hraUsername'};
                    $user_type = $GLOBALS['input']->{'userType'};
                    $hrajson_dataa = json_encode($hrajson_data);
                    if(mysqli_num_rows($updatehradataresult) == 1){
                        $allhramember_row=mysqli_fetch_array($updatehradataresult,MYSQLI_ASSOC);
                
                         $hraStatus = $allhramember_row['hraStatus']; 
                
                        // if($hraStatus == "1" || $hraStatus == "0" || $hraStatus == null)
                        // {
                        //    $HraStatusresp = 1; 
                        // }
                        // else
                        // {
                        //    $arraData = json_decode($hraStatus,true);
                        //    $HraStatusresp =  $arraData['hraStatus']; 	
                        // }
                        $db_status = "not updated";
                       // echo "sd";
                       // echo $user_type;die;
                        if($user_type =="nurse"){
                       //     print_r($hra_status_array);die;
                          //  $staticStatus =	'{"hraStatus": 2, "subStatus": "", "cancelStatus": "","cancelText": ""}';
                           $staticStatus =  json_encode($hra_status_array);
                    //   echo "fdf";
                    //   echo $HraStatusresp;die;
                          //  if($HraStatusresp == 1 || $HraStatusresp == 0 || $HraStatusresp == null || $HraStatusresp == 2){
                                $hra_status = $hra_status_array['hraStatus'];
                               $member = new members;
                               $resultData =   $member->addHraStatusHistory($client_id,$year,$member_id,$hra_status,$hra_username);
                               $result_success = $resultData['success'];
                               $hra_history_updated = $resultData['updatedJsonHistory'];
                               
                               $updateInprogressStatus ="";
                               if($result_success)
                               {
                                  $updateInprogressStatus = "update HRA_member_".$client_id.'_'.$year." set hraStatusHistory='$hra_history_updated' , hraStatus='$staticStatus' where member_id ='$member_id'";
                               }
                               else
                               {
                                 $updateInprogressStatus = "update HRA_member_".$client_id.'_'.$year." set hraStatus='$staticStatus' where member_id ='$member_id'";
                               }
                               try 
                               {
                                   $updateInprogressStatusResult=mysqli_query($conn,$updateInprogressStatus);
                                   $db_status = "updated";
                               }
                               catch (Exception $e)
                               {
                                   $error = $e->getMessage();
                               }
                
                
                          //  }
                
                        }
                
                        $hra_file_change = new HraFileChangesUtility;
                       // $member_id = $req_id;
                        $hra_json_content=$hrajson_dataa;
                        $hra_file_change->onHraFileUpdatedHistory($client_id,$year,$member_id,$hra_json_content);
                        /* $fileepath = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
                        $statusjson = file_put_contents($fileepath,$hrajson_dataa);
                        $permit = FileIOUtility::HRA_JSON_FILE_PERMISISON;
                        chmod($fileepath, $permit);
                
                        if($statusjson != 0)
                        {
                            $response = new stdClass();
                            $response->status = 'updated';
                            $response->db_status = $db_status;
                            $response = json_encode($response);
                         
                
                        }
                        else
                        {
                            $response = new stdClass();
                            $response->status = 'notupdated';
                            $response->db_status = $db_status;
                            $response = json_encode($response);
                           
                        } */
                
                    }
                  //  echo $response;die;
                    
                    
                break;

                case self::UTC:
                    SchedulerUtility::OnSchedulerCallHraStatusChanged(SchedulerUtility::MOVE_TO_UTC_FIVE_DISPOSITIONS,$client_id,$year,$member_id,null,null,false);
                break;
            }

            return $result_hra_status_result;
        }


         /*
            NAME    : OnReportStatusChanged
            TYPE    : global Static Utiltiy function 
            DETAILS : 
            RETURN : 
        */
        private static function OnHraReportStatusChanged($client_id,$year,$member_id,$hra_status_array)
        {
            switch($hra_status_array['hraStatus'])
            {
                case self::UNSCHEDULED:
                    ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::PENDING);
                    ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::PENDING);
                break;

                case self::OTHER:
                    ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::OTHER);
                    ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::OTHER);
                break;

                case self::SCHEDULED: //need to fix that direct call this method affect report status
                    $member_details = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,['reportStatus']);
                    $report_status = $member_details['reportStatus'];
                    if($report_status)
                    {
                        $report_status_array = json_decode($report_status,true);
                        if(is_array($report_status_array) && array_key_exists('date',$report_status_array))
                        {

                              $status = $report_status_array['status'];
                            if($status==ReportStatus::RESCHEDULED)
                            {
                                return; //already updated
                            }
                            ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::SCHEDULED);
                            ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::SCHEDULED);
                        }
                        else
                        {
                            ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::SCHEDULED);
                            ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::SCHEDULED);
                        }
                    }
                    else
                    {
                        ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::SCHEDULED);
                        ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::SCHEDULED);
                    }
                break;   

                case self::IN_PROGRESS:
                    ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::SCHEDULED);
                    ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::SCHEDULED);
                break;

                case self::APPOINTMENT_CANCELLED:
                case self::ASSESSMENT_CANCELLED:
                    ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::CANCELLED);
                    ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::CANCELLED);
                break;

                case self::PATIENT_REFUSAL:
                    ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::REFUSAL);
                    ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::REFUSAL);
                break;

                case self::UTC:
                    ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::UTC);
                    ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::UTC);
                break;

                case self::READY_FOR_QA:
                case self::READY_FOR_CODER:
                case self::CLINICIAN_REVIEW_QA:
                case self::CLINICAIN_REVIEW_CODER:
                case self::READY_FOR_UPLOAD:
                case self::COMPLETED: 
                    ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::COMPLETED);
                    ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::COMPLETED);
                break;

                case self::IN_ELIGIBILE:
                    ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::IN_ELIGIBLE);
                    ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::IN_ELIGIBLE);
                break;

                case self::DECEASED:
                    ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::DECEASED);
                    ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::DECEASED);
                break;

                case self::HOSPICE:
                    ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::HOSPICE);
                    ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::HOSPICE);
                break;

                case self::TERM_EXPIRED:
                    ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::TERMED);
                    ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::TERMED);
                break;

                case self::NO_SHOW:
                    $member_details = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,['VisitType']);
                    if($member_details)
                    {
                        $visit_type  = trim(strtolower($member_details['VisitType']));

                        if($visit_type == 'virtual')
                        {
                            ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::VIRTUAL_NO_SHOW);
                            ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::VIRTUAL_NO_SHOW);
                        }
                        else if($visit_type == 'in person')
                        {
                            ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::F2F_NO_SHOW);
                            ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::F2F_NO_SHOW);
                        }
                        else
                        {

                        }
                    }
                break;
            }

        }


        /*
            NAME    : OnCallLogReportStatusChanged
            TYPE    : global Static Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        private static function OnCallLogReportStatusChanged($client_id,$year,$member_id,$call_result,$sub_call_result)
        {
             //read the member hraStatus and scheduler details
             $hra_status = MemberUtility::UNSCHEDULED;
             $member_details = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,["hraStatus"]);
             $hra_status_array = json_decode($member_details["hraStatus"],true);
             if(is_array($hra_status_array) && array_key_exists('hraStatus',$hra_status_array))
             {
                $hra_status = $hra_status_array['hraStatus'];
             }

             if($hra_status == MemberUtility::UNSCHEDULED ||
                $hra_status == MemberUtility::SCHEDULED || 
                $hra_status == MemberUtility::APPOINTMENT_CANCELLED || 
                $hra_status == MemberUtility::ASSESSMENT_CANCELLED ||
                $hra_status == MemberUtility::NO_SHOW
             )
             {
                switch($call_result)
                {
                    case self::CALL_RESULT_UNSCHEDULED:
                    case self::CALL_RESULT_DEAD_AIR:
                    case self::CALL_RESULT_LINE_BUSY:
                        ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::PENDING);
                        ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::PENDING);
                    break;

                    case self::CALL_RESULT_OTHER:
                        ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::OTHER);
                        ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::OTHER);
                    break;

                    case self::CALL_RESULT_NO_ANSWER:

                        $call_log_sub_result=(self::CALL_RESULT_NO_ANSWER*10)+$sub_call_result;
                        switch($call_log_sub_result)
                        {
                            case self::LEFT_VOICEMAIL:
                            case self::MAILBOX_FULL:
                            case self::NO_VM_SETUP:
                                ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::PENDING);
                                ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::PENDING);
                            break;
                        }
                    break;

                    case self::CALL_RESULT_SCHEDULED:
                        ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::SCHEDULED);
                        ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::SCHEDULED);
                    break;

                    case self::CALL_RESULT_CALL_BACK_REQUESTED:
                        ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::CALLBACK_REQUESTED);
                        ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::CALLBACK_REQUESTED);
                    break;

                    case self::CALL_RESULT_F2F_CALLBACK:
                        ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::F2F_CALLBACK);
                        ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::F2F_CALLBACK);
                    break;

                    case self::CALL_RESULT_RESCHEDULED:
                        ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::RESCHEDULED);
                        ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::RESCHEDULED);
                    break;

                    case self::CALL_RESULT_WRONG_NUMBER:
                        ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::WRONG_NUMBER);
                        ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::WRONG_NUMBER);
                    break;

                    case self::CALL_RESULT_DISCONNECTED:
                        ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::DISCONNECTED);
                        ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::DISCONNECTED);
                    break;

                    case self::CALL_RESULT_CALLER_DISCONNECTED:
                        ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::PENDING);
                        ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::PENDING);
                    break;

                    case self::CALL_RESULT_INELIGIBLE:
                        ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::IN_ELIGIBLE);
                        ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::IN_ELIGIBLE);
                    break;

                    case self::CALL_RESULT_DECEASED:
                        ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::DECEASED);
                        ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::DECEASED);
                    break;

                    case self::CALL_RESULT_HOSPICE:
                        ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::HOSPICE);
                        ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::HOSPICE);
                    break;

                    case self::CALL_RESULT_REFUSAL:
                        ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::REFUSAL);
                        ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::REFUSAL);
                    break;
                    
                }
             }
             
        }

        /*
			NAME 		: OnAddHraStatusHistory
			DETAILS		: add hra status history is the utiltiy function to return hra status history updated json value
							and database operation validation as return value
							new function added on 19_10_2020 
			PARAMETERS 	: client id, year ,member id ,hra status , hra admin username
			RETURN		: array of database status and updated hra history json 
		*/
		public static function OnAddHraStatusHistory($client_id,$year,$member_id,$hra_status,$hra_username,$custom_date_time=null)
		{
			include("../db.php");
            
            self::OnReportStatusHraStatusUpdate($client_id,$year,$member_id,"",$hra_status,1);
            
			$hra_status_history="";
			$hra_status_history_array=NULL;
			$hra_status_history_query = "select * from HRA_member_".$client_id.'_'.$year." where member_id='$member_id'";
			$db_success = false;
			try
			{
				$hra_status_history_query_result=mysqli_query($conn,$hra_status_history_query);
				if(mysqli_num_rows($hra_status_history_query_result) == 1)
				{
					$hra_history_row=mysqli_fetch_array($hra_status_history_query_result,MYSQLI_ASSOC);
					$hra_status_history = $hra_history_row['hraStatusHistory'];
					$db_success=true;
				}
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				$db_success=false;
			}

			//if hra status history is null or empty
			if($hra_status_history=="" || $hra_status_history==NULL )
			{
				$hra_status_history =  '{ 
					"scheduled":[],"inProgress":[],"appointmentCancelled":[],
					"patientRefusal":[],"utc":[],"readyForQa":[],"qaAssigned":[],
					"readyForCoder":[],"coderAssigned":[],"clinicianReviewQa":[],"clinicianReviewCoder":[],
					"readyForUpload":[],"completed":[],"assessmentCalcelled":[],"preScheduled":[],
					"inEligibile":[],"deceased":[],"hospice":[],"other":[],"termExpired":[],"noShow":[]
					}';
			}

			//decode the json hra history format into php array
			$hra_status_history_array = json_decode($hra_status_history, true);

			//newly added fields 'preScheduled' to 'termExpired' so validate that keys already in available or not
			//if not push the php array with those newly added keys
			if (!array_key_exists('preScheduled', $hra_status_history_array))
			{
				$updated_hra_status_history='{ "preScheduled":[],
					"inEligibile":[],"deceased":[],"hospice":[],"other":[],"termExpired":[] ,"noShow":[] }';
				$hra_status_history_array =	array_merge( $hra_status_history_array,json_decode($updated_hra_status_history, true));

			}
            
			TimeZone::useTimeZone();
			$current_date_time = date("Y-m-d")."T".date("H:i");
            //if custom date format set 
            if($custom_date_time && isset($custom_date_time))
            {
                $current_date_time = $custom_date_time;
            }

			$hra_status_new_history = array("date"=>$current_date_time, "username"=>$hra_username);
		
				switch ( $hra_status )
				{	
						case self::SCHEDULED:
							array_push( $hra_status_history_array['scheduled'], $hra_status_new_history );
						break;

						case self::IN_PROGRESS:
							array_push( $hra_status_history_array['inProgress'], $hra_status_new_history );
						break;

						case self::APPOINTMENT_CANCELLED:
							array_push( $hra_status_history_array['appointmentCancelled'], $hra_status_new_history );
						break;

						case self::PATIENT_REFUSAL:
							array_push( $hra_status_history_array['patientRefusal'], $hra_status_new_history );
						break;

						case self::UTC: 
							array_push( $hra_status_history_array['utc'], $hra_status_new_history );
						break;

						case self::READY_FOR_QA:
							array_push( $hra_status_history_array['readyForQa'], $hra_status_new_history );
						break;

						case self::READY_FOR_CODER:
							array_push( $hra_status_history_array['readyForCoder'], $hra_status_new_history );
						break;

						case self::CLINICIAN_REVIEW_QA:
							array_push( $hra_status_history_array['clinicianReviewQa'], $hra_status_new_history );
						break;

						case self::CLINICAIN_REVIEW_CODER:
							array_push( $hra_status_history_array['clinicianReviewCoder'], $hra_status_new_history );
						break;

						case self::READY_FOR_UPLOAD:
							array_push( $hra_status_history_array['readyForUpload'], $hra_status_new_history );
						break;

						case self::COMPLETED:
							array_push( $hra_status_history_array['completed'], $hra_status_new_history );
						break;

						case self::ASSESSMENT_CANCELLED:
							array_push( $hra_status_history_array['assessmentCalcelled'], $hra_status_new_history );
						break;

                        case self::PRE_SCHEDULED:
							array_push( $hra_status_history_array['preScheduled'], $hra_status_new_history );
						break;

						case self::IN_ELIGIBILE:
							array_push( $hra_status_history_array['inEligibile'], $hra_status_new_history );
						break;
						
						case self::DECEASED:
							array_push( $hra_status_history_array['deceased'], $hra_status_new_history );
						break;
						
						case self::HOSPICE:
							array_push( $hra_status_history_array['hospice'], $hra_status_new_history );
						break;
						
						case self::OTHER:
							array_push( $hra_status_history_array['other'], $hra_status_new_history );
						break;
						
						case self::TERM_EXPIRED:
							array_push( $hra_status_history_array['termExpired'], $hra_status_new_history );
						break;

						case self::NO_SHOW:
							array_push( $hra_status_history_array['noShow'], $hra_status_new_history );
						break;
						
						//non hra status number 
						case self::QA_ASSIGNED: //qaAssigned
							array_push( $hra_status_history_array['qaAssigned'], $hra_status_new_history );
						break;

						case self::CODER_ASSIGNED://coderAssigned
							array_push( $hra_status_history_array['coderAssigned'], $hra_status_new_history );
						break;
				}

			return array("success"=>$db_success , "updatedJsonHistory"=>json_encode($hra_status_history_array),"date"=>$current_date_time);

		}

		/*
			NAME 		: OnAddCancelHistory
			DETAILS 	: used to store the patient cancellation status history in 'cancelHistory' as json array format 
			PARAMETERS 	: client id,year,member id,admin user name,hra status,sub status,cancel status,cancel text
			RETURN 		: true if history updated else false
		*/
		public static function OnAddCancelHistory($client_id,$year,$member_id,$hra_username,$hra_status,$sub_status,$cancel_status,$cancel_text,$current_date_time)
		{
            
			include("../db.php");
			
			$cancel_history="";
			$cancel_history_array=NULL;
			$member_query = "select * from HRA_member_".$client_id.'_'.$year." where member_id='$member_id'";
			$is_member = false;
			try
			{
				$member_query_result=mysqli_query($conn,$member_query);
				if(mysqli_num_rows($member_query_result) == 1)
				{
					$member_row=mysqli_fetch_array($member_query_result,MYSQLI_ASSOC);
					$visit_type = $member_row['VisitType'];
					$cancel_history = $member_row['cancelHistory'];
					$is_member=true;
				}
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				$is_member=false;
			}

//echo $visit_type;die;
			if($is_member)
			{

				if($cancel_history=="" || $cancel_history==NULL )
				{
					$cancel_history =  '{ "appointmentCancelled":[] , "patientRefusal":[] ,"utc":[] ,"noShow":[] }';
				}
				
				//decode the json cancel history into array
				$cancel_history_array = json_decode($cancel_history, true);

				//its added because its later update on 05-01-2021
				//newly added fields 'patientRefusal' to 'utc' so validate that keys already is available or not
				if (!array_key_exists('patientRefusal', $cancel_history_array))
				{
					$updated_cancel_history='{ "patientRefusal":[], "utc":[] ,"noShow":[] }';
					$cancel_history_array =	array_merge( $cancel_history_array,json_decode($updated_cancel_history, true));
				}

				//cancel history array format
				$new_cancel_history = array("date"=>$current_date_time, 
											"username"=>$hra_username,
											"hraStatus"=>$hra_status,
											"subStaus"=>$sub_status,
											"cancelStatus"=>$cancel_status,
											"cancelText"=>$cancel_text,
											"date"=>$current_date_time,
											"type"=>$visit_type);
		
				switch ( $hra_status )
				{	
					case self::APPOINTMENT_CANCELLED:
						array_push( $cancel_history_array['appointmentCancelled'], $new_cancel_history );
					break;

					case self::PATIENT_REFUSAL:
						array_push( $cancel_history_array['patientRefusal'], $new_cancel_history );
					break;

					case self::UTC:
						array_push( $cancel_history_array['utc'], $new_cancel_history );
					break;

					case self::NO_SHOW:
						array_push( $cancel_history_array['noShow'], $new_cancel_history );
					break;
				}

				//update the cancel history in db
				$updated_cancel_history=json_encode($cancel_history_array);
				$update_cancel_history_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET cancelHistory='$updated_cancel_history' WHERE `member_id` = '$member_id'";
				$update_cancel_history_query_result = NULL;
				try 
				{
					$update_cancel_history_query_result=mysqli_query($conn,$update_cancel_history_query);
					$updated_row_count = mysqli_affected_rows($conn);
					if($updated_row_count)
					{
						return true;
					}
					else
					{	
						//no value value change detected
						if($update_cancel_history_query_result)
						{
							return true;
						}
						return false;
					}	
				}
				catch (Exception $e)
				{
					$error = $e->getMessage();
					return false;
				}

			}

			return false;

		}

        /*
            NAME : getMemberCallResponse
            TYPE : global static Utiltiy function 
            DETAILS : 'scheduler' denotes scheduler column database field
            RETURN : 
        */
        public static function getMemberCallResponse($hraStatus,$scheduler_id,$scheduler,$scheduler_details,$scheduler_call_hra_status,$schedule_call_log_details)
        {
            $member_call_response = array("attempt_count"=>0,"call_order"=>self::DEFAULT_USER_ORDER);
            $hra_status_array = json_decode($hraStatus,true);
            $scheduler_array = json_decode($scheduler,true);
            $scheduler_details_array = json_decode($scheduler_details,true);
            $scheduler_call_hra_status_array = json_decode($scheduler_call_hra_status,true);
            $schedule_call_log_details_array = json_decode($schedule_call_log_details,true);
           
            if($schedule_call_log_details_array && is_array($schedule_call_log_details_array) && array_key_exists("attemptCount",$schedule_call_log_details_array))
            {
                $member_call_response["attempt_count"] = $schedule_call_log_details_array["attemptCount"];
            }

            $recent_scheduled_details = SchedulerUtility::getRecentSchedulerAssignedDetails($scheduler_details_array);
            //database column 'callDetails'
            //removed after the attempt implementation
            //$member_call_response["attempt_count"]=self::getMemberCallLogAttemptCount($scheduler_id,$scheduler_array,$recent_scheduled_details);
           
            //to check unscheduled member only
            $is_hra_null =($hra_status_array==null|| $hra_status_array==0||$hra_status_array==""||$hra_status_array==1);
            if($is_hra_null || ArrayUtility::compareKeyValue($hra_status_array,'hraStatus',self::UNSCHEDULED))
            {
                $member_call_response["call_order"]=self::getMemberInWhichCallOrder($scheduler_id,$scheduler_array,$scheduler_call_hra_status_array,$recent_scheduled_details);
            }
            
            return $member_call_response;
            
        }

        /*
            NAME : getMemberCalllogAttemptCount
            TYPE : internal static Utiltiy function 
            DETAILS : 'scheduler' denotes scheduler column database field
            RETURN : attempt count in numbers
        */
        private static function getMemberCallLogAttemptCount($scheduler_id,$scheduler_array,$recent_scheduled_details)
        {   
            
            if($scheduler_id)
            {
                //still no scheduler details done nothing
                if($recent_scheduled_details==null)
                {
                    //if call log available
                    if( $scheduler_array!=null && is_array($scheduler_array))
                    {
                        $call_log = $scheduler_array["callLog"];
                        return count($call_log);
                    }
                }
               
                if (is_array($recent_scheduled_details) && array_key_exists('date', $recent_scheduled_details))
                {   
                    if(array_key_exists('schedulerId', $recent_scheduled_details))
                    {
                        if($scheduler_id == $recent_scheduled_details['schedulerId'] )
                        {   
                            $recent_scheduled_date = $recent_scheduled_details['date'];
                            if( $scheduler_array!=null && is_array($scheduler_array))
                            {
                                $call_log = $scheduler_array['callLog'];
                                //invaild date format in call log issue not fixed yet
                                $recent_call_logs = self::getRecentCallLogAsArray($call_log,$recent_scheduled_date);
                                return count($recent_call_logs);
                            }
                        }
                        
                    }
                }
            }
            

            return 0;
        }

        /*
            NAME : getMemberInWhichCallLogOrder
            TYPE : internal static Utiltiy function 
            DETAILS : In scheduler lead dashboard ,unscheduled members sorting based on calllog made state 
                      there are 3 type of call log busineess group list as call#1-3,Call#4,Call#5
	                 In when call log business days that member lies need to find 
            RETURN : if calllog group , call#1-3=0,Call#4=1,Call#5=2

        */
        private static function getMemberInWhichCallOrder($scheduler_id,$scheduler_array,$scheduler_call_hra_status_array,$recent_scheduled_details)
        {
            //scheduler notification based call order
            //scheduler call hra status with notification
           
            if($scheduler_call_hra_status_array)
            {
               $status = $scheduler_call_hra_status_array['status'];
              
               if($status==SchedulerUtility::UNSCHEDULED)
               {
                   if(array_key_exists('notification',$scheduler_call_hra_status_array))
                   {
                        $notification = $scheduler_call_hra_status_array['notification'];
                        if($notification)
                        {
                            if( $notification['type'] == SchedulerUtility::SCHN_MOBILE_CHANGED)
                            {
                                return self::DEFAULT_NOTIFICATION_CALL_ORDER;
                            }
                        }
                   }
               }
            }

            //if no scheduler assigned
            //no recent scheduler details
            //no scheduler details
            if($scheduler_id==null || $recent_scheduled_details==null || $scheduler_array==null) return self::DEFAULT_USER_ORDER;

            if(array_key_exists('date', $recent_scheduled_details))
            {
                $recent_scheduled_date = $recent_scheduled_details["date"];
                return self::getCallOrderBasedOnCalllog($scheduler_array["callLog"],$recent_scheduled_date);
            }
            
            return self::DEFAULT_USER_ORDER;
           
        }

        /*
            NAME : getCallOrderBasedOnCalllog
            TYPE : internal Static Utiltiy function 
            DETAILS : 
            RETURN : order number 0,1,.....
        */
        private static function getCallOrderBasedOnCalllog($call_log,$scheduler_assigned_date)
        {
            //call order and business day variable 
            $DAY_CALL_ORDER = [0,1,2,3,4,5,6,7,8,9];
            $GROUP_A = 4;
            $GROUP_B = 1;
            $GROUP_C = 0;
            //active time zone value
            TimeZone::useTimeZone();
            $current_date = date('m-d-Y H:i:s');
            //format the current date to m/d/Y
            $formatted_current_date = DateUtility::convertDateFormat($current_date,'m-d-Y H:i:s',"m/d/Y");
            //convert the date format of the scheduled date to as call log date format
            $formatted_recent_scheduled_date = DateUtility::convertDateFormat($scheduler_assigned_date,'m-d-Y H:i:s',"m/d/Y");
            //details call logs made after scheduled date 
            $call_log_dates = self::extractCallLogDatesAsArray($call_log,$scheduler_assigned_date);
            $call_log_counts = 0;
            if(is_array($call_log_dates))
            {
                $call_log_counts = count($call_log_dates);
            }
            //business days count from scheduled date 
            $first_business_days_count = SchedulerUtility::FIRST_BUSINESS_DAYS;
            $second_business_days_count = SchedulerUtility::FIRST_BUSINESS_DAYS+SchedulerUtility::SECOND_BUSINESS_DAYS;
            $third_business_days_count = SchedulerUtility::FIRST_BUSINESS_DAYS+SchedulerUtility::SECOND_BUSINESS_DAYS+SchedulerUtility::THIRD_BUSINESS_DAYS;
            $after_third_business_days_count = $third_business_days_count+SchedulerUtility::THIRD_BUSINESS_DAYS;
            $days_difference = DateUtility::getNumberOfDaysPassed($formatted_recent_scheduled_date,$formatted_current_date);
            $day_call_order_count = count($DAY_CALL_ORDER);
           
            if($days_difference>0 && $days_difference<=$first_business_days_count)
            {
                //echo "Group A :".($first_business_days_count - $days_difference)."\n";
                $first_business_date = DateUtility::getDateAfterDays($formatted_recent_scheduled_date,
                $first_business_days_count,'m/d/Y');
                $parsed_call_log_count=0;
                $parsed_call_log_dates=null;
                if($call_log_counts>0)
                {
                    $parsed_call_log_dates = DateUtility::getDatesBetweenBusinessDays($call_log_dates,$formatted_recent_scheduled_date,
                                    $first_business_date,'m/d/Y');
                    $parsed_call_log_count = count($parsed_call_log_dates);
                }

                if($parsed_call_log_count>=SchedulerUtility::FIRST_BUSINESS_DAY_CALL_LOG_COUNT)
                {
                    return $GROUP_A+$DAY_CALL_ORDER[$day_call_order_count-1]+self::DEFAULT_CALL_ORDER;
                }
                else
                {
                    $days_pending = $first_business_days_count - $days_difference;
                    return $GROUP_A+$DAY_CALL_ORDER[$days_pending]+self::DEFAULT_CALL_ORDER;
                }

                return $GROUP_A+$DAY_CALL_ORDER[$day_call_order_count-2]+self::DEFAULT_CALL_ORDER;

            }
            else if($days_difference>$first_business_days_count && $days_difference<=$second_business_days_count)
            {
                //echo "Group B :".($second_business_days_count - $days_difference)."\n";
                $first_business_date= DateUtility::getDateAfterDays($formatted_recent_scheduled_date,
                                                                                $first_business_days_count,'m/d/Y');
    
                $second_business_date= DateUtility::getDateAfterDays($formatted_recent_scheduled_date,
                                                                                $second_business_days_count,'m/d/Y');
                $parsed_call_log_dates=null;
                if($call_log_counts>0)
                {
                    $parsed_call_log_dates = DateUtility::getDatesBetweenBusinessDays($call_log_dates,
                                                                    $first_business_date,$second_business_date,'m/d/Y');
                }

                //if call log made on second business week
                if($parsed_call_log_dates)
                {
                    return $GROUP_B+$DAY_CALL_ORDER[$day_call_order_count-1]+self::DEFAULT_CALL_ORDER; 
                }
                else
                {
                    $days_pending = $second_business_days_count - $days_difference;
                    if($days_pending>=$day_call_order_count) {$days_pending = $day_call_order_count-1;}
                    return $GROUP_B+$DAY_CALL_ORDER[$days_pending]+self::DEFAULT_CALL_ORDER;
                }
                
                return $GROUP_B+$DAY_CALL_ORDER[$day_call_order_count-2]+self::DEFAULT_CALL_ORDER;

            }
            else if($days_difference>$second_business_days_count && $days_difference<=$third_business_days_count )
            {
                //echo "Group C :".($third_business_days_count - $days_difference)."\n";
                $second_business_date=DateUtility::getDateAfterDays($formatted_recent_scheduled_date,
                $second_business_days_count,'m/d/Y');

                $third_business_date=DateUtility::getDateAfterDays($formatted_recent_scheduled_date,
                                $third_business_days_count,'m/d/Y');

                $parsed_call_log_dates=null;
                if($call_log_counts>0)
                {
                    $parsed_call_log_dates = DateUtility::getDatesBetweenBusinessDays($call_log_dates,
                                $second_business_date,$third_business_date,'m/d/Y');
                }

                //if call log made on second business week
                if($parsed_call_log_dates)
                {
                    //third call log group
                    return $GROUP_C+$DAY_CALL_ORDER[$day_call_order_count-1]+self::DEFAULT_CALL_ORDER; 
                }
                else
                {
                    $days_pending = $third_business_days_count - $days_difference;
                    if($days_pending>=$day_call_order_count) {$days_pending = $day_call_order_count-1;}
                    return $GROUP_C+$DAY_CALL_ORDER[$days_pending]+self::DEFAULT_CALL_ORDER;
                }
               
                return $GROUP_C+$DAY_CALL_ORDER[$day_call_order_count-2]+self::DEFAULT_CALL_ORDER; 

            }
            else if($days_difference>$third_business_days_count)
            {
                if($days_difference<self::DEFAULT_USER_ORDER)
                {
                    return $days_difference; 
                }
            }

            return self::DEFAULT_USER_ORDER;
    
        }

        /*
                NAME : getRecentCallLogAsArray
                TYPE : internal Static Utiltiy function 
                DETAILS : extract dates from call log and only return the 
                        call log dates greater than current scheduled date
                        else trancate the previous call logs                
        */
        private static function getRecentCallLogAsArray($call_log,$recent_scheduled_date)
        {
            
                //get the call log count
                $call_log_counts = $call_log!=NULL?count($call_log):0;
                $recent_call_log_details = [];

                for($cl=0;$cl<$call_log_counts;$cl++)
                {  
                    $this_call_date = $call_log[$cl]["date"];
                    
                    //if call log in valid format or not
                    //to avoid invalid date format corrupt the api call
                    if(DateUtility::validateScheduledDate($this_call_date,'n/j/Y @ h:i A'))
                    {
                        //log date format 1/7/2021 @ 11:48 AM
                        $formated_call_date = DateUtility::convertDateFormat($this_call_date,'n/j/Y @ h:i A',"m/d/Y H:i");
                        //date format 01-06-2021 03:53:53
                        $formatted_recent_scheduled_date = DateUtility::convertDateFormat($recent_scheduled_date,'m-d-Y H:i:s',"m/d/Y H:i");

                        $this_call_date = $call_log[$cl]["date"];
                        $call_log_date_array = explode(" @",$this_call_date);
                    
                        $count = count($call_log_date_array);
                        if($count>1)
                        {
                            $call_date_without_time = $call_log_date_array[0];
                            
                            $days_difference = DateUtility::getNumberOfDaysPassed($formatted_recent_scheduled_date,$formated_call_date);
                            if($days_difference>0)
                            {
                                $recent_call_log_details[] = $call_log[$cl];
                            }
                            else
                            {
                                //check for minutes if same date call log made
                                $minutes_difference=DateUtility::getTotalMinutesPassed($formatted_recent_scheduled_date,$formated_call_date);
                                if($minutes_difference>=0)
                                {
                                    $recent_call_log_details[] = $call_log[$cl];
                                }
                                
                            }
                        }
                    }
                }

                return $recent_call_log_details;
        }


    /*
        NAME : extractCallLogDatesAsArray
        TYPE : internal static Utiltiy function 
        DETAILS : extract dates only from call logs            
    */
    private static function extractCallLogDatesAsArray($call_log,$recent_scheduled_date)
    {
        //get the call log count
        $call_log_counts = $call_log!=NULL?count($call_log):0;
        $call_dates = NULL;

        for($cl=0;$cl<$call_log_counts;$cl++)
        {  
            $this_call_date = $call_log[$cl]["date"];
            //validate the date formate to avoid execution stop or error
            if(DateUtility::validateScheduledDate($this_call_date,'n/j/Y @ h:i A'))
            {
                //log date format 01/07/2021 @ 11:48 AM
                $formated_call_date = DateUtility::convertDateFormat($this_call_date,'n/j/Y @ h:i A',"m/d/Y H:i");
                //date format 01-06-2021 03:53:53
                $formatted_recent_scheduled_date = DateUtility::convertDateFormat($recent_scheduled_date,'m-d-Y H:i:s',"m/d/Y H:i");

                $this_call_date = $call_log[$cl]["date"];
                $call_log_date_array = explode(" @",$this_call_date);
                
                $count = count($call_log_date_array);
                if($count>1)
                {
                    $call_date_without_time = $call_log_date_array[0];
                    
                    $days_difference = DateUtility::getNumberOfDaysPassed($formatted_recent_scheduled_date,$formated_call_date);
                    if($days_difference>0)
                    {
                        $call_dates[] = DateUtility::convertDateFormat($call_date_without_time,'n/j/Y','m/d/Y');
                    }
                    else
                    {
                    
                        //check for minutes if same date call log made
                        $minutes_difference=DateUtility::getTotalMinutesPassed($formatted_recent_scheduled_date,$formated_call_date);
                        if($minutes_difference>=0)
                        {
                            $call_dates[] = DateUtility::convertDateFormat($call_date_without_time,'n/j/Y','m/d/Y');
                        }
                    }
                }
            }
        }

        return $call_dates;
    }

       

         /*
            NAME : getAllMemberDataBaseFields
            TYPE : global static utility function
            DETAILS : get member database field value based field arrray list
            RETURN : return array of member value else null;
        */
        public static function getAllMemberDataBaseFields($client_id,$year,$column_name_list = [])
        {
            include("../db.php");

            if(count($column_name_list)==0)
            {
                $column_name_list_string='*';
            }
            else
            {
                $column_name_list_string = implode(",",$column_name_list);
            }
            
            $member_column_details = NULL;
            $member_records_query = "select $column_name_list_string from HRA_member_".$client_id.'_'.$year;
            $member_records_query_result=mysqli_query($conn,$member_records_query);
            while($member_row = mysqli_fetch_array($member_records_query_result,MYSQLI_ASSOC))
            { 
                $member_column_details = $member_row; 
            }

            return $member_column_details;
        }

    /*
        NAME    : IsMemberScheduleDateExceeds
        TYPE    : Internal static Utility Function
        DETAILS : check the member scheduled date exceeds 10 month or not
        RETURN  : array with member_status and is_exceed  flag
    */
    private static function IsMemberScheduleDateExceeds($client_id,$year,$member_id,$number_of_month=10)
    {
       
        //database connection
        include("../db.php");

        $members_schedule_detail_sql = "SELECT member_id,firstname,lastname,scheduler_id,scheduleDate,schedulerCallHraStatus from HRA_member_".$client_id."_".$year." WHERE member_id = $member_id";
        $is_member_available = false;
        try 
		{	
			$members_schedule_detail = NULL;
            $members_schedule_detail_result=mysqli_query($conn,$members_schedule_detail_sql);
            //check the result for null 
            if(mysqli_num_rows($members_schedule_detail_result) == 1)
            {
                $members_schedule_detail=mysqli_fetch_array($members_schedule_detail_result,MYSQLI_ASSOC);
            }     
            
            if($members_schedule_detail)
            {
                $is_member_available = true;
                $scheduled_date = $members_schedule_detail["scheduleDate"];
                if($scheduled_date)
                {
                    //if scheduled date assigned check for 10 month exceed
                    $scheduled_date_array = explode("T",$scheduled_date);
                    if(count($scheduled_date_array)>1)
                    {
                        $formatted_scheduled_date = $scheduled_date_array[0];
                        //validate the schedule date is in proper format
                        if(DateUtility::validateScheduledDate($formatted_scheduled_date,"Y-n-j"))
                        {
                            $is_exceed = DateUtility::IsMonthPassed($formatted_scheduled_date,$number_of_month);
                            return array("member_status"=>true , "is_exceed"=>$is_exceed,"scheduledDate"=>$scheduled_date);
                        }
                    }
                }
                else
                {
                    //no schedule date assigned than that member elgible for scheduler in current year
                    return array("member_status"=>true , "is_exceed"=>true,"scheduledDate"=>null);
                }

            }
            else
            {
                return array("member_status"=>false , "is_exceed"=>false,"scheduledDate"=>null);
            }
				
		}
		catch (Exception $e)
		{
			$error = $e->getMessage();
			return array("member_status"=>false , "is_exceed"=>false,"scheduledDate"=>null);
        }
        
        return array("member_status"=>$is_member_available,"is_exceed"=>false,"scheduledDate"=>null);

    }

     /*
        NAME    : importTermDate
        TYPE    : Internal static Utility Function
        DETAILS : 
        RETURN  : 
    */
    public static function importTermDate($client_id,$year,$member_id,$term_date) 
    {
        //update refusal letter send date
		$valid_term_date = DateUtility::parseAndValidateTheTermDate($term_date);
        if($valid_term_date)
        {
			$column_name_list =['termDate'];
			$column_value_list=[$term_date];
			DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
		
            //Add OnTermDateUpdated once ready
            $response_array=self::OnTermDateUpdated($client_id,$year,$member_id,$term_date);
            //if hra status updated as termed when import updated report status again
            if($response_array["hraStatus"]==self::TERM_EXPIRED)
            {
                ReportStatus::updateReportStatus($client_id,$year,$member_id,"Termed");
                ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::TERMED);
            }

            return true;
        }

        return false;
    }

    /*
        NAME    : OnTermDateUpdated
        TYPE    : Internal static Utility Function
        DETAILS :  OnTermDateUpdated callback invoke when  termDat api called 
                    //DATE FORMAT
                    //Y-m-d-27T00:00
                    //2021-05-27T00:00
        RETURN  : term response as array
    */
    public static function OnTermDateUpdated($client_id,$year,$member_id,$term_date)
    {
        $response_array = array("status"=>false,"expired"=>false,"hraStatus"=>MemberUtility::UNKNOWN);
       
        $valid_term_date = DateUtility::parseAndValidateTheTermDate($term_date);
       
        if($valid_term_date)
        {
            $is_term_expired = DateUtility::IsDateExceed($valid_term_date);
            if($is_term_expired)
            {
              
               //update the hra status to termed when only following hra status meets
               $term_update_result= DataBaseUtility::updateHraStatusWithCondition($client_id,$year,$member_id,null,MemberUtility::TERM_EXPIRED,
                [
                    MemberUtility::UNSCHEDULED,MemberUtility::SCHEDULED,MemberUtility::APPOINTMENT_CANCELLED,
                    MemberUtility::PATIENT_REFUSAL,MemberUtility::UTC,MemberUtility::ASSESSMENT_CANCELLED,
                    MemberUtility::IN_ELIGIBILE,MemberUtility::NO_SHOW,MemberUtility::OTHER,MemberUtility::HRA_NOT_DUE
                ]);
            
               $response_array["status"]=true;
               $response_array["expired"]=true;
               if($term_update_result)
               {
                    //clear the scheduled date if any
                    $column_name_list =['nurse_id','scheduleDate'];
                    $column_value_list=[null,null];
                    DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
                    self::OnHraReportStatusChanged($client_id,$year,$member_id,array("hraStatus"=>MemberUtility::TERM_EXPIRED));
                    $response_array["hraStatus"]=MemberUtility::TERM_EXPIRED;
               }
              
            }
            else
            {
               
                //update the hra status to termed when only following hra status meets
               $term_update_result = DataBaseUtility::updateHraStatusWithCondition($client_id,$year,$member_id,null,MemberUtility::UNSCHEDULED,
                [
                    MemberUtility::TERM_EXPIRED
                ]);
            
                $response_array["status"]=true;
                $response_array["expired"]=false;
                if($term_update_result)
                {
                    self::OnHraReportStatusChanged($client_id,$year,$member_id,array("hraStatus"=>MemberUtility::UNSCHEDULED));
                    $response_array["hraStatus"]=MemberUtility::UNSCHEDULED;
                }
              
            }
            
        }

        return $response_array;

    }

        /*
        NAME    : OnReportStatusHraStatusUpdate
        TYPE    : Internal static Utility Function
        DETAILS : Used to update report status and hrastatus data as weekwise in new column
        If type is 0 => Report Status updated
        If type is 1 => HRA Status updated

        And also updating data of last updated date of Report Status and Hra Status
    */

    public static function OnReportStatusHraStatusUpdate($client_id,$year,$member_id,$report_status_index,$hra_status,$type){
        $reportHraStatusWeekly = "";
        $reportHraStatusWeekly_array=NULL;
        
        $hra_history_row = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,['reportStatus','reportHraStatusWeekly']);

        $reportHraStatusWeekly = $hra_history_row['reportHraStatusWeekly'];
        $reportStatus = $hra_history_row['reportStatus'];
        
        TimeZone::useTimeZone();
        $current_date_time = date("Y-m-d")."T".date("H:i");
        
        $reportHraStatusWeekly_new_history = array();

        if($reportHraStatusWeekly=="" || $reportHraStatusWeekly==NULL )
        {
            if($type == 0){
                $text = ReportStatus::GetStatusToString($report_status_index);
                $reportHraStatusWeekly_new_history = array(array("hraStatus" => "" , "hraStatus_date" => "","text" => $text ,"status" => $report_status_index , "reportStatus_date" => $current_date_time , "type"=> "ReportStatus"));
            }else{
                $reportHraStatusWeekly_new_history = array(array("hraStatus" => $hra_status , "hraStatus_date" => $current_date_time,"text" => "" ,"status" => "","reportStatus_date" => "" , "type" => "HraStatus"));
            }
        }else{
            $reportHraStatusWeekly_array = json_decode($reportHraStatusWeekly, true);
            $report_status_array = json_decode($reportStatus,true);
        
            if($custom_date_time && isset($custom_date_time))
            {
                $current_date_time = $custom_date_time;
            }

            $current_date = date("y-m-d");
            
            $getweek = date('w', strtotime($current_date));
            
            if($getweek == 2){
                $start_week = strtotime($current_date);
            }else{
                $start_week = strtotime("last tuesday",strtotime($current_date));
            }
            $end_week = strtotime("next monday",$start_week);

            $start_week = date("Y-m-d",$start_week);
            $end_week = date("Y-m-d",$end_week);

            $reportHraStatusWeekly_array1 = array();
            $index = "";
            if(substr(json_encode($reportHraStatusWeekly_array),0,1) != '['){
                $hra_status_value = $reportHraStatusWeekly_array['hraStatus'];
                $hra_status_date = $reportHraStatusWeekly_array['hraStatus_date'];
                $report_text = $reportHraStatusWeekly_array['text'];
                $reportStatus_date = $reportHraStatusWeekly_array['reportStatus_date'];
                $status1 = $reportHraStatusWeekly_array['status'];
            }else{
                $index = end(array_keys($reportHraStatusWeekly_array));
                $hra_status_value = $reportHraStatusWeekly_array[$index]['hraStatus'];
                $hra_status_date = $reportHraStatusWeekly_array[$index]['hraStatus_date'];
                $report_text = $reportHraStatusWeekly_array[$index]['text'];
                $reportStatus_date = $reportHraStatusWeekly_array[$index]['reportStatus_date'];
                $status1 = $reportHraStatusWeekly_array[$index]['status'];
            }

            if($type == 1){
                if($hra_status_date != ""){
                    $last_updated_date = $hra_status_date;
                }else if($reportStatus_date != ""){
                    $last_updated_date = $reportStatus_date;
                }
            }else{
                if($reportStatus_date != ""){
                    $last_updated_date = $reportStatus_date;
                }else if($hra_status_date != ""){
                    $last_updated_date = $hra_status_date;
                }
            }
            if (($last_updated_date >= $start_week) && ($last_updated_date <= $end_week)){
                if($type == 0){
                    $text = ReportStatus::GetStatusToString($report_status_index);
                    $reportHraStatusWeekly_array1 = array("hraStatus" => $hra_status_value , "hraStatus_date" => $hra_status_date,"text" => $text ,"status" => $report_status_index , "reportStatus_date" => $current_date_time , "type"=> "ReportStatus");
                }else{
                    $reportHraStatusWeekly_array1  = array("hraStatus" => $hra_status , "hraStatus_date" => $current_date_time , "text" => $report_text ,"status" => $status1 , "reportStatus_date" => $reportStatus_date , "type" => "HraStatus");
                }
                if(substr(json_encode($reportHraStatusWeekly_array),0,1) != '['){
                    $reportHraStatusWeekly_new_history = $reportHraStatusWeekly_array1 ;
                }else{
                    $reportHraStatusWeekly_array[$index] = $reportHraStatusWeekly_array1;
                    $reportHraStatusWeekly_new_history = $reportHraStatusWeekly_array ;
                }
            }else{
                if($type == 0){
                    $text = ReportStatus::GetStatusToString($report_status_index);
                    $reportHraStatusWeekly_array1 = array("hraStatus" => $reportHraStatusWeekly_array['hraStatus'] , "hraStatus_date" => $reportHraStatusWeekly_array['hraStatus_date'],"text" => $text ,"status" => $report_status_index , "reportStatus_date" => $current_date_time , "type"=> "ReportStatus");
                }else{
                    $reportHraStatusWeekly_array1  = array("hraStatus" => $hra_status , "hraStatus_date" => $current_date_time , "text" => $reportHraStatusWeekly_array['text'] ,"status" => $reportHraStatusWeekly_array['status'] , "reportStatus_date" => $reportHraStatusWeekly_array['reportStatus_date'] , "type" => "HraStatus");
                }
                
                if(substr(json_encode($reportHraStatusWeekly_array),0,1) != '['){
                    array_push($reportHraStatusWeekly_new_history,$reportHraStatusWeekly_array);
                    array_push($reportHraStatusWeekly_new_history,$reportHraStatusWeekly_array1);
                }else{
                    array_push($reportHraStatusWeekly_array,$reportHraStatusWeekly_array1);
                    $reportHraStatusWeekly_new_history =$reportHraStatusWeekly_array;
                }
                
            }
        }

        $current_status = array();
        $current_datetime = date("Y-m-d H:i:s");
        
        if($type == 0){
            $text = ReportStatus::GetStatusToString($report_status_index);
            $current_status = array("date" => $current_datetime, "hrastatus" => "","reportstatus" => $text);
         } else if($type == 1){
            $current_status = array("date" => $current_datetime, "hrastatus" => $hra_status,"reportstatus" => "");
         }

        $column_name_list =['reportHraStatusWeekly','currentStatus'];
		$column_value_list=[json_encode($reportHraStatusWeekly_new_history), json_encode($current_status)];
        
		DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
        
    }

}

?>