<?php

require_once("../utility/Utility.php");

class GeneratePasswordHash
{

    public function updatePasswordHash($user_name,$password)
    {   
        include("../db.php");
        $password_hash_value =  password_hash( $password, PASSWORD_BCRYPT);
        $conn->begin_transaction();
            $query=$conn->prepare('UPDATE userLogin SET `password_hash` = ? WHERE `username` = ?');
            $query->bind_param('ss',$password_hash_value,$user_name);
            $result=$query->execute();
         $conn->commit();

         return $result;
    }

    public function getPasswordHash($user_name)
    {   
        include("../db.php");
        $password_hash = null;

            $query=$conn->prepare('SELECT username,password_hash from userLogin WHERE `username` = ?');
            $query->bind_param('s',$user_name);
            $query->execute();
            $result = $query->get_result();
            $user_detail=$result->fetch_assoc();
            if($user_detail)
            {
		        $password_hash=$user_detail['password_hash'];
            }

        return $password_hash;
    }

    public function getPassword($user_name)
    {   
        include("../db.php");
        $password = null;

            $query=$conn->prepare('SELECT username,password from userLogin WHERE `username` = ?');
            $query->bind_param('s',$user_name);
            $query->execute();
            $result = $query->get_result();
            $user_detail=$result->fetch_assoc();
            if($user_detail)
            {
		        $password=$user_detail['password'];
            }

        return $password;
    }

    public function start()
    {
        include("../db.php");
        //sql query to get all client list 
        $user_details_query = "SELECT * from userLogin";
        $user_details_query_result=mysqli_query($conn,$user_details_query);
        //fetch all the client info
        while($user_row=mysqli_fetch_array($user_details_query_result,MYSQLI_ASSOC))
        {
            $id = $user_row["id"];
            $password = $user_row["password"];

            $password_hash=Utility::generatePasswordHash($password);
            $update_password_hash = "UPDATE userLogin SET `password_hash` = '$password_hash' WHERE `id` = $id";
            $update_password_hash_result = mysqli_query($conn, $update_password_hash);
        }

    }

}

$migrate_password = new GeneratePasswordHash;
$migrate_password->start();


?>