<?php

    /*
        ****DO NOT RUN WITHOUT UNDERSTAND 
        ****ALREADY THIS SCRIPT RAN FOR LIVE DB MIGRATED
    */
    class HraHistoryDataBaseMigration
    {
            private $count;

            public function migrateClientForHraFileHistory($client_id,$year)
            {
                include("../db.php");
                $this->count = 0;
                $member_records_query = "select * from HRA_member_".$client_id.'_'.$year;
                $member_records_query_result=mysqli_query($conn,$member_records_query);
                while($member_row = mysqli_fetch_array($member_records_query_result,MYSQLI_ASSOC))
                { 
                    $member_id = $member_row["member_id"];
                    $hra_json_content = $this->getJsonContent($client_id,$year,$member_id);
                    if($hra_json_content!=null)
                    {
                        $file_date = date("m-d-Y");
                        $file_time = date("H:i:s");
                        $hra_json_file_modified = $this->getFileModified($client_id,$year,$member_id);
                        if($hra_json_file_modified)
                        {
                            $file_date = $hra_json_file_modified["date"];
                            $file_time = $hra_json_file_modified["time"];
                        }

                        $this->migrateMemberWhenChangeInScreeningData($client_id,$year,$member_id,$hra_json_content,$file_date,$file_time);
                        $this->migrateDemographicsValue($client_id,$year,$member_id,$hra_json_content,$file_date,$file_time);
                    }
                }

            }

             /*
                NAME : migrateMemberWhenChangeInScreeningData
                DETAILS : migrate member's hraFileUpdatedHistory when screening data field value changes found
                ** : its not API DO NOT CALL THIS ,only used for db migration
            */
            public function migrateMemberWhenChangeInScreeningData($client_id,$year,$member_id,$hra_json_content,$current_date,$current_time)
            {
                    if($year==2019 || $year==2020) { return false; }

                    if($hra_json_content)
                    {
                        $screening_value = $this->convertJsonAsArray($hra_json_content,["Screenings Needed","Screenings"]);
                       
                        if($this->findChangesInScreeningData($client_id,$year,$member_id,$screening_value))
                        {
                           $this->appendHraFileUpdateHistroy($client_id,$year,$member_id,"screening",
                                            $current_date,$current_time,true,$screening_value,true);
                        }
                       
                    }
            }


            public function migrateDemographicsValue($client_id,$year,$member_id,$hra_json_content,$current_date,$current_time)
            {
                //current demographic value as php array
                $demographic_value = $this->convertJsonAsArray($hra_json_content,["Demographics","demo"]);
                
                $this->appendHraFileUpdateHistroy($client_id,$year,$member_id,"demographic",$current_date,$current_time,
                                                                    true,$demographic_value,true);

                //echo "member_id".$member_id."migrates Demographics details\n";
                    
            }



            /*
                NAME : findChangeInScreeningData
                DETAILS : when member import when no hra file found.IMPLEMENTATION PENDING
            */
            private function findChangesInScreeningData($client_id,$year,$member_id,$screening_value)
            {
                if($year==2019 || $year==2020) { return false; }

                if(is_array($screening_value))
                {
                        $screening_value_array=$screening_value[0];
                        if(is_array($screening_value_array))
                        {
                            $screeing_row_count = count($screening_value_array);
                            
                            for($scr=0;$scr<$screeing_row_count;$scr++)
                            {
                                $screening_row_value = $screening_value_array[$scr];

                                if(is_array($screening_row_value))
                                {
                                    //$member_eligible = $screening_row_value[0];
                                    //$status = $screening_row_value[6];
                                    $screening_completed = $screening_row_value[1];
                                    $screening_result = $screening_row_value[2];
                                    //$barcode = $screening_row_value[4];
                                    //find changes in screening value condition
                                    if($screening_completed=="Yes" || $screening_completed=="Exception")
                                    {
                                        return true;
                                    }

                                    if(strlen($screening_result)>0)
                                    {
                                        if(!empty($screening_result) && !ctype_space($screening_result))
                                        {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }

                }

                return false;
            }


            /*
                NAME : getJsonContent
                DETAILS : 
            */
            public function getJsonContent($client_id,$year,$member_id)
            {
                //previous saved hra json file
                $member_json_file_path = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
                if(file_exists($member_json_file_path))
                {
                    $hra_json_content = file_get_contents($member_json_file_path);
                    return $hra_json_content;
                }

                return NULL;
            }

            /*
                NAME : convertJsonAsArray
                DETAILS : 
            */
            private function convertJsonAsArray($hra_json_content,$component_title_name_array)
            {
                $specific_data_value = $this->getJsonAnswerByTitle($hra_json_content,$component_title_name_array);
                return $specific_data_value;
            }

            /*
                NAME : appendHraFileUpdateHistroy
                DETAILS : check the member present or not and decode the hra file updated history,
                         append the time and what component valued modified later update database column
                         hraFileUpdatedHistory
                RETURN : NULL
            */
            private function appendHraFileUpdateHistroy($client_id,$year,$member_id,$what_modified,$on_what_date,$on_what_time,
                            $component_status,$componet_value,$component_data_changed)
            {
                include("../db.php");

                $hra_file_history_json="";
                $hra_file_history_query = "select hraFileUpdatedHistory from HRA_member_".$client_id.'_'.$year." where member_id='$member_id'";
                $db_success = false;
                try
                {
                    $hra_status_history_query_result=mysqli_query($conn,$hra_file_history_query);
                    if(mysqli_num_rows($hra_status_history_query_result) == 1)
                    {
                        $hra_file_history_row=mysqli_fetch_array($hra_status_history_query_result,MYSQLI_ASSOC);
                        $hra_file_history_json = $hra_file_history_row['hraFileUpdatedHistory'];
                        $db_success=true;
                    }
                }
                catch (Exception $e)
                {
                    $error = $e->getMessage();
                    $db_success=false;
                }

                if($db_success)
                {
                    //decode the json hra history format into php array
                    $hra_file_history_array = json_decode($hra_file_history_json, true);
                    //check the hra file updated history at first position of the array 
                    $hra_file_history_array  = $this->findAndUpdateHraFileHistoryByFirstRow($hra_file_history_array,$what_modified,
                                        $on_what_date,$on_what_time,$component_status,$componet_value,$component_data_changed);
                    
                    if($this->updateHraFileJsonHistoryInDb($client_id,$year,$member_id,$hra_file_history_array))
                    {
                        $response = new stdClass();
                        $response->status = 'updated';
                        $response = json_encode($response);
                        return $response;
                    }
                    else
                    {
                        $response = new stdClass();
                        $response->status = 'not updated';
                        $response = json_encode($response);
                        return $response;
                    }
                }
                else
                {
                        $response = new stdClass();
                        $response->status = 'member not found';
                        $response = json_encode($response);
                        return $response;
                }
                
                //echo json_encode($hra_file_history_array,true);
                return $db_success;
            }

           
            /*
                NAME : updateHraFileJsonHistoryInDb
                DETAILS : udpated hra file history pushed into database column
                RETURN : return true if database updated else false
            */
            private function updateHraFileJsonHistoryInDb($client_id,$year,$member_id,$hra_file_history_array)
            {
                include("../db.php");
                //update the hra file json value in array
                $updated_hra_file_json_history=json_encode($hra_file_history_array);
                $updated_hra_file_json_history=mysqli_real_escape_string($conn,$updated_hra_file_json_history);
				$updated_hra_file_json_history_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET hraFileUpdatedHistory='$updated_hra_file_json_history' WHERE `member_id` = '$member_id'";
				$updated_hra_file_json_history_query_result = NULL;
				try 
				{
					$updated_hra_file_json_history_query_result=mysqli_query($conn,$updated_hra_file_json_history_query);
                    echo "member details ".$client_id."_".$year."_".$member_id." db_error:".$conn->error."\n";
                    if($conn->error)
                    {
                        //echo $updated_hra_file_json_history_query."\n";
                    }
					$updated_row_count = mysqli_affected_rows($conn);
					if($updated_row_count)
					{
						return true;
					}
					else
					{	
						//no value value change detected
						if($updated_hra_file_json_history_query_result)
						{
							return true;
						}
						return false;
					}	
				}
				catch (Exception $e)
				{
					$error = $e->getMessage();
					return false;
				}

            }

            /*
                NAME : addHraHistoryInArray
                DETAILS : when hra file history array is empty than  create new array of time and what component
                        modified .if already created push the new array of time and what component modified value.

                RETURN : update hra file history array
            */
            private function addHraHistoryInArray($hra_file_history_array,$what_modified,$on_what_date,$on_what_time,$component_status,$componet_value)
            {
                $current_time = $on_what_date." ".$on_what_time;
                if(empty($hra_file_history_array))
                {
                    if($component_status==false) { $componet_value=null;}
                    $hra_file_history_array = array("last_updated"=>$current_time,"history"=>array());
                    array_push($hra_file_history_array["history"],array(
                     "modified"=>array(
                         array("component"=>$what_modified,
                                "date"=>$on_what_date,
                                "time"=>$on_what_time,
                                "status"=>$component_status,
                                "value"=>$componet_value)
                            )));
                }
                else
                {
                    if($component_status==false) { $componet_value=null;}
                    $hra_file_update_array_history = $hra_file_history_array["history"];
                    array_push($hra_file_update_array_history,array(
                        "modified"=>array(
                            array("component"=>$what_modified,
                                   "date"=>$on_what_date,
                                   "time"=>$on_what_time,
                                   "status"=>$component_status,
                                   "value"=>$componet_value)
                               )));
                    $hra_file_history_array["history"]=$hra_file_update_array_history;
                }

                return $hra_file_history_array;
            }

            private function updateHraHistoryByComponent($hra_file_history_row,$what_modified,$on_what_date,$on_what_time,
                                                                    $component_status,$componet_value,$component_data_changed)
            {
                $is_what_modified_found = false;
                $hra_file_history_what_modified = $hra_file_history_row["modified"];
                if(is_array($hra_file_history_what_modified))
                {
                    $modified_count = count($hra_file_history_what_modified);
                    for($hmc=0;$hmc<$modified_count;$hmc++)
                    {
                        $modified_comp_array = $hra_file_history_what_modified[$hmc];
                       
                        //if value not found
                        if($modified_comp_array["component"]==$what_modified)
                        {
                            $is_what_modified_found = true;
                            if($component_status==false) { $componet_value=null;}
                            //if value found update the time at which the component updated
                            if($component_data_changed)
                            {
                                $modified_comp_array["date"]=$on_what_date;
                                $modified_comp_array["time"]=$on_what_time;
                            }
                            $modified_comp_array["status"]=$component_status;
                            $modified_comp_array["value"]=$componet_value;
                            $hra_file_history_what_modified[$hmc] = $modified_comp_array;
                        }
                    }

                    if($is_what_modified_found===false)
                    {
                        if($component_status==false) { $componet_value=null;}
                        $what_modified_at_time= array("component"=>$what_modified,
                                                "date"=>$on_what_time,
                                                "time"=>$on_what_time,
                                                "status"=>$component_status,
                                                "value"=>$componet_value);
                        array_push($hra_file_history_what_modified,$what_modified_at_time);
                    }

                    $hra_file_history_row["modified"] = $hra_file_history_what_modified;
                    
                }
                //echo "hra_file_history_row".json_encode($hra_file_history_row)."\n";
                return $hra_file_history_row;

            }

            /*
                NAME : findAndUpdateHraFileHistoryByFirstRow
                DETAILS : find and updated the first row of the history array when specific component updated
            */
            private function findAndUpdateHraFileHistoryByFirstRow($hra_file_history_array,$what_modified,$on_what_date,
                                                $on_what_time,$component_status,$componet_value,$component_data_changed)
            {
                $current_time = $on_what_date." ".$on_what_time;
                $already_date_found = false;
                if(is_array($hra_file_history_array))
                {
                    $hra_file_history_array["last_updated"] = $current_time;
                    if(array_key_exists("history",$hra_file_history_array))
                    {
                        $hra_file_update_array_history = $hra_file_history_array["history"];
                        if(is_array($hra_file_update_array_history))
                        {
                            $hra_file_history_count = count($hra_file_update_array_history);
                            for($hfh=0;$hfh<$hra_file_history_count;$hfh++)
                            {
                                $hra_file_history_row=$hra_file_update_array_history[$hfh];
                                if($hra_file_history_row)
                                {
                                    $hra_file_history_row_updated = $this->updateHraHistoryByComponent($hra_file_history_row,$what_modified,
                                                                    $on_what_date,$on_what_time,$component_status,
                                                                    $componet_value,$component_data_changed);
                                    $hra_file_update_array_history[$hfh]=$hra_file_history_row_updated;
                                    $already_date_found = true;
                                }
                            }
                        }
                        $hra_file_history_array["history"] = $hra_file_update_array_history;
                    }
                }

                //if date already not found than add new hra json file history
                if($already_date_found==false)
                {
                    $hra_file_history_array=$this->addHraHistoryInArray($hra_file_history_array,$what_modified,$on_what_date,
                                                $on_what_time,$component_status,$componet_value,$component_data_changed);
                }

                return $hra_file_history_array;
            }

            private function compareArray($array_a,$array_b)
            {
                $is_array_a = is_array($array_a);
                $is_array_b = is_array($array_b);
               
                if($is_array_a==1 && $is_array_b==1)
                {
                    if($array_a==$array_b)
                    {
                        return true;
                    }
        
                }
                return false;
            }

            private function compareJsonString($json_content_a,$json_content_b)
            {

                return true;
            }

            private function getFileModifiedDate($client_id,$year,$member_id)
            {
                $member_json_file_path = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
                if(file_exists($member_json_file_path))
                {
                    $file_modified_time = filemtime($member_json_file_path);
                    $file_modified_date=date("m-d-Y", $file_modified_time);
                    return $file_modified_date;
                }

                return NULL;
            }

            private function getFileModified($client_id,$year,$member_id)
            {
                $member_json_file_path = '../hrajsondata/HRA_member_'.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
                if(file_exists($member_json_file_path))
                {
                    $file_modified_time = filemtime($member_json_file_path);
                    $file_modified_date=date("m-d-Y", $file_modified_time);
                    $file_modified_time=date("H:i:s", $file_modified_time);
                    return array("date"=>$file_modified_date,"time"=>$file_modified_time);
                }

                return NULL;
            }

            private function getHraJsonAnswerChanges($client_id,$year,$hra_json_content)
            {
                $modified_section = array();

                return $modified_section;
            }

            private function getJsonAnswerByTitle($hra_json_content,$component_title_name_array)
		    {
                    $hra_json_array = json_decode($hra_json_content,true);
                    if($hra_json_array)
                    {
                        $array_count = count($hra_json_array);
                        if($array_count)
                        {
                            if(array_key_exists('data', $hra_json_array))
                            {
                                $hra_data_count = count($hra_json_array["data"]);
                                if($hra_data_count)
                                {
                                    for($ans=0;$ans<$hra_data_count;$ans++)
                                    {
                                        $answer_data_value=$hra_json_array["data"][$ans];
                                        if($answer_data_value)
                                        {
                                            if(array_key_exists('t', $answer_data_value))
                                            {
                                                $title_value = $answer_data_value["t"];
                                                if (in_array($title_value, $component_title_name_array))
                                                {
                                                    if(array_key_exists('q', $answer_data_value))
                                                    {
                                                        return $answer_data_value["q"];  
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    
			    return NULL;
		    }

    }

    $hra_file_migration = new HraHistoryDataBaseMigration;
    echo "----------------------------- Client 004 *** 2020 --------------------\n";
    $hra_file_migration->migrateClientForHraFileHistory("client_004",2020);
    
?>