<?php

//access control allow Header 
include("../AccessControlAllowHeader.php");

//other include files
require_once("../utility/JwtUtility.php");
require_once("../utility/Utility.php");
require_once("../auth/UserUtility.php");
require_once("../TimeZone.php");
require_once("../utility/ResponseUtility.php");

class nurse
{
	public function generate_RandomNumber()
	{
		return mt_rand(100000, 99999999);
	}

	public function nurseRegister()
	{
		include("../db.php");
		$fetched_email = $GLOBALS['inputData']['data']['email'];
		$fetched_username = $GLOBALS['inputData']['data']['username'];
		$licenseNumber = $GLOBALS['inputData']['data']['licenseNumber'];
		$fetched_password = $GLOBALS['inputData']['data']['password'];
		$firstName = $GLOBALS['inputData']['data']['firstName'];
		$lastName = $GLOBALS['inputData']['data']['lastName'];
		$uniqueId = $GLOBALS['input']->{'id'};
		$eight_digit_random_number = $this->generate_RandomNumber();
		$query = "select * from userLogin where username='$fetched_username'";
		$result=mysqli_query($conn,$query);
		if(mysqli_num_rows($result) == 0)
		{
			$Emailquery = "select * from userLogin where email='$fetched_email'";
			$resultEmail=mysqli_query($conn,$Emailquery);
			if(mysqli_num_rows($resultEmail) == 0)
			{
				$jsonn_data = $GLOBALS['inputData']['data'];
				$jsonn_data['password']="";//do not save password here
				$jsonn_data1 = json_encode($jsonn_data);

				TimeZone::useTimeZone();
				$date = date('d-m-Y h:i:s');
				$licenseNumber = isset($licenseNumber) ? $licenseNumber : '';
				$password_hash = Utility::generatePasswordHash($fetched_password);
				$insert_nursesql="insert into userLogin(type,userUniqueno,licenseNumber,username,password_hash,firstname,lastname,userStatus,email,userInfo,admin_idno,securityQuestionStatus,signatureStatus,created_on) values('nurse','$eight_digit_random_number','$licenseNumber','$fetched_username','$password_hash','$firstname','$lastName','1','$fetched_email','$jsonn_data1','$uniqueId','0','0','$date')";
				 try 
				 {
					mysqli_query($conn, $insert_nursesql);

					//update the nurse client privileges
					$user_clients = $GLOBALS['inputData']['userClients'];
					$user_unique_id = $eight_digit_random_number;
					$role="";
					UserUtility::OnUserClientPrivilegesUpdated($role,$user_unique_id,$user_clients);

					$response = new stdClass();
					$response->status = "Saved";
					$response->nurseuniqueno = $eight_digit_random_number;
					$response = json_encode($response);
					echo $response;
				}
				catch (Exception $e)
				{
					$error = $e->getMessage();
					echo $error;
				}	
			}
			else
			{
				$response = new stdClass();
				$response->status = "emailExists";
				$response = json_encode($response);
				echo $response;
			}
		}
		else
		{
			$response = new stdClass();
			$response->status = "usernameExists";
			$response = json_encode($response);
			echo $response;
		}
		
	}

	/*
		NAME    : Register
		TYPE    : api Utiltiy function 
		DETAILS :  
		RETURN  :  return response based on user registration
    */
	public function Register($request_body_array,$recursive_count = 0)
	{
			//database connection
			include("../db.php");
			//entire user request body
			$request_data_array = $request_body_array['data'];
			$admin_unique_id = $request_body_array['id'];//admin who resgister user
			//data array of the body
			$fetched_email = $request_data_array['email'];
			$fetched_username = $request_data_array['username'];
			$license_number = $request_data_array['licenseNumber'];
			$fetched_password = $request_data_array['password'];
			$first_name = $request_data_array['firstName'];
			$last_name = $request_data_array['lastName'];
			
			//generate unique random number
			$generate_user_unique_id = $this->generate_RandomNumber();//it needs to be rectified in migration

			$user_details = DataBaseUtility::getUserById($generate_user_unique_id);
			if($user_details == null)
			{
				$user_name_details = DataBaseUtility::getUserIdByUserName($fetched_username);
				if($user_name_details == null)
				{
					//email already present for user role
					$email_role_details = DataBaseUtility::getUserByEmailAndRole($fetched_email,'nurse');
					if($email_role_details == null)
					{ 
							$user_unique_id = $generate_user_unique_id;

							$nurse_json_data = $request_data_array;
							$nurse_json_data['password']="...";//do not store password here
							$encoded_nurse_info = json_encode($nurse_json_data);

							TimeZone::useTimeZone();
							$created_on = date('d-m-Y h:i:s');

							$license_number = isset($license_number) ? $license_number : '';
							$password_hash = Utility::generatePasswordHash($fetched_password);
							
							$security_question_status = 0;
							$signature_status = 0;
							$user_status = 1;
							$role ='nurse';

							$user_insert_query = $conn->prepare('INSERT INTO userLogin(type,userUniqueno,licenseNumber,
																	username,password_hash,firstname,lastname,
																	userStatus,email,userInfo,admin_idno,
																	securityQuestionStatus,signatureStatus,created_on
																	) 
																	VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
							
							$user_insert_query->bind_param("sisssssisssiis",$role,$user_unique_id,$license_number,
																	$fetched_username,$password_hash,$first_name,$last_name,
																	$user_status,$fetched_email,$encoded_nurse_info,$admin_unique_id,
																	$security_question_status,$signature_status,$created_on
																	);
							$user_insert_query->execute();
							if($user_insert_query->affected_rows>0)
							{
								//update the nurse client privileges
								$user_clients = $request_body_array['userClients'];
								
								UserUtility::OnUserClientPrivilegesUpdated($role,$user_unique_id,$user_clients);

								$response = ResponseUtility::responseWithErrorMessage(UserRegisterStatus::SUCCESS,
																	"new user registered successfully","");
								$response->nurseuniqueno = $generate_user_unique_id;
								echo json_encode($response);
							}
							else
							{
								echo ResponseUtility::jsonResponseWithErrorMessage(
									UserRegisterStatus::FAILED,"user registration failed","database insert issue");
							}

					}
					else
					{
						//same email already assigned for this role
						echo ResponseUtility::jsonResponseWithErrorMessage(
							UserRegisterStatus::EMAIL_ALREADY_FOR_ROLE,
									"e-mail id already available for the user role","");
					}
				}
				else
				{
					//user name already available
					echo ResponseUtility::jsonResponseWithErrorMessage(
						UserRegisterStatus::USER_NAME_AVAILABLE,
								"username already available","");
				}
			}
			else
			{
				//limit the recursive execution 
				if($recursive_count>=UserRegisterConstant::MAX_REGISTRATION_TRY_COUNT)
				{
					//break the limit
					echo ResponseUtility::jsonResponseWithErrorMessage(
						UserRegisterStatus::FAILED,"user registration failed","issue creating user id");
					return;
				}
				//when unique user unique id failed
				//try recursively again
				$this->Register($request_body_array,++$recursive_count);
			}

	}
	

	public function showAllNurse()
	{
		include("../db.php");
		$allfetch_recordquery="select * from userLogin";
		try {
			$allpatientinfo_result=mysqli_query($conn,$allfetch_recordquery);
			while($allpatientinfo_row=mysqli_fetch_array($allpatientinfo_result,MYSQLI_ASSOC))
			{
				$jon_nurseinfo = $allpatientinfo_row['userInfo'];
				$nurse_uniqueno = $allpatientinfo_row['userUniqueno'];
				$nurseStatus = $allpatientinfo_row['userStatus'];
				$signature = $allpatientinfo_row['signature'];
				$signatureStatus = $allpatientinfo_row['signatureStatus'];
				$nurse_uniqueno = isset($nurse_uniqueno) ? $nurse_uniqueno : '';
				$nurse_data[]=array("nurseUniqueno"=>$nurse_uniqueno,"nurseinfo"=>$jon_nurseinfo,"nurseStatus"=>$nurseStatus,"signature"=>$signature,"signatureStatus"=>$signatureStatus);
				
			}
			echo json_encode($nurse_data);
			
		}
		catch (Exception $e)
		{
		 	$error = $e->getMessage();
		 	echo $error;
		}
		
	}

	public function nurseMember($clientId,$year,$uniqueId)
	{
		include("../db.php");
		$allmemeber_recordquery="select * from HRA_member_".$clientId.'_'.$year." where nurse_id='$uniqueId'";
		$allmemberinfo_result=mysqli_query($conn,$allmemeber_recordquery);
		$counttt = mysqli_num_rows($allmemberinfo_result);
		
		 if($counttt != 0)
		 {
			 while($allmemberinfo_row=mysqli_fetch_array($allmemberinfo_result,MYSQLI_ASSOC))
			 {

				$memberinfo = $allmemberinfo_row['memberinfo']; 
				$hra1 = $allmemberinfo_row['hra']; 
				$scheduleDate = $allmemberinfo_row['scheduleDate'];
				$termDate = $allmemberinfo_row['termDate'];
				$EvaluationDate = $allmemberinfo_row['EvaluationDate'];
				$hraStatus = $allmemberinfo_row['hraStatus']; 
				$visitType = $allmemberinfo_row['VisitType']; 
				$versioning = $allmemberinfo_row['versioning']; 
				$clientid = $allmemberinfo_row['clientid'];
				$year = $allmemberinfo_row['year'];
				$uploadedfiles = $allmemberinfo_row['uploadedfiles'];
				$ccd = isset($uploadedfiles) ? $uploadedfiles : '';
				$coderid = $allmemberinfo_row['coder_id'];
				$qa_id = $allmemberinfo_row['qa_id'];
				$query_form = $allmemberinfo_row['query_form'];
				$coderid = isset($coderid) ? $coderid : '';
				$qaid = isset($qa_id) ? $qa_id : '';
				
				//newly added field response updated on 20_10_2020
				$scheduler_id =$allmemberinfo_row['scheduler_id']; $scheduler_id = isset($scheduler_id) ? $scheduler_id : '';
				$hra_status_history = $allmemberinfo_row['hraStatusHistory']; 
				$cancel_history = $allmemberinfo_row['cancelHistory'];
				//report fileds
				$sent_to_avility = $allmemberinfo_row['sentToAvility'];
				$invoice_date = $allmemberinfo_row['invoiceDate'];
				$notes = $allmemberinfo_row['reportNotes'];
				//scheduler
				$avail_for_schedule = $allmemberinfo_row['availForSchedule'];

				$scheduleDate = isset($scheduleDate) ? $scheduleDate : '';
				$termDate = isset($termDate) ? $termDate : '';
				$EvaluationDatee = isset($EvaluationDate) ? $EvaluationDate : '';
				
				//newly added field response updated on 20_10_2020
				$member_data[]=array("memberinfo"=>$memberinfo,"hraStatus"=>$hraStatus,"visitType"=>$visitType,"versioning"=>$versioning,
					"scheduleDate"=>$scheduleDate,"termDate"=>$termDate,"EvaluationDate"=>$EvaluationDatee,"clientid"=>$clientid,
					"year"=>$year,"ccd"=>$ccd,"query_form"=>$query_form,"coderid"=>$coderid,"qa_id"=>$qaid,"schedulerId"=> $scheduler_id,
					"hraStatusHistory"=>$hra_status_history,"cancelHistory"=>$cancel_history,"sentToAvility"=>$sent_to_avility,
					"invoiceDate"=>$invoice_date,"notes"=>$notes,"availForSchedule"=>$avail_for_schedule);
				
			 }
			 echo json_encode($member_data);
		 }
		 else
		 {
			 		$response = new stdClass();
					$response->status = 'null';
					$response = json_encode($response);
					echo $response; 
		 }
		 
	}


		public function editnurse()
		{
				include("../db.php");
				$array_data = $GLOBALS['inputData']['data'];
				$json_data = json_encode($array_data); 
				$licenseNumber = $GLOBALS['inputData']['data']['licenseNumber'];
				$firstName = $GLOBALS['inputData']['data']['firstName'];
				$lastName = $GLOBALS['inputData']['data']['lastName'];
				$username = $GLOBALS['inputData']['data']['username'];
				$password = $GLOBALS['inputData']['data']['password'];
				$nurseid = $GLOBALS['inputData']['data']['nurseid'];
				$uniqueId = $GLOBALS['input']->{'id'};
				
				$update_nurserecord = "update userLogin set licenseNumber='$licenseNumber',username='$username',firstname='$firstName',lastname='$lastName',userInfo='$json_data' where userUniqueno='$uniqueId'";
				try
				{
					mysqli_query($conn, $update_nurserecord);

					//update the nurse client privileges
					$user_clients = $GLOBALS['inputData']['userClients'];
					$user_unique_id = $uniqueId;
					$role="";
					UserUtility::OnUserClientPrivilegesUpdated($role,$user_unique_id,$user_clients);
					
					$response = new stdClass();
					$response->status = "Saved";
					$response = json_encode($response);
					echo $response;
				}
				catch (Exception $e)
				{
					$response = new stdClass();
					$response->status = "not Saved";
					$response->error = $e->getMessage();
					echo json_encode($response);
				}
				
		}

		public function changeNurseStatus()
		{
				include("../db.php");
				$nurseId = $GLOBALS['inputData']['data']['nurseId'];
				$adminId = $GLOBALS['inputData']['data']['adminId'];
				$loginStatus = $GLOBALS['inputData']['data']['loginStatus'];
				$updateNurseStatus="update userLogin set userStatus='$loginStatus' where userUniqueno='$nurseId' ";
				try 
				{
					mysqli_query($conn, $updateNurseStatus);
					$updated_res = mysqli_affected_rows($conn);
					if($updated_res)
					{
						$response = new stdClass();
						$response->status = "updated";
						$response = json_encode($response);
						echo $response;
					}
					else
					{
						$response = new stdClass();
						$response->status = "notupdated";
						$response = json_encode($response);
						echo $response;
					}
					
				}
				catch (Exception $e)
				{
					$error = $e->getMessage();
					echo $error;
				}
		}
	
}

//validate token
$token_validation_result = JwtUtility::isValidToken();
if($token_validation_result !== JwtUtility::VALID_TOKEN)
{     
	//un authorized access 
    JwtUtility::exitWithUnAuthorizedResponse($token_validation_result);
}
//end of token validation

$nurse = new nurse;
$method = $_SERVER['REQUEST_METHOD'];
$requestedurl = $_SERVER['REQUEST_URI'];
$arrayurlstring = explode("/",$requestedurl);
$crcount = count($arrayurlstring);
$crcountt = $crcount -1;
$requestMethod = $arrayurlstring[$crcountt];
$exploded = explode("?",$requestMethod);
$requestMethod = $exploded[0];

 switch ($method)
 {
	 case 'POST' :
		$postdata = file_get_contents("php://input");
		$request = json_decode($postdata);
		$requestt = json_decode($postdata,true);
		$GLOBALS['inputData'] = $requestt;
		$GLOBALS['input'] = $request;
			switch($requestMethod)
			{
				case 'nurseRegister' :
					$nurse->nurseRegister();
				break;

				//new updated nurse register method 18-06-2021
				case 'Register' :
					$request_body_array = Utility::parseRequestBodyFormat();
					$nurse->Register($request_body_array);
				break;
				
				case 'editnurse' :
					$nurse->editnurse();
				break;

				case 'changeNurseStatus' :
					$nurse->changeNurseStatus();
				break;
			}
			break;
	 
	 case 'GET' :
		switch($requestMethod)
		{
			case 'showAllNurse' :
				$nurse->showAllNurse();
			break;
			
			case 'nurseMember' :
				$clientId = $_GET['clientId'];
				$year = $_GET['year'];
				$uniqueId = $_GET['id'];
				$nurse->nurseMember($clientId,$year,$uniqueId);
			break;
		}
	 break;
 }
?>