<?php

/*
	REPORT GLOBAL API 
	Created On : 
*/

//access control allow Header 
include("../AccessControlAllowHeader.php");

//other include files
require_once("../utility/JwtUtility.php");
require_once("../TimeZone.php");
require_once("ReportGlobalMembers.php");
require_once("../global/GlobalHelper.php");

//validate token
$token_validation_result = JwtUtility::isValidToken();
if($token_validation_result !== JwtUtility::VALID_TOKEN)
{     
	//un authorized access 
    JwtUtility::exitWithUnAuthorizedResponse($token_validation_result);
}
//end of token validation

//create report api definition object
$nurse_global_members = new ReportGlobalMembers;
//parse the request 
$method = $_SERVER['REQUEST_METHOD'];
$requestedurl = $_SERVER['REQUEST_URI'];
$arrayurlstring = explode("/",$requestedurl);
$crcount = count($arrayurlstring);
$crcountt = $crcount -1;
$requestMethod = $arrayurlstring[$crcountt];
$exploded = explode("?",$requestMethod);
$requestMethod = $exploded[0];

  switch ($method) {

        case 'POST':
include("../db.php");
            $postdata = file_get_contents("php://input");

			$request = json_decode($postdata);
			$requestt = json_decode($postdata,true);

			$GLOBALS['inputData'] = $requestt;
			$GLOBALS['input'] = $request;

            switch($requestMethod)
            {
                case 'refreshHomeAccess':

                   $plan_id = $GLOBALS['inputData']['planId'];
                    $year = $GLOBALS['inputData']['year'];
                    try{
                  $overallmemberids =   $nurse_global_members->gethomeaccessmemberslist($plan_id,$year);
                 $overallcount = 0;
                 $updatedcount = 0;
foreach($overallmemberids as $clientids => $member_ids){
   $overallcount =  $overallcount  +  count($member_ids);
   $array_memberid = array_column($member_ids,'member_id');
   $member_id_string = "";
    $memiuds = implode("','",$array_memberid);

TimeZone::useTimeZone();
$current_date = date("Y-m-d");

$update_refresh = "UPDATE HRA_member_".$clientids.'_'.$year." SET `isDownload` = 1,DownloadDate = '$current_date'  WHERE `member_id` IN ('$memiuds') and ".GlobalQueryBuilder::sqlCustomColumnHomeValidRecords(). "is not null and isDownload is null";

$updated_response = NULL;
$updated_result=mysqli_query($conn,$update_refresh);
$updated_response = mysqli_affected_rows($conn);

 $updatedcount = $updatedcount +  $updated_response;

}

if($updated_response){
    $response = new stdClass();
$response->status = "success";
$response->totalmemberidssent = $overallcount;
$response->totalmemberidsupdate = $updatedcount;
 if($overallcount!=$updatedcount){$response->error = "but some invalid member ids";}
$response = json_encode($response);
}else{

    $response = new stdClass();
    if($overallcount!=$updatedcount)
    {
        $response->status = "failed";
        $response->error = "some invalid member ids";
    }
    else
    {
        $response->status = "success";
        $response->message = "no change";
    }
    $response->totalmemberidssent = $overallcount;
    $response->totalmemberidsupdate = $updatedcount;
    $response = json_encode($response);

}
echo $response;
}
catch (Exception $e)
{
    $error = $e->getMessage();
    echo $error;
}


				break;    
            }
        break;

	   case 'GET' :
            switch($requestMethod)
            {

                case 'reportmontlyscreeningresult' :

                    $parameters=[];
                 
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('year',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('clientId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('min',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('max',$parameters);
                    //tap ID
                    $parameters = ArrayUtility::appendIfVaildUrlParameter('tabId',$parameters);
                    //sort params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortBy',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortOrder',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('sortBy',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('sortOrder',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('page',$parameters);
                    //search params
                    $parameters = ArrayUtility::appendIfVaildUrlParameter('isSearchApplied',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('firstname',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('lastname',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('id',$parameters);

                    $nurse_global_members->reportmontlyscreeningresult($parameters,$error);


                    break;

                    case 'searchmontlyscreeningresult' :
                        $parameters=[];
                      
                        $parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$parameters);
                        $parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$parameters);
                        $parameters= ArrayUtility::appendIfVaildUrlParameter('year',$parameters);
                        $parameters= ArrayUtility::appendIfVaildUrlParameter('clientId',$parameters);
                        $parameters= ArrayUtility::appendIfVaildUrlParameter('min',$parameters);
                        $parameters= ArrayUtility::appendIfVaildUrlParameter('max',$parameters);
                        //tap ID
                        $parameters = ArrayUtility::appendIfVaildUrlParameter('tabId',$parameters);
                        //sort params
                        $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortBy',$parameters);
                        $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortOrder',$parameters);
                        $parameters= ArrayUtility::appendIfVaildUrlParameter('sortBy',$parameters);
                        $parameters= ArrayUtility::appendIfVaildUrlParameter('sortOrder',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('page',$parameters);

                                            //optional search params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('firstname',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('lastname',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('id',$parameters);
                        $parameters= ArrayUtility::appendIfVaildUrlParameter('page',$parameters);
                           $nurse_global_members->searchmontlyscreeningresult($parameters,$error);
    
    
                        break;

                        case 'filtermontlyscreeningresult' :
                            $filter_parameters=[];
                              $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$filter_parameters);
                              $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$filter_parameters);
                              $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('year',$filter_parameters);
                              $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('clientId',$filter_parameters);
                              $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('min',$filter_parameters);
                              $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('max',$filter_parameters);
                              //tap ID
                              $filter_parameters = ArrayUtility::appendIfVaildUrlParameter('tabId',$filter_parameters);
                              $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('program',$filter_parameters);
                              $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('lob',$filter_parameters);
                             $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('plan',$filter_parameters);
                              $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('scheduledFrom',$filter_parameters);
                              $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('scheduledTo',$filter_parameters);
				$filter_parameters= ArrayUtility::appendIfVaildUrlParameter('screening',$filter_parameters);

                              //sort params
                              $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortBy',$filter_parameters);
                              $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortOrder',$filter_parameters);
                              $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('sortBy',$filter_parameters);
                              $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('sortOrder',$filter_parameters);
                              $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('page',$filter_parameters);
                              $nurse_global_members->filtermontlyscreeningresult($filter_parameters,$error);
 
                            break;

                case 'Members':
                    $parameters=[];
                    //must params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('year',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('min',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('max',$parameters);
                    //tap ID
                    $parameters = ArrayUtility::appendIfVaildUrlParameter('tabId',$parameters);
                    //sort params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortBy',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortOrder',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('sortBy',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('sortOrder',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('type',$parameters);
                    //search params
                    $parameters = ArrayUtility::appendIfVaildUrlParameter('isSearchApplied',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('firstname',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('lastname',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('id',$parameters);
                    //call api
                    $error="";
                    if(GlobalHelper::isDefaultValidParameter($parameters))
                    {
                        
                        if($nurse_global_members->getMembers($parameters,$error)) { exit();}
                    }
                    
                    GlobalHelper::echoFailedResponse($error);
                break;

                case 'clientWiseDataPresAndPrev':
                    $parameters=[];
                    //must params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('year',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('min',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('max',$parameters);
                    //tap ID
                    $parameters = ArrayUtility::appendIfVaildUrlParameter('tabId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('type',$parameters);
                    //call api
                    $error="";
                    if(GlobalHelper::isDefaultValidParameter($parameters))
                    {
                        if($nurse_global_members->clientWiseDataPresAndPrev($parameters,$error)) { exit();}
                    }
                    GlobalHelper::echoFailedResponse($error);
                    break;

                case 'clientWiseReportCount':
                    $parameters=[];
                    //must params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('year',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('min',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('max',$parameters);
                    //tap ID
                    $parameters = ArrayUtility::appendIfVaildUrlParameter('tabId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('type',$parameters);

                    //call api
                    $error="";
                    if(GlobalHelper::isDefaultValidParameter($parameters))
                    {
                        if($nurse_global_members->clientWiseReportCount($parameters,$error)) { exit();}
                    }
                    GlobalHelper::echoFailedResponse($error);
                    break;

                case "Search":
                    $search_parameters =[];
                    //must params
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('year',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('min',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('max',$search_parameters);
                    //tab id
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('tabId',$search_parameters);
                    //optional search params
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('isSearchApplied',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('firstname',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('lastname',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('id',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('city',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('zip',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('plan',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('program',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('lob',$search_parameters);
                    //sort param
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortBy',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortOrder',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('sortBy',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('sortOrder',$search_parameters);
                    //call api
                    $error="";
                    if(GlobalHelper::isDefaultValidParameter($search_parameters))
                    {
                        //if($nurse_global_members->search($search_parameters,$error))  { exit();}
                        if($nurse_global_members->reportSearch($search_parameters,$error))  { exit();}
                    }
                    GlobalHelper::echoFailedResponse($error);

                break;

                case 'Filter':
                    $filter_parameters =[];
                    //must params
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('year',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('min',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('max',$filter_parameters);
                    //tab id
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('tabId',$filter_parameters);
                    //optional filter parameters
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('scheduledFrom',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('scheduledTo',$filter_parameters);

                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('refusalFrom',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('refusalTo',$filter_parameters);

                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('dateOfUploadFrom',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('dateOfUploadTo',$filter_parameters);
                    
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('clientId',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('plan',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('program',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('lob',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('city',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('hraStatus',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('visitType',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('qaIds',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('coderIds',$filter_parameters);
					$filter_parameters= ArrayUtility::appendIfVaildUrlParameter('nurseIds',$filter_parameters);
					$filter_parameters= ArrayUtility::appendIfVaildUrlParameter('status',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('schedulerIds',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('schedulerIds',$filter_parameters);
                    //sort params
                    $filter_parameters = ArrayUtility::appendIfVaildUrlParameter('baseSortBy', $filter_parameters);
                    $filter_parameters = ArrayUtility::appendIfVaildUrlParameter('baseSortOrder', $filter_parameters);
                    $filter_parameters = ArrayUtility::appendIfVaildUrlParameter('sortBy', $filter_parameters);
                    $filter_parameters = ArrayUtility::appendIfVaildUrlParameter('sortOrder', $filter_parameters);
                    $filter_parameters = ArrayUtility::appendIfVaildUrlParameter('screening', $filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('screeningStatus',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('screeningData',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('eligibility',$filter_parameters);
                    //call api
                    $error="";
                    if(GlobalHelper::isDefaultValidParameter($filter_parameters))
                    {
                        if($nurse_global_members->filter($filter_parameters,$error)) { exit();}
                    }
                    
                    GlobalHelper::echoFailedResponse($error); 
                break;

                case 'WeekwiseWeeklyReport':
                    $parameters=[];
                    //must params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('year',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('min',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('max',$parameters);
                    //tap ID
                    $parameters = ArrayUtility::appendIfVaildUrlParameter('tabId',$parameters);
                    //sort params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortBy',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortOrder',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('sortBy',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('sortOrder',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('type',$parameters);

                    //call api
                    $error="";
                    if(GlobalHelper::isDefaultValidParameter($parameters))
                    {
                        
                        if($nurse_global_members->weekwiseWeeklyReport($parameters,$error)) { exit();}
                    }
                    
                    GlobalHelper::echoFailedResponse($error);
                break;

                case 'BulkExportMembers':
                    $parameters=[];
                    //must params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('year',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('min',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('max',$parameters);
                    //tap ID
                    $parameters = ArrayUtility::appendIfVaildUrlParameter('tabId',$parameters);
                    //sort params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortBy',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortOrder',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('sortBy',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('sortOrder',$parameters);
                    //call api
                    $error="";
                    if(GlobalHelper::isDefaultValidParameter($parameters))
                    {

                        if($nurse_global_members->getMembersForBulkExport($parameters,$error)) { exit();}
                    }

                    GlobalHelper::echoFailedResponse($error);
                    break;

                case "reportSearch":
                    $search_parameters =[];
                    //must params
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('year',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('min',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('max',$search_parameters);
                    //tab id
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('tabId',$search_parameters);
                    //optional search params
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('isSearchApplied',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('firstname',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('lastname',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('id',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('city',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('zip',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('plan',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('program',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('lob',$search_parameters);
                    //sort param
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortBy',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortOrder',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('sortBy',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('sortOrder',$search_parameters);
                    //call api
                    $error="";
                    if(GlobalHelper::isDefaultValidParameter($search_parameters))
                    {
                        if($nurse_global_members->reportSearch($search_parameters,$error))  { exit();}
                    }
                    GlobalHelper::echoFailedResponse($error);

                    break;

                case 'reportFilter':
                    $filter_parameters =[];
                    //must params
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('year',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('min',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('max',$filter_parameters);
                    //tab id
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('tabId',$filter_parameters);
                    //optional filter parameters
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('scheduledFrom',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('scheduledTo',$filter_parameters);

                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('refusalFrom',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('refusalTo',$filter_parameters);

                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('clientId',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('plan',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('program',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('lob',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('city',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('hraStatus',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('visitType',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('qaIds',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('coderIds',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('nurseIds',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('status',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('schedulerIds',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('schedulerIds',$filter_parameters);
                    //sort params
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortBy',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortOrder',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('sortBy',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('sortOrder',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('screening',$filter_parameters);
                    //call api
                    $error="";
                    if(GlobalHelper::isDefaultValidParameter($filter_parameters))
                    {
                        if($nurse_global_members->reportFilter($filter_parameters,$error)) { exit();}
                    }

                    GlobalHelper::echoFailedResponse($error);
                    break;

                case 'allScreeningsMember':
                    $parameters = [];
                    //must params
                    $parameters = ArrayUtility::appendIfVaildUrlParameter('planId', $parameters);
                    $parameters = ArrayUtility::appendIfVaildUrlParameter('userId', $parameters);
                    $parameters = ArrayUtility::appendIfVaildUrlParameter('year', $parameters);

                    $parameters = ArrayUtility::appendIfVaildUrlParameter('min', $parameters);
                    $parameters = ArrayUtility::appendIfVaildUrlParameter('max', $parameters);
                    //tap ID
                    $parameters = ArrayUtility::appendIfVaildUrlParameter('tabId', $parameters);

                    $error = "";
                    if (GlobalHelper::isDefaultValidParameter($parameters)) {
                        if ($nurse_global_members->getAllScreeningsMember($parameters, $error)) {
                            exit();
                        }
                    }
                    GlobalHelper::echoFailedResponse($error);
                    break;

                
                case 'reportrefusalscreeningresult' :

                    $parameters=[];
                    
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('year',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('clientId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('min',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('max',$parameters);
                    //tap ID
                    $parameters = ArrayUtility::appendIfVaildUrlParameter('tabId',$parameters);
                    //sort params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortBy',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortOrder',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('sortBy',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('sortOrder',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('page',$parameters);
                    //search params
                    $parameters = ArrayUtility::appendIfVaildUrlParameter('isSearchApplied',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('firstname',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('lastname',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('id',$parameters);

                    $nurse_global_members->reportrefusalscreeningresult($parameters,$error);
                    break;

                case 'searchrefusalscreeningresult' :
                    $parameters=[];
                    
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('year',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('clientId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('min',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('max',$parameters);
                    //tap ID
                    $parameters = ArrayUtility::appendIfVaildUrlParameter('tabId',$parameters);
                    //sort params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortBy',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortOrder',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('sortBy',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('sortOrder',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('page',$parameters);

                    //optional search params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('firstname',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('lastname',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('id',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('page',$parameters);
                    $nurse_global_members->searchrefusalscreeningresult($parameters,$error);
                    break;

                case 'filterrefusalscreeningresult' :
                    $filter_parameters=[];
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('year',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('clientId',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('min',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('max',$filter_parameters);
                    //tap ID
                    $filter_parameters = ArrayUtility::appendIfVaildUrlParameter('tabId',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('program',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('lob',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('plan',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('scheduledFrom',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('scheduledTo',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('screening',$filter_parameters);

                    //sort params
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortBy',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortOrder',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('sortBy',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('sortOrder',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('page',$filter_parameters);
                    $nurse_global_members->filterrefusalscreeningresult($filter_parameters,$error);
                    break;
           
                }
        break;



  }


?>
