<?php
    /*

        CLASS : ReportUtility
        DETAILS : all the report related api call
    */

   //access control allow Header 
    include("../AccessControlAllowHeader.php");

    //other include files
    require_once("../utility/JwtUtility.php");
    require_once("../member/MemberUtility.php");
    require_once("../member/HraFileChanges.php");

    class Report
    {
        /*
            NAME : getMemeberScreeningDetails
            TYPE : API function
            DETAILS : get members the screening details based on  the client and year
            RETURN : required screening result data
        */
        public function getMemeberScreeningDetails($client_id,$year)
        {
            include("../db.php"); 

            //create hra file changes utilty class to parse the 'hraFileUpdatedHistory' component details
            $hra_file_change = new HraFileChangesUtility;

            //need to update sql query if nurse name need
            //select member_id,scheduleDate,hraStatus,nurseTable.firstname as nurse_firstname from ( select * from HRA_member_client_001_2021) as member_table 
            //LEFT JOIN userlogin as nurseTable ON nurseTable.userUniqueno = member_table.nurse_id
            
            //only on which hra status response of screening result 
            $hra_status_filter = array(
                MemberUtility::READY_FOR_CODER
            );

            $member_records_query = "select * from HRA_member_".$client_id.'_'.$year;
            $member_records_query_result=mysqli_query($conn,$member_records_query);
            $screening_details = null;
            while($member_row = mysqli_fetch_array($member_records_query_result,MYSQLI_ASSOC))
            { 
                //hra file json updated value and check for screening value changes
                $member_id = $member_row["member_id"];
                $hra_status = $member_row['hraStatus'];
                $hra_status_history = $member_row['hraStatusHistory'];
                $nurse_id = $member_row['nurse_id'];
                $schedule_date = $member_row['scheduleDate'];
                $memberinfo = $member_row['memberinfo'];
                $hra_file_updated_history = $member_row['hraFileUpdatedHistory'];
                
                $hra_status_array = json_decode($hra_status,true);
                if(
                    is_array($hra_status_array) && 
                    array_key_exists("hraStatus",$hra_status_array) ) 
                    //&& in_array($hra_status_array["hraStatus"],$hra_status_filter)) //removed
                {
                    $screen_updated_array = $hra_file_change->getComponentChangedStatus($hra_file_updated_history,"screening");
                    if($screen_updated_array)
                    {
                        if($screen_updated_array["status"]==true)
                        {
                            $demographics_detail_value = $this->getDemoGraphicsValue($hra_file_change,$hra_file_updated_history);
                            
                            $screening_details[] = array("memberId"=>$member_id,
                                            "nurseId"=>$nurse_id,
                                            "hraStatus"=>$hra_status,
                                            "hraStatusHistory"=>$hra_status_history,
                                            "scheduleDate"=>$schedule_date,
                                            "memberInfo"=>$memberinfo,
                                            "demographic"=>$demographics_detail_value,
                                            "screening"=>$screen_updated_array);
                        }
                    }
                }
            }

            //sort the response array based on screening date
            $sorted_screening_details=$this->sortScreenByDateModified($screening_details);
            echo json_encode($sorted_screening_details);
           
        }

        /*
            NAME    : getTotalScreeningCount
            TYPE    : API function
            DETAILS : 
            RETURN  : total screening member count
        */
        public function getTotalScreeningCount($client_id,$year)
        {
            include("../db.php"); 

                        //getting latest updated screening date
                        $LastUpdatedScreenDate = "select
                        member_id,STR_TO_DATE(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.date'
                        ) )),'%m-%d-%Y') AS ScreeningDate FROM HRA_member_".$client_id.'_'.$year." ORDER by ScreeningDate DESC LIMIT 1";
                        
                                    $LastUpdatedScreenDateresult=mysqli_query($conn,$LastUpdatedScreenDate);
                                    $lastestDateres=mysqli_fetch_array($LastUpdatedScreenDateresult,MYSQLI_ASSOC);
                              $todate =  $lastestDateres['ScreeningDate'];

                              $enddate = date('Y-m-d', strtotime($todate));
                              $startdate = date('Y-m-d', strtotime('-7 days', strtotime($enddate))); 
                          //   $startdate =  '2020-10-27';
                           //   $enddate =  '2021-10-27';
                            //fetching one week records based on latest updated screening date
                            $memberids = array();

                            $getMemberList = "select
                            member_id,STR_TO_DATE(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.date'
                            ) )),'%m-%d-%Y') AS ScreeningDate,
                            JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0]'
                            ) )) AS screeningobject
                            FROM HRA_member_".$client_id.'_'.$year." WHERE  STR_TO_DATE(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.date'
                            ) )),'%m-%d-%Y')  BETWEEN '".$startdate."'  and '".$enddate."'";
                            $membersresult=mysqli_query($conn,$getMemberList);
                            
                            while($membersresultres=mysqli_fetch_array($membersresult,MYSQLI_ASSOC)){
                              
                               
                               if($membersresultres['screeningobject'] != 'null' ){
                            $arraydata = json_decode($membersresultres['screeningobject'],true);
                            if($arraydata[1][4] != '' || $arraydata[2][4] != '' || $arraydata[3][4] != '' || $arraydata[6][4] != '')
                            {
                                $member_id=  $membersresultres['member_id'];
                                $memberids[] = $member_id;
                            }
                            }
                            
                            }
                             $memberidslist = "'" . implode ( "', '", $memberids ) . "'";

            $member_records_query = "SELECT COUNT(*) OVER() AS totalRows FROM HRA_member_".$client_id.'_'.$year;
            $member_records_query.=" WHERE
                                        JSON_EXTRACT(
                                            hraFileUpdatedHistory,
                                        REPLACE
                                            (
                                                json_unquote(
                                                    json_search(
                                                        hraFileUpdatedHistory,
                                                        'one',
                                                        'screening'
                                                    )
                                                ),
                                                '.component',
                                                '.status'
                                            )
                                        ) = TRUE and member_id in (".$memberidslist.") 
                                        ";
            $member_details_query=$conn->prepare($member_records_query);
            $member_details_query->execute();
            $member_details_query_result = $member_details_query->get_result();                                
            $member_row = $member_details_query_result->fetch_assoc();
            $toal_rows = $member_row["totalRows"];

            $screening_response = array("totalRows"=>$toal_rows);
            echo json_encode($screening_response);                                      

        }


       /*
            NAME : getMemeberScreeningDetailsWithLimits
            TYPE : API function
            DETAILS : get members the screening details based on  the client and year with limits
                        a) screening details fetched by sql query based on json search
                        b) wrong date format issue fixed when capuring but old date still their
                            to fix that issue wrong date always moved end of the array to show latest screening details
            RETURN : required screening result data
        */
       public function getMemeberScreeningDetailsWithLimits($client_id,$year,$min,$max)
        {
            include("../db.php"); 

            $start_limit = $min;
            if($start_limit<=0) { $start_limit =0;}

            $end_limit = $max-$min;
            if($end_limit<=0) { $end_limit=0;}
            //create hra file changes utilty class to parse the 'hraFileUpdatedHistory' component details
            $hra_file_change = new HraFileChangesUtility;

            //getting latest updated screening date
            $LastUpdatedScreenDate = "select
member_id,STR_TO_DATE(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.date'
) )),'%m-%d-%Y') AS ScreeningDate FROM HRA_member_".$client_id.'_'.$year." ORDER by ScreeningDate DESC LIMIT 1";

            $LastUpdatedScreenDateresult=mysqli_query($conn,$LastUpdatedScreenDate);
            $lastestDateres=mysqli_fetch_array($LastUpdatedScreenDateresult,MYSQLI_ASSOC);
      $todate =  $lastestDateres['ScreeningDate'];

  
        $enddate = date('Y-m-d', strtotime($todate));
          $startdate = date('Y-m-d', strtotime('-7 days', strtotime($enddate))); 
         // $startdate =  '2020-10-27';
        //   $enddate =  '2021-10-27';
        //fetching one week records based on latest updated screening date
        $memberids = array();
    $getMemberList = "select
member_id,STR_TO_DATE(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.date'
) )),'%m-%d-%Y') AS ScreeningDate,
JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0]'
) )) AS screeningobject
FROM HRA_member_".$client_id.'_'.$year." WHERE  STR_TO_DATE(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.date'
) )),'%m-%d-%Y')  BETWEEN '".$startdate."'  and '".$enddate."'";
$membersresult=mysqli_query($conn,$getMemberList);

while($membersresultres=mysqli_fetch_array($membersresult,MYSQLI_ASSOC)){
  
   
   if($membersresultres['screeningobject'] != 'null' ){
$arraydata = json_decode($membersresultres['screeningobject'],true);
if($arraydata[1][4] != '' || $arraydata[2][4] != '' || $arraydata[3][4] != '' || $arraydata[6][4] != '')
{
    $member_id=  $membersresultres['member_id'];
    $memberids[] = $member_id;
}
}

}
 $memberidslist = "'" . implode ( "', '", $memberids ) . "'";


            $member_records_query = "SELECT COUNT(*) OVER() AS totalRows,member_id,hraStatus,hraStatusHistory,nurse_id,
                                        scheduleDate,memberinfo,hraFileUpdatedHistory,JSON_UNQUOTE(
                                                JSON_EXTRACT(
                                                    hraFileUpdatedHistory,
                                                REPLACE
                                                    (
                                                        JSON_UNQUOTE(
                                                            JSON_SEARCH(
                                                                hraFileUpdatedHistory,
                                                                'one',
                                                                'screening'
                                                            )
                                                        ),
                                                        '.component',
                                                        '.date'
                                                    )
                                                )
                                            ) AS ScreeningDate FROM HRA_member_".$client_id.'_'.$year;

            $member_records_query.=" WHERE
                                        JSON_EXTRACT(
                                            hraFileUpdatedHistory,
                                        REPLACE
                                            (
                                                json_unquote(
                                                    json_search(
                                                        hraFileUpdatedHistory,
                                                        'one',
                                                        'screening'
                                                    )
                                                ),
                                                '.component',
                                                '.status'
                                            )
                                        ) = TRUE  and member_id in (".$memberidslist.") 
                                        ORDER BY 
                                            ScreeningDate 
                                        DESC 
                                        LIMIT $start_limit,$end_limit";
                                      // echo $member_records_query;die;


           $member_details_query=$conn->prepare($member_records_query);
         //  $member_details_query->bind_param('s',$memberidslist);
           $member_details_query->execute();
           $member_details_query_result = $member_details_query->get_result();
           
           $toal_rows = 0;                                     
           $screening_details = null;
            while ($member_row = $member_details_query_result->fetch_assoc()) 
            { 
                //hra file json updated value and check for screening value changes
                $toal_rows = $member_row["totalRows"];
                $member_id = $member_row["member_id"];
                $hra_status = $member_row['hraStatus'];
                $hra_status_history = $member_row['hraStatusHistory'];
                $nurse_id = $member_row['nurse_id'];
                $schedule_date = $member_row['scheduleDate'];
                $memberinfo = $member_row['memberinfo'];
                $hra_file_updated_history = $member_row['hraFileUpdatedHistory'];
                
        
                $screen_updated_array = $hra_file_change->getComponentChangedStatus($hra_file_updated_history,"screening");
                $demographics_detail_value = $this->getDemoGraphicsValue($hra_file_change,$hra_file_updated_history);
                            
                $screening_details[] = array("memberId"=>$member_id,
                                            "nurseId"=>$nurse_id,
                                            "hraStatus"=>$hra_status,
                                            "hraStatusHistory"=>$hra_status_history,
                                            "scheduleDate"=>$schedule_date,
                                            "memberInfo"=>$memberinfo,
                                            "demographic"=>$demographics_detail_value,
                                            "screening"=>$screen_updated_array);
                
                    
            }
            //temp fixing for error.if all the date in correct format no issue of it
            $fixed_screening_details = $this->FixingWrongScreeningDateFormatIssue($screening_details);
            $screening_response = array("totalRows"=>$toal_rows,"memberList"=>$fixed_screening_details);
            echo json_encode($screening_response);
           
        }


        /*
            NAME : getDemoGraphicsValue
            TYPE : Internal Utility function
            DETAILS : get the member's demo graphics details from 'hraFileUpdatedHistory' json object
            RETURN : member's demographic details (plan,program,lob.....)
        */
        private function getDemoGraphicsValue($hra_file_change,$hra_file_updated_history)
        {
            $demographics_detail = $hra_file_change->getComponentChangedStatus($hra_file_updated_history,"demographic");
            $demographics_detail_value = null;
             if($demographics_detail && is_array($demographics_detail) && array_key_exists("value",$demographics_detail))
            {
                if(is_array($demographics_detail["value"]) && count($demographics_detail["value"])>0)
                {
                    //to avoid array format when return json response
                    $demographics_detail_value = $demographics_detail["value"][0];
                }
            } 

            return $demographics_detail_value;
        }

        /*
            NAME : sortScreenByDateModified
            TYPE : Internal Utility function
            DETAILS : 
            RETURN : 
        */
        private function sortScreenByDateModified($screening_details)
        {
            if(is_array($screening_details))
            {
                //sort array 
                $sort_result=usort($screening_details,
                        function ($svalueA,$svalueB)
                        {
                            //if invalid date format
                            $screening_date_first = DateTime::createFromFormat('m-d-Y',$svalueA['screening']['date']);
                            $screening_date_second = DateTime::createFromFormat('m-d-Y',$svalueB['screening']['date']);
                            if($screening_date_first && $screening_date_second)
                            {
                                    $screening_date_a=$screening_date_first->format('Y-m-d');
                                    $screening_date_b=$screening_date_second->format('Y-m-d');
                                    
                                    if( $screening_date_a<$screening_date_b) 
                                        return 1;
                                    else if ( $screening_date_a>$screening_date_b) 
                                        return -1;
                                    else 
                                        return 0;
                            }

                            return 0;
                        });
            }

            return $screening_details;
        }

        /*
            NAME    : FixingWrongScreeningDateFormatIssue
            TYPE    : Internal Utility function
            DETAILS : 
            RETURN  : 
        */
        private function FixingWrongScreeningDateFormatIssue($screening_details)
        {
            
            if(is_array($screening_details))
            {
                $fixed_screening_details = [];
                $error_date_format_details = [];
                $screening_count = count($screening_details);
                for($scr=0;$scr<$screening_count;$scr++)
                {
                    $screening_date = DateTime::createFromFormat('m-d-Y',$screening_details[$scr]['screening']['date']);
                    if($screening_date)
                    {
                        $fixed_screening_details[] = $screening_details[$scr];
                    }
                    else
                    {
                        $error_date_format_details[]=$screening_details[$scr];
                    }
                }

                return array_merge($fixed_screening_details,$error_date_format_details);
            }

            return $screening_details;
        }
        /*
            NAME : Debug
            TYPE : Internal Utility function
            DETAILS : 
            RETURN : 
        */
        private function Debug($sorted_screening_details)
        {
            if(is_array($sorted_screening_details))
            {
                $screening_array = array_column($sorted_screening_details,'screening');
                if(is_array($screening_array))
                {
                    for($src=0;$src<count($screening_array);$src++)
                    {
                        echo $screening_array[$src]['date']."\n";
                    }
                }
            }
        }

    }

    //validate token
    $token_validation_result = JwtUtility::isValidToken();
    if($token_validation_result !== JwtUtility::VALID_TOKEN)
    {     
        //un authorized access 
        JwtUtility::exitWithUnAuthorizedResponse($token_validation_result);
    }
    //end of token validation

    //create report utility object
    $report_api = new Report;
    //parse the request 
    $requested_method = $_SERVER['REQUEST_METHOD'];
    $requested_url = $_SERVER['REQUEST_URI'];
    //parse the requested url path 
    $requested_url_array = explode("/",$requested_url);
    $req_count = count($requested_url_array);
    $req_count_zero = $req_count -1;
    //parse the memthod name
    $request_user_method = $requested_url_array[$req_count_zero];
    $request_user_method_array = explode("?",$request_user_method);
    $requested_function_name = $request_user_method_array[0];

    switch ($requested_method) 
    {
            case 'POST':
                switch($requested_function_name)
                {

                    
                }
            break;

            case 'GET' :
                switch($requested_function_name)
                {	
                    //screening api call
                    case 'Screening':
                        $client_id = $_GET['clientId'];
                        $year = $_GET['year'];
                        $report_api->getMemeberScreeningDetails($client_id,$year);
                    break;

                    //screening api call updated version
                    case 'ScreeningWithLimits':
                        $client_id = $_GET['clientId'];
                        $year = $_GET['year'];
                        $min = $_GET['min'];
                        $max = $_GET['max'];
                        $report_api->getMemeberScreeningDetailsWithLimits($client_id,$year,$min,$max);
                    break;
                    
                    case 'TotalScreeningCount':
                        $client_id = $_GET['clientId'];
                        $year = $_GET['year'];
                        $report_api->getTotalScreeningCount($client_id,$year);
                    break;

                }
            break;

    }
?>