<?php
      ini_set('memory_limit','-1');
ini_set('max_execution_time', 300);

/*
	REPORT GLOBAL MEMBER API CLASS
	Created On : 
*/

//other include files
require_once("../global/GlobalQueryBuilder.php");
require_once("../member/MemberUtility.php");
require_once("../utility/ArrayUtility.php");
require_once("../utility/StringUtility.php");
require_once("../auth/UserUtility.php");
require_once("../utility/JwtUtility.php");
require_once("../utility/ResponseUtility.php");
require_once("../TimeZone.php");
require_once("../member/HraFileChanges.php");

class ReportGlobalMembers
{

    /*
        NAME    : getNurseRequiredColumnAsString
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
	const MEMBERS_LIST = 1;
    const UNASSIGNED = 2;
    const SCHEDULED = 3;
    const IN_PROGRESS = 4;
    const QA = 1;
    const CODING = 6;
    const CLINICIAN_REVIEW = 7;
    const READY_FOR_UPLOAD = 8;
    const COMPLETED = 9;
    const CANCELLED_NO_SHOW = 10;
    const TERMED_EXPIRED = 11;
    public static function getQuery($tab_id,$plan_id,$year){

	    //database connection
	    include("../db.php");

	    $getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";


	    $getClientsidsresult=mysqli_query($conn,$getClientsids);
	    $combine_member_query = array();
	    while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
		    $client_id =  $getClientsidsresp['clientId'];

		    $overrideScheduleDate_column=GlobalQueryBuilder::sqlCustomColumnOverridedScheduledDate();
		    $refusalDate = '';
		    $noShowInfo = '';
		    $return_mail = '';
		    $reportNotes = '';
		    $return_mail_query = "";

$screeningId = '';
			if($tab_id == 3){
				$screeningId = GlobalQueryBuilder::sqlCustomColumnHomeValidRecords(). "as screeningId";
			}
		    if($tab_id == 6 ){
			    $refusalDate = ",".GlobalQueryBuilder::sqlCustomColumnRefusalDate('refusalDate');
		    }
		    if($tab_id == 5){
			    $refusalDate = ",".GlobalQueryBuilder::sqlCustomColumnRefusalDate('refusalDate');
			    $noShowInfo = ",".GlobalQueryBuilder::sqlCustomColumnnoshow('noShowInfo');
			    $return_mail = ",member_global_status.return_mail as returnMail";
			    $reportNotes = ",reportNotes";
			    $return_mail_query =" LEFT JOIN hra_member_global_status AS member_global_status ON member_global_status.member_id = HRA_member_".$client_id.'_'.$year.".member_id";
		    }

		    $reportStatus_column = ",".GlobalQueryBuilder::sqlCustomColumnReportStatus('reportStatus');

		    $combine_member_query[] = "select HRA_member_".$client_id.'_'.$year.".member_id,firstname,lastname,nurse_id,scheduler_id,qa_id,coder_id,memberinfo,hraStatus,admin_idno,scheduler,scheduleDate,VisitType,clientid,year,sentToAvility,invoiceDate,cancelHistory,termDate,JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory, REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','demographic' )),'.component', '.value[0]') )) As Demographic,JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory, REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening' )),'.component', '.value[0]') )) As ScreeningArray,hraStatusHistory,hraFileUpdatedHistory,refusalLetterDate $refusalDate $noShowInfo $return_mail $reportNotes $reportStatus_column , importTrackerDetails,$overrideScheduleDate_column,$screeningId from HRA_member_".$client_id.'_'.$year." ".$return_mail_query;

	    }
	    return $combine_member_query;
    }

    public static function getFinalResponse($memberrecordscount){
	    //database connection
	    include("../db.php");
	    //$reccount =  mysqli_fetch_array($memberrecordscount,MYSQLI_ASSOC);


	    $all_data=[];
	    while($member_row = mysqli_fetch_array($memberrecordscount,MYSQLI_ASSOC))
	    {
		    $count = $member_row['totalRows'];

		    $member_id = $member_row['member_id'];
		    $memberinfo = $member_row['memberinfo'];
		    //$demographic = $member_row['Demographic'];
		    //$override_scheduled_date = $member_row['overrideScheduledDate'];
		    $scheduled_date = $member_row['scheduleDate'];
		    $hra_status = $member_row['hraStatus'];
		    $visit_type = $member_row['VisitType'];

            $admin_id = $member_row['admin_idno'];
            $nurse_id = $member_row['nurse_id'];
            $qa_id = $member_row['qa_id'];
            $coder_id = $member_row['coder_id'];
			$scheduler_id = $member_row['scheduler_id'];
			
			$client_id = $member_row['clientid'];
			$client_year = $member_row['year'];
			$sentToAvility = $member_row['sentToAvility'];
			$invoiceDate = $member_row['invoiceDate'];
			$cancelHistory = $member_row['cancelHistory'];
			$term_date = $member_row['termDate'];
			$demographic = $member_row['Demographic'];
$ScreeningArray = $member_row['ScreeningArray'];
			$scheduler = $member_row['scheduler'];
			$hra_status_history = $member_row['hraStatusHistory'];
			$importTrackerDetails = $member_row['importTrackerDetails'];
			//$refusalLetterDate = $member_row['refusalLetterDate'];
			$refusal_letter_date = isset($member_row['refusalDate']) ? $member_row['refusalDate'] : '';
            $noShowInfo = isset($member_row['noShowInfo']) ? $member_row['noShowInfo'] : '';
            $return_mail = isset($member_row['returnMail']) ? $member_row['returnMail'] : '' ;
	    //$reportNotes = isset($member_row['reportNotes']) ? ($member_row['reportNotes']) : ''; 
	    $reportNote = $member_row['reportNotes']; 
	    $report_status = $member_row["reportStatus"];
            if(isset($member_row['query_form_review_count']))
            {
                $sub_status = GlobalHelper::queryReviewCountToReadableFormat($member_row['query_form_review_count']);
            }
            else
            {
                $sub_status= $query_form_review_status=GlobalHelper::queryReviewCountToReadableFormat(null);
            }
			$all_data[]=array(
			                "memberId"=>$member_id,
                                    "nurseId"=>$nurse_id,
				    "adminId"=>$admin_id,
				    "schedulerId"=>$scheduler_id,
				    "qaId"=>$qa_id,
				    "coderId"=>$coder_id,
				    "memberinfo"=>$memberinfo,
				    "scheduleDate"=>$scheduled_date,
				    "hraStatus"=>$hra_status,
				    "visitType"=>$visit_type,
				    "clientId"=>$client_id,
				    "clientYear"=>$client_year,
				    "overrideScheduleDate" => $member_row["overrideScheduledDate"],
				    "sentToAvility"=>$sentToAvility,
				    "invoiceDate"=>$invoiceDate,
				    "cancelHistory" => $cancelHistory,
				    "termDate"=>$term_date,
				    "demographic"=>$demographic,
"ScreeningArray"=>json_decode($ScreeningArray, true, JSON_UNESCAPED_SLASHES),
				    "scheduler"=>$scheduler,
				    "hraStatusHistory"=>$hra_status_history,
				    "importTrackerDetails"=>$importTrackerDetails,
				    "refusalDate" =>$refusal_letter_date,
                                    "noShowInfo" => $noShowInfo,
				    "returnMail" => $return_mail,
				    "reportNotes" => $reportNote,
				    "reportStatus" => $report_status
			    );
		}
		$response = new stdClass();
		$response->status = 1;
		$response->members = $all_data;
		$response->totalRows = $count;
		return $response;
    }
    public static function getNurseRequiredColumnAsString($tabId='None')
    {
	    $sql_demograhic_string = GlobalQueryBuilder::sqlCustomColumnDemographic();

	    $required_column_array[] = GlobalQueryBuilder::sqlCustomColumnpcpfname();
	    $required_column_array[] = GlobalQueryBuilder::sqlCustomColumnpcplname();
	    //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumn('customone');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumn('lob');

	    $required_column_array[]="member_id,firstname,lastname,nurse_id,scheduler_id,qa_id,coder_id,
		    memberinfo,hraStatus,hraStatusHistory,sentToAvility,cancelHistory,refusalLetterDate,invoiceDate,admin_idno,hraFileUpdatedHistory,termDate,query_form,
		    scheduleDate,STR_TO_DATE(scheduleDate, '%Y-%m-%d') as shortscheduleDate,EvaluationDate,schedulerCallHraStatus,schedulerCallLogDetails,VisitType,schedulerDetails,importTrackerDetails,schedulerCallOrder,reportNotes,scheduler";                   
	    $required_column_array[]=$sql_demograhic_string;
	    //custom member info field for sorting 
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Plan','memberPlan');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Program','memberProgram');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('LOB','memberLob');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_City','memberCity');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Zip_Code','memberZip');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_first_name','memberFirstName');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Last_name','memberLastName');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_State','memberState');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Country','memberCountry');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Language','memberLanguage');

	    //added by nandini on 11thjan22 start
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Gender','memberGender');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Qa_Assigned_Date','qaAssignedDate');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Coder_Assigned_Date','coderAssignedDate');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Ready_For_Upload_Date','readyforuploadDate');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Ready_For_Qa_Date','readyforqaDate');


	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Completed_Date','completedDate');

	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Pcp_State','pcp_state');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Pcp_City','Pcp_City');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Pcp_Name','Pcp_Name');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Pphy','Pphy');


	    //added by nandini on 11thjan22 end

	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Term_Date','memberTermDate');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_sent_To_Avility','membersentToAvility');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_refusal_Letter_Date','memberrefusalLetterDate');

	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Completed_Date','memberCompletedDate');


	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Invoice_Date','memberInvoiceDate');


	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_qa_name','memberQaName');


	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Coder_name','memberCoderName');

	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnScreening();
	    // $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedScheduledDate();
	    //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedShortScheduledDate();

	    if($tabId==5){
		    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnSortOverridedScheduledDate();
		    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnSortOverridedShortScheduledDate();
	    }else{
		    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedScheduledDate();
		    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedShortScheduledDate();
	    }


	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnRefusalDate('refusalDate');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnnoshow('noShowInfo');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReportStatusbychar('hrastatusbychar');


	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReportStatus('reportStatus');
	    //addded by eswar for sorting in qa and summary tab

	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReadyForQa('readyForQa');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnQaAssignedDate('qaAssignedDatee');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnCoderAssignedDate('coderassigneddatee');



	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnCompletedDate('completeddatee');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReadyForUploadDate('readyforuploaddatee');

	    //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnCompleted('completed');



	    //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnSimpleJsonExtract('reportStatus','text','reportStatus');
	    //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReportStatus('reportStatus');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnHraStatusHistoryDays(0,'hra_days');
	    return ArrayUtility::joinArrayByDelimiter($required_column_array,',');
    }
    public static function getNurseRequiredColumnAsStringQA($tabId='None')
    {
	    $sql_demograhic_string = GlobalQueryBuilder::sqlCustomColumnDemographic();

	    $required_column_array[] = GlobalQueryBuilder::sqlCustomColumnpcpfname();
	    $required_column_array[] = GlobalQueryBuilder::sqlCustomColumnpcplname();
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumn('customone');

	    $required_column_array[]="member_id,firstname,lastname,nurse_id,scheduler_id,qa_id,coder_id,
		    memberinfo,hraStatus,hraStatusHistory,sentToAvility,cancelHistory,refusalLetterDate,invoiceDate,admin_idno,hraFileUpdatedHistory,termDate,query_form,
		    scheduleDate,STR_TO_DATE(scheduleDate, '%Y-%m-%d') as shortscheduleDate,EvaluationDate,schedulerCallHraStatus,schedulerCallLogDetails,VisitType,schedulerDetails,importTrackerDetails,schedulerCallOrder,reportNotes,scheduler";
	    $required_column_array[]=$sql_demograhic_string;
	    //custom member info field for sorting
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Plan','memberPlan');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Program','memberProgram');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('LOB','memberLob');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_City','memberCity');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Zip_Code','memberZip');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_first_name','memberFirstName');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Last_name','memberLastName');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_State','memberState');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Country','memberCountry');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Language','memberLanguage');

	    //added by nandini on 11thjan22 start
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Gender','memberGender');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Qa_Assigned_Date','qaAssignedDate');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Coder_Assigned_Date','coderAssignedDate');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Ready_For_Upload_Date','readyforuploadDate');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Ready_For_Qa_Date','readyforqaDate');


	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Completed_Date','completedDate');

	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Pcp_State','pcp_state');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Pcp_City','Pcp_City');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Pcp_Name','Pcp_Name');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Pphy','Pphy');


	    //added by nandini on 11thjan22 end

	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Term_Date','memberTermDate');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_sent_To_Avility','membersentToAvility');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_refusal_Letter_Date','memberrefusalLetterDate');

	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Completed_Date','memberCompletedDate');


	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Invoice_Date','memberInvoiceDate');


	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_qa_name','memberQaName');


	    $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Coder_name','memberCoderName');

	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnScreening();
	    // $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedScheduledDate();
	    //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedShortScheduledDate();


	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedScheduledDate();
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedShortScheduledDate();



	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnRefusalDate('refusalDate');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnnoshow('noShowInfo');
	    $required_column_array[]=GlobalQueryBuilder::sqlHraStatusColumnReportStatusbychar('hrastatusbychar');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReportStatus('reportStatus');
	    //addded by eswar for sorting in qa and summary tab

	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReadyForQa('readyForQa');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnQaAssignedDate('qaAssignedDatee');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnCoderAssignedDate('coderassigneddatee');



	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnCompletedDate('completeddatee');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReadyForUploadDate('readyforuploaddatee');

	    //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnCompleted('completed');



	    //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnSimpleJsonExtract('reportStatus','text','reportStatus');
	    //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReportStatus('reportStatus');
	    $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnHraStatusHistoryDays(0,'hra_days');
	    return ArrayUtility::joinArrayByDelimiter($required_column_array,',');
    }


    /*
	NAME    : getNurseRequiredColumnAsString
	TYPE    : global Utiltiy function 
	DETAILS : 
	RETURN  : 
     */
    public static function convertToDefaultMemberSqlQuery($member_table_sql_query)
    {
	    if($member_table_sql_query === FALSE) return FALSE;//not valid query string

	    $scheduler_member_sql_query = "SELECT (COUNT(*) OVER()) as totalRows, member_table.*,
		    client_table.client_name as client_name,
		    admin_table.userUniqueno as admin_id,
		    CONCAT(scheduler_table.firstname ,' ',scheduler_table.lastname) as scheduler_fullname,
		    CONCAT(nurse_table.firstname ,' ', nurse_table.lastname) as nurse_fullname,
		    CONCAT(admin_table.firstname ,' ', admin_table.lastname) as admin_fullname, 
		    CONCAT(qa_table.firstname ,' ', qa_table.lastname) as qa_fullname,
		    CONCAT(coder_table.firstname ,' ', coder_table.lastname) as coder_fullname,

		    member_global_status.return_mail as returnMail
		    FROM 
		    ( $member_table_sql_query ) as member_table 
		    LEFT JOIN userLogin as scheduler_table ON scheduler_table.userUniqueno = member_table.scheduler_id 
		    LEFT JOIN userLogin as nurse_table ON nurse_table.userUniqueno = member_table.nurse_id 
		    LEFT JOIN userLogin as qa_table ON qa_table.userUniqueno = member_table.qa_id 
		    LEFT JOIN userLogin as coder_table ON coder_table.userUniqueno = member_table.coder_id 
		    LEFT JOIN HRA_client as client_table ON client_table.clientId = member_table.client_id 
		    LEFT JOIN userLogin as admin_table ON admin_table.userUniqueno = member_table.admin_idno
		    LEFT JOIN hra_member_global_status AS member_global_status ON member_global_status.member_id = member_table.member_id";

	    return $scheduler_member_sql_query;
    }
    /*
	NAME    : getMemberRequiredFieldAsArray
	TYPE    : global Utiltiy function 
	DETAILS : 
	RETURN  : 
     */

    private function getsecondlineiteminfo($hra_status1,$cancel_history){

	    $hra_statusinfo = json_decode($hra_status1,true);
	    $hra_status = $hra_statusinfo['hraStatus'];

	    if($hra_status == 6 || $hra_status ==7 || $hra_status ==8 || $hra_status == 9 || $hra_status == 10 || $hra_status == 11|| $hra_status == 12){

		    if($cancel_history != null){

			    $array = json_decode($cancel_history,true);

			    if($array['appointmentCancelled'] != null && ( $array['noShow'] == null)){

				    return "appointmentcancelled";
			    }

			    else if($array['appointmentCancelled'] == null && ( $array['noShow'] != null)){ 
				    return "noshow";

			    }

			    else if( $array['noShow'] != null && $array['appointmentCancelled'] != null )
			    {
				    $noshowcount =   count($array['noShow']);
				    $noshowcount1 = $noshowcount - 1;
				    $appointmentCancelledcount =   count($array['appointmentCancelled']);
				    $appointmentCancelledcount1 = $appointmentCancelledcount - 1;

				    $noshowmaxdate =  $array['noShow'][$noshowcount1]['date'];
				    $appointmentCancelledmaxdate = $array['appointmentCancelled'][$appointmentCancelledcount1]['date'];

				    if ($noshowmaxdate > $appointmentCancelledmaxdate)
					    return "noshow";

				    else
					    return "appointmentcancelled";


			    }


			    else{

				    return "";
			    }
		    }

	    }
	    else if($hra_status ==19)
	    {
		    $array = json_decode($cancel_history,true);

		    if($array['appointmentCancelled'] != null) {
			    return "appointmentcancelled";
		    }



	    }
	    else if($hra_status == 3){
		    $array = json_decode($cancel_history,true);

		    if($array['noShow'] != null) 
		    {
			    return "noshow";


		    }



	    }


	    else{
		    return "";

	    }

    }

    private function getMemberRequiredFieldAsArrayforqa($member_row){
	    //  echo "sm";die;
	    $member_id = $member_row['member_id'];
	    $memberinfo = $member_row['memberinfo'];
	    $demographic = $member_row['Demographic'];

	    $override_scheduled_date = $member_row['overrideScheduledDate'];
	    $scheduled_date = $member_row['scheduleDate'];
	    $term_date = $member_row['termDate'];
	    $evaluation_date = $member_row['EvaluationDate'];

	    $hra_status = $member_row['hraStatus'];
	    $scheduler_status=$member_row['reportStatus'];
	    $visit_type = $member_row['VisitType'];
	    $cancel_history = $member_row['cancelHistory'];
	    $secondlineitemvalue = $this->getsecondlineiteminfo($hra_status,$cancel_history);

	    $admin_id = $member_row['admin_id'];
	    $nurse_id = $member_row['nurse_id'];
	    $qa_id = $member_row['qa_id'];
	    $coder_id = $member_row['coder_id'];
	    $scheduler_id = $member_row['scheduler_id'];
	    $hra_status_history = $member_row['hraStatusHistory'];
	    $sentToAvility = $member_row['sentToAvility'];
	    $invoiceDate= $member_row['invoiceDate'];
	    $nurse_name = StringUtility::toEmptyStringIfNull($member_row['nurse_fullname']);
	    $scheduler_name = StringUtility::toEmptyStringIfNull($member_row['scheduler_fullname']);
	    $admin_name = StringUtility::toEmptyStringIfNull($member_row['admin_fullname']);
	    $qa_fullname = StringUtility::toEmptyStringIfNull($member_row['qa_fullname']);
	    $coder_fullname = StringUtility::toEmptyStringIfNull($member_row['coder_fullname']);
	    $scheduler_fullname = StringUtility::toEmptyStringIfNull($member_row['scheduler_fullname']);
	    $return_mail = StringUtility::toEmptyStringIfNull($member_row['returnMail']);

	    $client_id = $member_row['client_id'];
	    $client_name = $member_row['client_name'];
	    $client_year = $member_row['client_year'];

	    $query_form = $member_row['query_form'];

	    $refusalDate = $member_row['refusalDate'];
	    $noShowInfo = $member_row['noShowInfo'];


	    //conver the query review count to ordinal suffix if number
	    if(isset($member_row['query_form_review_count']))
	    {
		    $query_form_review_status = GlobalHelper::queryReviewCountToReadableFormat($member_row['query_form_review_count']);
	    }
	    else
	    {
		    $query_form_review_status= $query_form_review_status=GlobalHelper::queryReviewCountToReadableFormat(null);
	    }

	    $hra_days = StringUtility::toEmptyStringIfNull($member_row['hra_days']);
	    $import_tracker_details = json_decode($member_row['importTrackerDetails'],true);
	    $notes = $member_row['reportNotes'];
	    $refusal_letter_date  = $member_row['refusalLetterDate'];
	    $report_status  = $member_row['reportStatus'];
	    $scheduler = $member_row['scheduler'];
	    $scheduler_call_order = json_decode($member_row['schedulerCallOrder'],true);
	    $scheduler_details = $member_row['schedulerDetails'];
	    $schedule_hra_status = $member_row['schedulerCallHraStatus'];
	    $schedule_call_log_details= $member_row['schedulerCallLogDetails'];


	    $result_hra_status_result=MemberUtility::OnApiEvent($client_id,$client_year,$member_id,MemberUtility::API_SCHEDULED_DATE,true,null);

	    $scheduler_call_response = MemberUtility::getMemberCallResponse($hra_status,$scheduler_id,$scheduler,
		    $scheduler_details,$schedule_hra_status,$schedule_call_log_details);

	    $response_array=array(
		    "memberId"=>$member_id,
		    "nurseId"=>$nurse_id,
		    "adminId"=>$admin_id,
		    "schedulerId"=>$scheduler_id,
		    "qaId"=>$qa_id,
		    "coderId"=>$coder_id,
		    "refusalDate"=>$refusalDate,
		    "noShowInfo"=>$noShowInfo,

		    "nurseName"=>$nurse_name,
		    "schedulerName"=>$scheduler_name,
		    "qaName" => $qa_fullname,
		    "coderName" => $coder_fullname,
		    "adminName"=>$admin_name,
		    "sentToAvility"=>$sentToAvility,
		    "invoiceDate"=>$invoiceDate,
		    "memberinfo"=>$memberinfo,
		    "demographic"=>$demographic,
		    "hraStatusHistory"=>$hra_status_history,
		    "scheduleDate"=>$scheduled_date,
		    //some case evalution date consider as scheduled date
		    "overrideScheduleDate"=>$override_scheduled_date,
		    "termDate"=>$term_date,
		    "evaluationDate" => $evaluation_date,

		    "hraStatus"=>$hra_status,
		    "hraDays"=>$hra_days,
		    "queryReviewStatus"=>$query_form_review_status,
		    "schedulerStatus"=>$scheduler_status,
		    "visitType"=>$visit_type,

		    "clientId"=>$client_id,
		    "clientName"=>$client_name,
		    "clientYear"=>$client_year,
		    "cancelHistory"=>$cancel_history,

		    "queryForm"=>$query_form,
		    "importTrackerDetails"=>$import_tracker_details,
		    "reportNotes"=>$notes,
		    "refusalLetterDate"=>$refusal_letter_date,
		    "reportStatus"=>$report_status,
		    "scheduler"=>$scheduler,
		    "schedulerCallOrder"=>$scheduler_call_order,
		    "schedulerCallResponse"=>$scheduler_call_response,
		    "schedulerFullName"=>$scheduler_fullname,
		    "returnMail"=>$return_mail,
		    "schedulerHraStatus"=>$result_hra_status_result,
		    "secondlineitemvalue" => $secondlineitemvalue
	    );

	    return $response_array;

    }


    private function getMemberRequiredFieldAsArray($member_row)
    {
	    $hra_file_change = new HraFileChangesUtility;
	    $hra_file_updated_history = $member_row['hraFileUpdatedHistory'];
	    $member_id = $member_row['member_id'];
	    $memberinfo = $member_row['memberinfo'];
	    $demographic = $member_row['Demographic'];

	    $override_scheduled_date = $member_row['overrideScheduledDate'];
	    $scheduled_date = $member_row['scheduleDate'];
	    $term_date = $member_row['termDate'];
	    $sentToAvitity = $member_row['sentToAvility'];
	    $refusalDate = $member_row['refusalDate'];
	    $noShowInfo = $member_row['noShowInfo'];
	    $evaluation_date = $member_row['EvaluationDate'];

	    $memberFirstName = $member_row['memberFirstName'];
	    $memberLastName = $member_row['memberLastName'];

	    $pcpfname = $member_row['pcpfname'];
	    $pcplname = $member_row['pcplname'];


	    $hra_status = $member_row['hraStatus'];
	    $scheduler_status=$member_row['reportStatus'];
	    $visit_type = $member_row['VisitType'];

	    $admin_id = $member_row['admin_id'];
	    $nurse_id = $member_row['nurse_id'];
	    $qa_id = $member_row['qa_id'];
	    $coder_id = $member_row['coder_id'];
	    $scheduler_id = $member_row['scheduler_id'];
	    $hra_status_history = $member_row['hraStatusHistory'];
	    $sentToAvility = $member_row['sentToAvility'];
	    $invoiceDate= $member_row['invoiceDate'];
	    $nurse_name = StringUtility::toEmptyStringIfNull($member_row['nurse_fullname']);
	    $scheduler_name = StringUtility::toEmptyStringIfNull($member_row['scheduler_fullname']);
	    $admin_name = StringUtility::toEmptyStringIfNull($member_row['admin_fullname']);
	    $qa_fullname = StringUtility::toEmptyStringIfNull($member_row['qa_fullname']);
	    $coder_fullname = StringUtility::toEmptyStringIfNull($member_row['coder_fullname']);
	    $scheduler_fullname = StringUtility::toEmptyStringIfNull($member_row['scheduler_fullname']);
	    $return_mail = StringUtility::toEmptyStringIfNull($member_row['returnMail']);

	    $client_id = $member_row['client_id'];
	    $client_name = $member_row['client_name'];
	    $client_year = $member_row['client_year'];

	    $query_form = $member_row['query_form'];

	    //conver the query review count to ordinal suffix if number
	    if(isset($member_row['query_form_review_count']))
	    {
		    $query_form_review_status = GlobalHelper::queryReviewCountToReadableFormat($member_row['query_form_review_count']);
	    }
	    else
	    {
		    $query_form_review_status= $query_form_review_status=GlobalHelper::queryReviewCountToReadableFormat(null);
	    }

	    $hra_days = StringUtility::toEmptyStringIfNull($member_row['hra_days']);
	    $import_tracker_details = json_decode($member_row['importTrackerDetails'],true);
	    $notes = $member_row['reportNotes'];
	    $refusal_letter_date  = $member_row['refusalLetterDate'];
	    $report_status  = $member_row['reportStatus'];
	    $scheduler = $member_row['scheduler'];
	    $scheduler_call_order = json_decode($member_row['schedulerCallOrder'],true);
	    $scheduler_details = $member_row['schedulerDetails'];
	    $schedule_hra_status = $member_row['schedulerCallHraStatus'];
	    $schedule_call_log_details= $member_row['schedulerCallLogDetails'];
	    $cancel_history = $member_row['cancelHistory'];

	    $result_hra_status_result=MemberUtility::OnApiEvent($client_id,$client_year,$member_id,MemberUtility::API_SCHEDULED_DATE,true,null);

	    $screen_updated_array = $hra_file_change->getComponentChangedStatus($hra_file_updated_history,"screening");
	    if($screen_updated_array)
	    {
		    if($screen_updated_array["status"]==true)
			    $screening = $screen_updated_array;
	    }
	    $scheduler_call_response = MemberUtility::getMemberCallResponse($hra_status,$scheduler_id,$scheduler,
		    $scheduler_details,$schedule_hra_status,$schedule_call_log_details);

	    $response_array=array(
		    "memberId"=>$member_id,
		    "memberFirstName"=>$memberFirstName,
		    "memberLastName"=>$memberLastName,
		    "pcpfname"=>$pcpfname,
		    "pcplname"=>$pcplname,
		    "nurseId"=>$nurse_id,
		    "adminId"=>$admin_id,
		    "schedulerId"=>$scheduler_id,
		    "qaId"=>$qa_id,
		    "coderId"=>$coder_id,
		    "noShowInfo"=>$noShowInfo,
		    "nurseName"=>$nurse_name,
		    "schedulerName"=>$scheduler_name,
		    "qaName" => $qa_fullname,
		    "coderName" => $coder_fullname,
		    "adminName"=>$admin_name,
		    "invoiceDate"=>$invoiceDate,
		    "memberinfo"=>$memberinfo,
		    "demographic"=>$demographic,
		    "hraStatusHistory"=>$hra_status_history,
		    "scheduleDate"=>$scheduled_date,
		    //some case evalution date consider as scheduled date
		    "overrideScheduleDate"=>$override_scheduled_date,
		    "termDate"=>$term_date,
		    "sentToAvility"=>$sentToAvitity,
		    "refusalDate"=>$refusalDate,
		    "evaluationDate" => $evaluation_date,

		    "hraStatus"=>$hra_status,
		    "hraDays"=>$hra_days,
		    "queryReviewStatus"=>$query_form_review_status,
		    "schedulerStatus"=>$scheduler_status,
		    "visitType"=>$visit_type,

		    "clientId"=>$client_id,
		    "clientName"=>$client_name,
		    "clientYear"=>$client_year,
		    "cancelHistory"=>$cancel_history,

		    "queryForm"=>$query_form,
		    "importTrackerDetails"=>$import_tracker_details,
		    "reportNotes"=>$notes,
		    "refusalLetterDate"=>$refusal_letter_date,
		    "reportStatus"=>$report_status,
		    "scheduler"=>$scheduler,
		    "schedulerCallOrder"=>$scheduler_call_order,
		    "schedulerCallResponse"=>$scheduler_call_response,
		    "schedulerFullName"=>$scheduler_fullname,
		    "returnMail"=>$return_mail,
		    "schedulerHraStatus"=>$result_hra_status_result,
		    "screening"=>$screening
	    );

	    return $response_array;
    }

     /*
	NAME    : queryResultResponse
	TYPE    : global Utiltiy function 
	DETAILS : 
	RETURN  : 
      */

    private function queryResultResponseforqa($member_query_result,$error){

	    $total_rows = 0;

	    $member_list=[];
	    while ($member_row = $member_query_result->fetch_assoc()) 
	    {
		    // $member_list[]=$this->getMemberRequiredFieldAsArray($member_row);
		    $member_list[]=$this->getMemberRequiredFieldAsArrayforqa($member_row);
		    $total_rows = $member_row['totalRows'];
	    }

	    $member_response = new stdClass;
	    $member_response->status=true;
	    $member_response->error=$error;
	    $member_response->totalRows=$total_rows;
	    $member_response->members=$member_list;

	    return $member_response;
    }

    private function queryResultResponse($member_query_result,$error)
    {
	    $total_rows = 0;

	    $member_list=[];
	    while ($member_row = $member_query_result->fetch_assoc()) 
	    {
		    $member_list[]=$this->getMemberRequiredFieldAsArray($member_row);
		    $total_rows = $member_row['totalRows'];
	    }

	    $member_response = new stdClass;
	    $member_response->status=true;
	    $member_response->error=$error;
	    $member_response->totalRows=$total_rows;
	    $member_response->members=$member_list;

	    return $member_response;

    }


    /*
	NAME    : filter
	TYPE    : global Utiltiy function 
	DETAILS : 
	RETURN  : 
     */
    public function filter($filter_parameters,&$error)
    {
        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $filter_parameters['planId'];
        $user_id = $filter_parameters['userId'];
        $year = $filter_parameters['year'];
        $min = $filter_parameters['min'];
        $max = $filter_parameters['max'];
        $lob= base64_decode(urldecode($filter_parameters['lob']));
		$filter_parameters['lob']=$lob;
        $tab_id = $filter_parameters['tabId'];

		//if($tab_id == 3){
		 //$getmemberlists = $this->getmemberslistids($plan_id,$year);
      
		//}

        $base_sort_by = $filter_parameters['baseSortBy'];
        $base_sort_order = $filter_parameters['baseSortOrder']==0?'ASC':'DESC';
        $sort_by = $filter_parameters['sortBy']; 
        $sort_order = $filter_parameters['sortOrder']==0?'ASC':'DESC';

        $start = $min;
        $offset = $max - $min;

        $combine_member_query = $this -> getQuery($tab_id,$plan_id,$year);
		 if($combine_member_query && is_array($combine_member_query))
		 {
            $whereCondition = $this->tabConditionNew($tab_id,$getmemberlists);
            //$searchCondition = $this -> tabConditionSearch($whereCondition,$tab_id,$isSearchApplied,$memberid,$firstname,$lastname);
            $filterCondition = $this -> filterCondition($tab_id,$filter_parameters);
            $orderBy =$this->memberSorting($sort_by,$sort_order);
		    $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
		    $sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (". $sql_global_member_query1 . " ) as  member_info  where $whereCondition $filterCondition  $orderBy[0] limit $min,$max";
		 
		 }
         //echo $sql_global_member_query1;exit;
		 $memberrecordscount = mysqli_query($conn,$sql_global_member_query1);

		$final_response = $this -> getFinalResponse($memberrecordscount,$tab_id);
        echo json_encode($final_response);
        return TRUE;
    }
 public function filter_old($filter_parameters,&$error)
    {
	    //database connection
	    include("../db.php");
	    //custom parameter datas
	    $plan_id = $filter_parameters['planId'];
	    $user_id = $filter_parameters['userId'];
	    $year = $filter_parameters['year'];
	    $min = $filter_parameters['min'];
	    $max = $filter_parameters['max'];
	    $lob= base64_decode(urldecode($filter_parameters['lob']));
	    $filter_parameters['lob']=$lob;
	    $tab_id = $filter_parameters['tabId'];

	    $base_sort_by = $filter_parameters['baseSortBy'];
	    $base_sort_order = $filter_parameters['baseSortOrder']==0?'ASC':'DESC';
	    $sort_by = $filter_parameters['sortBy']; 
	    $sort_order = $filter_parameters['sortOrder']==0?'ASC':'DESC';

	    $start = $min;
	    $offset = $max - $min;

	    $sql_global_member_query = array();

	    if(array_key_exists('planId',$filter_parameters))
	    { 
		    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
			    ReportGlobalMembers::convertToDefaultMemberSqlQuery(
				    GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
				    self::getNurseRequiredColumnAsString())
			    ));
	    }
	    else
	    {
		    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
			    ReportGlobalMembers::convertToDefaultMemberSqlQuery(
				    GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
				    self::getNurseRequiredColumnAsString())
			    ));
	    }

	    //if invalid user details sent                                                
	    if(count($sql_global_member_query)==0) return FALSE; 

	    //where clause array and condition
	    $where_clause_contiditions = array();
	    //tab condition - hra status
	    $nurse_hralist = $this->tabHraCondition($tab_id);
	    switch($tab_id)
	    {
	    case '1':
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,'('.GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist).' OR '.GlobalQueryBuilder::whereClauseReportQATabConditionQuery().')') ;
		    break;
	    case '2':
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
		    break;
	    case '3':
		    //  $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
		    // $getmemberlists = $this->getmemberslistids($plan_id,$year);
		    $getmemberlists = $this->getmemberslistidsbyfilter($plan_id,$year,$filter_parameters);
		    //print_r($getmemberlists);die;
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHomeAccessResultsTabConditionQuery($getmemberlists));
		    break;
	    case '4':
		    $getmemberlists = $this->getmemberslistids($plan_id,$year);
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHomeAccessResultsTabConditionQuery($getmemberlists));
		    //$where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
		    break;
	    case '5':
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));

		    // $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusInweeklyreport($nurse_hralist));
		    break;
	    case '6':
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseReportRefusalTabConditionQuery());
		    break;
	    default:
		    break;
	    }

	    //to get this report assigned members where clause condition
	    /*$my_member_filter['nurseIds']=$user_id;
	    $my_member_filter['column']="nurse_id";
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('report',$my_member_filter));*/

	    //filter conditions
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseCustomColumnValueIn('client_id',$filter_parameters,'clientId',true,'|',','));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('qa',$filter_parameters));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('coder',$filter_parameters));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('scheduler',$filter_parameters));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseScheduleDateBetween($filter_parameters));

	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseRefusalDateBetween($filter_parameters));


	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseCustomColumnValueIn('VisitType',$filter_parameters,'visitType',true));
	    //$where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('nurse',$filter_parameters));
	    if($tab_id == 5){
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdInweeklyreport('nurse',$filter_parameters));
	    }else{
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('nurse',$filter_parameters));

	    }

	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseCustomColumnValueIn('reportStatus',$filter_parameters,'status',true));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($filter_parameters));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'city','Member_City',true));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'lob','LOB',true)); 
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'plan','Plan',true));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'program','Program',true)); 
	    if(count($where_clause_contiditions)==0) { $error="no valid filter option selected"; return FALSE;}  

	    //if any valid where clause found append 'where'
	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
	    //if multiple where clause add 'and' else 'or' condition
	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));
	    //order query string
	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy(UserRoleConstant::NURSE,$base_sort_by,$sort_by,$base_sort_order,$sort_order));
	    //limit string
	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT ?,? ");
	    //generated query 
	    $generated_query = implode($sql_global_member_query);
	    //echo $generated_query;exit();

	    //prepare the member query
	    if($conn->connect_errno)
	    {
		    $error="datatbase connection failed";
	    }
	    //prepare the member query
	    $member_query=$conn->prepare($generated_query);
	    if($member_query===FALSE)
	    {
		    $error = "error preparing sql query";
		    return FALSE;
	    }
	    //bind parameters
	    $member_query->bind_param('ii',$start,$offset);

	    if($member_query === FALSE)
	    {
		    $error="parameter error";
		    return FALSE;
	    }

	    $member_query->execute();

	    if($member_query === FALSE)
	    {
		    $error="error in sql query";
		    return FALSE;
	    }

	    $member_query_result = $member_query->get_result();
	    //ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$conn->error));
	    if($tab_id == 1){
		    //    echo "sd";die;
		    ResponseUtility::echoJsonObject($this->queryResultResponseforqa($member_query_result,$error));
	    }else{
		    ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$error));

	    }

	    return TRUE;
    }

    /*
	NAME    : search
	TYPE    : global Utiltiy function 
	DETAILS : 
	RETURN  : 
     */
    public function search_old($search_parameters,&$error)
    {
	    //database connection
	    include("../db.php");
	    //custom parameter datas
	    $plan_id = $search_parameters['planId'];
	    $user_id = $search_parameters['userId'];
	    $year = $search_parameters['year'];
	    $min = $search_parameters['min'];
	    $max = $search_parameters['max'];

	    $tab_id = $search_parameters['tabId'];
	    $base_sort_by = $search_parameters['baseSortBy'];
	    $base_sort_order = $search_parameters['baseSortOrder']==0?'ASC':'DESC';
	    $sort_by = $search_parameters['sortBy']; 
	    $sort_order = $search_parameters['sortOrder']==0?'ASC':'DESC';

	    $start = $min;
	    $offset = $max - $min;

	    $sql_global_member_query = array();

	    if(array_key_exists('planId',$search_parameters))
	    {   
		    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
			    ReportGlobalMembers::convertToDefaultMemberSqlQuery(
				    GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
				    self::getNurseRequiredColumnAsString($tab_id)))
			    );

	    }
	    else
	    {
		    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
			    ReportGlobalMembers::convertToDefaultMemberSqlQuery(
				    GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
				    self::getNurseRequiredColumnAsString($tab_id)))
			    );
	    }
	    //if invalid user details sent                                                
	    if(count($sql_global_member_query)==0) return FALSE;  
	    //where clause array and condition
	    $where_clause_contiditions = array();
	    //to get this report assigned members where clause condition
	    /*$my_member_filter['nurseIds']=$user_id;
	    $my_member_filter['column']="nurse_id";
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('report',$my_member_filter)); */ 

	    //hra status based on tab
	    /*$nurse_hralist = $this->tabHraCondition($tab_id);
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));*/
	    $nurse_hralist = $this->tabHraCondition($tab_id);
	    switch($tab_id)
	    {
	    case '1':
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,'('.GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist).' OR '.GlobalQueryBuilder::whereClauseReportQATabConditionQuery().')') ;
		    break;
	    case '2':
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
		    break;
	    case '3':
		    //  $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
		    $getmemberlists = $this->getmemberslistids($plan_id,$year);
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHomeAccessResultsTabConditionQuery($getmemberlists));
		    break;
	    case '4':
		    $getmemberlists = $this->getmemberslistids($plan_id,$year);
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHomeAccessResultsTabConditionQuery($getmemberlists));
		    //$where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
		    break;
	    case '5':
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
		    break;
	    case '6':
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseReportRefusalTabConditionQuery());
		    break;
	    default:
		    break;
	    }

	    //search where clause condition 
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByColumnLike('firstname',$search_parameters,'firstname'));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByColumnLike('lastname',$search_parameters,'lastname'));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberId($search_parameters,'id'));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('Plan',$search_parameters,'plan'));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('Program',$search_parameters,'program'));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('LOB',$search_parameters,'lob'));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('Member_City',$search_parameters,'city'));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('Member_Zip_Code',$search_parameters,'zip'));

	    if(count($where_clause_contiditions)==0) { $error="invalid search value"; return FALSE;}   

	    //if any valid where clause found append 'where'
	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
	    //if multiple where clause add 'and' else 'or' condition
	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));

	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy(UserRoleConstant::NURSE,$base_sort_by,$sort_by,$base_sort_order,$sort_order));

	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT ?,? ");

	    $generated_query = implode($sql_global_member_query);
	    //echo $generated_query;die;

	    if($conn->connect_errno)
	    {
		    $error="database connection failed";
	    }

	    //prepare the member query
	    $member_query=$conn->prepare($generated_query);
	    if($member_query===FALSE)
	    {
		    $error = "error preparing sql query";
		    return FALSE;
	    }
	    //bind parameters
	    $member_query->bind_param('ii',$start,$offset);

	    if($member_query === FALSE)
	    {
		    $error="parameter error";
		    return FALSE;
	    }

	    $member_query->execute();

	    if($member_query === FALSE)
	    {
		    $error="error in sql query";
		    return FALSE;
	    }

	    $member_query_result = $member_query->get_result();
	    // ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$error));

	    if($tab_id == 1){
		    //    echo "sd";die;
		    ResponseUtility::echoJsonObject($this->queryResultResponseforqa($member_query_result,$error));
	    }else{
		    ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$error));

	    }

	    return TRUE;

    }


/*
	NAME    : search for performance
	TYPE    : global Utiltiy function 
	DETAILS : 
	RETURN  : 
 */
    public function reportSearch($search_parameters,&$error)
    {
	    //database connection
	    include("../db.php");
	    //custom parameter datas
	    $plan_id = $search_parameters['planId'];
	    $user_id = $search_parameters['userId'];
	    $year = $search_parameters['year'];
	    $min = $search_parameters['min'];
	    $max = $search_parameters['max'];

	    $tab_id = $search_parameters['tabId'];
	    $base_sort_by = $search_parameters['baseSortBy'];
	    $base_sort_order = $search_parameters['baseSortOrder']==0?'ASC':'DESC';
	    $sort_by = $search_parameters['sortBy']; 
	    $sort_order = $search_parameters['sortOrder']==0?'ASC':'DESC';

	    $isSearchApplied = $search_parameters['isSearchApplied'];
	    $memberid = $search_parameters['id'];
	    $firstname = $search_parameters['firstname'];
	    $lastname = $search_parameters['lastname'];

		//if($tab_id == 3){
		 //$getmemberlists = $this->getmemberslistids($plan_id,$year);
      
		//}

	    $start = $min;
	    $offset = $max - $min;

	    $combine_member_query = $this -> getQuery($tab_id,$plan_id,$year);

	    if($combine_member_query && is_array($combine_member_query))
	    {
		    $whereCondition = $this->tabConditionNew($tab_id,$getmemberlists);
		    $searchCondition = $this -> tabConditionSearch($whereCondition,$tab_id,$isSearchApplied,$memberid,$firstname,$lastname);
		    $orderBy =$this->memberSorting($sort_by,$sort_order);
		    $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
		    $sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (". $sql_global_member_query1 . " ) as  member_info  where $searchCondition  $orderBy[0] limit $min,$max";
	    }
	    //echo $sql_global_member_query1;exit;
	    $memberrecordscount = mysqli_query($conn,$sql_global_member_query1);

	    $final_response = $this -> getFinalResponse($memberrecordscount,$tab_id);
	    echo json_encode($final_response);
	    return TRUE;

    }


    public function   filtermontlyscreeningresult($filter_parameters,$error){
	    include("../db.php");
	    //custom parameter datas
	    $plan_id = $filter_parameters['planId'];
	    $user_id = $filter_parameters['userId'];
	    $year = $filter_parameters['year'];
	    $min = $filter_parameters['min'];
	    $max = $filter_parameters['max'];
	    $page = $parameters['page'];
	    $base_sort_by = $filter_parameters['baseSortBy'];
	    $base_sort_order = $filter_parameters['baseSortOrder']==0?'ASC':'DESC';
	    $sort_by = $filter_parameters['sortBy']; 
	    $sort_order = $filter_parameters['sortOrder']==0?'ASC':'DESC';
	    $overallmemberids =   $this ->filtermemberslistformonthlyscreening($plan_id,$year,$filter_parameters);
	    $serialarray = $overallmemberids['serialrecords'];

	    $memberidslist = "'" . implode ( "', '", $overallmemberids['memberids'] ) . "'";

	    $arrdata = explode(",",$memberidslist);
	    $resprecordcount = count($overallmemberids['memberids']);

	    $newdaata = [];
	    $getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";

	    $getClientsidsresult=mysqli_query($conn,$getClientsids);
	    while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
		    $clientId =  $getClientsidsresp['clientId'];
		    $get_arraydataa[] = "select firstname,clientid,year,member_id,lastname,memberinfo,
			    JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory, REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','demographic' )),'.component', '.value[0]') )) As Demographic,
			    JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory, REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening' )),'.component', '.value[0]') )) As ScreeningArray from HRA_member_".$clientId.'_'.$year;

	    }
	    if($get_arraydataa && is_array($get_arraydataa))
	    {
		    $get_arraydataa = implode(" UNION ALL ", $get_arraydataa);
	    }

	    $memberinfo = $overallmemberids['serialrecords'];

	    $nb_elem_per_page = 100;
	    $page = isset($page)?intval($page-1):0;

	    $k = 0;
	    if($resprecordcount  != 0){

		    if($sort_by == 'screeningname'){

			    if($sort_order == 'ASC') {


				    usort($serialarray, function ($item1, $item2) {
					    return $item1['serialname'] <=> $item2['serialname'];
				    });
			    }else{

				    usort($serialarray, function ($item1, $item2) {
					    return $item2['serialname'] <=> $item1['serialname'];
				    });

			    }

		    }

		    if($sort_by == 'examdate'){

			    if($sort_order == 'ASC') {
				    usort($serialarray, function ($item1, $item2) {
					    return new DateTime($item1['examdate']) <=> new DateTime($item2['examdate']);
				    });
			    }else{

				    usort($serialarray, function ($item1, $item2) {
					    return $item2['examdate'] <=> $item1['examdate'];
					    //  return new DateTime($item2['examdate']) <=> new DateTime($item1['examdate']);
				    });

			    }

		    }


		    $arraydtaa2=  array_slice($serialarray, $page*$nb_elem_per_page, $nb_elem_per_page);
		    $member_idslist = array_column($arraydtaa2, 'member_id');
		    $newarray2 = array_count_values($member_idslist);


		    if($sort_by == 'examdate' || $sort_by == 'screeningname'){
			    $k=0;
			    foreach ( $member_idslist as $memberId){

				    $get_arraydata = "select * from (".$get_arraydataa. ") as member_table where member_id = $memberId";

				    $get_arraydataall=mysqli_query($conn,$get_arraydata);
				    $get_arraydataallrow=mysqli_fetch_array($get_arraydataall,MYSQLI_ASSOC);
				    //  $k = $k + 1; 
				    $serial = $arraydtaa2[$k]['serial'];
				    $serialname = $arraydtaa2[$k]['serialname'];
				    $examdate = $arraydtaa2[$k]['examdate'];
				    $member_id = $get_arraydataallrow['member_id']; 
				    $k = $k + 1; 
				    $newdaata[] =array(
					    'serial' => $serial,
					    'serialname' => $serialname,
					    'examdate' => $examdate,
					    'firstname' => $get_arraydataallrow['firstname'],
					    'client_id' => $get_arraydataallrow['clientid'],
					    'client_year' => $get_arraydataallrow['year'],
					    'member_id' => $get_arraydataallrow['member_id'],
					    'lastname' => $get_arraydataallrow['lastname'],
					    'memberinfo' => json_decode($get_arraydataallrow['memberinfo'], true, JSON_UNESCAPED_SLASHES),
					    'Demographic' => json_decode($get_arraydataallrow['Demographic'], true, JSON_UNESCAPED_SLASHES),
					    'ScreeningArray' => json_decode($get_arraydataallrow['ScreeningArray'], true, JSON_UNESCAPED_SLASHES)

				    );

			    }


		    }
		    else{
			    $m = 0;
			    foreach ( $newarray2 as $memberId  => $count) {   
				    $newmemberid = $member_id;
				    $get_arraydata = "select * from (".$get_arraydataa. ") as member_table where member_id = $memberId";

				    $get_arraydataall=mysqli_query($conn,$get_arraydata);
				    $get_arraydataallrow=mysqli_fetch_array($get_arraydataall,MYSQLI_ASSOC);
				    for($j=0;$j<$count;$j++){

					    $newdaata[] =array(
						    'serial' => $arraydtaa2[$m]['serial'] ,
						    'serialname' => $arraydtaa2[$m]['serialname'],
						    'examdate' => $arraydtaa2[$m]['examdate'],
						    'firstname' => $get_arraydataallrow['firstname'],
						    'client_id' => $get_arraydataallrow['clientid'],
						    'client_year' => $get_arraydataallrow['year'],
						    'member_id' => $get_arraydataallrow['member_id'],
						    'lastname' => $get_arraydataallrow['lastname'],
						    'memberinfo' => json_decode($get_arraydataallrow['memberinfo'], true, JSON_UNESCAPED_SLASHES),
						    'Demographic' => json_decode($get_arraydataallrow['Demographic'], true, JSON_UNESCAPED_SLASHES),
						    'ScreeningArray' => json_decode($get_arraydataallrow['ScreeningArray'], true, JSON_UNESCAPED_SLASHES)

					    );
					    $m= $m + 1;
				    }

			    }
		    }


		    $member_infodata=array("status"=>true,"members"=>$newdaata,"error"=>"","totalRows"=>count($arrdata));
	    }
	    else{
		    $member_infodata=array("status"=>true,"members"=>$newdaata,"error"=>"","totalRows"=>0);
	    }

	    echo $res_result = json_encode($member_infodata);  

    }

    public function searchmontlyscreeningresult($parameters,&$error){
	    include("../db.php");
	    //custom parameter datas
	    $plan_id = $parameters['planId'];
	    $user_id = $parameters['userId'];
	    $year = $parameters['year'];
	    $min = $parameters['min'];
	    $max = $parameters['max'];
	    $base_sort_by = $parameters['baseSortBy'];
	    $base_sort_order = $parameters['baseSortOrder']==0?'ASC':'DESC';
	    $sort_by = $parameters['sortBy']; 
	    $sort_order = $parameters['sortOrder']==0?'ASC':'DESC';
	    $page = $parameters['page'];
	    $overallmemberids =   $this ->searchmemberslistformonthlyscreening($plan_id,$year,$parameters);
	    //print_r($overallmemberids);die;
	    $serialarray = $overallmemberids['serialrecords'];
	    $memberidslist = "'" . implode ( "', '", $overallmemberids['memberids'] ) . "'";

	    $arrdata = explode(",",$memberidslist);
	    $resprecordcount = count($overallmemberids['memberids']);

	    $newdaata = [];
	    $getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";

	    $getClientsidsresult=mysqli_query($conn,$getClientsids);
	    while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
		    $clientId =  $getClientsidsresp['clientId'];

		    $get_arraydataa[] = "select firstname,clientid,year,member_id,lastname,memberinfo,
			    JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory, REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','demographic' )),'.component', '.value[0]') )) As Demographic,
			    JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory, REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening' )),'.component', '.value[0]') )) As ScreeningArray from HRA_member_".$clientId.'_'.$year;

	    }
	    if($get_arraydataa && is_array($get_arraydataa))
	    {
		    $get_arraydataa = implode(" UNION ALL ", $get_arraydataa);
	    }

	    $memberinfo = $overallmemberids['serialrecords'];

	    $nb_elem_per_page = 100;
	    $page = isset($page)?intval($page-1):0;

	    $k = 0;
	    //echo $resprecordcount;die;
	    if($resprecordcount  != 0){

		    if($sort_by == 'screeningname'){

			    if($sort_order == 'ASC') {


				    usort($serialarray, function ($item1, $item2) {
					    return $item1['serialname'] <=> $item2['serialname'];
				    });
			    }else{

				    usort($serialarray, function ($item1, $item2) {
					    return $item2['serialname'] <=> $item1['serialname'];
				    });

			    }

		    }

		    if($sort_by == 'examdate'){

			    if($sort_order == 'ASC') {
				    usort($serialarray, function ($item1, $item2) {
					    return new DateTime($item1['examdate']) <=> new DateTime($item2['examdate']);
				    });
			    }else{

				    usort($serialarray, function ($item1, $item2) {
					    return $item2['examdate'] <=> $item1['examdate'];
					    //  return new DateTime($item2['examdate']) <=> new DateTime($item1['examdate']);
				    });

			    }

		    }

		    //print_r($serialarray);die;
		    $arraydtaa2=  array_slice($serialarray, $page*$nb_elem_per_page, $nb_elem_per_page);
		    $member_idslist = array_column($arraydtaa2, 'member_id');
		    $newarray2 = array_count_values($member_idslist);

		    if($sort_by == 'examdate' || $sort_by == 'screeningname'){
			    $k=0;
			    foreach ( $member_idslist as $memberId){

				    $get_arraydata = "select * from (".$get_arraydataa. ") as member_table where member_id = $memberId";

				    $get_arraydataall=mysqli_query($conn,$get_arraydata);
				    $get_arraydataallrow=mysqli_fetch_array($get_arraydataall,MYSQLI_ASSOC);
				    //  $k = $k + 1; 
				    $serial = $arraydtaa2[$k]['serial'];
				    $serialname = $arraydtaa2[$k]['serialname'];
				    $examdate = $arraydtaa2[$k]['examdate'];
				    $member_id = $get_arraydataallrow['member_id']; 
				    $k = $k + 1; 
				    $newdaata[] =array(
					    'serial' => $serial,
					    'serialname' => $serialname,
					    'examdate' => $examdate,
					    'firstname' => $get_arraydataallrow['firstname'],
					    'client_id' => $get_arraydataallrow['clientid'],
					    'client_year' => $get_arraydataallrow['year'],
					    'member_id' => $get_arraydataallrow['member_id'],
					    'lastname' => $get_arraydataallrow['lastname'],
					    'memberinfo' => json_decode($get_arraydataallrow['memberinfo'], true, JSON_UNESCAPED_SLASHES),
					    'Demographic' => json_decode($get_arraydataallrow['Demographic'], true, JSON_UNESCAPED_SLASHES),
					    'ScreeningArray' => json_decode($get_arraydataallrow['ScreeningArray'], true, JSON_UNESCAPED_SLASHES)

				    );

			    }


		    }
		    else{
			    $m = 0;
			    //echo "else";
			    //print_r($newarray2);die;
			    foreach ( $newarray2 as $memberId  => $count) {   
				    $newmemberid = $member_id;
				    $get_arraydata = "select * from (".$get_arraydataa. ") as member_table where member_id = $memberId";

				    $get_arraydataall=mysqli_query($conn,$get_arraydata);
				    $get_arraydataallrow=mysqli_fetch_array($get_arraydataall,MYSQLI_ASSOC);
				    for($j=0;$j<$count;$j++){

					    $newdaata[] =array(
						    'serial' => $arraydtaa2[$m]['serial'] ,
						    'serialname' => $arraydtaa2[$m]['serialname'],
						    'examdate' => $arraydtaa2[$m]['examdate'],
						    'firstname' => $get_arraydataallrow['firstname'],
						    'client_id' => $get_arraydataallrow['clientid'],
						    'client_year' => $get_arraydataallrow['year'],
						    'member_id' => $get_arraydataallrow['member_id'],
						    'lastname' => $get_arraydataallrow['lastname'],
						    'memberinfo' => json_decode($get_arraydataallrow['memberinfo'], true, JSON_UNESCAPED_SLASHES),
						    'Demographic' => json_decode($get_arraydataallrow['Demographic'], true, JSON_UNESCAPED_SLASHES),
						    'ScreeningArray' => json_decode($get_arraydataallrow['ScreeningArray'], true, JSON_UNESCAPED_SLASHES)

					    );
					    $m= $m + 1;
				    }

			    }
		    }


		    $member_infodata=array("status"=>true,"members"=>$newdaata,"error"=>"","totalRows"=>count($arrdata));
	    }
	    else{
		    $member_infodata=array("status"=>true,"members"=>$newdaata,"error"=>"","totalRows"=>0);
	    }

	    echo $res_result = json_encode($member_infodata);  


    }



    public function reportmontlyscreeningresult($parameters,&$error){
	    include("../db.php");
	    //custom parameter datas
	    $plan_id = $parameters['planId'];
	    $user_id = $parameters['userId'];
	    $year = $parameters['year'];
	    $min = $parameters['min'];
	    $page = $parameters['page'];
	    $max = $parameters['max'];
	    $base_sort_by = $parameters['baseSortBy'];
	    $base_sort_order = $parameters['baseSortOrder']==0?'ASC':'DESC';
	    $sort_by = $parameters['sortBy']; 
	    $sort_order = $parameters['sortOrder']==0?'ASC':'DESC';

	    //getting member ids list based on matched conditions
	    $overallmemberids =   $this ->getmemberslistformonthlyscreening($plan_id,$year,$parameters);
	    $serialarray = $overallmemberids['serialrecords'];
	    $memberidslist = "'" . implode ( "', '", $overallmemberids['memberids'] ) . "'";
	    $arrdata = explode(",",$memberidslist);

	    $newdaata = [];
	    $getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";

	    $getClientsidsresult=mysqli_query($conn,$getClientsids);
	    while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
		    $clientId =  $getClientsidsresp['clientId'];
		    $get_arraydataa[] = "select firstname,clientid,year,member_id,lastname,memberinfo,
			    JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory, REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','demographic' )),'.component', '.value[0]') )) As Demographic,
			    JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory, REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening' )),'.component', '.value[0]') )) As ScreeningArray from HRA_member_".$clientId.'_'.$year;


	    }
	    if($get_arraydataa && is_array($get_arraydataa))
	    {
		    $get_arraydataa = implode(" UNION ALL ", $get_arraydataa);
	    }

	    $memberinfo = $overallmemberids['serialrecords'];
	    $resprecordcount = count($overallmemberids['memberids']);


	    $nb_elem_per_page = 100;
	    $page = isset($page)?intval($page-1):0;

	    $k = 0;
	    if($resprecordcount  != 0){

		    if($sort_by == 'screeningname'){

			    if($sort_order == 'ASC') { 
				    usort($serialarray, function ($item1, $item2) {
					    return $item1['serialname'] <=> $item2['serialname'];
				    });
			    }else{

				    usort($serialarray, function ($item1, $item2) {
					    return $item2['serialname'] <=> $item1['serialname'];
				    });

			    }

		    }

		    if($sort_by == 'examdate'){

			    if($sort_order == 'ASC') {
				    usort($serialarray, function ($item1, $item2) {
					    return new DateTime($item1['examdate']) <=> new DateTime($item2['examdate']);
				    });
			    }else{

				    usort($serialarray, function ($item1, $item2) {
					    return $item2['examdate'] <=> $item1['examdate'];
				    });

			    }

		    }
		    $arraydtaa2=  array_slice($serialarray, $page*$nb_elem_per_page, $nb_elem_per_page);
		    $member_idslist = array_column($arraydtaa2, 'member_id');
		    $newarray2 = array_count_values($member_idslist);
		    if($sort_by == 'examdate' || $sort_by == 'screeningname'){
			    $k=0;
			    foreach ( $member_idslist as $memberId){

				    $get_arraydata = "select * from (".$get_arraydataa. ") as member_table where member_id = $memberId";

				    $get_arraydataall=mysqli_query($conn,$get_arraydata);
				    $get_arraydataallrow=mysqli_fetch_array($get_arraydataall,MYSQLI_ASSOC);
				    $serial = $arraydtaa2[$k]['serial'];
				    $serialname = $arraydtaa2[$k]['serialname'];
				    $examdate = $arraydtaa2[$k]['examdate'];
				    $member_id = $get_arraydataallrow['member_id']; 
				    $k = $k + 1; 
				    $newdaata[] =array(
					    'serial' => $serial,
					    'serialname' => $serialname,
					    'examdate' => $examdate,
					    'firstname' => $get_arraydataallrow['firstname'],
					    'client_id' => $get_arraydataallrow['clientid'],
					    'client_year' => $get_arraydataallrow['year'],
					    'member_id' => $get_arraydataallrow['member_id'],
					    'lastname' => $get_arraydataallrow['lastname'],
					    'memberinfo' => json_decode($get_arraydataallrow['memberinfo'], true, JSON_UNESCAPED_SLASHES),
					    'Demographic' => json_decode($get_arraydataallrow['Demographic'], true, JSON_UNESCAPED_SLASHES),
					    'ScreeningArray' => json_decode($get_arraydataallrow['ScreeningArray'], true, JSON_UNESCAPED_SLASHES)

				    );

			    }


		    }
		    else{
			    $m = 0;
			    foreach ( $newarray2 as $memberId  => $count) {   
				    $newmemberid = $member_id;
				    $get_arraydata = "select * from (".$get_arraydataa. ") as member_table where member_id = $memberId";

				    $get_arraydataall=mysqli_query($conn,$get_arraydata);
				    $get_arraydataallrow=mysqli_fetch_array($get_arraydataall,MYSQLI_ASSOC);
				    for($j=0;$j<$count;$j++){

					    $newdaata[] =array(
						    'serial' => $arraydtaa2[$m]['serial'] ,
						    'serialname' => $arraydtaa2[$m]['serialname'],
						    'examdate' => $arraydtaa2[$m]['examdate'],
						    'firstname' => $get_arraydataallrow['firstname'],
						    'client_id' => $get_arraydataallrow['clientid'],
						    'client_year' => $get_arraydataallrow['year'],
						    'member_id' => $get_arraydataallrow['member_id'],
						    'lastname' => $get_arraydataallrow['lastname'],
						    'memberinfo' => json_decode($get_arraydataallrow['memberinfo'], true, JSON_UNESCAPED_SLASHES),
						    'Demographic' => json_decode($get_arraydataallrow['Demographic'], true, JSON_UNESCAPED_SLASHES),
						    'ScreeningArray' => json_decode($get_arraydataallrow['ScreeningArray'], true, JSON_UNESCAPED_SLASHES)

					    );
					    $m= $m + 1;
				    }

			    }
		    }

		    $member_infodata=array("status"=>true,"members"=>$newdaata,"error"=>"","totalRows"=>count($arrdata));
	    }
	    else{
		    $member_infodata=array("status"=>true,"members"=>$newdaata,"error"=>"","totalRows"=>0);
	    }

	    echo $res_result = json_encode($member_infodata);  

    }


    public function filtermemberslistformonthlyscreening($plan_id,$year,$filter_parameters){

	    $memberid = $filter_parameters['id'];
	    $firstname = $filter_parameters['firstname'];
	    $lastname = $filter_parameters['lastname'];

	    $base_sort_by = $filter_parameters['baseSortBy'];
	    $base_sort_order = $filter_parameters['baseSortOrder']==0?'ASC':'DESC';
	    $sort_by = $filter_parameters['sortBy']; 
	    $sort_order = $filter_parameters['sortOrder']==0?'ASC':'DESC';

	    $lob= base64_decode(urldecode($filter_parameters['lob']));
	    $filter_parameters['lob']=$lob;

	    $currentfiltersarray = array("0" => "DIGITAL RETINAL EXAM", "1" => "HBA1C", "2" => "MICROALBUMIN", "3" =>"FIT", "4" =>"DEXA", "5" =>"PAD", "6" =>"DLDL");
	    $arradata = explode("_",$filter_parameters['screening']);
	    $intersectresult=array_intersect($currentfiltersarray,$arradata);

	    include("../db.php");
	    $getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";

	    $getClientsidsresult=mysqli_query($conn,$getClientsids);
	    $sql_global_member_query = array();
	    while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
		    $client_id =  $getClientsidsresp['clientId'];

		    //joining tables based on client
		    $combine_member_query[] = "select member_id,clientid as client_id,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Program')))) AS memberProgram,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.LOB')))) AS memberLob,scheduleDate,memberinfo,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Member_first_name')))) AS memberFirstName,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Member_Last_name')))) AS memberLastName,STR_TO_DATE(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.date' ) )),'%m-%d-%Y') AS ScreeningDate,lastname,JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0]'
		    ) )) AS screeningobject FROM HRA_member_".$client_id.'_'.$year;

	    }
	    if($combine_member_query && is_array($combine_member_query))
	    {
		    $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
		    $sql_global_member_query1 = "select * from (".$sql_global_member_query1.") as  member_table";
		    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,$sql_global_member_query1);
	    }

	    if(count($sql_global_member_query)==0) return FALSE; 
	    $where_clause_contiditions = array();

	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'lob','LOB',true));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'plan','Plan',true));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'program','Program',true));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseCustomColumnValueIn('client_id',$filter_parameters,'clientId',true,'|',','));

	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseScheduleDateBetween($filter_parameters));

	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));

	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));

	    // print_r($where_clause_contiditions);die;
	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('nurse',$base_sort_by,$sort_by,$base_sort_order,$sort_order));

	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT 0,200000");
	    //generated query 
	    $generated_query = implode($sql_global_member_query);
	    //echo $generated_query;die;

	    $membersresult=mysqli_query($conn,$generated_query);

	    $memberserailids = [];
	    $offerArray = array();
	    $overallarray = array();
	    while($membersresultresp=mysqli_fetch_array($membersresult,MYSQLI_ASSOC)){
		    if($membersresultresp['screeningobject'] != null ){
			    $arraydata = json_decode($membersresultresp['screeningobject'],true);
			    if(count($intersectresult) == 0) { 
				    if($arraydata[0][2] != '' || $arraydata[0][3])
				    {
					    $member_id=  $membersresultresp['member_id'];
					    $memberids[] = $member_id;

					    $memberserailids['serial'] = 0;
					    $memberserailids['examdate'] = $arraydata[0][3];
					    $memberserailids['serialname'] = 'DIGITAL RETINAL EXAM';
					    $memberserailids['member_id'] = $member_id;
					    array_push($offerArray,$memberserailids);


				    }

				    if($arraydata[1][2] != '' || $arraydata[1][3])
				    {
					    $member_id=  $membersresultresp['member_id'];
					    $memberids[] = $member_id;

					    $memberserailids['serial'] = 1;
					    $memberserailids['examdate'] = $arraydata[1][3];
					    $memberserailids['serialname'] = 'HBA1C';
					    $memberserailids['member_id'] = $member_id;
					    array_push($offerArray,$memberserailids);
					    // array_push($offerArray,$keyval);

				    }
				    if($arraydata[2][2] != '' || $arraydata[2][3] != '') {
					    $member_id=  $membersresultresp['member_id'];
					    $memberids[] = $member_id;

					    $memberserailids['serial'] = 2;
					    $memberserailids['examdate'] = $arraydata[2][3];
					    $memberserailids['serialname'] = 'MICROALBUMIN';
					    $memberserailids['member_id'] = $member_id;
					    array_push($offerArray,$memberserailids);
				    }

				    if($arraydata[3][2] != ''  || $arraydata[3][3] != ''){
					    $member_id=  $membersresultresp['member_id'];
					    $memberids[] = $member_id;

					    $memberserailids['serial'] = 3;
					    $memberserailids['examdate'] = $arraydata[3][3];
					    $memberserailids['serialname'] = 'FIT';
					    $memberserailids['member_id'] = $member_id;
					    array_push($offerArray,$memberserailids);
				    }

				    if($arraydata[4][2] != ''  || $arraydata[4][3] != ''){
					    $member_id=  $membersresultresp['member_id'];
					    $memberids[] = $member_id;

					    $memberserailids['serial'] = 4;
					    $memberserailids['examdate'] = $arraydata[4][3];
					    $memberserailids['serialname'] = 'DEXA';
					    $memberserailids['member_id'] = $member_id;
					    array_push($offerArray,$memberserailids);
				    }

				    if($arraydata[5][2] != ''  || $arraydata[5][3] != ''){
					    $member_id=  $membersresultresp['member_id'];
					    $memberids[] = $member_id;

					    $memberserailids['serial'] = 5;
					    $memberserailids['examdate'] = $arraydata[5][3];
					    $memberserailids['serialname'] = 'PAD';
					    $memberserailids['member_id'] = $member_id;
					    array_push($offerArray,$memberserailids);
				    }


				    if($arraydata[6][2] != ''   || $arraydata[6][3] != ''){
					    $member_id=  $membersresultresp['member_id'];
					    $memberids[] = $member_id;

					    $memberserailids['serial'] = 6;
					    $memberserailids['examdate'] = $arraydata[6][3];
					    $memberserailids['serialname'] = 'DLDL';
					    $memberserailids['member_id'] = $member_id;
					    array_push($offerArray,$memberserailids);
				    }


			    }else{


				    if(($arraydata[0][2] != '' || $arraydata[0][3]) && $intersectresult[0] != '')
				    {
					    $member_id=  $membersresultresp['member_id'];
					    $memberids[] = $member_id;

					    $memberserailids['serial'] = 0;
					    $memberserailids['examdate'] = $arraydata[0][3];
					    $memberserailids['serialname'] = 'DIGITAL RETINAL EXAM';
					    $memberserailids['member_id'] = $member_id;
					    array_push($offerArray,$memberserailids);


				    }

				    if(($arraydata[1][2] != '' || $arraydata[1][3])  && $intersectresult[1] != '')
				    {
					    $member_id=  $membersresultresp['member_id'];
					    $memberids[] = $member_id;

					    $memberserailids['serial'] = 1;
					    $memberserailids['examdate'] = $arraydata[1][3];
					    $memberserailids['serialname'] = 'HBA1C';
					    $memberserailids['member_id'] = $member_id;
					    array_push($offerArray,$memberserailids);
					    // array_push($offerArray,$keyval);

				    }
				    if(($arraydata[2][2] != '' || $arraydata[2][3] != '')   && $intersectresult[2] != '' ) {
					    $member_id=  $membersresultresp['member_id'];
					    $memberids[] = $member_id;

					    $memberserailids['serial'] = 2;
					    $memberserailids['examdate'] = $arraydata[2][3];
					    $memberserailids['serialname'] = 'MICROALBUMIN';
					    $memberserailids['member_id'] = $member_id;
					    array_push($offerArray,$memberserailids);
				    }

				    if(($arraydata[3][2] != ''  || $arraydata[3][3] != '') && $intersectresult[3] != '' ){
					    $member_id=  $membersresultresp['member_id'];
					    $memberids[] = $member_id;

					    $memberserailids['serial'] = 3;
					    $memberserailids['examdate'] = $arraydata[3][3];
					    $memberserailids['serialname'] = 'FIT';
					    $memberserailids['member_id'] = $member_id;
					    array_push($offerArray,$memberserailids);
				    }

				    if(($arraydata[4][2] != ''  || $arraydata[4][3] != '') && $intersectresult[4] != '' ){
					    $member_id=  $membersresultresp['member_id'];
					    $memberids[] = $member_id;

					    $memberserailids['serial'] = 4;
					    $memberserailids['examdate'] = $arraydata[4][3];
					    $memberserailids['serialname'] = 'DEXA';
					    $memberserailids['member_id'] = $member_id;
					    array_push($offerArray,$memberserailids);
				    }

				    if(($arraydata[5][2] != ''  || $arraydata[5][3] != '') && $intersectresult[5] != '' ){
					    $member_id=  $membersresultresp['member_id'];
					    $memberids[] = $member_id;

					    $memberserailids['serial'] = 5;
					    $memberserailids['examdate'] = $arraydata[5][3];
					    $memberserailids['serialname'] = 'PAD';
					    $memberserailids['member_id'] = $member_id;
					    array_push($offerArray,$memberserailids);
				    }


				    if(($arraydata[6][2] != ''   || $arraydata[6][3] != '') && $intersectresult[6] != '' ){
					    $member_id=  $membersresultresp['member_id'];
					    $memberids[] = $member_id;

					    $memberserailids['serial'] = 6;
					    $memberserailids['examdate'] = $arraydata[6][3];
					    $memberserailids['serialname'] = 'DLDL';
					    $memberserailids['member_id'] = $member_id;
					    array_push($offerArray,$memberserailids);
				    }



			    }


		    }

	    }

	    $overallarray['serialrecords'] = $offerArray;
	    $overallarray['memberids'] = $memberids;
	    return $overallarray;

    }


    public function searchmemberslistformonthlyscreening($plan_id,$year,$parameters){
	    $memberid = $parameters['id'];
	    $firstname = $parameters['firstname'];
	    $lastname = $parameters['lastname'];

	    $base_sort_by = $parameters['baseSortBy'];
	    $base_sort_order = $parameters['baseSortOrder']==0?'ASC':'DESC';
	    $sort_by = $parameters['sortBy']; 
	    $sort_order = $parameters['sortOrder']==0?'ASC':'DESC';

	    include("../db.php");
	    $getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";

	    $getClientsidsresult=mysqli_query($conn,$getClientsids);
	    $sql_global_member_query = array();

	    while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
		    $client_id =  $getClientsidsresp['clientId'];

		    $combine_member_query[] = "select member_id,firstname,clientid as client_id,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Program')))) AS memberProgram,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.LOB')))) AS memberLob,scheduleDate,memberinfo,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Member_first_name')))) AS memberFirstName,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Member_Last_name')))) AS memberLastName,STR_TO_DATE(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.date' ) )),'%m-%d-%Y') AS ScreeningDate,lastname,JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0]'
		    ) )) AS screeningobject FROM HRA_member_".$client_id.'_'.$year;

	    }
	    if($combine_member_query && is_array($combine_member_query))
	    {
		    $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
		    $sql_global_member_query1 = "select * from (".$sql_global_member_query1.") as  member_table";
		    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,$sql_global_member_query1);

	    }

	    if(count($sql_global_member_query)==0) return FALSE; 
	    $where_clause_contiditions = array();

	    //search where clause condition 
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByColumnLike('firstname',$parameters,'firstname'));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByColumnLike('lastname',$parameters,'lastname'));
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberId($parameters,'id'));


	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
	    //if multiple where clause add 'and' else 'or' condition
	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));

	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy(UserRoleConstant::NURSE,$base_sort_by,$sort_by,$base_sort_order,$sort_order));

	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT 0,20000 ");

	    $generated_query = implode($sql_global_member_query);
	    //echo $generated_query;die;
	    $membersresult=mysqli_query($conn,$generated_query);

	    $memberserailids = [];
	    $offerArray = array();
	    $overallarray = array();
	    while($membersresultresp=mysqli_fetch_array($membersresult,MYSQLI_ASSOC)){
		    if($membersresultresp['screeningobject'] != null ){

			    $arraydata = json_decode($membersresultresp['screeningobject'],true);
			    if($arraydata[0][2] != '' || $arraydata[0][3])
			    {
				    $member_id=  $membersresultresp['member_id'];
				    $memberids[] = $member_id;

				    $memberserailids['serial'] = 0;
				    $memberserailids['examdate'] = $arraydata[0][3];
				    $memberserailids['serialname'] = 'DIGITAL RETINAL EXAM';
				    $memberserailids['member_id'] = $member_id;
				    array_push($offerArray,$memberserailids);

			    }

			    if($arraydata[1][2] != '' || $arraydata[1][3])
			    {
				    $member_id=  $membersresultresp['member_id'];
				    $memberids[] = $member_id;

				    $memberserailids['serial'] = 1;
				    $memberserailids['examdate'] = $arraydata[1][3];
				    $memberserailids['serialname'] = 'HBA1C';
				    $memberserailids['member_id'] = $member_id;
				    array_push($offerArray,$memberserailids);

			    }
			    if($arraydata[2][2] != '' || $arraydata[2][3] != '') {
				    $member_id=  $membersresultresp['member_id'];
				    $memberids[] = $member_id;

				    $memberserailids['serial'] = 2;
				    $memberserailids['examdate'] = $arraydata[2][3];
				    $memberserailids['serialname'] = 'MICROALBUMIN';
				    $memberserailids['member_id'] = $member_id;
				    array_push($offerArray,$memberserailids);
			    }

			    if($arraydata[3][2] != ''  || $arraydata[3][3] != ''){
				    $member_id=  $membersresultresp['member_id'];
				    $memberids[] = $member_id;

				    $memberserailids['serial'] = 3;
				    $memberserailids['examdate'] = $arraydata[3][3];
				    $memberserailids['serialname'] = 'FIT';
				    $memberserailids['member_id'] = $member_id;
				    array_push($offerArray,$memberserailids);
			    }

			    if($arraydata[4][2] != ''  || $arraydata[4][3] != ''){
				    $member_id=  $membersresultresp['member_id'];
				    $memberids[] = $member_id;

				    $memberserailids['serial'] = 4;
				    $memberserailids['examdate'] = $arraydata[4][3];
				    $memberserailids['serialname'] = 'DEXA';
				    $memberserailids['member_id'] = $member_id;
				    array_push($offerArray,$memberserailids);
			    }

			    if($arraydata[5][2] != ''  || $arraydata[5][3] != ''){
				    $member_id=  $membersresultresp['member_id'];
				    $memberids[] = $member_id;

				    $memberserailids['serial'] = 5;
				    $memberserailids['examdate'] = $arraydata[5][3];
				    $memberserailids['serialname'] = 'PAD';
				    $memberserailids['member_id'] = $member_id;
				    array_push($offerArray,$memberserailids);
			    }


			    if($arraydata[6][2] != ''   || $arraydata[6][3] != ''){
				    $member_id=  $membersresultresp['member_id'];
				    $memberids[] = $member_id;

				    $memberserailids['serial'] = 6;
				    $memberserailids['examdate'] = $arraydata[6][3];
				    $memberserailids['serialname'] = 'DLDL';
				    $memberserailids['member_id'] = $member_id;
				    array_push($offerArray,$memberserailids);
			    }

		    }
	    }

	    $overallarray['serialrecords'] = $offerArray;
	    $overallarray['memberids'] = $memberids;
	    return $overallarray;

    }


    public function getmemberslistformonthlyscreening($plan_id,$year,$parameters){
	    $base_sort_by = $parameters['baseSortBy'];
	    $base_sort_order = $parameters['baseSortOrder']==0?'ASC':'DESC';
	    $sort_by = $parameters['sortBy']; 
	    $sort_order = $parameters['sortOrder']==0?'ASC':'DESC';

	    include("../db.php");
	    $getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";

	    $getClientsidsresult=mysqli_query($conn,$getClientsids);
	    $sql_global_member_query = array();
	    while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
		    $client_id =  $getClientsidsresp['clientId'];
		    //joining tables based on client
		    $combine_member_query[] = "select member_id,clientid as client_id,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Program')))) AS memberProgram,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.LOB')))) AS memberLob,scheduleDate,memberinfo,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Member_first_name')))) AS memberFirstName,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Member_Last_name')))) AS memberLastName,STR_TO_DATE(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.date' ) )),'%m-%d-%Y') AS ScreeningDate,lastname,JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0]'
		    ) )) AS screeningobject FROM HRA_member_".$client_id.'_'.$year;

	    }
	    if($combine_member_query && is_array($combine_member_query))
	    {
		    $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
		    $sql_global_member_query1 = "select * from (". $sql_global_member_query1 . " ) as member_table ";
		    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,$sql_global_member_query1);
	    }


	    if(count($sql_global_member_query)==0) return FALSE; 
	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('nurse',$base_sort_by,$sort_by,$base_sort_order,$sort_order));
	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT 0,200000");

	    $generated_query = implode($sql_global_member_query);
	    //echo $generated_query;die;

	    $membersresult=mysqli_query($conn,$generated_query);
	    $memberserailids = [];
	    $offerArray = array();
	    $overallarray = array();

	    while($membersresultresp=mysqli_fetch_array($membersresult,MYSQLI_ASSOC)){


		    if($membersresultresp['screeningobject'] != null ){

			    $arraydata = json_decode($membersresultresp['screeningobject'],true);
			    if($arraydata[0][2] != '' || $arraydata[0][3])
			    {
				    $member_id=  $membersresultresp['member_id'];
				    $memberids[] = $member_id;

				    $memberserailids['serial'] = 0;
				    $memberserailids['examdate'] = $arraydata[0][3];
				    $memberserailids['serialname'] = 'DIGITAL RETINAL EXAM';
				    $memberserailids['member_id'] = $member_id;
				    array_push($offerArray,$memberserailids);

			    }

			    if($arraydata[1][2] != '' || $arraydata[1][3])
			    {
				    $member_id=  $membersresultresp['member_id'];
				    $memberids[] = $member_id;

				    $memberserailids['serial'] = 1;
				    $memberserailids['examdate'] = $arraydata[1][3];
				    $memberserailids['serialname'] = 'HBA1C';
				    $memberserailids['member_id'] = $member_id;
				    array_push($offerArray,$memberserailids);

			    }
			    if($arraydata[2][2] != '' || $arraydata[2][3] != '') {
				    $member_id=  $membersresultresp['member_id'];
				    $memberids[] = $member_id;

				    $memberserailids['serial'] = 2;
				    $memberserailids['examdate'] = $arraydata[2][3];
				    $memberserailids['serialname'] = 'MICROALBUMIN';
				    $memberserailids['member_id'] = $member_id;
				    array_push($offerArray,$memberserailids);
			    }

			    if($arraydata[3][2] != ''  || $arraydata[3][3] != ''){
				    $member_id=  $membersresultresp['member_id'];
				    $memberids[] = $member_id;

				    $memberserailids['serial'] = 3;
				    $memberserailids['examdate'] = $arraydata[3][3];
				    $memberserailids['serialname'] = 'FIT';
				    $memberserailids['member_id'] = $member_id;
				    array_push($offerArray,$memberserailids);
			    }

			    if($arraydata[4][2] != ''  || $arraydata[4][3] != ''){
				    $member_id=  $membersresultresp['member_id'];
				    $memberids[] = $member_id;

				    $memberserailids['serial'] = 4;
				    $memberserailids['examdate'] = $arraydata[4][3];
				    $memberserailids['serialname'] = 'DEXA';
				    $memberserailids['member_id'] = $member_id;
				    array_push($offerArray,$memberserailids);
			    }

			    if($arraydata[5][2] != ''  || $arraydata[5][3] != ''){
				    $member_id=  $membersresultresp['member_id'];
				    $memberids[] = $member_id;

				    $memberserailids['serial'] = 5;
				    $memberserailids['examdate'] = $arraydata[5][3];
				    $memberserailids['serialname'] = 'PAD';
				    $memberserailids['member_id'] = $member_id;
				    array_push($offerArray,$memberserailids);
			    }


			    if($arraydata[6][2] != ''   || $arraydata[6][3] != ''){
				    $member_id=  $membersresultresp['member_id'];
				    $memberids[] = $member_id;

				    $memberserailids['serial'] = 6;
				    $memberserailids['examdate'] = $arraydata[6][3];
				    $memberserailids['serialname'] = 'DLDL';
				    $memberserailids['member_id'] = $member_id;
				    array_push($offerArray,$memberserailids);
			    }

		    }
	    }
	    //print_r($offerArray);die;
	    $overallarray['serialrecords'] = $offerArray;
	    $overallarray['memberids'] = $memberids;
	    return $overallarray;

    }


    public function getmemberslistidsbyfilter($plan_id,$year,$filter_parameters)
    {

	    include("../db.php");
	    $getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";

	    $getClientsidsresult=mysqli_query($conn,$getClientsids);
	    while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
		    $client_id =  $getClientsidsresp['clientId'];
		    //joining tables based on client
		    $combine_member_query[] = "select member_id,STR_TO_DATE(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.date' ) )),'%m-%d-%Y') AS ScreeningDate,JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0]'
		    ) )) AS screeningobject FROM HRA_member_".$client_id.'_'.$year;

	    }

	    if($combine_member_query && is_array($combine_member_query))
	    {
		    $combine_member_query = implode(" UNION ALL ", $combine_member_query);
	    }

	    // query for getting last screening updated date 
	    $finalquery = $combine_member_query . " ORDER by ScreeningDate DESC LIMIT 1";
	    $LastUpdatedScreenDateresult=mysqli_query($conn,$finalquery);
	    $lastestDateres=mysqli_fetch_array($LastUpdatedScreenDateresult,MYSQLI_ASSOC);
	    $todate =  $lastestDateres['ScreeningDate'];

	    // based on  last screening date getting from and todate 
	    // $enddate = date('Y-m-d', strtotime($todate));
	    //$startdate = date('Y-m-d', strtotime('-7 days', strtotime($enddate))); 

	    //$day = date('Y-m-d');
	    $day = date('w');
	    $startdate = date('Y-m-d', strtotime('+'.(1-$day).' days'));
	    $enddate = date('Y-m-d', strtotime('+'.(7-$day).' days'));

	    //$startdate = '2022-01-10';
	    //$enddate = '2022-01-17';

	    $day = date('Y-m-d');
	    $startdate = $day;
	    $enddate = $day;


	    $finalquery2 = "select * from (". $combine_member_query . " ) as tableC WHERE tableC.ScreeningDate BETWEEN '".$startdate."' and '".$enddate."' ";

	    $membersresult=mysqli_query($conn,$finalquery2);
	    //print_r(mysqli_fetch_array($membersresult,MYSQLI_ASSOC));die;
	    //print_r($filter_parameters);die;
	    $currentfiltersarray = array("0" => "DLDL", "1" => "FIT", "2" => "HBA1C", "3" =>"MICROALBUMIN");

	    $arradata = explode("_",$filter_parameters['screening']);
	    $intersectresult=array_intersect($currentfiltersarray,$arradata);
	    //print_r($intersectresult);die;

	    $memberids = [];
	    while($membersresultres=mysqli_fetch_array($membersresult,MYSQLI_ASSOC)){


		    if($membersresultres['screeningobject'] != 'null' &&  $intersectresult[2] == 'HBA1C'){
			    $arraydata = json_decode($membersresultres['screeningobject'],true);
			    if($arraydata[1][4] != '')
			    {
				    $member_id=  $membersresultres['member_id'];
				    $memberids[] = $member_id;
			    }

		    }

		    if($membersresultres['screeningobject'] != 'null' &&  $intersectresult[3] == 'MICROALBUMIN'){
			    $arraydata = json_decode($membersresultres['screeningobject'],true);
			    if($arraydata[2][4] != '')
			    {
				    $member_id=  $membersresultres['member_id'];
				    $memberids[] = $member_id;
			    }

		    }

		    if($membersresultres['screeningobject'] != 'null' &&  $intersectresult[1] == 'FIT'){
			    $arraydata = json_decode($membersresultres['screeningobject'],true);

			    if($arraydata[3][4] != '')
			    {

				    $member_id=  $membersresultres['member_id'];
				    $memberids[] = $member_id;
			    }

		    }


		    if($membersresultres['screeningobject'] != 'null' &&  $intersectresult[0] == 'DLDL'){
			    $arraydata = json_decode($membersresultres['screeningobject'],true);

			    if($arraydata[6][4] != '')
			    {

				    $member_id=  $membersresultres['member_id'];
				    $memberids[] = $member_id;
			    }

		    }

		    //removed here else
		    if($membersresultres['screeningobject'] != 'null' && ($intersectresult[0] == '' && $intersectresult[1] == '' && $intersectresult[2] == '' && $intersectresult[3] == '')){
			    //echo "s";die;
			    $arraydata = json_decode($membersresultres['screeningobject'],true);

			    if($arraydata[1][4] != '' || $arraydata[2][4] != '' || $arraydata[3][4] != '' || $arraydata[6][4] != '')
			    {
				    $member_id=  $membersresultres['member_id'];
				    $memberids[] = $member_id;
			    }

		    }


	    }
	    //echo "asdf";
	    $memberidslist = "'" . implode ( "', '", $memberids ) . "'";
	    // $memberidslist = '11001318','10050057';
	    //echo "kl";die;
	    //echo $memberidslist;die;
	    return $memberidslist;

    }

    public function getmemberslistids($plan_id,$year)
    {

	    include("../db.php");
	    $getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";

	    $getClientsidsresult=mysqli_query($conn,$getClientsids);
	    while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
		    $client_id =  $getClientsidsresp['clientId'];
		    //joining tables based on client
		    $combine_member_query[] = "select member_id,STR_TO_DATE(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.date' ) )),'%m-%d-%Y') AS ScreeningDate,JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0]'
		    ) )) AS screeningobject FROM HRA_member_".$client_id.'_'.$year;

	    }
	    if($combine_member_query && is_array($combine_member_query))
	    {
		    $combine_member_query = implode(" UNION ALL ", $combine_member_query);
	    }

	    // query for getting last screening updated date 
	 //   $finalquery = $combine_member_query . " ORDER by ScreeningDate DESC LIMIT 1";
	   // $LastUpdatedScreenDateresult=mysqli_query($conn,$finalquery);
	   // $lastestDateres=mysqli_fetch_array($LastUpdatedScreenDateresult,MYSQLI_ASSOC);
	   // $todate =  $lastestDateres['ScreeningDate'];

	

	    $day = date('w');

	    $startdate = date('Y-m-d', strtotime('+'.(1-$day).' days'));
	     $enddate = date('Y-m-d', strtotime('+'.(7-$day).' days'));




	    $finalquery2 = "select * from (". $combine_member_query . " ) as tableC WHERE tableC.ScreeningDate BETWEEN '".$startdate."' and '".$enddate."' ";


	    $membersresult=mysqli_query($conn,$finalquery2);

	    while($membersresultres=mysqli_fetch_array($membersresult,MYSQLI_ASSOC)){


		    if($membersresultres['screeningobject'] != 'null' ){
			    $arraydata = json_decode($membersresultres['screeningobject'],true);
			    if($arraydata[1][4] != '' || $arraydata[2][4] != '' || $arraydata[3][4] != '' || $arraydata[6][4] != '')
			    {
				    $member_id=  $membersresultres['member_id'];
				    $memberids[] = $member_id;
			    }
		    }

	    }
	    $memberidslist = "'" . implode ( "', '", $memberids ) . "'";
	    // $memberidslist = '11001318','10050057';
	    return $memberidslist;

    }



   /*
	NAME    : getMembersForBulkExport
	TYPE    : global Utiltiy function 
	DETAILS : get the member details based on tab id
	RETURN  : member details
		dev - laskhmi
    */
    public function getMembersForBulkExport($parameters,&$error)
    {
	    //database connection
	    include("../db.php");
	    //custom parameter datas
	    $plan_id = $parameters['planId'];
	    $user_id = $parameters['userId'];
	    $year = $parameters['year'];
	    $min = $parameters['min'];
	    $max = $parameters['max'];

	    $tab_id = $parameters['tabId'];
	    $base_sort_by = $parameters['baseSortBy'];
	    $base_sort_order = $parameters['baseSortOrder']==0?'ASC':'DESC';
	    $sort_by = $parameters['sortBy']; 
	    $sort_order = $parameters['sortOrder']==0?'ASC':'DESC';

	    $start = $min;
	    $offset = $max - $min;

	    $sql_global_member_query = array();


	    if($tab_id==5){
		    if(array_key_exists('planId',$parameters))
		    {
			    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
				    ReportGlobalMembers::convertToSortMemberSqlQuery(
					    GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
					    self::getNurseRequiredColumnAsString($tab_id)))
				    );
		    }
		    else
		    {
			    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
				    ReportGlobalMembers::convertToSortMemberSqlQuery(
					    GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
					    self::getNurseRequiredColumnAsString($tab_id)))
				    );
		    }
	    }else{
		    if(array_key_exists('planId',$parameters))
		    {
			    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
				    ReportGlobalMembers::convertToDefaultMemberSqlQuery(
					    GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
					    self::getNurseRequiredColumnAsString($tab_id)))
				    );
		    }
		    else
		    {
			    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
				    ReportGlobalMembers::convertToDefaultMemberSqlQuery(
					    GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
					    self::getNurseRequiredColumnAsString($tab_id)))
				    );
		    }
	    }


	    //when invalid userid sent
	    if(count($sql_global_member_query)==0) return FALSE; 

	    //where clause array and condition
	    $where_clause_contiditions = array();

	    //to get this report assigned members where clause condition
	    /*$my_member_filter['nurseIds']=$user_id;
	    $my_member_filter['column']="nurse_id";
	    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn(UserRoleConstant::NURSE,$my_member_filter));*/
	    //hra status based on tab
	    $nurse_hralist = $this->tabHraCondition($tab_id);
	    /*$where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));*/
	    $nurse_hralist = $this->tabHraCondition($tab_id);
	    switch($tab_id)
	    {
	    case '1':
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,'('.GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist).' OR '.GlobalQueryBuilder::whereClauseReportQATabConditionQuery().')') ;
		    break;
	    case '2':
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
		    break;
	    case '3':
		    $getmemberlists = $this->getmemberslistids($plan_id,$year);
		    //echo $getmemberlists;die;

		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHomeAccessResultsTabConditionQuery($getmemberlists));
		    break;
	    case '4':
		    $getmemberlists = $this->getmemberslistids($plan_id,$year);
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHomeAccessResultsTabConditionQuery($getmemberlists));

		    // $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
		    break;
	    case '5':
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
		    break;
	    case '6':
		    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseReportRefusalTabConditionQuery());
		    break;
	    default:
		    break;
	    }

	    //if any valid where clause found append 'where'
	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
	    //if multiple where clause add 'and' else 'or' condition
	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));
	    //sort by query string
	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('nurse',$base_sort_by,$sort_by,$base_sort_order,$sort_order));
	    //limit by range
	    $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT ?,? ");

	    //genarated query
	    $generated_query = implode($sql_global_member_query);

	    //echo $generated_query;exit();
	    if($conn->connect_errno)
	    {
		    $error="database connection failed";
	    }

	    //prepare the member query
	    $member_query=$conn->prepare($generated_query);
	    if($member_query===FALSE)
	    {
		    $error = "error preparing sql query";
		    return FALSE;
	    }
	    //bind parameters
	    $member_query->bind_param('ii',$start,$offset);

	    if($member_query === FALSE)
	    {
		    $error="parameter error";
		    return FALSE;
	    }

	    $member_query->execute();

	    if($member_query === FALSE)
	    {
		    $error="error in sql query";
		    return FALSE;
	    }

	    $member_query_result = $member_query->get_result();
	    if($tab_id == 1){
		    //    echo "sd";die;
		    ResponseUtility::echoJsonObject($this->queryResultResponseForQaBulkExport($member_query_result,$error));
	    }else{
		    ResponseUtility::echoJsonObject($this->queryResultResponseForBulkExport($member_query_result,$error));

	    }



	    return TRUE;

    }


    private function queryResultResponseForBulkExport($member_query_result,$error)
    {
	    $total_rows = 0;

	    $member_list=[];
	    while ($member_row = $member_query_result->fetch_assoc()) 
	    {
		    // $member_list[]=$this->getMemberRequiredFieldAsArray($member_row);
		    $member_list[]=$member_row;
		    $total_rows = $member_row['totalRows'];
	    }

	    $member_response = new stdClass;
	    $member_response->status=true;
	    $member_response->error=$error;
	    $member_response->totalRows=$total_rows;
	    $member_response->members=$member_list;

	    return $member_response;

    }


    private function queryResultResponseForQaBulkExport($member_query_result,$error){

	    $total_rows = 0;

	    $member_list=[];
	    while ($member_row = $member_query_result->fetch_assoc()) 
	    {
		    // $member_list[]=$this->getMemberRequiredFieldAsArray($member_row);
		    $member_list[]=$member_row;
		    $total_rows = $member_row['totalRows'];
	    }

	    $member_response = new stdClass;
	    $member_response->status=true;
	    $member_response->error=$error;
	    $member_response->totalRows=$total_rows;
	    $member_response->members=$member_list;

	    return $member_response;
    }




    /*
	NAME    : convertToSortMemberSqlQuery
	TYPE    : global Utiltiy function 
	DETAILS : 
	RETURN  : 
     */
    public static function convertToSortMemberSqlQuery($member_table_sql_query)
    {
	    if($member_table_sql_query === FALSE) return FALSE;//not valid query string

	    $scheduler_member_sql_query = "SELECT (COUNT(*) OVER()) as totalRows, member_table.*,
		    client_table.client_name as client_name,
		    admin_table.userUniqueno as admin_id,
		    CONCAT(scheduler_table.firstname ,' ',scheduler_table.lastname) as scheduler_fullname,
		    CASE WHEN member_table.reportStatus in ('Scheduled','Cancellation','Completed','No Show','Rescheduled','Refusal','F2F No Show','Virtual No Show') THEN CONCAT(nurse_table.firstname ,' ', nurse_table.lastname) ELSE NULL END as nurse_fullname,            CONCAT(admin_table.firstname ,' ', admin_table.lastname) as admin_fullname, 
		    CONCAT(qa_table.firstname ,' ', qa_table.lastname) as qa_fullname,
		    CONCAT(coder_table.firstname ,' ', coder_table.lastname) as coder_fullname,

		    member_global_status.return_mail as returnMail
		    FROM 
		    ( $member_table_sql_query ) as member_table 
		    LEFT JOIN userLogin as scheduler_table ON scheduler_table.userUniqueno = member_table.scheduler_id 
		    LEFT JOIN userLogin as nurse_table ON nurse_table.userUniqueno = member_table.nurse_id 
		    LEFT JOIN userLogin as qa_table ON qa_table.userUniqueno = member_table.qa_id 
		    LEFT JOIN userLogin as coder_table ON coder_table.userUniqueno = member_table.coder_id 
		    LEFT JOIN HRA_client as client_table ON client_table.clientId = member_table.client_id 
		    LEFT JOIN userLogin as admin_table ON admin_table.userUniqueno = member_table.admin_idno
		    LEFT JOIN hra_member_global_status AS member_global_status ON member_global_status.member_id = member_table.member_id";

	    return $scheduler_member_sql_query;
    }

    /*
	NAME    : getMembers
	TYPE    : global Utiltiy function 
	DETAILS : get the member details based on tab id
	RETURN  : member details
     */
    public function getMembers($parameters,&$error)
    {
	    //database connection
	    include("../db.php");
	    //custom parameter datas
	    $plan_id = $parameters['planId'];
	    $user_id = $parameters['userId'];
	    $year = $parameters['year'];
	    $min = $parameters['min'];
	    $max = $parameters['max'];

	    $tab_id = $parameters['tabId'];
	    $base_sort_by = $parameters['baseSortBy'];
	    $base_sort_order = $parameters['baseSortOrder']==0?'ASC':'DESC';
	    $sort_by = $parameters['sortBy']; 
	    $sort_order = $parameters['sortOrder']==0?'ASC':'DESC';

	    $start = $min;
	    $offset = $max - $min;

		if($tab_id == 3){
		 $getmemberlists = $this->getmemberslistids($plan_id,$year);
		}

//print_r($getmemberlists);die;
	    //$required_column="member_id,firstname,lastname,nurse_id,scheduler_id,qa_id,coder_id,memberinfo,hraStatus,admin_idno,scheduler,scheduleDate,VisitType,clientid,year,sentToAvility";

	    $combine_member_query = $this -> getQuery($tab_id,$plan_id,$year);
	    if($combine_member_query && is_array($combine_member_query))
	    {
		    $whereCondition = $this->tabConditionNew($tab_id,$getmemberlists);
		    //$searchCondition = $this -> tabConditionSearch($whereCondition,$tab_id,$isSearchApplied,$memberid,$firstname,$lastname);
		    $orderBy =$this->memberSorting($sort_by,$sort_order);
		    $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
		    $sql_global_member_query1 = "select (COUNT(*) OVER()) as totalRows,member_info.* from (". $sql_global_member_query1 . " ) as  member_info  where $whereCondition  $orderBy[0] limit $min,$offset";

	    }
	    //echo $sql_global_member_query1;exit;



	    $memberrecordscount = mysqli_query($conn,$sql_global_member_query1);

	    $final_response = $this -> getFinalResponse($memberrecordscount,$tab_id);
	    echo json_encode($final_response);
	    return TRUE;

    }

	/*
	NAME    : tabCondition
	TYPE    : internal Utiltiy function 
	DETAILS : tab based hra stauts condition
	RETURN  : hra status as string with '_' delimiter
	 */
    private function tabConditionNew($tab_id,$getmemberlists)
    {
	    $whereCondition="";
	    //tab hra status condition
	    switch($tab_id)
	    {
	    case '1': //member list
		    $whereCondition = "(JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::APPOINTMENT_CANCELLED." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::NO_SHOW." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::READY_FOR_QA." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::READY_FOR_CODER." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::CLINICIAN_REVIEW_QA." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::CLINICAIN_REVIEW_CODER." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::READY_FOR_UPLOAD." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::COMPLETED." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::ASSESSMENT_CANCELLED.")";

		    break;

	    case '2': //un assigned
		    $whereCondition = "(JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::READY_FOR_QA." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::READY_FOR_CODER." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::CLINICIAN_REVIEW_QA." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::CLINICAIN_REVIEW_CODER." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::READY_FOR_UPLOAD." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::COMPLETED.")";
		    break;

case '3' :
$whereCondition = "member_info.screeningId is not null";
break;
	    case '5': //un assigned
		    $whereCondition = "member_info.member_id != 'null'";
		    break;
	    case '6': //un assigned
		    //		$whereCondition = "(JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::UTC." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::READY_FOR_QA." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::READY_FOR_CODER." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::CLINICIAN_REVIEW_QA." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::CLINICAIN_REVIEW_CODER." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::READY_FOR_UPLOAD." OR JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus'))=".MemberUtility::COMPLETED.")";
		    $whereCondition = "(JSON_LENGTH (member_info.hraStatus,'$.hraStatus')<=5 or
			    JSON_EXTRACT (member_info.hraStatus,'$.hraStatus')=11 or
			    JSON_EXTRACT (member_info.hraStatus,'$.hraStatus')=12 or
			    JSON_EXTRACT (member_info.hraStatus,'$.hraStatus')=14 or
			    JSON_EXTRACT (member_info.hraStatus,'$.hraStatus')=15 or
			    JSON_EXTRACT (member_info.hraStatus,'$.hraStatus')=16 or
			    JSON_EXTRACT (member_info.hraStatus,'$.hraStatus')=18 or
			    JSON_EXTRACT (member_info.hraStatus,'$.hraStatus')=19 or
			    JSON_EXTRACT (member_info.hraStatus,'$.hraStatus')=20) AND
			    (JSON_LENGTH (member_info.hraStatusHistory,'$.patientRefusal') >= 1 or
			    member_info.refusalLetterDate IS NOT NULL)";
		    break;

	    default:
		    break;

	    }

	    return $whereCondition;
    }

	/*
	NAME    : tabCondition
	TYPE    : internal Utiltiy function 
	DETAILS : tab based hra stauts condition
	RETURN  : hra status as string with '_' delimiter
	 */
   
   private function memberSorting($sort_by, $sort_order)
{
    $sort_text = "";
    $nurse_sort = "";
    switch ($sort_by) {
        case "name" :
            $sort_text = "ORDER BY trim(JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_first_name'))) " . $sort_order;
            break;
        case "lname" :
            $sort_text = "ORDER BY trim(JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Last_name'))) " . $sort_order;
            break;
          case "nursename" :
                $sort_text = "ORDER BY (CASE WHEN u.firstname IS NULL THEN 1 ELSE 0 END), u.firstname " . $sort_order;
                $nurse_sort = "LEFT JOIN userLogin u ON u.userUniqueno=member_info.nurse_id";
                break;
        case "visittype" :
            $sort_text = "ORDER BY (CASE WHEN (VisitType IS NULL OR VisitType = '') THEN 1 ELSE 0 END), VisitType " . $sort_order;
            break;
        case "termdate" :
            $sort_text = "ORDER BY (CASE WHEN (termDate IS NULL or termDate='') THEN 1 ELSE 0 END),termDate " . $sort_order;
            break;
        case "hrastatusbychar" :
            $sort_text = "ORDER BY (CASE
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 20 
        THEN
        'Not Due'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 19 
        THEN
        'NO SHOW'  
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 18 
        THEN
        'TERM EXPIRED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 17 
        THEN
        'OTHER'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 16 
        THEN
        'HOSPICE'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 15 
        THEN
        'DECEASED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 14 
        THEN
        'INELIGIBILE'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 13 
        THEN
        'PRE-SCHEDULED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 12 
        THEN
        'ASSESSMENT CANCEllED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 11 
        THEN
        'COMPLETED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 10 
        THEN
        'READY FOR UPLOAD'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 9 
        THEN
        'CLINICAIN REVIEW CODER'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 8 
        THEN
        'CLINICIAN REVIEW QA'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 7 
        THEN
        'READY FOR CODER'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 6 
        THEN
        'READY FOR QA'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 5 
        THEN
        'UTC'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 4 
        THEN
        'PATIENT REFUSUAL'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 3 
        THEN
        'APPOINTMENT CANCELLED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 2 
        THEN
        'IN PROGRESS'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 1 
        THEN
        'SCHEDULED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 0 
        THEN
        'UNSCHEDULED'    
                   else
        'ZUNSCHEDULED' END
                ) " . $sort_order;
            break;
        case "plan" :
            $sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Plan')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Plan')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Plan')) " . $sort_order;
            break;
        case "program" :
            $sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Program')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Program')) = '') THEN 1 ELSE 0 END), LOWER(JSON_UNQUOTE(JSON_extract(memberinfo, '$.Program'))) " . $sort_order;
            break;
        case "lob" :
            $sort_text = " ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB')) = 'null' OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB')) = '') THEN 1 ELSE 0 END),JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB')) " . $sort_order;
            break;
        case "id" :
            $sort_text = " ORDER BY cast(member_id as unsigned) " . $sort_order;
            break;
        case "overridescheduledate" :
            $sort_text = "ORDER BY (CASE WHEN (overrideScheduledDate IS NULL OR overrideScheduledDate = '') THEN 1 ELSE 0 END), overrideScheduledDate " . $sort_order;
            break;
       case "qaname" :
                $sort_text = "ORDER BY (CASE WHEN (u.firstname IS NULL OR u.firstname = '') THEN 1 ELSE 0 END), u.firstname " . $sort_order;
                $nurse_sort = "LEFT JOIN userLogin as u ON u.userUniqueno=member_info.qa_id";
                break;
            case "codername" :
                $sort_text = "ORDER BY (CASE WHEN (u.firstname IS NULL OR u.firstname = '') THEN 1 ELSE 0 END), u.firstname " . $sort_order;
                $nurse_sort = "LEFT JOIN userLogin as u ON u.userUniqueno=coder_id";
                break;
        case "senttoavility" :
            $sort_text = "ORDER BY (CASE WHEN (sentToAvility IS NULL OR sentToAvility = '') THEN 1 ELSE 0 END), sentToAvility " . $sort_order;
            break;
        case "invoicedate" :
            $sort_text = "ORDER BY (CASE WHEN (invoiceDate IS NULL OR invoiceDate = '') THEN 1 ELSE 0 END), invoiceDate " . $sort_order;
            break;
        case "city" :
            $sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_City')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_City')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_City')) " . $sort_order;
            break;
        case "state" :
            $sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_State')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_State')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_State')) " . $sort_order;
            break;
        case "gender" :
            $sort_text = "ORDER BY (CASE WHEN JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Gender')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Gender')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Gender')) " . $sort_order;
            break;
        case "country" :
            $sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Country')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Country')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Country')) " . $sort_order;
            break;
        case "language" :
            $sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Language')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Language')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Language')) " . $sort_order;
            break;
        case "status" :
            $sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(reportStatus, '$.text')) IS NULL OR JSON_UNQUOTE(JSON_extract(reportStatus, '$.text')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(reportStatus, '$.text')) " . $sort_order;
            break;
        case "qaassigneddate" :
            $qaassigneddate_sort = " ( CASE 
                WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.qaAssigned'))) != 0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,'$.qaAssigned[0].date'))
                    END ) ";
            $sort_text = "ORDER BY (CASE WHEN $qaassigneddate_sort IS NULL THEN 1 ELSE 0 END ) , $qaassigneddate_sort " . $sort_order;
            break;
        case "readyforqadate" :
            $readyforqadate_sort = "( CASE 
                WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.readyForQa'))) !=  0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,'$.readyForQa[0].date'))
                    END )";
            $sort_text = "ORDER BY (CASE WHEN $readyforqadate_sort IS NULL THEN 1 ELSE 0 END ) , $readyforqadate_sort " . $sort_order;
            break;

        case "completeddate" :
            $completeddate_sort = "( CASE 
                WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.completed'))) !=  0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,'$.completed[0].date'))
                    END ) ";
            $sort_text = "ORDER BY (CASE WHEN $completeddate_sort IS NULL THEN 1 ELSE 0 END), $completeddate_sort" . $sort_order;
            break;
        case "coderassigneddate" :
            $coderassigneddate_sort = "( CASE 
                WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.coderAssigned'))) !=  0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,'$.coderAssigned[0].date'))
                    END ) ";
            $sort_text = "ORDER BY  (CASE WHEN $coderassigneddate_sort IS NULL THEN 1 ELSE 0 END), $coderassigneddate_sort " . $sort_order;

            break;
        case "readyforuploaddate" :
            $readyforuploaddate = "( CASE 
                WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.readyForUpload'))) !=  0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,'$.readyForUpload[0].date'))
                    END ) ";
            $sort_text = "ORDER BY (CASE WHEN $readyforuploaddate IS NULL THEN 1 ELSE 0 END), $readyforuploaddate" . $sort_order;

            break;
        case "returnmail" :
            $sort_text = "ORDER BY (CASE WHEN (mgs.return_mail IS NULL OR mgs.return_mail = '') THEN 1 ELSE 0 END), mgs.return_mail " . $sort_order;
            $nurse_sort = "LEFT JOIN hra_member_global_status as mgs ON mgs.member_id = member_id";
            break;
        case "noshow" :
            $sort_text = "ORDER BY (CASE WHEN (noShowInfo IS NULL OR noShowInfo ='null' OR noShowInfo ='') THEN 1 ELSE 0 END),noShowInfo " . $sort_order;
            break;
        case "refusaldate" :
            $sort_text = "ORDER BY (CASE WHEN (refusalDate is NULL OR refusalDate ='null' OR refusalDate ='' OR refusalDate ='N/A') THEN 1 ELSE 0 END), refusalDate ". $sort_order;
            break;
        default:
            break;
    }
    return [$sort_text, $nurse_sort];
}

	private function memberSortingOld($sort_by, $sort_order)
	{
		$sort_text = "";
		$nurse_sort = "";
		switch ($sort_by) {
			case "name" :
				$sort_text = "ORDER BY trim(JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_first_name'))) " . $sort_order;
//                $sort_text = "ORDER BY JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_first_name')) " . $sort_order;
				break;
			case "lname" :
				$sort_text = "ORDER BY trim(JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Last_name'))) " . $sort_order;
//                $sort_text = "ORDER BY JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_first_name')) " . $sort_order;
//                $sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Last_name')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Last_name')) = '') THEN 1 ELSE 0 END), (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Last_name'))  " . $sort_order;
//                $sort_text = "ORDER BY (CASE WHEN (JSON_extract(memberinfo, '$.Member_Last_name')) IS NULL THEN 1 ELSE 0 END), (JSON_extract(memberinfo, '$.Member_Last_name'))  " . $sort_order;
//                $sort_text = "ORDER BY lastname " . $sort_order;
				break;
			case "nursename" :
				$sort_text = "ORDER BY (CASE WHEN (u.firstname IS NULL OR u.firstname = '') THEN 1 ELSE 0 END), u.firstname " . $sort_order;
				$nurse_sort = "LEFT JOIN userLogin u ON u.userUniqueno=nurse_id";
				break;
			case "visittype" :
				$sort_text = "ORDER BY (CASE WHEN (VisitType IS NULL OR VisitType = '') THEN 1 ELSE 0 END), VisitType " . $sort_order;
				break;
			case "termdate" :
				$sort_text = "ORDER BY (CASE WHEN (termDate IS NULL or termDate='') THEN 1 ELSE 0 END),termDate " . $sort_order;
				break;
			case "hrastatusbychar" :
//                $sort_text = "ORDER BY JSON_UNQUOTE(JSON_extract(hraStatus, '$.hraStatus')) " . $sort_order;
//                $sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(hraStatus, '$.hraStatus')) IS NULL OR JSON_UNQUOTE(JSON_extract(hraStatus, '$.hraStatus'))='') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(hraStatus, '$.hraStatus')) " . $sort_order;
				$sort_text = "ORDER BY (CASE
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 20 
        THEN
        'Not Due'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 19 
        THEN
        'NO SHOW'  
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 18 
        THEN
        'TERM EXPIRED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 17 
        THEN
        'OTHER'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 16 
        THEN
        'HOSPICE'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 15 
        THEN
        'DECEASED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 14 
        THEN
        'INELIGIBILE'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 13 
        THEN
        'PRE-SCHEDULED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 12 
        THEN
        'ASSESSMENT CANCEllED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 11 
        THEN
        'COMPLETED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 10 
        THEN
        'READY FOR UPLOAD'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 9 
        THEN
        'CLINICAIN REVIEW CODER'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 8 
        THEN
        'CLINICIAN REVIEW QA'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 7 
        THEN
        'READY FOR CODER'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 6 
        THEN
        'READY FOR QA'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 5 
        THEN
        'UTC'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 4 
        THEN
        'PATIENT REFUSUAL'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 3 
        THEN
        'APPOINTMENT CANCELLED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 2 
        THEN
        'IN PROGRESS'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 1 
        THEN
        'SCHEDULED'
        WHEN
        JSON_UNQUOTE(JSON_EXTRACT(hraStatus, '$.hraStatus')) = 0 
        THEN
        'UNSCHEDULED'    
                   else
        'ZUNSCHEDULED' END
                ) " . $sort_order;
				break;
			case "plan" :
				$sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Plan')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Plan')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Plan')) " . $sort_order;
				break;
			case "program" :
				$sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Program')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Program')) = '') THEN 1 ELSE 0 END), LOWER(JSON_UNQUOTE(JSON_extract(memberinfo, '$.Program'))) " . $sort_order;
				break;
			case "lob" :
				$sort_text = " ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB')) = 'null' OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB')) = '') THEN 1 ELSE 0 END),JSON_UNQUOTE(JSON_extract(memberinfo, '$.LOB')) " . $sort_order;

				break;
			case "id" :
				$sort_text = " ORDER BY cast(member_id as unsigned) " . $sort_order;
				break;
			case "overridescheduledate" :
//                $sort_text = "ORDER BY overrideScheduledDate " . $sort_order;
//                $sort_text = "ORDER BY (CASE WHEN (overrideScheduledDate IS NULL OR overrideScheduledDate = 'null'OR overrideScheduledDate = '') THEN 1 ELSE 0 END), overrideScheduledDate " . $sort_order;
				$scheduled_sort_text = " (
                CASE
                    WHEN EvaluationDate IS NOT NULL AND scheduleDate IS NOT NULL THEN STR_TO_DATE(EvaluationDate, '%Y-%m-%d')
                    ELSE STR_TO_DATE(scheduleDate, '%Y-%m-%d')
                END ) ";
				$sort_text = "ORDER BY (CASE WHEN $scheduled_sort_text IS NULL THEN 1 ELSE 0 END ) , $scheduled_sort_text " . $sort_order;
				break;
//            case "hrastatusbychar" :
//                $sort_text = "ORDER BY (CASE WHEN JSON_UNQUOTE(JSON_extract(hraStatus, '$.hraStatus')) IS NULL THEN 1 ELSE 0 END),JSON_UNQUOTE(JSON_extract(hraStatus, '$.hraStatus')) " . $sort_order;
//                break;
//            case "city" :
//                $sort_text = "ORDER BY (CASE WHEN JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_City')) IS NULL THEN 1 ELSE 0 END),JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_City')) " . $sort_order;
//                break;
//            case "state" :
//                $sort_text = "ORDER BY (CASE WHEN JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_State')) IS NULL THEN 1 ELSE 0 END),JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_State')) " . $sort_order;
//                break;
//            case "gender" :
//                $sort_text = "ORDER BY (CASE WHEN JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Gender')) IS NULL THEN 1 ELSE 0 END),JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Gender')) " . $sort_order;
//                break;
			case "qaname" :
				$sort_text = "ORDER BY (CASE WHEN (u.firstname IS NULL OR u.firstname = '') THEN 1 ELSE 0 END), u.firstname " . $sort_order;
				$nurse_sort = "LEFT JOIN userLogin as u ON u.userUniqueno = qa_id";
				break;
			case "codername" :
				$sort_text = "ORDER BY (CASE WHEN u.firstname IS NULL OR u.firstname = '') THEN 1 ELSE 0 END), u.firstname " . $sort_order;
				$nurse_sort = "LEFT JOIN userLogin as u ON u.userUniqueno = coder_id";
				break;
			case "senttoavility" :
				$sort_text = "ORDER BY (CASE WHEN (sentToAvility IS NULL OR sentToAvility = '') THEN 1 ELSE 0 END), sentToAvility " . $sort_order;
				break;
			case "invoicedate" :
				$sort_text = "ORDER BY (CASE WHEN (invoiceDate IS NULL OR invoiceDate = '') THEN 1 ELSE 0 END), invoiceDate " . $sort_order;
				break;


			case "city" :
				//$sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_City')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_City')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_City)) " . $sort_order;
				$sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_City')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_City')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_City')) " . $sort_order;

				// $sort_text = "ORDER BY (CASE WHEN JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_City')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_City')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_City')) " . $sort_order;
				break;
			case "state" :
				$sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_State')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_State')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_State')) " . $sort_order;

				// $sort_text = "ORDER BY (CASE WHEN JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_State')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_State')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_State')) " . $sort_order;
				break;
			case "gender" :
				$sort_text = "ORDER BY (CASE WHEN JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Gender')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Gender')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Gender')) " . $sort_order;
				break;
			case "country" :
				$sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Country')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Country')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Country')) " . $sort_order;

				// $sort_text = "ORDER BY (CASE WHEN JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_State')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_State')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_State')) " . $sort_order;
				break;
			case "language" :
				$sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Language')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Language')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Language')) " . $sort_order;

				// $sort_text = "ORDER BY (CASE WHEN JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_State')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_State')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_State')) " . $sort_order;
				break;
//            case "refusaldate" :
////                $sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Country')) IS NULL OR JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Country')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(memberinfo, '$.Member_Country')) " . $sort_order;
//
//                $sort_text = "ORDER BY (CASE WHEN (refusalDate IS NULL OR refusalDate = '') THEN 1 ELSE 0 END), refusalDate " . $sort_order;
//                break;
			case "status" :
				$sort_text = "ORDER BY (CASE WHEN (JSON_UNQUOTE(JSON_extract(reportStatus, '$.text')) IS NULL OR JSON_UNQUOTE(JSON_extract(reportStatus, '$.text')) = '') THEN 1 ELSE 0 END), JSON_UNQUOTE(JSON_extract(reportStatus, '$.text')) " . $sort_order;

				// $sort_text = "ORDER BY (CASE WHEN (refusalDate IS NULL OR refusalDate = '') THEN 1 ELSE 0 END), refusalDate " . $sort_order;
				break;


			case "qaassigneddate" :
				$qaassigneddate_sort = " ( CASE 
                WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.qaAssigned'))) <> 0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,'$.qaAssigned[0].date'))
                    END ) ";
				$sort_text = "ORDER BY (CASE WHEN $qaassigneddate_sort IS NULL THEN 1 ELSE 0 END ) , $qaassigneddate_sort " . $sort_order;
				break;

			case "readyforqadate" :
				$readyforqadate_sort = "( CASE 
                WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.readyForQa'))) <> 0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,'$.readyForQa[0].date'))
                    END )";
				$sort_text = "ORDER BY (CASE WHEN $readyforqadate_sort IS NULL THEN 1 ELSE 0 END ) , $readyforqadate_sort " . $sort_order;
				break;

			case "completeddate" :
				$completeddate_sort = "( CASE 
                WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.completed'))) <> 0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,'$.completed[0].date'))
                    END ) ";
				$sort_text = "ORDER BY (CASE WHEN $completeddate_sort IS NULL THEN 1 ELSE 0 END), $completeddate_sort" . $sort_order;
				break;

			case "coderassigneddate" :
				$coderassigneddate_sort = "( CASE 
                WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.coderAssigned'))) <> 0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,'$.coderAssigned[0].date'))
                    END ) ";
				$sort_text = "ORDER BY  (CASE WHEN $coderassigneddate_sort IS NULL THEN 1 ELSE 0 END), $coderassigneddate_sort " . $sort_order;

				break;

			case "readyforuploaddate" :
				$readyforuploaddate = "( CASE 
                WHEN JSON_LENGTH(JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory, '$.readyForUpload'))) <> 0 THEN JSON_UNQUOTE(JSON_EXTRACT(hraStatusHistory,'$.readyForUpload[0].date'))
                    END ) ";
				$sort_text = "ORDER BY (CASE WHEN $readyforuploaddate IS NULL THEN 1 ELSE 0 END), $readyforuploaddate" . $sort_order;

				break;

			case "returnmail" :
				//$sort_text = "ORDER BY (CASE WHEN mgs.return_mail IS NULL OR mgs.return_mail = '') THEN 1 ELSE 0 END), mgs.return_mail " . $sort_order;
				//$nurse_sort = "LEFT JOIN hra_member_global_status as mgs ON mgs.member_id = member_id";

				$sort_text = "(CASE WHEN  member_global_status.return_mail IS NULL THEN 1 ELSE 0 END), member_global_status.return_mail ". $sort_order;
				break;

			case "noshow" :
				$sort_text = "(CASE WHEN noShowInfo IS NULL OR noShowInfo ='' THEN 1 ELSE 0 END),noShowInfo " . $sort_order;

				break;

			case "refusaldate" :
				$sort_text = "ORDER BY (CASE WHEN refusalDate is NULL THEN 1 ELSE 0 END), refusalDate ". $sort_order;
				break;
			default:
				break;
		}
		return [$sort_text, $nurse_sort];
	}




    /*
	NAME    : tabConditionSearch
	TYPE    : internal Utiltiy function 
	DETAILS : tab based hra stauts condition
	RETURN  : hra status as string with '_' delimiter
     */
    private function tabConditionSearch($whereCondition,$tab_id,$isSearchApplied=FALSE,$id='',$firstname='',$lastname=''){
	    $search_condtion = "";
	    //echo $isSearchApplied;
	    if($isSearchApplied == "true"){
		    if($id != ''){
			    //$search_condtion = $whereCondition. " AND member_id LIKE '%$id%'";
			    $search_condtion = $whereCondition. " AND member_id = '$id'";
		    }elseif($firstname != ''){
			    $search_condtion = $whereCondition. " AND firstname LIKE '%$firstname%'";
		    }elseif($lastname !=''){
			    $search_condtion = $whereCondition. " AND lastname LIKE '%$lastname%'";
		    }else{
			    $search_condtion = $whereCondition;
		    }
	    }else{
		    $search_condtion = $whereCondition;
	    }
	    //echo $search_condtion;exit;

	    return $search_condtion;
    }

    private function filterCondition($tab_id,$filter_parameters){
        $scheduledFrom = $filter_parameters['scheduledFrom'];
        $scheduledTo = $filter_parameter['scheduledTo'];

        $refusalFrom = $filter_parameters['refusalFrom'];
        $refusalTo = $filter_parameters['refusalTo'];

        $clientId = $filter_parameters['clientId'];
        $program = $filter_parameters['program'];
        $lob =$filter_parameters['lob'];
        //$city = $filter_parameters['city'];
        $hraStatus = $filter_parameters['hraStatus'];
        $visitType = $filter_parameters['visitType'];
        //$qaIds = $filter_parameters['qaIds'];
        //$coderIds = $filter_parameters['coderIds'];
        $nurseIds = $filter_parameters['nurseIds'];
        //$status = $filter_parameters['status'];
        //$schedulerIds = $filter_parameters['schedulerIds'];  

        $filterCondition = '';
        if($clientId != ''){
            $filterCondition = " AND clientid IN ('".str_replace("|","','",$clientId)."')";
        }
        if($lob != ''){
            $filterCondition .= " AND UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.LOB')))) IN ('".str_replace("_","','",$lob)."')";
        }
        if($hraStatus != ''){
            $filterCondition .= " AND UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(hraStatus,'$.hraStatus')))) IN ('".str_replace("_","','",$hraStatus)."')";
        }

        if($visitType != ''){
            $filterCondition .= " AND VisitType IN ('".str_replace("_","','",$visitType)."')";
        }

        if($nurseIds != ''){
            $filterCondition .= " AND nurse_id IN ('".str_replace("_","','",$nurseIds)."')";
        }

        if($scheduledFrom != ''){
            $filterCondition .= " AND ".GlobalQueryBuilder::whereClauseScheduleDateBetweenPerformance($filter_parameters);
        }

        if($refusalFrom != ''){
            $filterCondition .= " AND ".GlobalQueryBuilder::whereClauseRefusalDateBetweenPerformance($filter_parameters);
        }

        //echo $filterCondition;exit;
        return $filterCondition;
    }
    /*
	NAME    : tabHraCondition
	TYPE    : internal Utiltiy function 
	DETAILS : hra sttaus condition based on  tab id
	RETURN  : hra status array list
     */
    private function tabHraCondition($tab_id)
    {
	    $nurse_hralist['hraStatus'] = null;
	    //tab hra status condition

	    switch($tab_id)
	    {
	    case '1':
		    $nurse_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
			    [
				    MemberUtility::APPOINTMENT_CANCELLED,
				    MemberUtility::NO_SHOW,
				    MemberUtility::READY_FOR_QA,
				    MemberUtility::READY_FOR_CODER,
				    MemberUtility::CLINICIAN_REVIEW_QA,
				    MemberUtility::CLINICAIN_REVIEW_CODER,
				    MemberUtility::READY_FOR_UPLOAD,
				    MemberUtility::COMPLETED,
				    MemberUtility::ASSESSMENT_CANCELLED
			    ],'_');
		    break;

	    case '2':
		    $nurse_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
			    [
				    // MemberUtility::APPOINTMENT_CANCELLED,
				    // MemberUtility::NO_SHOW,
				    MemberUtility::READY_FOR_QA,
				    MemberUtility::READY_FOR_CODER,
				    MemberUtility::CLINICIAN_REVIEW_QA,
				    MemberUtility::CLINICAIN_REVIEW_CODER,
				    MemberUtility::READY_FOR_UPLOAD,
				    MemberUtility::COMPLETED
				    //MemberUtility::ASSESSMENT_CANCELLED
			    ],'_');
		    break;

	    case '3':
		    $nurse_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
			    [
				    MemberUtility::PATIENT_REFUSAL,
				    MemberUtility::UTC,
				    MemberUtility::READY_FOR_QA,
				    MemberUtility::READY_FOR_CODER,
				    MemberUtility::APPOINTMENT_CANCELLED,
				    MemberUtility::READY_FOR_UPLOAD,
				    MemberUtility::COMPLETED,
				    MemberUtility::ASSESSMENT_CANCELLED,
				    MemberUtility::IN_ELIGIBILE,
				    MemberUtility::DECEASED,
				    MemberUtility::HOSPICE,
				    MemberUtility::OTHER,
				    MemberUtility::TERM_EXPIRED,
				    MemberUtility::NO_SHOW

			    ],'_');    
		    break;

	    case '4':
		    $nurse_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
			    [
				    MemberUtility::CLINICIAN_REVIEW_QA,
				    MemberUtility::CLINICAIN_REVIEW_CODER
			    ],'_');    
		    break;
	    case '5':
		    $nurse_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
			    [
				    MemberUtility::UNSCHEDULED,
				    MemberUtility::SCHEDULED,
				    MemberUtility::IN_PROGRESS,
				    MemberUtility::APPOINTMENT_CANCELLED,
				    MemberUtility::PATIENT_REFUSAL,
				    MemberUtility::UTC,
				    MemberUtility::READY_FOR_QA,
				    MemberUtility::READY_FOR_CODER,
				    MemberUtility::CLINICIAN_REVIEW_QA,
				    MemberUtility::CLINICAIN_REVIEW_CODER,
				    MemberUtility::READY_FOR_UPLOAD,
				    MemberUtility::COMPLETED,
				    MemberUtility::ASSESSMENT_CANCELLED,
				    MemberUtility::PRE_SCHEDULED,
				    MemberUtility::IN_ELIGIBILE,
				    MemberUtility::DECEASED,
				    MemberUtility::HOSPICE,
				    MemberUtility::OTHER,
				    MemberUtility::TERM_EXPIRED,
				    MemberUtility::NO_SHOW,
				    MemberUtility::HRA_NOT_DUE
			    ],'_');
		    break;
	    case '6':
		    $nurse_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
			    [
				    MemberUtility::UTC,
				    MemberUtility::READY_FOR_QA,
				    MemberUtility::READY_FOR_CODER,
				    MemberUtility::CLINICIAN_REVIEW_QA,
				    MemberUtility::CLINICAIN_REVIEW_CODER,
				    MemberUtility::READY_FOR_UPLOAD,
				    MemberUtility::COMPLETED
			    ],'_');
		    break;

	    default:
		    $nurse_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
			    [
				    MemberUtility::UNSCHEDULED,
				    MemberUtility::SCHEDULED
			    ],'_');
	    }

	    return $nurse_hralist;

    }


}


?>

