<?php
      ini_set('memory_limit','-1');
ini_set('max_execution_time', 300);

/*
	REPORT GLOBAL MEMBER API CLASS
	Created On : 
*/

//other include files
require_once("../global/GlobalQueryBuilder.php");
require_once("../member/MemberUtility.php");
require_once("../utility/ArrayUtility.php");
require_once("../utility/StringUtility.php");
require_once("../auth/UserUtility.php");
require_once("../utility/JwtUtility.php");
require_once("../utility/ResponseUtility.php");
require_once("../TimeZone.php");
require_once("../member/HraFileChanges.php");

class ReportGlobalMembers
{

    /*
        NAME    : getNurseRequiredColumnAsString
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function getNurseRequiredColumnAsString($tabId='None')
    {
        $sql_demograhic_string = GlobalQueryBuilder::sqlCustomColumnDemographic();

         $required_column_array[] = GlobalQueryBuilder::sqlCustomColumnpcpfname();
         $required_column_array[] = GlobalQueryBuilder::sqlCustomColumnpcplname();
	 $required_column_array[]=GlobalQueryBuilder::sqlCustomColumn('customone');

        $required_column_array[]="member_id,firstname,lastname,nurse_id,scheduler_id,qa_id,coder_id,
                                memberinfo,hraStatus,hraStatusHistory,sentToAvility,cancelHistory,refusalLetterDate,invoiceDate,admin_idno,hraFileUpdatedHistory,termDate,query_form,
                                scheduleDate,STR_TO_DATE(scheduleDate, '%Y-%m-%d') as shortscheduleDate,EvaluationDate,schedulerCallHraStatus,schedulerCallLogDetails,VisitType,schedulerDetails,importTrackerDetails,schedulerCallOrder,reportNotes,scheduler";                   
        $required_column_array[]=$sql_demograhic_string;
        //custom member info field for sorting 
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Plan','memberPlan');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Program','memberProgram');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('LOB','memberLob');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_City','memberCity');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Zip_Code','memberZip');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_first_name','memberFirstName');
		$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Last_name','memberLastName');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_State','memberState');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Country','memberCountry');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Language','memberLanguage');

//added by nandini on 11thjan22 start
		$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Gender','memberGender');
		$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Qa_Assigned_Date','qaAssignedDate');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Coder_Assigned_Date','coderAssignedDate');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Ready_For_Upload_Date','readyforuploadDate');
$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Ready_For_Qa_Date','readyforqaDate');

       
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Completed_Date','completedDate');
       
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Pcp_State','pcp_state');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Pcp_City','Pcp_City');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Pcp_Name','Pcp_Name');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Pphy','Pphy');

       
//added by nandini on 11thjan22 end

        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Term_Date','memberTermDate');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_sent_To_Avility','membersentToAvility');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_refusal_Letter_Date','memberrefusalLetterDate');
       
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Completed_Date','memberCompletedDate');
        
        
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Invoice_Date','memberInvoiceDate');
        
        
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_qa_name','memberQaName');
        
       
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Coder_name','memberCoderName');
		
        $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnScreening();
       // $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedScheduledDate();
 //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedShortScheduledDate();

if($tab_id==5){
            $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnSortOverridedScheduledDate();
            $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnSortOverridedShortScheduledDate();
        }else{
            $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedScheduledDate();
            $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedShortScheduledDate();
        }


$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnRefusalDate('refusalDate');
$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnnoshow('noShowInfo');
$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReportStatusbychar('hrastatusbychar');
		$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReportStatus('reportStatus');
//addded by eswar for sorting in qa and summary tab

$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReadyForQa('readyForQa');
 $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnQaAssignedDate('qaAssignedDatee');
$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnCoderAssignedDate('coderassigneddatee');



 $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnCompletedDate('completeddatee');
 $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReadyForUploadDate('readyforuploaddatee');
 
 //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnCompleted('completed');



        //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnSimpleJsonExtract('reportStatus','text','reportStatus');
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReportStatus('reportStatus');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnHraStatusHistoryDays(0,'hra_days');
        return ArrayUtility::joinArrayByDelimiter($required_column_array,',');
    }

    
    /*
        NAME    : getNurseRequiredColumnAsString
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function convertToDefaultMemberSqlQuery($member_table_sql_query)
	{
            if($member_table_sql_query === FALSE) return FALSE;//not valid query string

			$scheduler_member_sql_query = "SELECT (COUNT(*) OVER()) as totalRows, member_table.*,
            client_table.client_name as client_name,
            admin_table.userUniqueno as admin_id,
            CONCAT(scheduler_table.firstname ,' ',scheduler_table.lastname) as scheduler_fullname,
            CONCAT(nurse_table.firstname ,' ', nurse_table.lastname) as nurse_fullname,
            CONCAT(admin_table.firstname ,' ', admin_table.lastname) as admin_fullname, 
            CONCAT(qa_table.firstname ,' ', qa_table.lastname) as qa_fullname,
            CONCAT(coder_table.firstname ,' ', coder_table.lastname) as coder_fullname,
            
            member_global_status.return_mail as returnMail
            FROM 
				( $member_table_sql_query ) as member_table 
				LEFT JOIN userLogin as scheduler_table ON scheduler_table.userUniqueno = member_table.scheduler_id 
				LEFT JOIN userLogin as nurse_table ON nurse_table.userUniqueno = member_table.nurse_id 
                LEFT JOIN userLogin as qa_table ON qa_table.userUniqueno = member_table.qa_id 
                LEFT JOIN userLogin as coder_table ON coder_table.userUniqueno = member_table.coder_id 
				LEFT JOIN HRA_client as client_table ON client_table.clientId = member_table.client_id 
				LEFT JOIN userLogin as admin_table ON admin_table.userUniqueno = member_table.admin_idno
                LEFT JOIN hra_member_global_status AS member_global_status ON member_global_status.member_id = member_table.member_id";

			return $scheduler_member_sql_query;
	}
    /*
        NAME    : getMemberRequiredFieldAsArray
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */

private function getsecondlineiteminfo($hra_status1,$cancel_history){
   
    $hra_statusinfo = json_decode($hra_status1,true);
   $hra_status = $hra_statusinfo['hraStatus'];

      if($hra_status == 6 || $hra_status ==7 || $hra_status ==8 || $hra_status == 9 || $hra_status == 10 || $hra_status == 11|| $hra_status == 12){

if($cancel_history != null){

    $array = json_decode($cancel_history,true);

    if($array['appointmentCancelled'] != null && ( $array['noShow'] == null)){

        return "appointmentcancelled";
    }

    else if($array['appointmentCancelled'] == null && ( $array['noShow'] != null)){ 
        return "noshow";

    }

    else if( $array['noShow'] != null && $array['appointmentCancelled'] != null )
{
  $noshowcount =   count($array['noShow']);
  $noshowcount1 = $noshowcount - 1;
  $appointmentCancelledcount =   count($array['appointmentCancelled']);
  $appointmentCancelledcount1 = $appointmentCancelledcount - 1;

$noshowmaxdate =  $array['noShow'][$noshowcount1]['date'];
 $appointmentCancelledmaxdate = $array['appointmentCancelled'][$appointmentCancelledcount1]['date'];

if ($noshowmaxdate > $appointmentCancelledmaxdate)
        return "noshow";
	
else
return "appointmentcancelled";


}


else{
    
    return "";
    }
}

}
else if($hra_status ==19)
{
    $array = json_decode($cancel_history,true);
    
        if($array['appointmentCancelled'] != null) {
            return "appointmentcancelled";
}



}
else if($hra_status == 3){
    $array = json_decode($cancel_history,true);

 if($array['noShow'] != null) 
{
    return "noshow";
	

}



}


else{
    return "";

}

      }

    private function getMemberRequiredFieldAsArrayforqa($member_row){
      //  echo "sm";die;
        $member_id = $member_row['member_id'];
        $memberinfo = $member_row['memberinfo'];
        $demographic = $member_row['Demographic'];
        
        $override_scheduled_date = $member_row['overrideScheduledDate'];
        $scheduled_date = $member_row['scheduleDate'];
        $term_date = $member_row['termDate'];
        $evaluation_date = $member_row['EvaluationDate'];
       
        $hra_status = $member_row['hraStatus'];
        $scheduler_status=$member_row['reportStatus'];
        $visit_type = $member_row['VisitType'];
        $cancel_history = $member_row['cancelHistory'];
        $secondlineitemvalue = $this->getsecondlineiteminfo($hra_status,$cancel_history);

        $admin_id = $member_row['admin_id'];
        $nurse_id = $member_row['nurse_id'];
        $qa_id = $member_row['qa_id'];
        $coder_id = $member_row['coder_id'];
        $scheduler_id = $member_row['scheduler_id'];
        $hra_status_history = $member_row['hraStatusHistory'];
        $sentToAvility = $member_row['sentToAvility'];
        $invoiceDate= $member_row['invoiceDate'];
        $nurse_name = StringUtility::toEmptyStringIfNull($member_row['nurse_fullname']);
        $scheduler_name = StringUtility::toEmptyStringIfNull($member_row['scheduler_fullname']);
        $admin_name = StringUtility::toEmptyStringIfNull($member_row['admin_fullname']);
        $qa_fullname = StringUtility::toEmptyStringIfNull($member_row['qa_fullname']);
        $coder_fullname = StringUtility::toEmptyStringIfNull($member_row['coder_fullname']);
        $scheduler_fullname = StringUtility::toEmptyStringIfNull($member_row['scheduler_fullname']);
        $return_mail = StringUtility::toEmptyStringIfNull($member_row['returnMail']);

        $client_id = $member_row['client_id'];
        $client_name = $member_row['client_name'];
        $client_year = $member_row['client_year'];

        $query_form = $member_row['query_form'];

        $refusalDate = $member_row['refusalDate'];
        $noShowInfo = $member_row['noShowInfo'];
       
        
        //conver the query review count to ordinal suffix if number
        if(isset($member_row['query_form_review_count']))
        {
            $query_form_review_status = GlobalHelper::queryReviewCountToReadableFormat($member_row['query_form_review_count']);
        }
        else
        {
            $query_form_review_status= $query_form_review_status=GlobalHelper::queryReviewCountToReadableFormat(null);
        }
       
        $hra_days = StringUtility::toEmptyStringIfNull($member_row['hra_days']);
        $import_tracker_details = json_decode($member_row['importTrackerDetails'],true);
        $notes = $member_row['reportNotes'];
        $refusal_letter_date  = $member_row['refusalLetterDate'];
        $report_status  = $member_row['reportStatus'];
        $scheduler = $member_row['scheduler'];
        $scheduler_call_order = json_decode($member_row['schedulerCallOrder'],true);
        $scheduler_details = $member_row['schedulerDetails'];
        $schedule_hra_status = $member_row['schedulerCallHraStatus'];
        $schedule_call_log_details= $member_row['schedulerCallLogDetails'];
	

       $result_hra_status_result=MemberUtility::OnApiEvent($client_id,$client_year,$member_id,MemberUtility::API_SCHEDULED_DATE,true,null);

        $scheduler_call_response = MemberUtility::getMemberCallResponse($hra_status,$scheduler_id,$scheduler,
                $scheduler_details,$schedule_hra_status,$schedule_call_log_details);

        $response_array=array(
                                "memberId"=>$member_id,
                                "nurseId"=>$nurse_id,
                                "adminId"=>$admin_id,
                                "schedulerId"=>$scheduler_id,
                                "qaId"=>$qa_id,
                                "coderId"=>$coder_id,
                                "refusalDate"=>$refusalDate,
                                "noShowInfo"=>$noShowInfo,

                                "nurseName"=>$nurse_name,
                                "schedulerName"=>$scheduler_name,
                                "qaName" => $qa_fullname,
                                "coderName" => $coder_fullname,
                                "adminName"=>$admin_name,
                                "sentToAvility"=>$sentToAvility,
                                "invoiceDate"=>$invoiceDate,
                                "memberinfo"=>$memberinfo,
                                "demographic"=>$demographic,
                                "hraStatusHistory"=>$hra_status_history,
                                "scheduleDate"=>$scheduled_date,
                                //some case evalution date consider as scheduled date
                                "overrideScheduleDate"=>$override_scheduled_date,
                                "termDate"=>$term_date,
                                "evaluationDate" => $evaluation_date,

                                "hraStatus"=>$hra_status,
                                "hraDays"=>$hra_days,
                                "queryReviewStatus"=>$query_form_review_status,
                                "schedulerStatus"=>$scheduler_status,
                                "visitType"=>$visit_type,

                                "clientId"=>$client_id,
                                "clientName"=>$client_name,
                                "clientYear"=>$client_year,
								"cancelHistory"=>$cancel_history,

                                "queryForm"=>$query_form,
                                "importTrackerDetails"=>$import_tracker_details,
                                "reportNotes"=>$notes,
                                "refusalLetterDate"=>$refusal_letter_date,
                                "reportStatus"=>$report_status,
                                "scheduler"=>$scheduler,
                                "schedulerCallOrder"=>$scheduler_call_order,
                                "schedulerCallResponse"=>$scheduler_call_response,
                                "schedulerFullName"=>$scheduler_fullname,
                                "returnMail"=>$return_mail,
                                "schedulerHraStatus"=>$result_hra_status_result,
                                "secondlineitemvalue" => $secondlineitemvalue
                            );

        return $response_array;

    }


    private function getMemberRequiredFieldAsArray($member_row)
	{
		$hra_file_change = new HraFileChangesUtility;
        $hra_file_updated_history = $member_row['hraFileUpdatedHistory'];
        $member_id = $member_row['member_id'];
        $memberinfo = $member_row['memberinfo'];
        $demographic = $member_row['Demographic'];
        
        $override_scheduled_date = $member_row['overrideScheduledDate'];
        $scheduled_date = $member_row['scheduleDate'];
        $term_date = $member_row['termDate'];
		$sentToAvitity = $member_row['sentToAvility'];
        $refusalDate = $member_row['refusalDate'];
$noShowInfo = $member_row['noShowInfo'];
        $evaluation_date = $member_row['EvaluationDate'];

$memberFirstName = $member_row['memberFirstName'];
$memberLastName = $member_row['memberLastName'];

        $pcpfname = $member_row['pcpfname'];
        $pcplname = $member_row['pcplname'];

       
        $hra_status = $member_row['hraStatus'];
        $scheduler_status=$member_row['reportStatus'];
        $visit_type = $member_row['VisitType'];

        $admin_id = $member_row['admin_id'];
        $nurse_id = $member_row['nurse_id'];
        $qa_id = $member_row['qa_id'];
        $coder_id = $member_row['coder_id'];
        $scheduler_id = $member_row['scheduler_id'];
        $hra_status_history = $member_row['hraStatusHistory'];
        $sentToAvility = $member_row['sentToAvility'];
        $invoiceDate= $member_row['invoiceDate'];
        $nurse_name = StringUtility::toEmptyStringIfNull($member_row['nurse_fullname']);
        $scheduler_name = StringUtility::toEmptyStringIfNull($member_row['scheduler_fullname']);
        $admin_name = StringUtility::toEmptyStringIfNull($member_row['admin_fullname']);
        $qa_fullname = StringUtility::toEmptyStringIfNull($member_row['qa_fullname']);
        $coder_fullname = StringUtility::toEmptyStringIfNull($member_row['coder_fullname']);
        $scheduler_fullname = StringUtility::toEmptyStringIfNull($member_row['scheduler_fullname']);
        $return_mail = StringUtility::toEmptyStringIfNull($member_row['returnMail']);

        $client_id = $member_row['client_id'];
        $client_name = $member_row['client_name'];
        $client_year = $member_row['client_year'];

        $query_form = $member_row['query_form'];
        
        //conver the query review count to ordinal suffix if number
        if(isset($member_row['query_form_review_count']))
        {
            $query_form_review_status = GlobalHelper::queryReviewCountToReadableFormat($member_row['query_form_review_count']);
        }
        else
        {
            $query_form_review_status= $query_form_review_status=GlobalHelper::queryReviewCountToReadableFormat(null);
        }
       
        $hra_days = StringUtility::toEmptyStringIfNull($member_row['hra_days']);
        $import_tracker_details = json_decode($member_row['importTrackerDetails'],true);
        $notes = $member_row['reportNotes'];
        $refusal_letter_date  = $member_row['refusalLetterDate'];
        $report_status  = $member_row['reportStatus'];
        $scheduler = $member_row['scheduler'];
        $scheduler_call_order = json_decode($member_row['schedulerCallOrder'],true);
        $scheduler_details = $member_row['schedulerDetails'];
        $schedule_hra_status = $member_row['schedulerCallHraStatus'];
        $schedule_call_log_details= $member_row['schedulerCallLogDetails'];
		$cancel_history = $member_row['cancelHistory'];

       $result_hra_status_result=MemberUtility::OnApiEvent($client_id,$client_year,$member_id,MemberUtility::API_SCHEDULED_DATE,true,null);

$screen_updated_array = $hra_file_change->getComponentChangedStatus($hra_file_updated_history,"screening");
        if($screen_updated_array)
        {
            if($screen_updated_array["status"]==true)
            $screening = $screen_updated_array;
        }
        $scheduler_call_response = MemberUtility::getMemberCallResponse($hra_status,$scheduler_id,$scheduler,
                $scheduler_details,$schedule_hra_status,$schedule_call_log_details);

        $response_array=array(
                                "memberId"=>$member_id,
                                "memberFirstName"=>$memberFirstName,
                                "memberLastName"=>$memberLastName,
                                "pcpfname"=>$pcpfname,
                                "pcplname"=>$pcplname,
                                "nurseId"=>$nurse_id,
                                "adminId"=>$admin_id,
                                "schedulerId"=>$scheduler_id,
                                "qaId"=>$qa_id,
                                "coderId"=>$coder_id,
 "noShowInfo"=>$noShowInfo,
                                "nurseName"=>$nurse_name,
                                "schedulerName"=>$scheduler_name,
                                "qaName" => $qa_fullname,
                                "coderName" => $coder_fullname,
                                "adminName"=>$admin_name,
                                "invoiceDate"=>$invoiceDate,
                                "memberinfo"=>$memberinfo,
                                "demographic"=>$demographic,
                                "hraStatusHistory"=>$hra_status_history,
                                "scheduleDate"=>$scheduled_date,
                                //some case evalution date consider as scheduled date
                                "overrideScheduleDate"=>$override_scheduled_date,
                                "termDate"=>$term_date,
								"sentToAvility"=>$sentToAvitity,
                                "refusalDate"=>$refusalDate,
                                "evaluationDate" => $evaluation_date,

                                "hraStatus"=>$hra_status,
                                "hraDays"=>$hra_days,
                                "queryReviewStatus"=>$query_form_review_status,
                                "schedulerStatus"=>$scheduler_status,
                                "visitType"=>$visit_type,

                                "clientId"=>$client_id,
                                "clientName"=>$client_name,
                                "clientYear"=>$client_year,
								"cancelHistory"=>$cancel_history,

                                "queryForm"=>$query_form,
                                "importTrackerDetails"=>$import_tracker_details,
                                "reportNotes"=>$notes,
                                "refusalLetterDate"=>$refusal_letter_date,
                                "reportStatus"=>$report_status,
                                "scheduler"=>$scheduler,
                                "schedulerCallOrder"=>$scheduler_call_order,
                                "schedulerCallResponse"=>$scheduler_call_response,
                                "schedulerFullName"=>$scheduler_fullname,
                                "returnMail"=>$return_mail,
                                "schedulerHraStatus"=>$result_hra_status_result,
								"screening"=>$screening
                            );

        return $response_array;
	}

     /*
        NAME    : queryResultResponse
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */

    private function queryResultResponseforqa($member_query_result,$error){

        $total_rows = 0;
        
        $member_list=[];
        while ($member_row = $member_query_result->fetch_assoc()) 
        {
           // $member_list[]=$this->getMemberRequiredFieldAsArray($member_row);
            $member_list[]=$this->getMemberRequiredFieldAsArrayforqa($member_row);
            $total_rows = $member_row['totalRows'];
        }

       $member_response = new stdClass;
            $member_response->status=true;
            $member_response->error=$error;
            $member_response->totalRows=$total_rows;
            $member_response->members=$member_list;

        return $member_response;
    }

    private function queryResultResponse($member_query_result,$error)
    {
        $total_rows = 0;
        
        $member_list=[];
        while ($member_row = $member_query_result->fetch_assoc()) 
        {
            $member_list[]=$this->getMemberRequiredFieldAsArray($member_row);
            $total_rows = $member_row['totalRows'];
        }

       $member_response = new stdClass;
            $member_response->status=true;
            $member_response->error=$error;
            $member_response->totalRows=$total_rows;
            $member_response->members=$member_list;

        return $member_response;

    }


    /*
        NAME    : filter
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */

 public function filter($filter_parameters,&$error)
    {
        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $filter_parameters['planId'];
        $user_id = $filter_parameters['userId'];
        $year = $filter_parameters['year'];
        $min = $filter_parameters['min'];
        $max = $filter_parameters['max'];
        $lob= base64_decode(urldecode($filter_parameters['lob']));
		$filter_parameters['lob']=$lob;
        $tab_id = $filter_parameters['tabId'];

        $base_sort_by = $filter_parameters['baseSortBy'];
        $base_sort_order = $filter_parameters['baseSortOrder']==0?'ASC':'DESC';
        $sort_by = $filter_parameters['sortBy']; 
        $sort_order = $filter_parameters['sortOrder']==0?'ASC':'DESC';

        $start = $min;
        $offset = $max - $min;
       
        $sql_global_member_query = array();
		
        if(array_key_exists('planId',$filter_parameters))
        { 
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                            ReportGlobalMembers::convertToDefaultMemberSqlQuery(
                                            GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
                                            self::getNurseRequiredColumnAsString())
                                        ));
        }
        else
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                            ReportGlobalMembers::convertToDefaultMemberSqlQuery(
                                            GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
                                            self::getNurseRequiredColumnAsString())
                                        ));
        }

        //if invalid user details sent                                                
        if(count($sql_global_member_query)==0) return FALSE; 

            //where clause array and condition
            $where_clause_contiditions = array();
             //tab condition - hra status
             $nurse_hralist = $this->tabHraCondition($tab_id);
             switch($tab_id)
             {
                 case '1':
                     $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,'('.GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist).' OR '.GlobalQueryBuilder::whereClauseReportQATabConditionQuery().')') ;
                 break;
                 case '2':
                     $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
                 break;
                 case '3':
                   //  $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
                   // $getmemberlists = $this->getmemberslistids($plan_id,$year);
 $getmemberlists = $this->getmemberslistidsbyfilter($plan_id,$year,$filter_parameters);
//print_r($getmemberlists);die;
                     $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHomeAccessResultsTabConditionQuery($getmemberlists));
                 break;
                 case '4':
                    $getmemberlists = $this->getmemberslistids($plan_id,$year);
                     $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHomeAccessResultsTabConditionQuery($getmemberlists));
                     //$where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
                 break;
                 case '5':
 $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));

 // $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusInweeklyreport($nurse_hralist));
                 break;
                 case '6':
                     $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseReportRefusalTabConditionQuery());
                 break;
                 default:
                 break;
             }
 
            //to get this report assigned members where clause condition
            /*$my_member_filter['nurseIds']=$user_id;
            $my_member_filter['column']="nurse_id";
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('report',$my_member_filter));*/

            //filter conditions
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseCustomColumnValueIn('client_id',$filter_parameters,'clientId',true,'|',','));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('qa',$filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('coder',$filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('scheduler',$filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseScheduleDateBetween($filter_parameters));

            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseRefusalDateBetween($filter_parameters));


            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseCustomColumnValueIn('VisitType',$filter_parameters,'visitType',true));
	//$where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('nurse',$filter_parameters));
           if($tab_id == 5){
			$where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdInweeklyreport('nurse',$filter_parameters));
        }else{
			$where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('nurse',$filter_parameters));

        }

			$where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseCustomColumnValueIn('reportStatus',$filter_parameters,'status',true));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'city','Member_City',true));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'lob','LOB',true)); 
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'plan','Plan',true));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'program','Program',true)); 
        if(count($where_clause_contiditions)==0) { $error="no valid filter option selected"; return FALSE;}  

            //if any valid where clause found append 'where'
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
            //if multiple where clause add 'and' else 'or' condition
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));
            //order query string
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy(UserRoleConstant::NURSE,$base_sort_by,$sort_by,$base_sort_order,$sort_order));
            //limit string
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT ?,? ");
            //generated query 
            $generated_query = implode($sql_global_member_query);
            //echo $generated_query;exit();

            //prepare the member query
                if($conn->connect_errno)
                {
                    $error="datatbase connection failed";
                }
                //prepare the member query
                $member_query=$conn->prepare($generated_query);
                if($member_query===FALSE)
                {
                    $error = "error preparing sql query";
                    return FALSE;
                }
                //bind parameters
                $member_query->bind_param('ii',$start,$offset);
               
                if($member_query === FALSE)
                {
                    $error="parameter error";
                    return FALSE;
                }

                $member_query->execute();

                if($member_query === FALSE)
                {
                    $error="error in sql query";
                    return FALSE;
                }

                $member_query_result = $member_query->get_result();
                //ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$conn->error));
                if($tab_id == 1){
                    //    echo "sd";die;
                     ResponseUtility::echoJsonObject($this->queryResultResponseforqa($member_query_result,$error));
                 }else{
                     ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$error));
         
                 }
        
        return TRUE;
    }

    /*
        NAME    : search
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public function search($search_parameters,&$error)
    {
        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $search_parameters['planId'];
        $user_id = $search_parameters['userId'];
        $year = $search_parameters['year'];
        $min = $search_parameters['min'];
        $max = $search_parameters['max'];

        $tab_id = $search_parameters['tabId'];
        $base_sort_by = $search_parameters['baseSortBy'];
        $base_sort_order = $search_parameters['baseSortOrder']==0?'ASC':'DESC';
        $sort_by = $search_parameters['sortBy']; 
        $sort_order = $search_parameters['sortOrder']==0?'ASC':'DESC';

        $start = $min;
        $offset = $max - $min;

        $sql_global_member_query = array();
		
        if(array_key_exists('planId',$search_parameters))
        {   
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                    ReportGlobalMembers::convertToDefaultMemberSqlQuery(
                                    GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
                                    self::getNurseRequiredColumnAsString($tab_id)))
                                    );
									
        }
        else
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                        ReportGlobalMembers::convertToDefaultMemberSqlQuery(
                                        GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
                                        self::getNurseRequiredColumnAsString($tab_id)))
                                        );
        }
        //if invalid user details sent                                                
        if(count($sql_global_member_query)==0) return FALSE;  
            //where clause array and condition
            $where_clause_contiditions = array();
            //to get this report assigned members where clause condition
            /*$my_member_filter['nurseIds']=$user_id;
            $my_member_filter['column']="nurse_id";
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('report',$my_member_filter)); */ 
            
            //hra status based on tab
            /*$nurse_hralist = $this->tabHraCondition($tab_id);
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));*/
			 $nurse_hralist = $this->tabHraCondition($tab_id);
            switch($tab_id)
            {
                case '1':
                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,'('.GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist).' OR '.GlobalQueryBuilder::whereClauseReportQATabConditionQuery().')') ;
                break;
                case '2':
                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
                break;
                case '3':
                  //  $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
                   $getmemberlists = $this->getmemberslistids($plan_id,$year);
                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHomeAccessResultsTabConditionQuery($getmemberlists));
                break;
                case '4':
                   $getmemberlists = $this->getmemberslistids($plan_id,$year);
                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHomeAccessResultsTabConditionQuery($getmemberlists));
                    //$where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
                break;
                case '5':
                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
                break;
                case '6':
                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseReportRefusalTabConditionQuery());
                break;
                default:
                break;
            }

            //search where clause condition 
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByColumnLike('firstname',$search_parameters,'firstname'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByColumnLike('lastname',$search_parameters,'lastname'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberId($search_parameters,'id'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('Plan',$search_parameters,'plan'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('Program',$search_parameters,'program'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('LOB',$search_parameters,'lob'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('Member_City',$search_parameters,'city'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('Member_Zip_Code',$search_parameters,'zip'));
        
        if(count($where_clause_contiditions)==0) { $error="invalid search value"; return FALSE;}   

            //if any valid where clause found append 'where'
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
            //if multiple where clause add 'and' else 'or' condition
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));
            
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy(UserRoleConstant::NURSE,$base_sort_by,$sort_by,$base_sort_order,$sort_order));

            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT ?,? ");

            $generated_query = implode($sql_global_member_query);
 //echo $generated_query;die;
                                                       
                if($conn->connect_errno)
                {
                    $error="database connection failed";
                }

                //prepare the member query
                $member_query=$conn->prepare($generated_query);
                if($member_query===FALSE)
                {
                    $error = "error preparing sql query";
                    return FALSE;
                }
                //bind parameters
                $member_query->bind_param('ii',$start,$offset);
               
                if($member_query === FALSE)
                {
                    $error="parameter error";
                    return FALSE;
                }

                $member_query->execute();

                if($member_query === FALSE)
                {
                    $error="error in sql query";
                    return FALSE;
                }

                $member_query_result = $member_query->get_result();
               // ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$error));

                if($tab_id == 1){
                    //    echo "sd";die;
                     ResponseUtility::echoJsonObject($this->queryResultResponseforqa($member_query_result,$error));
                 }else{
                     ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$error));
         
                 }

            return TRUE;
   
    }



  public function   filtermontlyscreeningresult($filter_parameters,$error){
        include("../db.php");
        //custom parameter datas
        $plan_id = $filter_parameters['planId'];
        $user_id = $filter_parameters['userId'];
       $year = $filter_parameters['year'];
       $min = $filter_parameters['min'];
       $max = $filter_parameters['max'];
       $page = $parameters['page'];
       $base_sort_by = $filter_parameters['baseSortBy'];
       $base_sort_order = $filter_parameters['baseSortOrder']==0?'ASC':'DESC';
       $sort_by = $filter_parameters['sortBy']; 
       $sort_order = $filter_parameters['sortOrder']==0?'ASC':'DESC';
       $overallmemberids =   $this ->filtermemberslistformonthlyscreening($plan_id,$year,$filter_parameters);

$memberidslist = "'" . implode ( "', '", $overallmemberids['memberids'] ) . "'";

$arrdata = explode(",",$memberidslist);
$resprecordcount = count($overallmemberids['memberids']);

$newdaata = [];
$getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";

$getClientsidsresult=mysqli_query($conn,$getClientsids);
while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
$clientId =  $getClientsidsresp['clientId'];
$get_arraydataa[] = "select firstname,clientid,year,member_id,lastname,nurse_id,scheduler_id, qa_id,coder_id,memberinfo,hraStatus,hraStatusHistory,cancelHistory,invoiceDate,admin_idno,hraFileUpdatedHistory,query_form,scheduleDate,EvaluationDate,schedulerCallHraStatus,schedulerCallLogDetails,VisitType,schedulerDetails,reportNotes,scheduler,
JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory, REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','demographic' )),'.component', '.value[0]') )) As Demographic,
JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory, REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening' )),'.component', '.value[0]') )) As ScreeningArray,
reportStatus from HRA_member_".$clientId.'_'.$year;
}
if($get_arraydataa && is_array($get_arraydataa))
{
 $get_arraydataa = implode(" UNION ALL ", $get_arraydataa);
}

$memberinfo = $overallmemberids['serialrecords'];

// $k = 0;
// if($resprecordcount  != 0){
// foreach($arrdata as $memberId) {

    $nb_elem_per_page = 100;
$page = isset($page)?intval($page-1):0;

$k = 0;
if($resprecordcount  != 0){
  $arraydtaa=  array_slice($arrdata, $page*$nb_elem_per_page, $nb_elem_per_page);
  $newarray = array_count_values($arraydtaa);
    foreach ( $newarray as $memberId  => $count) {   
   $newmemberid = $member_id;
   $get_arraydata = "select * from (".$get_arraydataa. ") as member_table where member_id = $memberId";
    $get_arraydataall=mysqli_query($conn,$get_arraydata);
    $get_arraydataallrow=mysqli_fetch_array($get_arraydataall,MYSQLI_ASSOC);

    for($j=0;$j<$count;$j++){
        $serial = $j+1;
        $newdaata[] =array(
            'serial' => $overallmemberids['serialrecords'][$j]['serial'] ,
              'serialname' => $overallmemberids['serialrecords'][$j]['serialname'],
              'examdate' => $overallmemberids['serialrecords'][$j]['examdate'],
            'firstname' => $get_arraydataallrow['firstname'],
            'client_id' => $get_arraydataallrow['clientid'],
            'client_year' => $get_arraydataallrow['year'],
            'member_id' => $get_arraydataallrow['member_id'],
            'lastname' => $get_arraydataallrow['lastname'],
            'memberinfo' => json_decode($get_arraydataallrow['memberinfo'], true, JSON_UNESCAPED_SLASHES),
            'Demographic' => json_decode($get_arraydataallrow['Demographic'], true, JSON_UNESCAPED_SLASHES),
            'ScreeningArray' => json_decode($get_arraydataallrow['ScreeningArray'], true, JSON_UNESCAPED_SLASHES)
       
        );
    }

}

  if($sort_by == 'screeningname'){
    
    if($sort_order == 'ASC') {
       
    
    usort($newdaata, function ($item1, $item2) {
        return $item1['serialname'] <=> $item2['serialname'];
    });
    }else{
    
        usort($newdaata, function ($item1, $item2) {
            return $item2['serialname'] <=> $item1['serialname'];
        });
    
    }
    
    }

    if($sort_by == 'examdate'){
        
        if($sort_order == 'ASC') {
        usort($newdaata, function ($item1, $item2) {
          return new DateTime($item1['examdate']) <=> new DateTime($item2['examdate']);
        });
        }else{
        
            usort($newdaata, function ($item1, $item2) {
                return $item2['examdate'] <=> $item1['examdate'];
            });
        
        }
        
        }

$member_infodata=array("status"=>true,"members"=>$newdaata,"error"=>"","totalRows"=>count($arrdata));
}
else{
$member_infodata=array("status"=>true,"members"=>$newdaata,"error"=>"","totalRows"=>0);
}

echo $res_result = json_encode($member_infodata);  

    }

    public function searchmontlyscreeningresult($parameters,&$error){
       // print_r($parameters);die;
        include("../db.php");
        //custom parameter datas
        $plan_id = $parameters['planId'];
        $user_id = $parameters['userId'];
       $year = $parameters['year'];
       $min = $parameters['min'];
       $max = $parameters['max'];
       $base_sort_by = $parameters['baseSortBy'];
       $base_sort_order = $parameters['baseSortOrder']==0?'ASC':'DESC';
       $sort_by = $parameters['sortBy']; 
       $sort_order = $parameters['sortOrder']==0?'ASC':'DESC';
       $overallmemberids =   $this ->searchmemberslistformonthlyscreening($plan_id,$year,$parameters);

       $memberidslist = "'" . implode ( "', '", $overallmemberids['memberids'] ) . "'";
       //echo $memberidslist;die;
    
       $arrdata = explode(",",$memberidslist);
$resprecordcount = count($overallmemberids['memberids']);
       
    $newdaata = [];
    $getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";
       
    $getClientsidsresult=mysqli_query($conn,$getClientsids);
    while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
       $clientId =  $getClientsidsresp['clientId'];
       $get_arraydataa[] = "select firstname,clientid,year,member_id,lastname,nurse_id,scheduler_id, qa_id,coder_id,memberinfo,hraStatus,hraStatusHistory,cancelHistory,invoiceDate,admin_idno,hraFileUpdatedHistory,query_form,scheduleDate,EvaluationDate,schedulerCallHraStatus,schedulerCallLogDetails,VisitType,schedulerDetails,reportNotes,scheduler,
       JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory, REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','demographic' )),'.component', '.value[0]') )) As Demographic,
    JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory, REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening' )),'.component', '.value[0]') )) As ScreeningArray,
       reportStatus from HRA_member_".$clientId.'_'.$year;
    }
    if($get_arraydataa && is_array($get_arraydataa))
    {
        $get_arraydataa = implode(" UNION ALL ", $get_arraydataa);
    }
    
    $memberinfo = $overallmemberids['serialrecords'];
    
   // $k = 0;
if($resprecordcount  != 0){
  $arraydtaa=  array_slice($arrdata, $page*$nb_elem_per_page, $nb_elem_per_page);
  $newarray = array_count_values($arraydtaa);
    foreach ( $newarray as $memberId  => $count) {   
   $newmemberid = $member_id;
   $get_arraydata = "select * from (".$get_arraydataa. ") as member_table where member_id = $memberId";
    $get_arraydataall=mysqli_query($conn,$get_arraydata);
    $get_arraydataallrow=mysqli_fetch_array($get_arraydataall,MYSQLI_ASSOC);

    for($j=0;$j<$count;$j++){
        //$serial = $j+1;
        $newdaata[] =array(
            'serial' => $overallmemberids['serialrecords'][$j]['serial'] ,
              'serialname' => $overallmemberids['serialrecords'][$j]['serialname'],
              'examdate' => $overallmemberids['serialrecords'][$j]['examdate'],
            'firstname' => $get_arraydataallrow['firstname'],
            'client_id' => $get_arraydataallrow['clientid'],
            'client_year' => $get_arraydataallrow['year'],
            'member_id' => $get_arraydataallrow['member_id'],
            'lastname' => $get_arraydataallrow['lastname'],
            'memberinfo' => json_decode($get_arraydataallrow['memberinfo'], true, JSON_UNESCAPED_SLASHES),
            'Demographic' => json_decode($get_arraydataallrow['Demographic'], true, JSON_UNESCAPED_SLASHES),
            'ScreeningArray' => json_decode($get_arraydataallrow['ScreeningArray'], true, JSON_UNESCAPED_SLASHES)
       
        );
    }

}

  if($sort_by == 'screeningname'){
    
    if($sort_order == 'ASC') {
       
    
    usort($newdaata, function ($item1, $item2) {
        return $item1['serialname'] <=> $item2['serialname'];
    });
    }else{
    
        usort($newdaata, function ($item1, $item2) {
            return $item2['serialname'] <=> $item1['serialname'];
        });
    
    }
    
    }


    if($sort_by == 'examdate'){
        
        if($sort_order == 'ASC') {
        usort($newdaata, function ($item1, $item2) {
          return new DateTime($item1['examdate']) <=> new DateTime($item2['examdate']);
        });
        }else{
        
            usort($newdaata, function ($item1, $item2) {
                return $item2['examdate'] <=> $item1['examdate'];
            });
        
        }
        
        }

$member_infodata=array("status"=>true,"members"=>$newdaata,"error"=>"","totalRows"=>count($arrdata));
}
else{
$member_infodata=array("status"=>true,"members"=>$newdaata,"error"=>"","totalRows"=>0);
}
    echo $res_result = json_encode($member_infodata);  


    }

    public function reportmontlyscreeningresult($parameters,&$error){
//ini_set('max_execution_time', 0);
        include("../db.php");
        //custom parameter datas
        $plan_id = $parameters['planId'];
        $user_id = $parameters['userId'];
       $year = $parameters['year'];
       $min = $parameters['min'];
       $max = $parameters['max'];
$page = $parameters['page'];
       $base_sort_by = $parameters['baseSortBy'];
       $base_sort_order = $parameters['baseSortOrder']==0?'ASC':'DESC';
       $sort_by = $parameters['sortBy']; 
       $sort_order = $parameters['sortOrder']==0?'ASC':'DESC';
    
     
   $overallmemberids =   $this ->getmemberslistformonthlyscreening($plan_id,$year,$parameters);
// print_r($overallmemberids);die;
$serialarray = $overallmemberids['serialrecords'];

$memberidslist = "'" . implode ( "', '", $overallmemberids['memberids'] ) . "'";
$arrdata = explode(",",$memberidslist);
   
$newdaata = [];
$getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";
   
$getClientsidsresult=mysqli_query($conn,$getClientsids);
while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
   $clientId =  $getClientsidsresp['clientId'];

   $get_arraydataa[] = "select firstname,clientid,year,member_id,lastname,memberinfo,
   JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory, REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','demographic' )),'.component', '.value[0]') )) As Demographic,
JSON_UNQUOTE( JSON_EXTRACT( hraFileUpdatedHistory, REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening' )),'.component', '.value[0]') )) As ScreeningArray from HRA_member_".$clientId.'_'.$year;



}
if($get_arraydataa && is_array($get_arraydataa))
{
    $get_arraydataa = implode(" UNION ALL ", $get_arraydataa);
}

$memberinfo = $overallmemberids['serialrecords'];
$resprecordcount = count($overallmemberids['memberids']);
//echo $resprecordcount;die;

$nb_elem_per_page = 100;
$page = isset($page)?intval($page-1):0;

$k = 0;
if($resprecordcount  != 0){

 // $arraydtaa=  array_slice($arrdata, $page*$nb_elem_per_page, $nb_elem_per_page);
//print_r($serialarray);die;
  $arraydtaa=  array_slice($serialarray, $page*$nb_elem_per_page, $nb_elem_per_page);
  $member_ids = array_column($arraydtaa, 'member_id');
  $newarray = array_count_values($member_ids);

 // $arraydtaa=  array_slice($serialarray, $page*$nb_elem_per_page, $nb_elem_per_page);
 // $member_ids = array_column($arraydtaa, 'member_id');
 // $newarray = array_count_values($member_ids);


 // $newarray = array_count_values($arraydtaa);
//print_r($newarray);die;
$m = 0;
    foreach ( $newarray as $memberId  => $count) {   
   $newmemberid = $member_id;
   $get_arraydata = "select * from (".$get_arraydataa. ") as member_table where member_id = $memberId";
    $get_arraydataall=mysqli_query($conn,$get_arraydata);
    $get_arraydataallrow=mysqli_fetch_array($get_arraydataall,MYSQLI_ASSOC);

    for($j=0;$j<$count;$j++){

        $serial = $j+1;
        $newdaata[] =array(
            'serial' => $overallmemberids['serialrecords'][$m]['serial'] ,
            'serialname' => $overallmemberids['serialrecords'][$m]['serialname'],
            'examdate' => $overallmemberids['serialrecords'][$m]['examdate'],
            'firstname' => $get_arraydataallrow['firstname'],
            'client_id' => $get_arraydataallrow['clientid'],
            'client_year' => $get_arraydataallrow['year'],
            'member_id' => $get_arraydataallrow['member_id'],
            'lastname' => $get_arraydataallrow['lastname'],
            'memberinfo' => json_decode($get_arraydataallrow['memberinfo'], true, JSON_UNESCAPED_SLASHES),
            'Demographic' => json_decode($get_arraydataallrow['Demographic'], true, JSON_UNESCAPED_SLASHES),
            'ScreeningArray' => json_decode($get_arraydataallrow['ScreeningArray'], true, JSON_UNESCAPED_SLASHES)
       
        );
$m= $m + 1;
    }

}

//print_r($newdaata);die;
if($sort_by == 'screeningname'){
    
if($sort_order == 'ASC') {
   

usort($newdaata, function ($item1, $item2) {
    return $item1['serialname'] <=> $item2['serialname'];
});
}else{

    usort($newdaata, function ($item1, $item2) {
        return $item2['serialname'] <=> $item1['serialname'];
    });

}

}
//echo "<br>";
//print_r($newdaata);die;
if($sort_by == 'examdate'){
    
    if($sort_order == 'ASC') {
    usort($newdaata, function ($item1, $item2) {
      return new DateTime($item1['examdate']) <=> new DateTime($item2['examdate']);
    });
    }else{
    
        usort($newdaata, function ($item1, $item2) {
            return $item2['examdate'] <=> $item1['examdate'];
        });
    
    }
    
    }
//print_r($newdaata);die;
$member_infodata=array("status"=>true,"members"=>$newdaata,"error"=>"","totalRows"=>count($arrdata));
}
else{

    $member_infodata=array("status"=>true,"members"=>$newdaata,"error"=>"","totalRows"=>0);
}

echo $res_result = json_encode($member_infodata);  

    }


	    public function filtermemberslistformonthlyscreening($plan_id,$year,$filter_parameters){

        $memberid = $filter_parameters['id'];
        $firstname = $filter_parameters['firstname'];
        $lastname = $filter_parameters['lastname'];

        $base_sort_by = $filter_parameters['baseSortBy'];
        $base_sort_order = $filter_parameters['baseSortOrder']==0?'ASC':'DESC';
        $sort_by = $filter_parameters['sortBy']; 
        $sort_order = $filter_parameters['sortOrder']==0?'ASC':'DESC';

        $lob= base64_decode(urldecode($filter_parameters['lob']));
		$filter_parameters['lob']=$lob;

        $currentfiltersarray = array("0" => "DIGITAL RETINAL EXAM", "1" => "HBA1C", "2" => "MICROALBUMIN", "3" =>"FIT", "4" =>"DEXA", "5" =>"PAD", "6" =>"DLDL");
        $arradata = explode("_",$filter_parameters['screening']);
        $intersectresult=array_intersect($currentfiltersarray,$arradata);

          include("../db.php");
          $getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";
     
          $getClientsidsresult=mysqli_query($conn,$getClientsids);
          $sql_global_member_query = array();
          while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
             $client_id =  $getClientsidsresp['clientId'];

             //joining tables based on client
                $combine_member_query[] = "select member_id,clientid as client_id,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Program')))) AS memberProgram,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.LOB')))) AS memberLob,scheduleDate,memberinfo,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Member_first_name')))) AS memberFirstName,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Member_Last_name')))) AS memberLastName,STR_TO_DATE(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.date' ) )),'%m-%d-%Y') AS ScreeningDate,lastname,JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0]'
       ) )) AS screeningobject FROM HRA_member_".$client_id.'_'.$year;
     
          }
          if($combine_member_query && is_array($combine_member_query))
          {
              $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
              $sql_global_member_query1 = "select * from (".$sql_global_member_query1.") as  member_table";
              $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,$sql_global_member_query1);
          }

        if(count($sql_global_member_query)==0) return FALSE; 
        $where_clause_contiditions = array();

        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'lob','LOB',true));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'plan','Plan',true));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'program','Program',true));
        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseCustomColumnValueIn('client_id',$filter_parameters,'clientId',true,'|',','));

        $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseScheduleDateBetween($filter_parameters));

        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));

        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));

       // print_r($where_clause_contiditions);die;
       $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('nurse',$base_sort_by,$sort_by,$base_sort_order,$sort_order));
     
        $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT 0,200000");
        //generated query 
        $generated_query = implode($sql_global_member_query);
       //echo $generated_query;die;

       $membersresult=mysqli_query($conn,$generated_query);

       $memberserailids = [];
       $offerArray = array();
       $overallarray = array();
       while($membersresultresp=mysqli_fetch_array($membersresult,MYSQLI_ASSOC)){
           if($membersresultresp['screeningobject'] != null ){
        $arraydata = json_decode($membersresultresp['screeningobject'],true);
    if(count($intersectresult) == 0) { 
       if($arraydata[0][2] != '' || $arraydata[0][3])
       {
            $member_id=  $membersresultresp['member_id'];
           $memberids[] = $member_id;
   
          $memberserailids['serial'] = 0;
          $memberserailids['examdate'] = $arraydata[0][3];
          $memberserailids['serialname'] = 'DIGITAL RETINAL EXAM';
          $memberserailids['member_id'] = $member_id;
          array_push($offerArray,$memberserailids);
         
   
       }
   
        if($arraydata[1][2] != '' || $arraydata[1][3])
        {
             $member_id=  $membersresultresp['member_id'];
            $memberids[] = $member_id;
   
           $memberserailids['serial'] = 1;
           $memberserailids['examdate'] = $arraydata[1][3];
           $memberserailids['serialname'] = 'HBA1C';
           $memberserailids['member_id'] = $member_id;
           array_push($offerArray,$memberserailids);
          // array_push($offerArray,$keyval);
   
        }
        if($arraydata[2][2] != '' || $arraydata[2][3] != '') {
             $member_id=  $membersresultresp['member_id'];
            $memberids[] = $member_id;
   
           $memberserailids['serial'] = 2;
           $memberserailids['examdate'] = $arraydata[2][3];
           $memberserailids['serialname'] = 'MICROALBUMIN';
           $memberserailids['member_id'] = $member_id;
           array_push($offerArray,$memberserailids);
        }
        
        if($arraydata[3][2] != ''  || $arraydata[3][3] != ''){
             $member_id=  $membersresultresp['member_id'];
            $memberids[] = $member_id;
   
           $memberserailids['serial'] = 3;
           $memberserailids['examdate'] = $arraydata[3][3];
           $memberserailids['serialname'] = 'FIT';
           $memberserailids['member_id'] = $member_id;
           array_push($offerArray,$memberserailids);
        }
   
        if($arraydata[4][2] != ''  || $arraydata[4][3] != ''){
           $member_id=  $membersresultresp['member_id'];
          $memberids[] = $member_id;
   
         $memberserailids['serial'] = 4;
         $memberserailids['examdate'] = $arraydata[4][3];
         $memberserailids['serialname'] = 'DEXA';
         $memberserailids['member_id'] = $member_id;
         array_push($offerArray,$memberserailids);
      }
   
      if($arraydata[5][2] != ''  || $arraydata[5][3] != ''){
       $member_id=  $membersresultresp['member_id'];
      $memberids[] = $member_id;
   
     $memberserailids['serial'] = 5;
     $memberserailids['examdate'] = $arraydata[5][3];
     $memberserailids['serialname'] = 'PAD';
     $memberserailids['member_id'] = $member_id;
     array_push($offerArray,$memberserailids);
   }
   
   
        if($arraydata[6][2] != ''   || $arraydata[6][3] != ''){
             $member_id=  $membersresultresp['member_id'];
            $memberids[] = $member_id;
    
           $memberserailids['serial'] = 6;
           $memberserailids['examdate'] = $arraydata[6][3];
           $memberserailids['serialname'] = 'DLDL';
           $memberserailids['member_id'] = $member_id;
           array_push($offerArray,$memberserailids);
        }


    }else{


        if(($arraydata[0][2] != '' || $arraydata[0][3]) && $intersectresult[0] != '')
        {
             $member_id=  $membersresultresp['member_id'];
            $memberids[] = $member_id;
    
           $memberserailids['serial'] = 0;
           $memberserailids['examdate'] = $arraydata[0][3];
           $memberserailids['serialname'] = 'DIGITAL RETINAL EXAM';
           $memberserailids['member_id'] = $member_id;
           array_push($offerArray,$memberserailids);
          
    
        }
    
         if(($arraydata[1][2] != '' || $arraydata[1][3])  && $intersectresult[1] != '')
         {
              $member_id=  $membersresultresp['member_id'];
             $memberids[] = $member_id;
    
            $memberserailids['serial'] = 1;
            $memberserailids['examdate'] = $arraydata[1][3];
            $memberserailids['serialname'] = 'HBA1C';
            $memberserailids['member_id'] = $member_id;
            array_push($offerArray,$memberserailids);
           // array_push($offerArray,$keyval);
    
         }
         if(($arraydata[2][2] != '' || $arraydata[2][3] != '')   && $intersectresult[2] != '' ) {
              $member_id=  $membersresultresp['member_id'];
             $memberids[] = $member_id;
    
            $memberserailids['serial'] = 2;
            $memberserailids['examdate'] = $arraydata[2][3];
            $memberserailids['serialname'] = 'MICROALBUMIN';
            $memberserailids['member_id'] = $member_id;
            array_push($offerArray,$memberserailids);
         }
         
         if(($arraydata[3][2] != ''  || $arraydata[3][3] != '') && $intersectresult[3] != '' ){
              $member_id=  $membersresultresp['member_id'];
             $memberids[] = $member_id;
    
            $memberserailids['serial'] = 3;
            $memberserailids['examdate'] = $arraydata[3][3];
            $memberserailids['serialname'] = 'FIT';
            $memberserailids['member_id'] = $member_id;
            array_push($offerArray,$memberserailids);
         }
    
         if(($arraydata[4][2] != ''  || $arraydata[4][3] != '') && $intersectresult[4] != '' ){
            $member_id=  $membersresultresp['member_id'];
           $memberids[] = $member_id;
    
          $memberserailids['serial'] = 4;
          $memberserailids['examdate'] = $arraydata[4][3];
          $memberserailids['serialname'] = 'DEXA';
          $memberserailids['member_id'] = $member_id;
          array_push($offerArray,$memberserailids);
       }
    
       if(($arraydata[5][2] != ''  || $arraydata[5][3] != '') && $intersectresult[5] != '' ){
        $member_id=  $membersresultresp['member_id'];
       $memberids[] = $member_id;
    
      $memberserailids['serial'] = 5;
      $memberserailids['examdate'] = $arraydata[5][3];
      $memberserailids['serialname'] = 'PAD';
      $memberserailids['member_id'] = $member_id;
      array_push($offerArray,$memberserailids);
    }
    
    
         if(($arraydata[6][2] != ''   || $arraydata[6][3] != '') && $intersectresult[6] != '' ){
              $member_id=  $membersresultresp['member_id'];
             $memberids[] = $member_id;
     
            $memberserailids['serial'] = 6;
            $memberserailids['examdate'] = $arraydata[6][3];
            $memberserailids['serialname'] = 'DLDL';
            $memberserailids['member_id'] = $member_id;
            array_push($offerArray,$memberserailids);
         }



    }

        
        }

        }
   
      $overallarray['serialrecords'] = $offerArray;
      $overallarray['memberids'] = $memberids;
        return $overallarray;

    }


	  public function searchmemberslistformonthlyscreening($plan_id,$year,$parameters){
      $memberid = $parameters['id'];
      $firstname = $parameters['firstname'];
      $lastname = $parameters['lastname'];

      $base_sort_by = $parameters['baseSortBy'];
      $base_sort_order = $parameters['baseSortOrder']==0?'ASC':'DESC';
      $sort_by = $parameters['sortBy']; 
      $sort_order = $parameters['sortOrder']==0?'ASC':'DESC';
        
        include("../db.php");
        $getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";
   
        $getClientsidsresult=mysqli_query($conn,$getClientsids);
        $sql_global_member_query = array();
        
        while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
           $client_id =  $getClientsidsresp['clientId'];

    $combine_member_query[] = "select member_id,firstname,clientid as client_id,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Program')))) AS memberProgram,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.LOB')))) AS memberLob,scheduleDate,memberinfo,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Member_first_name')))) AS memberFirstName,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Member_Last_name')))) AS memberLastName,STR_TO_DATE(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.date' ) )),'%m-%d-%Y') AS ScreeningDate,lastname,JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0]'
    ) )) AS screeningobject FROM HRA_member_".$client_id.'_'.$year;
   
        }
        if($combine_member_query && is_array($combine_member_query))
        {
            $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
            $sql_global_member_query1 = "select * from (".$sql_global_member_query1.") as  member_table";
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,$sql_global_member_query1);

        }

if(count($sql_global_member_query)==0) return FALSE; 
$where_clause_contiditions = array();

            //search where clause condition 
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByColumnLike('firstname',$parameters,'firstname'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByColumnLike('lastname',$parameters,'lastname'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberId($parameters,'id'));


            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
            //if multiple where clause add 'and' else 'or' condition
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));
            
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy(UserRoleConstant::NURSE,$base_sort_by,$sort_by,$base_sort_order,$sort_order));

            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT 0,20000 ");

            $generated_query = implode($sql_global_member_query);

    $membersresult=mysqli_query($conn,$generated_query);

    $memberserailids = [];
    $offerArray = array();
    $overallarray = array();
    while($membersresultresp=mysqli_fetch_array($membersresult,MYSQLI_ASSOC)){
        if($membersresultresp['screeningobject'] != null ){
            
     $arraydata = json_decode($membersresultresp['screeningobject'],true);
    if($arraydata[0][2] != '' || $arraydata[0][3])
    {
         $member_id=  $membersresultresp['member_id'];
        $memberids[] = $member_id;

       $memberserailids['serial'] = 0;
       $memberserailids['examdate'] = $arraydata[0][3];
       $memberserailids['serialname'] = 'DIGITAL RETINAL EXAM';
       $memberserailids['member_id'] = $member_id;
       array_push($offerArray,$memberserailids);

    }

     if($arraydata[1][2] != '' || $arraydata[1][3])
     {
          $member_id=  $membersresultresp['member_id'];
         $memberids[] = $member_id;

        $memberserailids['serial'] = 1;
        $memberserailids['examdate'] = $arraydata[1][3];
        $memberserailids['serialname'] = 'HBA1C';
        $memberserailids['member_id'] = $member_id;
        array_push($offerArray,$memberserailids);

     }
     if($arraydata[2][2] != '' || $arraydata[2][3] != '') {
          $member_id=  $membersresultresp['member_id'];
         $memberids[] = $member_id;

        $memberserailids['serial'] = 2;
        $memberserailids['examdate'] = $arraydata[2][3];
        $memberserailids['serialname'] = 'MICROALBUMIN';
        $memberserailids['member_id'] = $member_id;
        array_push($offerArray,$memberserailids);
     }
     
     if($arraydata[3][2] != ''  || $arraydata[3][3] != ''){
          $member_id=  $membersresultresp['member_id'];
         $memberids[] = $member_id;

        $memberserailids['serial'] = 3;
        $memberserailids['examdate'] = $arraydata[3][3];
        $memberserailids['serialname'] = 'FIT';
        $memberserailids['member_id'] = $member_id;
        array_push($offerArray,$memberserailids);
     }

     if($arraydata[4][2] != ''  || $arraydata[4][3] != ''){
        $member_id=  $membersresultresp['member_id'];
       $memberids[] = $member_id;

      $memberserailids['serial'] = 4;
      $memberserailids['examdate'] = $arraydata[4][3];
      $memberserailids['serialname'] = 'DEXA';
      $memberserailids['member_id'] = $member_id;
      array_push($offerArray,$memberserailids);
   }

   if($arraydata[5][2] != ''  || $arraydata[5][3] != ''){
    $member_id=  $membersresultresp['member_id'];
   $memberids[] = $member_id;

  $memberserailids['serial'] = 5;
  $memberserailids['examdate'] = $arraydata[5][3];
  $memberserailids['serialname'] = 'PAD';
  $memberserailids['member_id'] = $member_id;
  array_push($offerArray,$memberserailids);
}


     if($arraydata[6][2] != ''   || $arraydata[6][3] != ''){
          $member_id=  $membersresultresp['member_id'];
         $memberids[] = $member_id;
 
        $memberserailids['serial'] = 6;
        $memberserailids['examdate'] = $arraydata[6][3];
        $memberserailids['serialname'] = 'DLDL';
        $memberserailids['member_id'] = $member_id;
        array_push($offerArray,$memberserailids);
     }
     
     }
	 }

   $overallarray['serialrecords'] = $offerArray;
   $overallarray['memberids'] = $memberids;
     return $overallarray;

    }


   public function getmemberslistformonthlyscreening($plan_id,$year,$parameters){
        $base_sort_by = $parameters['baseSortBy'];
        $base_sort_order = $parameters['baseSortOrder']==0?'ASC':'DESC';
        $sort_by = $parameters['sortBy']; 
        $sort_order = $parameters['sortOrder']==0?'ASC':'DESC';

        include("../db.php");
        $getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";
   
        $getClientsidsresult=mysqli_query($conn,$getClientsids);
        $sql_global_member_query = array();
        while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
           $client_id =  $getClientsidsresp['clientId'];
           //joining tables based on client
           $combine_member_query[] = "select member_id,clientid as client_id,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Program')))) AS memberProgram,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.LOB')))) AS memberLob,scheduleDate,memberinfo,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Member_first_name')))) AS memberFirstName,UPPER(TRIM(JSON_UNQUOTE(JSON_EXTRACT(memberinfo,'$.Member_Last_name')))) AS memberLastName,STR_TO_DATE(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.date' ) )),'%m-%d-%Y') AS ScreeningDate,lastname,JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0]'
           ) )) AS screeningobject FROM HRA_member_".$client_id.'_'.$year;
   
        }
        if($combine_member_query && is_array($combine_member_query))
        {
            $sql_global_member_query1 = implode(" UNION ALL ", $combine_member_query);
            $sql_global_member_query1 = "select * from (". $sql_global_member_query1 . " ) as member_table ";
$sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,$sql_global_member_query1);
        }
   

if(count($sql_global_member_query)==0) return FALSE; 
$sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('nurse',$base_sort_by,$sort_by,$base_sort_order,$sort_order));
$sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT 0,200000");

$generated_query = implode($sql_global_member_query);
//echo $generated_query;die;
   
    $membersresult=mysqli_query($conn,$generated_query);
    $memberserailids = [];
    $offerArray = array();
    $overallarray = array();

    while($membersresultresp=mysqli_fetch_array($membersresult,MYSQLI_ASSOC)){
  
   
        if($membersresultresp['screeningobject'] != null ){
            
     $arraydata = json_decode($membersresultresp['screeningobject'],true);
    if($arraydata[0][2] != '' || $arraydata[0][3])
    {
         $member_id=  $membersresultresp['member_id'];
        $memberids[] = $member_id;

       $memberserailids['serial'] = 0;
       $memberserailids['examdate'] = $arraydata[0][3];
       $memberserailids['serialname'] = 'DIGITAL RETINAL EXAM';
       $memberserailids['member_id'] = $member_id;
       array_push($offerArray,$memberserailids);

    }

     if($arraydata[1][2] != '' || $arraydata[1][3])
     {
          $member_id=  $membersresultresp['member_id'];
         $memberids[] = $member_id;

        $memberserailids['serial'] = 1;
        $memberserailids['examdate'] = $arraydata[1][3];
        $memberserailids['serialname'] = 'HBA1C';
        $memberserailids['member_id'] = $member_id;
        array_push($offerArray,$memberserailids);

     }
     if($arraydata[2][2] != '' || $arraydata[2][3] != '') {
          $member_id=  $membersresultresp['member_id'];
         $memberids[] = $member_id;

        $memberserailids['serial'] = 2;
        $memberserailids['examdate'] = $arraydata[2][3];
        $memberserailids['serialname'] = 'MICROALBUMIN';
        $memberserailids['member_id'] = $member_id;
        array_push($offerArray,$memberserailids);
     }
     
     if($arraydata[3][2] != ''  || $arraydata[3][3] != ''){
          $member_id=  $membersresultresp['member_id'];
         $memberids[] = $member_id;

        $memberserailids['serial'] = 3;
        $memberserailids['examdate'] = $arraydata[3][3];
        $memberserailids['serialname'] = 'FIT';
        $memberserailids['member_id'] = $member_id;
        array_push($offerArray,$memberserailids);
     }

     if($arraydata[4][2] != ''  || $arraydata[4][3] != ''){
        $member_id=  $membersresultresp['member_id'];
       $memberids[] = $member_id;

      $memberserailids['serial'] = 4;
      $memberserailids['examdate'] = $arraydata[4][3];
      $memberserailids['serialname'] = 'DEXA';
      $memberserailids['member_id'] = $member_id;
      array_push($offerArray,$memberserailids);
   }

   if($arraydata[5][2] != ''  || $arraydata[5][3] != ''){
    $member_id=  $membersresultresp['member_id'];
   $memberids[] = $member_id;

  $memberserailids['serial'] = 5;
  $memberserailids['examdate'] = $arraydata[5][3];
  $memberserailids['serialname'] = 'PAD';
  $memberserailids['member_id'] = $member_id;
  array_push($offerArray,$memberserailids);
}


     if($arraydata[6][2] != ''   || $arraydata[6][3] != ''){
          $member_id=  $membersresultresp['member_id'];
         $memberids[] = $member_id;
 
        $memberserailids['serial'] = 6;
        $memberserailids['examdate'] = $arraydata[6][3];
        $memberserailids['serialname'] = 'DLDL';
        $memberserailids['member_id'] = $member_id;
        array_push($offerArray,$memberserailids);
     }
     
     }
	 }
//print_r($offerArray);die;
   $overallarray['serialrecords'] = $offerArray;
   $overallarray['memberids'] = $memberids;
     return $overallarray;
    
    }


 public function getmemberslistidsbyfilter($plan_id,$year,$filter_parameters)
    {

        include("../db.php");
     $getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";

     $getClientsidsresult=mysqli_query($conn,$getClientsids);
     while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
        $client_id =  $getClientsidsresp['clientId'];
        //joining tables based on client
  $combine_member_query[] = "select member_id,STR_TO_DATE(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.date' ) )),'%m-%d-%Y') AS ScreeningDate,JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0]'
  ) )) AS screeningobject FROM HRA_member_".$client_id.'_'.$year;

     }

     if($combine_member_query && is_array($combine_member_query))
     {
         $combine_member_query = implode(" UNION ALL ", $combine_member_query);
     }

     // query for getting last screening updated date 
 $finalquery = $combine_member_query . " ORDER by ScreeningDate DESC LIMIT 1";
  $LastUpdatedScreenDateresult=mysqli_query($conn,$finalquery);
  $lastestDateres=mysqli_fetch_array($LastUpdatedScreenDateresult,MYSQLI_ASSOC);
$todate =  $lastestDateres['ScreeningDate'];

// based on  last screening date getting from and todate 
// $enddate = date('Y-m-d', strtotime($todate));
//$startdate = date('Y-m-d', strtotime('-7 days', strtotime($enddate))); 

//$day = date('Y-m-d');
$day = date('w');
$startdate = date('Y-m-d', strtotime('+'.(1-$day).' days'));
$enddate = date('Y-m-d', strtotime('+'.(7-$day).' days'));

//$startdate = '2022-01-10';
//$enddate = '2022-01-17';

$day = date('Y-m-d');
$startdate = $day;
$enddate = $day;


  $finalquery2 = "select * from (". $combine_member_query . " ) as tableC WHERE tableC.ScreeningDate BETWEEN '".$startdate."' and '".$enddate."' ";

 $membersresult=mysqli_query($conn,$finalquery2);
//print_r(mysqli_fetch_array($membersresult,MYSQLI_ASSOC));die;
//print_r($filter_parameters);die;
$currentfiltersarray = array("0" => "DLDL", "1" => "FIT", "2" => "HBA1C", "3" =>"MICROALBUMIN");

$arradata = explode("_",$filter_parameters['screening']);
$intersectresult=array_intersect($currentfiltersarray,$arradata);
//print_r($intersectresult);die;

$memberids = [];
while($membersresultres=mysqli_fetch_array($membersresult,MYSQLI_ASSOC)){
  
   
    if($membersresultres['screeningobject'] != 'null' &&  $intersectresult[2] == 'HBA1C'){
    $arraydata = json_decode($membersresultres['screeningobject'],true);
    if($arraydata[1][4] != '')
{
     $member_id=  $membersresultres['member_id'];
    $memberids[] = $member_id;
}

}

 if($membersresultres['screeningobject'] != 'null' &&  $intersectresult[3] == 'MICROALBUMIN'){
    $arraydata = json_decode($membersresultres['screeningobject'],true);
    if($arraydata[2][4] != '')
{
     $member_id=  $membersresultres['member_id'];
    $memberids[] = $member_id;
}

}

 if($membersresultres['screeningobject'] != 'null' &&  $intersectresult[1] == 'FIT'){
    $arraydata = json_decode($membersresultres['screeningobject'],true);

    if($arraydata[3][4] != '')
{

     $member_id=  $membersresultres['member_id'];
    $memberids[] = $member_id;
}

}


 if($membersresultres['screeningobject'] != 'null' &&  $intersectresult[0] == 'DLDL'){
    $arraydata = json_decode($membersresultres['screeningobject'],true);

    if($arraydata[6][4] != '')
{

     $member_id=  $membersresultres['member_id'];
    $memberids[] = $member_id;
}

}

//removed here else
if($membersresultres['screeningobject'] != 'null' && ($intersectresult[0] == '' && $intersectresult[1] == '' && $intersectresult[2] == '' && $intersectresult[3] == '')){
//echo "s";die;
$arraydata = json_decode($membersresultres['screeningobject'],true);

    if($arraydata[1][4] != '' || $arraydata[2][4] != '' || $arraydata[3][4] != '' || $arraydata[6][4] != '')
    {
         $member_id=  $membersresultres['member_id'];
        $memberids[] = $member_id;
    }

}


}
//echo "asdf";
  $memberidslist = "'" . implode ( "', '", $memberids ) . "'";
// $memberidslist = '11001318','10050057';
//echo "kl";die;
//echo $memberidslist;die;
return $memberidslist;

    }

    public function getmemberslistids($plan_id,$year)
    {

        include("../db.php");
     $getClientsids =  "SELECT clientId FROM HRA_client where plan= '".$plan_id."' and year like  '%".$year."%'";

     $getClientsidsresult=mysqli_query($conn,$getClientsids);
     while($getClientsidsresp=mysqli_fetch_array($getClientsidsresult,MYSQLI_ASSOC)){
        $client_id =  $getClientsidsresp['clientId'];
        //joining tables based on client
  $combine_member_query[] = "select member_id,STR_TO_DATE(JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.date' ) )),'%m-%d-%Y') AS ScreeningDate,JSON_UNQUOTE(JSON_EXTRACT(hraFileUpdatedHistory,REPLACE(JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'one','screening')),'.component','.value[0]'
  ) )) AS screeningobject FROM HRA_member_".$client_id.'_'.$year;

     }
     if($combine_member_query && is_array($combine_member_query))
     {
         $combine_member_query = implode(" UNION ALL ", $combine_member_query);
     }

     // query for getting last screening updated date 
 $finalquery = $combine_member_query . " ORDER by ScreeningDate DESC LIMIT 1";
  $LastUpdatedScreenDateresult=mysqli_query($conn,$finalquery);
  $lastestDateres=mysqli_fetch_array($LastUpdatedScreenDateresult,MYSQLI_ASSOC);
$todate =  $lastestDateres['ScreeningDate'];

// based on  last screening date getting from and todate 
// $enddate = date('Y-m-d', strtotime($todate));
//$startdate = date('Y-m-d', strtotime('-7 days', strtotime($enddate))); 

$day = date('w');

$startdate = date('Y-m-d', strtotime('+'.(1-$day).' days'));
$enddate = date('Y-m-d', strtotime('+'.(7-$day).' days'));


//$startdate = date('Y-m-d', strtotime('+'.(0-$day).' days'));
//$enddate = date('Y-m-d', strtotime('+'.(1-$day).' days'));

$day = date('Y-m-d');
$startdate = $day;
$enddate = $day;

//$startdate = '2022-01-10';
//$enddate = '2022-01-17';

   $finalquery2 = "select * from (". $combine_member_query . " ) as tableC WHERE tableC.ScreeningDate BETWEEN '".$startdate."' and '".$enddate."' ";


 $membersresult=mysqli_query($conn,$finalquery2);

while($membersresultres=mysqli_fetch_array($membersresult,MYSQLI_ASSOC)){
  
   
   if($membersresultres['screeningobject'] != 'null' ){
$arraydata = json_decode($membersresultres['screeningobject'],true);
if($arraydata[1][4] != '' || $arraydata[2][4] != '' || $arraydata[3][4] != '' || $arraydata[6][4] != '')
{
     $member_id=  $membersresultres['member_id'];
    $memberids[] = $member_id;
}
}

}
  $memberidslist = "'" . implode ( "', '", $memberids ) . "'";
// $memberidslist = '11001318','10050057';
return $memberidslist;

    }


  
   /*
        NAME    : getMembersForBulkExport
        TYPE    : global Utiltiy function 
        DETAILS : get the member details based on tab id
        RETURN  : member details
		dev - laskhmi
    */
    public function getMembersForBulkExport($parameters,&$error)
    {
        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $parameters['planId'];
        $user_id = $parameters['userId'];
        $year = $parameters['year'];
        $min = $parameters['min'];
        $max = $parameters['max'];

        $tab_id = $parameters['tabId'];
        $base_sort_by = $parameters['baseSortBy'];
        $base_sort_order = $parameters['baseSortOrder']==0?'ASC':'DESC';
        $sort_by = $parameters['sortBy']; 
        $sort_order = $parameters['sortOrder']==0?'ASC':'DESC';

        $start = $min;
        $offset = $max - $min;

        $sql_global_member_query = array();


                if($tab_id==5){
            if(array_key_exists('planId',$parameters))
            {
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                        ReportGlobalMembers::convertToSortMemberSqlQuery(
                                        GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
                                        self::getNurseRequiredColumnAsString($tab_id)))
                                    );
            }
           else
            {
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                        ReportGlobalMembers::convertToSortMemberSqlQuery(
                                        GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
                                        self::getNurseRequiredColumnAsString($tab_id)))
                                    );
            }
        }else{
        if(array_key_exists('planId',$parameters))
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                    ReportGlobalMembers::convertToDefaultMemberSqlQuery(
                                    GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
                                    self::getNurseRequiredColumnAsString($tab_id)))
                                );
        }
        else
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                    ReportGlobalMembers::convertToDefaultMemberSqlQuery(
                                    GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
                                    self::getNurseRequiredColumnAsString($tab_id)))
                                );
        }
}

        
        //when invalid userid sent
        if(count($sql_global_member_query)==0) return FALSE; 

            //where clause array and condition
            $where_clause_contiditions = array();

            //to get this report assigned members where clause condition
            /*$my_member_filter['nurseIds']=$user_id;
            $my_member_filter['column']="nurse_id";
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn(UserRoleConstant::NURSE,$my_member_filter));*/
            //hra status based on tab
            $nurse_hralist = $this->tabHraCondition($tab_id);
            /*$where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));*/
			$nurse_hralist = $this->tabHraCondition($tab_id);
            switch($tab_id)
            {
                case '1':
                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,'('.GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist).' OR '.GlobalQueryBuilder::whereClauseReportQATabConditionQuery().')') ;
                break;
                case '2':
                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
                break;
                case '3':
 $getmemberlists = $this->getmemberslistids($plan_id,$year);
//echo $getmemberlists;die;

                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHomeAccessResultsTabConditionQuery($getmemberlists));
                break;
                case '4':
 $getmemberlists = $this->getmemberslistids($plan_id,$year);
                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHomeAccessResultsTabConditionQuery($getmemberlists));

                   // $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
                break;
                case '5':
                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
                break;
                case '6':
                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseReportRefusalTabConditionQuery());
                break;
                default:
                break;
            }
            
            //if any valid where clause found append 'where'
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
            //if multiple where clause add 'and' else 'or' condition
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));
            //sort by query string
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('nurse',$base_sort_by,$sort_by,$base_sort_order,$sort_order));
            //limit by range
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT ?,? ");
             
            //genarated query
            $generated_query = implode($sql_global_member_query);
           
           //echo $generated_query;exit();
                if($conn->connect_errno)
                {
                    $error="database connection failed";
                }

                //prepare the member query
                $member_query=$conn->prepare($generated_query);
                if($member_query===FALSE)
                {
                    $error = "error preparing sql query";
                    return FALSE;
                }
                //bind parameters
                $member_query->bind_param('ii',$start,$offset);
               
                if($member_query === FALSE)
                {
                    $error="parameter error";
                    return FALSE;
                }

                $member_query->execute();

                if($member_query === FALSE)
                {
                    $error="error in sql query";
                    return FALSE;
                }

            $member_query_result = $member_query->get_result();
           if($tab_id == 1){
           //    echo "sd";die;
            ResponseUtility::echoJsonObject($this->queryResultResponseForQaBulkExport($member_query_result,$error));
        }else{
            ResponseUtility::echoJsonObject($this->queryResultResponseForBulkExport($member_query_result,$error));

        }
           
        

        return TRUE;
        
    }
	
	
	    private function queryResultResponseForBulkExport($member_query_result,$error)
    {
        $total_rows = 0;
        
        $member_list=[];
        while ($member_row = $member_query_result->fetch_assoc()) 
        {
           // $member_list[]=$this->getMemberRequiredFieldAsArray($member_row);
		   $member_list[]=$member_row;
            $total_rows = $member_row['totalRows'];
        }

       $member_response = new stdClass;
            $member_response->status=true;
            $member_response->error=$error;
            $member_response->totalRows=$total_rows;
            $member_response->members=$member_list;

        return $member_response;

    }
	
	
    private function queryResultResponseForQaBulkExport($member_query_result,$error){

        $total_rows = 0;
        
        $member_list=[];
        while ($member_row = $member_query_result->fetch_assoc()) 
        {
           // $member_list[]=$this->getMemberRequiredFieldAsArray($member_row);
         $member_list[]=$member_row;
            $total_rows = $member_row['totalRows'];
        }

       $member_response = new stdClass;
            $member_response->status=true;
            $member_response->error=$error;
            $member_response->totalRows=$total_rows;
            $member_response->members=$member_list;

        return $member_response;
    }




    /*
        NAME    : convertToSortMemberSqlQuery
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function convertToSortMemberSqlQuery($member_table_sql_query)
	{
            if($member_table_sql_query === FALSE) return FALSE;//not valid query string

			$scheduler_member_sql_query = "SELECT (COUNT(*) OVER()) as totalRows, member_table.*,
            client_table.client_name as client_name,
            admin_table.userUniqueno as admin_id,
            CONCAT(scheduler_table.firstname ,' ',scheduler_table.lastname) as scheduler_fullname,
            CASE WHEN member_table.reportStatus in ('Scheduled','Cancellation','Completed','No Show','Rescheduled','Refusal','F2F No Show','Virtual No Show') THEN CONCAT(nurse_table.firstname ,' ', nurse_table.lastname) ELSE NULL END as nurse_fullname,            CONCAT(admin_table.firstname ,' ', admin_table.lastname) as admin_fullname, 
            CONCAT(qa_table.firstname ,' ', qa_table.lastname) as qa_fullname,
            CONCAT(coder_table.firstname ,' ', coder_table.lastname) as coder_fullname,
            
            member_global_status.return_mail as returnMail
            FROM 
				( $member_table_sql_query ) as member_table 
				LEFT JOIN userLogin as scheduler_table ON scheduler_table.userUniqueno = member_table.scheduler_id 
				LEFT JOIN userLogin as nurse_table ON nurse_table.userUniqueno = member_table.nurse_id 
                LEFT JOIN userLogin as qa_table ON qa_table.userUniqueno = member_table.qa_id 
                LEFT JOIN userLogin as coder_table ON coder_table.userUniqueno = member_table.coder_id 
				LEFT JOIN HRA_client as client_table ON client_table.clientId = member_table.client_id 
				LEFT JOIN userLogin as admin_table ON admin_table.userUniqueno = member_table.admin_idno
                LEFT JOIN hra_member_global_status AS member_global_status ON member_global_status.member_id = member_table.member_id";

			return $scheduler_member_sql_query;
	}
   
    /*
        NAME    : getMembers
        TYPE    : global Utiltiy function 
        DETAILS : get the member details based on tab id
        RETURN  : member details
    */
    public function getMembers($parameters,&$error)
    {
        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $parameters['planId'];
        $user_id = $parameters['userId'];
        $year = $parameters['year'];
        $min = $parameters['min'];
        $max = $parameters['max'];

        $tab_id = $parameters['tabId'];
        $base_sort_by = $parameters['baseSortBy'];
        $base_sort_order = $parameters['baseSortOrder']==0?'ASC':'DESC';
        $sort_by = $parameters['sortBy']; 
        $sort_order = $parameters['sortOrder']==0?'ASC':'DESC';

        $start = $min;
        $offset = $max - $min;

        $sql_global_member_query = array();


                if($tab_id==5){
            if(array_key_exists('planId',$parameters))
            {
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                        ReportGlobalMembers::convertToSortMemberSqlQuery(
                                        GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
                                        self::getNurseRequiredColumnAsString($tab_id)))
                                    );
            }
           else
            {
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                        ReportGlobalMembers::convertToSortMemberSqlQuery(
                                        GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
                                        self::getNurseRequiredColumnAsString($tab_id)))
                                    );
            }
        }else{
        if(array_key_exists('planId',$parameters))
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                    ReportGlobalMembers::convertToDefaultMemberSqlQuery(
                                    GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
                                    self::getNurseRequiredColumnAsString($tab_id)))
                                );
        }
        else
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                    ReportGlobalMembers::convertToDefaultMemberSqlQuery(
                                    GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
                                    self::getNurseRequiredColumnAsString($tab_id)))
                                );
        }
}

        
        //when invalid userid sent
        if(count($sql_global_member_query)==0) return FALSE; 

            //where clause array and condition
            $where_clause_contiditions = array();

            //to get this report assigned members where clause condition
            /*$my_member_filter['nurseIds']=$user_id;
            $my_member_filter['column']="nurse_id";
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn(UserRoleConstant::NURSE,$my_member_filter));*/
            //hra status based on tab
            $nurse_hralist = $this->tabHraCondition($tab_id);
            /*$where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));*/
			$nurse_hralist = $this->tabHraCondition($tab_id);
            switch($tab_id)
            {
                case '1':
                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,'('.GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist).' OR '.GlobalQueryBuilder::whereClauseReportQATabConditionQuery().')') ;
                break;
                case '2':
                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
                break;
                case '3':
 $getmemberlists = $this->getmemberslistids($plan_id,$year);
//echo $getmemberlists;die;

                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHomeAccessResultsTabConditionQuery($getmemberlists));
                break;
                case '4':
 $getmemberlists = $this->getmemberslistids($plan_id,$year);
                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHomeAccessResultsTabConditionQuery($getmemberlists));

                   // $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
                break;
                case '5':
                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($nurse_hralist));
                break;
                case '6':
                    $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseReportRefusalTabConditionQuery());
                break;
                default:
                break;
            }
            
            //if any valid where clause found append 'where'
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
            //if multiple where clause add 'and' else 'or' condition
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));
            //sort by query string
	    //$sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('nurse',$base_sort_by,$sort_by,$base_sort_order,$sort_order));
	    if($tab_id == 5 && $sort_by == 'overridescheduledate'){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('nurse',$base_sort_by,'overridescheduledatereportstatus',$base_sort_order,$sort_order));
            }elseif($tab_id == 1 && $sort_by == 'overridescheduledate'){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('nurse',$base_sort_by,'overridescheduledatehrastatus',$base_sort_order,$sort_order));
            }else{
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('nurse',$base_sort_by,$sort_by,$base_sort_order,$sort_order));
            }
            //limit by range
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT ?,? ");
             
            //genarated query
            $generated_query = implode($sql_global_member_query);
           
           //echo $generated_query;exit();
                if($conn->connect_errno)
                {
                    $error="database connection failed";
                }

                //prepare the member query
                $member_query=$conn->prepare($generated_query);
                if($member_query===FALSE)
                {
                    $error = "error preparing sql query";
                    return FALSE;
                }
                //bind parameters
                $member_query->bind_param('ii',$start,$offset);
               
                if($member_query === FALSE)
                {
                    $error="parameter error";
                    return FALSE;
                }

                $member_query->execute();

                if($member_query === FALSE)
                {
                    $error="error in sql query";
                    return FALSE;
                }

            $member_query_result = $member_query->get_result();
           if($tab_id == 1){
           //    echo "sd";die;
            ResponseUtility::echoJsonObject($this->queryResultResponseforqa($member_query_result,$error));
        }else{
            ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$error));

        }
           
          //  ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$error));

        return TRUE;
        
    }

    /*
        NAME    : tabHraCondition
        TYPE    : internal Utiltiy function 
        DETAILS : hra sttaus condition based on  tab id
        RETURN  : hra status array list
    */
    private function tabHraCondition($tab_id)
    {
        $nurse_hralist['hraStatus'] = null;
        //tab hra status condition
		
        switch($tab_id)
        {
            case '1':
                $nurse_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
                            [
                                MemberUtility::APPOINTMENT_CANCELLED,
                                MemberUtility::NO_SHOW,
                                MemberUtility::READY_FOR_QA,
                                MemberUtility::READY_FOR_CODER,
								MemberUtility::CLINICIAN_REVIEW_QA,
								MemberUtility::CLINICAIN_REVIEW_CODER,
								MemberUtility::READY_FOR_UPLOAD,
								MemberUtility::COMPLETED,
								MemberUtility::ASSESSMENT_CANCELLED
                            ],'_');
            break;

            case '2':
                $nurse_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
                            [
                                // MemberUtility::APPOINTMENT_CANCELLED,
                               // MemberUtility::NO_SHOW,
                                MemberUtility::READY_FOR_QA,
                                MemberUtility::READY_FOR_CODER,
								MemberUtility::CLINICIAN_REVIEW_QA,
								MemberUtility::CLINICAIN_REVIEW_CODER,
								MemberUtility::READY_FOR_UPLOAD,
								MemberUtility::COMPLETED
								//MemberUtility::ASSESSMENT_CANCELLED
                            ],'_');
            break;
    
            case '3':
                $nurse_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
                            [
                                MemberUtility::PATIENT_REFUSAL,
                                MemberUtility::UTC,
                                MemberUtility::READY_FOR_QA,
                                MemberUtility::READY_FOR_CODER,
                                MemberUtility::APPOINTMENT_CANCELLED,
                                MemberUtility::READY_FOR_UPLOAD,
                                MemberUtility::COMPLETED,
                                MemberUtility::ASSESSMENT_CANCELLED,
                                MemberUtility::IN_ELIGIBILE,
                                MemberUtility::DECEASED,
                                MemberUtility::HOSPICE,
                                MemberUtility::OTHER,
                                MemberUtility::TERM_EXPIRED,
                                MemberUtility::NO_SHOW

                            ],'_');    
                break;

                case '4':
                    $nurse_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
                            [
                                MemberUtility::CLINICIAN_REVIEW_QA,
                                MemberUtility::CLINICAIN_REVIEW_CODER
                            ],'_');    
                break;
				case '5':
                $nurse_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
                            [
                                MemberUtility::UNSCHEDULED,
                                MemberUtility::SCHEDULED,
                                MemberUtility::IN_PROGRESS,
                                MemberUtility::APPOINTMENT_CANCELLED,
								MemberUtility::PATIENT_REFUSAL,
								MemberUtility::UTC,
								MemberUtility::READY_FOR_QA,
								MemberUtility::READY_FOR_CODER,
								MemberUtility::CLINICIAN_REVIEW_QA,
								MemberUtility::CLINICAIN_REVIEW_CODER,
								MemberUtility::READY_FOR_UPLOAD,
								MemberUtility::COMPLETED,
								MemberUtility::ASSESSMENT_CANCELLED,
								MemberUtility::PRE_SCHEDULED,
								MemberUtility::IN_ELIGIBILE,
								MemberUtility::DECEASED,
								MemberUtility::HOSPICE,
								MemberUtility::OTHER,
								MemberUtility::TERM_EXPIRED,
								MemberUtility::NO_SHOW,
								MemberUtility::HRA_NOT_DUE
                            ],'_');
            break;
			case '6':
                $nurse_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
                            [
                                MemberUtility::UTC,
                                MemberUtility::READY_FOR_QA,
                                MemberUtility::READY_FOR_CODER,
                                MemberUtility::CLINICIAN_REVIEW_QA,
								MemberUtility::CLINICAIN_REVIEW_CODER,
								MemberUtility::READY_FOR_UPLOAD,
								MemberUtility::COMPLETED
                            ],'_');
            break;

                default:
                    $nurse_hralist['hraStatus'] = ArrayUtility::convertArrayToString(
                            [
                                MemberUtility::UNSCHEDULED,
                                MemberUtility::SCHEDULED
                            ],'_');
        }

        return $nurse_hralist;
        
    }

   
}


?>
