<?php

    require_once("../TimeZone.php");
    require_once("../utility/DataBaseUtility.php");
    require_once("../member/MemberUtility.php");
    /*
        CALSS : REPORT STATUS
	*/
	class ReportStatus
	{

        //LIST OF REPORT STATUS
        const UNSCHEDULED = -1;//unused status
        const SCHEDULED  = 0;//Scheduled
        const DEAD_AIR  = 1; //Dead Air
        const IN_ELIGIBLE  = 2; //Ineligible
        const NO_ANSWER  = 3; //No Answer NOT NEED
        const LEFT_VOICEMAIL=4;//LVM
        const MAILBOX_FULL=5; //Mailbox Full
        const NO_VM_SETUP=6; //No Vm Setup
        const WRONG_NUMBER  = 7; //Wrong Number
        const DECEASED  = 8; //Deceased
        const CALLBACK_REQUESTED  = 9; //Call Back
        const F2F_CALLBACK = 10; //F2F Call Back
        const LINE_BUSY  = 11;//Line Busy
        const HOSPICE  = 12; //Hospice
        const REFUSAL  = 13; //Refusal
        const DISCONNECTED  = 14;//Disconnected
        const OTHER  = 15; //Other 
        const RESCHEDULED  = 16;//Rescheduled
        const CALLER_DISCONNECTED = 17;//Caller Disconnected
        const CANCELLED = 18;//Cancellation
        const UTC = 19; //UTC
        const COMPLETED=20;//Completed
        const PENDING = 21;//Pending
        const TERMED = 22; //TERMED
        const VIRTUAL_NO_SHOW=23;//NO SHOW AND VISIT TYPE IS VIRTUAL
        const F2F_NO_SHOW=24;//NO SHOW AND VISIT TYPE IS In Person

        /*
            NAME 	: updateReportStatus
            TYPR 	: api pulbic function
            DETAILS : 		 
            RETURN 	: 
	    */
        public static function updateReportStatus($client_id,$year,$member_id,$report_status_text)
        {
            if(isset($report_status_text))
            {
                TimeZone::useTimeZone();
		        $import_date = date('m-d-Y H:i:s'); 
                //report status 
                $report_status_text = trim($report_status_text);
                $report_status_array['status'] = self::GetStringToStatus($report_status_text);
                $report_status_array['text'] = $report_status_text;
                $report_status_array['method'] = "import";
                $report_status_array['date'] = $import_date;
                $report_status_json = json_encode($report_status_array);
                $column_name_list =['reportStatus'];
                $column_value_list=[$report_status_json];
                DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
            }
        }

        /*
            NAME 	: updateReportStatusByEnum
            TYPR 	: public utility function
            DETAILS : 		 
            RETURN 	: 
	    */
        public static function updateReportStatusByEnum($client_id,$year,$member_id,$report_status_index)
        {
            TimeZone::useTimeZone();
		    $update_date = date('m-d-Y H:i:s'); 

            $report_status_array['status'] = $report_status_index;
            $report_status_array['text'] = self::GetStatusToString($report_status_index);
            $report_status_array['method'] = "api";
            $report_status_array['date'] = $update_date;
            $report_status_json = json_encode($report_status_array);
//print_r($report_status_json);die;

            $column_name_list =['reportStatus'];
            $column_value_list=[$report_status_json];
            DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
            
        }

         /*
            NAME 	: GetStatusToString
            TYPR 	:  public utility function
            DETAILS : 		 
            RETURN 	: 
	    */
        public static function GetStatusToString($report_status)
        {
            $report_status_string = null;
            switch($report_status)
            {
                case self::UNSCHEDULED: $report_status_string = ""; break;//Blank
                case self::SCHEDULED: $report_status_string = "Scheduled"; break;//Scheduled
                case self::DEAD_AIR: $report_status_string = "Dead Air"; break;//Dead Air
                case self::IN_ELIGIBLE: $report_status_string = "Ineligible"; break;//Ineligible
                case self::NO_ANSWER: $report_status_string = "No Answer"; break;//No Answer
                case self::LEFT_VOICEMAIL: $report_status_string = "LVM"; break;//LVM
                case self::MAILBOX_FULL: $report_status_string = "Mailbox Full"; break; //Mailbox Full
                case self::NO_VM_SETUP: $report_status_string = "No Vm Setup"; break; //No Vm Setup
                case self::WRONG_NUMBER: $report_status_string = "Wrong Number"; break; //Wrong Number
                case self::DECEASED : $report_status_string = "Deceased"; break; //Deceased
                case self::CALLBACK_REQUESTED : $report_status_string = "Call Back"; break; //Call Back
                case self::F2F_CALLBACK: $report_status_string = "F2F Call Back"; break; //F2F Call Back
                case self::LINE_BUSY : $report_status_string = "Line Busy"; break;;//Line Busy
                case self::HOSPICE : $report_status_string = "Hospice"; break; //Hospice
                case self::REFUSAL : $report_status_string = "Refusal"; break; //Refusal
                case self::DISCONNECTED : $report_status_string = "Disconnected"; break;//Disconnected
                case self::OTHER: $report_status_string = "Other"; break;//Other
                case self::RESCHEDULED: $report_status_string = "Rescheduled"; break;//Rescheduled
                case self::CALLER_DISCONNECTED : $report_status_string = "Caller Disconnected"; break;//Caller Disconnected
                case self::CANCELLED : $report_status_string = "Cancellation"; break;//Cancellation
                case self::UTC : $report_status_string = "UTC"; break;//UTC
                case self::COMPLETED: $report_status_string = "Completed"; break;//Completed
                case self::PENDING : $report_status_string = "Pending"; break;//Pending
                case self::TERMED : $report_status_string = "Termed"; break; //TERMED
                case self::VIRTUAL_NO_SHOW: $report_status_string = "Virtual No Show"; break;//Virtual No Show
                case self::F2F_NO_SHOW: $report_status_string = "F2F No Show"; break;//F2F No Show
            }

            return $report_status_string;
        }

        /*
            NAME 	: GetStringToStatus
            TYPR 	:  public utility function
            DETAILS : 		 
            RETURN 	: 
	    */
        public static function GetStringToStatus($report_status_text)
        {
            $report_status = -1;
            switch($report_status_text)
            {
                case "": $report_status=self::UNSCHEDULED ; break;
                case "Unscheduled": $report_status=self::UNSCHEDULED ; break;
                case "Scheduled": $report_status=self::SCHEDULED; break;//Scheduled
                case "Dead Air": $report_status=self::DEAD_AIR; break;//Dead Air
                case "Ineligible":$report_status=self::IN_ELIGIBLE; break;//Ineligible
                case "No Ansnwer":$report_status=self::NO_ANSWER; break;//No Answer
                case "LVM": $report_status=self::LEFT_VOICEMAIL; break;//LVM
                case "Mailbox Full":$report_status=self::MAILBOX_FULL; break; //Mailbox Full
                case "No Vm Setup": $report_status=self::NO_VM_SETUP; break; //No Vm Setup
                case "Wrong Number": $report_status=self::WRONG_NUMBER; break; //Wrong Number
                case "Deceased": $report_status=self::DECEASED; break; //Deceased
                case "Call Back": $report_status=self::CALLBACK_REQUESTED; break; //Call Back
                case "F2F Call Back": $report_status=self::F2F_CALLBACK; break; //F2F Call Back
                case "Line Busy": $report_status=self::LINE_BUSY; break;;//Line Busy
                case "Hospice": $report_status=self::HOSPICE; break; //Hospice
                case "Refusal": $report_status=self::REFUSAL; break; //Refusal
                case "Disconnected":$report_status=self::DISCONNECTED; break;//Disconnected
                case "Other":$report_status=self::OTHER; break;//Other
                case "Rescheduled": $report_status=self::RESCHEDULED; break;//Rescheduled
                case "Caller Disconnected":$report_status=self::CALLER_DISCONNECTED; break;//Caller Disconnected
                case "Cancellation":$report_status=self::CANCELLED; break;//Cancellation
                case "UTC":$report_status=self::UTC; break;//UTC
                case "Completed": $report_status=self::COMPLETED ; break;//Completed
                case "Pending":$report_status=self::PENDING ; break;//Pending
                case "TERMED":$report_status=self::TERMED; break; //TERMED
                case "Termed":$report_status=self::TERMED; break; //TERMED
                case "Virtual No Show":$report_status=self::VIRTUAL_NO_SHOW; break;//Virtual No Show
                case "F2F No Show":$report_status=self::F2F_NO_SHOW; break;//F2F No Show
            }

            return $report_status;
        }

         /*
            NAME 	: FoundString
            TYPR 	:  public utility function
            DETAILS : 		 
            RETURN 	: 
	    */
        public static function FoundString($string_value,$possbile_list_array)
        {
            foreach($possbile_list_array as $p_str)
            {
                if(stripos($string_value,$p_str) !==false)
                {
                   return true;
                }
            }

            return false;
        }

        /*
            Created By : Ramya T
            Created on : 09-06-2022
            Use : to save all report statuses
        */
        public static function OnAddReportStatusHistory($client_id,$year,$member_id,$report_status)
		{
			include("../db.php");
            MemberUtility::OnReportStatusHraStatusUpdate($client_id,$year,$member_id,$report_status,"",0);
            
			$report_status_history="";
            $reportStatus = "";
			$report_status_history_array=NULL;
			$report_status_history_query = "select * from HRA_member_".$client_id.'_'.$year." where member_id='$member_id'";
			$db_success = false;
			try
			{
				$report_status_history_query_result=mysqli_query($conn,$report_status_history_query);
				if(mysqli_num_rows($report_status_history_query_result) == 1)
				{
					$hra_history_row=mysqli_fetch_array($report_status_history_query_result,MYSQLI_ASSOC);
					$report_status_history = $hra_history_row['reportStatusHistory'];
                    $reportStatus = $hra_history_row['reportStatus'];
					$db_success=true;
				}
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				$db_success=false;
			}

			//if hra status history is null or empty
			if($report_status_history=="" || $report_status_history==NULL )
			{
				$report_status_history =  '{ 
					"unschedule":[],"scheduled":[],"deadAir":[],
					"inEligible":[],"noAnsnwer":[],"LVM":[],"mailboxFull":[],
					"noVmSetup":[],"wrongNumber":[],"deceased":[],"callBackRequested":[],
					"f2fCallBack":[],"lineBusy":[],"hospice":[],"refusal":[],
					"disconnected":[],"other":[],"rescheduled":[],"callerDisconnected":[],"cancellation":[],"utc":[],
                    "completed":[],"pending":[],"termed":[],"virtualNoShow":[],"f2fNoShow":[]
					}';
			}
            $report_status_history_array = json_decode($report_status_history, true);
            $report_status_array = json_decode($reportStatus,true);
            //print_r($report_status_array);exit;
			TimeZone::useTimeZone();
			$current_date_time = date("Y-m-d")."T".date("H:i");
            //if custom date format set 
            if($custom_date_time && isset($custom_date_time))
            {
                $current_date_time = $custom_date_time;
            }
            
            
			$report_status_new_history = array("status" => $report_status_array['status'] , "text" => $report_status_array['text'],"method" => $report_status_array['method'],"date"=>$current_date_time);
		
				switch ( $report_status )
				{	
                    
                        case self::UNSCHEDULED:
                            array_push($report_status_history_array['unschedule'], $report_status_new_history);
                        break;

						case self::SCHEDULED:
                            $last_array = end($report_status_history_array['scheduled']);
                            if($last_array['date'] != $current_date_time){
                                array_push( $report_status_history_array['scheduled'], $report_status_new_history );
                            }							break;

						case self::DEAD_AIR:
							array_push( $report_status_history_array['deadAir'], $report_status_new_history );
						break;

						case self::IN_ELIGIBLE:
							array_push( $report_status_history_array['inEligible'], $report_status_new_history );
						break;

						case self::NO_ANSWER:
							array_push( $report_status_history_array['noAnsnwer'], $report_status_new_history );
						break;

                        case self::LEFT_VOICEMAIL: 
							array_push( $report_status_history_array['LVM'], $report_status_new_history );
						break;
                        
                        case self::MAILBOX_FULL:
                            array_push( $report_status_history_array['mailboxFull'], $report_status_new_history );
                        break;

                        case self::NO_VM_SETUP:
                            array_push( $report_status_history_array['noVmSetup'], $report_status_new_history );
                        break;

                        case self::WRONG_NUMBER:
                            array_push( $report_status_history_array['wrongNumber'], $report_status_new_history );
                        break;

                        case self::DECEASED:
                            array_push( $report_status_history_array['deceased'], $report_status_new_history );
                        break;

                        case self::CALLBACK_REQUESTED:
                            array_push( $report_status_history_array['callBackRequested'], $report_status_new_history );
                        break;

                        case self::F2F_CALLBACK:
                            array_push( $report_status_history_array['f2fCallBack'], $report_status_new_history );
                        break;

                        case self::LINE_BUSY:
                            array_push( $report_status_history_array['lineBusy'], $report_status_new_history );
                        break;

                        case self::HOSPICE:
							array_push( $report_status_history_array['hospice'], $report_status_new_history );
						break;

                        case self::REFUSAL:
							array_push( $report_status_history_array['refusal'], $report_status_new_history );
						break;

                        case self::DISCONNECTED:
							array_push( $report_status_history_array['disconnected'], $report_status_new_history );
						break;

                        case self::OTHER:
							array_push( $report_status_history_array['other'], $report_status_new_history );
						break;

                        case self::RESCHEDULED:
                            $last_array = end($report_status_history_array['rescheduled']);
                            if($last_array['date'] != $current_date_time){
							    array_push( $report_status_history_array['rescheduled'], $report_status_new_history );
                            }						break;

						case self::CALLER_DISCONNECTED:
							array_push( $report_status_history_array['callerDisconnected'], $report_status_new_history );
						break;

						case self::CANCELLED:
							array_push( $report_status_history_array['cancellation'], $report_status_new_history );
						break;

                        case self::UTC: 
							array_push( $report_status_history_array['utc'], $report_status_new_history );
						break;

                        case self::COMPLETED:
							array_push( $report_status_history_array['completed'], $report_status_new_history );
						break;
                        
						case self::PENDING:
							array_push( $report_status_history_array['pending'], $report_status_new_history );
						break;

                        case self::TERMED:
							array_push( $report_status_history_array['termed'], $report_status_new_history );
						break;

						case self::VIRTUAL_NO_SHOW:
							array_push( $report_status_history_array['virtualNoShow'], $report_status_new_history );
						break;

						case self::F2F_NO_SHOW:
							array_push( $report_status_history_array['f2fNoShow'], $report_status_new_history );
						break;
				}

            // echo json_encode($report_status_history_array);exit;
			//return array("success"=>$db_success , "updatedJsonHistory"=>json_encode($report_status_history_array),"date"=>$current_date_time);
            $report_status_history_json = json_encode($report_status_history_array);
            $column_name_list =['reportStatusHistory'];
            $column_value_list=[$report_status_history_json];
            DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
		}

	}


?>