<?php

    /*
        REPORT RELATED UTILTIY CALSS AND GLOBAL FUNCTIONS
    */

	require_once("../TimeZone.php");

	
    class ReportUtility
    {

        /*
            NAME : sentToAvility
            DETAILS : sent to avility api definition
            REQUEST FORMAT:
			sample request body json format
			{
				"data":
				{
					"clientId":"client_001",
					"year" : "2020",
					"memberIds":[
							"11002711",
							"11002711"
						],
					"sentToAvility":"23-11-2020 04:45:54"
				}
			}
		*/
		public function sentToAvility($client_id,$year,$member_id_array,$date)
		{

			include("../db.php");

			//total member ids sent count
			$total_member_count = count($member_id_array);

			//implode array values in to string with single quotes
			$array_of_member_ids_string = "'".implode("', '", $member_id_array)."'";
			try
			{
				//find the members record count to identify wrong member id if any
				$member_records_query = "select * from HRA_member_".$client_id.'_'.$year." where member_id IN ($array_of_member_ids_string)";
				$member_records_query_result=mysqli_query($conn,$member_records_query);
				$member_record_count = mysqli_num_rows($member_records_query_result);
			
				//update members sent to avility date 
				$update_set_to_avility_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET `sentToAvility` = '$date' WHERE `member_id` IN ($array_of_member_ids_string)";
				$updated_response = NULL;
				$updated_result=mysqli_query($conn,$update_set_to_avility_query);
				$updated_response = mysqli_affected_rows($conn);
				
				if($updated_response)
				{
					$response = new stdClass();
					$response->status = "success";
					$response->totalmemberidssent = $total_member_count;
					$response->totalmemberidsupdate = $member_record_count;
					if($total_member_count!=$member_record_count){$response->error = "but some invalid member ids";}
					$response = json_encode($response);
				}
				else
				{
					$response = new stdClass();
					if($total_member_count!=$member_record_count)
					{
						$response->status = "failed";
						$response->error = "some invalid member ids";
					}
					else
					{
						$response->status = "success";
						$response->message = "no change in date value";
					}
					$response->totalmemberidssent = $total_member_count;
					$response->totalmemberidsupdate = $updated_response;
					$response = json_encode($response);
				}

				echo $response;
						
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				echo $error;
			}
	
		}

		/*
            NAME : invoiceDate
            DETAILS : set invoice date to list of members 
            REQUEST FORMAT:
			sample request body json format
			{
				"data":
				{
					"clientId":"client_001",
					"year" : "2020",
					"memberIds":[
							"11002711",
							"11002711"
						],
					"invoiceDate":"23-11-2020 04:45:54"
				}
			}
			
		*/
		public function invoiceDate($client_id,$year,$member_id_array,$date)
		{
			
			include("../db.php");

			//total member ids sent count
			$total_member_count = count($member_id_array);
			//implode array values in to string with single quotes
			$array_of_member_ids_string = "'".implode("', '", $member_id_array)."'";
			try
			{
				//find the members record count to identify wrong member id if any
				$member_records_query = "select * from HRA_member_".$client_id.'_'.$year." where member_id IN ($array_of_member_ids_string)";
				$member_records_query_result=mysqli_query($conn,$member_records_query);
				$member_record_count = mysqli_num_rows($member_records_query_result);
			
				//update members invoice date 
				$update_invoice_date_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET `invoiceDate` = '$date' WHERE `member_id` IN ($array_of_member_ids_string)";
				$updated_response = NULL;
				$updated_result=mysqli_query($conn,$update_invoice_date_query);
				$updated_response = mysqli_affected_rows($conn);
				
				if($updated_response)
				{
					$response = new stdClass();
					$response->status = "success";
					$response->totalmemberidssent = $total_member_count;
					$response->totalmemberidsupdate = $member_record_count;
					if($total_member_count!=$member_record_count){$response->error = "but some invalid member ids";}
					$response = json_encode($response);
				}
				else
				{
					$response = new stdClass();
					if($total_member_count!=$member_record_count)
					{
						$response->status = "failed";
						$response->error = "some invalid member ids";
					}
					else
					{
						$response->status = "success";
						$response->message = "no change in date value";
					}
					$response->totalmemberidssent = $total_member_count;
					$response->totalmemberidsupdate = $updated_response;
					$response = json_encode($response);
				}

				echo $response;
						
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				echo $error;
			}
	
		}

		/*
            NAME : reportNotes
            DETAILS :set report notes for a member
            REQUEST FORMAT:
			request body json format
			{
				"data":
				{
					"clientId":"client_001",
					"year":"2020",
					"memberId":"1100094',
					"notes":"notes for member"
				}
			}
			
		*/
		public function reportNotes($client_id,$year,$member_id,$notes_text)
		{
			
			try
			{
				$is_note_updated=$this->addReportNote($client_id,$year,$member_id,$notes_text);			
				if($is_note_updated)
				{
					$response = new stdClass();
					$response->status = "success";
					$response = json_encode($response);
				}
				else
				{
					$response = new stdClass();
					$response->status = "failed";
					$response = json_encode($response);
				}
				echo $response;			
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				echo $error;
			}
	
		}

		/*
            NAME : addReportNote
            DETAILS : internal utility function for report notes api call
			        to append report json field everytime reportNotes api called 
			RETURN :
		*/
		private function addReportNote($client_id,$year,$member_id,$notes_text)
		{

			include("../db.php");
			
			$report_notes=NULL;
			$report_notes_array=NULL;
			$member_query = "select * from HRA_member_".$client_id.'_'.$year." where member_id='$member_id'";
			$is_member = false;
			try
			{
				$member_query_result=mysqli_query($conn,$member_query);
				if(mysqli_num_rows($member_query_result) == 1)
				{
					$member_row=mysqli_fetch_array($member_query_result,MYSQLI_ASSOC);
					$report_notes = $member_row['reportNotes'];
					$is_member=true;
				}
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				$is_member=false;
			}

			if($is_member)
			{
				if($report_notes==NULL || $report_notes=="")
				{
					$report_notes='{ }';
				}
				//decode the report notes into array
				$report_notes_array = json_decode($report_notes, true);
				//get the current time
				TimeZone::useTimeZone();
				$current_date_time = date("Y-m-d")."T".date("H:i");
				//report note array keys ans values
				$new_report_note = array("date"=>$current_date_time,"text"=>$notes_text);
				array_push( $report_notes_array, $new_report_note );
				$updated_report_notes_array=json_encode($report_notes_array);
				//update report notes sql query 
				$update_report_notes_query = "update HRA_member_".$client_id.'_'.$year." SET reportNotes='$updated_report_notes_array' WHERE `member_id` = '$member_id'";
				$update_report_notes_query_result = NULL;
				try 
				{
					$update_report_notes_query_result=mysqli_query($conn,$update_report_notes_query);
					if($update_report_notes_query_result)
					{
						return true;
					}
					else
					{	
						return false;
					}	
				}
				catch (Exception $e)
				{
					$error = $e->getMessage();
					return false;
				}

			}

			return false;

		}

		/*
            NAME : clearReportNotes
            DETAILS :utilty function to clear the reportNotes data
			        with the condition when call log api called
			RETURN :
		*/
		public  function clearReportNotes($client_id,$year,$member_id)
		{
				include("../db.php");
				$update_report_notes_query = "update HRA_member_".$client_id.'_'.$year." SET reportNotes=NULL WHERE `member_id` = '$member_id'";
				$update_report_notes_query_result = NULL;
				try 
				{
					$update_report_notes_query_result=mysqli_query($conn,$update_report_notes_query);
					if($update_report_notes_query_result)
					{
						return true;
					}
					else
					{	
						return false;
					}	
				}
				catch (Exception $e)
				{
					$error = $e->getMessage();
					return false;
				}

				return false;
		}

    }

?>