<?php

/*
	SCHEDULER GLOBAL API 
	Created On : 08/18/2021
*/

//access control allow Header 
include("../AccessControlAllowHeader.php");

//other include files
require_once("../utility/JwtUtility.php");
require_once("../TimeZone.php");
require_once("SchedulerApiClass.php");
require_once("SchedulerGlobalMembers.php");
require_once("../global/GlobalHelper.php");

//validate token
$token_validation_result = JwtUtility::isValidToken();
if($token_validation_result !== JwtUtility::VALID_TOKEN)
{     
	//un authorized access 
    JwtUtility::exitWithUnAuthorizedResponse($token_validation_result);
}
//end of token validation

//create Scheduler api definition object
$scheduler_global_members = new SchedulerGlobalMembers;
//parse the request 
$method = $_SERVER['REQUEST_METHOD'];
$requestedurl = $_SERVER['REQUEST_URI'];
$arrayurlstring = explode("/",$requestedurl);
$crcount = count($arrayurlstring);
$crcountt = $crcount -1;
$requestMethod = $arrayurlstring[$crcountt];
$exploded = explode("?",$requestMethod);
$requestMethod = $exploded[0];

  switch ($method) {

        case 'POST':
            switch($requestMethod)
            {
                case "assign":
                    $scheduler_api = new SchedulerApiClass;
                    $scheduler_api->assignSchedulerToGlobalMembers();
                break;

                case "unAssign":
                    $scheduler_api = new SchedulerApiClass;
                    $scheduler_api->unAssignSchedulerToGlobalMembers();
                break;
            }
        break;

	   case 'GET' :
            switch($requestMethod)
            {
                case 'Members':
                    $parameters=[];
                    //must params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('year',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('min',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('max',$parameters);
                    //is my member
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('isMyMember',$parameters);
                    //assign and unassigned params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('assigned',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('unAssigned',$parameters);
                    //sort params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortBy',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortOrder',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('sortBy',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('sortOrder',$parameters);
                    //call api
                    $error="";
                    if(GlobalHelper::isDefaultValidParameter($parameters))
                    {
                        if($scheduler_global_members->getMembers($parameters,$error)) { exit();}
                    }
                    
                    GlobalHelper::echoFailedResponse($error);
                break;

                case 'DisabledMembers':
                    $parameters=[];
                    //must params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('year',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('min',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('max',$parameters);
                    //is my member
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('isMyMember',$parameters);
                    //sort params
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortBy',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortOrder',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('sortBy',$parameters);
                    $parameters= ArrayUtility::appendIfVaildUrlParameter('sortOrder',$parameters);
                    //call api
                    $error="";
                    if(GlobalHelper::isDefaultValidParameter($parameters))
                    {
                        if($scheduler_global_members->getDisableMembers($parameters,$error)) { exit();}
                    }
                    
                    GlobalHelper::echoFailedResponse($error);
                break;

                case "Search":
                    $search_parameters =[];
                    //must params
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('year',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('min',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('max',$search_parameters);
                    //is my member
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('isMyMember',$search_parameters);
                    //assign and unassigned params
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('assigned',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('unAssigned',$search_parameters);
                    //optional search params
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('firstname',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('lastname',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('id',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('city',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('zip',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('plan',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('program',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('lob',$search_parameters);
                    //sort param
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortBy',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortOrder',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('sortBy',$search_parameters);
                    $search_parameters= ArrayUtility::appendIfVaildUrlParameter('sortOrder',$search_parameters);
                    //call api
                    $error="";
                    if(GlobalHelper::isDefaultValidParameter($search_parameters))
                    {
                        if($scheduler_global_members->search($search_parameters,$error))  { exit();}
                    }
                   
                    GlobalHelper::echoFailedResponse($error);
                break;

                case 'Filter':
                    $filter_parameters =[];
                    //must params
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('planId',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('userId',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('year',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('min',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('max',$filter_parameters);
                    //is my member
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('isMyMember',$filter_parameters);
                    //assign and unassigned params
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('assigned',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('unAssigned',$filter_parameters);
                    //optional filter parameters
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('scheduledFrom',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('scheduledTo',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('clientId',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('hraStatus',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('visitType',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('nurseIds',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('qaIds',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('coderIds',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('schedulerIds',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('callResult',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('status',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('screening',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('callBackStatus',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('callBackDateFrom',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('callBackDateTo',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('nextOutreachCallBackFromDate',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('nextOutreachCallBackToDate',$filter_parameters);

                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('city',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('plan',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('program',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('lob',$filter_parameters);
                    //individual screening condition
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('screening_0',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('screening_1',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('screening_2',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('screening_3',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('screening_4',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('screening_5',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('screening_6',$filter_parameters);
                    //sort params
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortBy',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('baseSortOrder',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('sortBy',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('sortOrder',$filter_parameters);
                    $filter_parameters = ArrayUtility::appendIfVaildUrlParameter('isDisabledMember',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('screeningIha',$filter_parameters);
                    //search params by suresh
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('firstname',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('lastname',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('id',$filter_parameters);
                    $filter_parameters= ArrayUtility::appendIfVaildUrlParameter('zip',$filter_parameters);

                    //call api
                    $error="";
                    if(GlobalHelper::isDefaultValidParameter($filter_parameters))
                    {
                        if($scheduler_global_members->filter($filter_parameters,$error)) { exit();}
                    }
                    
                    GlobalHelper::echoFailedResponse($error); 
                break;
            }
        break;

  }


?>