<?php

/*
	SCHEDULER API 
	Created On : 03/10/2020 
*/

//access control allow Header 
include("../AccessControlAllowHeader.php");

//other include files
require_once("../utility/JwtUtility.php");
require_once("../TimeZone.php");
require_once("SchedulerApiClass.php");


//validate token
$token_validation_result = JwtUtility::isValidToken();
if($token_validation_result !== JwtUtility::VALID_TOKEN)
{     
	//un authorized access 
    JwtUtility::exitWithUnAuthorizedResponse($token_validation_result);
}
//end of token validation

//create Scheduler api definition object
$scheduler = new SchedulerApiClass;
//parse the request 
$method = $_SERVER['REQUEST_METHOD'];
$requestedurl = $_SERVER['REQUEST_URI'];
$arrayurlstring = explode("/",$requestedurl);
$crcount = count($arrayurlstring);
$crcountt = $crcount -1;
$requestMethod = $arrayurlstring[$crcountt];
$exploded = explode("?",$requestMethod);
$requestMethod = $exploded[0];

  switch ($method) {

        case 'POST':
            switch($requestMethod)
            {
                case 'assignSchedulerToMember' :
                    $client_id = $_GET['clientId'];
                    $year = $_GET['year'];
                    $member_id = $_GET['memberId'];
                    $scheduler_id = $_GET['schedulerId'];
                    $scheduler->assignSchedulerToMember($member_id,$scheduler_id,$client_id,$year);
				break;
				
				case 'assignSchedulerToMembers':
						$scheduler->assignSchedulerToMembers();
				break;

				case 'unAssignSchedulerToMembers':
						$scheduler->unAssignSchedulerToMembers();
				break;

				case 'importCallLog':
						$scheduler->importSchedulerLogDetailsFromExcel();
				break;
  
            }
        break;

	   case 'GET' :
            switch($requestMethod)
            {
                case 'getAllScheduler' :
                    $scheduler->getAllScheduler('scheduler');
				break;

				case 'getAllSchedulerLead' :
                    $scheduler->getAllScheduler('scheduler_lead');
                break;
                
                case 'getTotalMembersBySchedulerId' :
                    $client_id = $_GET['clientId'];
                    $year = $_GET['year'];
                    $scheduler_id = $_GET['schedulerId'];
					$scheduler->getTotalMembersBySchedulerId($client_id,$year,$scheduler_id);
				break;

				case 'getMembersBySchedulerId' :
                    $client_id = $_GET['clientId'];
					$year = $_GET['year'];
					$min = $_GET['min'];
					$max = $_GET['max'];
                    $scheduler_id = $_GET['schedulerId'];
					$scheduler->getMembersByScheduler($client_id,$year,$scheduler_id,$min,$max);
				break;
				
				case 'totalMembersBySchedulerId':
					$client_id = $_GET['clientId'];
                    $year = $_GET['year'];
                    $scheduler_id = $_GET['schedulerId'];
					$scheduler->totalMembersBySchedulerId($client_id,$year,$scheduler_id);
				break;
            }
        break;

  }
?>