<?php

/*
	SCHEDULER API CALSS DEFINITIONS  
*/

//other include files
require_once("../utility/JwtUtility.php");
require_once("../TimeZone.php");
require_once("../member/MemberUtility.php");
require_once("../utility/DataBaseUtility.php");
require_once("../utility/DateUtility.php");
require_once("SchedulerUtility.php");
require_once("../report/ReportStatus.php");
require_once("../global/GlobalMemberStatus.php");
require_once("../scheduler/SchedulerCallOrderUtility.php");

class SchedulerApiClass { 

	/*
        NAME    : assignSchedulerToMember
        TYPE    : api utility function   
        DETAILS : assign scheduler id to a  member
        RETURN  : 
    */
	public function assignSchedulerToMember($member_id,$scheduler_id,$client_id,$year)
	{
        //include database 
		include("../db.php");
		
		$member_query = "select * from HRA_member_".$client_id.'_'.$year." where member_id='$member_id'";
		try 
		{

			$member_query_result=mysqli_query($conn,$member_query);
			if(mysqli_num_rows($member_query_result) == 1)
			{
				$update_scheduler_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET `scheduler_id` = '$scheduler_id' WHERE `member_id` = '$member_id'";
				$updated_response = NULL;
				try 
				{
					$updated_result=mysqli_query($conn,$update_scheduler_query);
					$updated_response = mysqli_affected_rows($conn);
					if($updated_response)
					{
						$response = new stdClass();
						$response->status = "scheduler assigned";
						$response = json_encode($response);
					}
					else
					{
						$response = new stdClass();
						$response->status = "same scheduler id assigned";
						$response = json_encode($response);
					}
					
				}
					catch (Exception $e){
					$error = $e->getMessage();
					echo $error;
				}
				
				echo $response;
			}
			else
			{
				$response = new stdClass();
				$response->status = "member not found";
				$response = json_encode($response);
				echo $response;
			}
		}
		catch (Exception $e)
		{
			$error = $e->getMessage();
			echo $error;
		}
	}

	
	/*
        NAME    : assignSchedulerToMembers
        TYPE    : api utility function   
        DETAILS : assign scheduler to memebrs 
        RETURN  : 
		REQUEST BODY FORMAT :
			sample json body format
			{
					"clientId":"client_001",
					"year" : "2019",
					"assignDate":"2021-03-17T18:30:00",
					"schedulerLeadId":"12000340",
					"schedulerId":"22003432",
						"memberIds":[
							"11000031"
						]
			}
	*/
	public function assignSchedulerToMembers()
	{ 
		$assign_post_body_data  = file_get_contents("php://input");
		$post_memeber_array = json_decode($assign_post_body_data,true);
		
		$client_id = $post_memeber_array["clientId"];
		$year = $post_memeber_array["year"];
		
		TimeZone::useTimeZone();
		$custom_date_time = date('m-d-Y H:i:s'); 
		
		if (array_key_exists('assignDate',$post_memeber_array))
		{
			$assign_date=$post_memeber_array["assignDate"];
			if(DateUtility::validateScheduledDate($assign_date,'m-d-Y H:i:s'))
			{
				$custom_date_time = $post_memeber_array["assignDate"];
			}
		}
		
		//newly added scheduler lead id field
		$scheduler_lead_id=null;
		if (array_key_exists('schedulerLeadId', $post_memeber_array))
		{
			$scheduler_lead_id = $post_memeber_array["schedulerLeadId"];
		}
		$scheduler_id = $post_memeber_array["schedulerId"];
		$member_id_array = $post_memeber_array["memberIds"];
		//assign the scheduler to members
		$this->_assignSchedulerToMembers($client_id,$year,$scheduler_lead_id,$scheduler_id,$member_id_array,$custom_date_time);

	}

	/*
		NAME    : unAssignSchedulerToMembers
        TYPE    : api utility function   
        DETAILS : unassign scheduler to memebrs 
	*/
	public function unAssignSchedulerToMembers()
	{
		include("../db.php");

		$response = NULL;
		$assign_post_body_data  = file_get_contents("php://input");
		$post_memeber_array = json_decode($assign_post_body_data,true);
		
		$client_id = $post_memeber_array["clientId"];
		$year = $post_memeber_array["year"];
		$member_id_array = $post_memeber_array["memberIds"];
		//total member ids sent count
		$total_member_count = count($member_id_array);
		$array_of_member_ids_string = "'".implode("', '", $member_id_array)."'";

		try
		{
			//update members scheduler id
			$update_scheduler_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET `scheduler_id` = NULL WHERE `member_id` IN ($array_of_member_ids_string)";
			$updated_response = NULL;
			$updated_result=mysqli_query($conn,$update_scheduler_query);
			$updated_response = mysqli_affected_rows($conn);

			//invoke scheduler unassigned event for each member
			for($m=0;$m<$total_member_count;$m++)
			{
				$member_id = $member_id_array[$m];
				if(DataBaseUtility::isMemberAvailable($client_id,$year,$member_id))
				{
					$this->OnSchedulerUnAssignedEvent($client_id,$year,$member_id);
				}
			}

			if($updated_response)
			{
				$response = new stdClass();
				$response->status = "updated";
				$response = json_encode($response);
			}
			else
			{
				$response = new stdClass();
				$response->status = "not updated";
				$response = json_encode($response);
			}
		}
		catch (Exception $e)
		{
			$error = $e->getMessage();
			echo $error;
		}

		echo $response;

	}

	/*
            NAME 	: assignSchedulerLeadHimSelfToMember
            TYPR 	: non api pulbic function
			DETAILS : assign scheduler lead or scheduler him self as member scheduler  when create the call log
					  memebr has no scheduler id		 
			RETURN 	: response as array
	*/
	public function assignSchedulerLeadHimSelfToMember($client_id,$year,$member_id,$scheduler_lead_id,$scheduler_id,$custom_date_time=null)
	{
		//datatbase connection
		include("../db.php");
		$response = new stdClass();
		$db_result = false;
		try
		{
			//find the members record count to identify wrong member id if any
			$member_records_query = "select * from HRA_member_".$client_id.'_'.$year." where member_id = '$member_id'";
			$member_records_query_result=mysqli_query($conn,$member_records_query);
			$member_record_count = mysqli_num_rows($member_records_query_result);
			 
			if($member_record_count>0)
			{	
				//update the scheduler id of not assigned 
				$member_column_details = NULL;
				$member_column_details = mysqli_fetch_array($member_records_query_result,MYSQLI_ASSOC);
				if($member_column_details["scheduler_id"]==NULL)
				{
						//update members scheduler id
						$update_scheduler_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET `scheduler_id` = '$scheduler_id' WHERE `member_id` ='$member_id'";
						$updated_response = NULL;
						$updated_result = mysqli_query($conn,$update_scheduler_query);
				}
				
				//update only when valid scheduler lead id set
				if($scheduler_lead_id)
				{
					//update the scheduler details to each member
					$appended_result=$this->appendSchedulerDetails($client_id,$year,$member_id,$scheduler_lead_id,$scheduler_id,$custom_date_time);
					$db_result = $appended_result['success'];
					$scheduler_details = $appended_result['updated_scheduler_details'];
					if($db_result)
					{
						$this->OnSchedulerAssignedEvent($client_id,$year,$member_id,$scheduler_lead_id,$scheduler_id);
						$scheduler_details_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET 
														`schedulerDetails` = '$scheduler_details' WHERE `member_id`='$member_id'";
						$updated_result=mysqli_query($conn,$scheduler_details_query);	
					}
				}
			
				if($updated_result)
				{
					$response->status = "success";
					$response->dbstatus = $db_result;
				}
				else
				{
					$response->status = "failed";
					$response->dbstatus = $db_result;
				}
			}
			else
			{
				$response->status = "failed";
				$response->dbstatus = $db_result;
			}
					
		}
		catch (Exception $e)
		{
			$error = $e->getMessage();
			$response->status = "failed";
			$response->dbstatus = false;
			$response->error = $error;
		}

		return json_encode($response);
 
	}


	/*
        NAME 	: importSchedulerLogDetailsFromExcel
        TYPR 	: Api public function
		DETAILS : 		 
		RETURN 	: 
	*/
	public function importSchedulerLogDetailsFromExcel()
	{
		//datatbase connection
		include("../db.php");
		//
		//parse the request format
		$import_data_array = $this->parseImportRequestFormat();
		$client_id = $import_data_array["clientId"];
		$year = $import_data_array["year"];
		$member_id = $import_data_array["memberId"];
		$assign_date =  $import_data_array["assignDate"];
		$refusal_letter_date =  $import_data_array["refusalLetterDate"];
		$report_status_text =  $import_data_array["status"];
		$term_date =  $import_data_array["termDate"];
		$return_mail =  $import_data_array["returnMail"];

		$visit_type =  $import_data_array["visitType"];
		$schedule_date =  $import_data_array["scheduleDate"];
		$assessor_full_name =  $import_data_array["assessor"];
		//no show 
		$no_show = $import_data_array["noShow"];
		//get the member details
		//read the member hraStatus and scheduler details
		$member_details = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,["nurse_id","scheduleDate","VisitType","importTrackerDetails"]);
		$current_nusre_id = $member_details["nurse_id"];
		$current_schedule_date = $member_details["scheduleDate"];
		$current_visit_type = $member_details["VisitType"];
		//other import tracker details
		$import_tracker_details_json = $member_details["importTrackerDetails"];
		if($import_tracker_details_json==null)
		{
			$import_tracker_details=array("refusalLetterEligibility"=>'',"noShowReportStatus"=>'');
		}
		else
		{
			$import_tracker_details = json_decode($import_tracker_details_json,true);
		}
		$import_tracker_details['noShowReportStatus']=$no_show;
		
		//update refusal letter send date
			$refusal_letter_date = trim($refusal_letter_date);
			if(DateUtility::isValidateDateFormat($refusal_letter_date,'Y-m-d H:i:s'))
			{
				$column_name_list =['refusalLetterDate'];
				$column_value_list=[$refusal_letter_date];
				$import_tracker_details['refusalLetterEligibility']="";
				DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
			}
			else
			{
				$import_tracker_details['refusalLetterEligibility']=$refusal_letter_date;
				$column_name_list =['refusalLetterDate'];
				$column_value_list=[null];
				DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
			}
		//

		//update import tracker details in db
			$import_column_name_list =['importTrackerDetails'];
			$import_column_value_list=[json_encode($import_tracker_details)];
			DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$import_column_name_list,$import_column_value_list);
		//

		$scheduled_date_updated = false;
		//valid scheduled date format
		if(StringUtility::isValueSet($current_schedule_date)==false)
		{
			$valid_schedule_date = trim(str_replace('T','@',$schedule_date));
			if($valid_schedule_date && DateUtility::isValidateDateFormat($valid_schedule_date,'Y-n-j@H:i'))
			{
				if(strpos($schedule_date,'T')!==false)
				{
					DataBaseUtility::updateScheduleDate($client_id,$year,$member_id,$schedule_date);
					$scheduled_date_updated = true;
				}
			}
		}

		//update visit type
		$visit_type_updated = false;
		if(StringUtility::isValueSet($current_visit_type)==false)
		{
			DataBaseUtility::updateVisitType($client_id,$year,$member_id,$visit_type);
			$visit_type_updated = true;
		}

		//update assessor details
		$nurse_id_updated = false;
		if(StringUtility::isValueSet($current_nusre_id)==false)
		{
			if($assessor_full_name)
			{
				$assessor_name_array = explode(' ',trim($assessor_full_name));
				if(is_array($assessor_name_array))
				{
					if(count($assessor_name_array)==2)
					{
						//get user details from first name and last anme
						$user_details = DataBaseUtility::getUserIdByFullName($assessor_name_array[0],$assessor_name_array[1]);
						if($user_details)
						{
							$user_unique_id=$user_details['userUniqueno'];
							if($user_unique_id && is_numeric($user_unique_id))
							{
								$column_name_list =['nurse_id'];
								$column_value_list=[$user_unique_id];
								DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
								$nurse_id_updated = true;
							}
						}
					}
				}
			}
		}

		//import term date
		$term_date_status = MemberUtility::importTermDate($client_id,$year,$member_id,trim($term_date));

		//update newly added report result status captured in tracker sheet
		ReportStatus::updateReportStatus($client_id,$year,$member_id,$report_status_text);
		$report_status_index = ReportStatus::GetStringToStatus($report_status_text);
		ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,$report_status_index);
		//update call order - pending testing
		//SchedulerCallOrderUtility::setCallOrderWhenTrackerImport($client_id,$year,$member_id,$report_status_text);

		//update return mail
		$return_mail_status = null;
		if(isset($return_mail))
		{
			//return mail
			$return_mail_value = strtolower($return_mail);
			$status_value =  $return_mail_value=='yes'?1:0;
			if($status_value==1)
			{
				$global_member_status = new GlobalMemberStatus;
				$return_mail_status=$global_member_status->importStatus($client_id,$member_id,"return_mail",$status_value,GlobalMemberStatus::BOOL_STATUS_TYPE);
			}
		}

		$scheduler_details=null;
		if(array_key_exists("scheduler",$import_data_array))
		{
			/*$firstname = $import_data_array["scheduler"];
			$scheduler_details=DataBaseUtility::getUserDetailsByFirstNameAndType($firstname,"scheduler");
			//check for schedulerlead acted as scheduler
			if($scheduler_details==null)
			{
				$scheduler_details=DataBaseUtility::getUserDetailsByFirstNameAndType($firstname,"scheduler_lead");
			}*/

			$scheduler_name_array = $import_data_array["scheduler"];
			$scheduler_name_array = explode(' ',trim($scheduler_name_array));

			if(is_array($scheduler_name_array))
				{
					if(count($scheduler_name_array)==2)
					{
						$scheduler_details=DataBaseUtility::getUserDetailsByFirstNameLastNameAndType($scheduler_name_array[0],$scheduler_name_array[1],"scheduler");
						if($scheduler_details==null)
						{
							$scheduler_details=DataBaseUtility::getUserDetailsByFirstNameAndType($scheduler_name_array[0],"scheduler_lead");
						}
					}
				}
			//if admin user act as scheduler lead ? not implemented yet
			
		}

		$scheduler_lead_details=null;
		if(array_key_exists("schedulerLead",$import_data_array))
		{
			$firstname = $import_data_array["schedulerLead"];
			$scheduler_lead_details=DataBaseUtility::getUserDetailsByFirstNameAndType($firstname,"scheduler_lead");
			//if admin user acted as scheduler lead ? not implemented yet
			
		}

		$scheduler_call_log = null;
		$is_call_logs = false; //to validate empty call log or not
		if(array_key_exists("callLogDetails",$import_data_array))
		{
			$scheduler_call_log  = $import_data_array["callLogDetails"];

			if(array_key_exists('callLog',$scheduler_call_log))
			{
				$call_log_array = $scheduler_call_log['callLog'];
				if($call_log_array && is_array($call_log_array))
				{
					$call_log_count = count($call_log_array);
					if($call_log_count>0)
					{
						$is_call_logs =true;
					}
				}
			}
		}
		
		$response = new stdClass();
		$is_all_okay = ($scheduler_details && $scheduler_lead_details && $member_id && $scheduler_call_log && $is_call_logs);
		
		if($is_all_okay)
		{
			//update call log,scheduler id and 
			$db_result = false;
			try
			{
				$scheduler_id = $scheduler_details["userUniqueno"];
				$scheduler_username = $scheduler_details["username"];

				$scheduler_lead_id = $scheduler_lead_details["userUniqueno"];

				//find the members record count to identify wrong member id if any
				$member_records_query = "select * from HRA_member_".$client_id.'_'.$year." where member_id = '$member_id'";
				$member_records_query_result=mysqli_query($conn,$member_records_query);
				$member_record_count = mysqli_num_rows($member_records_query_result);
				//only update when valid member id present
				$updated_result = false;
				$db_result = false;
				if($member_record_count>0)
				{	
					//update the scheduler id is valid
					if($scheduler_id)
					{
						//update members scheduler id
						$update_scheduler_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET `scheduler_id` = '$scheduler_id' WHERE `member_id` ='$member_id'";
						$response->schedulerIdStatus = mysqli_query($conn,$update_scheduler_query);
					}
					
					//update only when valid scheduler lead id set
					if($scheduler_lead_id && $scheduler_id)
					{
						//Nullify the scheduler details before import
						$column_name_list =['schedulerDetails'];
						$column_value_list=[null];
						DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
						
						//update the scheduler details to each member
						$appended_result=$this->appendSchedulerDetails($client_id,$year,$member_id,$scheduler_lead_id,$scheduler_id,$assign_date);
						$db_result = $appended_result['success'];
						$updated_scheduler_details = $appended_result['updated_scheduler_details'];
						if($db_result)
						{
							$scheduler_details_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET 
															`schedulerDetails` = '$updated_scheduler_details'  WHERE `member_id`='$member_id'";
							$response->schedulerDetailsStatus=mysqli_query($conn,$scheduler_details_query);		
						}
					}

					
					//calculate number of call log count
					if(array_key_exists("callLog",$scheduler_call_log))
					{
						$call_log_count = count($scheduler_call_log['callLog']);
						if($call_log_count<=0) { $call_log_count=0;}
						MemberUtility::SetCallLogAttemptCount($client_id,$year,$member_id,$call_log_count);
					}

					//scheduler call log details updated
					if(array_key_exists("callLog",$scheduler_call_log) && array_key_exists("result",$scheduler_call_log))
					{

						//Nullify the scheduler call hra status before import
						$column_name_list =['schedulerCallHraStatus'];
						$column_value_list=[null];
						DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
						
						$member_details = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,["hraStatus"]);
						$hra_status_array = json_decode($member_details["hraStatus"],true);

						$scheduler_current_call_result = $scheduler_call_log["result"];
						$scheduler_current_call_result = is_numeric($scheduler_current_call_result)?$scheduler_current_call_result:-1;
						
						$call_logs = $scheduler_call_log["callLog"];
						//update call log 'scheduler' key with scheduler full name if properly set
						if(isset($scheduler_details["firstname"]) && isset($scheduler_details["lastname"]))
						{
							$scheduler_full_name = $scheduler_details["firstname"].' '.$scheduler_details["lastname"];
							//update call log with scheduler full name
							$call_logs = SchedulerUtility::updateCallLogField($scheduler_call_log["callLog"],"scheduler",$scheduler_full_name);	
							$scheduler_call_log["callLog"] = $call_logs;
						}

						//update scheduler hra call status
						$import_custom_data = array("hraUsername"=>$scheduler_username);

						SchedulerUtility::OnCallLogSchedulerCallHraStatus($client_id,$year,$member_id,$scheduler_current_call_result,
									$call_logs,$hra_status_array,false,$import_custom_data);
					}

					//update database 'scheduler' column update
					$response->status = true;
					$scheduler_call_log_json = json_encode($scheduler_call_log,true);
					$scheduler_details_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET `scheduler` = '$scheduler_call_log_json'  WHERE `member_id`='$member_id'";						
					$response->callLogStatus=mysqli_query($conn,$scheduler_details_query);
					//
					$response->returnMailStatus = $return_mail_status;
					$response->termDateUpdated = $term_date_status;
					$response->isMemberFound=true;
					$response->scheduledDateUpdated = $scheduled_date_updated;
					$response->nurseUpdated = $nurse_id_updated;
					$response->visitTypeUpdated = $visit_type_updated;
				}
				else
				{
					$response->status = false;
					$response->dbStatus = false;
					$response->isMemberFound=false;
				}
						
			}
			catch (Exception $e)
			{
				$error = $e->getMessage();
				$response->status = false;
				$response->dbStatus = false;
				$response->error = $error;
			}

		}
		else
		{
			$response->status = false;
			if($is_call_logs==false)
			{
				$response->callLogStatus=false;
				$response->error ="no call log information";
			}
			else
			{
				$response->error ="invalid scheduler or scheduler Lead name";
			}
		}

		echo json_encode($response);
 
	}


	/*
        NAME 	: importSchedulerFromExcel
        TYPR 	: internal utiltiy function
		DETAILS : parser for import request format		 
		RETURN 	: 
	*/
	private function parseImportRequestFormat()
	{
		
		$import_request_format = file_get_contents("php://input");
		$import_request_array = json_decode($import_request_format,true);
		
		$parsed_data_array = array();
		//array field value
		$parsed_data_array["clientId"] = $import_request_array["clientId"];
		$parsed_data_array["year"]  = $import_request_array["year"];
		$parsed_data_array["scheduler"] ="";//default empty value 
		$parsed_data_array["schedulerLead"]="";//default empty value
		$parsed_data_array["memberId"]=null;
		$parsed_data_array["callLogDetails"]=null;
		$parsed_data_array["assignDate"] = $import_request_array["assignDate"];
		$parsed_data_array["refusalLetterDate"] = $import_request_array["refusalLetterDate"];
		$parsed_data_array["status"] = $import_request_array["status"];
		$parsed_data_array["returnMail"] = $import_request_array["returnMail"];
		$parsed_data_array["termDate"] = $import_request_array["termDate"];
		$parsed_data_array["visitType"] =  $import_request_array["visitType"];
		$parsed_data_array["scheduleDate"] =  $import_request_array["scheduleDate"];
		$parsed_data_array["assessor"] =  $import_request_array["assessor"];
		$parsed_data_array["noShow"] =  $import_request_array["noShow"];
	
		//first name of the scheduler
		if (array_key_exists('scheduler', $import_request_array))
		{
			$parsed_data_array["scheduler"] = $import_request_array["scheduler"];
		}
		//scheduler first name
		if (array_key_exists('schedulerLead', $import_request_array))
		{
			$parsed_data_array["schedulerLead"] = $import_request_array["schedulerLead"];
		}

		if (array_key_exists('memberId', $import_request_array))
		{
			$parsed_data_array["memberId"] = $import_request_array["memberId"];
		}

		if (array_key_exists('callLogDetails', $import_request_array))
		{
			$parsed_data_array["callLogDetails"] = $import_request_array["callLogDetails"];
		}

		return $parsed_data_array;

	}
	
	/*
        NAME 	: assignSchedulerToGlobalMembers
        TYPR 	: internal utiltiy function
		DETAILS : internal use utiltiy function to assign scheduler to group of global client members		 
		RETURN 	: 
	*/
	public function assignSchedulerToGlobalMembers()
	{
		include("../db.php");

		$assign_post_body_data  = file_get_contents("php://input");
		$post_memeber_array = json_decode($assign_post_body_data,true);
		
		$client_id_array = $post_memeber_array["clientIds"];
		$member_id_array = $post_memeber_array["memberIds"];
		$year = $post_memeber_array["year"];
		
		TimeZone::useTimeZone();
		$custom_date_time = date('m-d-Y H:i:s'); 
		
		if (array_key_exists('assignDate',$post_memeber_array))
		{
			$assign_date=$post_memeber_array["assignDate"];
			if(DateUtility::validateScheduledDate($assign_date,'m-d-Y H:i:s'))
			{
				$custom_date_time = $post_memeber_array["assignDate"];
			}
		}
		
		//newly added scheduler lead id field
		$scheduler_lead_id=null;
		if (array_key_exists('schedulerLeadId', $post_memeber_array))
		{
			$scheduler_lead_id = $post_memeber_array["schedulerLeadId"];
		}
		$scheduler_id = $post_memeber_array["schedulerId"];
		

		$updated_response = FALSE;

		//total member ids sent count
		$total_member_count = count($member_id_array);
		$total_client_id_count = count($client_id_array);
		
		$member_record_count = 0;
			//update only when valid scheduler lead id set
			if($scheduler_lead_id)
			{
				if( $total_client_id_count === $total_member_count )
				{
					//update the scheduler details to each members
					for($m=0;$m<$total_member_count;$m++)
					{
						
						$member_id = $member_id_array[$m];
						$client_id = $client_id_array[$m];
						$column_name_list = ['scheduler_id'];
						$column_value_list = [$scheduler_id];

						if(DataBaseUtility::isMemberAvailable($client_id,$year,$member_id))
						{
							if(DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list))
							{
								$appended_result=$this->appendSchedulerDetails($client_id,$year,$member_id,$scheduler_lead_id,$scheduler_id,$custom_date_time);
								$db_result = $appended_result['success'];
								$scheduler_details = $appended_result['updated_scheduler_details'];
								if($db_result)
								{
									$this->OnSchedulerAssignedEvent($client_id,$year,$member_id,$scheduler_lead_id,$scheduler_id);

									$column_name_listB = ['schedulerDetails'];
									$column_value_listB = [$scheduler_details];
									if(DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_listB,$column_value_listB))
									{

									}	
								}
								
								$member_record_count++;
							}

							$updated_response = TRUE;
						}
					}

				}
			}
			
			if($updated_response)
			{
				$response = new stdClass();
				$response->status = "scheduler id assigned";
				$response->totalmemberidssent = $total_member_count;
				$response->totalmemberidsupdate = $member_record_count;
				if($total_member_count!=$member_record_count){$response->error = "some invalid member ids";}
				$response = json_encode($response);
			}
			else
			{
				$response = new stdClass();
				$response->status = "scheduler assigned failed";
				$response->totalmemberidssent = $total_member_count;
				$response->totalmemberidsupdate = $member_record_count;
				if($total_member_count!=$member_record_count)
				{
					$response->error = "some invalid memeber ids";
				}
				else
				{
					$response->status = "same scheduler id assigned again";
				}
				$response = json_encode($response);
			}

			echo $response;
					

	}

	/*
        NAME 	: unAssignSchedulerToGlobalMembers
        TYPR 	: internal utiltiy function
		DETAILS : global  utiltiy function to un assign scheduler to group of global client members		 
		RETURN 	: 
	*/
	public function unAssignSchedulerToGlobalMembers()
	{
		include("../db.php");

		$assign_post_body_data  = file_get_contents("php://input");
		$post_memeber_array = json_decode($assign_post_body_data,true);
		
		$client_id_array = $post_memeber_array["clientIds"];
		$member_id_array = $post_memeber_array["memberIds"];
		$year = $post_memeber_array["year"];
		
		//total member ids sent count
		$total_member_count = count($member_id_array);
		$total_client_id_count = count($client_id_array);
		
			$updated_response = FALSE;

			if( $total_client_id_count === $total_member_count )
			{
				//update the scheduler details to each members
				for($m=0;$m<$total_member_count;$m++)
				{
					$member_id = $member_id_array[$m];
					$client_id = $client_id_array[$m];
					$column_name_list = ['scheduler_id'];
					$column_value_list = [null];

					if(DataBaseUtility::isMemberAvailable($client_id,$year,$member_id))
					{
						if(DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list))
						{
							$this->OnSchedulerUnAssignedEvent($client_id,$year,$member_id);
						}
						$updated_response = TRUE;
					}
				}
			}
			
			if($updated_response)
			{
				$response = new stdClass();
				$response->status = "updated";
				echo json_encode($response);
			}
			else
			{
				$response = new stdClass();
				$response->status = "not updated";
				echo json_encode($response);
			}
 
	}


	/*
        NAME 	: _assignSchedulerToMembers
        TYPR 	: internal utiltiy function
		DETAILS : internal use utiltiy function to assign scheduler to group of members		 
		RETURN 	: 
	*/
	private function _assignSchedulerToMembers($client_id,$year,$scheduler_lead_id,$scheduler_id,$member_id_array,$custom_date_time)
	{
		include("../db.php");
		//total member ids sent count
		$total_member_count = count($member_id_array);
		//implode array values in to string with single quotes
		$array_of_member_ids_string = "'".implode("', '", $member_id_array)."'";
		try
		{
			//find the members record count to identify wrong member id if any
			$member_records_query = "select * from HRA_member_".$client_id.'_'.$year." where member_id IN ($array_of_member_ids_string)";
			$member_records_query_result=mysqli_query($conn,$member_records_query);
			$member_record_count = mysqli_num_rows($member_records_query_result);
			 
			//update members scheduler id
			$update_scheduler_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET `scheduler_id` = '$scheduler_id' WHERE `member_id` IN ($array_of_member_ids_string)";
			$updated_response = NULL;
			$updated_result=mysqli_query($conn,$update_scheduler_query);
			$updated_response = mysqli_affected_rows($conn);

			//update only when valid scheduler lead id set
			if($scheduler_lead_id)
			{
				//update the scheduler details to each members
				for($m=0;$m<$total_member_count;$m++)
				{
					$member_id = $member_id_array[$m];
					$appended_result=$this->appendSchedulerDetails($client_id,$year,$member_id,$scheduler_lead_id,$scheduler_id,$custom_date_time);
					$db_result = $appended_result['success'];
					$scheduler_details = $appended_result['updated_scheduler_details'];
					if($db_result)
					{
						$this->OnSchedulerAssignedEvent($client_id,$year,$member_id,$scheduler_lead_id,$scheduler_id);
						$scheduler_details_query = "UPDATE HRA_member_".$client_id.'_'.$year." SET 
													`schedulerDetails` = '$scheduler_details' WHERE `member_id`='$member_id'";
						$updated_result=mysqli_query($conn,$scheduler_details_query);
						
					}
				}
			}
			
			if($updated_response)
			{
				$response = new stdClass();
				$response->status = "scheduler id assigned";
				$response->totalmemberidssent = $total_member_count;
				$response->totalmemberidsupdate = $member_record_count;
				if($total_member_count!=$member_record_count){$response->error = "some invalid member ids";}
				$response = json_encode($response);
			}
			else
			{
				$response = new stdClass();
				$response->status = "scheduler assigned failed";
				$response->totalmemberidssent = $total_member_count;
				$response->totalmemberidsupdate = $updated_response;
				if($total_member_count!=$member_record_count)
				{
					$response->error = "some invalid memeber ids";
				}
				else
				{
					$response->status = "same scheduler id assigned again";
				}
				$response = json_encode($response);
			}

			echo $response;
					
		}
		catch (Exception $e)
		{
			$error = $e->getMessage();
			echo $error;
		}
 
	}


	/*
		NAME : appendSchedulerDetails
		parameters : client id,year,member id,scheduler lead id and scheduler id
		return : database response and appended scheduler details json string AS array
		details :
			1)append scheduler details when member assigned to scheduler by scheduler lead 
			2)scheduler details sample json format
				{ 
					"scheduler_details":[
						{"schedulerLead":"10000220","schedulerId":"12330300","date":"23-11-2020"}
					] ,
					//mail sent details update via scheduler automation script
				   "mail_details":[
					   {"attempt":1,"date":"23-11-2020","mailSent":"failed"}
					] 
				}
		
	*/
	public function appendSchedulerDetails($client_id,$year,$member_id,$scheduler_lead,$scheduler_id,$custom_date_time=null)
	{
		include("../db.php");

		$scheduler_details="";
		$scheduler_details_array=NULL;
		$scheduler_details_query = "select * from HRA_member_".$client_id.'_'.$year." where member_id='$member_id'";
		$db_success = false;
		try
		{
			$scheduler_details_query_result=mysqli_query($conn,$scheduler_details_query);
			if(mysqli_num_rows($scheduler_details_query_result) == 1)
			{
				$member_result=mysqli_fetch_array($scheduler_details_query_result,MYSQLI_ASSOC);
				$scheduler_details = $member_result['schedulerDetails'];
				$db_success=true;
			}
		}
		catch (Exception $e)
		{
			$error = $e->getMessage();
			$db_success=false;
		}

		//if scheduler details is empty or null
		if($scheduler_details=="" || $scheduler_details==NULL )
		{
			$scheduler_details =  '{ "scheduler_details":[] , "mail_details":[] }';
		}

		//decode the json scheduler details format into php array
		$scheduler_details_array = json_decode($scheduler_details, true);
		
		TimeZone::useTimeZone();
		$current_date_time = date('m-d-Y H:i:s');
		//check custom date and time is in valid format
		if($custom_date_time)
		{
			if(DateUtility::isValidateDateFormat($custom_date_time,'m-d-Y H:i:s'))
			{
				$current_date_time = $custom_date_time;
			}
		}

		$append_scheduler_details = array("schedulerLeadId"=>$scheduler_lead,
										   "schedulerId"=>$scheduler_id,
											"date"=>$current_date_time);

		//if new scheduler details.here array used to store scheduler history							
		array_push( $scheduler_details_array['scheduler_details'], $append_scheduler_details );

		return array("success"=>$db_success , "updated_scheduler_details"=>json_encode($scheduler_details_array));

	}

	/*
		NAME : OnSchedulerAssignedEvent
		TYPE : Internal event callbak
	*/
	private function OnSchedulerAssignedEvent($client_id,$year,$member_id,$scheduler_lead,$scheduler_id)
	{
		//when scheduler assigned or reassigned attempt count reset to zero
		MemberUtility::SetCallLogAttemptCount($client_id,$year,$member_id,0);
		//set call order to show what order that member shown in dashboard
		SchedulerCallOrderUtility::setCallOrder($client_id,$year,$member_id,SchedulerCallOrderUtility::NEWLY_ASSIGNED_ORDER);
		//when new scheduler assigned if any notification in mobile number changed 
		//remove value that field from 'notification' in schedulerHraCallStatus
		//$member_scheduler_call_hra_status['notification']
		//read the member hraStatus and scheduler details
		 $member_details = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,["schedulerCallHraStatus"]);
		 $member_scheduler_call_hra_status = json_decode($member_details["schedulerCallHraStatus"],true);
		 if($member_scheduler_call_hra_status && is_array($member_scheduler_call_hra_status) && array_key_exists('notification',$member_scheduler_call_hra_status))
		 {
			 if($member_scheduler_call_hra_status['status'] == SchedulerUtility::UNSCHEDULED)
			 { 
				$schdeuler_notification=$member_scheduler_call_hra_status["notification"];
				if($schdeuler_notification)
				{
					$schdeuler_notification_status=$member_scheduler_call_hra_status["notification"]["type"];
					switch($schdeuler_notification_status)
					{	
						case SchedulerUtility::SCHN_MOBILE_CHANGED:
							TimeZone::useTimeZone();
							$member_scheduler_call_hra_status['date']=date('m-d-Y H:i:s');
							$member_scheduler_call_hra_status['details']="scheduler re-assigned";
							$member_scheduler_call_hra_status['notification']=null;
							//update database field
							$column_name_list =['schedulerCallHraStatus'];
							$column_value_list=[json_encode($member_scheduler_call_hra_status)];
							DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
						break;
					}
				}
			 }
		 }

	}

	/*
		NAME : OnSchedulerUnAssignedEvent
		TYPE : Internal event callback
	*/
	private function OnSchedulerUnAssignedEvent($client_id,$year,$member_id)
	{
		//when scheduler unassigned attempt count reset to zero
		MemberUtility::SetCallLogAttemptCount($client_id,$year,$member_id,0);
		//clear if any order already set
		SchedulerCallOrderUtility::clearCallOrder($client_id,$year,$member_id);
	}

	
	/*
		get all the schedulers by scheduler type like scheduler,scheduler_lead
	*/
	public function getAllScheduler($scheduler_type)
	{
		include("../db.php");
		$scheduler_records_query="select userUniqueno,username,firstname,lastname,userInfo from userLogin where type='$scheduler_type'";
		try 
		{	
			$scheduler_data = array();
			$scheduler_records_query_result=mysqli_query($conn,$scheduler_records_query);
			while($scheduler_info_row=mysqli_fetch_array($scheduler_records_query_result,MYSQLI_ASSOC))
			{
				//scheduler info
				$scheduler_data[]=$scheduler_info_row;
			}
			echo json_encode($scheduler_data);	
		}
		catch (Exception $e)
		{
			$error = $e->getMessage();
			echo $error;
		}
		
	}

	

	/*
		get total the members by scheduler id
	*/
	public function getTotalMembersBySchedulerId($client_id,$year,$scheduler_id)
	{
		include("../db.php");

		$members_query_by_scheduler_id = "select * from HRA_member_".$client_id.'_'.$year." where scheduler_id ='$scheduler_id '";
		try 
		{
			$member_scheduler_id_data = array();
			$members_query_by_scheduler_id_result=mysqli_query($conn,$members_query_by_scheduler_id);
			while($member_record_row=mysqli_fetch_array($members_query_by_scheduler_id_result,MYSQLI_ASSOC))
			{
				$member_scheduler_id_data[]=$member_record_row;
			}

			echo json_encode($member_scheduler_id_data);
		}
		catch (Exception $e)
		{
			$error = $e->getMessage();
			echo $error;  
		}

	}

	/*
		To get number of the memebers assigned to a scheduler with limits
	*/
	public function getMembersByScheduler($client_id,$year,$scheduler_id,$min,$max)
	{
		include("../db.php");

		$count = $max - $min;
		$members_query_by_scheduler_id = "select * from HRA_member_".$client_id.'_'.$year." where scheduler_id ='$scheduler_id ' limit $min,$count";
		try 
		{
			$member_scheduler_id_data = array();
			$members_query_by_scheduler_id_result=mysqli_query($conn,$members_query_by_scheduler_id);
			while($member_record_row=mysqli_fetch_array($members_query_by_scheduler_id_result,MYSQLI_ASSOC))
			{
				$member_scheduler_id_data[]=$member_record_row;
			}

			echo json_encode($member_scheduler_id_data);
		}
		catch (Exception $e)
		{
			$error = $e->getMessage();
			echo $error;  
		}

	}

	/*
		To get the total number of the memebers assigned to a scheduler
	*/
	public function totalMembersBySchedulerId($client_id,$year,$scheduler_id)
	{
		include("../db.php");
		$members_query_by_scheduler_id = "select * from HRA_member_".$client_id.'_'.$year." where scheduler_id ='$scheduler_id'";
		try 
		{
			$members_query_by_scheduler_id_result=mysqli_query($conn,$members_query_by_scheduler_id);
			$member_record_count = mysqli_num_rows($members_query_by_scheduler_id_result);
			//send response
			$response = new stdClass();
			$response->count = $member_record_count;
			$response = json_encode($response);
			echo $response;
		}
		catch (Exception $e)
		{
			$error = $e->getMessage();
			echo $error;  
		}

	}

	
}

?>