<?php

/*
	SCHEDULER GLOBAL MEMBER API  CLASS
	Created On : 
*/

//other include files
require_once("../global/GlobalQueryBuilder.php");
require_once("../member/MemberUtility.php");
require_once("../utility/ArrayUtility.php");
require_once("../utility/StringUtility.php");
require_once("../utility/JwtUtility.php");
require_once("../utility/ResponseUtility.php");
require_once("../TimeZone.php");


class SchedulerGlobalMembers
{

    /*
        NAME    : getSchedulerRequiredColumnAsString
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function getSchedulerRequiredColumnAsString()
    {
        $sql_screening_string = GlobalQueryBuilder::sqlCustomColumnScreeningEligibility();
        //$sql_demograhic_string = GlobalQueryBuilder::sqlCustomColumnDemographic();
        $sql_last_call_log_string  = GlobalQueryBuilder::sqlCustomColumnLastCallLog();

        //$required_column_array[]="member_id,firstname,lastname,nurse_id,scheduler_id";
        $required_column_array[]="member_id,scheduler_id,nurse_id";
        //$required_column_array[]="memberinfo,hraStatus,admin_idno,hraFileUpdatedHistory,termDate";
        $required_column_array[]="memberinfo,hraStatus,hraFileUpdatedHistory,termDate";
        $required_column_array[]=$sql_last_call_log_string;
        $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedScheduledDate();
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedShortScheduledDate();
        $required_column_array[]="scheduler,scheduleDate,STR_TO_DATE(scheduleDate, '%Y-%m-%dT%H:%i:%s') as shortscheduleDate,EvaluationDate,schedulerCallLogDetails,schedulerCallHraStatus,schedulerCallOrder,VisitType";
        //$required_column_array[]=$sql_demograhic_string;
        //custom member info field for sorting 
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Plan','memberPlan');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Program','memberProgram');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('LOB','memberLob');
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_City','memberCity');
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Zip_Code','memberZip');
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_first_name','memberFirstName');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReportStatus('reportStatus');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReportStatusbychar('hrastatusbychar');
        //added on 22nd dec21
		//$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Term_Date','memberTermDate');
		//$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_last_Call_Log','memberlastCalLog');
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_schedule_Date','memberscheduleDate');
        $required_column_array[]=$sql_screening_string;
        $required_column_array[] = GlobalQueryBuilder::attemptCount();
        return ArrayUtility::joinArrayByDelimiter($required_column_array,',');
    }

    public static function getSchedulerRequiredColumnAsString_search()
    {
        $sql_screening_string = GlobalQueryBuilder::sqlCustomColumnScreeningEligibility();
        //$sql_demograhic_string = GlobalQueryBuilder::sqlCustomColumnDemographic();
        $sql_last_call_log_string  = GlobalQueryBuilder::sqlCustomColumnLastCallLog();

        //$required_column_array[]="member_id,firstname,lastname,nurse_id,scheduler_id";
        $required_column_array[]="member_id,firstname,lastname,scheduler_id";
        //$required_column_array[]="memberinfo,hraStatus,admin_idno,hraFileUpdatedHistory,termDate";
        $required_column_array[]="memberinfo,hraStatus,hraFileUpdatedHistory,termDate";
        $required_column_array[]=$sql_last_call_log_string;
        $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedScheduledDate();
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedShortScheduledDate();
        $required_column_array[]="scheduler,scheduleDate,STR_TO_DATE(scheduleDate, '%Y-%m-%dT%H:%i:%s') as shortscheduleDate,EvaluationDate,schedulerCallLogDetails,schedulerCallHraStatus,schedulerCallOrder,VisitType";
        //$required_column_array[]=$sql_demograhic_string;
        //custom member info field for sorting 
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Plan','memberPlan');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Program','memberProgram');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('LOB','memberLob');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_City','memberCity');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Zip_Code','memberZip');
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_first_name','memberFirstName');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReportStatus('reportStatus');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReportStatusbychar('hrastatusbychar');
        //added on 22nd dec21
		//$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Term_Date','memberTermDate');
		// $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_last_Call_Log','memberlastCalLog');
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_schedule_Date','memberscheduleDate');
        $required_column_array[]=$sql_screening_string;
        $required_column_array[] = GlobalQueryBuilder::attemptCount();
        return ArrayUtility::joinArrayByDelimiter($required_column_array,',');
    }


    
    /*
        NAME    : getSchedulerRequiredColumnAsString
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function convertToDefaultMemberSqlQuery($member_table_sql_query)
	{
            if($member_table_sql_query === FALSE) return FALSE;//not valid query string

            $scheduler_member_sql_query = "SELECT (COUNT(*) OVER()) as totalRows, member_table.*,member_table.*,(CASE WHEN JSON_UNQUOTE((JSON_EXTRACT(member_table.ScreeningEligibility,'$[0]'))) ='Yes' THEN 'Yes' ELSE 'No' END) as eyeexam,
            
            CONCAT(scheduler_table.firstname ,' ',scheduler_table.lastname) as scheduler_fullname
            
            FROM 
				( $member_table_sql_query ) as member_table 
				LEFT JOIN userLogin as scheduler_table ON scheduler_table.userUniqueno = member_table.scheduler_id 
				 ";

			return $scheduler_member_sql_query;
	}

    /*
        NAME    : getMemberRequiredFieldAsArray
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    private function getMemberRequiredFieldAsArray($member_row)
	{
			$response_array=array(
                                    "memberId"=>$member_row['member_id'],
                                    //"nurseId"=>$member_row['nurse_id'],
                                    //"adminId"=>$member_row['admin_id'],
                                    "schedulerId"=>$member_row["scheduler_id"],

                                   // "nurseName"=>StringUtility::toEmptyStringIfNull($member_row['nurse_fullname']),
                                    "schedulerName"=>StringUtility::toEmptyStringIfNull($member_row['scheduler_fullname']),
                                    //"adminName"=>StringUtility::toEmptyStringIfNull($member_row['admin_fullname']),
                                    
                                    "memberinfo"=>$member_row['memberinfo'],
                                   // "demographic"=>$member_row['Demographic'],

                                    "scheduleDate"=>$member_row['scheduleDate'],
                                    //some case evalution date consider as scheduled date
                                    "overrideScheduleDate"=>$member_row['overrideScheduledDate'],
                                    "termDate"=>$member_row['termDate'],
                                    "evaluationDate" => $member_row['EvaluationDate'],

                                    "hraStatus"=>$member_row['hraStatus'],
                                    
                                    "visitType"=>$member_row['VisitType'],

                                    "clientId"=>$member_row['client_id'],
                                    //"clientName"=>$member_row['client_name'],
                                    "clientYear"=>$member_row['client_year'],

                                    "scheduler"=>$member_row['scheduler'],
                                    "lastCallLog"=>$member_row['lastCallLog'],
                                    "schedulerStatus"=>$member_row['reportStatus'],
                                    "schedulerHraStatus"=>$member_row['schedulerCallHraStatus'],
                                    "schedulerCallResponse"=>$member_row['schedulerCallLogDetails'],
                                    "schedulerCallOrder"=>$member_row['schedulerCallOrder'],

                                    "screeningEligibility"=>$member_row['ScreeningEligibility'],
                                    
								);

			return $response_array;
	}

     /*
        NAME    : queryResultResponse
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    private function queryResultResponse($member_query_result,$error)
    {
        $total_rows = 0;
        
        $member_list=[];
        while ($member_row = $member_query_result->fetch_assoc()) 
        {
            $member_list[]=$this->getMemberRequiredFieldAsArray($member_row);
            $total_rows = $member_row['totalRows'];
        }

       $member_response = new stdClass;
            $member_response->status=true;
            $member_response->error=$error;
            $member_response->totalRows=$total_rows;
            $member_response->members=$member_list;

        return $member_response;

    }


    /*
        NAME    : filter
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public function filter($filter_parameters,&$error)
    {

        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $filter_parameters['planId'];
        $user_id = $filter_parameters['userId'];
        $year = $filter_parameters['year'];
        $min = $filter_parameters['min'];
        $max = $filter_parameters['max'];
        $isFilterApplied = $filter_parameters['isFilterApplied'];

	    $lob= base64_decode(urldecode($filter_parameters['lob']));
       // $filter_parameters['lob']=strtoupper($lob);
      if($lob != '' && strpos($lob,"M4") >= 0){
        $lob =  $lob . '_Medallion';
       }
       $filter_parameters['lob']=strtoupper($lob);

        $is_my_member = 0;
        if(array_key_exists('isMyMember',$filter_parameters))
        {
            $is_my_member = $filter_parameters['isMyMember'];
        }

        $base_sort_by = $filter_parameters['baseSortBy'];
        $base_sort_order = $filter_parameters['baseSortOrder']==0?'ASC':'DESC';
        $sort_by = $filter_parameters['sortBy']; 
        $sort_order = $filter_parameters['sortOrder']==0?'ASC':'DESC';

        $start =$min;
        $offset = $max - $min;

        $sql_global_member_query = array();

        $isDisabledMember = $filter_parameters["isDisabledMember"];
       

        if($isDisabledMember){
            $tab_filter_data['status']=ArrayUtility::convertArrayToString(
                [
                    "Wrong Number","Disconnected","Ineligible","Deceased",
                    "Hospice","Other","UTC","Termed"
                ],"_"
            );
            $tab_filter_data['hraStatus']=ArrayUtility::convertArrayToString([MemberUtility::HRA_NOT_DUE],'_');
        }else{
            $tab_filter_data['status']=ArrayUtility::convertArrayToString(
                [
                    "","Pending","Call Back","F2F Call Back","Scheduled",
                    "Rescheduled","Completed","Refusal","Cancellation","F2F No Show","Virtual No Show","UTC"
                ],"_"
            );
    
            $tab_filter_data['hraStatus']=ArrayUtility::convertArrayToString([MemberUtility::UNSCHEDULED],'_');
        }

        if($is_my_member)
        {
            $tab_filter_data['status']=ArrayUtility::convertArrayToString(
                [
                    "","Pending","Call Back","F2F Call Back","Cancellation","F2F No Show","Virtual No Show"
                ],"_"
            );
        }


        if(array_key_exists('planId',$filter_parameters))
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                                SchedulerGlobalMembers::convertToDefaultMemberSqlQuery(
                                                GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
                                                self::getSchedulerRequiredColumnAsString())
                                                )
                                            );
        }
        else
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                                SchedulerGlobalMembers::convertToDefaultMemberSqlQuery(
                                                GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
                                                self::getSchedulerRequiredColumnAsString())
                                                )
                                            );
        }
        //if invalid user details sent                                                
        if(count($sql_global_member_query)==0) return FALSE;
                                                      
            //where clause array and condition
            $where_clause_contiditions = array();
            //if my member flag set show only this scheduler assighed member details
            if($is_my_member)
            {
                $my_member_filter['schedulerIds']=$user_id;
                $my_member_filter['column']="scheduler_id";
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('scheduler',$my_member_filter));   
            }

            //assigned and unassigned condition applied only when scheduler lead
            if($is_my_member==0 && $isDisabledMember == "false")
            {
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseForAssignAndUnAssign($filter_parameters));
            } else{
                $disconnected_where_condition[] ="(";
                $disconnected_where_condition[] = GlobalQueryBuilder::whereClauseCustomColumnValueIn('reportStatus',$tab_filter_data,'status',true);
            //disconnected where clause condition
                $special_status_filter_data['status']=ArrayUtility::convertArrayToString(
                [
                    "Disconnected"
                ]);
                $attempt_filter_array['attemptCount'] = 5;
                $disconnected_where_condition[] = " OR ";
                $disconnected_where_condition[] = "(member_table.reportStatus IS NULL)";
                $disconnected_where_condition[] = " OR ";
                    $disconnected_where_condition[] = "(";
                    $disconnected_where_condition[] = GlobalQueryBuilder::whereClauseCustomColumnValueIn('reportStatus',$special_status_filter_data,'status',true);

                    $disconnected_where_condition[] = " AND ";
                    $disconnected_where_condition[] = GlobalQueryBuilder::whereClauseColumnSimpleJsonField('schedulerCallLogDetails',$attempt_filter_array,'attemptCount','attemptCount','<');
                    $disconnected_where_condition[] = ")";
                $disconnected_where_condition[] = ")";
                $disconnected_where_query_string = implode($disconnected_where_condition);
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,$disconnected_where_query_string);
        }


            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseScreeningStatus($filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseCustomColumnValueIn('client_id',$filter_parameters,'clientId',true,'|',','));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('nurse',$filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('scheduler',$filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('qa',$filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('coder',$filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseScheduleDateBetween($filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseCustomColumnValueIn('reportStatus',$filter_parameters,'status',true));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseBySpecificScreeningEligibligy($filter_parameters));                                            
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseByScreeningEligibility('screening',$filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseLastCallLogWithSubResultIn($filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseCustomColumnValueIn('VisitType',$filter_parameters,'visitType',true));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseCallBackStatus($filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseLastCallLogCallBackDateRange($filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseNextOutreachCallBackDateRange($filter_parameters));

            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'city','Member_City',true));
 // print_r($filter_parameters);die;
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'lob','LOB',true)); 
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'plan','Plan',true));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'program','Program',true)); 
            //search filter by suresh
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'firstname','Member_first_name',true)); 
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'lastname','Member_Last_name',true));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'id','Member_Identification_Number',true));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'zip','Member_Zip_Code',true)); 
            
                //print_r($where_clause_contiditions);die;
        if(count($where_clause_contiditions)==0) { $error="no valid filter option selected"; return FALSE;}  

            //if any valid where clause found append 'where'
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
            //if multiple where clause add 'and' else 'or' condition
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));
            //order query string
            //$sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,$sort_by,$base_sort_order,$sort_order));

            if($sort_by == 'name'){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'name_schedule',$base_sort_order,$sort_order));
            }elseif($sort_by == "city"){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'city_schedule',$base_sort_order,$sort_order));
            }elseif($sort_by == 'scheduledate'){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'scheduledate_scheduler',$base_sort_order,$sort_order));
            }elseif($sort_by == "hrastatusbychar"){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'hrastatusbychar_scheduler',$base_sort_order,$sort_order));
            }elseif($sort_by == "attemptcount"){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'attemptcount_scheduler',$base_sort_order,$sort_order));
            }else{
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,$sort_by,$base_sort_order,$sort_order));
            }
            //limit string
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT ?,? ");
            //generated query 
            $generated_query = implode($sql_global_member_query);
            //echo $generated_query;exit();

            //prepare the member query
                if($conn->connect_errno)
                {
                    $error="datatbase connection failed";
                }
                //prepare the member query
                $member_query=$conn->prepare($generated_query);
                if($member_query===FALSE)
                {
                    $error = "error preparing sql query";
                    return FALSE;
                }
                //bind parameters
                $member_query->bind_param('ii',$start,$offset);
               
                if($member_query === FALSE)
                {
                    $error="parameter error";
                    return FALSE;
                }

                $member_query->execute();

                if($member_query === FALSE)
                {
                    $error="error in sql query";
                    return FALSE;
                }

                $member_query_result = $member_query->get_result();
                ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$conn->error));
        
        return TRUE;
    }


    /*
        NAME    : search
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public function search($search_parameters,&$error)
    {
        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $search_parameters['planId'];
        $user_id = $search_parameters['userId'];
        $year = $search_parameters['year'];
        $min = $search_parameters['min'];
        $max = $search_parameters['max'];

        $is_my_member = 0;
        if(array_key_exists('isMyMember',$search_parameters))
        {
            $is_my_member = $search_parameters['isMyMember'];
        }

        $base_sort_by = $search_parameters['baseSortBy'];
        $base_sort_order = $search_parameters['baseSortOrder']==0?'ASC':'DESC';
        $sort_by = $search_parameters['sortBy']; 
        $sort_order = $search_parameters['sortOrder']==0?'ASC':'DESC';

        $start =$min;
        $offset = $max - $min;

        $sql_global_member_query = array();
        if(array_key_exists('planId',$search_parameters))
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                                SchedulerGlobalMembers::convertToDefaultMemberSqlQuery(
                                                GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
                                                self::getSchedulerRequiredColumnAsString_search()))
                                                );
        }
        else
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                                    SchedulerGlobalMembers::convertToDefaultMemberSqlQuery(
                                                    GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
                                                    self::getSchedulerRequiredColumnAsString_search()))
                                                    );
        }

        //if invalid user details sent                                                
        if(count($sql_global_member_query)==0) return FALSE;  
            //where clause array and condition
            $where_clause_contiditions = array();
            //if my member flag set show only this scheduler assighed member details
            if($is_my_member)
            {
                $my_member_filter['schedulerIds']=$user_id;
                $my_member_filter['column']="scheduler_id";
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('scheduler',$my_member_filter));   
            }
            //search where clause condition 
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByColumnLike('firstname',$search_parameters,'firstname'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByColumnLike('lastname',$search_parameters,'lastname'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberId($search_parameters,'id'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('Plan',$search_parameters,'plan'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('Program',$search_parameters,'program'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('LOB',$search_parameters,'lob'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('Member_City',$search_parameters,'city'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('Member_Zip_Code',$search_parameters,'zip'));
        
        if(count($where_clause_contiditions)==0) { $error="invalid search value"; return FALSE;}   

            //if any valid where clause found append 'where'
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
            //if multiple where clause add 'and' else 'or' condition
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));
            
            //$sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,$sort_by,$base_sort_order,$sort_order));

            if($sort_by == 'name'){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'name_schedule',$base_sort_order,$sort_order));
            }elseif($sort_by == "city"){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'city_schedule',$base_sort_order,$sort_order));
            }elseif($sort_by == 'scheduledate'){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'scheduledate_scheduler',$base_sort_order,$sort_order));
            }elseif($sort_by == "hrastatusbychar"){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'hrastatusbychar_scheduler',$base_sort_order,$sort_order));
            }elseif($sort_by == "attemptcount"){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'attemptcount_scheduler',$base_sort_order,$sort_order));
            }else{
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,$sort_by,$base_sort_order,$sort_order));
            }

            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT ?,? ");

            $generated_query = implode($sql_global_member_query);
            //echo $generated_query;exit;                          
                if($conn->connect_errno)
                {
                    $error="database connection failed";
                }

                //prepare the member query
                $member_query=$conn->prepare($generated_query);
                if($member_query===FALSE)
                {
                    $error = "error preparing sql query";
                    return FALSE;
                }
                //bind parameters
                $member_query->bind_param('ii',$start,$offset);
               
                if($member_query === FALSE)
                {
                    $error="parameter error";
                    return FALSE;
                }

                $member_query->execute();

                if($member_query === FALSE)
                {
                    $error="error in sql query";
                    return FALSE;
                }

                $member_query_result = $member_query->get_result();
                ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$error));

            return TRUE;
   
    }

    /*
        NAME    : search
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public function getDisableMembers($parameters,&$error)
    {

        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $parameters['planId'];
        $user_id = $parameters['userId'];
        $year = $parameters['year'];
        $min = $parameters['min'];
        $max = $parameters['max'];

        $is_my_member = 0;
        if(array_key_exists('isMyMember',$parameters))
        {
            $is_my_member = $parameters['isMyMember'];
        }

        $base_sort_by = $parameters['baseSortBy'];
        $base_sort_order = $parameters['baseSortOrder']==0?'ASC':'DESC';
        $sort_by = $parameters['sortBy']; 
        $sort_order = $parameters['sortOrder']==0?'ASC':'DESC';

        $start =$min;
        $offset = $max - $min;
        //only show folowing scheduler status 
        //and where cause condition to be 'OR' so combine and consider both the condition as single where clause
        $tab_filter_data['status']=ArrayUtility::convertArrayToString(
            [
                "Wrong Number","Disconnected","Ineligible","Deceased",
                "Hospice","Other","UTC","Termed"
            ],"_"
        );
        $tab_filter_data['hraStatus']=ArrayUtility::convertArrayToString([MemberUtility::HRA_NOT_DUE],'_');
       
        $sql_global_member_query = array();
        if(array_key_exists('planId',$parameters))
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                                                SchedulerGlobalMembers::convertToDefaultMemberSqlQuery(
                                                                GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
                                                                self::getSchedulerRequiredColumnAsString()))
                                                            );
        }
        else
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                                                SchedulerGlobalMembers::convertToDefaultMemberSqlQuery(
                                                                GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
                                                                self::getSchedulerRequiredColumnAsString()))
                                                            );
        }
        //if invalid user details sent                                                
        if(count($sql_global_member_query)==0) return FALSE;  
            //where clause array and condition
            $where_clause_contiditions = array();
             //if my member flag set show only scheduler assighed member details
            if($is_my_member)
            {
                $my_member_filter['schedulerIds']=$user_id;
                $my_member_filter['column']="scheduler_id";
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('scheduler',$my_member_filter));   
            }
            //disabled tab members 
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,'('.GlobalQueryBuilder::whereClauseHraStatusIn($tab_filter_data).' OR '.GlobalQueryBuilder::whereClauseCustomColumnValueIn('reportStatus',$tab_filter_data,'status',true).')');
            //if any valid where clause found append 'where'
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
            //if multiple where clause add 'and' else 'or' condition
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));
            //sort by query string                                       
            //$sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,$sort_by,$base_sort_order,$sort_order));
            
            if($sort_by == 'name'){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'name_schedule',$base_sort_order,$sort_order));
            }elseif($sort_by == "city"){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'city_schedule',$base_sort_order,$sort_order));
            }elseif($sort_by == 'scheduledate'){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'scheduledate_scheduler',$base_sort_order,$sort_order));
            }elseif($sort_by == "hrastatusbychar"){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'hrastatusbychar_scheduler',$base_sort_order,$sort_order));
            }elseif($sort_by == "attemptcount"){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'attemptcount_scheduler',$base_sort_order,$sort_order));
            }else{
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,$sort_by,$base_sort_order,$sort_order));
            }
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT ?,? ");

            $generated_query = implode($sql_global_member_query);
            //echo $generated_query;exit();   
            //prepare the member query                                   
            if($conn->connect_errno)
            {
                $error="database connection failed";
            }
            //prepare the member query
            $member_query=$conn->prepare($generated_query);
            if($member_query===FALSE)
            {
                $error = "error preparing sql query";
                return FALSE;
            }
            //bind parameters
            $member_query->bind_param('ii',$start,$offset);
           
            if($member_query === FALSE)
            {
                $error="parameter error";
                return FALSE;
            }

            $member_query->execute();

            if($member_query === FALSE)
            {
                $error="error in sql query";
                return FALSE;
            }

            $member_query_result = $member_query->get_result();
            ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$conn->error));
            
        return TRUE;

    }

    /*
        NAME    : getMembers
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public function getMembers($parameters,&$error)
    {
        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $parameters['planId'];
        $user_id = $parameters['userId'];
        $year = $parameters['year'];
        $min = $parameters['min'];
        $max = $parameters['max'];

        $is_my_member = 0;
        if(array_key_exists('isMyMember',$parameters))
        {
            $is_my_member = $parameters['isMyMember'];
        }

        $is_unassigned = 0;
        if(array_key_exists('unAssigned',$parameters))
        {
            $is_unassigned = $parameters['unAssigned'];
        }

        //sort arder
        $base_sort_by = $parameters['baseSortBy'];
        $base_sort_order = $parameters['baseSortOrder']==0?'ASC':'DESC';
        $sort_by = $parameters['sortBy']; 
        $sort_order = $parameters['sortOrder']==0?'ASC':'DESC';

        $start =$min;
        $offset = $max - $min;

        //only show folowing scheduler status  and hra status in member tab
        //and where cause condition to be 'OR' so combine and consider both the condition as single where clause
        $tab_filter_data['status']=ArrayUtility::convertArrayToString(
            [
                "","Pending","Call Back","F2F Call Back","Scheduled",
                "Rescheduled","Completed","Refusal","Cancellation","F2F No Show","Virtual No Show"
            ],"_"
        );
        $tab_filter_data['hraStatus']=ArrayUtility::convertArrayToString([MemberUtility::UNSCHEDULED],'_');

        //status condition altered for unassigned condition
        if($is_unassigned)
        {
            $tab_filter_data['status']=ArrayUtility::convertArrayToString(
                [
                    "","Pending","Call Back","F2F Call Back","Refusal","Cancellation","F2F No Show","Virtual No Show"
                ],"_"
            );
        }
        //status condition when my member enabled
        if($is_my_member)
        {
            $tab_filter_data['status']=ArrayUtility::convertArrayToString(
                [
                    "","Pending","Call Back","F2F Call Back","Cancellation","F2F No Show","Virtual No Show"
                ],"_"
            );
        }

        $sql_global_member_query = array();
        if(array_key_exists('planId',$parameters))
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                                            SchedulerGlobalMembers::convertToDefaultMemberSqlQuery(
                                                            GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
                                                            self::getSchedulerRequiredColumnAsString()))
                                                        );
        }
        else
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                                            SchedulerGlobalMembers::convertToDefaultMemberSqlQuery(
                                                            GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
                                                            self::getSchedulerRequiredColumnAsString()))
                                                        );
        }
        
        //when invalid userid sent
        if(count($sql_global_member_query)==0) return FALSE; 

            //where clause array and condition
            $where_clause_contiditions = array();
            if($is_my_member)
            {
                $my_member_filter['schedulerIds']=$user_id;
                $my_member_filter['column']="scheduler_id";
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('scheduler',$my_member_filter));   
            }

            //assigned and unassigned condition applied only when scheduler lead
            if($is_my_member==0)
            {
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseForAssignAndUnAssign($parameters));
            }
            else
            {
                //scheduler status my member condition
                    $disconnected_where_condition[] ="(";
                    $disconnected_where_condition[] = GlobalQueryBuilder::whereClauseCustomColumnValueIn('reportStatus',$tab_filter_data,'status',true);
                //disconnected where clause condition
                    $special_status_filter_data['status']=ArrayUtility::convertArrayToString(
                    [
                        "Disconnected"
                    ]);
                    $attempt_filter_array['attemptCount'] = 5;
                    $disconnected_where_condition[] = " OR ";
                $disconnected_where_condition[] = " (member_table.reportStatus IS NULL) OR";
                        $disconnected_where_condition[] = "(";
                        $disconnected_where_condition[] = GlobalQueryBuilder::whereClauseCustomColumnValueIn('reportStatus',$special_status_filter_data,'status',true);
                        $disconnected_where_condition[] = " AND ";
                        $disconnected_where_condition[] = GlobalQueryBuilder::whereClauseColumnSimpleJsonField('schedulerCallLogDetails',$attempt_filter_array,'attemptCount','attemptCount','<');
                        $disconnected_where_condition[] = ")";
                    $disconnected_where_condition[] = ")";
                    $disconnected_where_query_string = implode($disconnected_where_condition);
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,$disconnected_where_query_string);
            }
          
            //if any valid where clause found append 'where'
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
            //if multiple where clause add 'and' else 'or' condition
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));
            //sort by query string
            //$sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,$sort_by,$base_sort_order,$sort_order));

            if($sort_by == 'name'){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'name_schedule',$base_sort_order,$sort_order));
            }elseif($sort_by == "city"){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'city_schedule',$base_sort_order,$sort_order));
            }elseif($sort_by == 'scheduledate'){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'scheduledate_scheduler',$base_sort_order,$sort_order));
            }elseif($sort_by == "hrastatusbychar"){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'hrastatusbychar_scheduler',$base_sort_order,$sort_order));
            }elseif($sort_by == "attemptcount"){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'attemptcount_scheduler',$base_sort_order,$sort_order));
            }else{
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,$sort_by,$base_sort_order,$sort_order));
            }
            //limit by range
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT ?,? ");
            //genarated query
            $generated_query = implode($sql_global_member_query);
           //echo $generated_query;exit();    

                                   
                if($conn->connect_errno)
                {
                    $error="database connection failed";
                }

                //prepare the member query
                $member_query=$conn->prepare($generated_query);
                if($member_query===FALSE)
                {
                    $error = "error preparing sql query";
                    return FALSE;
                }
                //bind parameters
                $member_query->bind_param('ii',$start,$offset);
               
                if($member_query === FALSE)
                {
                    $error="parameter error";
                    return FALSE;
                }

                $member_query->execute();

                if($member_query === FALSE)
                {
                    $error="error in sql query";
                    return FALSE;
                }

            $member_query_result = $member_query->get_result();
            ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$error));

        return TRUE;
        
    }

   
}


?>