<?php

/*
	SCHEDULER GLOBAL MEMBER API  CLASS
	Created On : 
*/

//other include files
require_once("../global/GlobalQueryBuilder.php");
require_once("../member/MemberUtility.php");
require_once("../utility/ArrayUtility.php");
require_once("../utility/StringUtility.php");
require_once("../utility/JwtUtility.php");
require_once("../utility/ResponseUtility.php");
require_once("../TimeZone.php");

class SchedulerGlobalMembers
{

    /*
        NAME    : getSchedulerRequiredColumnAsString
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function getSchedulerRequiredColumnAsString()
    {
        $sql_screening_string = GlobalQueryBuilder::sqlCustomColumnScreeningEligibility();
        //$sql_demograhic_string = GlobalQueryBuilder::sqlCustomColumnDemographic();
        $sql_last_call_log_string  = GlobalQueryBuilder::sqlCustomColumnLastCallLog();

        //$required_column_array[]="member_id,firstname,lastname,nurse_id,scheduler_id";
        $required_column_array[]="member_id,scheduler_id";
        //$required_column_array[]="memberinfo,hraStatus,admin_idno,hraFileUpdatedHistory,termDate";
        $required_column_array[]="memberinfo,hraStatus,termDate";
        $required_column_array[]=$sql_last_call_log_string;
        $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedScheduledDate();
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedShortScheduledDate();
        $required_column_array[]="scheduler,scheduleDate,STR_TO_DATE(scheduleDate, '%Y-%m-%dT%H:%i:%s') as shortscheduleDate,EvaluationDate,schedulerCallLogDetails,schedulerCallHraStatus,schedulerCallOrder,VisitType";
        //$required_column_array[]=$sql_demograhic_string;
        //custom member info field for sorting 
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Plan','memberPlan');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Program','memberProgram');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('LOB','memberLob');
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_City','memberCity');
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Zip_Code','memberZip');
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_first_name','memberFirstName');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReportStatus('reportStatus');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReportStatusbychar('hrastatusbychar');
//added on 22nd dec21
		//$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Term_Date','memberTermDate');
		// $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_last_Call_Log','memberlastCalLog');
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_schedule_Date','memberscheduleDate');
        $required_column_array[]=$sql_screening_string;
        
        return ArrayUtility::joinArrayByDelimiter($required_column_array,',');
    }

    public static function getSchedulerRequiredColumnAsString_search()
    {
        $sql_screening_string = GlobalQueryBuilder::sqlCustomColumnScreeningEligibility();
        //$sql_demograhic_string = GlobalQueryBuilder::sqlCustomColumnDemographic();
        $sql_last_call_log_string  = GlobalQueryBuilder::sqlCustomColumnLastCallLog();

        //$required_column_array[]="member_id,firstname,lastname,nurse_id,scheduler_id";
        $required_column_array[]="member_id,firstname,lastname,scheduler_id";
        //$required_column_array[]="memberinfo,hraStatus,admin_idno,hraFileUpdatedHistory,termDate";
        $required_column_array[]="memberinfo,hraStatus,termDate";
        $required_column_array[]=$sql_last_call_log_string;
        $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedScheduledDate();
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomColumnOverridedShortScheduledDate();
        $required_column_array[]="scheduler,scheduleDate,STR_TO_DATE(scheduleDate, '%Y-%m-%dT%H:%i:%s') as shortscheduleDate,EvaluationDate,schedulerCallLogDetails,schedulerCallHraStatus,schedulerCallOrder,VisitType";
        //$required_column_array[]=$sql_demograhic_string;
        //custom member info field for sorting 
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Plan','memberPlan');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Program','memberProgram');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('LOB','memberLob');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_City','memberCity');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Zip_Code','memberZip');
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_first_name','memberFirstName');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReportStatus('reportStatus');
        $required_column_array[]=GlobalQueryBuilder::sqlCustomColumnReportStatusbychar('hrastatusbychar');
//added on 22nd dec21
		//$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_Term_Date','memberTermDate');
		// $required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_last_Call_Log','memberlastCalLog');
        //$required_column_array[]=GlobalQueryBuilder::sqlCustomMemberInfoFiled('Member_schedule_Date','memberscheduleDate');
        $required_column_array[]=$sql_screening_string;
        
        return ArrayUtility::joinArrayByDelimiter($required_column_array,',');
    }

    /*
        NAME    : getSchedulerRequiredColumnAsString
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public static function convertToDefaultMemberSqlQuery($member_table_sql_query)
	{
            if($member_table_sql_query === FALSE) return FALSE;//not valid query string

			/*$scheduler_member_sql_query = "SELECT (COUNT(*) OVER()) as totalRows, member_table.*,
            client_table.client_name as client_name,
            admin_table.userUniqueno as admin_id,
            CONCAT(scheduler_table.firstname ,' ',scheduler_table.lastname) as scheduler_fullname,
            CONCAT(nurse_table.firstname ,' ', nurse_table.lastname) as nurse_fullname,
            CONCAT(admin_table.firstname ,' ', admin_table.lastname) as admin_fullname, 
            member_global_status.return_mail as returnMail
            FROM 
				( $member_table_sql_query ) as member_table 
				LEFT JOIN userLogin as scheduler_table ON scheduler_table.userUniqueno = member_table.scheduler_id 
				LEFT JOIN userLogin as nurse_table ON nurse_table.userUniqueno = member_table.nurse_id 
				LEFT JOIN HRA_client as client_table ON client_table.clientId = member_table.client_id 
				LEFT JOIN userLogin as admin_table ON admin_table.userUniqueno = member_table.admin_idno
                LEFT JOIN hra_member_global_status AS member_global_status ON member_global_status.member_id = member_table.member_id ";*/


                $scheduler_member_sql_query = "SELECT (COUNT(*) OVER()) as totalRows, member_table.* ,CONCAT(scheduler_table.firstname ,' ',scheduler_table.lastname) as scheduler_fullname

            FROM 
				( $member_table_sql_query ) as member_table 
                LEFT JOIN userLogin as scheduler_table ON scheduler_table.userUniqueno = member_table.scheduler_id 
				 ";

			return $scheduler_member_sql_query;
	}

    /*
        NAME    : getMemberRequiredFieldAsArray
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    private function getMemberRequiredFieldAsArray($member_row)
	{
       //echo "<pre>". print_r($member_row,1). "</pre>";exit;
			$member_id = $member_row['member_id'];
			$memberinfo = $member_row['memberinfo'];
            //$demographic = $member_row['Demographic'];

			$scheduler_call_log = $member_row['scheduler'];
            $last_call_log = $member_row['lastCallLog'];
            $schedule_hra_status = $member_row['schedulerCallHraStatus'];
			$schedule_call_log_details = $member_row['schedulerCallLogDetails'];
            $schedule_call_order_details = $member_row['schedulerCallOrder'];

			$override_scheduled_date = $member_row['overrideScheduledDate'];
            $scheduled_date = $member_row['scheduleDate'];
			$term_date = $member_row['termDate'];
            $evaluation_date = $member_row['EvaluationDate'];
           
			$hra_status = $member_row['hraStatus'];
            $scheduler_status=$member_row['reportStatus'];
			$visit_type = $member_row['VisitType'];

            //$admin_id = $member_row['admin_id'];
            //$nurse_id = $member_row['nurse_id'];
			$scheduler_id = $member_row["scheduler_id"];

			//$nurse_name = StringUtility::toEmptyStringIfNull($member_row['nurse_fullname']);
            $scheduler_name = StringUtility::toEmptyStringIfNull($member_row['scheduler_fullname']);
            //$admin_name = StringUtility::toEmptyStringIfNull($member_row['admin_fullname']);

			$client_id = $member_row['client_id'];
			//$client_name = $member_row['client_name'];
			$client_year = $member_row['client_year'];

            $screening_details = $member_row['ScreeningEligibility'];

           
			$response_array=array(
                                    "memberId"=>$member_id,
                                    //"nurseId"=>$nurse_id,
                                    //"adminId"=>$admin_id,
                                    "schedulerId"=>$scheduler_id,

                                    //"nurseName"=>$nurse_name,
                                    "schedulerName"=>$scheduler_name,
                                    //"adminName"=>$admin_name,
                                    
                                    "memberinfo"=>$memberinfo,
                                    //"demographic"=>$demographic,

                                    "scheduleDate"=>$scheduled_date,
                                    //some case evalution date consider as scheduled date
                                    "overrideScheduleDate"=>$override_scheduled_date,
                                    "termDate"=>$term_date,
                                    "evaluationDate" => $evaluation_date,

                                    "hraStatus"=>$hra_status,
                                    
                                    "visitType"=>$visit_type,

                                    "clientId"=>$client_id,
                                    //"clientName"=>$client_name,
                                    //"clientYear"=>$client_year,

                                    "scheduler"=>$scheduler_call_log,
                                    "lastCallLog"=>$last_call_log,
                                    "schedulerStatus"=>$scheduler_status,
                                    "schedulerHraStatus"=>$schedule_hra_status,
                                    "schedulerCallResponse"=>$schedule_call_log_details,
                                    "schedulerCallOrder"=>$schedule_call_order_details,

                                    "screeningEligibility"=>$screening_details,
                                    
								);

			return $response_array;
	}

     /*
        NAME    : queryResultResponse
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    private function queryResultResponse($member_query_result,$error)
    {
        $total_rows = 0;
        
        $member_list=[];
        while ($member_row = $member_query_result->fetch_assoc()) 
        {
            //echo "<pre>". print_r($member_row,1). "</pre>"; exit;
            $member_list[]=$this->getMemberRequiredFieldAsArray($member_row);
            $total_rows = $member_row['totalRows'];
        }

       $member_response = new stdClass;
            $member_response->status=true;
            $member_response->error=$error;
            $member_response->totalRows=$total_rows;
            $member_response->members=$member_list;

        return $member_response;

    }


    /*
        NAME    : filter
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public function filter($filter_parameters,&$error)
    {

        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $filter_parameters['planId'];
        $user_id = $filter_parameters['userId'];
        $year = $filter_parameters['year'];
        $min = $filter_parameters['min'];
        $max = $filter_parameters['max'];
$isFilterApplied = $filter_parameters['isFilterApplied'];

	         $lob= base64_decode(urldecode($filter_parameters['lob']));
        $filter_parameters['lob']=strtoupper($lob);
        $is_my_member = 0;
        if(array_key_exists('isMyMember',$filter_parameters))
        {
            $is_my_member = $filter_parameters['isMyMember'];
        }

        $base_sort_by = $filter_parameters['baseSortBy'];
        $base_sort_order = $filter_parameters['baseSortOrder']==0?'ASC':'DESC';
        $sort_by = $filter_parameters['sortBy']; 
        $sort_order = $filter_parameters['sortOrder']==0?'ASC':'DESC';

        $start =$min;
        $offset = $max - $min;

        $sql_global_member_query = array();

     $tab_filter_data['status']=ArrayUtility::convertArrayToString(
            [
                "","Pending","Call Back","F2F Call Back","Scheduled",
                "Rescheduled","Completed","Refusal","Cancellation","F2F No Show","Virtual No Show","UTC"
            ],"_"
        );

 $tab_filter_data['hraStatus']=ArrayUtility::convertArrayToString([MemberUtility::UNSCHEDULED],'_');

        if($is_unassigned)
        {
            $tab_filter_data['status']=ArrayUtility::convertArrayToString(
                [
                    "","Pending","Call Back","F2F Call Back","Refusal","Cancellation","F2F No Show","Virtual No Show"
                ],"_"
            );
        }

        if($is_my_member)
        {
            $tab_filter_data['status']=ArrayUtility::convertArrayToString(
                [
                    "","Pending","Call Back","F2F Call Back","Cancellation","F2F No Show","Virtual No Show"
                ],"_"
            );
        }


        if(array_key_exists('planId',$filter_parameters))
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                                SchedulerGlobalMembers::convertToDefaultMemberSqlQuery(
                                                GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
                                                self::getSchedulerRequiredColumnAsString())
                                                )
                                            );
        }
        else
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                                SchedulerGlobalMembers::convertToDefaultMemberSqlQuery(
                                                GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
                                                self::getSchedulerRequiredColumnAsString())
                                                )
                                            );
        }
        //if invalid user details sent                                                
        if(count($sql_global_member_query)==0) return FALSE;
                                                      
            //where clause array and condition
            $where_clause_contiditions = array();
            //if my member flag set show only this scheduler assighed member details
            if($is_my_member)
            {
                $my_member_filter['schedulerIds']=$user_id;
                $my_member_filter['column']="scheduler_id";
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('scheduler',$my_member_filter));   
            }

            //assigned and unassigned condition applied only when scheduler lead
            if($is_my_member==0)
            {
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseForAssignAndUnAssign($filter_parameters));
            } else{
                $disconnected_where_condition[] ="(";
                $disconnected_where_condition[] = GlobalQueryBuilder::whereClauseCustomColumnValueIn('reportStatus',$tab_filter_data,'status',true);
            //disconnected where clause condition
                $special_status_filter_data['status']=ArrayUtility::convertArrayToString(
                [
                    "Disconnected"
                ]);
                $attempt_filter_array['attemptCount'] = 5;
                $disconnected_where_condition[] = " OR ";
                $disconnected_where_condition[] = "(member_table.reportStatus IS NULL)";
                $disconnected_where_condition[] = " OR ";
                    $disconnected_where_condition[] = "(";
                    $disconnected_where_condition[] = GlobalQueryBuilder::whereClauseCustomColumnValueIn('reportStatus',$special_status_filter_data,'status',true);

                    $disconnected_where_condition[] = " AND ";
                    $disconnected_where_condition[] = GlobalQueryBuilder::whereClauseColumnSimpleJsonField('schedulerCallLogDetails',$attempt_filter_array,'attemptCount','attemptCount','<');
                    $disconnected_where_condition[] = ")";
                $disconnected_where_condition[] = ")";
                $disconnected_where_query_string = implode($disconnected_where_condition);
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,$disconnected_where_query_string);
}


            
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseCustomColumnValueIn('client_id',$filter_parameters,'clientId',true,'|',','));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('nurse',$filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('scheduler',$filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('qa',$filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('coder',$filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseScheduleDateBetween($filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseCustomColumnValueIn('reportStatus',$filter_parameters,'status',true));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseBySpecificScreeningEligibligy($filter_parameters));                                            
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseByScreeningEligibility('screening',$filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseLastCallLogWithSubResultIn($filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseCustomColumnValueIn('VisitType',$filter_parameters,'visitType',true));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseHraStatusIn($filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseCallBackStatus($filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseLastCallLogCallBackDateRange($filter_parameters));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseNextOutreachCallBackDateRange($filter_parameters));

            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'city','Member_City',true));
 // print_r($filter_parameters);die;
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'lob','LOB',true)); 
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'plan','Plan',true));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseColumnSimpleJsonFieldsIn('memberinfo',$filter_parameters,'program','Program',true)); 
            
                //print_r($where_clause_contiditions);die;
        if(count($where_clause_contiditions)==0) { $error="no valid filter option selected"; return FALSE;}  

            //if any valid where clause found append 'where'
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
            //if multiple where clause add 'and' else 'or' condition
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));
            //order query string
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,$sort_by,$base_sort_order,$sort_order));
            //limit string
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT ?,? ");
            //generated query 
            $generated_query = implode($sql_global_member_query);
            //echo $generated_query;exit();

            //prepare the member query
                if($conn->connect_errno)
                {
                    $error="datatbase connection failed";
                }
                //prepare the member query
                $member_query=$conn->prepare($generated_query);
                if($member_query===FALSE)
                {
                    $error = "error preparing sql query";
                    return FALSE;
                }
                //bind parameters
                $member_query->bind_param('ii',$start,$offset);
               
                if($member_query === FALSE)
                {
                    $error="parameter error";
                    return FALSE;
                }

                $member_query->execute();

                if($member_query === FALSE)
                {
                    $error="error in sql query";
                    return FALSE;
                }

                $member_query_result = $member_query->get_result();
                ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$conn->error));
        
        return TRUE;
    }


    /*
        NAME    : search
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public function search($search_parameters,&$error)
    {
        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $search_parameters['planId'];
        $user_id = $search_parameters['userId'];
        $year = $search_parameters['year'];
        $min = $search_parameters['min'];
        $max = $search_parameters['max'];

        $is_my_member = 0;
        if(array_key_exists('isMyMember',$search_parameters))
        {
            $is_my_member = $search_parameters['isMyMember'];
        }

        $base_sort_by = $search_parameters['baseSortBy'];
        $base_sort_order = $search_parameters['baseSortOrder']==0?'ASC':'DESC';
        $sort_by = $search_parameters['sortBy']; 
        $sort_order = $search_parameters['sortOrder']==0?'ASC':'DESC';

        $start =$min;
        $offset = $max - $min;

        $sql_global_member_query = array();
        if(array_key_exists('planId',$search_parameters))
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                                SchedulerGlobalMembers::convertToDefaultMemberSqlQuery(
                                                GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
                                                self::getSchedulerRequiredColumnAsString_search()))
                                                );
        }
        else
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                                    SchedulerGlobalMembers::convertToDefaultMemberSqlQuery(
                                                    GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
                                                    self::getSchedulerRequiredColumnAsString_search()))
                                                    );
        }

        //if invalid user details sent                                                
        if(count($sql_global_member_query)==0) return FALSE;  
            //where clause array and condition
            $where_clause_contiditions = array();
            //if my member flag set show only this scheduler assighed member details
            if($is_my_member)
            {
                $my_member_filter['schedulerIds']=$user_id;
                $my_member_filter['column']="scheduler_id";
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('scheduler',$my_member_filter));   
            }
            //search where clause condition 
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByColumnLike('firstname',$search_parameters,'firstname'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByColumnLike('lastname',$search_parameters,'lastname'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberId($search_parameters,'id'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('Plan',$search_parameters,'plan'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('Program',$search_parameters,'program'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('LOB',$search_parameters,'lob'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('Member_City',$search_parameters,'city'));
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::searchByMemberInfoField('Member_Zip_Code',$search_parameters,'zip'));
        
        if(count($where_clause_contiditions)==0) { $error="invalid search value"; return FALSE;}   

            //if any valid where clause found append 'where'
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
            //if multiple where clause add 'and' else 'or' condition
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));
            
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,$sort_by,$base_sort_order,$sort_order));

            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT ?,? ");

            $generated_query = implode($sql_global_member_query);
                                                       
                if($conn->connect_errno)
                {
                    $error="database connection failed";
                }

                //prepare the member query
                $member_query=$conn->prepare($generated_query);
                if($member_query===FALSE)
                {
                    $error = "error preparing sql query";
                    return FALSE;
                }
                //bind parameters
                $member_query->bind_param('ii',$start,$offset);
               
                if($member_query === FALSE)
                {
                    $error="parameter error";
                    return FALSE;
                }

                $member_query->execute();

                if($member_query === FALSE)
                {
                    $error="error in sql query";
                    return FALSE;
                }

                $member_query_result = $member_query->get_result();
                ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$error));

            return TRUE;
   
    }

    /*
        NAME    : search
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public function getDisableMembers($parameters,&$error)
    {

        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $parameters['planId'];
        $user_id = $parameters['userId'];
        $year = $parameters['year'];
        $min = $parameters['min'];
        $max = $parameters['max'];

        $is_my_member = 0;
        if(array_key_exists('isMyMember',$parameters))
        {
            $is_my_member = $parameters['isMyMember'];
        }

        $base_sort_by = $parameters['baseSortBy'];
        $base_sort_order = $parameters['baseSortOrder']==0?'ASC':'DESC';
        $sort_by = $parameters['sortBy']; 
        $sort_order = $parameters['sortOrder']==0?'ASC':'DESC';

        $start =$min;
        $offset = $max - $min;
        //only show folowing scheduler status 
        //and where cause condition to be 'OR' so combine and consider both the condition as single where clause
        $tab_filter_data['status']=ArrayUtility::convertArrayToString(
            [
                "Wrong Number","Disconnected","Ineligible","Deceased",
                "Hospice","Other","UTC","Termed"
            ],"_"
        );
        $tab_filter_data['hraStatus']=ArrayUtility::convertArrayToString([MemberUtility::HRA_NOT_DUE],'_');
       
        $sql_global_member_query = array();
        if(array_key_exists('planId',$parameters))
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                                                SchedulerGlobalMembers::convertToDefaultMemberSqlQuery(
                                                                GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
                                                                self::getSchedulerRequiredColumnAsString()))
                                                            );
        }
        else
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                                                SchedulerGlobalMembers::convertToDefaultMemberSqlQuery(
                                                                GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
                                                                self::getSchedulerRequiredColumnAsString()))
                                                            );
        }
        //if invalid user details sent                                                
        if(count($sql_global_member_query)==0) return FALSE;  
            //where clause array and condition
            $where_clause_contiditions = array();
             //if my member flag set show only scheduler assighed member details
            if($is_my_member)
            {
                $my_member_filter['schedulerIds']=$user_id;
                $my_member_filter['column']="scheduler_id";
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('scheduler',$my_member_filter));   
            }
            //disabled tab members 
            $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,'('.GlobalQueryBuilder::whereClauseHraStatusIn($tab_filter_data).' OR '.GlobalQueryBuilder::whereClauseCustomColumnValueIn('reportStatus',$tab_filter_data,'status',true).')');
            //if any valid where clause found append 'where'
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
            //if multiple where clause add 'and' else 'or' condition
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));
            //sort by query string                                       
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,$sort_by,$base_sort_order,$sort_order));
            //                                            
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT ?,? ");

            $generated_query = implode($sql_global_member_query);
            //echo $generated_query;exit();   
            //prepare the member query                                   
            if($conn->connect_errno)
            {
                $error="database connection failed";
            }
            //prepare the member query
            $member_query=$conn->prepare($generated_query);
            if($member_query===FALSE)
            {
                $error = "error preparing sql query";
                return FALSE;
            }
            //bind parameters
            $member_query->bind_param('ii',$start,$offset);
           
            if($member_query === FALSE)
            {
                $error="parameter error";
                return FALSE;
            }

            $member_query->execute();

            if($member_query === FALSE)
            {
                $error="error in sql query";
                return FALSE;
            }

            $member_query_result = $member_query->get_result();
            ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$conn->error));
            
        return TRUE;

    }

    /*
        NAME    : getMembers
        TYPE    : global Utiltiy function 
        DETAILS : 
        RETURN  : 
    */
    public function getMembers($parameters,&$error)
    {
        //database connection
        include("../db.php");
        //custom parameter datas
        $plan_id = $parameters['planId'];
        $user_id = $parameters['userId'];
        $year = $parameters['year'];
        $min = $parameters['min'];
        $max = $parameters['max'];

        $is_my_member = 0;
        if(array_key_exists('isMyMember',$parameters))
        {
            $is_my_member = $parameters['isMyMember'];
        }

        $is_unassigned = 0;
        if(array_key_exists('unAssigned',$parameters))
        {
            $is_unassigned = $parameters['unAssigned'];
        }

        //sort arder
        $base_sort_by = $parameters['baseSortBy'];
        $base_sort_order = $parameters['baseSortOrder']==0?'ASC':'DESC';
        $sort_by = $parameters['sortBy']; 
        $sort_order = $parameters['sortOrder']==0?'ASC':'DESC';

        $start =$min;
        $offset = $max - $min;

        //only show folowing scheduler status  and hra status in member tab
        //and where cause condition to be 'OR' so combine and consider both the condition as single where clause
        $tab_filter_data['status']=ArrayUtility::convertArrayToString(
            [
                "","Pending","Call Back","F2F Call Back","Scheduled",
                "Rescheduled","Completed","Refusal","Cancellation","F2F No Show","Virtual No Show"
            ],"_"
        );
        $tab_filter_data['hraStatus']=ArrayUtility::convertArrayToString([MemberUtility::UNSCHEDULED],'_');

        //status condition altered for unassigned condition
        if($is_unassigned)
        {
            $tab_filter_data['status']=ArrayUtility::convertArrayToString(
                [
                    "","Pending","Call Back","F2F Call Back","Refusal","Cancellation","F2F No Show","Virtual No Show"
                ],"_"
            );
        }
        //status condition when my member enabled
        if($is_my_member)
        {
            $tab_filter_data['status']=ArrayUtility::convertArrayToString(
                [
                    "","Pending","Call Back","F2F Call Back","Cancellation","F2F No Show","Virtual No Show"
                ],"_"
            );
        }

        $sql_global_member_query = array();
        if(array_key_exists('planId',$parameters))
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                                            SchedulerGlobalMembers::convertToDefaultMemberSqlQuery(
                                                            GlobalQueryBuilder::generateMemberQueryBasedOnPlanAndClientPrivilege($plan_id,$user_id,$year,
                                                            self::getSchedulerRequiredColumnAsString()))
                                                        );
        }
        else
        {
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,
                                                            SchedulerGlobalMembers::convertToDefaultMemberSqlQuery(
                                                            GlobalQueryBuilder::generateMemberQueryBasedOnClientPrivilege($user_id,$year,
                                                            self::getSchedulerRequiredColumnAsString()))
                                                        );
        }
        
        //when invalid userid sent
        if(count($sql_global_member_query)==0) return FALSE; 

            //where clause array and condition
            $where_clause_contiditions = array();
            if($is_my_member)
            {
                $my_member_filter['schedulerIds']=$user_id;
                $my_member_filter['column']="scheduler_id";
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseUserIdIn('scheduler',$my_member_filter));   
            }

            //assigned and unassigned condition applied only when scheduler lead
            if($is_my_member==0)
            {
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,GlobalQueryBuilder::whereClauseForAssignAndUnAssign($parameters));
            }
            else
            {
                //scheduler status my member condition
                    $disconnected_where_condition[] ="(";
                    $disconnected_where_condition[] = GlobalQueryBuilder::whereClauseCustomColumnValueIn('reportStatus',$tab_filter_data,'status',true);
                //disconnected where clause condition
                    $special_status_filter_data['status']=ArrayUtility::convertArrayToString(
                    [
                        "Disconnected"
                    ]);
                    $attempt_filter_array['attemptCount'] = 5;
                    $disconnected_where_condition[] = " OR ";
 $disconnected_where_condition[] = " (member_table.reportStatus IS NULL) OR";
                        $disconnected_where_condition[] = "(";
                        $disconnected_where_condition[] = GlobalQueryBuilder::whereClauseCustomColumnValueIn('reportStatus',$special_status_filter_data,'status',true);
                        $disconnected_where_condition[] = " AND ";
                        $disconnected_where_condition[] = GlobalQueryBuilder::whereClauseColumnSimpleJsonField('schedulerCallLogDetails',$attempt_filter_array,'attemptCount','attemptCount','<');
                        $disconnected_where_condition[] = ")";
                    $disconnected_where_condition[] = ")";
                    $disconnected_where_query_string = implode($disconnected_where_condition);
                $where_clause_contiditions = ArrayUtility::appendIfNotFalse($where_clause_contiditions,$disconnected_where_query_string);
            }
          
            //if any valid where clause found append 'where'
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,(count($where_clause_contiditions)>0?' WHERE ':''));
            //if multiple where clause add 'and' else 'or' condition
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,ArrayUtility::joinArrayByDelimiter($where_clause_contiditions,' AND '));
            //sort by query string
            if($sort_by == 'name'){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'name_schedule',$base_sort_order,$sort_order));
            }elseif($sort_by == "city"){
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,'city_schedule',$base_sort_order,$sort_order));
            }else{
                $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query,GlobalQueryBuilder::orderBy('scheduler',$base_sort_by,$sort_by,$base_sort_order,$sort_order));
            }
            
            //limit by range
            $sql_global_member_query = ArrayUtility::appendIfNotFalse($sql_global_member_query," LIMIT ?,? ");
            //genarated query
            $generated_query = implode($sql_global_member_query);
           //echo $generated_query;exit();   

                                   
                if($conn->connect_errno)
                {
                    $error="database connection failed";
                }

                //prepare the member query
                $member_query=$conn->prepare($generated_query);
                if($member_query===FALSE)
                {
                    $error = "error preparing sql query";
                    return FALSE;
                }
                //bind parameters
                $member_query->bind_param('ii',$start,$offset);
               
                if($member_query === FALSE)
                {
                    $error="parameter error";
                    return FALSE;
                }

                $member_query->execute();

                if($member_query === FALSE)
                {
                    $error="error in sql query";
                    return FALSE;
                }

            $member_query_result = $member_query->get_result();
            ResponseUtility::echoJsonObject($this->queryResultResponse($member_query_result,$error));

        return TRUE;
        
    }

   
}


?>