<?php

    /*
        SCHEDULER RELATED UTILTIY FUNCTION

    */
    require_once("../TimeZone.php");
    require_once("../utility/ArrayUtility.php");
    require_once("../utility/DataBaseUtility.php");
    require_once("../member/MemberUtility.php");
    require_once("../report/ReportStatus.php");
    require_once("../scheduler/SchedulerCallOrderUtility.php");

    class SchedulerUtility
    {
        /*
            SCHEDULER GLOBAL CONST VALUES
        */
        
        //SCHEDULER CALL STATUS CONTIDION
        const UNSCHEDULED = 0; //0 - scheduled
        const SCHEDULED = 1;//1 - unscheduled
        const DISCONNECT_WRONG_NUMBER = 2; //2 - disconnected/wrong number
        const MOVE_TO_UTC_FIVE_DISPOSITIONS = 3; //3 - MovedToUtc 
        const TEN_MONTH_NOT_EXCEED = 4;//4 -ten month after scheduled date only
        const SCHEDULER_DEACTIVATED = 5;//5- when scheduler deactivated , need to clarify with ...

        //scheduler call status notification (SCSN)
        const SCHN_MOBILE_CHANGED = 0;
        const SCSN_NO_SHOW_CANCELLATION = 1;
        const SCSN_SCHEDULER_DEACTIVATED =2;

        //call count calculation condition type
        //scheduler call log count contiton (SCLC)
        const SCLC_CONTITION_DEFAULT = 0;
        const SCLC_CONTITION_NOSHOW = 1;
       

        //Attempts 1-3 within N business days
        const FIRST_BUSINESS_DAYS = 5;
        const FIRST_BUSINESS_DAY_CALL_LOG_COUNT = 3;
        //after 3rd attempt  N business days
        const SECOND_BUSINESS_DAYS = 7;
        const SECOND_BUSINESS_DAY_CALL_LOG_COUNT = 1;
        //after 4rd attempt  N business days
        const THIRD_BUSINESS_DAYS = 7;
        const THIRD_BUSINESS_DAY_CALL_LOG_COUNT = 1;

        /*
            NAME : OnSchedulerDeactivated
            DETAILS : When user type of scheduler deactivated 
                      remove that scheduler id from member
                    
        */
        public static function OnSchedulerDeactivated($unique_user_id,$status) 
        {   
                //database connection
                include("../db.php");
                //when user deactivated
                //check the user type if it scheduler
                //get the members list with scheduler id 
                //remove the scheduler id column with null value when scheduler deactivated
                //where member hraStatus null and hraStatus = 0
                //read the member hraStatus and scheduler details

                if($status==0)
                {
                    $user_details = DataBaseUtility::getUserById($unique_user_id);
                    if($user_details)
                    {
                        if($user_details["type"]=="scheduler")
                        {
                            TimeZone::useTimeZone();   
                            $current_date = date('m-d-Y H:i:s');
                            $scheduler_notification = self::generateSchedulerNotification(SchedulerUtility::SCSN_SCHEDULER_DEACTIVATED,
                                                                    SchedulerUtility::UNSCHEDULED,"");

                            $scheduler_call_hra_status  = array(
                                'status'=>self::UNSCHEDULED,
                                'date'=>$current_date,
                                'details'=>"scheduler deactivated",
                                'notification'=>$scheduler_notification,
                                'disabled'=>false
                            );

                            $scheduler_call_hra_json = json_encode($scheduler_call_hra_status);
                            DataBaseUtility::runSqlQueryOnAllClientYears(function($client_id,$client_year) use ($unique_user_id,$scheduler_call_hra_json)
                            {
                                $client_year_table_name ="HRA_member_".$client_id."_".$client_year;
                                $scheduler_deactivated_sql_query = "UPDATE $client_year_table_name SET schedulerCallHraStatus = '$scheduler_call_hra_json' 
                                                                where scheduler_id = '$unique_user_id' AND 
                                                                (hraStatus IS NULL OR JSON_CONTAINS(`hraStatus`,0,'$.hraStatus')) AND 
                                                                (scheduleDate =' ' OR scheduleDate IS NULL)";
                                
                                //DataBaseUtility::runUpdateSqlQuery($scheduler_deactivated_sql_query);
                            }
                            );
                        }
                    } 
                    
                }

             return false;
            
        }

        /*
                NAME : OnSchedulerCallHraStatusChanged 
                DETAILS :
                    //scheduler call status 
                    0 - unscheduled
                    1 - scheduled
                    2 - disconnected/wrong number
                    3 - MovedToUtc (Left Voicemail,Mailbox Full,No Vm Setup,Line Busy,Dead Air)
                    other hra call status addedd in futrue
                    4 - termemd member (pending)
                    5 - last year member (pending)
                    .... 
                    .... 
                    SAMPLE FORMAT
                    -------------
                    schedulerCallHraStatus db column format
                        { "status":0,"date":"02-03-2021","details":"scheduled","disabled":true}
                            
                            status - in which sttaus a member for a scheduler /scheduler lead
                            date - date at which the the status moved
                            details - description regarding the status changes
                            disabled - which is used to dispaly a member in scheduler dashboard ( 3rd tab ) or not 

                        { "status":1,"date":"02-03-2021","details":"unscheduled","disabled":false}
                        { "status":2,"date":"02-03-2021","details":"disconnected/wrong number","disabled":true }
                        { "status":3,"date":"02-03-2021","details":"MovedToUtc","disabled":true }
                    
                        Example :
                        when member's scheduler hra call status { "status":2,"date":"02-03-2021","details":"disconnected/wrong number","disabled":true },
                        when member mobile number change in demographics , schedulerCallHraStatus will be changed as follows
                        { "status":1,"date":"02-03-2021","details":"mobile numbaer changed","disabled":false }

        */
        public static function OnSchedulerCallHraStatusChanged($call_hra_status,$client_id,$year,$member_id,
                        $recent_call_logs=null,$hra_status_array=null,$enable_hra_status_updation=true)
        {

            TimeZone::useTimeZone();
            $current_date = date('m-d-Y H:i:s');
            //read the member hraStatus and scheduler details
            $member_details = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,["schedulerCallHraStatus"]);
            $call_hra_status_array = json_decode($member_details["schedulerCallHraStatus"],true);
            if($call_hra_status_array=="" || $call_hra_status_array==NULL)
            {
                $default_call_hra_status='{ "status":0,"date":"","details":"unscheduled","notification":null,"disabled":false }';
                $call_hra_status_array = json_decode($default_call_hra_status,true);
            }

            $recent_call_log_scheduler = "";
            if($recent_call_logs!=null)
            {
                if(count($recent_call_logs)>0)
                {
                    $recent_call_log = $recent_call_logs[0];
                    $recent_call_log_scheduler = $recent_call_log["scheduler"];
                }
            }

            switch($call_hra_status)
            {   
                case self::UNSCHEDULED:
                    $details = "unscheduled by ".$recent_call_log_scheduler;
                    DataBaseUtility::updateSchedulerCallHraInDatabase($client_id,$year,$member_id,self::UNSCHEDULED,$current_date,$details,false);
                break;

                case self::SCHEDULED:
                    if(is_array($call_hra_status_array) && array_key_exists("status",$call_hra_status_array))
                    {
                        //only change scheduler call hra status to scheduled only when unscheduled state 
                        $saved_call_hra_status = $call_hra_status_array['status'];
                        if($saved_call_hra_status == self::UNSCHEDULED)
                        {
                            $details = "scheduled by ".$recent_call_log_scheduler;
                            DataBaseUtility::updateSchedulerCallHraInDatabase($client_id,$year,$member_id,self::SCHEDULED,$current_date,$details,false);
                        }
                    }
                break;

                case self::MOVE_TO_UTC_FIVE_DISPOSITIONS:
                    if(is_array($call_hra_status_array) && array_key_exists("status",$call_hra_status_array))
                    {
                        $saved_call_hra_status = $call_hra_status_array['status'];

                    include("../db.php");
$getattemptcount = "select * from HRA_member_".$client_id.'_'.$year." where member_id ='$member_id'";
$getattemptcountresult=mysqli_query($conn,$getattemptcount);
$getattemptcount_row=mysqli_fetch_array($getattemptcountresult,MYSQLI_ASSOC);

$schedulerCallLogDetails = $getattemptcount_row['schedulerCallLogDetails']; 
$decodedata = json_decode($schedulerCallLogDetails,true);
//print_r($decodedata);
$attemptcount = $decodedata['attemptCount'];

                        if($saved_call_hra_status!=self::MOVE_TO_UTC_FIVE_DISPOSITIONS  && $attemptcount >= 5)
                        {
                            $details = "moved to utc";
                            $call_hra_status_move_to_utc = array(

                                'status'=>self::MOVE_TO_UTC_FIVE_DISPOSITIONS,
                                'date'=>$current_date,
                                'details'=>$details,
                                'notification'=>null,
                                'disabled'=>true
                            );

                            //only update hra status when this flag enabled.
                            //this used when scheduler tracker excel file import
                            if($enable_hra_status_updation)
                            {
                                //update the hra status to UTC 
                                if(is_array($hra_status_array) && array_key_exists("hraStatus",$hra_status_array))
                                {
                                    $hra_status_array["hraStatus"]=MemberUtility::UTC;
                                }
                                else
                                {
                                    $hra_status_json_string ='{"hraStatus":"", "subStatus": "", "cancelStatus": "","cancelText": ""}';
                                    $hra_status_array=json_decode($hra_status_json_string,true);
                                    $hra_status_array["hraStatus"]=MemberUtility::UTC;
                                }

                                $column_name_list =['hraStatus','schedulerCallHraStatus'];
                                $column_value_list=[json_encode($hra_status_array),json_encode($call_hra_status_move_to_utc)];
                                DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);

                                ReportStatus::updateReportStatusByEnum($client_id,$year,$member_id,ReportStatus::UTC);
                                ReportStatus::OnAddReportStatusHistory($client_id,$year,$member_id,ReportStatus::UTC);
                            }
                            else
                            {
                                $column_name_list =['schedulerCallHraStatus'];
                                $column_value_list=[json_encode($call_hra_status_move_to_utc)];
                                DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);   
                            }
                        }
                    }
                break;

                case self::DISCONNECT_WRONG_NUMBER:
                    $details = "disconnected/wrong number";
                    DataBaseUtility::updateSchedulerCallHraInDatabase($client_id,$year,$member_id,self::DISCONNECT_WRONG_NUMBER,$current_date,$details,true);
                break;

                case self::TEN_MONTH_NOT_EXCEED:
                    $details = "member previous year scheduled date not exceed 10 months";
                    DataBaseUtility::updateSchedulerCallHraInDatabase($client_id,$year,$member_id,self::TEN_MONTH_NOT_EXCEED,$current_date,$details,true);
                break;

                case self::SCHEDULER_DEACTIVATED:
                    $details = "member previous year scheduled date not exceed 10 months";
                    DataBaseUtility::updateSchedulerCallHraInDatabase($client_id,$year,$member_id,self::SCHEDULER_DEACTIVATED,$current_date,$details,false);
                break;

            }


        }
        

        /*
            NAME    : OnCallLogSchedulerCallHraStatus
            TYPE    : static global Utiltiy function 
            DETAILS : Utility function to move scheduler hra call status and hra status as per call log details  
        */
        public static function OnCallLogSchedulerCallHraStatus($client_id,$year,$member_id,$scheduler_current_call_result,
                                                        $recent_call_logs,$hra_status_array,
                                                        $enable_hra_status_updation,$import_custom_data=null,$scheduler_call_status_array=null)
        {
            //only when tool call log made
            if($import_custom_data==null)
            {
                //clear call order if any call result added
                SchedulerCallOrderUtility::clearCallOrder($client_id,$year,$member_id);
            }

            $disabled_status = false;
            switch($scheduler_current_call_result)
            {
                case MemberUtility::CALL_RESULT_SCHEDULED:
                case MemberUtility::CALL_RESULT_RESCHEDULED:
                    //because normal api call work flow hra status updated by hraStatus api call
                    if($import_custom_data)
                    {
                        $hra_status_updated=DataBaseUtility::updateHraStatus($client_id,$year,$member_id,MemberUtility::SCHEDULED,MemberUtility::UNSCHEDULED);
                        if($hra_status_updated)
                        {
                            //hra status
                            $hra_user_name=$import_custom_data['hraUsername'];
                            $current_call_date = str_replace('@','T',DateUtility::getRecentCallLogDate($recent_call_logs,"Y-m-d@H:i"));
                            if( $current_call_date && $hra_user_name)
                            {
                                self::updateHraStatusHistory($client_id,$year,$member_id,MemberUtility::SCHEDULED,$hra_user_name,$current_call_date);
                            }

                        }
                    }
                    self::OnSchedulerCallHraStatusChanged(self::SCHEDULED,$client_id,$year,$member_id,$recent_call_logs,$hra_status_array,$enable_hra_status_updation);
                break;
                
                case MemberUtility::CALL_RESULT_DEAD_AIR:
                case MemberUtility::CALL_RESULT_LINE_BUSY:
                case MemberUtility::CALL_RESULT_NO_ANSWER:
                case MemberUtility::CALL_RESULT_CALLER_DISCONNECTED:
                    $is_no_show_contion_meets = -1;
                    if($import_custom_data==null)//tool only
                    {
                        $no_show_condition=self::checkAndUpdatedNoShowCancellation2ndAttempt($scheduler_call_status_array,$recent_call_logs);
                        if($no_show_condition==1)
                        {
                            self::OnSchedulerCallHraStatusChanged(self::MOVE_TO_UTC_FIVE_DISPOSITIONS,$client_id,$year,$member_id,
                                                    $recent_call_logs,$hra_status_array,$enable_hra_status_updation);
                            $disabled_status = true;
                            $is_no_show_contion_meets = 1;
                        }
                    }

                    if(count($recent_call_logs)>=5 &&  $is_no_show_contion_meets==-1)
                    {
                        $is_condition_meets = self::callResultConditionalResponse(self::SCLC_CONTITION_DEFAULT,$recent_call_logs);
                        if($is_condition_meets)
                        {
                            if($import_custom_data)
                            {
                                //updated hra status  
                                $hra_status_updated = DataBaseUtility::updateHraStatus($client_id,$year,$member_id,MemberUtility::UTC,MemberUtility::UNSCHEDULED);
                                if($hra_status_updated)
                                {
                                    //hra status history updated
                                    $hra_user_name=$import_custom_data['hraUsername'];
                                    $hra_assigned_date = str_replace('@','T',DateUtility::getRecentCallLogDate($recent_call_logs,"Y-m-d@H:i"));

                                    if( $hra_assigned_date && $hra_user_name)
                                    {
                                        self::updateHraStatusHistory($client_id,$year,$member_id,MemberUtility::UTC,$hra_user_name,$hra_assigned_date);
                                    }
                                }
                            }

                            self::OnSchedulerCallHraStatusChanged(self::MOVE_TO_UTC_FIVE_DISPOSITIONS,$client_id,$year,$member_id,
                                                        $recent_call_logs,$hra_status_array,$enable_hra_status_updation);
                            $disabled_status = true;
                        }
                    }
                break;

                case MemberUtility::CALL_RESULT_WRONG_NUMBER:
                    self::OnSchedulerCallHraStatusChanged(self::DISCONNECT_WRONG_NUMBER,$client_id,$year,$member_id,
                                                    $recent_call_logs,$hra_status_array,$enable_hra_status_updation);
                    $disabled_status = true;
                break;

                case MemberUtility::CALL_RESULT_DISCONNECTED:
                    //if status unscheduled with no show /cancellation status
                    $is_no_show_condition_meets = -1;
                    if($import_custom_data==null)//tool only
                    {
                        $no_show_condition=self::checkAndUpdatedNoShowCancellation2ndAttempt($scheduler_call_status_array,$recent_call_logs);
                        if($no_show_condition==1)
                        {

                            self::OnSchedulerCallHraStatusChanged(self::MOVE_TO_UTC_FIVE_DISPOSITIONS,$client_id,$year,$member_id,
                                                            $recent_call_logs,$hra_status_array,$enable_hra_status_updation);

                            $disabled_status = true;
                            $is_no_show_condition_meets = 1;
                        }
                    }

                    if(count($recent_call_logs)>=5 &&  $is_no_show_condition_meets==-1)
                    {
                        $is_condition_meets = self::callResultConditionalResponse(self::SCLC_CONTITION_DEFAULT,$recent_call_logs);
                        if($is_condition_meets)
                        {
                            self::OnSchedulerCallHraStatusChanged(self::DISCONNECT_WRONG_NUMBER,$client_id,$year,$member_id,
                                                        $recent_call_logs,$hra_status_array,$enable_hra_status_updation);
                            $disabled_status = true;
                        }
                    }
                break;

                case MemberUtility::CALL_RESULT_CALL_BACK_REQUESTED:
                case MemberUtility::CALL_RESULT_F2F_CALLBACK:
                       
                break;

                case MemberUtility::CALL_RESULT_REFUSAL:
                    //because normal work flow hra status updated by hraStatus api call
                    if($import_custom_data)
                    {
                        $hra_status_updated = DataBaseUtility::updateHraStatus($client_id,$year,$member_id,MemberUtility::PATIENT_REFUSAL,MemberUtility::UNSCHEDULED);
                        if($hra_status_updated)
                        {
                            //hra status 
                            $hra_user_name=$import_custom_data['hraUsername'];
                            $hra_assigned_date = str_replace('@','T',DateUtility::getRecentCallLogDate($recent_call_logs,"Y-m-d@H:i"));

                            if( $hra_assigned_date && $hra_user_name)
                            {
                                self::updateHraStatusHistory($client_id,$year,$member_id,MemberUtility::PATIENT_REFUSAL,$hra_user_name,$hra_assigned_date);
                            }

                        }
                    }
                break;

                case MemberUtility::CALL_RESULT_DECEASED:
                    //because normal work flow hra status updated by hraStatus api call
                    if($import_custom_data)
                    {
                        $hra_status_updated = DataBaseUtility::updateHraStatus($client_id,$year,$member_id,MemberUtility::DECEASED,MemberUtility::UNSCHEDULED);
                        if($hra_status_updated)
                        {
                            //hra status 
                            $hra_user_name=$import_custom_data['hraUsername'];
                            $hra_assigned_date = str_replace('@','T',DateUtility::getRecentCallLogDate($recent_call_logs,"Y-m-d@H:i"));

                            if( $hra_assigned_date && $hra_user_name)
                            {
                                self::updateHraStatusHistory($client_id,$year,$member_id,MemberUtility::DECEASED,$hra_user_name,$hra_assigned_date);
                            }
                            
                        }
                    }
                break;

                case MemberUtility::CALL_RESULT_HOSPICE:
                    //because normal work flow hra status updated by hraStatus api call
                    if($import_custom_data)
                    {
                        $hra_status_updated=DataBaseUtility::updateHraStatus($client_id,$year,$member_id,MemberUtility::HOSPICE,MemberUtility::UNSCHEDULED);
                        if($hra_status_updated)
                        {
                             //hra status 
                             $hra_user_name=$import_custom_data['hraUsername'];
                             $hra_assigned_date = str_replace('@','T',DateUtility::getRecentCallLogDate($recent_call_logs,"Y-m-d@H:i"));
 
                             if( $hra_assigned_date && $hra_user_name)
                             {
                                 self::updateHraStatusHistory($client_id,$year,$member_id,MemberUtility::HOSPICE,$hra_user_name,$hra_assigned_date);
                             } 
                        }
                    }
                break;

                case MemberUtility::CALL_RESULT_INELIGIBLE:
                    //because normal work flow hra status updated by hraStatus api call
                    if($import_custom_data)
                    {
                        $hra_status_updated=DataBaseUtility::updateHraStatus($client_id,$year,$member_id,MemberUtility::IN_ELIGIBILE,MemberUtility::UNSCHEDULED);
                        if($hra_status_updated)
                        {
                           //hra status 
                           $hra_user_name=$import_custom_data['hraUsername'];
                           $hra_assigned_date = str_replace('@','T',DateUtility::getRecentCallLogDate($recent_call_logs,"Y-m-d@H:i"));

                           if( $hra_assigned_date && $hra_user_name)
                           {
                               self::updateHraStatusHistory($client_id,$year,$member_id,MemberUtility::IN_ELIGIBILE,$hra_user_name,$hra_assigned_date);
                           } 
                               
                        }
                    }
                break;

   
            }

            return $disabled_status;
        }

         
        /*
            NAME    : updateHraStatusHistory
            TYPE    : static internal Utiltiy function 
            DETAILS : Ut   
        */
        private static function updateHraStatusHistory($client_id,$year,$member_id,$hra_status_index,$hra_user_name,$hra_assigned_date)
        {
           
            $resultData=MemberUtility::OnAddHraStatusHistory($client_id,$year,$member_id,$hra_status_index,$hra_user_name,$hra_assigned_date);
            $result_success = $resultData['success'];
            $hra_history_updated = $resultData['updatedJsonHistory'];
            if($result_success)
            {
                //hraStatusHistory
                $column_name_list =['hraStatusHistory'];
                $column_value_list=[$hra_history_updated];
                DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
            }
        }

         /*
            NAME    : updateHraCancelHistory
            TYPE    : static internal Utiltiy function 
            DETAILS : "notification": {"type": 0, "value": "", "previous_status": 3}
        */
        private static function checkAndUpdatedNoShowCancellation2ndAttempt($scheduler_call_status_array,$recent_call_logs)
        {
            if($scheduler_call_status_array && is_array($scheduler_call_status_array))
            {
                $status = $scheduler_call_status_array["status"];
                if($status == self::UNSCHEDULED)
                {
                    $notification_array = $scheduler_call_status_array["notification"];
                    if($notification_array && array_key_exists('type',$notification_array))
                    {
                        if($notification_array['type'] == self::SCSN_NO_SHOW_CANCELLATION)
                        {
                            $is_condition_meets = self::callResultConditionalResponse(self::SCLC_CONTITION_NOSHOW,$recent_call_logs);
                            if($is_condition_meets)
                            {
                                return 1;
                            }
                            else
                            {
                                return 0;
                            }
                        }
                        
                    }
                   
                }
            }

            return -1;
        }

        /*
            NAME    : updateHraCancelHistory
            TYPE    : static internal Utiltiy function 
            DETAILS : Ut   
        */
        private static function updateHraCancelHistory($client_id,$year,$member_id,$hra_user_name,$hra_status,$sub_status,$cancel_status,$cancel_text,$hra_assigned_date)
        {
           
            $resultData=MemberUtility::OnAddCancelHistory($client_id,$year,$member_id,$hra_user_name,$hra_status,$sub_status,$cancel_status,$cancel_text,$hra_assigned_date);
            $result_success = $resultData['success'];
            $hra_history_updated = $resultData['updatedJsonHistory'];
            if($result_success)
            {
                //hraStatusHistory
                $column_name_list =['hraStatusHistory'];
                $column_value_list=[$hra_history_updated];
                DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
            }
        }

        
        /*
            NAME    : getRecentSchedulerAssignedDate
            TYPE    : static global Utiltiy function 
            DETAILS : Utility function to get the date on which a member assigned to scheduler recently   
        */
        public static function getRecentSchedulerAssignedDate($scheduler_details_array)
        {
            //get the scheduler details internal sub field value
            $scheduler_details = $scheduler_details_array["scheduler_details"];
            $total_entry_count = count($scheduler_details);

            if($total_entry_count>=1)
            {
                //recently scheduler assigned date 
                $recent_assigned_details = $scheduler_details[$total_entry_count-1];
                if (array_key_exists('date', $recent_assigned_details))
                {
                    $recent_scheduler_assigned_date = $recent_assigned_details["date"];
                    return $recent_scheduler_assigned_date;
                }
 
            }

            return null;
 
        }

        /*
            NAME    : getSchedulerDetailsAndCallHraStatus
            TYPE    :  global Utiltiy function 
            DETAILS : 
        */
        public static function getSchedulerDetailsAndCallHraStatus($client_id,$year,$member_id)
        {
            $member_details = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,["scheduler_id","schedulerDetails","schedulerCallHraStatus"]);
            $scheduler_id = $member_details["scheduler_id"];
            $scheduler_details_array = json_decode($member_details["schedulerDetails"],true);
            $scheduler_hra_status_array = json_decode($member_details["schedulerCallHraStatus"],true);

            return array("schedulerId"=>$scheduler_id,"schedulerDetails"=>$scheduler_details_array,"schedulerCallHraStatus"=>$scheduler_hra_status_array);
        }

        /*
            NAME : OnCallLogAddedEvent
            TYPE : global event callbak
        */
        public static function OnCallLogAddedEvent($client_id,$year,$member_id)
        {
            //when new call log added  if any notification in mobile number changed 
            //remove value that field from 'notification' in schedulerHraCallStatus
            //$member_scheduler_call_hra_status['notification']
            //read the member hraStatus and scheduler details
            $member_details = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,["schedulerCallHraStatus"]);
            $member_scheduler_call_hra_status = json_decode($member_details["schedulerCallHraStatus"],true);
            if($member_scheduler_call_hra_status && is_array($member_scheduler_call_hra_status) && array_key_exists('notification',$member_scheduler_call_hra_status))
            {
                if($member_scheduler_call_hra_status['status'] == SchedulerUtility::UNSCHEDULED)
                { 
                    $schdeuler_notification=$member_scheduler_call_hra_status["notification"];
                    if($schdeuler_notification)
                    {
                        $schdeuler_notification_status=$member_scheduler_call_hra_status["notification"]["type"];
                        switch($schdeuler_notification_status)
                        {	
                            case SchedulerUtility::SCHN_MOBILE_CHANGED:
                                TimeZone::useTimeZone();
                                $member_scheduler_call_hra_status['date']=date('m-d-Y H:i:s');
                                $member_scheduler_call_hra_status['details']="call log added after mobile number altered";
                                $member_scheduler_call_hra_status['notification']=null;
                                //update database field
                                $column_name_list =['schedulerCallHraStatus'];
                                $column_value_list=[json_encode($member_scheduler_call_hra_status)];
                                DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
                            break;
                        }
                    }
                }
            }

        }

        /*
            NAME    : callResultConditionalResponse
            TYPE    : internal global Utiltiy function 
            DETAILS : common function to check can member schedule hra call status move to other status
                        when following call condition meets
        */
        private static function callResultConditionalResponse($contidition_state,$recent_call_logs)
        {
            $result_status = false;
            //condition not implemeneted yet if need use contidition_state based on last call result
            $filtered_call_result = ArrayUtility::getArrayFilter($recent_call_logs,
                function($array_value)
                { 
                    return  
    
                        (
                            $array_value["result"] == MemberUtility::CALL_RESULT_DEAD_AIR || 
                            (
                                $array_value["result"] == MemberUtility::CALL_RESULT_NO_ANSWER && // No Answer
                                (
                                    $array_value["noAnswer"] == self::subCallResultConstToInt(MemberUtility::LEFT_VOICEMAIL,MemberUtility::CALL_RESULT_NO_ANSWER,10)||
                                    $array_value["noAnswer"] == self::subCallResultConstToInt(MemberUtility::MAILBOX_FULL,MemberUtility::CALL_RESULT_NO_ANSWER,10)||
                                    $array_value["noAnswer"] == self::subCallResultConstToInt(MemberUtility::NO_VM_SETUP,MemberUtility::CALL_RESULT_NO_ANSWER,10)
                                )
                            ) ||
                            $array_value["result"] == MemberUtility::CALL_RESULT_WRONG_NUMBER ||
                            $array_value["result"] == MemberUtility::CALL_RESULT_CALL_BACK_REQUESTED ||
                            $array_value["result"] == MemberUtility::CALL_RESULT_LINE_BUSY ||
                            $array_value["result"] == MemberUtility::CALL_RESULT_REFUSAL ||
                            $array_value["result"] == MemberUtility::CALL_RESULT_DISCONNECTED ||
                            $array_value["result"] == MemberUtility::CALL_RESULT_OTHER ||
                            $array_value["result"] == MemberUtility::CALL_RESULT_CALLER_DISCONNECTED ||
                            $array_value["result"] == MemberUtility::CALL_RESULT_F2F_CALLBACK
                            
                        );

                }
            );

            switch($contidition_state)
            {
                case self::SCLC_CONTITION_DEFAULT:
                    if(count($filtered_call_result)>=5)
                    {
                        $result_status = true;
                    }
                break;

                case self::SCLC_CONTITION_NOSHOW:
                    if(count($filtered_call_result)>=2)
                    {
                        $result_status = true;
                    }
                break;

                default:
                    //if recent call log contains 5 logs that match above result and sub result value
                    if(count($filtered_call_result)>=5)
                    {
                        $result_status = true;
                    }
            }
            

            return  $result_status ;
        }

        /*
            NAME    : subCallResultConstToInt
            TYPE    : Utiltiy function 
            DETAILS : 
            RETURN  : 
        */
        public static function subCallResultConstToInt($sub_call_result,$parent_call_result,$sub_mul_factor)
        {
            return ($sub_call_result-$parent_call_result*$sub_mul_factor);
        }

        /*
            NAME    : getRecentSchedulerAssignedDetails
            TYPE    : static global Utiltiy function 
            DETAILS : Utility function to get the date on which a member assigned to scheduler recently   
        */
        public static function getRecentSchedulerAssignedDetails($scheduler_details_array)
        {
            if($scheduler_details_array)
            {
                //get the scheduler details internal sub field value
                $scheduler_details = $scheduler_details_array["scheduler_details"];
                $total_entry_count = count($scheduler_details);

                if($total_entry_count>=1)
                {
                    //recently scheduler assigned date 
                    $recent_assigned_details = $scheduler_details[$total_entry_count-1];
                    return $recent_assigned_details;
                }
            }

            return null;
        }

        /*
            NAME    : generateSchedulerNotificationAsJson
            TYPE    : static global Utiltiy function 
            DETAILS : 
        */
        public static function generateSchedulerNotification($type,$previous_status,$value)
        {
            $notification_array = array(
                "type"=>$type,
                "previous_status"=>$previous_status,
                "value"=>$value
            );
            
            return $notification_array;
        }

        /*
            NAME    : generateSchedulerCallLogDetails
            TYPE    : static global Utiltiy function 
            DETAILS : 
        */
        public static function generateSchedulerCallLogDetails($attempt_count)
        {
            $call_log_details_array = array(
                "attemptCount"=>$attempt_count
            );
            
            return $call_log_details_array;
        }

        /*
            NAME    : updateCallLogField
            TYPE    : static global Utiltiy function 
            DETAILS : 
        */
        public static function updateCallLogField($call_logs_array,$field_name,$field_value)
        {
            if($call_logs_array && is_array($call_logs_array))
            {
                $call_log_count = count($call_logs_array);
                for($cl=0;$cl<$call_log_count;$cl++)
                {
                    $call_log = $call_logs_array[$cl];
                    if(array_key_exists($field_name,$call_log))
                    {
                        $call_log[$field_name]=$field_value;
                    }
                    $call_logs_array[$cl] =  $call_log;
                }
            }

            return $call_logs_array;
        }

        /*
            NAME    : reAssignSchedulerDetails
            TYPE    : static global Utiltiy function 
            DETAILS : 
        */
        public static function reAssignSchedulerDetails($client_id,$year,$member_id)
        {
                $member_scheduler_details = SchedulerUtility::getSchedulerDetailsAndCallHraStatus($client_id,$year,$member_id);
                $member_scheduler_id = $member_scheduler_details['schedulerId'];
                $scheduler_details_array = $member_scheduler_details['schedulerDetails'];

                if($scheduler_details_array)
                {
                    $recent_scheduler_detail=SchedulerUtility::getRecentSchedulerAssignedDetails($scheduler_details_array);
                    if($recent_scheduler_detail)
                    {
                        $scheduler_id = $recent_scheduler_detail['schedulerId'];
                        $scheduler_lead_id = $recent_scheduler_detail['schedulerLeadId'];
                        if($member_scheduler_id==$scheduler_id) //update only when scheduler id matched
                        {
                            $scheduler_api = new SchedulerApiClass;
                            $appended_result=$scheduler_api->appendSchedulerDetails($client_id,$year,$member_id,$scheduler_lead_id,$scheduler_id);
                            $db_result = $appended_result['success'];
                            $scheduler_details_json = $appended_result['updated_scheduler_details'];
                            if($db_result)
                            {
                                //updated other database columns
                                $column_name_list =['schedulerDetails'];
                                $column_value_list=[$scheduler_details_json];
                                DataBaseUtility::updateMemberDatabseFields($client_id,$year,$member_id,$column_name_list,$column_value_list);
                            }
                        }
                    }
                }
                    
        }
            

    }

?>