<?php

//access control allow Header 
include("../AccessControlAllowHeader.php");

//other include files
require_once("../utility/JwtUtility.php");
require_once("../utility/FileIOUtility.php");
require_once("../TimeZone.php");
require_once("../member/HraFileChanges.php");

class update
{
	
	public function totalMember($clientId,$year)
	{
		include("../db.php");
		$total_count = "select * from HRA_member_".$clientId.'_'.$year."";
		try 
		{
			$allmemberinfo_result=mysqli_query($conn,$total_count);
			$total_cnt = mysqli_num_rows($allmemberinfo_result);
			$response = new stdClass();
			$response->count = $total_cnt;
			$response = json_encode($response);
			echo $response; // all memberinfo details in format of json object
		}
		catch (Exception $e)
		{
			$error = $e->getMessage();
			echo $error;
		}	
	}

	public function singleMemberDataInfo($clientId,$year,$req_id){
		include("../db.php");
		$memInfoDetails = "SELECT * FROM HRA_member_".$clientId.'_'.$year." LIMIT ".$req_id.",1";

		$memInfo_result=mysqli_query($conn,$memInfoDetails);
		$memInfo_row=mysqli_fetch_array($memInfo_result,MYSQLI_ASSOC);
		$memberinfo = $memInfo_row['memberinfo'];
		$member_id = $memInfo_row['member_id'];
		$hraFileUpdatedHistory = $memInfo_row['hraFileUpdatedHistory'];
		$fileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';		
		$getcontentdata = file_get_contents($fileepath);

	
		$mem_data=array("memberinfo"=>$memberinfo,"getcontentdata"=>$getcontentdata,"member_id"=>$member_id,"hraFileUpdatedHistory"=>$hraFileUpdatedHistory);
		//print_r($mem_data);
		echo json_encode($mem_data);
	}

	public function singleMemberData($clientId,$year,$req_id)
	{
		//echo "hii";
		include("../db.php");
		$allmemeber_recordquery="SELECT * FROM HRA_member_".$clientId.'_'.$year." LIMIT ".$req_id.",1";
		$allmemeber_result=mysqli_query($conn,$allmemeber_recordquery);
		$allmemeber_row=mysqli_fetch_array($allmemeber_result,MYSQLI_ASSOC);
		$member_id = $allmemeber_row['member_id'];
		$hra_status = json_decode($allmemeber_row['hraStatus'],true);
		$hra = $allmemeber_row['hra'];
		$exploded = explode("/",$hra);
		$lastpath=$exploded[9];
		$fifthpath=$exploded[8];
		//$member_id=11000030;
		$fileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';		
		$getcontentdata = file_get_contents($fileepath);			  
		$mem_data=array("member_id"=>$member_id,"hraStatus"=>$hra_status,"getcontentdata"=>$getcontentdata);
		//print_r($mem_data);
		echo json_encode($mem_data);
	}

	/*
		FUNCTION : getJson
		DETAILS : get the member json hra file content as response based on client id,year ans member id	
	*/
	public function getJson($clientId,$year,$member_id)
	{
		include("../db.php");
		$allmemeber_recordquery="select * from HRA_member_".$clientId.'_'.$year." where member_id='$member_id'";
		try 
		{
			$allmemberinfo_result=mysqli_query($conn,$allmemeber_recordquery);
			$allmemberinfo_row=mysqli_fetch_array($allmemberinfo_result,MYSQLI_ASSOC);
			if(mysqli_num_rows($allmemberinfo_result) == 1)
			{
				$fileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
				$hra_status = json_decode($allmemberinfo_row['hraStatus'],true);
				$getcontentdata = file_get_contents($fileepath);
				$member_data=array("member_id"=>$member_id,"hraStatus"=>$hra_status,"getcontentdata"=>$getcontentdata);
				echo json_encode($member_data);
			}
			else
			{
				$member_data=array("member_id"=>$member_id,"hraStatus"=>null,"getcontentdata"=>null);
				echo json_encode($member_data);
			}

		}
		catch(Exception $e)
		{
			$error = $e->getMessage();
			echo $error;
		}

	}
	
	public function getMemberId($clientId,$year,$req_id)
	{
		include("../db.php");
		$allmemeber_recordquery="SELECT * FROM HRA_member_".$clientId.'_'.$year. " LIMIT ".$req_id.",1";
		$allmemeber_result=mysqli_query($conn,$allmemeber_recordquery);
		$allmemeber_row=mysqli_fetch_array($allmemeber_result,MYSQLI_ASSOC);
		$member_id = $allmemeber_row['member_id'];

		//$getcontentdata = file_get_contents($fileepath);
		$mem_data=array("member_id"=>$member_id);
		echo json_encode($mem_data);
	}
	
	
	public function hraSave($clientId,$year,$req_id)
	{
		include("../db.php");
		$update_hradata = "select * from HRA_member_".$clientId.'_'.$year." where member_id ='$req_id'";
		$updatehradataresult=mysqli_query($conn,$update_hradata);
		$hrajson_data = $GLOBALS['inputData']['data'];
		$hrajson_dataa = json_encode($hrajson_data);
		if(mysqli_num_rows($updatehradataresult) == 1)
		{
			$fileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$req_id.'/'.$req_id.'.json';
			$statusjson = file_put_contents($fileepath,$hrajson_dataa);
			$permit = FileIOUtility::HRA_JSON_FILE_PERMISISON;
			chmod($fileepath, $permit);
			if($statusjson != 0)
			{
				$response = new stdClass();
				$response->status = 'updated';
				$response = json_encode($response);
				echo $response;
			}
			else
			{
				$response = new stdClass();
				$response->status = 'notupdated';
				$response = json_encode($response);
				echo $response;
			}
		}
		else
		{
			$response = new stdClass();
			$response->status = "recordnotfound";
			$response->memid = $memberId;
			$response = json_encode($response);
			echo $response;
		}
	}

	public function hraSavesingleMemberDataInfo($clientId,$year,$req_id){
		include("../db.php");
		$memberinfofield = $GLOBALS['inputData']['memberinfo'];

		$memberinfoobject = json_encode($memberinfofield);

		$updatememberinfo = "update HRA_member_".$clientId.'_'.$year." set memberinfo = ".$memberinfoobject." where member_id ='$req_id'";
		$updated_resultt=mysqli_query($conn,$updatememberinfo);
		//$updated_res = mysqli_affected_rows($conn);
		
		$update_hradata = "select * from HRA_member_".$clientId.'_'.$year." where member_id ='$req_id'"; 
		$updatehradataresult=mysqli_query($conn,$update_hradata);
		$allhramember_row=mysqli_fetch_array($updatehradataresult,MYSQLI_ASSOC);
		//$hra_path = $allhramember_row['hra']; 

		$fileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$req_id.'/'.$req_id.'.json';
				
		$hrajson_data = $GLOBALS['inputData']['data'];
		$hrajson_dataa = json_encode($hrajson_data);

		$hra_file_change = new HraFileChangesUtility;
		$member_id = $req_id;
		$hra_json_content=$hrajson_dataa;

		$hra_file_change->onHraFileUpdatedHistory($clientId,$year,$member_id,$hra_json_content);

		file_put_contents($fileepath,$hrajson_dataa);

				



		$permit = FileIOUtility::HRA_JSON_FILE_PERMISISON;
		chmod($fileepath, $permit);

		$response = new stdClass();
		$response->status = "Success";	 
		$response = json_encode($response);
		echo $response;
	}
	
	public function writeJson($clientId,$year,$req_id)
	{
		include("../db.php");
		$update_hradata = "select * from HRA_member_".$clientId.'_'.$year." where member_id ='$req_id'"; 
		$updatehradataresult=mysqli_query($conn,$update_hradata);
		$allhramember_row=mysqli_fetch_array($updatehradataresult,MYSQLI_ASSOC);
		$hra_path = $allhramember_row['hra']; 
		$exploded = explode("/",$hra_path);
		$lastpath=$exploded[6];
		$fifthpath=$exploded[5];
		$fileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$req_id.'/'.$req_id.'.json';
				
		$hrajson_data = $GLOBALS['inputData']['data'];
				
		$hrajson_dataa = json_encode($hrajson_data);
		file_put_contents($fileepath,$hrajson_dataa);
		$permit = FileIOUtility::HRA_JSON_FILE_PERMISISON;
		chmod($fileepath, $permit);
						
		$response = new stdClass();
		$response->status = "Success";	 
		$response = json_encode($response);
		echo $response;

	}
	
	public function jsonWithFolder($clientId,$year,$req_id)
	{
		include("../db.php");
		$fileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/';
		$resp = file_exists($fileepath);
					
		if($resp == 1)
		{
			$memfileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$req_id;
			$memresp = file_exists($memfileepath);
			if($memresp == 1)
			{
				$meminsidefilepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$req_id.'/'.$req_id.'.json';
					
				$hrajson_data = $GLOBALS['inputData']['data'];
				$hrajson_dataa = json_encode($hrajson_data);
				file_put_contents($meminsidefilepath,$hrajson_dataa);
				$permit = FileIOUtility::HRA_JSON_FILE_PERMISISON;
				chmod($meminsidefilepath, $permit);
						
				$response = new stdClass();
				$response->status = "Success";
				$response = json_encode($response);
				echo $response;

			}
			else
			{
					$memfileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$req_id;
					$permit = FileIOUtility::CLIENT_FOLDER_PERMISSION;
					mkdir($memfileepath);
					chmod($memfileepath, $permit);
					$meminsidefilepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$req_id.'/'.$req_id.'.json';
					$hrajson_data = $GLOBALS['inputData']['data'];
					$hrajson_dataa = json_encode($hrajson_data);
					$statusjson = file_put_contents($meminsidefilepath,$hrajson_dataa);
					$permit = FileIOUtility::HRA_JSON_FILE_PERMISISON;
					chmod($meminsidefilepath, $permit);

					if($statusjson != 0)
					{
						$response = new stdClass();
						$response->status = 'updated';
						$response = json_encode($response);
						echo $response;
					}
					else
					{
						$response = new stdClass();
						$response->status = 'notupdated';
						$response = json_encode($response);
						echo $response;
					}
			}
		
		}
	
	
	}
	
	public function updatePhoneNumber($clientId,$year,$req_id,$phonenumber)
	{
		include("../db.php");



		$selque1 = "SELECT member_id,memberinfo,hraFileUpdatedHistory,JSON_UNQUOTE(JSON_SEARCH(hraFileUpdatedHistory,'all','demographic', null, '$.history[*].modified[*].component' )) as serialno  FROM HRA_member_".$clientId."_".$year." where member_id = '".$req_id."'"; 
		$que_memb=mysqli_query($conn,$selque1) or die(mysqli_error($conn));
	  
		if(mysqli_num_rows($que_memb)>0){
			while($res_memb=mysqli_fetch_array($que_memb)){
				
				$serialno = $res_memb['serialno'];
				$serailid = mb_substr($serialno, 22, 1);
				$hraFileUpdatedHistory = $res_memb['hraFileUpdatedHistory'];
				$hraFileUpdatedHistoryarray = json_decode($hraFileUpdatedHistory,true);
				$hraFileUpdatedHistoryarray['history'][0]['modified'][$serailid]['value'][0]['pno'] = str_replace(" ","",str_replace("-","",$phonenumber));
				$hramodified=$hraFileUpdatedHistoryarray['history'][0]['modified'];
				for($j=0;$j<sizeof($hramodified);$j++){
					$value=$hraFileUpdatedHistoryarray['history'][0]['modified'][$j]['value'];
					for($k=0;$k<sizeof($value);$k++){
						if(isset($value[$k]['a'])){
							if(isset($value[$k]['a']['sub'])){
								if(isset($value[$k]['a']['sub']['sub'])){
									if(isset($value[$k]['a']['sub']['sub'])){
										$sub=$value[$k]['a']['sub']['sub'];
										foreach($sub as $subvalue){
											$hraFileUpdatedHistoryarray['history'][0]['modified'][$j]['value'][$k]['a']['sub']['sub']=str_replace(" ","&nbsp;",$subvalue);
										}
									}
									if(isset($value[$k]['a']['sub']['indx'])){
										$indx=$value[$k]['a']['sub']['indx'];
										foreach($indx as $indxvalue){
											$hraFileUpdatedHistoryarray['history'][0]['modified'][$j]['value'][$k]['a']['sub']['indx']=str_replace(" ","&nbsp;",$indxvalue);
										}
									}
									if(isset($value[$k]['a']['sub']['comment'])){
										$comment=$value[$k]['a']['sub']['comment'];
										foreach($comment as $commentvalue){
											$hraFileUpdatedHistoryarray['history'][0]['modified'][$j]['value'][$k]['a']['sub']['comment']=str_replace(" ","&nbsp;",$commentvalue);
										}
									}

								}else{
									if(isset($value[$k]['a']['sub'])){
										$sub=$value[$k]['a']['sub'];
										foreach($sub as $subvalue){
											$hraFileUpdatedHistoryarray['history'][0]['modified'][$j]['value'][$k]['a']['sub']=str_replace(" ","&nbsp;",$subvalue);
										}
									}
								}
							}
							if(isset($value[$k]['a']['indx'])){
								$indx=$value[$k]['a']['indx'];
								foreach($indx as $indxvalue){
									$hraFileUpdatedHistoryarray['history'][0]['modified'][$j]['value'][$k]['a']['indx']=str_replace(" ","&nbsp;",$indxvalue);
								}
							}
							if(isset($value[$k]['a']['comment'])){
								$comment=$value[$k]['a']['comment'];
								foreach($comment as $commentvalue){
									$hraFileUpdatedHistoryarray['history'][0]['modified'][$j]['value'][$k]['a']['comment']=str_replace(" ","&nbsp;",$commentvalue);
								}
							}
						}else{
							$valuehra=$hraFileUpdatedHistoryarray['history'][0]['modified'][$j]['value'][$k];
							foreach($valuehra as $key=>$hravalue){
								$hraFileUpdatedHistoryarray['history'][0]['modified'][$j]['value'][$k][$key]=str_replace(" ","&nbsp;",$hravalue);
							}
						}
					}
				}
				
				$hramodified=$hraFileUpdatedHistoryarray['history'][0]['modified'];
				for($j=0;$j<sizeof($hramodified);$j++){
					$ff[]= $hramodified[$j];
				}
				$hraFileUpdatedHistoryarray['history'][0]['modified']=$ff;

				$hraFileUpdatedHistoryarray['last_updated']=str_replace(" ","T",$hraFileUpdatedHistoryarray['last_updated']);
				
				$hraFileUpdatedHistoryobject = json_encode($hraFileUpdatedHistoryarray);
				$hraFileUpdatedHistoryobject = mysqli_real_escape_string($conn,$hraFileUpdatedHistoryobject);
			
	
				$memberinfo = $res_memb['memberinfo'];
				
				$memberinfo_array = json_decode($memberinfo,true);
				$memberinfo_array['Member_Primary_Phone_Number']=str_replace(" ","",str_replace("-","",$phonenumber));
				foreach($memberinfo_array as $key=>$meminfo){
					$memberinfo_array[$key]=str_replace(" ","&nbsp;",$meminfo);
				}

				$memberinfo_obj = json_encode($memberinfo_array);
				
				$update_faxnumber_query = "UPDATE HRA_member_".$clientId."_".$year." SET `memberinfo` = '$memberinfo_obj',`hraFileUpdatedHistory` = '$hraFileUpdatedHistoryobject' WHERE `member_id` = '".$res_memb['member_id']."'";
				$updated_result=mysqli_query($conn,$update_faxnumber_query);
				
				$fileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$req_id.'/'.$req_id.'.json';			
				$hrajson_data = $GLOBALS['inputData']['data'];
				$hrajson_dataa = json_encode($hrajson_data);
				$statusjson = file_put_contents($fileepath,$hrajson_dataa);
				$permit = FileIOUtility::HRA_JSON_FILE_PERMISISON;
				chmod($fileepath, $permit);
				if($statusjson != 0)
				{
					$response = new stdClass();
					$response->status = 'updated';
					$response = json_encode($response);
					echo $response;
				}
				else
				{
					$response = new stdClass();
					$response->status = 'notupdated';
					$response = json_encode($response);
					echo $response;
				}

			}
			
		}
		else
		{
			$response = new stdClass();
			$response->status = "recordnotfound";
			$response->memid = $memberId;
			$response = json_encode($response);
			echo $response;
		}
	}
}

//validate token
$token_validation_result = JwtUtility::isValidToken();
if($token_validation_result !== JwtUtility::VALID_TOKEN)
{     
	//un authorized access 
    JwtUtility::exitWithUnAuthorizedResponse($token_validation_result);
}
//end of token validation

$update = new update;
$method = $_SERVER['REQUEST_METHOD'];
$requestedurl = $_SERVER['REQUEST_URI'];
$arrayurlstring = explode("/",$requestedurl);
$crcount = count($arrayurlstring);
$crcountt = $crcount -1;
$requestMethod = $arrayurlstring[$crcountt];
$exploded = explode("?",$requestMethod);
$requestMethod = $exploded[0];
 
   switch ($method)
   {
	    case 'POST' :
			$postdata = file_get_contents("php://input");
			$request = json_decode($postdata);
			$requestt = json_decode($postdata,true);
			$GLOBALS['inputData'] = $requestt;
			$GLOBALS['input'] = $request;

			switch($requestMethod)
			{
				case 'totalMember' :
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$update->totalMember($clientId,$year);
				break;
				
				case 'singleMemberData' :
					$clientId = $GLOBALS['input']->{'clientId'};
					$year = $GLOBALS['input']->{'year'};
					$req_id = $GLOBALS['input']->{'id'};
					$update->singleMemberData($clientId,$year,$req_id);
				break;
				
				case 'writeJson' :
					$req_id = $GLOBALS['input']->{'id'};
					$year = $GLOBALS['input']->{'year'};
					$clientId = $GLOBALS['input']->{'clientId'};
					$update->writeJson($clientId,$year,$req_id);
				break;
				
				case 'jsonWithFolder' :
					$req_id = $request->{'id'};
					$year = $GLOBALS['input']->{'year'};
					$clientId = $GLOBALS['input']->{'clientId'};
					$update->jsonWithFolder($clientId,$year,$req_id);
				break;
				
				case 'hraSave' :
					$req_id = $request->{'id'};
					$year = $GLOBALS['input']->{'year'};
					$clientId = $GLOBALS['input']->{'clientId'};
					$update->hraSave($clientId,$year,$req_id);
				break;

				case 'hraSavesingleMemberDataInfo' :
					$req_id = $request->{'id'};
					$year = $GLOBALS['input']->{'year'};
					$clientId = $GLOBALS['input']->{'clientId'};
					$update->hraSavesingleMemberDataInfo($clientId,$year,$req_id);
					break;

				case 'updatePhoneNumber' :
					$req_id = $request->{'id'};
					$year = $GLOBALS['input']->{'year'};
					$clientId = $GLOBALS['input']->{'clientId'};
					$phonenumber = $GLOBALS['input']->{'phoneNumber'};
					$update->updatePhoneNumber($clientId,$year,$req_id,$phonenumber);
					break;
			}
	  break;
	  
	  case 'GET' :
	    switch($requestMethod)
		{
			case 'getMemberId' :
				$req_id = $_GET['id'];
				$clientId = $_GET['clientId'];
				$year = $_GET['year'];
				$update->getMemberId($clientId,$year,$req_id);
			break;
			
			case 'singleMemberData' :
				$clientId = $_GET['clientId'];
				$year = $_GET['year'];
				$req_id = $_GET['id'];
				$update->singleMemberData($clientId,$year,$req_id);
			break;
			case 'singleMemberDataInfo' :
				//echo "hii";die;
				$clientId = $_GET['clientId'];
				$year = $_GET['year'];
				$req_id = $_GET['id'];
				$update->singleMemberDataInfo($clientId,$year,$req_id);
				break;

			case 'getJson' :
				$clientId = $_GET['clientId'];
				$year = $_GET['year'];
				$member_id = $_GET['id'];
				$update->getJson($clientId,$year,$member_id);
			break;
			
		}
	  break;

   }
?>