<?php

//access control allow Header 

use Config\AppConfig;
use Config\ReferralFormEmailConfig;

include("../AccessControlAllowHeader.php");

//other include files
require_once("../utility/JwtUtility.php");
require_once("../utility/FileIOUtility.php");
require_once("../utility/FtpUtility.php");
require_once("../config/Config.php");
require_once("../TimeZone.php");
require_once("../TimeZone.php");
require_once("../fax/FaxApiClass.php");
require_once("../utility/SftpUtility.php");

	class uploadfile
	{
		public function movefile($memberId,$clientId,$year)
		{

				include("../db.php");
				$fileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$memberId;
				$fileepathh = trim($fileepath);
				$memresp = file_exists($fileepathh);
				$response = new stdClass();
				if($memresp == 1)
				{
					$file_pointer = $fileepathh.'/'.$_FILES["file"]["name"];
					
					if(file_exists($file_pointer) != 1)
					{
						if(move_uploaded_file($_FILES["file"]["tmp_name"], $fileepathh.'/'.$_FILES["file"]["name"]))
						{
							$response->status = "uploaded";
							include("../db.php");
							$getUpdatedFiles = "select * from HRA_member_".$clientId.'_'.$year." where member_id=".$memberId;
							$getUpdatedFilesRec=mysqli_query($conn,$getUpdatedFiles);
							$getUpdatedFilesRow=mysqli_fetch_array($getUpdatedFilesRec,MYSQLI_ASSOC);
							$uplodedfiless = $getUpdatedFilesRow['uploadedfiles'];

					 
							if($uplodedfiless == '')
							{
								$fName = $_FILES["file"]["name"];
								
								TimeZone::useTimeZone();
								$curr_time = date('d-m-Y H:i:s');
								
								$myObj->filename[] = $fName;
								$myObj->dateTime[] = $curr_time;
								$myJSON = json_encode($myObj);

								$updateFileName= "update HRA_member_".$clientId.'_'.$year." set uploadedfiles='".$myJSON."' where member_id=".$memberId;
								$updated_resultt=mysqli_query($conn,$updateFileName);
							}
							else
							{
								$b = $uplodedfiless;
								$jsonstring = json_decode( $b, true );

								TimeZone::useTimeZone();
								$curr_time = date('d-m-Y H:i:s');
								
								array_push($jsonstring['filename'],$_FILES["file"]["name"]);
								array_push($jsonstring['dateTime'],$curr_time);

								$meregedjsonm = json_encode($jsonstring);

								$updateFileName= "update HRA_member_".$clientId.'_'.$year." set uploadedfiles='".$meregedjsonm."' where member_id=".$memberId;
								$updated_resultt=mysqli_query($conn,$updateFileName);
							}
							
					
						}
						else
						{
							$response->status = "notuploaded";
						}
					}
					else
					{
						$response->status = "fileAlreadyExists";
					}
				}
				else
				{
					$response->status = "folderNotFound";
				}
				$response = json_encode($response);
				echo $response;
		}

			
		/*
            NAME    : uploadMemberData
            TYPE    : api upload function 
            DETAILS :  
        */
		public function uploadMemberData($memberId,$clientId,$year,$extensiontype,$extensionpath,$pdf_file_name)
		{
			//response format
			$response = new stdClass;
			$response->status = "not uploaded";
			//the file upload in where server hosted
			$response->hostUploadStatus = "not uploaded";
			$response->error = "";

			//temp uploaded file location
			$uploaded_local_temp_file = $_FILES["file"]["tmp_name"];

			//upload to go any where if the form type is form_pdf
			if(AppConfig::APP_ENVIRONMENT_TYPE===2)
			{
				//$is_uploaded=$this->uploadToGoAnyWhereIfFormPdf($extensionpath,$clientId,$uploaded_local_temp_file,$pdf_file_name);
				//if($is_uploaded)
				//{
				//	$response->status = "uploaded";
				//}
			}

  			$fileepath = '../member_data/HRA_member_'.$clientId.'/'.$year;
  			$is_folder_exist = file_exists($fileepath);
			//check for year folder found or not,if not ,create the directory
			if($is_folder_exist==0)
			{
				$is_folder_exist=FileIOUtility::makeDirIfNotAvailable($fileepath);
			}

			if($is_folder_exist == 1)
			{
					$folder_path = $fileepath.'/'.$extensionpath.'/';
					switch ($extensiontype)
					{
						case 'pdf' :
							if(FileIOUtility::makeDirIfNotAvailable($folder_path))
							{	
								//azure server pdf save location
								if($extensionpath == "referral_pdf"){
									$file_moved_path_location = $fileepath.'/'.$extensionpath.'/'.$memberId.'-referral-form.pdf';
								}elseif($extensionpath == "member_summary_report"){
									$file_moved_path_location = $fileepath.'/'.$extensionpath.'/'.$pdf_file_name;
								}else{
									$file_moved_path_location = $fileepath.'/'.$extensionpath.'/'.$memberId.'.pdf';
								}
								
								$move_result = move_uploaded_file($uploaded_local_temp_file,$file_moved_path_location);
								
								if($move_result)
								{
									
									switch($extensionpath)
									{
										case 'form_pdf':
											include("../db.php");
											$update_query = "UPDATE HRA_member_".$clientId."_$year SET pdf_file_name='".mysqli_real_escape_string($conn,$pdf_file_name)."' WHERE member_id = '$memberId'";
											mysqli_query($conn , $update_query) or die("error");
											if(AppConfig::APP_ENVIRONMENT_TYPE!==2)
											{	
												$response->status = "uploaded";
											}
											$response->hostUploadStatus = "uploaded";
										break;

										case 'summary_report' :
											include("../db.php");
											$update_query = "UPDATE HRA_member_".$clientId."_$year SET summary_pdf_file_name='".mysqli_real_escape_string($conn,$pdf_file_name)."' WHERE member_id = '$memberId'";
											mysqli_query($conn , $update_query) or die("error");

											

											mysqli_close($conn);
											$sftp_utility = new SftpUtility();
											$plan_id = DataBaseUtility::getPlanName($clientId);
											$ftp_upload = $sftp_utility->uploadFilesToSftp($plan_id,$year,$memberId,$file_moved_path_location);

											$faxapiclass = new FaxApiClass;
											$faxstatusapiclass = $faxapiclass->getFaxStatus();
											if($faxstatusapiclass == 1) {
												$faxapiclass->SendFaxPdfFile($clientId,$year,$memberId,$file_moved_path_location);
											}
											
											$response -> ftp_status = $ftp_upload;

											break;
											case 'member_summary_report':
												include("../db.php");
												$update_query = "UPDATE HRA_member_".$clientId."_$year SET member_pdf_file_name='".mysqli_real_escape_string($conn,$pdf_file_name)."' WHERE member_id = '$memberId'";
												mysqli_query($conn , $update_query) or die("error");
												$sftp_utility = new SftpUtility();
												$plan_id = DataBaseUtility::getPlanName($clientId);
												$ftp_upload = $sftp_utility->uploadFilesToSftpMembeSummary($plan_id,$year,$memberId,$file_moved_path_location);
												
												$response->hostUploadStatus = "uploaded";
											break;
										
										case 'referral_pdf':
											$user_email = ReferralFormEmailConfig::REFERRAL_FORM_EMAIL;
											$mail_subject = "Referral Form PDF";
											$mail_attachment  = $file_moved_path_location;
											$mail_content  = '<div style="width:100%;background-color: gainsboro;">
												<div style="margin-left:0px;  margin-top: 0px; height: auto width: 100%;">
												<b>Referral Form PDF</b><br><br>Welcome to the Focuscare
												<br><br>PLease find the attached pdf of following member id '.$memberId.'<br><br>Thanks and Regards,<br> Focus Care Team </div></div>';
											$mail_response = Utility::sendMailByAttachment($user_email,$mail_subject,$mail_content,$mail_attachment);
											if($mail_response['mailStatus'] == 'success') {
												unlink($mail_attachment);
												include("../db.php");
												$getReferral = "select * from HRA_member_".$clientId.'_'.$year." where member_id=".$memberId;
												$getReferralRec=mysqli_query($conn,$getReferral);
												$getReferralRow=mysqli_fetch_array($getReferralRec,MYSQLI_ASSOC);
												$referralStatusinfo = json_decode($getReferralRow['referralForm'], true);
												if(!empty($referralStatusinfo)) {
													$referralStatusinfo['sentToQADate'] = $_POST['mailSentDate'];
													$referralStatusinfo['referralFormStatus'] = 1;
													$referral_obj = json_encode($referralStatusinfo);
													$updateInprogressStatus = "update HRA_member_" . $clientId . '_' . $year . " set referralForm='$referral_obj' where member_id ='$memberId'";
													$updateEvalDateResult = mysqli_query($conn, $updateInprogressStatus);
													$updated_resp = mysqli_affected_rows($conn);
												}
											}
											$response->referralStatus = ($updated_resp) ? 'Updated' : 'Not Updated';
											$response->status = $mail_response['mailStatus'];
											$response->hostUploadStatus = $mail_response['error'];
											break;

										case 'utcletter':  
											// comment below line while moving to production
											$user_email = ReferralFormEmailConfig::UTC_EMAIL;  //Email for Testing
											//uncomment below condition while moving to production as email has to go members, but get confirmation on this condition
											// if($_POST['mailId']!=''){
											// 	$user_email = $_POST['mailId'];  //from Mail ID frontend
											// }else{
											// 	$user_email = ReferralFormEmailConfig::UTC_EMAIL;  //Default Email
											// }
											$mail_subject = "UTC Letter";
											$mail_attachment  = str_replace(" ","",$file_moved_path_location);
											$mail_content  = '<div style="width:100%;background-color: gainsboro;">
												<div style="margin-left:0px;  margin-top: 0px; height: auto width: 100%;">
												<b>UTC Letter</b><br><br>Welcome to the Focuscare
												<br><br>Please find the attached pdf of following member id '.$memberId.'<br><br>Thanks and Regards,<br> Focus Care Team </div></div>';
											$mail_response = Utility::sendMailByAttachment($user_email,$mail_subject,$mail_content,$mail_attachment);
											if($mail_response['mailStatus'] == 'success') unlink($mail_attachment);
											$response->status = $mail_response['mailStatus'];
											$response->hostUploadStatus = $mail_response['error'];
											break;

										case 'declineLetter':  
											//comment below line while moving to production
											$user_email = ReferralFormEmailConfig::DECLINE_EMAIL; //Email for Testing
											//uncomment below condition while moving to production as email has to go members, but get confirmation on this condition
											// if($_POST['mailId']!=''){
											// 	$user_email = $_POST['mailId'];  //from Mail ID frontend
											// }else{
											// 	$user_email = ReferralFormEmailConfig::DECLINE_EMAIL;  //Default Email
											// }
											$mail_subject = "Decline Letter";
											$mail_attachment  = str_replace(" ","",$file_moved_path_location);
											$mail_content  = '<div style="width:100%;background-color: gainsboro;">
												<div style="margin-left:0px;  margin-top: 0px; height: auto width: 100%;">
												<b>Decline Letter</b><br><br>Welcome to the Focuscare
												<br><br>Please find the attached pdf of following member id '.$memberId.'<br><br>Thanks and Regards,<br> Focus Care Team </div></div>';
											$mail_response = Utility::sendMailByAttachment($user_email,$mail_subject,$mail_content,$mail_attachment);
											if($mail_response['mailStatus'] == 'success') unlink($mail_attachment);
											$response->status = $mail_response['mailStatus'];
											$response->hostUploadStatus = $mail_response['error'];
											break;

										default:
											$response->status = "uploaded";
											$response->hostUploadStatus = "uploaded";
									}
								}
								else
								{
									$response->status = "not uploaded";
									$response->status = "failed when file moved";
								}
							}
						break;
						
						case 'xml' : //if no xml folder 
							if(FileIOUtility::makeDirIfNotAvailable($folder_path))
							{
								$file_moved_path_location = $fileepath.'/'.$extensionpath.'/'.$memberId.'.xml';
								$move_result = move_uploaded_file($uploaded_local_temp_file,$file_moved_path_location);
								if($move_result)
								{
									$response->status = "uploaded";
									$response->hostUploadStatus = "uploaded";
								}
								else
								{
									$response->status = "not uploaded";
									$response->status = "failed when file moved";
								}
							}
						break;
					}
			}
			else
			{
				$response->hostUploadStatus = "not uploaded";
				$response->error = "folder not found";
			}

			echo json_encode($response);

		}

		/*
            NAME    : updateFaxStatus
            DETAILS    : api for updating fax status
            RETURN :  integer
        */
		public function updateFaxStatus($faxVal)
		{
			$faxapiclass = new FaxApiClass;
			$faxapiclass = $faxapiclass->updateFax($faxVal);
			$response = new stdClass();
			$response->status = ($faxapiclass == $faxVal) ? 1 : 0;
			$response->faxEnable = $faxapiclass;
			echo json_encode($response);
			return TRUE;
		}

		/*
            NAME    : uploadToGoAnyWhereIfFormPdf
            TYPE    : internal upload utility function 
            DETAILS : 
        */
		private function uploadToGoAnyWhereIfFormPdf($form_type,$clientId,$local_file_to_upload,$file_name)
		{
			switch($form_type)
			{
				case 'form_pdf':				
					if(isset($file_name))
					{
						$file_name_with_extention = $file_name.'.pdf';
						$go_any_where_status =  FtpUtility::uploadToGoAnyWhere($clientId,$local_file_to_upload,$file_name_with_extention);
						if($go_any_where_status)
						{
							$update_status = $go_any_where_status["uploadStatus"];
							if($update_status=='success')
							{
								return true;
							}
							return false;
						}
					}
				break;
			}

			return false;
		}
	}

//validate token
$token_validation_result = JwtUtility::isValidToken();
if($token_validation_result !== JwtUtility::VALID_TOKEN)
{     
	//un authorized access 
    JwtUtility::exitWithUnAuthorizedResponse($token_validation_result);
}
//end of token validation

$uploadingfile = new uploadfile;
$method          = $_SERVER['REQUEST_METHOD'];
$requestedurl = $_SERVER['REQUEST_URI'];
$arrayurlstring = explode("/",$requestedurl);
$crcount = count($arrayurlstring);
$crcountt = $crcount -1;
$requestMethod = $arrayurlstring[$crcountt];
$exploded = explode("?",$requestMethod);
$requestMethod = $exploded[0];

 switch ($method) 
 {
	 case 'POST':
	 	$memberId = $_POST['memberId'];
		$clientId = $_POST['clientId'];
		$year = $_POST['year'];
		switch($requestMethod)
		{
			case 'uploadCCD' :
				$uploadingfile->movefile($memberId,$clientId,$year);
			break;

			case 'uploadMemberData' :
				$extensiontype = $_POST['type'];
				$extensionpath = $_POST['formType'];
				$pdf_file_name = isset($_POST['pdfName'])?$_POST['pdfName']:null;
				$uploadingfile->uploadMemberData($memberId,$clientId,$year,$extensiontype,$extensionpath,$pdf_file_name);
			break;

			case 'updateFaxStatus' :
				$faxVal = $_POST['faxStatus'];
				$uploadingfile->updateFaxStatus($faxVal);
				break;

			case 'referralFormToMail':
				$pdf_file_name = isset($_POST['pdfName']) ? $_POST['pdfName'] : null;
				$extensiontype = $_POST['type'];
				$extensionpath = $_POST['formType'];
				$uploadingfile->uploadMemberData($memberId, $clientId, $year, $extensiontype, $extensionpath, $pdf_file_name);
				break;
				
			case 'utcletterToMail':
				$pdf_file_name = isset($_POST['pdfName']) ? $_POST['pdfName'] : null;
				$extensiontype = $_POST['type'];
				$extensionpath = $_POST['formType'];
				$mailId = $_POST['mailId'];				
				$memberId  = str_replace(" ","",$memberId); //to remove space added after memberid
				$uploadingfile->uploadMemberData($memberId, $clientId, $year, $extensiontype, $extensionpath, $pdf_file_name);
				break;
			
			case 'declineLetterToMail':
				$pdf_file_name = isset($_POST['pdfName']) ? $_POST['pdfName'] : null;
				$extensiontype = $_POST['type'];
				$extensionpath = $_POST['formType'];
				$mailId = $_POST['mailId'];				
				$memberId  = str_replace(" ","",$memberId); //to remove space added after memberid
				$uploadingfile->uploadMemberData($memberId, $clientId, $year, $extensiontype, $extensionpath, $pdf_file_name);
				break;
		}
	break;

	case 'GET':
		case 'member_report_ftp_montlhy':
			$plan = isset($_GET['plan']) ? $_GET['plan'] : NULL;
			$year = isset($_GET['year']) ? $_GET['year'] : NULL;
			$sftp_utility = new SftpUtility();
			//$plan_id = DataBaseUtility::getPlanName($clientId);
			$ftp_upload = $sftp_utility->memberMonthlyFtpUpload($plan,$year);
		break;
	break;
 }
?>
