<?php

//access control allow Header 

use Config\AppConfig;

include("../AccessControlAllowHeader.php");

//other include files
require_once("../utility/JwtUtility.php");
require_once("../utility/FileIOUtility.php");
require_once("../utility/FtpUtility.php");
require_once("../config/Config.php");
require_once("../TimeZone.php");
require_once("../TimeZone.php");
require_once("../fax/FaxApiClass.php");
require_once("../php_excel/PHPExcel/IOFactory.php");

	class uploadfile
	{
		public function uploadMembers($year,$clientId,$file){

			$inputFileName = $_FILES['file']["tmp_name"];

  			try {
    			$inputFileType = PHPExcel_IOFactory::identify($inputFileName);
    			$objReader = PHPExcel_IOFactory::createReader($inputFileType);
    			$objPHPExcel = $objReader->load($inputFileName);
  			} catch (Exception $e) {
    			die('Error loading file "' . pathinfo($inputFileName, PATHINFO_BASENAME) . '": ' . 
        		$e->getMessage());
 	 		}
  			$sheet = $objPHPExcel->getSheet(0);
  			$highestRow = $sheet->getHighestRow();
  			$highestColumn = $sheet->getHighestColumn();

			$json_array = array();
  			for ($row = 1; $row <= $highestRow; $row++) { 
    			if($row != 1){
      				$rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, null, true, false);
      				//echo '<pre>'. print_r($rowData).'</pre>';
					$memberId = $rowData[0][3];

					$fileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$memberId;
					$fileepathh = trim($fileepath);
					$memresp = file_exists($fileepathh);

					if($memresp == 1){
						$memstatus = "updateMember";
					}else{
						$memstatus = "registerMember";
					}
					$json_array = array(
						"id"=>$memberId, 
						"type"=> $memstatus,
						"clientId"=> $clientId,
    					"year"=> $year,
    					"min"=> "",
    					"max"=> "",
						"data" => array(
							"Member_Identification_Number"=> $memberId,
							"Member_first_name"=> $rowData[0][6],
							"Member_Last_name"=> $rowData[0][7],
							"Member_Gender"=> $rowData[0][12],
							"DOB"=> $rowData[0][13],
							"Date_Of_Birth"=> $rowData[0][14],
        					"Member_Primary_Phone_Number"=> $rowData[0][15],
        					"Member_Address1"=> $rowData[0][22],
        					"Member_City"=> $rowData[0][25],
        					"Member_State"=> $rowData[0][26],
        					"Member_Zip_Code"=> $rowData[0][27],
        					"Member_Country"=> $rowData[0][35],
        					"Member_Language"=> $rowData[0][39],
							"Plan_Effective_Date"=> $rowData[0][41],
							"Screening_IHA"=> $rowData[0][58],
							"Pcp_Name"=> $rowData[0][46],
							"PCP_Phone"=> $rowData[0][49],
							"PCP_Fax_Number"=> $rowData[0][50],
							"Pcp_Address_1"=> $rowData[0][51],
							"Pcp_City"=> $rowData[0][52],
							"Pcp_State"=> $rowData[0][53],
							"Pcp_Zip"=> $rowData[0][54],
							"Office_Name"=> $rowData[0][57],
							"DIGITAL_RETINAL_EXAM"=>$rowData[0][59],
							"HBA1C"=> $rowData[0][60],
							"MICROALBUMIN"=> $rowData[0][61],
							"FOBT"=> $rowData[0][62],
							"DEXA"=> $rowData[0][63],
							"LDL"=> $rowData[0][64],
							"PAD"=> $rowData[0][65],
							"Member_Suspect_Codes"=> $rowData[0][72],
							"LOB"=> $rowData[0][2],
							"Plan"=> $rowData[0][0],
							"Program"=> $rowData[0][1],
							"Member_Region"=> $rowData[0][36],
							"Aligned"=> $rowData[0][37],
							"Member_UniqueID"=> $rowData[0][9],
							"Medication_Review"=> $rowData[0][67],
							"Pain_Assessment"=> $rowData[0][68],
							"Functional_Assessment"=> $rowData[0][69],
							"Rank_All"=> $rowData[0][70],
							"Care_Coordinator"=> $rowData[0][71],
							"Medicaid_ID"=> $rowData[0][4],
							"Medicare_ID"=> $rowData[0][5],
							"PCP_Specality"=> $rowData[0][47]
						),
						"hraJson"=> array(
							"version"=> "0.4",
							"data"=> [
								array(
									"t"=> "Demographics",
									"q"=> [
										array(
											"name"=> $rowData[0][6]." ".$rowData[0][7],
											"gend"=> 1,
											"add"=> $rowData[0][22],
											"city"=> $rowData[0][25],
											"state"=> $rowData[0][26],
											"zip"=> $rowData[0][27],
											"dob"=> $rowData[0][13],
											"age"=> "",
											"mstatus"=> "",
											"insh"=> $memberId,
											"cliId"=> "",
											"pno"=> $rowData[0][15],
											"cno"=> "",
											"email"=> $rowData[0][19],
											"ename"=> "",
											"eno"=> "",
											"pphy"=> $rowData[0][46],
											"ppno"=> $rowData[0][49],
											"pcpadd"=> $rowData[0][51],
											"pcpcity"=> $rowData[0][52],
											"pcpstate"=> $rowData[0][53],
											"pcpzip"=> $rowData[0][54],
											"pcpcounty"=> $rowData[0][55],
											"pcpid"=> "",
											"pcpname"=> $rowData[0][57],
											"plan"=> $rowData[0][0],
											"program"=> $rowData[0][1],
											"lob"=> $rowData[0][2],
											"region"=> $rowData[0][36],
											"aligned"=> $rowData[0][37],
											"ano"=> "",
											"add2"=> "",
											"add3"=> "",
											"madd1"=> "",
											"madd2"=> "",
											"madd3"=> "",
											"mcity"=> "",
											"mstate"=> "",
											"mzip"=> "",
											"pcpfaxno"=> $rowData[0][50],
											"pcpnpi"=> $rowData[0][48]
										),
										array(
											"a"=> array(
												"indx"=> [
													"",
													"",
													"",
													"",
													"",
													"",
													"",
													"1"
												],
												"comment"=> [
													"",
													"",
													"",
													"",
													"",
													"",
													"",
													""
												],
												"sub"=> array(
													"indx"=> [
														[
															"No Ethnicity"
														]
													],
													"comment"=> [
														[
															""
														]
													],
													"sub"=> array()
												)
											)
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										)
									]
								),
								array(
									"t"=> "Previously Documented Conditions",
									"q"=> [
										array(
											"a"=> []
										)
									]
								),
								array(
									"t"=> "Covid Screening",
									"q"=> [
										array(
											"a"=> []
										)
									]
								),
								array(
									"t"=> "Self-Assessment and Social History",
									"q"=> [
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										)
									]
								),
								array(
									"t"=> "Activities of Daily Living",
									"q"=> [
										array(
											"a"=> []
										)
									]
								),
								array(
									"t"=> "Medical History",
									"q"=> [
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										)
									]
								),
								array(
									"t"=> "Family History",
									"q"=> [
										array(
											"a"=> []
										)
									]
								),
								array(
									"t"=> "Preventive Care",
									"q"=> [
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										)
									]
								),
								array(
									"t"=> "Allergies / Medications",
									"q"=> [
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										)
									]
								),
								array(
									"t"=> "Review of Systems and Diagnoses",
									"q"=> [
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										)
									]
								),
								array(
									"t"=> "Pain",
									"q"=> [
										array(
											"a"=> []
										)
									]
								),
								array(
									"t"=> "Vital Signs",
									"q"=> [
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										)
									]
								),
								array(
									"t"=> "Exam Review",
									"q"=> [
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										)
									]
								),
								array(
									"t"=> "Screenings Needed",
									"q"=> [
										array(
											"a"=> array(
												"indx"=> [
													"",
													"1"
												],
												"comment"=> [
													"",
													""
												]
											)
										),
										array(
											"a"=> array(
												"indx"=> [
													"",
													"1"
												],
												"comment"=> [
													"",
													""
												]
											)
										),
										array(
											"a"=> array(
												"indx"=> [
													"",
													"1"
												],
												"comment"=> [
													"",
													""
												]
											)
										),
										array(
											"a"=> array(
												"indx"=> [
													"",
													"1"
												],
												"comment"=> [
													"",
													""
												]
											)
										),
										array(
											"a"=> array(
												"indx"=> [
													"",
													"1"
												],
												"comment"=> [
													"",
													""
												]
											)
										),
										array(
											"a"=> array(
												"indx"=> [
													"",
													"1"
												],
												"comment"=> [
													"",
													""
												]
											)
										),
										array(
											"a"=> array(
												"indx"=> [
													"",
													"1"
												],
												"comment"=> [
													"",
													""
												]
											)
										),
										array(
											"a"=> []
										)
									]
								),
								array(
									"t"=> "Mini-Cog",
									"q"=> [
										array(
											"a"=> []
										),
										array(
											"a"=> []
										)
									]
								),
								array(
									"t"=> "Home Safety & Personal Goals",
									"q"=> [
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										),
										array(
											"a"=> []
										)
									]
								),
								array(
									"t"=> "Active Problem Conditions",
									"q"=> [
										array(
											"a"=> []
										)
									]
								),
								array(
									"t"=> "Patient Summary",
									"q"=> [
										array(
											"a1"=> "",
											"a2"=> "",
											"a3"=> "",
											"a4"=> "",
											"a5"=> "",
											"a6"=> "",
											"a7"=> [],
											"a8"=> "",
											"a9"=> "",
											"a10"=> [],
											"a11"=> "",
											"a12"=> "",
											"a13"=> ""
										)
									]
								)
							]
						),
						"termDate"=> "",
						"sessionId"=> ""
					);

					echo json_encode($json_array);
					//$is_folder_created=FileIOUtility::CreateHraJsonDataFolder($client_id,$year);
                //$is_folder_created=self::CreateMemberDataFolder($client_id,$year);
					//$fileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$memberId;
					$fileepath = 'hrajsondata/HRA_member_'.$clientId;
  					$is_folder_exist = file_exists($fileepath);
					//check for year folder found or not,if not ,create the directory
					if($is_folder_exist==0)
					{
						$is_folder_exist=FileIOUtility::makeDirIfNotAvailable($fileepath);
					}

					//echo $is_folder_exist;exit;
					if($is_folder_exist == 1)
					{
						
						$fileepath .= "/$year";
						$is_folder_exist = file_exists($fileepath);
						if($is_folder_exist==0)
						{
							$is_folder_exist=FileIOUtility::makeDirIfNotAvailable($fileepath);
						}

						if($is_folder_exist == 1){
							$fileepath_mem = "$fileepath/$memberId" ;
							$is_folder_exist = file_exists($fileepath_mem);
							
							if($is_folder_exist==0)
							{
								$is_folder_exist=FileIOUtility::makeDirIfNotAvailable($fileepath_mem);
							}

							if($is_folder_exist == 1){
								$json_file = $fileepath_mem."/$memberId.json";
								$hra_json = json_encode($json_array);
                    			file_put_contents($json_file,$hra_json);
                    			$permit = FileIOUtility::HRA_JSON_FILE_PERMISISON;
                    			chmod($json_file, $permit);
							}
						}
						
					}
					exit;
					
					/*$create_json_folder = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/';
					$is_folder_exist = file_exists($create_json_folder);
					if(!file_exists($create_json_folder)){
						$create_json_folder = FileIOUtility::CreateHraJsonDataFolder($clientId,$year,$memberId,$json_array);
					}
					
					if(file_exists($create_json_folder)){
							$create_json_file = FileIOUtility::CreateMemberJsonFile($clientId,$year,$memberId,$json_array);
							if($create_json_file){
								echo "Hi";
							}else{
								echo "Hiiiiiiiii";
							}
					}*/
					exit;
				}
  			}
		}
		public function movefile($memberId,$clientId,$year)
		{

				include("../db.php");
				$fileepath = '../hrajsondata/HRA_member_'.$clientId.'/'.$year.'/'.$memberId;
				$fileepathh = trim($fileepath);
				$memresp = file_exists($fileepathh);
				$response = new stdClass();
				if($memresp == 1)
				{
					$file_pointer = $fileepathh.'/'.$_FILES["file"]["name"];
					
					if(file_exists($file_pointer) != 1)
					{
						if(move_uploaded_file($_FILES["file"]["tmp_name"], $fileepathh.'/'.$_FILES["file"]["name"]))
						{
							$response->status = "uploaded";
							include("../db.php");
							$getUpdatedFiles = "select * from HRA_member_".$clientId.'_'.$year." where member_id=".$memberId;
							$getUpdatedFilesRec=mysqli_query($conn,$getUpdatedFiles);
							$getUpdatedFilesRow=mysqli_fetch_array($getUpdatedFilesRec,MYSQLI_ASSOC);
							$uplodedfiless = $getUpdatedFilesRow['uploadedfiles'];

					 
							if($uplodedfiless == '')
							{
								$fName = $_FILES["file"]["name"];
								
								TimeZone::useTimeZone();
								$curr_time = date('d-m-Y H:i:s');
								
								$myObj->filename[] = $fName;
								$myObj->dateTime[] = $curr_time;
								$myJSON = json_encode($myObj);

								$updateFileName= "update HRA_member_".$clientId.'_'.$year." set uploadedfiles='".$myJSON."' where member_id=".$memberId;
								$updated_resultt=mysqli_query($conn,$updateFileName);
							}
							else
							{
								$b = $uplodedfiless;
								$jsonstring = json_decode( $b, true );

								TimeZone::useTimeZone();
								$curr_time = date('d-m-Y H:i:s');
								
								array_push($jsonstring['filename'],$_FILES["file"]["name"]);
								array_push($jsonstring['dateTime'],$curr_time);

								$meregedjsonm = json_encode($jsonstring);

								$updateFileName= "update HRA_member_".$clientId.'_'.$year." set uploadedfiles='".$meregedjsonm."' where member_id=".$memberId;
								$updated_resultt=mysqli_query($conn,$updateFileName);
							}
							
					
						}
						else
						{
							$response->status = "notuploaded";
						}
					}
					else
					{
						$response->status = "fileAlreadyExists";
					}
				}
				else
				{
					$response->status = "folderNotFound";
				}
				$response = json_encode($response);
				echo $response;
		}

			
		/*
            NAME    : uploadMemberData
            TYPE    : api upload function 
            DETAILS : 
        */
		public function uploadMemberData($memberId,$clientId,$year,$extensiontype,$extensionpath,$pdf_file_name)
		{
			
			//response format
			$response = new stdClass;
			$response->status = "not uploaded";
			//the file upload in where server hosted
			$response->hostUploadStatus = "not uploaded";
			$response->error = "";

			//temp uploaded file location
			$uploaded_local_temp_file = $_FILES["file"]["tmp_name"];

			//upload to go any where if the form type is form_pdf
			if(AppConfig::APP_ENVIRONMENT_TYPE===2)
			{
				//$is_uploaded=$this->uploadToGoAnyWhereIfFormPdf($extensionpath,$clientId,$uploaded_local_temp_file,$pdf_file_name);
				//if($is_uploaded)
				//{
				//	$response->status = "uploaded";
				//}
			}

  			$fileepath = '../member_data/HRA_member_'.$clientId.'/'.$year;
  			$is_folder_exist = file_exists($fileepath);
			//check for year folder found or not,if not ,create the directory
			if($is_folder_exist==0)
			{
				$is_folder_exist=FileIOUtility::makeDirIfNotAvailable($fileepath);
			}

			if($is_folder_exist == 1)
			{
					$folder_path = $fileepath.'/'.$extensionpath.'/';
					switch ($extensiontype)
					{
						case 'pdf' :
							if(FileIOUtility::makeDirIfNotAvailable($folder_path))
							{	
								//azure server pdf save location
								$file_moved_path_location = $fileepath.'/'.$extensionpath.'/'.$memberId.'.pdf';
								$move_result = move_uploaded_file($uploaded_local_temp_file,$file_moved_path_location);
								if($move_result)
								{
									switch($extensionpath)
									{
										case 'form_pdf':
											if(AppConfig::APP_ENVIRONMENT_TYPE!==2)
											{	
												$response->status = "uploaded";
											}
											$response->hostUploadStatus = "uploaded";
										break;

										case 'summary_report' :
											$faxapiclass = new FaxApiClass;
											$faxapiclass->SendFaxPdfFile($clientId,$year,$memberId,$file_moved_path_location);
											break;

										
										default:
											$response->status = "uploaded";
											$response->hostUploadStatus = "uploaded";
									}
								}
								else
								{
									$response->status = "not uploaded";
									$response->status = "failed when file moved";
								}
							}
						break;
						
						case 'xml' : //if no xml folder 
							if(FileIOUtility::makeDirIfNotAvailable($folder_path))
							{
								$file_moved_path_location = $fileepath.'/'.$extensionpath.'/'.$memberId.'.xml';
								$move_result = move_uploaded_file($uploaded_local_temp_file,$file_moved_path_location);
								if($move_result)
								{
									$response->status = "uploaded";
									$response->hostUploadStatus = "uploaded";
								}
								else
								{
									$response->status = "not uploaded";
									$response->status = "failed when file moved";
								}
							}
						break;
					}
			}
			else
			{
				$response->hostUploadStatus = "not uploaded";
				$response->error = "folder not found";
			}

			echo json_encode($response);

		}

		/*
            NAME    : uploadToGoAnyWhereIfFormPdf
            TYPE    : internal upload utility function 
            DETAILS : 
        */
		private function uploadToGoAnyWhereIfFormPdf($form_type,$clientId,$local_file_to_upload,$file_name)
		{
			switch($form_type)
			{
				case 'form_pdf':				
					if(isset($file_name))
					{
						$file_name_with_extention = $file_name.'.pdf';
						$go_any_where_status =  FtpUtility::uploadToGoAnyWhere($clientId,$local_file_to_upload,$file_name_with_extention);
						if($go_any_where_status)
						{
							$update_status = $go_any_where_status["uploadStatus"];
							if($update_status=='success')
							{
								return true;
							}
							return false;
						}
					}
				break;
			}

			return false;
		}
	}

//validate token
$token_validation_result = JwtUtility::isValidToken();
if($token_validation_result !== JwtUtility::VALID_TOKEN)
{     
	//un authorized access 
    JwtUtility::exitWithUnAuthorizedResponse($token_validation_result);
}
//end of token validation

$uploadingfile = new uploadfile;
$method          = $_SERVER['REQUEST_METHOD'];
$requestedurl = $_SERVER['REQUEST_URI'];
$arrayurlstring = explode("/",$requestedurl);
$crcount = count($arrayurlstring);
$crcountt = $crcount -1;
$requestMethod = $arrayurlstring[$crcountt];
$exploded = explode("?",$requestMethod);
$requestMethod = $exploded[0];

 switch ($method) 
 {
	 case 'POST':
	 	$memberId = $_POST['memberId'];
		$clientId = $_POST['clientId'];
		$year = $_POST['year'];
		switch($requestMethod)
		{
			case 'uploadCCD' :
				$uploadingfile->movefile($memberId,$clientId,$year);
			break;

			case 'uploadMemberData' :
				$extensiontype = $_POST['type'];
				$extensionpath = $_POST['formType'];
				$pdf_file_name = isset($_POST['pdfName'])?$_POST['pdfName']:null;
				$uploadingfile->uploadMemberData($memberId,$clientId,$year,$extensiontype,$extensionpath,$pdf_file_name);
			break;

			case 'uploadMembers' :
				
				$file = $_POST['file'];
				$year = $_POST['year'];
				$clientId = $_POST['client_id'];
				$uploadingfile->uploadMembers($year,$clientId,$file);
			break;

		}
	break;
 }
?>
