<?php

    class ArrayUtility
    {
        /*
            NAME : getArrayFilter
            DETAILS : filter the array with custom callback condition function
            RETURN : filter array without index key
        */
        public static function getArrayFilter($array_value,callable $callback_condition)
        {
           return array_values(
                array_filter($array_value,$callback_condition
                ));
        }

        /*
            NAME    : getArrayLast
            TYPE    : Internal utility function   
            DETAILS : Utility function to get last array value   
            RETURN  : last element of the array if any
        */
        public static function getArrayLast($any_array)
        {
            $total_count = count($any_array);
            if($total_count>=1)
            {
                //recently scheduler assigned date 
                $any_array = $any_array[$total_count-1];
                return $any_array;
            }
            //if any mail not sent yet
            return null;
        }

         /*
            NAME    : addArrayByKey
            TYPE    : global utility function   
            DETAILS : 
            RETURN  : update array
        */
        public static function getArrayFromJsonByKey($json_string,$key)
        {
            if(isset($json_string))
            {
                $json_array = json_decode($json_string,true);

                if(array_key_exists($key,$json_array))
                {
                    return $json_array[$key];
                }
            }
            //if any mail not sent yet
            return null;
        }

        /*
            NAME    : convertArrayToString
            TYPE    : global utility function   
            DETAILS : 
            RETURN  : array value as string with specified delimiter
        */
        public static function convertArrayToString($array,$delimit=',',$arrayType='1D')
        {
            if($array)
            {
                return implode($delimit,$array);
            }
            
            return '';
        }

        /*
            NAME    : convertStringToArray
            TYPE    : global utility function   
            DETAILS : 
            RETURN  : array value as string with specified delimiter
        */
        public static function convertStringToArray($string_value,$delimit=',')
        {
            if($string_value || $string_value==="0")
            {
                return explode($delimit,$string_value);
            }
            return FALSE;
        }

        
        /*
            NAME    : addArrayByKey
            TYPE    : global utility function   
            DETAILS : 
            RETURN  : update array
        */
        public static function addArrayByKey($target_array,$key,$value_array)
        {
            
            if(is_array($target_array))
            {
                if(array_key_exists($key,$target_array))
                {
                    $target_array[$key] = $value_array; 
                }
                else
                {
                    $target_array=array($key=>$value_array);
                }
            }
            else
            {
                $target_array=array($key=>$value_array);
            }

            return $target_array;
        }

        /*
            NAME    : getArrayLast
            TYPE    : global utility function   
            DETAILS : update the array value by if available else  insert key and update value
            RETURN  : update array
        */
        public static function updateValueByKey($target_array,$key,$value,$create_if_not_available=false)
        {
            if(array_key_exists($key,$target_array))
            {
                $target_array[$key] = $value;   
            }
            else
            {
                if($create_if_not_available)
                {
                    $target_array[$key] = $value;
                }
            }

            return $target_array;
        }

        /*
            NAME    : incrementValueByKey
            TYPE    : global utility function   
            DETAILS : increment the array value by if available else  insert key and update value
            RETURN  : update array
        */
        public static function incrementValueByKey($target_array,$key,$increment_value,$create_if_not_available=false)
        {
            if(is_array($target_array) && array_key_exists($key,$target_array))
            {
                $value=$target_array[$key];
                $value+=$increment_value;
                $target_array[$key] = $value;   
            }
            else
            {
                if($create_if_not_available)
                {
                    $target_array = array();
                    $target_array[$key] = $increment_value;
                }
            }

            return $target_array;
        }

         /*
            NAME    : checkArrayWithAnyOfKeys
            TYPE    : global utility function   
            DETAILS : check a array with any of the key exsits
            RETURN  : FALSE-not matched,key value if any matched              
        */
        public static function checkArrayWithAnyOfKeys($target_array,$key_array)
        {
            if(is_array($target_array) && is_array($key_array))
            {
                $key_count = count($key_array);
                for($ky=0;$ky<$key_count;$ky++)
                {
                    if(array_key_exists($key_array[$ky],$target_array))
                    {
                       return $key_array[$ky];
                    }
                }
            }

            return FALSE;

        }

         /*
            NAME    : compareArrayKeyValue
            TYPE    : global utility function   
            DETAILS : compare array with mutiple values
            RETURN  :  0-not matched,1-value matched              
        */
        public static function compareArrayKeyValue($target_array,$key,$value)
        {
            $array_count = count($target_array);
            for($av=0;$av<$array_count;$av++)
            {
                if(array_key_exists($key,$target_array[$av]))
                {
                    if($target_array[$av][$key] == $value)
                    {
                        return array("result"=>true,"index"=>$av);
                    }
                }
            }

            return array("result"=>false,"index"=>-1); // not matched
        }

        /*
            NAME    : compareKeyValue
            TYPE    : global utility function   
            DETAILS : caheck file key and its value matched
            RETURN  :   0-not matched,1-value matched              
        */
        public static function compareKeyValue($target_array,$key,$value)
        {
            if(is_array($target_array))
            {
                if(array_key_exists($key,$target_array))
                {
                    if($target_array[$key] == $value)
                    {
                        return true;
                    }
                }
            }

            return false; // not matched
        }

        /*
            NAME    : joinArrayByDelimiter
            TYPE    : global utility function   
            DETAILS : 
            RETURN  :         
        */
        public static function joinArrayByDelimiter($source_array,$delimiter)
        {
			return join($delimiter,$source_array);
        }

        /*
            NAME    : appendIfNotFalse
            TYPE    : global utility function   
            DETAILS : 
            RETURN  :         
        */
        public static function appendIfNotFalse($source_array,$array_value)
        {
            if($array_value!==FALSE)
            {
			    array_push($source_array,$array_value);
                return $source_array;
            }

            return $source_array;
        }

        /*
            NAME    : appendIfNotZeroInLength
            TYPE    : global utility function   
            DETAILS : 
            RETURN  :         
        */
        public static function appendIfNotZeroInLength($source_array,$source_count,$array_value,$add_at_last=true)
        {
            if($source_count)
            {
                if($add_at_last)
                {
                    array_push($source_array,$array_value);
                }
                else
                {
                    array_unshift($source_array,$array_value);
                }
                return $source_array;
            }

            return $source_array;
        }

        /*
            NAME    : appendIfVaildUrlParameter
            TYPE    : global utility function   
            DETAILS : 
            RETURN  :         
        */
        public static function appendIfVaildUrlParameter($param_name,$source_array)
        {
       
            if(isset($_GET[$param_name]))
            {
                $source_array[$param_name]= $_GET[$param_name];
//echo $source_array[$param_name]= preg_replace('/[^a-zA-Z0-9_ %\[\]\.\(\)%&-+]/s', '', $_GET[$param_name]);
            }

            return $source_array;
        }

    }

?>