<?php

require_once("../TimeZone.php");

class DateUtility
{

     /*
        NAME    : convertDateFormat
        TYPE    : Utiltiy function 
        DETAILS : convert the source date to other date format
        RETURN  : convert format date        
    */
    public static function convertDateFormat($source_date,$source_format,$convert_format)
    {
        $created_date = DateTime::createFromFormat($source_format,$source_date);
        return $created_date->format($convert_format);
    }

     /*
        NAME    : getNumberOfDaysPassed
        TYPE    : Utiltiy function 
        DETAILS : get the number of days passed from start date to end date
        RETURN  : number of days count ( if start date > end date returns negative numbers of difference)      
    */
    public static function getNumberOfDaysPassed($start_date,$end_date)
    {
        //calculate date difference and days passed sofar
        $start_date_time = date_create($start_date);
        $end_date_time = date_create($end_date);
        $date_difference = date_diff($start_date_time,$end_date_time);
        $days_passed=$date_difference->format('%r%a');
        return $days_passed;
    }

    /*
        NAME    : getNumberOfMinutesPassed
        TYPE    : Utiltiy function 
        DETAILS : get the number of minutes passed from start date to end date
        RETURN  : number of days count ( if start date > end date returns negative numbers of difference)      
    */
    public static function getNumberOfMinutesPassed($start_date,$end_date)
    {
        //calculate date difference and days passed sofar
        $start_date_time = date_create($start_date);
        $end_date_time = date_create($end_date);
        $date_difference = date_diff($start_date_time,$end_date_time);
        $days_passed=$date_difference->format('%r%i');
        return $days_passed;
    }

 
    /*
        NAME    : getTotalMinutesPassed
        TYPE    : Utility function 
        DETAILS : 
        RETURN  : 
    */
    public static function getTotalMinutesPassed($start_date,$end_date)
    {
        
        $first_date = new DateTime($start_date);
        $second_date = new DateTime($end_date);
        $interval = $first_date->diff($second_date);

        $days_passed = $interval->format('%r%a');
        $hours_diff = $interval->format('%r%h');
        $minutes_diff = $interval->format('%r%i');
        $total_minutes = (($days_passed*24 + $hours_diff) * 60 + $minutes_diff);

        return $total_minutes;
    }

    
    /*
        NAME    : validateScheduledDate
        TYPE    : Internal  Utility Function
        DETAILS :  to validate the  date is in correct date format
        RETURN  : true if date is correct format else false
    */
    public static function validateScheduledDate($date, $format)
    {
        $created_date = DateTime::createFromFormat($format, $date);
        return $created_date && $created_date->format($format) === $date;
    }

     /*
        NAME    : isValidateDateFormat
        TYPE    : Internal  Utility Function
        DETAILS :  to validate the  date is in correct date format
        RETURN  : true if date is correct format else false
    */
    public static function isValidateDateFormat($date, $format)
    {
        $created_date = DateTime::createFromFormat($format, $date);
        return $created_date && $created_date->format($format) === $date;
    }

    /*
        NAME    : GetMonthPassed
        TYPE    : Internal  Utility Function
        DETAILS : calculate the month passed from specific date
        RETURN  : true if passed else false
    */
    public static function IsMonthPassed($date,$month_count)
    {
        TimeZone::useTimeZone();
        //check date member created and current date
        $datetime1 = date_create($date);
        $datetime2 = date_create(date('Y-n-j'));
        $interval = date_diff($datetime1, $datetime2);

        //year,month and days difference between date format
        $year_difference  = $interval->format('%r%y');
        $month_difference = $interval->format('%r%m');
        $days_difference  = $interval->format('%r%d');
        //echo " date difference year :".$year_difference." month : ".$month_difference." days :".$days_difference." ";
        //calculate month difference if exceeds more than 10 month
        if($year_difference>0)
        {
            return true;
        }
        else
        {
            if($month_difference>$month_count)
            {
                return true;
            }
            else
            {
                if($month_difference==$month_count)
                {
                    if($days_difference>0)
                    {
                        return true;
                    }
                }
            }
        }
        
		return false;
    }

    /*
        NAME    : getDatesBetweenBusinessDays
        TYPE    : Utiltiy function 
        DETAILS : get dates between business days
        RETURN  : array of call log dates         
    */
    public static function getDatesBetweenBusinessDays($collection_of_dates,$start_date, $end_date,$date_format) 
    { 
      
        //to store call log date between business dates 
        $dates_between_business_days_array = array();
          
        //P1D means period of 1 day 
        $one_day_interval = new DateInterval('P1D'); 
        
        //add extra one for business days to calculate between dates
        $end_business_date = new DateTime($end_date); 
        $end_business_date->add($one_day_interval); 
        //create business period to get dates in this peroid of 
        $business_period = new DatePeriod(new DateTime($start_date), $one_day_interval, $end_business_date); 
      
        // check formatted cal log dates present in between business days
        foreach($business_period as $business_date)
        {                  
            $formatted_business_date = $business_date->format($date_format); 
            if (in_array($formatted_business_date, $collection_of_dates))
            {
                $dates_between_business_days_array[] = $formatted_business_date;
            }

        } 
      
        return $dates_between_business_days_array; 
    } 

    /*
        NAME    : getDateAfterDays
        TYPE    : Utiltiy function 
        DETAILS : get the date after N number of days from specific start date
        RETURN  : date (m/d/Y) after N days        
    */
    public static function getDateAfterDays($start_date,$number_of_days,$date_format='m/d/Y')
    {
        //add extra one for business days to calculate between dates
        $after_date = new DateTime($start_date);
        $number_of_days_interval = new DateInterval('P'.$number_of_days.'D'); 
        $after_date->add($number_of_days_interval);
        return $after_date->format($date_format);
    }

    /*
        NAME    : getRecentCallLogDate
        TYPE    : global Utiltiy function 
        DETAILS : to get the recent call log date from call log array
        RETURN  :         
    */
    public static function getRecentCallLogDate($recent_call_logs,$resonse_date_format="m/d/Y H:i:s")
    {
            if($recent_call_logs && is_array($recent_call_logs))
            {
                $call_log_count = count($recent_call_logs);
                if($call_log_count>0)
                {
                    $this_call_date = $recent_call_logs[0]['date'];
                    if(self::validateScheduledDate($this_call_date,'n/j/Y @ h:i A'))
                    {
                        //log date format 01/07/2021 @ 11:48 AM
                        $formated_call_date = DateUtility::convertDateFormat($this_call_date,'n/j/Y @ h:i A',$resonse_date_format);
                        return $formated_call_date;
                    }
                }
            }

            return null;
    }

    /*
        NAME    : parseAndValidateTheTermDate
        TYPE    : Internal  Utility Function
        DETAILS : 
        RETURN  : 
    */
    public static function parseAndValidateTheTermDate($term_date_and_time)
    {
        $term_date_array=explode( 'T', $term_date_and_time );
        if(is_array($term_date_array) && count($term_date_array)>0)
        {
            $term_date = $term_date_array[0];
            $date_format ='Y-m-d';
            if(self::isValidateDateFormat($term_date,$date_format))
            {
               return $term_date;
            }
            else
            {
               return null;
            }
        }

        return null;
    }

    /*
        NAME    : parseAndConvertDelimiterDate
        TYPE    : global  Utility Function
        DETAILS : parse and covert the input date into specified output date format if middle delimiter(T,@) set 
                    between date and time 
        RETURN  : Date else FALSE
    */
    public static function parseAndConvertDelimiterDate($input_date,$output_format ='Y-m-d',$delimiter='T')
    {
        $date_time_string=self::splitAndJoinDelimiterDate($input_date,$delimiter);
        if($date_time_string)
        {
            $time_stamp = strtotime($date_time_string);
            return date($output_format,$time_stamp);
        }
        return FALSE;
    }

    /*
        NAME    : splitAndJoinDelimiterDate
        TYPE    : global  Utility Function
        DETAILS : split and join the input date into date time stamp string format if middle delimiter(T,@) present
        RETURN  : Date String else FALSE
    */
    public static function splitAndJoinDelimiterDate($input_date,$delimiter='T')
    {
        $date_array=explode($delimiter,$input_date);
        if(is_array($date_array) && count($date_array)>0)
        {
            return $date_array[0]." ".$date_array[1];
        }
        return FALSE;
    }

     /*
        NAME    : IsDateExceed
        TYPE    : Internal  Utility Function
        DETAILS : calculate the month passed from specific date
        RETURN  : true if passed else false
    */
    public static function IsDateExceed($term_date,$current_date_format='Y-m-d',$month_count=0)
    {

        //use time zone
        TimeZone::useTimeZone();
        //check date member created and current date
        $datetime1 = date_create($term_date);
        $datetime2 = date_create(date($current_date_format));
        $interval = date_diff($datetime1, $datetime2);

        //year,month and days difference between date format
        $year_difference  = $interval->format('%r%y');
        $month_difference = $interval->format('%r%m');
        $days_difference  = $interval->format('%r%d');

        //calculate month difference if exceeds more than 10 month
        if($year_difference>0)
        {
            return true;
        }
        else
        {
            if($month_difference>$month_count)
            {
                return true;
            }
            else
            {
                if($month_difference==$month_count)
                {
                    if($days_difference>0)
                    {
                        return true;
                    }
                }
            }
        }
        
		return false;
    }

}

?>