
<?php

     /*
        FILE IO OPERATION AND RELATED UTILTIY FUNCTION
    */

    require_once("../TimeZone.php");

    class FileIOUtility
    {
        //file io global constants
        const JSON_DATA_FOLDER_PREFIX = 'HRA_member_';
        const MEMBER_DATA_FOLDER_PREFIX = 'HRA_member_';

        //file saving location 
        const JSON_DATA_FOLDER_RELATIVE_PATH = '../hrajsondata/';
        const MEMBER_DATA_FOLDER_RELATIVE_PATH = '../member_data/';

        //file and folder permissions
        const DEFAULT_FOLDER_PERMISISON = 0775;
        const CLIENT_FOLDER_PERMISSION = 0775;
        const CLIENT_YEAR_FOLDER_PERMISSION = 0775;
        const DEFAULT_FILE_PERMISISON = 0664;
        const HRA_JSON_FILE_PERMISISON = 0664;

        /*
            NAME    : makeDirIfNotAvailable
            TYPE    : internal Utility function 
            DETAILS : create directory if not avaialble
            RETURN  : 
        */
		public static function makeDirIfNotAvailable($folder_path)
		{
			if(is_dir($folder_path)===FALSE)
			{
				return mkdir($folder_path,FileIOUtility::CLIENT_FOLDER_PERMISSION);
			}

			return true;
		}


        /*
            NAME    : CreateFoldersWhenClientAdded
            TYPE    : static global Utiltiy function 
            DETAILS : create required folder when new client added and when existing client's year added
        */
        public static function CreateFoldersWhenClientAdded($client_id,$year)
        {

            $is_folder_created = false;

                $is_folder_created=self::CreateHraJsonDataFolder($client_id,$year);
                $is_folder_created=self::CreateMemberDataFolder($client_id,$year);
            
            return $is_folder_created;

        }

         /*
            NAME    : CreateHraJsonDataFolder
            TYPE    : static global Utiltiy function 
            DETAILS : 
        */
        public static function CreateHraJsonDataFolder($client_id,$year)
        {
            $is_folder_created = false;
             //create hra json folder
             $hra_json_folder_path = self::JSON_DATA_FOLDER_RELATIVE_PATH.self::JSON_DATA_FOLDER_PREFIX.$client_id;
             $hra_json_client_year_folder_path = self::JSON_DATA_FOLDER_RELATIVE_PATH.self::JSON_DATA_FOLDER_PREFIX.$client_id.'/'.$year;
             $is_folder_exist = is_dir($hra_json_folder_path);
             if($is_folder_exist == 1)
             {
                 $is_year_folder_exist = is_dir($hra_json_client_year_folder_path);
                 if($is_year_folder_exist)
                 {  
                    //already created
                   
                 }
                 else
                 {
                    $client_year_folder_permission = self::CLIENT_YEAR_FOLDER_PERMISSION;
                    mkdir($hra_json_client_year_folder_path);
                    chmod($hra_json_client_year_folder_path, $client_year_folder_permission);
                    $is_folder_created = true;
                 }
             }
             else
             {
                 //if folder not avaialble create parent folder andthan relative client year folder
                 //create client folder
                $client_folder_permission = self::CLIENT_FOLDER_PERMISSION;
                mkdir($hra_json_folder_path);
                chmod($hra_json_folder_path, $client_folder_permission);

                //create year folder
                $client_year_folder_permission = self::CLIENT_YEAR_FOLDER_PERMISSION;
                mkdir($hra_json_client_year_folder_path);
                chmod($hra_json_client_year_folder_path, $client_year_folder_permission);
                $is_folder_created = true;
 
             }

             return  $is_folder_created;

        }

         /*
            NAME    : CreateMemberDataFolder
            TYPE    : static global Utiltiy function 
            DETAILS : 
        */
        public static function CreateMemberDataFolder($client_id,$year)
        {
            $is_folder_created = false;
            //create member data folder
            $member_data_folder_path = self::MEMBER_DATA_FOLDER_RELATIVE_PATH.self::MEMBER_DATA_FOLDER_PREFIX.$client_id;
            $member_data_client_year_folder_path = self::MEMBER_DATA_FOLDER_RELATIVE_PATH.self::MEMBER_DATA_FOLDER_PREFIX.$client_id.'/'.$year;

            $is_folder_exist = is_dir($member_data_folder_path);
            if($is_folder_exist == 1)
            {
                $is_year_folder_exist = is_dir($member_data_client_year_folder_path);
                if($is_year_folder_exist)
                {
                    //already created 
                }   
                else
                {
                    $folder_permission = self::CLIENT_YEAR_FOLDER_PERMISSION;
                    mkdir($member_data_client_year_folder_path);
                    chmod($member_data_client_year_folder_path, $folder_permission);
                    $is_folder_created = true;
                }
            }
            else
            {
                //create client folder
                $client_folder_permission = self::CLIENT_FOLDER_PERMISSION;
                mkdir($member_data_folder_path);
                chmod($member_data_folder_path, $client_folder_permission);

                //create year folder
                $client_year_folder_permission = self::CLIENT_YEAR_FOLDER_PERMISSION;
                mkdir($member_data_client_year_folder_path);
                chmod($member_data_client_year_folder_path, $client_year_folder_permission);
                $is_folder_created = true;
            }

            return $is_folder_created;

        }

        /*
            NAME    : CreateMemberJsonFile
            TYPE    : static global Utiltiy function 
            DETAILS : 
        */
        public static function CreateMemberJsonFile($client_id,$year,$member_id,$hra_json_file_array)
        {
            $member_id_folder_path = self::JSON_DATA_FOLDER_RELATIVE_PATH.self::JSON_DATA_FOLDER_PREFIX.$client_id.'/'.$year.'/'.$member_id;
            $is_member_id_folder = is_dir($member_id_folder_path);
            if($is_member_id_folder == 1)
            {
                //create member json file 
                $member_json_file_path = self::JSON_DATA_FOLDER_RELATIVE_PATH.self::JSON_DATA_FOLDER_PREFIX.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
                $hra_json = json_encode($hra_json_file_array);
                file_put_contents($member_json_file_path,$hra_json);
                $permit = self::HRA_JSON_FILE_PERMISISON;
                chmod($member_json_file_path, $permit);
                return true;
            }
            else
            {
                $member_id_folder_path = self::JSON_DATA_FOLDER_RELATIVE_PATH.self::JSON_DATA_FOLDER_PREFIX.$client_id.'/'.$year.'/'.$member_id;
                $permit = self::CLIENT_YEAR_FOLDER_PERMISSION;
                mkdir($member_id_folder_path);
                chmod($member_id_folder_path, $permit);
                    //create member json file 
                    $member_json_file_path = self::JSON_DATA_FOLDER_RELATIVE_PATH.self::JSON_DATA_FOLDER_PREFIX.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
                    $hra_json = json_encode($hra_json_file_array);
                    file_put_contents($member_json_file_path,$hra_json);
                    $permit = self::HRA_JSON_FILE_PERMISISON;
                    chmod($member_json_file_path, $permit);
                return true;
            }

            return false;
        }

        /*
            NAME    : getClientYearFolderPath
            TYPE    : static global Utiltiy function 
            DETAILS : 
        */
        public static function getClientYearFolderPath($client_id,$year)
        {
            $hra_json_folder_path_prefix = self::JSON_DATA_FOLDER_RELATIVE_PATH.self::JSON_DATA_FOLDER_PREFIX;
            return $hra_json_folder_path_prefix.$client_id.'/'.$year;
        }

        /*
            NAME    : getMemberJsonFolderPath
            TYPE    : static global Utiltiy function 
            DETAILS : 
        */
        public static function getMemberJsonFolderPath($client_id,$year,$member_id)
        {
            $hra_json_folder_path_prefix = self::JSON_DATA_FOLDER_RELATIVE_PATH.self::JSON_DATA_FOLDER_PREFIX;
            return $hra_json_folder_path_prefix.$client_id.'/'.$year.'/'.$member_id;
        }

        /*
            NAME    : getJsonFilePath
            TYPE    : static global Utiltiy function 
            DETAILS : 
        */
        public static function getMemberJsonFilePath($client_id,$year,$member_id)
        {
            $hra_json_folder_path_prefix = self::JSON_DATA_FOLDER_RELATIVE_PATH.self::JSON_DATA_FOLDER_PREFIX;
            return $hra_json_folder_path_prefix.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id.'.json';
        }

        /*
            NAME    : getMemberJsonFilePathWithOutExtension
            TYPE    : static global Utiltiy function 
            DETAILS : 
        */
        public static function getMemberJsonFilePathWithOutExtension($client_id,$year,$member_id)
        {
            $hra_json_folder_path_prefix = self::JSON_DATA_FOLDER_RELATIVE_PATH.self::JSON_DATA_FOLDER_PREFIX;
            return $hra_json_folder_path_prefix.$client_id.'/'.$year.'/'.$member_id.'/'.$member_id;
        }

        /*
            NAME    : getMemberJsonFileContent
            TYPE    : static global Utiltiy function 
            DETAILS : 
        */
        public static function getMemberJsonFileContent($client_id,$year,$member_id)
        {
            $member_json_file_path = self::getMemberJsonFilePath($client_id,$year,$member_id);
            return file_get_contents($member_json_file_path);
        }

        /*
            NAME    : createBackupMemberJsonFile
            TYPE    : static global Utiltiy function 
            DETAILS : 
        */
        public static function createBackupMemberJsonFile($client_id,$year,$member_id)
        {
            TimeZone::useTimeZone();
            $member_json_file_path = self::getMemberJsonFilePathWithOutExtension($client_id,$year,$member_id); 
            $member_json_file_path.='_backup.json';

            $member_json_file_content = self::getMemberJsonFileContent($client_id,$year,$member_id);
            if($member_json_file_content)
            {
                return file_put_contents($member_json_file_path,$member_json_file_content);
            }

            return false;
        }

        
        /*
            NAME    : getDemographicDetails
            TYPE    : global Utiltiy function 
            DETAILS :  
        */
        public static function getDemographicDetails($hra_file_change,$hra_file_updated_history)
        {

            $demographics_detail = $hra_file_change->getComponentChangedStatus($hra_file_updated_history,"demographic");
            $demographics_detail_value = null;
           
                if($demographics_detail && array_key_exists("value",$demographics_detail))
                {
                    if(is_array($demographics_detail["value"]) && count($demographics_detail["value"])>0)
                    {
                        //to avoid array format when return json response
                        $demographics_detail_value = $demographics_detail["value"][0];
                    }
                }
            
            return $demographics_detail_value;
        }

        /*
            NAME    : getScreeningDetails
            TYPE    : global Utiltiy function 
            DETAILS : if response type SET 0 it will give response as all screening eligibility status as array
                      else it will give all screening details as array if row and column both SET as -1,-1 respectively
                      or it will give specific screening section value as array
                    
        */
        public static function getScreeningDetails($hra_file_change,$hra_file_updated_history,$response_type,$screening_row_idx,$screening_column_idx)
        {
           
            if($response_type===0) //ELIGIBILITY AS ARRAY
            {
                $screening_elgibilty_array = null;
                $screening_detail_array = $hra_file_change->getComponentChangedStatus($hra_file_updated_history,"screening");
                if($screening_detail_array)
                {
                    if(array_key_exists("value",$screening_detail_array))
                    {
                        $screening_value_array = $screening_detail_array["value"];
                        if($screening_value_array && is_array($screening_value_array))
                        {
                            $screnning_value_count = count($screening_value_array);
                            if($screnning_value_count>0)
                            {
                                $screening_needed_array=$screening_detail_array["value"][0];
                                if($screening_needed_array && is_array($screening_needed_array))
                                {
                                    $screnning_needed_count = count($screening_needed_array);
                                    for($snc=0;$snc<$screnning_needed_count;$snc++)
                                    {
                                        $screening_elgibilty_array[]=$screening_needed_array[$snc][0];
                                    }
                                }
                            }
                        }
                    }
                }
                
                return $screening_elgibilty_array;
            }
            else
            {
                
                if($hra_file_change)
                {
                    if($screening_row_idx===-1 && $screening_column_idx===-1) //entire screening needed value as array
                    {
                        $screening_detail_array = $hra_file_change->getComponentChangedStatus($hra_file_updated_history,"screening");
                        if($screening_detail_array)
                        {
                            if(array_key_exists("value",$screening_detail_array))
                            {
                                if($screening_detail_array["value"] && is_array($screening_detail_array["value"]))
                                {
                                   return $screening_detail_array["value"][0];
                                }
                            }
                        }
                    }
                    else //only specific screening as array
                    {
                        $screening_detail_value = null;
                        
                            $screening_detail_array = $hra_file_change->getComponentChangedStatus($hra_file_updated_history,"screening");
                            if($screening_detail_array)
                            {
                                if(array_key_exists("value",$screening_detail_array))
                                {
                                    if($screening_detail_array["value"] && is_array($screening_detail_array["value"]))
                                    {
                                        if(count($screening_detail_array["value"])>0 && count($screening_detail_array["value"][$screening_row_idx])>0)
                                        {
                                            //to avoid array format when return json response
                                            $screening_detail_value = $screening_detail_array["value"][$screening_row_idx][$screening_column_idx];
                                        }
                                    }
                                }
                            }
                        
                        return $screening_detail_value;
                    }
                }
            }

            return null;
        }
         
        /*
            NAME    : getListOfJsonFiles
            TYPE    : global Utiltiy function 
            DETAILS :  
        */
        public static function getListOfJsonFiles($folder_path)
        {
            //$json_file_list = scandir($folder_path);
            $json_file_list = glob($folder_path.'/*.json');
            return $json_file_list;
        }

        public static function SftplogFilePath($log_path,$date,$plan_id,$log_file){
            if(!file_exists("$log_path/$date")){
		        mkdir("$log_path/$date",0777,true);
	        }

	        if(!file_exists("$log_path/$date/$plan_id")){
		        mkdir("$log_path/$date/$plan_id",0777,true);
	        }
        }

        public static function SftpExcelUploadFolder($date, $plan_id, $fileName){
            if(!file_exists("../ftp_uploads")){
                mkdir("..ftp_uploads",0777,true);
        
            }
            if(!file_exists("../ftp_uploads/$date")){
                mkdir("../ftp_uploads/$date",0777,true);
        
            }      
            if(!file_exists("../ftp_uploads/$date/$plan_id")){
                mkdir("../ftp_uploads/$date/$plan_id",0777,true);
        
            }
        }

    }

?>