<?php

    /*
        AUTHOR     : FocusCare
        CLASS      : FtpUtility
        DESC       : ftp related functionality           
        CREATED ON : 10-13-2021
    */

    require_once("../utility/DataBaseUtility.php");
    require_once("../utility/SftpUtility.php");
    require_once("../config/Config.php");
   
    use Config\FtpGoAnywhereConfig;

    class FtpUtility
    {
        
        
        /*
            NAME    : uploadToGoAnyWhere
            TYPE    : global Utility function 
            DETAILS : its based on SFTP nor FTP.To upload file into go any where server basd on the client
            RETURN  : return upload status
        */
        public static function uploadToGoAnyWhere($client_id,$local_file_path,$file_name)
        {
            $client_name = DataBaseUtility::getClientName($client_id);
            $upload_status = array("uploadStatus"=>"failed");
            switch($client_name)
            {
                case 'Virginia Premier':
                case 'Medicare':
                case 'Exchange':
                case 'Medicaid':
                    //VPHP ftp upload
                    $sftp_utility = new SftpUtility;
                    $sftp_connection=$sftp_utility->connect(FtpGoAnywhereConfig::VPHP_FTP_HOST_NAME,
                                                             FtpGoAnywhereConfig::VPHP_USERNAME,
                                                             FtpGoAnywhereConfig::VPHP_PASSWORD);
                    if($sftp_connection)
                    {
                       $remote_file_path=FtpGoAnywhereConfig::VPHP_REMOTE_PATH.$file_name;
                       $upload_status=$sftp_utility->uploadFile($sftp_connection,$local_file_path,$remote_file_path);
                    }
                break;

                case 'Optima':
                    //Optima ftp upload
                    $sftp_utility = new SftpUtility;
                    $sftp_connection=$sftp_utility->connect(FtpGoAnywhereConfig::OPTIMA_FTP_HOST_NAME,
                                                            FtpGoAnywhereConfig::OPTIMA_USERNAME,
                                                            FtpGoAnywhereConfig::OPTIMA_PASSWORD);
                    if($sftp_connection) 
                    {
                        $remote_file_path=FtpGoAnywhereConfig::OPTIMA_REMOTE_PATH.$file_name;
                        $upload_status=$sftp_utility->uploadFile($sftp_connection,$local_file_path,$remote_file_path);
                    }
                break;

            }

            return $upload_status;
        }

        /*
            NAME    : connect
            TYPE    : Utility function 
            DETAILS : 
            RETURN  : 
        */
        public function connect($ftp_host_name,$ftp_username,$ftp_user_password)
        {
            
            $ftp_connection = ftp_connect($ftp_host_name);
            if($ftp_connection)
            {
                $ftp_login_details = ftp_login($ftp_connection,$ftp_username,$ftp_user_password);
                if($ftp_login_details)
                {
                    return array("connection"=>$ftp_connection,"login"=>$ftp_login_details);
                }
            }
            return array("connection"=>$ftp_connection,"login"=>null);
        }

        /*
            NAME    : uploadFile
            TYPE    : Utility function 
            DETAILS : 
            RETURN  : 
        */
        public function uploadFile($ftp_connection,$local_file_path,$remote_file_path,$ftp_mode=FTP_BINARY)
        {
            if($ftp_connection)
            {
                if(file_exists($local_file_path))
                {
                    if(ftp_put($ftp_connection,$remote_file_path,$local_file_path,$ftp_mode))
                    {
                        return array("uploadStatus"=>"success");
                    }
                    else
                    {
                        return array("uploadStatus"=>"failed");
                    }
                    
                }
            }

            return array("uploadStatus"=>"failed");
        }

         /*
            NAME    : uploadFile
            TYPE    : Utility function 
            DETAILS : 
            RETURN  : 
        */
        public function disConnect($ftp_connection)
        {
            if($ftp_connection)
            {
                ftp_close($ftp_connection);
            }
        }

        

    }

?>