<?php

/*
	CLASS : HRA STATUS UTILTIY
	CREATED ON : 21-06-2021
*/

require_once("../member/MemberUtility.php");
require_once("../utility/DataBaseUtility.php");

class HraStatusUtility 
{
		/*
			NAME    : hraJsonToStauts
			TYPE    : Internal Utility Function
			DETAILS : 
			RETURN  : 
       */
        public static function hraJsonToStauts($hra_status_json)
        {
            $hra_status_array = json_decode($hra_status_json["hraStatus"],true);

            if($hra_status_array && is_array($hra_status_array))
            {
                if(array_key_exists('hraStatus',$hra_status_array))
                {
                    return $hra_status_array['hraStatus'];
                }

            }

            return self::UNSCHEDULED;
        }

		/*
			NAME    : getHraStatusHistoryArrayBy
			TYPE    : global Utility Function
			DETAILS : get hra histroy by hra status
			RETURN  : 
       */
		public static function getHraStatusHistoryArrayBy($client_id,$year,$member_id,$hra_status)
		{
			$member_field_array = DataBaseUtility::getMemberDataBaseFields($client_id,$year,$member_id,['hraStatusHistory']);
			$hra_status_history_array = json_decode($member_field_array['hraStatusHistory'],true);
			if($hra_status_history_array  && is_array($hra_status_history_array))
			{
				switch ( $hra_status )
				{	
						case MemberUtility::SCHEDULED:
							return $hra_status_history_array['scheduled'];
						break;

						case MemberUtility::IN_PROGRESS:
							return $hra_status_history_array['inProgress'];
						break;

						case MemberUtility::APPOINTMENT_CANCELLED:
							return $hra_status_history_array['appointmentCancelled'];
						break;

						case MemberUtility::PATIENT_REFUSAL:
							return $hra_status_history_array['patientRefusal'];
						break;

						case MemberUtility::UTC: 
							return $hra_status_history_array['utc'];
						break;

						case MemberUtility::READY_FOR_QA:
							return $hra_status_history_array['readyForQa'];
						break;

						case MemberUtility::READY_FOR_CODER:
							return $hra_status_history_array['readyForCoder'];
						break;

						case MemberUtility::CLINICIAN_REVIEW_QA:
							return $hra_status_history_array['clinicianReviewQa'];
						break;

						case MemberUtility::CLINICAIN_REVIEW_CODER:
							return $hra_status_history_array['clinicianReviewCoder'];
						break;

						case MemberUtility::READY_FOR_UPLOAD:
							return $hra_status_history_array['readyForUpload'];
						break;

						case MemberUtility::COMPLETED:
							return $hra_status_history_array['completed'];
						break;

						case MemberUtility::ASSESSMENT_CANCELLED:
							return $hra_status_history_array['assessmentCalcelled'];
						break;

						case MemberUtility::PRE_SCHEDULED:
							return $hra_status_history_array['preScheduled'];
						break;

						case MemberUtility::IN_ELIGIBILE:
							return $hra_status_history_array['inEligibile'];
						break;
							
						case MemberUtility::DECEASED:
							return $hra_status_history_array['deceased'];
						break;
							
						case MemberUtility::HOSPICE:
							return $hra_status_history_array['hospice'];
						break;
							
						case MemberUtility::OTHER:
							return $hra_status_history_array['other'];
						break;
							
						case MemberUtility::TERM_EXPIRED:
							return $hra_status_history_array['termExpired'];
						break;

						case MemberUtility::NO_SHOW:
							return $hra_status_history_array['noShow'];
						break;
						
						//non hra status number 
						case MemberUtility::QA_ASSIGNED: //qaAssigned
							return $hra_status_history_array['qaAssigned'];
						break;

						case MemberUtility::CODER_ASSIGNED://coderAssigned
							return $hra_status_history_array['coderAssigned'];
						break;
				}
			}

			return FALSE;
		}

		/*
			NAME    : getHraStatusHistoryArrayBy
			TYPE    : global Utility Function
			DETAILS : get hra histroy by hra status
			RETURN  : 
       */
		public static function getCurrentHraStatusHistoryDate($client_id,$year,$member_id,$hra_status)
		{
			$specific_history_array=self::getHraStatusHistoryArrayBy($client_id,$year,$member_id,$hra_status);

			if($specific_history_array && is_array($specific_history_array))
			{
				$current_hra_status_history = end($specific_history_array);
				if(array_key_exists('date',$current_hra_status_history))
				{
					return $current_hra_status_history['date'];
				}	 
			}

			return FALSE;
		}

		/*
			NAME    : hraStatusToString
			TYPE    : Internal  Utility Function
			DETAILS : 
			RETURN  : 
    	*/
        public static function hraStatusToString($hra_status)
        {
            switch ( $hra_status )
			{	
                case MemberUtility::UNSCHEDULED:
					return 'unScheduled';
				break;

				case MemberUtility::SCHEDULED:
					return 'scheduled';
				break;

				case MemberUtility::IN_PROGRESS:
					return 'inProgress';
				break;

				case MemberUtility::APPOINTMENT_CANCELLED:
					return 'appointmentCancelled';
				break;

				case MemberUtility::PATIENT_REFUSAL:
					return 'patientRefusal';
				break;

				case MemberUtility::UTC: 
					return 'utc';
				break;

				case MemberUtility::READY_FOR_QA:
					return 'readyForQa';
				break;

				case MemberUtility::READY_FOR_CODER:
					return 'readyForCoder';
				break;

				case MemberUtility::CLINICIAN_REVIEW_QA:
					return 'clinicianReviewQa';
				break;

				case MemberUtility::CLINICAIN_REVIEW_CODER:
					return 'clinicianReviewCoder';
				break;

				case MemberUtility::READY_FOR_UPLOAD:
					return 'readyForUpload';
				break;

				case MemberUtility::COMPLETED:
					return 'completed';
				break;

				case MemberUtility::ASSESSMENT_CANCELLED:
					return 'assessmentCalcelled';
				break;

                case MemberUtility::PRE_SCHEDULED:
					return 'preScheduled';
				break;

				case MemberUtility::IN_ELIGIBILE:
					return 'inEligibile';
				break;
						
				case MemberUtility::DECEASED:
					return 'deceased';
				break;
						
				case MemberUtility::HOSPICE:
					return 'hospice';
				break;
						
				case MemberUtility::OTHER:
					return 'other';
				break;
						
				case MemberUtility::TERM_EXPIRED:
					return 'termExpired';
				break;

				case MemberUtility::NO_SHOW:
					return 'noShow';
				break;

                case MemberUtility::HRA_NOT_DUE:
					return 'notDue';
				break;
						
				//non hra status number 
				case MemberUtility::QA_ASSIGNED: //qaAssigned
					return 'qaAssigned';
				break;

				case MemberUtility::CODER_ASSIGNED://coderAssigned
					return 'coderAssigned';
				break;
			}
        }
}

?>