<?php

require_once ("../packages/php-jwt/src/BeforeValidException.php");
require_once ("../packages/php-jwt/src/ExpiredException.php");
require_once ("../packages/php-jwt/src/SignatureInvalidException.php");
require_once ("../packages/php-jwt/src/JWT.php");
require_once ("../utility/Utility.php");
require_once ("../TimeZone.php");

use \Firebase\JWT\JWT;

error_reporting(0);

class JwtUtility
{
    //global constant
    const OPTION_REQUEST_METHOD=0;
    const VALID_TOKEN =1;
    const TOKEN_EXPIRED=2;
    const INVALID_TOKEN=3;

    //internal private constants
    private const EXPIRED_MINUTES_FORMAT ='+720 minutes';//12 hours
    private const SECRET_KEY = "eyJSb2xlIjoiQWRtaW4iLCJJc3N1ZXIiOiJJc3N1ZXIiLCJVc2VybmFtZSI6I";
    private const SERVER_NAME = "https://hra.focuscare.com";

     /*
        NAME    : generateToken
        TYPE    : Utility function 
        DETAILS : 
        RETURN  : 
    */
    public function generateToken($user_data)
    {   
        //token issued time
        TimeZone::useTimeZone();
        $issued_at   = new DateTimeImmutable();
        $expire     = $issued_at->modify(self::EXPIRED_MINUTES_FORMAT)->getTimestamp();

        $token_payload = array(
            "iss" => self::SERVER_NAME,
            "iat" => $issued_at->getTimestamp(),
            "nbf" => $issued_at->getTimestamp(),
            "exp" => $expire,
            "customData" => array(
                "username" => $user_data["username"],
                "role" => $user_data["role"]
                ));

        return JWT::encode($token_payload, self::SECRET_KEY,'HS256');

    }

    /*
        NAME    : isValidToken
        TYPE    : Utility function 
        DETAILS : 
        RETURN  : 
    */
    public static function isValidToken()
    {   
        $request_method = $_SERVER['REQUEST_METHOD'];
        if($request_method=='OPTIONS')
        {
            return self::OPTION_REQUEST_METHOD;
        }

        //return self::VALID_TOKEN;

        $jwt_utility = new JwtUtility;
        $custom_header=$jwt_utility->parseHeader();
        return $jwt_utility->validateToken($custom_header["jwt_token"],$custom_header["customData"]);
    }

    /*
        NAME    : exitWithUnAuthorizedResponse
        TYPE    : Utility function 
        DETAILS : 
        RETURN  : 
    */
    public static function exitWithUnAuthorizedResponse($token_validation_result)
    {
        if($token_validation_result==self::OPTION_REQUEST_METHOD)
        {
            //valid request access 
            //option based preflight state check
            http_response_code(200);

            echo json_encode(array(
                "authentication" => false,
                "message" => "preflight success",
            ));
            
            exit;
        }
        else
        {
            //un authorized access 
            http_response_code(401);
            
            echo json_encode(array(
                "authentication" => false,
                "message" => "Access denied.",
                "errorCode" => $token_validation_result
            ));

            exit;
        }

    }

    /*
        NAME    : validateToken
        TYPE    : Utility function 
        DETAILS : 
        RETURN  : 
    */
    public function validateToken($jwt_token,$user_data)
    {
        
        try
        {
            $decoded_token_array = JWT::decode($jwt_token,self::SECRET_KEY, array('HS256'));
            if(isset($decoded_token_array->customData))
            {
                $user_name = $user_data["username"];
                $user_role = $user_data["role"];
                $custom_user_data = $decoded_token_array->customData;
                if($custom_user_data->username==$user_name && $custom_user_data->role==$user_role)
                {
                    return self::VALID_TOKEN;
                }
            }
        }
        catch (Exception $e){

            if($e->getMessage() == "Expired token")
            {
                return self::TOKEN_EXPIRED;
            }
            else
            {
                return self::INVALID_TOKEN;
            }
        }

        return self::INVALID_TOKEN;
    }

    /*
        NAME    : parseHeader
        TYPE    : Utility function 
        DETAILS : 
        RETURN  : 
    */
    public function parseHeader()
    {
    
        $auth_header = $_SERVER['HTTP_AUTHORIZATION'];
        $hra_user_data_header = $_SERVER['HTTP_HRAUSERDATA'];
        //split the autho token
        $header_split_array = explode(" ", $auth_header);
        $jwt_token = $header_split_array[1];
        //split the user custom data
        $hra_user_data_array = explode(",", $hra_user_data_header);
        $user_name = $hra_user_data_array[0];
        $user_type = $hra_user_data_array[1];
        
        return array("jwt_token"=>$jwt_token,"customData"=>array("username"=>$user_name,"role"=>$user_type));
    }

}

?>